/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.qualidade;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioNaoConformidade
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_SETOR = "filtroSetor";
    private final String FILTRO_USUARIO_ENVOLVIDO = "filtroUsuarioEnvolvido";
    private final String FILTRO_USUARIO_CRIACAO = "filtroUsuarioCriacao";
    private final String FILTRO_ORIGEM = "filtroOrigem";
    private final String FILTRO_PROCEDENCIA = "filtroProcedencia";
    private final String FILTRO_SITUACAO = "filtroSituacao";
    private final String FILTRO_TIPO_NAO_CONFORMIDADE = "filtroTipoNaoConformidade";
    private static long MODULO_ACESSO = Long.parseLong("0890000200");
    private static long MODULO_CONFIGURAR = Long.parseLong("0890000201");
    private String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoNaoConformidade", "dataNaoConformidade", "dataHoraNaoConformidade", "codigoProcedencia", "descricaoNaoConformidade", "urgente", "usuarioConclusao", "usuarioAnalise", "usuarioRegistro", "analiseNaoConformidade", "conclusaoNaoConformidade", "dataConclusaoNaoConformidade", "situacaoNaoConformidade", "dataAnaliseNaoConformidade", "dataHoraConclusaoNaoConformidade", "dataHoraAnaliseNaoConformidade", "tipoConclusaoNaoConformidade", "codigoNaoConformidade", "identificadorConclusao", "descricaoProcedencia", "criticasSetores", "usuarioResponsavelSetor", "codigosSetores", "descricoesSetores", "siglasSetores", "codigosUsuariosEnvolvidosSetores", "nomesUsuariosEnvolvidosSetores", "codigosAcaoNaoConformidade", "descricoesAcaoNaoConformidade", "analisesAcaoNaoConformidade", "codigosProcedenciaNaoConformidade", "descricoesProcedenciaNaoConformidade", "codigoUsuarioNaoConformidade", "nomeUsuarioNaoConformidade", "codigoOrigemNaoConformidade", "descricaoOrigemNaoConformidade", "tipoNaoConformidade", "codigoTipoNaoConformidade"});

    public RelatorioNaoConformidade() {
        this.montaBarraDescricao("N\u00e3o conformidade", "Listagem das n\u00e3o conformidades", "relatorios/rel_qc_nc_rel_naoconformidade.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroSetor", "Setor", "setores", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroUsuarioEnvolvido", "Usu\u00e1rio envolvido", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroUsuarioCriacao", "Usu\u00e1rio cria\u00e7\u00e3o", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroOrigem", "Origem", "origemnaoconformidade", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"onc_codigo", "onc_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroProcedencia", "Proced\u00eancia", "procedencianaoconformidade", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"pnc_codigo", "pnc_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroTipoNaoConformidade", "Tipo", "tiponaoconformidade", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"tcf_codigo", "tcf_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroSituacao", "Situa\u00e7\u00e3o", Tipos.getTiposSitucaoNaoConformidade(), new String[]{"Descri\u00e7\u00e3o"});
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.setModuloConfigurar(RelatorioNaoConformidade.getModuloConfigurar());
        this.setModuloAcesso(RelatorioNaoConformidade.getModuloAcesso());
        this.setCamposConfigurador(this.campos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement statement;
        block12: {
            this.setCursor(Cursor.getPredefinedCursor(3));
            statement = Conexao.getStatement();
            try {
                String sql = this.getSql();
                ModeloGridTable modeloImpressao = new ModeloGridTable(this.campos);
                ResultSet rsDados = Conexao.executeQuery(statement, sql);
                if (rsDados.next()) {
                    do {
                        Object[] o = new Object[this.campos.length];
                        for (int i = 0; i < this.campos.length; ++i) {
                            o[i] = this.campos[i].equalsIgnoreCase("situacaoNaoConformidade") ? Tipos.tipoSituacaoNaoConformidade(rsDados.getString(this.campos[i])) : rsDados.getObject(this.campos[i]);
                        }
                        modeloImpressao.addLine(o);
                    } while (rsDados.next());
                }
                if (modeloImpressao.getRowCount() > 0) {
                    StringBuilder sqlRel = new StringBuilder();
                    sqlRel.append("select rel_xml from relatoriosistema where rel_codigo = ").append(this.getModuloAcesso());
                    ResultSet rsLayout = Conexao.executeQuery(statement, sqlRel.toString());
                    if (rsLayout.next()) {
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        StringBuilder p = new StringBuilder();
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put("filtroSetor", this.getSelecionadosFiltroValores("filtroSetor", 0, false, false));
                        var.put("filtroUsuarioEnvolvido", this.getSelecionadosFiltroValores("filtroUsuarioEnvolvido", 0, false, false));
                        var.put("filtroUsuarioCriacao", this.getSelecionadosFiltroValores("filtroUsuarioCriacao", 0, false, false));
                        var.put("filtroOrigem", this.getSelecionadosFiltroValores("filtroOrigem", 0, false, false));
                        var.put("filtroProcedencia", this.getSelecionadosFiltroValores("filtroProcedencia", 0, false, false));
                        var.put("filtroTipoNaoConformidade", this.getSelecionadosFiltroValores("filtroTipoNaoConformidade", 0, false, false));
                        var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                        var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                        String[] situacao = this.getSelecionadosFiltroArray("filtroSituacao");
                        p.delete(0, p.length());
                        if (situacao != null) {
                            for (int i = 0; i < situacao.length; ++i) {
                                p.append(situacao[i]);
                                if (i >= situacao.length - 1) continue;
                                p.append(", ");
                            }
                        }
                        var.put("filtroSituacao", p.toString());
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(0.5f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioNaoConformidade.this.panelCentro.removeAll();
                                RelatorioNaoConformidade.this.panelCentro.repaint();
                                RelatorioNaoConformidade.this.habilitaBotaoImprimir(true);
                            }
                        });
                        gerador.executar(rsLayout.getString("rel_xml"), (TableModel)modeloImpressao, var);
                        this.panelCentro.revalidate();
                    } else {
                        Funcoes.mensagem(this.getTopLevelAncestor(), "Relat\u00f3rio n\u00e3o possui layout.", 2);
                        this.habilitaBotaoImprimir(true);
                    }
                    break block12;
                }
                Funcoes.mensagem(this.getTopLevelAncestor(), "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel gerar o relat\u00f3rio de n\u00e3o conformidade.\n" + e.getMessage(), e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(statement);
                    this.setCursor(Cursor.getDefaultCursor());
                    throw throwable;
                }
                Conexao.fecharStatement(statement);
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
        Conexao.fecharStatement(statement);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private String getSql() {
        StringBuilder sql = new StringBuilder();
        sql.append(this.getCamposSql());
        sql.append(this.getJoinSql());
        sql.append(this.getWhereSql());
        sql.append(this.getGroupBySql());
        sql.append(this.getOrderBySql());
        return sql.toString();
    }

    private String getCamposSql() {
        StringBuilder buf = new StringBuilder();
        buf.append(" SELECT a.nac_codigo as codigoNaoConformidade ");
        buf.append("       ,a.nac_data as dataNaoConformidade ");
        buf.append("       ,a.nac_datahora as dataHoraNaoConformidade ");
        buf.append("       ,a.pnc_codigo as codigoProcedencia ");
        buf.append("       ,a.nac_registro as descricaoNaoConformidade ");
        buf.append("       ,(case when a.nac_urgente is true then 'Sim' else 'N\u00e3o' end) as urgente ");
        buf.append("       ,a.usr_codconclusao as usuarioConclusao ");
        buf.append("       ,a.usr_codanalise as usuarioAnalise ");
        buf.append("       ,a.usr_codregistro as usuarioRegistro ");
        buf.append("       ,a.nac_analise as analiseNaoConformidade ");
        buf.append("       ,a.nac_conclusao as conclusaoNaoConformidade ");
        buf.append("       ,a.nac_dataconclusao as dataConclusaoNaoConformidade ");
        buf.append("       ,a.nac_situacao as situacaoNaoConformidade ");
        buf.append("       ,a.nac_dataanalise as dataAnaliseNaoConformidade ");
        buf.append("       ,a.nac_datahoraconclusao as dataHoraConclusaoNaoConformidade ");
        buf.append("       ,a.nac_datahoraanalise as dataHoraAnaliseNaoConformidade ");
        buf.append("       ,a.nac_tipoconclusao as tipoConclusaoNaoConformidade ");
        buf.append("       ,a.nac_codigo as codigoNaoConformidade ");
        buf.append("       ,a.nac_identificadorconclusao as identificadorConclusao ");
        buf.append("       ,a.nac_descricaoprocedencia descricaoProcedencia ");
        buf.append("       ,array_to_string(array_agg(distinct snc.sna_critica), ',') as criticasSetores ");
        buf.append("       ,array_to_string(array_agg(distinct snc.usr_codresponsavelsetor), ',') as usuarioResponsavelSetor ");
        buf.append("       ,array_to_string(array_agg(distinct set.set_codigo), ',') as codigosSetores ");
        buf.append("       ,array_to_string(array_agg(distinct set.set_descricao), ',') as descricoesSetores ");
        buf.append("       ,array_to_string(array_agg(distinct set.set_sigla), ',') as siglasSetores ");
        buf.append("       ,array_to_string(array_agg(distinct usrEnv.usr_codigo), ',') as codigosUsuariosEnvolvidosSetores ");
        buf.append("       ,array_to_string(array_agg(distinct usrEnv.usr_nome), ',') as nomesUsuariosEnvolvidosSetores ");
        buf.append("       ,array_to_string(array_agg(distinct anc.anc_codigo), ',') as codigosAcaoNaoConformidade ");
        buf.append("       ,array_to_string(array_agg(distinct anc.acn_descricaoacao), ',') as descricoesAcaoNaoConformidade ");
        buf.append("       ,array_to_string(array_agg(distinct anc.acn_analise), ',') as analisesAcaoNaoConformidade ");
        buf.append("       ,array_to_string(array_agg(distinct pnc.pnc_codigo), ',') as codigosProcedenciaNaoConformidade ");
        buf.append("       ,array_to_string(array_agg(distinct pnc.pnc_descricao), ',') as descricoesProcedenciaNaoConformidade ");
        buf.append("       ,usrCriou.usr_codigo as codigoUsuarioNaoConformidade ");
        buf.append("       ,usrCriou.usr_nome as nomeUsuarioNaoConformidade ");
        buf.append("       ,onc.onc_codigo as codigoOrigemNaoConformidade ");
        buf.append("       ,onc.onc_descricao as descricaoOrigemNaoConformidade ");
        buf.append("       ,tn.tcf_descricao as tipoNaoConformidade ");
        buf.append("       ,tn.tcf_codigo as codigoTipoNaoConformidade ");
        buf.append(" ,").append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
        return buf.toString();
    }

    private String getJoinSql() {
        StringBuilder buf = new StringBuilder();
        buf.append(" FROM naoconformidade a ");
        buf.append(" LEFT JOIN setoresnaoconformidade snc on a.fil_codigo = snc.fil_codigo and a.nac_codigo = snc.nac_codigo ");
        buf.append(" LEFT JOIN setores set on snc.fil_codigo = set.fil_codigo and snc.set_codigo = set.set_codigo ");
        buf.append(" LEFT JOIN setoresnaoconformidadeusuario snu on a.fil_codigo = snu.fil_codigo and a.nac_codigo = snu.nac_codigo and snc.sna_codigo = snu.sna_codigo ");
        buf.append(" LEFT JOIN usuario usrEnv on snu.fil_codigo = usrEnv.fil_codigo and snu.usr_codigo = usrEnv.usr_codigo ");
        buf.append(" LEFT JOIN acoesnaoconformidade anc on a.fil_codigo = anc.fil_codigo and a.nac_codigo = anc.nac_codigo ");
        buf.append(" LEFT JOIN procedencianaoconformidade pnc on a.fil_codigo = pnc.fil_codigo and a.pnc_codigo = pnc.pnc_codigo ");
        buf.append(" LEFT JOIN usuario usrCriou on a.fil_codigo = usrCriou.fil_codigo and a.usr_codigo = usrCriou.usr_codigo ");
        buf.append(" LEFT JOIN origemnaoconformidade onc on a.fil_codigo = onc.fil_codigo and a.onc_codigo = onc.onc_codigo ");
        buf.append(" LEFT JOIN tiponaoconformidade tn on a.fil_codigo = tn.fil_codigo and a.tcf_codigo = tn.tcf_codigo ");
        buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
        return buf.toString();
    }

    private String getWhereSql() {
        String[] situacoes;
        String[] tipos;
        String[] procedencias;
        String[] origens;
        String[] usuariosCriacao;
        String[] usuariosEnvolvidos;
        StringBuilder buf = new StringBuilder();
        buf.append(" WHERE a.fil_codigo = ").append(Variaveis.filialPadrao);
        String[] setores = this.getSelecionadosFiltro("filtroSetor", 0);
        if (setores != null && setores.length > 0) {
            StringBuilder aux = new StringBuilder();
            aux.append(" AND (SELECT count(1) ");
            aux.append("        FROM setoresnaoconformidade snc1 ");
            aux.append("       WHERE snc1.fil_codigo = ").append(Variaveis.filialPadrao);
            aux.append("         AND snc1.nac_codigo = a.nac_codigo ");
            aux.append("         AND snc1.set_codigo IN (");
            aux.append(this.getSelecionadosFiltroValores("filtroSetor", 0, false, false));
            aux.append(" )) > 0 ");
            buf.append(aux.toString());
        }
        if ((usuariosEnvolvidos = this.getSelecionadosFiltro("filtroUsuarioEnvolvido", 0)) != null && usuariosEnvolvidos.length > 0) {
            StringBuilder aux = new StringBuilder();
            aux.append(" AND (SELECT count(1) ");
            aux.append("        FROM setoresnaoconformidade snc1 ");
            aux.append("        JOIN setoresnaoconformidadeusuario snu1 on snc1.fil_codigo = snu1.fil_codigo and snc1.nac_codigo = snu1.nac_codigo and snc1.sna_codigo = snu1.sna_codigo");
            aux.append("       WHERE snc1.fil_codigo = ").append(Variaveis.filialPadrao);
            aux.append("         AND snc1.nac_codigo = a.nac_codigo ");
            aux.append("         AND snu1.usr_codigo IN (");
            aux.append(this.getSelecionadosFiltroValores("filtroUsuarioEnvolvido", 0, false, true));
            aux.append(" )) > 0 ");
            buf.append(aux.toString());
        }
        if ((usuariosCriacao = this.getSelecionadosFiltro("filtroUsuarioCriacao", 0)) != null && usuariosCriacao.length > 0) {
            this.getSelecionadosFiltroValoresConcat("filtroUsuarioCriacao", 0, buf, " AND a.usr_codigo IN ", false, true);
        }
        if ((origens = this.getSelecionadosFiltro("filtroOrigem", 0)) != null && origens.length > 0) {
            this.getSelecionadosFiltroValoresConcat("filtroOrigem", 0, buf, " AND a.onc_codigo IN ", false, false);
        }
        if ((procedencias = this.getSelecionadosFiltro("filtroProcedencia", 0)) != null && procedencias.length > 0) {
            this.getSelecionadosFiltroValoresConcat("filtroProcedencia", 0, buf, " AND a.pnc_codigo IN ", false, false);
        }
        if ((tipos = this.getSelecionadosFiltro("filtroTipoNaoConformidade", 0)) != null && tipos.length > 0) {
            this.getSelecionadosFiltroValoresConcat("filtroTipoNaoConformidade", 0, buf, " AND a.tcf_codigo IN ", false, false);
        }
        if ((situacoes = this.getSelecionadosFiltroArray("filtroSituacao")) != null) {
            buf.append(" and a.nac_situacao in (");
            for (int i = 0; i < situacoes.length; ++i) {
                buf.append("'");
                String situacao = Tipos.getCodigoTipoSituacaoNaoConformidade(situacoes[i]);
                buf.append(situacao);
                buf.append("'");
                if (i >= situacoes.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (!Funcoes.textoVazio(this.getFiltroData("filtroDataInicial"))) {
            buf.append(" AND cast(a.nac_datahora as date) >= '").append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial"))).append("' ");
        }
        if (!Funcoes.textoVazio(this.getFiltroData("filtroDataFinal"))) {
            buf.append(" AND cast(a.nac_datahora as date) <= '").append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataFinal"))).append("' ");
        }
        return buf.toString();
    }

    private String getGroupBySql() {
        StringBuilder buf = new StringBuilder();
        buf.append(" GROUP BY a.nac_codigo ");
        buf.append(" ,a.nac_data ");
        buf.append(" ,a.nac_datahora ");
        buf.append(" ,usrCriou.usr_codigo ");
        buf.append(" ,usrCriou.usr_nome ");
        buf.append(" ,a.pnc_codigo ");
        buf.append(" ,pnc.pnc_descricao ");
        buf.append(" ,a.nac_registro ");
        buf.append(" ,a.nac_urgente ");
        buf.append(" ,a.usr_codconclusao ");
        buf.append(" ,a.usr_codanalise ");
        buf.append(" ,a.usr_codregistro ");
        buf.append(" ,a.nac_analise ");
        buf.append(" ,a.nac_conclusao ");
        buf.append(" ,a.nac_dataconclusao ");
        buf.append(" ,a.nac_situacao ");
        buf.append(" ,a.nac_dataanalise ");
        buf.append(" ,a.nac_datahoraconclusao ");
        buf.append(" ,a.nac_datahoraanalise ");
        buf.append(" ,a.nac_tipoconclusao ");
        buf.append(" ,a.nac_identificadorconclusao ");
        buf.append(" ,a.nac_descricaoprocedencia ");
        buf.append(" ,a.nac_codigo ");
        buf.append(" ,onc.onc_codigo ");
        buf.append(" ,onc.onc_descricao, tn.tcf_descricao,\ttn.tcf_codigo  ");
        buf.append(" ,").append("filial.fil_codigo, filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, filial.fil_complemento, filial.fil_cep, filial.fil_fone, filial.fil_fax, filial.fil_razaosocial, filial.fil_cnes, cidadefilial.cid_codigo, cidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo, bairrofilial.bai_descricao ");
        return buf.toString();
    }

    private String getOrderBySql() {
        return " ORDER BY codigoNaoConformidade, codigosSetores, codigosAcaoNaoConformidade, codigosProcedenciaNaoConformidade ";
    }

    public static long getModuloAcesso() {
        return MODULO_ACESSO;
    }

    public static long getModuloConfigurar() {
        return MODULO_CONFIGURAR;
    }
}

