/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.qualidade;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.model.vo.cadastro.NaoConformidadeVO;
import jalis.relatorio.Gerador;
import jalis.service.cadastro.NaoConformidadeService;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.SplashMensagem;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class ImprimirNaoConformidade
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private static final String FILTRO_NCF = "filtroNcf";
    private static final String FILTRO_CRITICA_SETOR = "filtroSetorCritica";
    private String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoNaoConformidade", "dataNaoConformidade", "fantasiaConvenio", "dataLeitura", "dataHoraNaoConformidade", "usuarioNaoConformidade", "codigoProcedencia", "nomeProcedencia", "codigoRequisicao", "codigoConvenio", "codigoPaciente", "crmMedico", "nomeMedico", "razaoSocialConvenio", "dataRequisicao", "nomePaciente", "codigoSetor", "descricaoSetor", "usuarioResponsavelSetor", "usuarioNotificado", "descricaoNaoConformidade", "urgente", "usuarioConclusao", "usuarioAnalise", "usuarioRegistro", "analiseNaoConformidade", "conclusaoNaoConformidade", "dataConclusaoNaoConformidade", "situacaoNaoConformidade", "dataAnaliseNaoConformidade", "dataHoraConclusaoNaoConformidade", "dataHoraAnaliseNaoConformidade", "tipoConclusaoNaoConformidade", "descricaoAnaliseAcaoNaoConformidade", "tipoSetorNaoConformidade", "codigoAcaoNaoConformidade", "descricaoAcaoNaoConformidade", "usuarioAcaoNaoConformidade", "dataHoraAcaoNaoConformidade", "analiseAcaoNaoConformidade", "tipoRelatorio", "codigoNaoConformidadeChave", "siglaSetor", "requisicaoUrgente", "identificadorConclusao", "descricaoProcedencia", "critica", "codigoOrigemNaoConformidade", "descricaoOrigemNaoConformidade", "descricaoAcaoAnaliseNaoConformidade", "tipoNaoConformidade", "codigoTipoNaoConformidade"});

    public ImprimirNaoConformidade() {
        this.montaBarraDescricao("Imprimir n\u00e3o conformidade", "Imprime a n\u00e3o conformidade selecionada", "relatorios/rel_qc_nc_naoconformidade.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaFiltroComPesquisa(FILTRO_NCF, "C\u00f3digo:", 7, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    NaoConformidadeVO codigoNcf = (NaoConformidadeVO)new NaoConformidadeService().pesquisaVOSemSituacao(ImprimirNaoConformidade.this.getTopLevelAncestor(), new NaoConformidadeVO(), "Pesquisando n\u00e3o conformidades", false);
                    if (codigoNcf != null) {
                        ImprimirNaoConformidade.this.setFiltroComPesquisa(ImprimirNaoConformidade.FILTRO_NCF, codigoNcf.getCodigo().toString());
                    }
                }
                catch (Exception e1) {
                    ErrorLogger.mostraMensagem(ImprimirNaoConformidade.this.getTopLevelAncestor(), "Informe o c\u00f3digo", e1.getStackTrace());
                }
            }
        }, 1);
        this.adicionaFiltroCheck(FILTRO_CRITICA_SETOR, "Considerar critica por setor", false);
        this.setModuloConfigurar(ImprimirNaoConformidade.getModuloConfigurar());
        this.setModuloAcesso(ImprimirNaoConformidade.getModuloAcesso());
        this.setCamposConfigurador(this.campos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement statement;
        block13: {
            this.setCursor(Cursor.getPredefinedCursor(3));
            statement = Conexao.getStatement();
            ModeloGridTable modeloImpressao = new ModeloGridTable(this.campos);
            if (Funcoes.textoVazio(this.getFiltroComPesquisa(FILTRO_NCF))) {
                Funcoes.mensagem(this, "Informe o c\u00f3digo.", 2);
                this.setCursor(Cursor.getDefaultCursor());
                this.requisitaFocoComponente(FILTRO_NCF);
                this.habilitaBotaoImprimir(true);
                return;
            }
            try {
                StringBuilder sql = new StringBuilder();
                if (this.getFiltroCheck(FILTRO_CRITICA_SETOR)) {
                    sql.append(this.getSelectCriticaSetores());
                }
                sql.append(this.getSqlRequisicao(Integer.parseInt(this.getFiltroComPesquisa(FILTRO_NCF))));
                sql.append(" union ");
                sql.append(this.getSqlSetores(Integer.parseInt(this.getFiltroComPesquisa(FILTRO_NCF))));
                sql.append(" union ");
                sql.append(this.getSqlSetoresUsuario(Integer.parseInt(this.getFiltroComPesquisa(FILTRO_NCF))));
                if (this.getFiltroCheck(FILTRO_CRITICA_SETOR)) {
                    sql.append(this.getJoinCriticaSetor());
                }
                sql.append(" order by codigoNaoConformidadeChave, codigoRequisicao, tipoSetorNaoConformidade, codigoSetor");
                ResultSet rsDados = Conexao.executeQuery(statement, sql.toString());
                if (rsDados.next()) {
                    do {
                        Object[] o = new Object[this.campos.length];
                        for (int i = 0; i < this.campos.length; ++i) {
                            o[i] = rsDados.getObject(this.campos[i]);
                        }
                        modeloImpressao.addLine(o);
                    } while (rsDados.next());
                }
                if (modeloImpressao.getRowCount() > 0) {
                    StringBuilder sqlRel = new StringBuilder();
                    sqlRel.append("select rel_xml from relatoriosistema where rel_codigo = ").append(this.getModuloAcesso());
                    ResultSet rsLayout = Conexao.executeQuery(statement, sqlRel.toString());
                    if (rsLayout.next()) {
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put(FILTRO_NCF, this.getFiltroComPesquisa(FILTRO_NCF));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(0.5f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                ImprimirNaoConformidade.this.panelCentro.removeAll();
                                ImprimirNaoConformidade.this.panelCentro.repaint();
                                ImprimirNaoConformidade.this.habilitaBotaoImprimir(true);
                            }
                        });
                        gerador.executar(rsLayout.getString("rel_xml"), (TableModel)modeloImpressao, var);
                        this.panelCentro.revalidate();
                    } else {
                        Funcoes.mensagem(this.getTopLevelAncestor(), "Relat\u00f3rio n\u00e3o possui layout.", 2);
                    }
                    break block13;
                }
                Funcoes.mensagem(this.getTopLevelAncestor(), "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel gerar o relat\u00f3rio de n\u00e3o conformidade", e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(statement);
                    this.setCursor(Cursor.getDefaultCursor());
                    throw throwable;
                }
                Conexao.fecharStatement(statement);
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
        Conexao.fecharStatement(statement);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public ImprimirNaoConformidade(Integer codigoNaoConformidade) {
        this.impressaoJanelaPopUp(codigoNaoConformidade);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void impressaoJanelaPopUp(Integer codigoNaoConformidade) {
        SplashMensagem mensagem = SplashMensagem.getInstancia(this);
        try {
            StringBuilder sqlConsulta = new StringBuilder();
            sqlConsulta.append(this.getSqlRequisicao(codigoNaoConformidade));
            sqlConsulta.append(" union ");
            sqlConsulta.append(this.getSqlSetores(codigoNaoConformidade));
            sqlConsulta.append(" union ");
            sqlConsulta.append(this.getSqlSetoresUsuario(codigoNaoConformidade));
            sqlConsulta.append(" order by codigoNaoConformidadeChave, codigoRequisicao, tipoSetorNaoConformidade, codigoSetor");
            ModeloGridTable modeloImpressao = new ModeloGridTable(this.campos);
            ResultSet rsDados = Conexao.executeQuery(Conexao.getStatement(), sqlConsulta.toString());
            if (rsDados.next()) {
                do {
                    Object[] o = new Object[this.campos.length];
                    for (int i = 0; i < this.campos.length; ++i) {
                        o[i] = rsDados.getObject(this.campos[i]);
                    }
                    modeloImpressao.addLine(o);
                } while (rsDados.next());
            }
            StringBuilder sql = new StringBuilder();
            sql.append("select rel_xml from relatoriosistema where rel_codigo = ");
            sql.append(this.getModuloAcesso());
            ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), sql.toString());
            if (modeloImpressao.getRowCount() > 0) {
                mensagem.mostrar("Aguarde...");
                if (rs.next()) {
                    HashMap<String, Object> variaveis = new HashMap<String, Object>();
                    variaveis.put(FILTRO_NCF, codigoNaoConformidade);
                    Gerador gerador = new Gerador(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                    gerador.setPreVisualizar(true);
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modeloImpressao, variaveis);
                    this.panelCentro.revalidate();
                } else {
                    Funcoes.mensagem(this, "Relat\u00f3rio n\u00e3o possui layout.", 2);
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
            }
            mensagem.apagar();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), "N\u00e3o foi poss\u00edvel imprimir o relat\u00f3rio de n\u00e3o conformidade", e.getStackTrace());
        }
        finally {
            mensagem.apagar();
        }
    }

    public static long getModuloAcesso() {
        return Long.valueOf("0890000100");
    }

    public static long getModuloConfigurar() {
        return Long.valueOf("0890000101");
    }

    private String getSelectCriticaSetores() {
        StringBuilder sql = new StringBuilder();
        sql.append("select distinct a.sna_critica critica, s.codigoNaoConformidadeChave, s.dataNaoConformidade, s.dataLeitura, s.dataHoraNaoConformidade, s.usuarioNaoConformidade, s.codigoProcedencia, s.nomeProcedencia,");
        sql.append(" s.codigoRequisicao, s.codigoConvenio, s.razaoSocialConvenio, s.fantasiaConvenio, s.codigoPaciente, s.nomePaciente, s.crmMedico, s.nomeMedico, s.dataRequisicao, s.codigoSetor, s.descricaoSetor,");
        sql.append(" s.usuarioResponsavelSetor, s.usuarioNotificado, s.descricaoNaoConformidade, s.urgente, s.usuarioConclusao, s.usuarioAnalise, s.usuarioRegistro, s.analiseNaoConformidade, s.conclusaoNaoConformidade,");
        sql.append(" s.dataConclusaoNaoConformidade, s.situacaoNaoConformidade, s.dataAnaliseNaoConformidade, s.dataHoraConclusaoNaoConformidade, s.dataHoraAnaliseNaoConformidade, s.tipoConclusaoNaoConformidade,");
        sql.append(" s.tipoSetorNaoConformidade, s.codigoAcaoNaoConformidade, s.usuarioAcaoNaoConformidade, s.dataHoraAcaoNaoConformidade, s.analiseAcaoNaoConformidade, s.descricaoAnaliseAcaoNaoConformidade,");
        sql.append(" s.descricaoAcaoNaoConformidade, s.descricaoAcaoAnaliseNaoConformidade, s.tipoRelatorio, s.codigoNaoConformidade, s.siglaSetor, s.requisicaoUrgente, s.identificadorConclusao, s.descricaoProcedencia,");
        sql.append(" s.codigoFilial, s.descricaoFilial, s.cnpjFilial, s.enderecoFilial, s.complementoFilial, s.cepFilial, s.foneFilial, s.faxFilial, s.razaoSocialFilial, s.CNESFilial, s.codigoCidadeFilial,");
        sql.append(" s.descricaoCidadeFilial, s.estadoCidadeFilial, s.codigoBairroFilial, s.descricaoBairroFilial, s.codigoOrigemNaoConformidade,s.descricaoOrigemNaoConformidade from (");
        return sql.toString();
    }

    private String getJoinCriticaSetor() {
        StringBuilder sql = new StringBuilder();
        sql.append(") as s left join setoresnaoconformidade a on s.codigosetor = a.set_codigo and a.nac_codigo  = s.codigoNaoConformidade where a.fil_codigo = ").append(Variaveis.filialPadrao);
        sql.append(" and a.sna_critica is not null");
        return sql.toString();
    }

    private String getSqlRequisicao(Integer codigoNcf) {
        StringBuilder sql = new StringBuilder();
        sql.append(" (select distinct (a.nac_codigo) as codigoNaoConformidadeChave, a.nac_data as dataNaoConformidade, cast(null as timestamp) as dataLeitura     ");
        sql.append(" ,a.nac_datahora as dataHoraNaoConformidade, a.usr_codigo as usuarioNaoConformidade");
        sql.append(" ,a.pnc_codigo as codigoProcedencia, pnc.pnc_descricao as nomeProcedencia");
        sql.append(" ,req.req_codigo as codigoRequisicao, con.con_codigo as codigoConvenio");
        sql.append(" ,con.con_razao as razaoSocialConvenio, con.con_fantasia as fantasiaConvenio");
        sql.append(" ,pac.pac_codigo as codigoPaciente, pac.pac_nome as nomePaciente, med.med_crm as crmMedico");
        sql.append(" ,upper(med.med_nome) as nomeMedico, req.req_data as dataRequisicao, cast(NULL as integer) as codigoSetor");
        sql.append(" ,'' as descricaoSetor, '' as usuarioResponsavelSetor");
        sql.append(" ,'' as usuarioNotificado, a.nac_registro as descricaoNaoConformidade");
        sql.append(",(case when nac_urgente is true then 'Sim' else 'N\u00e3o' end) as urgente");
        sql.append(" ,a.usr_codconclusao as usuarioConclusao, a.usr_codanalise as usuarioAnalise");
        sql.append(" ,a.usr_codregistro as usuarioRegistro, a.nac_analise as analiseNaoConformidade");
        sql.append(" ,a.nac_conclusao as conclusaoNaoConformidade, a.nac_dataconclusao as dataConclusaoNaoConformidade");
        sql.append(" ,(case when a.nac_situacao = '").append("A").append("' then 'Aberta' when a.nac_situacao = '").append("N").append("' then 'An\u00e1lise'          ");
        sql.append(" when a.nac_situacao = '").append("C").append("' then 'Conclu\u00edda' when a.nac_situacao = '").append("L").append("' then 'An\u00e1lise' end ) as situacaoNaoConformidade            ");
        sql.append(" ,a.nac_dataanalise as dataAnaliseNaoConformidade, a.nac_datahoraconclusao as dataHoraConclusaoNaoConformidade ");
        sql.append(" ,a.nac_datahoraanalise as dataHoraAnaliseNaoConformidade\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t ");
        sql.append(" ,(case when a.nac_tipoconclusao = 'S' then 'Simples' when a.nac_tipoconclusao = 'C' then            ");
        sql.append("  'Ac\u00e3o Corretiva' when a.nac_tipoconclusao = 'P' then 'A\u00e7\u00e3o Preventiva' end ) as tipoConclusaoNaoConformidade ");
        sql.append(" ,'' as tipoSetorNaoConformidade ");
        sql.append(this.getCamposAcoes());
        sql.append(" , '").append("R").append("' as tipoRelatorio, a.nac_codigo as codigoNaoConformidade, '' as siglaSetor                               ");
        sql.append(" ,(case when req.req_urgente is true then 'Sim' else 'N\u00e3o' end) as requisicaoUrgente                           ");
        sql.append(" ,a.nac_identificadorconclusao as identificadorConclusao, a.nac_descricaoprocedencia descricaoProcedencia      ");
        sql.append(" ,").append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
        sql.append(", NULL as critica ");
        sql.append(" ,onc.onc_codigo as codigoOrigemNaoConformidade,  onc.onc_descricao as descricaoOrigemNaoConformidade");
        sql.append(" ,tc.tcf_codigo as codigoTipoNaoConformidade,  tc.tcf_descricao as tipoNaoConformidade ");
        sql.append(" from naoconformidade a                                                                                        ");
        sql.append(" left join requisicaonaoconformidade rnc on rnc.fil_codigo = a.fil_codigo and rnc.nac_codigo = a.nac_codigo    ");
        sql.append(" left join naoconformidadelote ncl on ncl.fil_codigo = a.fil_codigo and ncl.nac_codigo = rnc.nac_codigo        ");
        sql.append(" left join procedencianaoconformidade pnc on pnc.fil_codigo = a.fil_codigo and pnc.pnc_codigo = a.pnc_codigo\t ");
        sql.append(" left join requisicao req on req.fil_codigo = a.fil_codigo and req.req_codigo = rnc.req_codigo                 ");
        sql.append(" left join convenios con on con.fil_codigo = a.fil_codigo and con.con_codigo = req.con_codigo                  ");
        sql.append(" left join paciente pac on pac.fil_codigo = a.fil_codigo and pac.pac_codigo = req.pac_codigo                   ");
        sql.append(" left join medico med on a.fil_codigo = med.fil_codigo and req.med_conselho = med.med_conselho and req.med_crm = med.med_crm and req.med_uf = med.med_uf ");
        sql.append(" left join origemnaoconformidade onc on a.fil_codigo = onc.fil_codigo and a.onc_codigo = onc.onc_codigo ");
        sql.append(" left join tiponaoconformidade tc on tc.fil_codigo = a.fil_codigo and tc.tcf_codigo = a.tcf_codigo        ");
        sql.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
        sql.append(" where a.fil_codigo = ").append(Variaveis.filialPadrao);
        sql.append(" and a.nac_codigo = ").append(codigoNcf);
        sql.append(" order by codigoNaoConformidadeChave, codigoRequisicao, tipoSetorNaoConformidade, codigoSetor)");
        return sql.toString();
    }

    private String getSqlSetores(Integer codigoNcf) {
        StringBuilder sql = new StringBuilder();
        sql.append(" (select distinct (a.nac_codigo + 1) as codigoNaoConformidadeChave, a.nac_data as dataNaoConformidade");
        sql.append(" ,cast(null as timestamp) as dataLeitura ");
        sql.append(" ,a.nac_datahora as dataHoraNaoConformidade, a.usr_codigo as usuarioNaoConformidade");
        sql.append(" ,a.pnc_codigo as codigoProcedencia, pnc.pnc_descricao as nomeProcedencia");
        sql.append(" ,cast(NULL as integer) as codigoRequisicao, cast(NULL as integer) as codigoConvenio");
        sql.append(" ,'' as razaoSocialConvenio, '' as fantasiaConvenio");
        sql.append(" ,cast(NULL as integer) as codigoPaciente, '' as nomePaciente, '' as crmMedico");
        sql.append(" ,'' as nomeMedico, cast(NULL as date) as dataRequisicao, set.set_codigo as codigoSetor");
        sql.append(" ,set.set_descricao as descricaoSetor, snc.usr_codresponsavelsetor as usuarioResponsavelSetor");
        sql.append(" ,(select  Array_to_string(Array_agg(usr_codigo) , ',') from");
        sql.append(" setoresnaoconformidadeusuario notificado where  notificado.nac_codigo = a.nac_codigo");
        sql.append(" and snc.sna_codigo = notificado.sna_codigo) AS usuarioNotificado , a.nac_registro as descricaoNaoConformidade ");
        sql.append("  ,(case when nac_urgente is true then 'Sim' else 'N\u00e3o' end) as urgente");
        sql.append(" ,a.usr_codconclusao as usuarioConclusao, a.usr_codanalise as usuarioAnalise");
        sql.append(" ,a.usr_codregistro as usuarioRegistro, a.nac_analise as analiseNaoConformidade");
        sql.append(" ,a.nac_conclusao as conclusaoNaoConformidade, a.nac_dataconclusao as dataConclusaoNaoConformidade");
        sql.append(" ,(case when a.nac_situacao = '").append("A").append("' then 'Aberta' when a.nac_situacao = '").append("N").append("' then 'An\u00e1lise'          ");
        sql.append(" when a.nac_situacao = '").append("C").append("' then 'Conclu\u00edda' when a.nac_situacao = '").append("L").append("' then 'An\u00e1lise' end ) as situacaoNaoConformidade            ");
        sql.append(" ,a.nac_dataanalise as dataAnaliseNaoConformidade, a.nac_datahoraconclusao as dataHoraConclusaoNaoConformidade ");
        sql.append(" ,a.nac_datahoraanalise as dataHoraAnaliseNaoConformidade");
        sql.append(" ,(case when a.nac_tipoconclusao = 'S' then 'Simples' when a.nac_tipoconclusao = 'C' then");
        sql.append("  'Ac\u00e3o Corretiva' when a.nac_tipoconclusao = 'P' then 'A\u00e7\u00e3o Preventiva' end ) as tipoConclusaoNaoConformidade ");
        sql.append(" ,(case when snc.sna_tipo = 'R' then 'Respons\u00e1vel' when snc.sna_tipo = 'N' then 'Notificado'");
        sql.append(" when snc.sna_tipo = 'S' then 'Envolvido' end) as tipoSetorNaoConformidade ");
        sql.append(this.getCamposAcoes());
        sql.append(" , '").append("S").append("' as tipoRelatorio, a.nac_codigo as codigoNaoConformidade, set.set_sigla as siglaSetor");
        sql.append(" ,'' as requisicaoUrgente, a.nac_identificadorconclusao as identificadorConclusao");
        sql.append(" ,a.nac_descricaoprocedencia descricaoProcedencia");
        sql.append(" ,").append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
        sql.append(", NULL as critica ");
        sql.append(" ,onc.onc_codigo as codigoOrigemNaoConformidade,  onc.onc_descricao as descricaoOrigemNaoConformidade");
        sql.append("       ,tn.tcf_codigo as codigoTipoNaoConformidade ");
        sql.append("       ,tn.tcf_descricao as tipoNaoConformidade ");
        sql.append(" from naoconformidade a");
        sql.append(" left join setoresnaoconformidade snc on snc.fil_codigo = a.fil_codigo and snc.nac_codigo = a.nac_codigo");
        sql.append(" left join naoconformidadelote ncl on ncl.fil_codigo = a.fil_codigo and ncl.nac_codigo = a.nac_codigo");
        sql.append(" left join procedencianaoconformidade pnc on pnc.fil_codigo = a.fil_codigo and pnc.pnc_codigo = a.pnc_codigo");
        sql.append(" left join setores set on set.fil_codigo = a.fil_codigo and set.set_codigo = snc.set_codigo ");
        sql.append(" left join origemnaoconformidade onc on a.fil_codigo = onc.fil_codigo and a.onc_codigo = onc.onc_codigo ");
        sql.append(" LEFT JOIN tiponaoconformidade tn on a.fil_codigo = tn.fil_codigo and a.tcf_codigo = tn.tcf_codigo ");
        sql.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
        sql.append(" where a.fil_codigo = ").append(Variaveis.filialPadrao);
        sql.append(" and a.nac_codigo = ").append(codigoNcf);
        sql.append(" order by codigoNaoConformidadeChave, codigoRequisicao, tipoSetorNaoConformidade, codigoSetor)");
        return sql.toString();
    }

    private String getSqlSetoresUsuario(Integer codigoNcf) {
        StringBuilder sql = new StringBuilder();
        sql.append(" (select distinct (a.nac_codigo + 2) as codigoNaoConformidadeChave, a.nac_data as dataNaoConformidade");
        sql.append(" ,date_trunc('second', sncfu.snu_dataleitura ) as dataLeitura ");
        sql.append(" ,a.nac_datahora as dataHoraNaoConformidade, a.usr_codigo as usuarioNaoConformidade");
        sql.append(" ,a.pnc_codigo as codigoProcedencia, pnc.pnc_descricao as nomeProcedencia");
        sql.append(" ,cast(NULL as integer) as codigoRequisicao, cast(NULL as integer) as codigoConvenio");
        sql.append(" ,'' as razaoSocialConvenio, '' as fantasiaConvenio");
        sql.append(" ,cast(NULL as integer) as codigoPaciente, '' as nomePaciente, '' as crmMedico");
        sql.append(" ,'' as nomeMedico, cast(NULL as date) as dataRequisicao, set.set_codigo as codigoSetor");
        sql.append(" ,'' as descricaoSetor, '' as usuarioResponsavelSetor");
        sql.append(" , '' AS usuarioNotificado , a.nac_registro as descricaoNaoConformidade ");
        sql.append(" ,(case when nac_urgente is true then 'Sim' else 'N\u00e3o' end) as urgente");
        sql.append(" ,a.usr_codconclusao as usuarioConclusao, a.usr_codanalise as usuarioAnalise");
        sql.append(" ,a.usr_codregistro as usuarioRegistro, a.nac_analise as analiseNaoConformidade");
        sql.append(" ,a.nac_conclusao as conclusaoNaoConformidade, a.nac_dataconclusao as dataConclusaoNaoConformidade");
        sql.append(" ,(case when a.nac_situacao = '").append("A").append("' then 'Aberta' when a.nac_situacao = '").append("N").append("' then 'An\u00e1lise'          ");
        sql.append(" when a.nac_situacao = '").append("C").append("' then 'Conclu\u00edda' when a.nac_situacao = '").append("L").append("' then 'An\u00e1lise' end ) as situacaoNaoConformidade ");
        sql.append(" ,a.nac_dataanalise as dataAnaliseNaoConformidade, a.nac_datahoraconclusao as dataHoraConclusaoNaoConformidade ");
        sql.append(" ,a.nac_datahoraanalise as dataHoraAnaliseNaoConformidade");
        sql.append(" ,cast(null as varchar) as tipoConclusaoNaoConformidade ");
        sql.append(" ,cast(null as varchar) as tipoSetorNaoConformidade ");
        sql.append(this.getCamposAcoes());
        sql.append(" , '").append("N").append("' as tipoRelatorio, a.nac_codigo as codigoNaoConformidade, '' as siglaSetor                    ");
        sql.append(" ,'' as requisicaoUrgente, a.nac_identificadorconclusao as identificadorConclusao");
        sql.append(" ,a.nac_descricaoprocedencia descricaoProcedencia");
        sql.append(" ,").append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
        sql.append(this.getCampoCritica());
        sql.append(" ,onc.onc_codigo as codigoOrigemNaoConformidade,  onc.onc_descricao as descricaoOrigemNaoConformidade");
        sql.append("       ,tn.tcf_codigo as codigoTipoNaoConformidade ");
        sql.append("       ,tn.tcf_descricao as tipoNaoConformidade ");
        sql.append(" from naoconformidade a");
        sql.append(" left join setoresnaoconformidade snc on snc.fil_codigo = a.fil_codigo and snc.nac_codigo = a.nac_codigo");
        sql.append(" left join setoresnaoconformidadeusuario sncfu on sncfu.fil_codigo = a.fil_codigo and sncfu.nac_codigo = a.nac_codigo and sncfu.sna_codigo = snc.sna_codigo ");
        sql.append(" left join naoconformidadelote ncl on ncl.fil_codigo = a.fil_codigo and ncl.nac_codigo = snc.nac_codigo");
        sql.append(" left join procedencianaoconformidade pnc on pnc.fil_codigo = a.fil_codigo and pnc.pnc_codigo = a.pnc_codigo");
        sql.append(" left join setores set on set.fil_codigo = a.fil_codigo and set.set_codigo = snc.set_codigo ");
        sql.append(" left join origemnaoconformidade onc on a.fil_codigo = onc.fil_codigo and a.onc_codigo = onc.onc_codigo ");
        sql.append(" LEFT JOIN tiponaoconformidade tn on a.fil_codigo = tn.fil_codigo and a.tcf_codigo = tn.tcf_codigo ");
        sql.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
        sql.append(" where a.fil_codigo = ").append(Variaveis.filialPadrao);
        sql.append(" and a.nac_codigo = ").append(codigoNcf);
        sql.append(" order by codigoNaoConformidadeChave, codigoRequisicao, tipoSetorNaoConformidade, codigoSetor)");
        return sql.toString();
    }

    private String getCampoCritica() {
        StringBuilder sql = new StringBuilder();
        sql.append(" , (select  array_to_string(array_agg(distinct snc.sna_critica), '\n' ) from setoresnaoconformidade snc where snc.fil_codigo = a.fil_codigo and snc.nac_codigo = a.nac_codigo) as critica");
        return sql.toString();
    }

    private String getCamposAcoes() {
        StringBuilder sql = new StringBuilder();
        sql.append(" ,(select array_to_string(array_agg(distinct anc.nac_codigo) , ',')  from acoesnaoconformidade anc where anc.fil_codigo = a.fil_codigo and anc.nac_codigo = a.nac_codigo ) as codigoAcaoNaoConformidade ");
        sql.append(" ,(select array_to_string(array_agg(distinct anc.usr_codigo) , ',')   from acoesnaoconformidade anc where anc.fil_codigo = a.fil_codigo and anc.nac_codigo = a.nac_codigo) as usuarioAcaoNaoConformidade ");
        sql.append(" ,(select array_to_string(array_agg(distinct to_char(anc.acn_datahora, 'dd-MM-yyyy')|| ' '|| to_char(anc.acn_datahora, 'HH12:MI') ), ',') from acoesnaoconformidade anc where anc.fil_codigo = a.fil_codigo and anc.nac_codigo = a.nac_codigo) as dataHoraAcaoNaoConformidade ");
        sql.append(" ,(select array_to_string(array_agg(distinct anc.acn_analise) , ',')  from acoesnaoconformidade anc where anc.fil_codigo = a.fil_codigo and anc.nac_codigo = a.nac_codigo)  as analiseAcaoNaoConformidade ");
        sql.append(" ,(select array_to_string(array_agg(distinct anc.acn_descricaoacao) , ',') from acoesnaoconformidade anc where anc.fil_codigo = a.fil_codigo and anc.nac_codigo = a.nac_codigo) as descricaoAnaliseAcaoNaoConformidade ");
        sql.append(" ,(select array_to_string(array_agg(distinct nc.anc_descricao) , ',') ");
        sql.append(" from acoesnaoconformidade anc ");
        sql.append(" left join acaonaoconformidade nc on anc.fil_codigo = nc.fil_codigo");
        sql.append(" and anc.anc_codigo = nc.anc_codigo");
        sql.append(" where anc.fil_codigo = a.fil_codigo ");
        sql.append(" and anc.nac_codigo = a.nac_codigo").append(") as descricaoAcaoNaoConformidade ");
        sql.append(" ,(select array_to_string(array_agg( anc.acn_descricaoacao || ', ' ||  anc.acn_analise  || ', ' || nc.anc_descricao) ,  '<html><br>'  )");
        sql.append(" from acoesnaoconformidade anc ");
        sql.append(" left join acaonaoconformidade nc on anc.fil_codigo = nc.fil_codigo ");
        sql.append("and anc.anc_codigo = nc.anc_codigo  ");
        sql.append("where  anc.fil_codigo = a.fil_codigo ");
        sql.append("and anc.nac_codigo = a.nac_codigo ) as descricaoAcaoAnaliseNaoConformidade ");
        return sql.toString();
    }
}

