/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.log;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioLoginsUsuario
extends FrmRelPadrao {
    private static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private static final String FILTRO_USUARIO = "filtroUsuario";
    private static final String FILTRO_ESTACAO = "filtroEstacao";
    private static final String FILTRO_CAMPO = "filtroCampo";
    private String[] campos = new String[]{"dataHoraLogin", "dataHoraLogout", "codigoUsuario", "codigoEstacao", "nomeUsuario", "descricaoEstacao"};
    private String[] camposData = new String[]{"ulo_datahoralogin", "ulo_datahoralogout"};
    private String[] camposFilial = Constantes.CAMPOS_FILIAL;
    private SplashMensagem mensagem = new SplashMensagem();

    public RelatorioLoginsUsuario() {
        try {
            this.montaBarraDescricao("Relat\u00f3rio logins por usu\u00e1rios", "Listagem de usu\u00e1rios que acessaram o sistema.", "relatorios/rel_ger_log_login.jpg");
            this.adicionaRelatorioListener(this);
            this.adicionaItemFiltro(FILTRO_USUARIO, "Usu\u00e1rio", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
            this.adicionaItemFiltro(FILTRO_ESTACAO, "Esta\u00e7\u00e3o", "estacoes", "", 1, new String[]{"est_codigo", "est_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
            this.adicionaFiltroCombo(FILTRO_CAMPO, "Campo data:", new String[]{"Login", "Logout"}, 0);
            this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Data Inicial:");
            this.adicionaFiltroData(FILTRO_DATA_FINAL, "Data Final:");
            this.setModuloAcesso(RelatorioLoginsUsuario.getModuloAcesso());
            this.setModuloConfigurar(RelatorioLoginsUsuario.getModuloConfigurar());
            this.setCamposConfigurador((String[])this.campos.clone());
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "", e.getStackTrace());
        }
    }

    @Override
    public void imprimirPressionado() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        ModeloGridTable modelo = new ModeloGridTable(ArraysUtil.concatenar(this.campos, this.camposFilial));
        try {
            String[] usuarios;
            StringBuilder sql = new StringBuilder();
            sql.append("select ulo.usr_codigo as codigoUsuario ");
            sql.append("      ,ulo.ulo_datahoralogin as dataHoraLogin ");
            sql.append("\t\t\t,ulo.ulo_datahoralogout as dataHoraLogout ");
            sql.append("\t\t\t,ulo.est_codigo as codigoEstacao ");
            sql.append("\t\t\t,est.est_descricao as descricaoEstacao ");
            sql.append("\t\t\t,usr.usr_nome as nomeUsuario ");
            sql.append("  from usuariologin ulo ");
            sql.append("  join usuario usr on ulo.usr_codigo = usr.usr_codigo ");
            sql.append("  join estacoes est on ulo.est_codigo = est.est_codigo ");
            sql.append("where ");
            if (!Funcoes.textoVazio(this.getFiltroData(FILTRO_DATA_INICIAL))) {
                this.mensagem = SplashMensagem.getInstancia(this);
                String dataInicial = Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_INICIAL));
                String dataFinal = Funcoes.textoVazio(this.getFiltroData(FILTRO_DATA_FINAL)) ? null : Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_FINAL));
                sql.append(" cast(ulo." + this.camposData[this.getFiltroComboIndice(FILTRO_CAMPO)] + " as date) >= '").append(dataInicial).append("' ");
                if (!Funcoes.textoVazio(dataFinal)) {
                    sql.append(" and cast(ulo." + this.camposData[this.getFiltroComboIndice(FILTRO_CAMPO)] + " as date) <= '").append(dataFinal).append("' ");
                }
            } else {
                this.setCursor(Cursor.getDefaultCursor());
                Funcoes.mensagem(this, "Informe a data inicial.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            String[] estacoes = this.getSelecionadosFiltro(FILTRO_ESTACAO, 0);
            if (estacoes != null) {
                sql.append(" and ulo.est_codigo in (");
                for (int i = 0; i < estacoes.length; ++i) {
                    sql.append(estacoes[i]);
                    if (i >= estacoes.length - 1) continue;
                    sql.append(", ");
                }
                sql.append(")");
            }
            if ((usuarios = this.getSelecionadosFiltro(FILTRO_USUARIO, 0)) != null) {
                sql.append(" and ulo.usr_codigo in (");
                for (int i = 0; i < usuarios.length; ++i) {
                    sql.append(StringUtil.textoDBEscape(usuarios[i]));
                    if (i >= usuarios.length - 1) continue;
                    sql.append(", ");
                }
                sql.append(")");
            }
            sql.append(" order by upper(ulo.usr_codigo), ulo.ulo_codigo ");
            Statement st = Conexao.getStatement();
            ResultSet rs = Conexao.executeQuery(st, sql.toString());
            if (rs.next()) {
                Statement stFilial = Conexao.getStatement();
                sql.setLength(0);
                sql.append("select  ");
                sql.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                sql.append("from filiais_postocoleta filial ");
                sql.append("left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo ");
                sql.append("left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                sql.append("where filial.fil_codigo = ").append(Variaveis.filialPadrao);
                ResultSet rsFilial = Conexao.executeQuery(stFilial, sql.toString());
                Object[] oFilial = new Object[this.camposFilial.length];
                if (rsFilial.next()) {
                    for (int i = 0; i < this.camposFilial.length; ++i) {
                        oFilial[i] = rsFilial.getObject(this.camposFilial[i]);
                    }
                }
                do {
                    Object[] o = new Object[this.campos.length];
                    for (int i = 0; i < this.campos.length; ++i) {
                        o[i] = rs.getObject(this.campos[i]);
                    }
                    o = ArraysUtil.concatenar(o, oFilial);
                    modelo.addLine(o);
                } while (rs.next());
                sql.delete(0, sql.length());
                sql.append("select rel_xml from relatoriosistema where rel_codigo = ");
                sql.append(RelatorioLoginsUsuario.getModuloAcesso());
                ResultSet resultSetRelatorio = Conexao.executeQuery(Conexao.getStatement(), sql.toString());
                if (resultSetRelatorio.next()) {
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(1.0f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioLoginsUsuario.this.panelCentro.removeAll();
                            RelatorioLoginsUsuario.this.panelCentro.repaint();
                            RelatorioLoginsUsuario.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    if (this.getSelecionadosFiltro(FILTRO_USUARIO, 0) != null) {
                        var.put(FILTRO_USUARIO, this.getSelecionadosFiltro(FILTRO_USUARIO, 0));
                    }
                    if (this.getSelecionadosFiltro(FILTRO_ESTACAO, 0) != null) {
                        var.put(FILTRO_ESTACAO, this.getSelecionadosFiltro(FILTRO_ESTACAO, 0));
                    } else {
                        var.put(FILTRO_ESTACAO, "");
                    }
                    if (this.getFiltroCombo(FILTRO_CAMPO) != null) {
                        var.put(FILTRO_CAMPO, this.getFiltroCombo(FILTRO_CAMPO));
                    }
                    if (!Funcoes.textoVazio(this.getFiltroData(FILTRO_DATA_INICIAL))) {
                        var.put(FILTRO_DATA_INICIAL, Funcoes.formataData("dd/MM/yyyy", this.getFiltroData(FILTRO_DATA_INICIAL)));
                    } else {
                        var.put(FILTRO_DATA_INICIAL, "");
                    }
                    if (!Funcoes.textoVazio(this.getFiltroData(FILTRO_DATA_FINAL))) {
                        var.put(FILTRO_DATA_FINAL, Funcoes.formataData("dd/MM/yyyy", this.getFiltroData(FILTRO_DATA_FINAL)));
                    } else {
                        var.put(FILTRO_DATA_FINAL, "");
                    }
                    gerador.executar(resultSetRelatorio.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                    resultSetRelatorio.close();
                    this.mensagem.apagar();
                } else {
                    Funcoes.mensagem(this, "Relat\u00f3rio n\u00e3o possui layout.", 2);
                    this.habilitaBotaoImprimir(true);
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
        }
        catch (Exception e) {
            this.habilitaBotaoImprimir(true);
            this.mensagem.apagar();
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        this.mensagem.apagar();
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0880500102");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0880500103");
    }
}

