/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.log;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.laboratorio.configuracao.log.AuditoriaLog;
import jalis.laboratorio.configuracao.log.LogRegistroMudanca;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.model.bean.cadastro.FilialBean;
import jalis.model.bean.log.AuditoriaTabelaDescricaoLogBean;
import jalis.model.bean.log.AuditoriaTabelaDescricaoLogTabelaBean;
import jalis.model.bean.log.LogRastreabilidadeBean;
import jalis.relatorio.Gerador;
import jalis.service.cadastro.FilialService;
import jalis.service.log.AuditoriaTabelaDescricaoLogTabelaService;
import jalis.service.log.AuditoriaTabelaDescricaoService;
import jalis.service.log.LogRastreabilidadeService;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.table.TableModel;

public class RelatorioAuditoriaLog
extends FrmRelPadrao {
    private static final String FILTRO_CHAVES = "filtroChaves";
    private static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private static final String FILTRO_TABELA = "filtroTabela";
    private static final String FILTRO_USUARIO = "filtroUsuario";
    private static final String FILTRO_FILIAL = "filtroFilial";
    private String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoLogTabela", "dataHoraAlteracao", "codigoUsuarioAlteracao", "tabelaAlterada", "tipoOperacao", "colunaAlterada", "valorAnterior", "valorNovo", "colunaAlteradaField", "chave"});
    private SplashMensagem mensagem = new SplashMensagem();
    private AuditoriaTabelaDescricaoService auditoriaTabelaDescricaoService = new AuditoriaTabelaDescricaoService();
    private AuditoriaTabelaDescricaoLogTabelaService auditoriaTabelaDescricaoLogTabelaService = new AuditoriaTabelaDescricaoLogTabelaService();
    private LogRastreabilidadeService rastreabilidadeService = new LogRastreabilidadeService();

    public RelatorioAuditoriaLog() {
        try {
            this.montaBarraDescricao("Relat\u00f3rio Auditoria de Log", "Relat\u00f3rio de log das mudan\u00e7as realizadas nos registros do sistema.", "relatorios/rel_ger_log_auditoria.jpg");
            this.adicionaRelatorioListener(this);
            this.adicionaItemFiltro(FILTRO_FILIAL, "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
            this.adicionaItemFiltro(FILTRO_USUARIO, "Usu\u00e1rio", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
            this.adicionaFiltroComboPopupWidth(FILTRO_TABELA, "Tabela", this.auditoriaTabelaDescricaoService.getListaTabelaDescricaoUser(), 0, 400);
            this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Data Inicial");
            this.adicionaFiltroData(FILTRO_DATA_FINAL, "Data Final");
            this.adicionaFiltroTexto(FILTRO_CHAVES, "Chaves", 100);
            this.setModuloAcesso(RelatorioAuditoriaLog.getModuloAcesso());
            this.setModuloConfigurar(RelatorioAuditoriaLog.getModuloConfigurar());
            this.setCamposConfigurador((String[])this.campos.clone());
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "", e.getStackTrace());
        }
    }

    @Override
    public void imprimirPressionado() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        ModeloGridTable modelo = new ModeloGridTable(this.campos);
        Set logRastreabilidadeBeans = new HashSet();
        Set auditoriaTabelaDescricaoLogTabelaBeans = null;
        try {
            StringBuilder sql = new StringBuilder();
            AuditoriaTabelaDescricaoLogBean tabela = this.getTabelaSelecionada();
            if (tabela == null) {
                Funcoes.mensagem(this, "Informe a tabela.", 2);
                this.setCursor(Cursor.getDefaultCursor());
                this.habilitaBotaoImprimir(true);
                return;
            }
            if (!Funcoes.textoVazio(this.getFiltroData(FILTRO_DATA_INICIAL))) {
                this.mensagem = SplashMensagem.getInstancia(this);
                StringBuilder tabelasRelacionadas = new StringBuilder();
                StringBuilder filial = new StringBuilder();
                StringBuilder usuarios = new StringBuilder();
                String[] filialSelecionada = this.getSelecionadosFiltro(FILTRO_FILIAL, 0);
                String[] usuariosSelecionados = this.getSelecionadosFiltro(FILTRO_USUARIO, 0);
                String dataInicial = Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_INICIAL));
                String dataFinal = null;
                if (!Funcoes.textoVazio(this.getFiltroData(FILTRO_DATA_FINAL))) {
                    dataFinal = Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_FINAL));
                }
                try {
                    auditoriaTabelaDescricaoLogTabelaBeans = this.auditoriaTabelaDescricaoLogTabelaService.getListaTabelaRelacionada(tabela.getCodigo());
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel buscar lista de tabelas relacionadas ao log.", e.getStackTrace());
                    return;
                }
                this.montaSqlTabelaRelacionada(tabelasRelacionadas, auditoriaTabelaDescricaoLogTabelaBeans);
                sql.append(" where ras_tabela in (").append((CharSequence)tabelasRelacionadas).append(")");
                sql.append(" and cast(ras_datahora as date) >= '").append(dataInicial).append("'");
                if (dataFinal != null) {
                    sql.append(" and cast(ras_datahora as date) <= '").append(dataFinal).append("'");
                }
                this.montaSqlFilialUsuarioSelecionados(filial, filialSelecionada);
                if (filialSelecionada != null && filialSelecionada.length > 0) {
                    sql.append(" and ras_filialorigem in(").append(filial.toString()).append(")");
                }
                this.montaSqlFilialUsuarioSelecionados(usuarios, usuariosSelecionados);
                if (usuarios != null && !usuarios.toString().isEmpty()) {
                    sql.append(" and ras_loginusuario in(").append((CharSequence)usuarios).append(")");
                }
                if (!Funcoes.textoVazio(this.getFiltroTexto(FILTRO_CHAVES))) {
                    sql.append(" and ras_chave like '%").append(this.getFiltroTexto(FILTRO_CHAVES)).append("%'");
                }
            } else {
                this.setCursor(Cursor.getDefaultCursor());
                Funcoes.mensagem(this, "Informe a data inicial.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            sql.append(" order by ras_filialorigem, ras_datahora");
            logRastreabilidadeBeans = this.rastreabilidadeService.load(sql.toString());
            HashMap<String, Class<?>> classes = this.auditoriaTabelaDescricaoService.getListaClasses(auditoriaTabelaDescricaoLogTabelaBeans);
            if (!logRastreabilidadeBeans.isEmpty()) {
                Object logSelecionado2;
                this.mensagem.mostrar("Aguarde...");
                FilialBean filialBeanLogada = (FilialBean)new FilialService().get(Variaveis.filialPadrao);
                ArrayList<LogRegistroMudanca> mudancaBeanAuxs = new ArrayList<LogRegistroMudanca>();
                for (Object logSelecionado2 : logRastreabilidadeBeans) {
                    String xmlCampos = ((LogRastreabilidadeBean)logSelecionado2).getOperacao();
                    String[] campos = StringUtil.getValores(xmlCampos, "campo");
                    if (campos == null || campos.length == 0) {
                        mudancaBeanAuxs.addAll(AuditoriaLog.carregaCamposNovo((LogRastreabilidadeBean)logSelecionado2, xmlCampos, false));
                    } else {
                        mudancaBeanAuxs.addAll(AuditoriaLog.carregaCamposAntigo((LogRastreabilidadeBean)logSelecionado2, campos, false));
                    }
                    String tabelaBanco = ((LogRastreabilidadeBean)logSelecionado2).getTabela();
                    HashMap<String, String> camposAtributosClasse = this.auditoriaTabelaDescricaoService.montaListaAtributosClasse(tabelaBanco, classes);
                    for (LogRegistroMudanca mudancaBeanAux : mudancaBeanAuxs) {
                        mudancaBeanAux.setCepFilial(filialBeanLogada.getCep());
                        mudancaBeanAux.setCNESFilial(filialBeanLogada.getCnes());
                        mudancaBeanAux.setCnpjFilial(filialBeanLogada.getCnpj());
                        mudancaBeanAux.setCodigoBairroFilial(filialBeanLogada.getBairro() != null ? filialBeanLogada.getBairro().getCodigo() : null);
                        mudancaBeanAux.setCodigoCidadeFilial(filialBeanLogada.getCidade() != null ? filialBeanLogada.getCidade().getCodigo().toString() : null);
                        mudancaBeanAux.setCodigoFilial(filialBeanLogada.getCodigo().toString());
                        mudancaBeanAux.setComplementoFilial(filialBeanLogada.getComplemento());
                        mudancaBeanAux.setDescricaoBairroFilial(filialBeanLogada.getBairro() != null ? filialBeanLogada.getBairro().getDescricao() : null);
                        mudancaBeanAux.setDescricaoCidadeFilial(filialBeanLogada.getCidade() != null ? filialBeanLogada.getCidade().getNome() : null);
                        mudancaBeanAux.setDescricaoFilial(filialBeanLogada.getDescricao());
                        mudancaBeanAux.setEnderecoFilial(filialBeanLogada.getEndereco());
                        mudancaBeanAux.setEstadoCidadeFilial(filialBeanLogada.getCidade() != null ? filialBeanLogada.getCidade().getUf() : null);
                        mudancaBeanAux.setFaxFilial(filialBeanLogada.getFax());
                        mudancaBeanAux.setFoneFilial(filialBeanLogada.getFone());
                        mudancaBeanAux.setRazaoSocialFilial(filialBeanLogada.getRazaoSocial());
                    }
                }
                Class<?> classGenerica = Class.forName(new LogRegistroMudanca().getClass().getCanonicalName());
                logSelecionado2 = mudancaBeanAuxs.iterator();
                while (logSelecionado2.hasNext()) {
                    LogRegistroMudanca mudancaBeanAux;
                    LogRegistroMudanca object = mudancaBeanAux = (LogRegistroMudanca)logSelecionado2.next();
                    Object[] o = new Object[this.campos.length];
                    int i = 0;
                    for (Field fildObject : mudancaBeanAux.getClass().getDeclaredFields()) {
                        fildObject.setAccessible(true);
                        try {
                            Method method = classGenerica.getMethod(this.getMetodo(fildObject), new Class[0]);
                            o[i] = method.getName().equalsIgnoreCase("getTipoOperacao") ? Tipos.getTipoOperacaoLog(method.invoke((Object)object, new Object[0]).toString()) : method.invoke((Object)object, new Object[0]);
                        }
                        catch (Exception e) {
                            ErrorLogger.mostraMensagem(this, "M\u00e9todo n\u00e3o encontrado : " + this.getMetodo(fildObject), e.getStackTrace());
                        }
                        ++i;
                    }
                    modelo.addLine(o);
                }
                if (modelo.getRowCount() > 0) {
                    modelo.ordenarColunaAvancado(modelo.findColumn("codigoLogTabela"), modelo.findColumn("codigoLogTabela"), 1, false);
                }
                sql.delete(0, sql.length());
                sql.append("select rel_xml from relatoriosistema where rel_codigo = ");
                sql.append(RelatorioAuditoriaLog.getModuloAcesso());
                ResultSet resultSetRelatorio = Conexao.executeQuery(Conexao.getStatement(), sql.toString());
                if (resultSetRelatorio.next()) {
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(1.0f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioAuditoriaLog.this.panelCentro.removeAll();
                            RelatorioAuditoriaLog.this.panelCentro.repaint();
                            RelatorioAuditoriaLog.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put(FILTRO_FILIAL, this.getSelecionadosFiltro(FILTRO_FILIAL, 0));
                    var.put(FILTRO_USUARIO, this.getSelecionadosFiltro(FILTRO_USUARIO, 0));
                    var.put(FILTRO_TABELA, this.getFiltroCombo(FILTRO_TABELA).toString());
                    if (!Funcoes.textoVazio(this.getFiltroData(FILTRO_DATA_INICIAL))) {
                        var.put(FILTRO_DATA_INICIAL, Funcoes.formataData("dd/MM/yyyy", this.getFiltroData(FILTRO_DATA_INICIAL)));
                    } else {
                        var.put(FILTRO_DATA_INICIAL, "");
                    }
                    if (!Funcoes.textoVazio(this.getFiltroData(FILTRO_DATA_FINAL))) {
                        var.put(FILTRO_DATA_FINAL, Funcoes.formataData("dd/MM/yyyy", this.getFiltroData(FILTRO_DATA_FINAL)));
                    } else {
                        var.put(FILTRO_DATA_FINAL, "");
                    }
                    var.put(FILTRO_CHAVES, this.getFiltroTexto(FILTRO_CHAVES));
                    gerador.executar(resultSetRelatorio.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                    resultSetRelatorio.close();
                    this.mensagem.apagar();
                } else {
                    Funcoes.mensagem(this, "Relat\u00f3rio n\u00e3o possui layout.", 2);
                    this.habilitaBotaoImprimir(true);
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            this.mensagem.apagar();
        }
        catch (Exception e) {
            this.mensagem.apagar();
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        this.mensagem.apagar();
        this.setCursor(Cursor.getDefaultCursor());
    }

    private String getNomeCidadeFilialLogada(FilialBean filialBeanLogada) {
        if (filialBeanLogada.getCidade() == null) {
            return "";
        }
        return filialBeanLogada.getCidade().getNome();
    }

    private String getDescricaoBairroFilialLogada(FilialBean filialBeanLogada) {
        if (filialBeanLogada.getBairro() == null) {
            return "";
        }
        return filialBeanLogada.getBairro().getDescricao();
    }

    private String getCodigoFilialLogada(FilialBean filialBeanLogada) {
        return filialBeanLogada.getCodigo().toString();
    }

    private String getCodigoCidadeFilialLogada(FilialBean filialBeanLogada) {
        if (filialBeanLogada.getCidade() == null) {
            return "";
        }
        return filialBeanLogada.getCidade().getCodigo().toString();
    }

    private String getCodigoBairroFilialLogada(FilialBean filialBeanLogada) {
        if (filialBeanLogada.getBairro() == null) {
            return "";
        }
        return filialBeanLogada.getBairro().getCodigo();
    }

    private String getMetodo(Field fildObject) {
        return "get" + fildObject.getName().substring(0, 1).toUpperCase() + fildObject.getName().substring(1, fildObject.getName().length());
    }

    private void montaSqlFilialUsuarioSelecionados(StringBuilder sql, String[] listaSelecionados) {
        if (listaSelecionados != null) {
            for (String selecionado : listaSelecionados) {
                sql.append("'");
                sql.append(selecionado);
                sql.append("'");
            }
        }
        if (!sql.toString().isEmpty()) {
            String temp = sql.toString();
            sql.setLength(0);
            sql.append(temp.replaceAll("''", "','"));
        }
    }

    private void montaSqlTabelaRelacionada(StringBuilder tabelasRelacionadas, Set<AuditoriaTabelaDescricaoLogTabelaBean> auditoriaTabelaDescricaoLogTabelaBeans) {
        for (AuditoriaTabelaDescricaoLogTabelaBean auditoriaTabelaDescricaoLogTabelaBean : auditoriaTabelaDescricaoLogTabelaBeans) {
            tabelasRelacionadas.append("'");
            tabelasRelacionadas.append(auditoriaTabelaDescricaoLogTabelaBean.getTabela().trim());
            tabelasRelacionadas.append("'");
        }
        if (!tabelasRelacionadas.toString().isEmpty()) {
            String temp = tabelasRelacionadas.toString();
            tabelasRelacionadas.setLength(0);
            tabelasRelacionadas.append(temp.replaceAll("''", "','"));
        }
    }

    private AuditoriaTabelaDescricaoLogBean getTabelaSelecionada() {
        return (AuditoriaTabelaDescricaoLogBean)this.getFiltroCombo(FILTRO_TABELA);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0880500100");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0880500101");
    }
}

