/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.gerencial.relatoriotempomedioatendimento;

import jalis.laboratorio.relatorios.gerencial.relatoriotempomedioatendimento.RelatorioTempoMedioAtendimentoDao;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.tabela.Registro;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.postgresql.util.PGInterval;

public class RelatorioTempoMedioAtendimentoService {
    private static final int SEGUNDOS_MINUTO = 60;
    private static final int SEGUNGOS_HORA = 3600;
    private static final int SEGUNDOS_DIA = 86400;
    private static final int SEGUNDOS_MES = 2592000;
    private static final int SEGUNDOS_ANO = 31104000;
    private final RelatorioTempoMedioAtendimentoDao dao;
    private final String[] campos = new String[]{"codigoConvenio", "codigoFilial", "descricaoFilial", "fantasiaConvenio", "mediaTempoMaximoEntregaExame", "mediaTempoMinimoEntregaExame", "mediaTempoTotalAteColetaExame", "mediaTempoTotalAteDigitacaoExame", "mediaTempoTotalAteConferenciaExame", "mediaTempoTotalAteImpressaoExame", "mediaTempoTotalColetaAteImpressaoExameRequisicao", "mediaTempoTotalColetaAteImpressaoExameRequisicaoDia", "quantidadeExameRequisicao", "quantidadeRequisicao", "somaTempoTotalAteImpressaoExame", "tempototalatecoletaexame", "tempototalatedigitacaoexame", "tempototalateconferenciaexame", "tempototalateimpressaoexame", "somatempototalateconferenciaexame", "mediaTempoTotalColetaAteConferenciaExameRequisicao", "mediaTempoTotalColetaAteConferenciaExameRequisicaoDia"};
    private String[] filiaisSelecionadas;
    private String[] conveniosSelecionados;
    private String[] setoresSelecionados;
    private String[] estacoesSelecionadas;
    private String[] coletasSelecionadas;
    private String[] examesSelecionados;
    private String[] materiaisSelecionados;
    private String[] conselhosSelecionados;
    private String[] crmsSelecionados;
    private String[] ufsSelecionados;
    private String[] pacientesSelecionados;
    private String[] usuariosSelecionados;
    private String dataInicialInformada;
    private String dataFinalInformada;
    private String horaInicialInformada;
    private String horaFinalInformada;
    private ModeloGridTable modelo;
    private List<Registro> registros = new ArrayList<Registro>();

    public RelatorioTempoMedioAtendimentoService() {
        this.dao = new RelatorioTempoMedioAtendimentoDao();
    }

    private void definirFiltrosSelecionadosPeloUsuario() {
        this.dao.setFiliaisSelecionadas(this.filiaisSelecionadas);
        this.dao.setConveniosSelecionados(this.conveniosSelecionados);
        this.dao.setSetoresSelecionados(this.setoresSelecionados);
        this.dao.setEstacoesSelecionadas(this.estacoesSelecionadas);
        this.dao.setColetasSelecionadas(this.coletasSelecionadas);
        this.dao.setExamesSelecionados(this.examesSelecionados);
        this.dao.setMateriaisSelecionados(this.materiaisSelecionados);
        this.dao.setConselhosSelecionados(this.conselhosSelecionados);
        this.dao.setCrmsSelecionados(this.crmsSelecionados);
        this.dao.setUfsSelecionados(this.ufsSelecionados);
        this.dao.setPacientesSelecionados(this.pacientesSelecionados);
        this.dao.setUsuariosSelecionados(this.usuariosSelecionados);
        this.dao.setDataInicialInformada(this.dataInicialInformada);
        this.dao.setDataFinalInformada(this.dataFinalInformada);
        this.dao.setHoraInicialInformada(this.horaInicialInformada);
        this.dao.setHoraFinalInformada(this.horaFinalInformada);
    }

    public int getQuantidadeDeDiasComRequisicao() throws SQLException {
        return this.dao.getQuantidadeDiasComRequisicao();
    }

    public String getLayoutRelatorio(long codigoModuloAcesso) throws SQLException {
        return this.dao.getLayoutRelatorio(codigoModuloAcesso);
    }

    public String getMedicosSelecionados() {
        StringBuilder medicosSelecionados = new StringBuilder();
        if (this.medicoSelecionado()) {
            for (int i = 0; i < this.conselhosSelecionados.length; ++i) {
                medicosSelecionados.append(this.conselhosSelecionados[i]).append(": ");
                medicosSelecionados.append(this.crmsSelecionados[i]);
                medicosSelecionados.append("(").append(this.ufsSelecionados[i]).append(") ");
            }
        }
        return medicosSelecionados.toString();
    }

    public boolean modeloPreenchido() throws SQLException {
        this.definirFiltrosSelecionadosPeloUsuario();
        this.modelo = new ModeloGridTable(this.campos);
        this.registros = this.dao.recuperarDados();
        Object linhas = null;
        if (!this.registros.isEmpty()) {
            for (Registro registro : this.registros) {
                this.converterRegistroParaModelo(registro);
            }
            return true;
        }
        return false;
    }

    private void converterRegistroParaModelo(Registro registro) throws SQLException {
        PGInterval mediaTempoMaximo = this.calcularMediaTotalPorQuantidadeDeExames(this.campos[4]);
        PGInterval mediaTempoMinimo = this.calcularMediaTotalPorQuantidadeDeExames(this.campos[5]);
        PGInterval mediaTempoTotalColetaAteImpressaoExameRequisicao = this.calcularMediaTotalPorQuantidadeDeExames(this.campos[14]);
        PGInterval mediaTempoTotalColetaAteImpressaoExameRequisicaoDia = this.calcularMediaTempoTotalPorExameRequisicaoDia(this.campos[14]);
        PGInterval mediaTempoTotalColetaAteConferenciaExameRequisicao = this.calcularMediaTotalPorQuantidadeDeExames(this.campos[19]);
        PGInterval mediaTempoTotalColetaAteConferenciaExameRequisicaoDia = this.calcularMediaTempoTotalPorExameRequisicaoDia(this.campos[19]);
        PGInterval mediaTempoTotalAteColetaExame = this.calcularTempoMedioPorConvenio(registro, this.campos[15]);
        PGInterval mediaTempoTotalAteDigitacaoExame = this.calcularTempoMedioPorConvenio(registro, this.campos[16]);
        PGInterval mediaTempoTotalAteConferenciaExame = this.calcularTempoMedioPorConvenio(registro, this.campos[17]);
        PGInterval mediaTempoTotalAteImpressaoExame = this.calcularTempoMedioPorConvenio(registro, this.campos[18]);
        Object[] o = new Object[this.campos.length];
        o[0] = registro.getValor(this.campos[0].toLowerCase());
        o[1] = registro.getValor(this.campos[1].toLowerCase());
        o[2] = registro.getValor(this.campos[2].toLowerCase());
        o[3] = registro.getValor(this.campos[3].toLowerCase());
        o[4] = RelatorioTempoMedioAtendimentoService.converterIntervaloParaString(mediaTempoMaximo);
        o[5] = RelatorioTempoMedioAtendimentoService.converterIntervaloParaString(mediaTempoMinimo);
        o[6] = RelatorioTempoMedioAtendimentoService.converterHorasDoIntervaloParaString(mediaTempoTotalAteColetaExame);
        o[7] = RelatorioTempoMedioAtendimentoService.converterHorasDoIntervaloParaString(mediaTempoTotalAteDigitacaoExame);
        o[8] = RelatorioTempoMedioAtendimentoService.converterHorasDoIntervaloParaString(mediaTempoTotalAteConferenciaExame);
        o[9] = RelatorioTempoMedioAtendimentoService.converterHorasDoIntervaloParaString(mediaTempoTotalAteImpressaoExame);
        o[10] = RelatorioTempoMedioAtendimentoService.converterIntervaloParaString(mediaTempoTotalColetaAteImpressaoExameRequisicao);
        o[11] = RelatorioTempoMedioAtendimentoService.converterIntervaloParaString(mediaTempoTotalColetaAteImpressaoExameRequisicaoDia);
        o[12] = registro.getValor(this.campos[12].toLowerCase());
        o[13] = registro.getValor(this.campos[13].toLowerCase());
        o[14] = registro.getValor(this.campos[14].toLowerCase());
        o[15] = registro.getValor(this.campos[15].toLowerCase());
        o[16] = registro.getValor(this.campos[16].toLowerCase());
        o[17] = registro.getValor(this.campos[17].toLowerCase());
        o[18] = registro.getValor(this.campos[18].toLowerCase());
        o[19] = registro.getValor(this.campos[19].toLowerCase());
        o[20] = RelatorioTempoMedioAtendimentoService.converterIntervaloParaString(mediaTempoTotalColetaAteConferenciaExameRequisicao);
        o[21] = RelatorioTempoMedioAtendimentoService.converterIntervaloParaString(mediaTempoTotalColetaAteConferenciaExameRequisicaoDia);
        this.modelo.addLine(o);
    }

    private PGInterval calcularTempoMedioPorConvenio(Registro registro, String campo) {
        long segundos = 0L;
        long media = 0L;
        segundos = this.getSegundosPorIntervalo((PGInterval)registro.getValor(campo.toLowerCase()));
        long quantidadeExamesConvenio = (Long)registro.getValor(this.campos[12].toLowerCase());
        media = segundos / quantidadeExamesConvenio;
        return this.getIntervaloPorSegundos(media);
    }

    private PGInterval calcularMediaTotalPorQuantidadeDeExames(String campo) {
        long segundosTotais = this.getSegundosTotaisDosRegistros(campo);
        int quantidadeTotalExames = this.getQuantidadeTotalDeExamesDosRegistros();
        long media = segundosTotais / (long)quantidadeTotalExames;
        return this.getIntervaloPorSegundos(media);
    }

    private PGInterval calcularMediaTempoTotalPorExameRequisicaoDia(String campo) throws SQLException {
        long media = 0L;
        int quantidadeDiasComRequisicao = this.getQuantidadeDeDiasComRequisicao();
        long segundosTotais = this.getSegundosTotaisDosRegistros(campo);
        int quantidadeTotalExames = this.getQuantidadeTotalDeExamesDosRegistros();
        media = segundosTotais / (long)quantidadeTotalExames / (long)quantidadeDiasComRequisicao;
        return this.getIntervaloPorSegundos(media);
    }

    private long getSegundosTotaisDosRegistros(String campo) {
        long segundosTotais = 0L;
        for (Registro registro : this.registros) {
            for (String reg : registro.getKeySet()) {
                segundosTotais += reg.equalsIgnoreCase(campo.toLowerCase()) ? this.getSegundosPorIntervalo((PGInterval)registro.getValor(reg)) : 0L;
            }
        }
        return segundosTotais;
    }

    private int getQuantidadeTotalDeExamesDosRegistros() {
        int quantidadeTotalExames = 0;
        for (Registro registro : this.registros) {
            for (String reg : registro.getKeySet()) {
                quantidadeTotalExames = (int)((long)quantidadeTotalExames + (reg.equalsIgnoreCase(this.campos[12]) ? (Long)registro.getValor(reg) : 0L));
            }
        }
        return quantidadeTotalExames;
    }

    private long getSegundosPorIntervalo(PGInterval interval) {
        if (interval == null) {
            return 0L;
        }
        long intervaloSegundos = 0L;
        intervaloSegundos = (long)((double)intervaloSegundos + interval.getSeconds());
        intervaloSegundos += (long)(interval.getMinutes() * 60);
        intervaloSegundos += (long)(interval.getHours() * 3600);
        intervaloSegundos += (long)(interval.getDays() * 86400);
        intervaloSegundos += (long)(interval.getMonths() * 2592000);
        if ((intervaloSegundos += (long)(interval.getYears() * 31104000)) < 0L) {
            intervaloSegundos = 0L;
        }
        return intervaloSegundos;
    }

    private PGInterval getIntervaloPorSegundos(long intervaloSegundos) {
        int anos = (int)(intervaloSegundos / 31104000L);
        int meses = (int)((intervaloSegundos -= (long)(anos * 31104000)) / 2592000L);
        int dias = (int)((intervaloSegundos -= (long)(meses * 2592000)) / 86400L);
        int horas = (int)((intervaloSegundos -= (long)(dias * 86400)) / 3600L);
        int minutos = (int)((intervaloSegundos -= (long)(horas * 3600)) / 60L);
        return new PGInterval(anos, meses, dias, horas, minutos, (double)(intervaloSegundos -= (long)(minutos * 60)));
    }

    private static String converterHorasDoIntervaloParaString(PGInterval interval) {
        if (interval == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        buf.append(Funcoes.preencheZero(Math.abs(interval.getHours()), 2)).append(":");
        buf.append(Funcoes.preencheZero(Math.abs(interval.getMinutes()), 2)).append(":");
        buf.append(Funcoes.preencheZero(Math.abs((int)interval.getSeconds()), 2));
        return buf.toString();
    }

    private static String converterIntervaloParaString(PGInterval interval) {
        if (interval != null) {
            StringBuilder bi = new StringBuilder();
            bi.append(interval.getYears()).append(" Anos, ");
            bi.append(interval.getMonths()).append(" Meses, ");
            bi.append(interval.getDays()).append(" Dias, ");
            bi.append(Funcoes.preencheZero(interval.getHours(), 2)).append(":");
            bi.append(Funcoes.preencheZero(interval.getMinutes(), 2)).append(":");
            bi.append(Funcoes.preencheZero((int)interval.getSeconds(), 2));
            return bi.toString();
        }
        return null;
    }

    private boolean medicoSelecionado() {
        return this.conselhosSelecionados != null && this.conselhosSelecionados.length > 0 && this.ufsSelecionados != null && this.ufsSelecionados.length > 0 && this.crmsSelecionados != null && this.crmsSelecionados.length > 0;
    }

    public String[] getCampos() {
        return this.campos;
    }

    public String[] getFiliaisSelecionadas() {
        return this.filiaisSelecionadas;
    }

    public void setFiliaisSelecionadas(String[] filiaisSelecionadas) {
        this.filiaisSelecionadas = filiaisSelecionadas;
    }

    public String[] getConveniosSelecionados() {
        return this.conveniosSelecionados;
    }

    public void setConveniosSelecionados(String[] conveniosSelecionados) {
        this.conveniosSelecionados = conveniosSelecionados;
    }

    public String[] getSetoresSelecionados() {
        return this.setoresSelecionados;
    }

    public void setSetoresSelecionados(String[] setoresSelecionados) {
        this.setoresSelecionados = setoresSelecionados;
    }

    public String[] getEstacoesSelecionadas() {
        return this.estacoesSelecionadas;
    }

    public void setEstacoesSelecionadas(String[] estacoesSelecionadas) {
        this.estacoesSelecionadas = estacoesSelecionadas;
    }

    public String[] getColetasSelecionadas() {
        return this.coletasSelecionadas;
    }

    public void setColetasSelecionadas(String[] coletasSelecionadas) {
        this.coletasSelecionadas = coletasSelecionadas;
    }

    public String[] getExamesSelecionados() {
        return this.examesSelecionados;
    }

    public void setExamesSelecionados(String[] examesSelecionados) {
        this.examesSelecionados = examesSelecionados;
    }

    public String[] getMateriaisSelecionados() {
        return this.materiaisSelecionados;
    }

    public void setMateriaisSelecionados(String[] materiaisSelecionados) {
        this.materiaisSelecionados = materiaisSelecionados;
    }

    public String[] getConselhosSelecionados() {
        return this.conselhosSelecionados;
    }

    public void setConselhosSelecionados(String[] conselhosSelecionados) {
        this.conselhosSelecionados = conselhosSelecionados;
    }

    public String[] getCrmsSelecionados() {
        return this.crmsSelecionados;
    }

    public void setCrmsSelecionados(String[] crmsSelecionados) {
        this.crmsSelecionados = crmsSelecionados;
    }

    public String[] getUfsSelecionados() {
        return this.ufsSelecionados;
    }

    public void setUfsSelecionados(String[] ufsSelecionados) {
        this.ufsSelecionados = ufsSelecionados;
    }

    public String[] getPacientesSelecionados() {
        return this.pacientesSelecionados;
    }

    public void setPacientesSelecionados(String[] pacientesSelecionados) {
        this.pacientesSelecionados = pacientesSelecionados;
    }

    public String[] getUsuariosSelecionados() {
        return this.usuariosSelecionados;
    }

    public void setUsuariosSelecionados(String[] usuariosSelecionados) {
        this.usuariosSelecionados = usuariosSelecionados;
    }

    public String getDataInicialInformada() {
        return this.dataInicialInformada;
    }

    public void setDataInicialInformada(String dataInicialInformada) {
        this.dataInicialInformada = dataInicialInformada;
    }

    public String getDataFinalInformada() {
        return this.dataFinalInformada;
    }

    public void setDataFinalInformada(String dataFinalInformada) {
        this.dataFinalInformada = dataFinalInformada;
    }

    public String getHoraInicialInformada() {
        return this.horaInicialInformada;
    }

    public void setHoraInicialInformada(String horaInicialInformada) {
        this.horaInicialInformada = horaInicialInformada;
    }

    public String getHoraFinalInformada() {
        return this.horaFinalInformada;
    }

    public void setHoraFinalInformada(String horaFinalInformada) {
        this.horaFinalInformada = horaFinalInformada;
    }

    public ModeloGridTable getModelo() {
        return this.modelo;
    }
}

