/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.gerencial.relatoriotempomedioatendimento;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.util.Funcoes;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class RelatorioTempoMedioAtendimentoDao {
    private String[] filiaisSelecionadas;
    private String[] conveniosSelecionados;
    private String[] setoresSelecionados;
    private String[] estacoesSelecionadas;
    private String[] coletasSelecionadas;
    private String[] examesSelecionados;
    private String[] materiaisSelecionados;
    private String[] conselhosSelecionados;
    private String[] crmsSelecionados;
    private String[] ufsSelecionados;
    private String[] pacientesSelecionados;
    private String[] usuariosSelecionados;
    private String dataInicialInformada;
    private String dataFinalInformada;
    private String horaInicialInformada;
    private String horaFinalInformada;

    public List<Registro> recuperarDados() throws SQLException {
        Statement st = Conexao.getStatement();
        ResultSet resultadoConsulta = Conexao.executeQuery(st, this.getSqlRelatorio());
        ArrayList<Registro> registros = new ArrayList<Registro>();
        while (resultadoConsulta.next()) {
            registros.add(new Registro(resultadoConsulta));
        }
        return registros;
    }

    private String getSqlRelatorio() {
        StringBuilder sqlRelatorio = new StringBuilder();
        sqlRelatorio.append(this.getSqlSelect());
        sqlRelatorio.append(this.getSqlSelectSub());
        sqlRelatorio.append(this.getSqlFromSub());
        sqlRelatorio.append(this.getSqlWhereSub());
        sqlRelatorio.append(this.getSqlGroupBySub());
        sqlRelatorio.append(this.getSqlGroupBy());
        sqlRelatorio.append(this.getSqlOrderBy());
        return sqlRelatorio.toString();
    }

    private String getSqlSelect() {
        StringBuilder sqlSelect = new StringBuilder("select ");
        sqlSelect.append("s.fil_codigo as codigofilial, ");
        sqlSelect.append("s.fil_descricao as descricaofilial, ");
        sqlSelect.append("s.con_codigo as codigoconvenio, ");
        sqlSelect.append("s.con_fantasia as fantasiaconvenio, ");
        sqlSelect.append("count(distinct(s.req_codigo || s.exa_codigo || s.mco_codigo)) as quantidadeexamerequisicao, ");
        sqlSelect.append("count(distinct(s.req_codigo)) as quantidaderequisicao,  ");
        sqlSelect.append("coalesce(sum(age(s.exr_datamaterial, (s.req_data + s.req_hora))),'00:00:00') as tempototalatecoletaexame, ");
        sqlSelect.append("coalesce(sum(age(s.exr_datadigita, s.exr_datamaterial)),'00:00:00') as tempototalatedigitacaoexame, ");
        sqlSelect.append("coalesce(sum(age(s.exr_dataassina, s.exr_datadigita)),'00:00:00') as tempototalateconferenciaexame, ");
        sqlSelect.append("coalesce(sum(age(s.exr_dataimpresso, s.exr_dataassina)), '00:00:00') as tempototalateimpressaoexame, ");
        sqlSelect.append("coalesce(sum(age(s.exr_dataimpresso, (s.req_data + s.req_hora))),'00:00:00') as somatempototalateimpressaoexame, ");
        sqlSelect.append("coalesce(sum(age(s.exr_dataassina, (s.req_data + s.req_hora))), '00:00:00') as somatempototalateconferenciaexame, ");
        sqlSelect.append("coalesce(min(age(s.exr_dataentreguerst, (s.req_data + s.req_hora))),'00:00:00') as mediaTempoMinimoEntregaExame, ");
        sqlSelect.append("coalesce(max(age(s.exr_dataentreguerst, (s.req_data + s.req_hora))),'00:00:00') as mediaTempoMaximoEntregaExame, ");
        sqlSelect.append("0 as mediatempototalatecoletaexame, ");
        sqlSelect.append("0 as mediatempototalatedigitacaoexame, ");
        sqlSelect.append("0 as mediatempototalateconferenciaexame, ");
        sqlSelect.append("0 as mediatempototalateimpressaoexame, ");
        sqlSelect.append("0 as mediaTempoTotalColetaAteImpressaoExameRequisicao, ");
        sqlSelect.append("0 as mediaTempoTotalColetaAteImpressaoExameRequisicaoDia ");
        return sqlSelect.toString();
    }

    private String getSqlSelectSub() {
        StringBuilder sqlSelectSub = new StringBuilder(" from ( select ");
        sqlSelectSub.append("filial.fil_codigo, filial.fil_descricao, c.con_codigo, c.con_fantasia, er.req_codigo, er.exa_codigo, er.mco_codigo, ");
        sqlSelectSub.append("r.req_data, r.req_hora, er.exr_datamaterial, er.exr_datadigita, er.exr_dataassina, er.exr_dataimpresso, er.exr_dataentreguerst ");
        return sqlSelectSub.toString();
    }

    private String getSqlFromSub() {
        StringBuilder sqlFrom = new StringBuilder("from ");
        sqlFrom.append("requisicao r left join examerequisicao er ");
        sqlFrom.append("on r.fil_codigo = er.fil_codigo and r.req_codigo = er.req_codigo ");
        sqlFrom.append("left join filiais_postocoleta filial ");
        sqlFrom.append("on r.fil_codigo = filial.fil_codigo ");
        sqlFrom.append("left join convenios c  ");
        sqlFrom.append("on r.fil_codigo = c.fil_codigo and r.con_codigo = c.con_codigo ");
        sqlFrom.append("left join examesetor es ");
        sqlFrom.append("on er.fil_codigo = es.fil_codigo and er.exa_codigo = es.exa_codigo ");
        return sqlFrom.toString();
    }

    private String getSqlWhereSub() {
        StringBuilder sqlWhere = new StringBuilder("where ");
        sqlWhere.append(this.filialIn());
        sqlWhere.append(this.convenioIn());
        sqlWhere.append(this.setorIn());
        sqlWhere.append(this.estacaoIn());
        sqlWhere.append(this.coletaIn());
        sqlWhere.append(this.exameIn());
        sqlWhere.append(this.materialColetadoIn());
        sqlWhere.append(this.pacienteIn());
        sqlWhere.append(this.usuarioIn());
        sqlWhere.append(this.medicoIn());
        sqlWhere.append(this.dataBetween());
        sqlWhere.append(" and r.req_excluida = false");
        sqlWhere.append(" and er.exr_excluido = false");
        return sqlWhere.toString();
    }

    private String getSqlGroupBy() {
        StringBuilder groupBy = new StringBuilder(" group by ");
        groupBy.append("s.fil_codigo, s.fil_descricao, s.con_codigo,s.con_fantasia ");
        return groupBy.toString();
    }

    private String getSqlGroupBySub() {
        StringBuilder groupBySub = new StringBuilder(" group by ");
        groupBySub.append(" filial.fil_codigo, filial.fil_descricao, c.con_codigo, c.con_fantasia, er.req_codigo, er.exa_codigo, er.mco_codigo, ");
        groupBySub.append("r.req_data, r.req_hora, er.exr_datamaterial, er.exr_datadigita, er.exr_dataassina, er.exr_dataimpresso, er.exr_dataentreguerst ) as s ");
        return groupBySub.toString();
    }

    private String getSqlOrderBy() {
        StringBuilder orderBy = new StringBuilder(" order by ");
        orderBy.append("s.fil_codigo, s.con_codigo");
        return orderBy.toString();
    }

    private String filialIn() {
        StringBuilder filialIn = new StringBuilder("r.fil_codigo in(");
        if (this.filiaisSelecionadas == null || this.filiaisSelecionadas.length <= 0) {
            this.filiaisSelecionadas = new String[]{Variaveis.filialPadrao};
        }
        filialIn.append(this.getCondicoesIntegerIn(this.filiaisSelecionadas));
        return filialIn.toString();
    }

    private String convenioIn() {
        StringBuilder convenioIn = new StringBuilder();
        if (this.conveniosSelecionados != null && this.conveniosSelecionados.length > 0) {
            convenioIn.append(" and r.con_codigo in (");
            convenioIn.append(this.getCondicoesIntegerIn(this.conveniosSelecionados));
        }
        return convenioIn.toString();
    }

    private String setorIn() {
        StringBuilder setorIn = new StringBuilder();
        if (this.setoresSelecionados != null && this.setoresSelecionados.length > 0) {
            setorIn.append(" and es.set_codigo in (");
            setorIn.append(this.getCondicoesIntegerIn(this.setoresSelecionados));
        }
        return setorIn.toString();
    }

    private String estacaoIn() {
        StringBuilder estacaoIn = new StringBuilder();
        if (this.estacoesSelecionadas != null && this.estacoesSelecionadas.length > 0) {
            estacaoIn.append(" and r.est_codigo in (");
            estacaoIn.append(this.getCondicoesIntegerIn(this.estacoesSelecionadas));
        }
        return estacaoIn.toString();
    }

    private String coletaIn() {
        StringBuilder coletaIn = new StringBuilder();
        if (this.coletasSelecionadas != null && this.coletasSelecionadas.length > 0) {
            coletaIn.append(" and r.col_codigo in ('");
            coletaIn.append(this.getCondicoesStringIn(this.coletasSelecionadas));
        }
        return coletaIn.toString();
    }

    private String exameIn() {
        StringBuilder exameIn = new StringBuilder();
        if (this.examesSelecionados != null && this.examesSelecionados.length > 0) {
            exameIn.append(" and er.exa_codigo in ('");
            exameIn.append(this.getCondicoesStringIn(this.examesSelecionados));
        }
        return exameIn.toString();
    }

    private String materialColetadoIn() {
        StringBuilder materialColetadoIn = new StringBuilder();
        if (this.materiaisSelecionados != null && this.materiaisSelecionados.length > 0) {
            materialColetadoIn.append(" and er.mco_codigo in (");
            materialColetadoIn.append(this.getCondicoesIntegerIn(this.materiaisSelecionados));
        }
        return materialColetadoIn.toString();
    }

    private String pacienteIn() {
        StringBuilder pacienteIn = new StringBuilder();
        if (this.pacientesSelecionados != null && this.pacientesSelecionados.length > 0) {
            pacienteIn.append(" and r.pac_codigo in (");
            pacienteIn.append(this.getCondicoesIntegerIn(this.pacientesSelecionados));
        }
        return pacienteIn.toString();
    }

    private String usuarioIn() {
        StringBuilder usuarioIn = new StringBuilder();
        if (this.usuariosSelecionados != null && this.usuariosSelecionados.length > 0) {
            usuarioIn.append(" and r.usr_codigo in ('");
            usuarioIn.append(this.getCondicoesStringIn(this.usuariosSelecionados));
        }
        return usuarioIn.toString();
    }

    private String medicoIn() {
        StringBuilder medicoIn = new StringBuilder();
        if (this.medicoSelecionado()) {
            medicoIn.append(" and (");
            for (int i = 0; i < this.conselhosSelecionados.length; ++i) {
                medicoIn.append(i == 0 ? "" : " or ");
                medicoIn.append("(r.med_conselho = '").append(this.conselhosSelecionados[i]);
                medicoIn.append("' and r.med_uf = '").append(this.ufsSelecionados[i]);
                medicoIn.append("' and r.med_crm = '").append(this.crmsSelecionados[i]);
                medicoIn.append("')");
            }
            medicoIn.append(")");
        }
        return medicoIn.toString();
    }

    private String dataBetween() {
        StringBuilder data = new StringBuilder();
        if (this.datasInformadas()) {
            String horaInicial = this.getHoraInicial();
            String horaFinal = this.getHoraFinal();
            data.append(" and (r.req_data + r.req_hora) between '");
            data.append(Funcoes.formataData("yyyy-MM-dd", this.dataInicialInformada)).append(" ").append(horaInicial).append("'");
            data.append(" and '");
            data.append(Funcoes.formataData("yyyy-MM-dd", this.dataFinalInformada)).append(" ").append(horaFinal).append("'");
        }
        return data.toString();
    }

    private boolean datasInformadas() {
        return this.dataInicialInformada != null && Funcoes.verificaData(this.dataInicialInformada) && this.dataFinalInformada != null && Funcoes.verificaData(this.dataFinalInformada);
    }

    private String getHoraInicial() {
        return this.horaInicialInformada != null && Funcoes.verificaHora(this.horaInicialInformada) ? this.horaInicialInformada : "00:00";
    }

    private String getHoraFinal() {
        return this.horaFinalInformada != null && Funcoes.verificaHora(this.horaFinalInformada) ? this.horaFinalInformada : "23:59";
    }

    private String getCondicoesIntegerIn(String[] condicoesInteger) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < condicoesInteger.length; ++i) {
            sb.append(condicoesInteger[i]);
            if (i >= condicoesInteger.length - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    private String getCondicoesStringIn(String[] condicoesString) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < condicoesString.length; ++i) {
            sb.append(condicoesString[i].replaceAll("'", "''").trim());
            sb.append(i < condicoesString.length - 1 ? "','" : "'");
        }
        sb.append(")");
        return sb.toString();
    }

    public String getLayoutRelatorio(long codigoModuloAcesso) throws SQLException {
        String layout = "";
        StringBuilder builder = new StringBuilder();
        builder.append("select rel_xml from relatoriosistema where rel_codigo = ");
        builder.append(codigoModuloAcesso);
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), builder.toString());
        if (rs.next()) {
            layout = rs.getString("rel_xml");
        }
        return layout;
    }

    public int getQuantidadeDiasComRequisicao() throws SQLException {
        int quantidadeDiasComRequisicao = 0;
        StringBuilder builder = new StringBuilder();
        builder.append("select count(distinct(r.req_data)) as quantidadeDias ");
        builder.append(this.getSqlFromSub());
        builder.append(this.getSqlWhereSub());
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), builder.toString());
        if (rs.next()) {
            quantidadeDiasComRequisicao = rs.getInt("quantidadeDias");
        }
        return quantidadeDiasComRequisicao;
    }

    private boolean medicoSelecionado() {
        return this.conselhosSelecionados != null && this.conselhosSelecionados.length > 0 && this.ufsSelecionados != null && this.ufsSelecionados.length > 0 && this.crmsSelecionados != null && this.crmsSelecionados.length > 0;
    }

    public void setFiliaisSelecionadas(String[] filiaisSelecionadas) {
        this.filiaisSelecionadas = filiaisSelecionadas;
    }

    public void setConveniosSelecionados(String[] conveniosSelecionados) {
        this.conveniosSelecionados = conveniosSelecionados;
    }

    public void setSetoresSelecionados(String[] setoresSelecionados) {
        this.setoresSelecionados = setoresSelecionados;
    }

    public void setEstacoesSelecionadas(String[] estacoesSelecionadas) {
        this.estacoesSelecionadas = estacoesSelecionadas;
    }

    public void setColetasSelecionadas(String[] coletasSelecionadas) {
        this.coletasSelecionadas = coletasSelecionadas;
    }

    public void setExamesSelecionados(String[] examesSelecionados) {
        this.examesSelecionados = examesSelecionados;
    }

    public void setMateriaisSelecionados(String[] materiaisSelecionados) {
        this.materiaisSelecionados = materiaisSelecionados;
    }

    public String[] getConselhosSelecionados() {
        return this.conselhosSelecionados;
    }

    public void setConselhosSelecionados(String[] conselhosSelecionados) {
        this.conselhosSelecionados = conselhosSelecionados;
    }

    public void setCrmsSelecionados(String[] crmsSelecionados) {
        this.crmsSelecionados = crmsSelecionados;
    }

    public void setUfsSelecionados(String[] ufsSelecionados) {
        this.ufsSelecionados = ufsSelecionados;
    }

    public void setPacientesSelecionados(String[] pacientesSelecionados) {
        this.pacientesSelecionados = pacientesSelecionados;
    }

    public void setUsuariosSelecionados(String[] usuariosSelecionados) {
        this.usuariosSelecionados = usuariosSelecionados;
    }

    public void setDataInicialInformada(String dataInicialInformada) {
        this.dataInicialInformada = dataInicialInformada;
    }

    public void setDataFinalInformada(String dataFinalInformada) {
        this.dataFinalInformada = dataFinalInformada;
    }

    public void setHoraInicialInformada(String horaInicialInformada) {
        this.horaInicialInformada = horaInicialInformada;
    }

    public void setHoraFinalInformada(String horaFinalInformada) {
        this.horaFinalInformada = horaFinalInformada;
    }
}

