/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.gerencial.relatoriotempomedioatendimento;

import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.gerencial.relatoriotempomedioatendimento.RelatorioTempoMedioAtendimentoService;
import jalis.relatorio.Gerador;
import jalis.util.CheckItemFiltro;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableModel;

public class RelatorioTempoMedioAtendimento
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private static final String RELATORIO_ICONE = "relatorios/rel_tempo_medio_de_atendimento.jpg";
    private static final String RELATORIO_DESCRITIVO = "Listagem do tempo m\u00e9dio de atendimento";
    private static final String RELATORIO_TITULO = "Relat\u00f3rio de tempo m\u00e9dio de atendimento";
    private static final String FILTRO_FILIAL = "filtroFilial";
    private static final String FILTRO_CONVENIO = "filtroConvenio";
    private static final String FILTRO_SETOR = "filtroSetor";
    private static final String FILTRO_ESTACAO = "filtroEstacao";
    private static final String FILTRO_COLETA = "filtroColeta";
    private static final String FILTRO_EXAME = "filtroExame";
    private static final String FILTRO_MATERIAL = "filtroMaterial";
    private static final String FILTRO_MEDICO = "filtroMedico";
    private static final String FILTRO_PACIENTE = "filtroPaciente";
    private static final String FILTRO_USUARIO = "filtroUsuario";
    private static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private static final String FILTRO_HORA_INICIAL = "filtroHoraInicial";
    private static final String FILTRO_HORA_FINAL = "filtroHoraFinal";
    private static final long MODULO_ACESSO_CODIGO = Long.parseLong("0880401300");
    private static final long MODULO_CONFIGURAR_CODIGO = Long.parseLong("0880401301");
    private final RelatorioTempoMedioAtendimentoService service = new RelatorioTempoMedioAtendimentoService();

    public RelatorioTempoMedioAtendimento() {
        this.setName("RelatorioTempoMedioAtendimento");
        this.montaBarraDescricao(RELATORIO_TITULO, RELATORIO_DESCRITIVO, RELATORIO_ICONE);
        this.adicionaRelatorioListener(this);
        this.adicionarFiltros();
        this.adicionarCheckItemFiltros();
        this.adicionarFiltrosAvancados();
        this.adicionarFiltrosPorData();
        this.adicionarFiltrosPorHora();
        this.setModuloConfigurar(RelatorioTempoMedioAtendimento.getModuloConfigurar());
        this.setModuloAcesso(RelatorioTempoMedioAtendimento.getModuloAcesso());
        this.setCamposConfigurador(this.service.getCampos());
    }

    private void adicionarFiltros() {
        this.adicionaItemFiltro(FILTRO_FILIAL, "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_CONVENIO, "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_SETOR, "Setor", "setores", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_COLETA, "Coleta", "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_EXAME, "Exame", "exames", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_MATERIAL, "Material", "materialcoleta", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"mco_codigo", "mco_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
    }

    private void adicionarFiltrosAvancados() {
        this.adicionaItemFiltroAvancado(FILTRO_MEDICO, "M\u00e9dico", "medico", "fil_codigo = " + Variaveis.filialPadrao, 4, new String[]{"med_conselho", "med_crm", "med_uf", "med_nome"}, new String[]{"Conselho", "N\u00famero", "UF", "Nome"}, new int[]{70, 70, 40, 0}, false, new int[]{0, 1, 2});
        this.adicionaItemFiltroAvancado(FILTRO_PACIENTE, "Paciente", "paciente", "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"pac_codigo", "pac_nome", "pac_nomesocial"}, new String[]{"C\u00f3digo", "Nome", "Nome Social"}, new int[]{70, 0, 0}, false, new int[]{70, 0});
    }

    private void adicionarFiltrosPorData() {
        this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Data inicial:");
        this.adicionaFiltroData(FILTRO_DATA_FINAL, "Data final:");
    }

    private void adicionarFiltrosPorHora() {
        this.adicionaFiltroHora(FILTRO_HORA_INICIAL, "Hora inicial:");
        this.adicionaFiltroHora(FILTRO_HORA_FINAL, "Hora final:");
    }

    private void adicionarCheckItemFiltros() {
        final CheckItemFiltro itemFiltroEstacao = this.adicionaRetornaItemFiltro(FILTRO_ESTACAO, "Esta\u00e7\u00e3o", "estacoes", "", 1, new String[]{"est_codigo", "est_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        final CheckItemFiltro itemFiltroUsuario = this.adicionaRetornaItemFiltro(FILTRO_USUARIO, "Usu\u00e1rio", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        itemFiltroEstacao.getCheckBox().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                itemFiltroUsuario.setEnabled(!itemFiltroEstacao.isSelected());
            }
        });
        itemFiltroUsuario.getCheckBox().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                itemFiltroEstacao.setEnabled(!itemFiltroUsuario.isSelected());
            }
        });
    }

    @Override
    public void imprimirPressionado() {
        try {
            this.definirFiltrosSelecionadosPeloUsuario();
            if (Funcoes.textoVazio(this.service.getLayoutRelatorio(MODULO_ACESSO_CODIGO))) {
                Funcoes.mensagem(null, "Modelo n\u00e3o localizado ou n\u00e3o definido.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            if (!this.service.modeloPreenchido()) {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.gerarRelatorio();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void definirFiltrosSelecionadosPeloUsuario() {
        this.service.setFiliaisSelecionadas(this.getSelecionadosFiltro(FILTRO_FILIAL, 0));
        this.service.setConveniosSelecionados(this.getSelecionadosFiltro(FILTRO_CONVENIO, 0));
        this.service.setSetoresSelecionados(this.getSelecionadosFiltro(FILTRO_SETOR, 0));
        this.service.setEstacoesSelecionadas(this.getSelecionadosFiltro(FILTRO_ESTACAO, 0));
        this.service.setColetasSelecionadas(this.getSelecionadosFiltro(FILTRO_COLETA, 0));
        this.service.setExamesSelecionados(this.getSelecionadosFiltro(FILTRO_EXAME, 0));
        this.service.setMateriaisSelecionados(this.getSelecionadosFiltro(FILTRO_MATERIAL, 0));
        this.service.setConselhosSelecionados(this.getSelecionadosFiltroAvancado(FILTRO_MEDICO, 0));
        this.service.setCrmsSelecionados(this.getSelecionadosFiltroAvancado(FILTRO_MEDICO, 1));
        this.service.setUfsSelecionados(this.getSelecionadosFiltroAvancado(FILTRO_MEDICO, 2));
        this.service.setPacientesSelecionados(this.getSelecionadosFiltroAvancado(FILTRO_PACIENTE, 0));
        this.service.setUsuariosSelecionados(this.getSelecionadosFiltro(FILTRO_USUARIO, 0));
        this.service.setDataInicialInformada(this.getFiltroData(FILTRO_DATA_INICIAL));
        this.service.setDataFinalInformada(this.getFiltroData(FILTRO_DATA_FINAL));
        this.service.setHoraInicialInformada(this.getFiltroHora(FILTRO_HORA_INICIAL));
        this.service.setHoraFinalInformada(this.getFiltroHora(FILTRO_HORA_FINAL));
    }

    private void gerarRelatorio() throws SQLException {
        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
        gerador.setPai(this.panelCentro);
        gerador.setPreVisualizar(true);
        gerador.setZoomPreVisualizar(0.5f);
        gerador.setAcaoFechar(new Runnable(){

            @Override
            public void run() {
                RelatorioTempoMedioAtendimento.this.panelCentro.removeAll();
                RelatorioTempoMedioAtendimento.this.panelCentro.repaint();
                RelatorioTempoMedioAtendimento.this.habilitaBotaoImprimir(true);
            }
        });
        gerador.executar(this.service.getLayoutRelatorio(MODULO_ACESSO_CODIGO), (TableModel)this.service.getModelo(), this.adicionarVariaveisAoRelatorio());
        this.panelCentro.revalidate();
    }

    private Map<String, Object> adicionarVariaveisAoRelatorio() {
        HashMap<String, Object> variaveis = new HashMap<String, Object>();
        variaveis.put(FILTRO_COLETA, this.getValoresSelecionados(this.service.getColetasSelecionadas()));
        variaveis.put(FILTRO_CONVENIO, this.getValoresSelecionados(this.service.getConveniosSelecionados()));
        variaveis.put(FILTRO_DATA_FINAL, this.service.getDataFinalInformada());
        variaveis.put(FILTRO_DATA_INICIAL, this.service.getDataInicialInformada());
        variaveis.put(FILTRO_ESTACAO, this.getValoresSelecionados(this.service.getEstacoesSelecionadas()));
        variaveis.put(FILTRO_EXAME, this.getValoresSelecionados(this.service.getExamesSelecionados()));
        variaveis.put(FILTRO_FILIAL, this.getValoresSelecionados(this.service.getFiliaisSelecionadas()));
        variaveis.put(FILTRO_HORA_FINAL, this.service.getHoraFinalInformada());
        variaveis.put(FILTRO_HORA_INICIAL, this.service.getHoraInicialInformada());
        variaveis.put(FILTRO_MATERIAL, this.getValoresSelecionados(this.service.getMateriaisSelecionados()));
        variaveis.put(FILTRO_MEDICO, this.service.getMedicosSelecionados());
        variaveis.put(FILTRO_PACIENTE, this.getValoresSelecionados(this.service.getPacientesSelecionados()));
        variaveis.put(FILTRO_SETOR, this.getValoresSelecionados(this.service.getSetoresSelecionados()));
        variaveis.put(FILTRO_USUARIO, this.getValoresSelecionados(this.service.getUsuariosSelecionados()));
        return variaveis;
    }

    private String getValoresSelecionados(String[] selecionados) {
        StringBuilder sb = new StringBuilder();
        if (selecionados != null && selecionados.length > 0) {
            for (int i = 0; i < selecionados.length; ++i) {
                sb.append(selecionados[i]);
                if (i >= selecionados.length - 1) continue;
                sb.append(",");
            }
        }
        return sb.toString();
    }

    public static long getModuloAcesso() {
        return MODULO_ACESSO_CODIGO;
    }

    public static long getModuloConfigurar() {
        return MODULO_CONFIGURAR_CODIGO;
    }
}

