/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.gerencial.recepcao.relatorioexamessolicitadossetorconvenio;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.digitacao.TabelaSimbolos;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class RelatorioExamesSolicitadosSetorConvenioDAO {
    private String[] filtroFilial;
    private String[] filtroConvenio;
    private String[] filtroSetor;
    private String[] filtroEstacao;
    private String[] filtroColeta;
    private String[] filtroExame;
    private String[] filtroMaterial;
    private String[] filtroGrupo;
    private String[] filtroMedico;
    private String[] filtroDestino;
    private String dataInicial;
    private String dataFinal;
    private String ordem;
    protected static String[] campos;
    private String campoData;
    private boolean filtroIntervaloHora;
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";

    public RelatorioExamesSolicitadosSetorConvenioDAO() {
        this.montaCampos();
    }

    public ModeloGridTable realizaConsulta() throws SQLException {
        String[] destino;
        String[] grupos;
        String[] materiais;
        String[] exames;
        String[] coletas;
        String[] estacoes;
        String[] setor;
        StringBuilder bui = new StringBuilder();
        bui.append("select distinct");
        bui.append(" avg(COALESCE(exameMatCol.emc_custosimples,0.0)) as valorCustoSimplesExameAtual, ");
        bui.append(" conv.con_fantasia as fantasiaConvenio, ");
        bui.append(" set.set_descricao as descricaoSetor, ");
        bui.append(" exameReq.exa_codigo as codigoExame, ");
        bui.append(" exa.exa_descricao as descricaoExame, ");
        bui.append(" detTabPreco.dtp_codamb as codigoAMB, ");
        bui.append(" calculaprecototalexamerequisicao(req.fil_codigo, req.con_codigo, req.req_codigo, exameReq.exa_codigo, exameReq.mco_codigo, true, false, false, exameReq.exr_vlrchexame, exameReq.exr_vlrch, exameReq.exr_valorporte, exameReq.exr_valorcusto, exameReq.exr_valoruco, exameReq.exr_vlrbalcaoconvenio, exameReq.exr_datafatura IS NOT NULL OR exameReq.usr_codfatura IS NOT NULL, exameReq.exr_vlrmaterial, exameReq.exr_vlrbalcaoconvenio, conv.con_precosdiferenciados, conv.con_reajuste, conv.con_cobrmaterial, conv.con_percpgtomaterial, conv.con_percpgto, conv.con_tpcalcfatu, conv.con_tpcalcch, conv.con_perguntarpercbalcao, conv.con_acrescimo, conv.con_bonus, conv.tpe_codigo, conv.con_acrescimoporte, conv.con_acrescimouco, conv.con_descontoporte, conv.con_descontouco, conv.con_valorch, 2, 5, false, exameReq.met_codigo) as valorExame, ");
        bui.append(" calculaprecototalexamerequisicao(req.fil_codigo, req.con_codigo, req.req_codigo, exameReq.exa_codigo, exameReq.mco_codigo, true, false, true, exameReq.exr_vlrchexame, exameReq.exr_vlrch, exameReq.exr_valorporte, exameReq.exr_valorcusto, exameReq.exr_valoruco, exameReq.exr_vlrbalcaoconvenio, exameReq.exr_datafatura IS NOT NULL OR exameReq.usr_codfatura IS NOT NULL, exameReq.exr_vlrmaterial, exameReq.exr_vlrbalcaoconvenio, conv.con_precosdiferenciados, conv.con_reajuste, conv.con_cobrmaterial, conv.con_percpgtomaterial, conv.con_percpgto, conv.con_tpcalcfatu, conv.con_tpcalcch, conv.con_perguntarpercbalcao, conv.con_acrescimo, conv.con_bonus, conv.tpe_codigo, conv.con_acrescimoporte, conv.con_acrescimouco, conv.con_descontoporte, conv.con_descontouco, conv.con_valorch, 2, 5, false, exameReq.met_codigo) as valorTotalExame, ");
        bui.append(" sum(exameReq.exr_vlrmaterial) as valorMaterial, ");
        bui.append(" count(exameReq.exa_codigo) as quantidadeExames, ");
        bui.append(" sum(exameReq.exr_vlrchexame) as valorCHOriginal, ");
        bui.append(" sum(calculachexamerequisicao(req.fil_codigo, req.con_codigo, req.req_codigo, exameReq.exa_codigo, exameReq.mco_codigo)) as valorCH, ");
        bui.append(" matCol.mco_codigo as codigoMaterial, ");
        bui.append(" matCol.mco_abreviatura as descricaoAbreviadaMaterial, ");
        bui.append(" round(calculaprecototalexamerequisicao(req.fil_codigo, req.con_codigo, req.req_codigo, exameReq.exa_codigo, exameReq.mco_codigo, true, false, false, exameReq.exr_vlrchexame, exameReq.exr_vlrch, exameReq.exr_valorporte, exameReq.exr_valorcusto, exameReq.exr_valoruco, exameReq.exr_vlrbalcaoconvenio, exameReq.exr_datafatura IS NOT NULL OR exameReq.usr_codfatura IS NOT NULL, exameReq.exr_vlrmaterial, exameReq.exr_vlrbalcaoconvenio, conv.con_precosdiferenciados, conv.con_reajuste, conv.con_cobrmaterial, conv.con_percpgtomaterial, conv.con_percpgto, conv.con_tpcalcfatu, conv.con_tpcalcch, conv.con_perguntarpercbalcao, conv.con_acrescimo, conv.con_bonus, conv.tpe_codigo, conv.con_acrescimoporte, conv.con_acrescimouco, conv.con_descontoporte, conv.con_descontouco, conv.con_valorch, 2, 5, false, exameReq.met_codigo) * ((100 - req.req_desconto)/100), 2) as valorLiquidoTotalExame, ");
        bui.append(" sum(COALESCE(exameReq.exr_custosimples, 0.0)) as valorCustoSimplesExameAgrupado, ");
        bui.append(" avg(COALESCE(exameReq.exr_custosimples,0.0)) as valorCustoSimplesExame, ");
        bui.append(" sum(COALESCE(exameMatCol.emc_custosimples,0.0)) as valorCustoSimplesExameAgrupadoAtual, ");
        bui.append(" conv.con_codigo as codigoConvenio,   ");
        bui.append(" conv.con_razao as razaoSocialConvenio, ");
        bui.append(" exaSet.set_codigo as codigoSetor, ");
        bui.append(" set.set_codigo as codigoSetor, ");
        bui.append(" filPostoCol.fil_codigo as codigoFilial, ");
        bui.append(" filPostoCol.fil_descricao as descricaoFilial, ");
        bui.append(" filPostoCol.fil_cnpj as cnpjFilial, ");
        bui.append(" filPostoCol.fil_endereco as enderecoFilial, ");
        bui.append(" filPostoCol.fil_complemento as complementoFilial, ");
        bui.append(" filPostoCol.fil_cep as cepFilial, ");
        bui.append(" filPostoCol.fil_cnes as CNESFilial, ");
        bui.append(" filPostoCol.fil_fone as foneFilial, ");
        bui.append(" filPostoCol.fil_fax as faxFilial, ");
        bui.append(" filPostoCol.fil_razaosocial as razaoSocialFilial, ");
        bui.append(" cid.cid_codigo as codigoCidadeFilial, ");
        bui.append(" cid.cid_nome as descricaoCidadeFilial, ");
        bui.append(" cid.cid_uf as estadoCidadeFilial, ");
        bui.append(" bairro.bai_codigo as codigoBairroFilial, ");
        bui.append(" bairro.bai_descricao as descricaoBairroFilial ");
        bui.append(" from examerequisicao exameReq ");
        bui.append(" left join requisicao req  on exameReq.fil_codigo = req.fil_codigo and exameReq.req_codigo = req.req_codigo ");
        bui.append(" left join examematcoleta exameMatCol on exameReq.fil_codigo = exameMatCol.fil_codigo and exameReq.exa_codigo = exameMatCol.exa_codigo and exameReq.mco_codigo = exameMatCol.mco_codigo ");
        bui.append(" left join destino des on req.fil_codigo = des.fil_codigo and req.des_codigo = des.des_codigo ");
        bui.append(" left join exames exa on exameReq.fil_codigo = exa.fil_codigo and exameReq.exa_codigo = exa.exa_codigo ");
        bui.append(" left join convenios conv on req.fil_codigo = conv.fil_codigo and req.con_codigo = conv.con_codigo ");
        bui.append(" left join examesetor exaSet on exameReq.fil_codigo = exaSet.fil_codigo and exameReq.exa_codigo = exaSet.exa_codigo and exaSet.ese_default = true ");
        bui.append(" left join setores set on exaSet.fil_codigo = set.fil_codigo and exaSet.set_codigo = set.set_codigo ");
        bui.append(" left join examematgrupo exaMatGp on exameReq.fil_codigo = exaMatGp.fil_codigo and exameReq.exa_codigo = exaMatGp.exa_codigo and exameReq.mco_codigo = exaMatGp.mco_codigo ");
        bui.append(" left join materialcoleta matCol on exameReq.fil_codigo = matCol.fil_codigo and exameReq.mco_codigo = matCol.mco_codigo ");
        bui.append(" left join grupo gp on exameReq.fil_codigo = gp.fil_codigo and exaMatGp.grp_codigo = gp.grp_codigo ");
        bui.append(" left join detalhetabelapreco detTabPreco on exameReq.fil_codigo = detTabPreco.fil_codigo and exameReq.exa_codigo = detTabPreco.exa_codigo and exameReq.mco_codigo = detTabPreco.mco_codigo and conv.tpe_codigo = detTabPreco.tpe_codigo ");
        bui.append(" left join filiais_postocoleta filPostoCol on exameReq.fil_codigo = filPostoCol.fil_codigo ");
        bui.append(" left join cidades cid on filPostoCol.fil_codigo = cid.fil_codigo and filPostoCol.cid_codigo = cid.cid_codigo ");
        bui.append(" left join bairro bairro on filPostoCol.fil_codigo = bairro.fil_codigo and filPostoCol.bai_codigo = bairro.bai_codigo ");
        if (this.getFiltroFilial() == null) {
            this.filtroFilial = new String[]{Variaveis.filialPadrao};
        }
        bui.append(" where req.fil_codigo in (");
        for (int i = 0; i < this.filtroFilial.length; ++i) {
            bui.append(this.filtroFilial[i]);
            if (i >= this.filtroFilial.length - 1) continue;
            bui.append(", ");
        }
        bui.append(") ");
        String[] convenio = this.getFiltroConvenio();
        if (convenio != null) {
            bui.append(" and conv.con_codigo in (");
            for (int i = 0; i < convenio.length; ++i) {
                bui.append(convenio[i]);
                if (i >= convenio.length - 1) continue;
                bui.append(", ");
            }
            bui.append(")");
        }
        if ((setor = this.getFiltroSetor()) != null) {
            bui.append(" and set.set_codigo in (");
            for (int i = 0; i < setor.length; ++i) {
                bui.append("'");
                bui.append(setor[i]);
                bui.append("'");
                if (i >= setor.length - 1) continue;
                bui.append(", ");
            }
            bui.append(")");
        }
        if ((estacoes = this.getFiltroEstacao()) != null) {
            bui.append(" and req.est_codigo in (");
            for (int i = 0; i < estacoes.length; ++i) {
                bui.append(estacoes[i]);
                if (i >= estacoes.length - 1) continue;
                bui.append(", ");
            }
            bui.append(")");
        }
        if ((coletas = this.getFiltroColeta()) != null) {
            bui.append(" and req.col_codigo in (");
            for (int i = 0; i < coletas.length; ++i) {
                bui.append(StringUtil.textoDBEscape(coletas[i]));
                if (i >= coletas.length - 1) continue;
                bui.append(", ");
            }
            bui.append(")");
        }
        if ((exames = this.getFiltroExame()) != null) {
            bui.append(" and exa.exa_codigo in (");
            for (int i = 0; i < exames.length; ++i) {
                bui.append("'");
                bui.append(exames[i]);
                bui.append("'");
                if (i >= exames.length - 1) continue;
                bui.append(", ");
            }
            bui.append(")");
        }
        if ((materiais = this.getFiltroMaterial()) != null) {
            bui.append(" and exameMatCol.mco_codigo in (");
            for (int i = 0; i < materiais.length; ++i) {
                bui.append(materiais[i]);
                if (i >= materiais.length - 1) continue;
                bui.append(", ");
            }
            bui.append(")");
        }
        if ((grupos = this.getFiltroGrupo()) != null) {
            bui.append(" and exaMatGp.grp_codigo in (");
            for (int i = 0; i < grupos.length; ++i) {
                bui.append(StringUtil.textoDBEscape(grupos[i]));
                if (i >= grupos.length - 1) continue;
                bui.append(", ");
            }
            bui.append(")");
        }
        if ((destino = this.getFiltroDestino()) != null) {
            bui.append(" and des.des_codigo in (");
            for (int i = 0; i < destino.length; ++i) {
                bui.append(StringUtil.textoDBEscape(destino[i]));
                if (i >= destino.length - 1) continue;
                bui.append(", ");
            }
            bui.append(")");
        }
        String[] conselho = this.getFiltroMedico();
        String[] crm = this.getFiltroMedico();
        String[] uf = this.getFiltroMedico();
        if (crm != null && uf != null && crm.length <= ParametrosGerais.getQuantidadeMaximoFiltroAvancado()) {
            bui.append(" and (");
            for (int i = 0; i < crm.length; ++i) {
                bui.append("(req.med_conselho = '");
                bui.append(conselho[i]);
                bui.append("' and req.med_crm = '");
                bui.append(crm[i]);
                bui.append("' and req.med_uf = '");
                bui.append(uf[i]);
                bui.append("')");
                if (i >= crm.length - 1) continue;
                bui.append(" or ");
            }
            bui.append(")");
        }
        if (!Funcoes.textoVazio(this.dataInicial)) {
            bui.append(" and req.req_data >= '").append(Funcoes.formataData("yyyy-MM-dd", this.dataInicial)).append("' ");
        }
        if (!Funcoes.textoVazio(this.dataFinal)) {
            bui.append(" and req.req_data <= '").append(Funcoes.formataData("yyyy-MM-dd", this.dataFinal)).append("' ");
        }
        bui.append(" and req.req_excluida = false and ");
        bui.append(" exameReq.exr_excluido = false ");
        bui.append(" group by gp.grp_codigo,\texameReq.exa_codigo, exa.exa_descricao, conv.con_fantasia, conv.con_codigo, conv.con_razao, conv.con_codigo, conv.con_razao, detTabPreco.dtp_codamb, valorExame, valorTotalExame, matCol.mco_codigo, matCol.mco_abreviatura, exaSet.set_codigo, set.set_codigo, set.set_descricao, filPostoCol.fil_codigo, filPostoCol.fil_descricao,  filPostoCol.fil_endereco, filPostoCol.fil_complemento, filPostoCol.fil_cep, filPostoCol.fil_cnes, filPostoCol.fil_fone, filPostoCol.fil_fax, filPostoCol.fil_razaosocial, cid.cid_codigo, cid.cid_nome, cid.cid_uf, bairro.bai_codigo, bairro.bai_descricao, req.fil_codigo, valorLiquidoTotalExame");
        bui.append(" order by ");
        bui.append(" conv.con_fantasia, ");
        bui.append(" set.set_descricao, ");
        String order = this.getOrdem();
        if (order.equals("C\u00f3digo")) {
            bui.append(" exameReq.exa_codigo ");
        } else if (order.equals("Descri\u00e7\u00e3o")) {
            bui.append(" exa.exa_descricao ");
        } else if (order.equals("Quantidade")) {
            bui.append(" quantidadeExames ");
        }
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, bui.toString());
        ModeloGridTable modelo = new ModeloGridTable(campos);
        while (rs.next()) {
            Object[] o = new Object[campos.length];
            TabelaSimbolos tabela = new TabelaSimbolos();
            int pos = -1;
            for (int i = 0; i < campos.length; ++i) {
                o[i] = rs.getObject(campos[i]);
            }
            modelo.addLine(o);
        }
        return modelo;
    }

    private void montaCampos() {
        campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoExame", "descricaoExame", "valorExame", "valorTotalExame", "codigoAMB", "valorMaterial", "quantidadeExames", "valorCHOriginal", "valorCH", "codigoMaterial", "descricaoAbreviadaMaterial", "valorLiquidoTotalExame", "valorCustoSimplesExameAgrupado", "valorCustoSimplesExame", "valorCustoSimplesExameAgrupadoAtual", "valorCustoSimplesExameAtual", "codigoConvenio", "fantasiaConvenio", "razaoSocialConvenio", "codigoSetor", "descricaoSetor"});
    }

    public String[] getFiltroFilial() {
        return this.filtroFilial;
    }

    public void setFiltroFilial(String[] filtroFilial) {
        this.filtroFilial = filtroFilial;
    }

    public String[] getFiltroConvenio() {
        return this.filtroConvenio;
    }

    public void setFiltroConvenio(String[] filtroConvenio) {
        this.filtroConvenio = filtroConvenio;
    }

    public String[] getFiltroSetor() {
        return this.filtroSetor;
    }

    public void setFiltroSetor(String[] filtroSetor) {
        this.filtroSetor = filtroSetor;
    }

    public String[] getFiltroEstacao() {
        return this.filtroEstacao;
    }

    public void setFiltroEstacao(String[] filtroEstacao) {
        this.filtroEstacao = filtroEstacao;
    }

    public String[] getFiltroColeta() {
        return this.filtroColeta;
    }

    public void setFiltroColeta(String[] filtroColeta) {
        this.filtroColeta = filtroColeta;
    }

    public String[] getFiltroExame() {
        return this.filtroExame;
    }

    public void setFiltroExame(String[] filtroExame) {
        this.filtroExame = filtroExame;
    }

    public String[] getFiltroMaterial() {
        return this.filtroMaterial;
    }

    public void setFiltroMaterial(String[] filtroMaterial) {
        this.filtroMaterial = filtroMaterial;
    }

    public String[] getFiltroGrupo() {
        return this.filtroGrupo;
    }

    public void setFiltroGrupo(String[] filtroGrupo) {
        this.filtroGrupo = filtroGrupo;
    }

    public String[] getFiltroMedico() {
        return this.filtroMedico;
    }

    public void setFiltroMedico(String[] filtroMedico) {
        this.filtroMedico = filtroMedico;
    }

    public String[] getFiltroDestino() {
        return this.filtroDestino;
    }

    public void setFiltroDestino(String[] filtroDestino) {
        this.filtroDestino = filtroDestino;
    }

    public String getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(String dataInicial) {
        this.dataInicial = dataInicial;
    }

    public String getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(String dataFinal) {
        this.dataFinal = dataFinal;
    }

    public String getOrdem() {
        return this.ordem;
    }

    public void setOrdem(String ordem) {
        this.ordem = ordem;
    }

    public static String[] getCampos() {
        return campos;
    }

    public static void setCampos(String[] campos) {
        RelatorioExamesSolicitadosSetorConvenioDAO.campos = campos;
    }

    public String getCampoData() {
        return this.campoData;
    }

    public void setCampoData(String campoData) {
        this.campoData = campoData;
    }

    public boolean isFiltroIntervaloHora() {
        return this.filtroIntervaloHora;
    }

    public void setFiltroIntervaloHora(boolean filtroIntervaloHora) {
        this.filtroIntervaloHora = filtroIntervaloHora;
    }

    public String getLayoutRelatorio(long moduloAcesso) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
        buf.append(moduloAcesso);
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            return rs.getString("rel_xml");
        }
        return null;
    }
}

