/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.gerencial.recepcao.relatorioexamessolicitadossetorconvenio;

import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.gerencial.recepcao.relatorioexamessolicitadossetorconvenio.RelatorioExamesSolicitadosSetorConvenioService;
import jalis.relatorio.Gerador;
import jalis.relatorio.gerador.RelatorioException;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import java.awt.Cursor;
import java.sql.SQLException;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.table.TableModel;

public class RelatorioExamesSolicitadosSetorConvenio
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String[] campoData = new String[]{"Coleta", "Confer\u00eancia"};
    private final String[] ordem = new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Quantidade"};
    protected static final String FILTRO_FILIAL = "filtroFilial";
    protected static final String FILTRO_CONVENIO = "filtroConvenio";
    protected static final String FILTRO_SETOR = "filtroSetor";
    protected static final String FILTRO_ESTACAO = "filtroEstacao";
    protected static final String FILTRO_COLETA = "filtroColeta";
    protected static final String FILTRO_EXAME = "filtroExame";
    protected static final String FILTRO_MATERIAL = "filtroMaterial";
    protected static final String FILTRO_GRUPO = "filtroGrupo";
    protected static final String FILTRO_MEDICO = "filtroMedico";
    protected static final String FILTRO_DESTINO = "filtroDestino";
    protected static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    protected static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    protected static final String FILTRO_ORDEM = "ordemRelatorio";
    private RelatorioExamesSolicitadosSetorConvenioService service = new RelatorioExamesSolicitadosSetorConvenioService();

    public RelatorioExamesSolicitadosSetorConvenio() {
        this.montaBarraDescricao("Relat\u00f3rio de exames solicitados por setor e conv\u00eanio", "Listagem das requisi\u00e7\u00f5es solicitadas no per\u00edodo por setor e conv\u00eanio", "relatorios/rel_exames_solicitados.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro(FILTRO_FILIAL, "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_CONVENIO, "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_SETOR, "Setor", "setores", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_ESTACAO, "Esta\u00e7\u00e3o", "estacoes", "", 1, new String[]{"est_codigo", "est_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_COLETA, "Coleta", "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_EXAME, "Exame", "exames", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_MATERIAL, "Material", "materialcoleta", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"mco_codigo", "mco_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_GRUPO, "Grupo", "grupo", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"grp_codigo", "grp_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltroAvancado(FILTRO_MEDICO, "M\u00e9dico", "medico", "fil_codigo = " + Variaveis.filialPadrao, 4, new String[]{"med_conselho", "med_crm", "med_uf", "med_nome"}, new String[]{"Conselho", "N\u00famero", "UF", "Nome"}, new int[]{70, 70, 40, 0}, false, new int[]{0, 1, 2});
        this.adicionaItemFiltro(FILTRO_DESTINO, "Destino", "destino", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Destino"}, new int[]{70, 0});
        this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Data inicial:");
        this.adicionaFiltroData(FILTRO_DATA_FINAL, "Data final:");
        JComboBox comboOrdem = this.adicionaRetornaFiltroCombo(FILTRO_ORDEM, "Ordem:", this.ordem, 0);
        this.setModuloConfigurar(RelatorioExamesSolicitadosSetorConvenio.getModuloConfigurar());
        this.setModuloAcesso(this.getModuloAcesso());
        this.setCamposConfigurador(this.service.getCampos());
    }

    @Override
    public void imprimirPressionado() {
        try {
            this.validarCampos();
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.service.setFiltroFilial(this.getSelecionadosFiltro(FILTRO_FILIAL, 0));
            this.service.setFiltroConvenio(this.getSelecionadosFiltro(FILTRO_CONVENIO, 0));
            this.service.setFiltroSetor(this.getSelecionadosFiltro(FILTRO_SETOR, 0));
            this.service.setFiltroEstacao(this.getSelecionadosFiltro(FILTRO_ESTACAO, 0));
            this.service.setFiltroColeta(this.getSelecionadosFiltro(FILTRO_COLETA, 0));
            this.service.setFiltroExame(this.getSelecionadosFiltro(FILTRO_EXAME, 0));
            this.service.setFiltroMaterial(this.getSelecionadosFiltro(FILTRO_MATERIAL, 0));
            this.service.setFiltroGrupo(this.getSelecionadosFiltro(FILTRO_GRUPO, 0));
            this.service.setFiltroMedico(this.getSelecionadosFiltro(FILTRO_MEDICO, 0));
            this.service.setFiltroDestino(this.getSelecionadosFiltro(FILTRO_DESTINO, 0));
            this.service.setDataInicial(this.getFiltroData(FILTRO_DATA_INICIAL));
            this.service.setDataFinal(this.getFiltroData(FILTRO_DATA_FINAL));
            this.service.setOrdem((String)this.getFiltroCombo(FILTRO_ORDEM));
            ModeloGridTable modelo = this.service.imprimir();
            if (modelo.getRowCount() == 0) {
                throw new RelatorioException("N\u00e3o h\u00e1 dados para imprimir.");
            }
            String layout = this.service.getLayoutRelatorio(RelatorioExamesSolicitadosSetorConvenio.getModuloAcesso());
            if (modelo.getRowCount() > 0) {
                Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                gerador.setPai(this.panelCentro);
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                Map<String, Object> var = this.service.getFiltros();
                gerador.setAcaoFechar(new Runnable(){

                    @Override
                    public void run() {
                        RelatorioExamesSolicitadosSetorConvenio.this.panelCentro.removeAll();
                        RelatorioExamesSolicitadosSetorConvenio.this.panelCentro.repaint();
                        RelatorioExamesSolicitadosSetorConvenio.this.habilitaBotaoImprimir(true);
                    }
                });
                gerador.executar(layout, (TableModel)modelo, var);
                this.panelCentro.revalidate();
            }
        }
        catch (RelatorioException e) {
            Funcoes.mensagem(this, e.getMessage(), 2);
            this.habilitaBotaoImprimir(true);
        }
        catch (SQLException e) {
            Funcoes.mensagem(this, e.getMessage(), 2);
            this.habilitaBotaoImprimir(true);
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void validarCampos() throws RelatorioException {
        String dataInicial = this.getFiltroData(FILTRO_DATA_INICIAL);
        String dataFinal = this.getFiltroData(FILTRO_DATA_FINAL);
        if (Funcoes.textoVazio(dataInicial)) {
            throw new RelatorioException("Informe ao menos a data inicial.");
        }
        if (!Funcoes.verificaData(dataInicial)) {
            throw new RelatorioException("A data inicial \u00e9 inv\u00e1lida.");
        }
        if (!Funcoes.textoVazio(dataInicial) && !Funcoes.textoVazio(dataFinal) && Funcoes.getData("dd/MM/yyyy", dataInicial).compareTo(Funcoes.getData("dd/MM/yyyy", dataFinal)) > 0) {
            throw new RelatorioException("A data inicial \u00e9 maior do que a data final.");
        }
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0880301500");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0880301501");
    }
}

