/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.gerencial.recepcao;

import jalis.comum.Acesso;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.model.vo.relatorio.RelatorioRequisicoesRecoletaVO;
import jalis.relatorio.Gerador;
import jalis.service.relatorio.RelatorioRequisicoesRecoletaService;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableModel;

public class RelatorioRequisicoesRecoleta
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private RelatorioRequisicoesRecoletaService service = null;
    private final String[] ordem = new String[]{"C\u00f3digo", "Paciente"};
    private final String[] campoData = new String[]{"Requisi\u00e7\u00e3o", "Entrega", "Coleta"};
    private final String[] campoDataBanco = new String[]{"a.req_data", "b.exr_dataentregaprev", "b.exr_datamaterial"};
    private final String[] situacao = new String[]{"Todas", Tipos.tipoSituacaoExame(""), Tipos.tipoSituacaoExame("T"), Tipos.tipoSituacaoExame("F"), Tipos.tipoSituacaoExame("R"), Tipos.tipoSituacaoExame("L"), Tipos.tipoSituacaoExame("C"), Tipos.tipoSituacaoExame("O"), Tipos.tipoSituacaoExame("I"), Tipos.tipoSituacaoExame("E"), Tipos.tipoSituacaoExame("A"), Tipos.tipoSituacaoExame("P")};
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_SITUACAO = "filtroSituacao";
    private final String FILTRO_DESTINO = "filtroDestino";
    private final String FILTRO_COLETA = "filtroColeta";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_MEDICO = "filtroMedico";
    private final String FILTRO_HORA_INICIAL = "filtroHoraInicial";
    private final String FILTRO_HORA_FINAL = "filtroHoraFinal";
    private final String FILTRO_EXAME = "filtroExame";
    private final String FILTRO_MATERIAL_COLETA = "filtroMaterialColeta";
    private final String FILTRO_SETOR = "filtroSetor";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String FILTRO_INTERVALO_HORA = "intervaloHora";
    private final String FILTRO_CAMPO_DATA = "filtroCampoData";
    private final String FILTRO_REQUISICAO = "filtroRequisicao";
    private final String ORDEM_POR_FILIAL = "ordemPorFilial";
    private final String FILTRO_MOTIVO_RECOLETA = "filtroMotivoRecoleta";
    private final String FILTRO_APRESENTAR_HISTORICO = "apresentarHistorico";

    public RelatorioRequisicoesRecoleta() {
        this.service = new RelatorioRequisicoesRecoletaService();
        this.montaBarraDescricao("Relat\u00f3rio de Requisi\u00e7\u00f5es com recoleta", "Listagem de requisi\u00e7\u00f5es com recoleta", "relatorios/rel_ger_rec_requisicao_recoleta.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroDestino", "Destino", "destino", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroColeta", "Coleta", "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltroAvancado("filtroMedico", "M\u00e9dico", "medico", "fil_codigo = " + Variaveis.filialPadrao, 4, new String[]{"med_conselho", "med_crm", "med_uf", "med_nome"}, new String[]{"Conselho", "N\u00famero", "UF", "Nome"}, new int[]{70, 70, 40, 0}, false, new int[]{0, 1, 2});
        this.adicionaItemFiltro("filtroExame", "Exame", "exames", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroMaterialColeta", "Material", "materialcoleta", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"mco_codigo", "mco_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroSetor", "Setor", "setores", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroMotivoRecoleta", "Motivo Recoleta", "motivorecoleta", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"mrc_codigo", "mrc_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroHora("filtroHoraInicial", "Hora inicial:");
        this.adicionaFiltroHora("filtroHoraFinal", "Hora final:");
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.adicionaFiltroCheck("intervaloHora", "Intervalo de Hora", false);
        if (Acesso.getAcesso(RelatorioRequisicoesRecoleta.getModuloAcessoHistoricoRecoleta())) {
            this.adicionaFiltroCheck("apresentarHistorico", "Apresentar hist\u00f3rico", false);
        }
        this.setModuloAcesso(RelatorioRequisicoesRecoleta.getModuloAcesso());
        this.setCamposConfigurador(RelatorioRequisicoesRecoletaService.campos);
    }

    private boolean colunaExiste(ResultSet rs, String campo) {
        try {
            return rs.findColumn(campo) > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setModuloAcesso(this.getTipoRelatorio());
        super.actionPerformed(e);
    }

    private long getTipoRelatorio() {
        long acesso = Long.parseLong("0880101700");
        if (this.getFiltroCheck("apresentarHistorico")) {
            acesso = Long.parseLong("0880101702");
        }
        return acesso;
    }

    @Override
    public void imprimirPressionado() {
        if (this.isDataValida()) {
            try {
                ModeloGridTable modelo = new ModeloGridTable(this.service.getCampos());
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.service.setFiltroFiliais(this.getSelecionadosFiltro("filtroFilial", 0));
                this.service.setFiltroDestinos(this.getSelecionadosFiltro("filtroDestino", 0));
                this.service.setFiltroColetas(this.getSelecionadosFiltro("filtroColeta", 0));
                this.service.setFiltroConvenios(this.getSelecionadosFiltro("filtroConvenio", 0));
                this.service.setFiltroConselhos(this.getSelecionadosFiltroAvancado("filtroMedico", 0));
                this.service.setCrms(this.getSelecionadosFiltroAvancado("filtroMedico", 1));
                this.service.setUfs(this.getSelecionadosFiltroAvancado("filtroMedico", 2));
                this.service.setFiltroExames(this.getSelecionadosFiltro("filtroExame", 0));
                this.service.setFiltroMateriais(this.getSelecionadosFiltro("filtroMaterialColeta", 0));
                this.service.setFiltroSetores(this.getSelecionadosFiltro("filtroSetor", 0));
                this.service.setFiltroMotivoRecoleta(this.getSelecionadosFiltro("filtroMotivoRecoleta", 0));
                this.service.setDataInicial(this.getFiltroData("filtroDataInicial"));
                this.service.setDataFinal(this.getFiltroData("filtroDataFinal"));
                this.service.setHoraInicial(this.getFiltroHora("filtroHoraInicial"));
                this.service.setHoraFinal(this.getFiltroHora("filtroHoraFinal"));
                this.service.setFiltroOrdem(this.getFiltroCombo("ordemRelatorio"));
                this.service.setFiltroIntervaloHora(this.getFiltroCheck("intervaloHora"));
                this.service.setFiltroApresentarHistorico(this.getFiltroCheck("apresentarHistorico"));
                List<Object> listDados = this.service.gerarRelatorio();
                if (listDados != null && !listDados.isEmpty()) {
                    Iterator<Object> it = listDados.iterator();
                    boolean contador = true;
                    while (it.hasNext()) {
                        RelatorioRequisicoesRecoletaVO relatorioVO = (RelatorioRequisicoesRecoletaVO)it.next();
                        Object[] o = new Object[this.service.getCampos().length];
                        for (int i = 0; i < this.service.getCampos().length && relatorioVO.getDados() != null; ++i) {
                            o[i] = relatorioVO.getDados().get(this.service.getCampos()[i].toLowerCase());
                        }
                        modelo.addLine(o);
                    }
                    this.getQtdeEmRecoleta(modelo);
                    if (Funcoes.textoVazio(this.service.getModeloRelatorio())) {
                        this.habilitaBotaoImprimir(true);
                        return;
                    }
                } else {
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                    this.habilitaBotaoImprimir(true);
                    this.setCursor(Cursor.getDefaultCursor());
                    return;
                }
                Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                gerador.setPai(this.panelCentro);
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                gerador.setAcaoFechar(new Runnable(){

                    @Override
                    public void run() {
                        RelatorioRequisicoesRecoleta.this.panelCentro.removeAll();
                        RelatorioRequisicoesRecoleta.this.panelCentro.repaint();
                        RelatorioRequisicoesRecoleta.this.habilitaBotaoImprimir(true);
                    }
                });
                Map<String, Object> varFiltro = this.montaDadosCabecalho();
                gerador.executar(this.service.getModeloRelatorio(), (TableModel)modelo, varFiltro);
                this.panelCentro.revalidate();
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void getQtdeEmRecoleta(ModeloGridTable modelo) {
        int i;
        Object requisicaoAnterior = null;
        Object exameAnterior = null;
        boolean quantidadeRequisicao = false;
        boolean quantidadeExame = false;
        ArrayList<String> exames = new ArrayList<String>();
        ArrayList<String> requisicoes = new ArrayList<String>();
        for (i = 0; i < modelo.getRowCount(); ++i) {
            HashMap<String, Object> o = modelo.getLine(i);
            String codigoRequisicao = o.get("codigoRequisicao").toString();
            String codigoExame = o.get("codigoExame").toString();
            String codigoMaterial = o.get("codigoMaterialColetado").toString();
            if (!requisicoes.contains(codigoRequisicao)) {
                requisicoes.add(codigoRequisicao);
            }
            if (exames.contains(codigoRequisicao + codigoExame + codigoMaterial)) continue;
            exames.add(codigoRequisicao + codigoExame + codigoMaterial);
        }
        for (i = 0; i < modelo.getRowCount(); ++i) {
            modelo.setValueAt(requisicoes.size(), i, modelo.findColumn("quantidadeRequisicoesRecoleta"));
            modelo.setValueAt(exames.size(), i, modelo.findColumn("quantidadeExamesRecoleta"));
        }
    }

    private Map<String, Object> montaDadosCabecalho() {
        int i;
        HashMap<String, Object> varFiltro = new HashMap<String, Object>();
        StringBuilder buf = new StringBuilder();
        if (this.service.getFiltroFiliais() != null) {
            for (i = 0; i < this.service.getFiltroFiliais().length; ++i) {
                buf.append(this.service.getFiltroFiliais()[i]);
                if (i >= this.service.getFiltroFiliais().length - 1) continue;
                buf.append(", ");
            }
            varFiltro.put("filtroFilial", buf.toString());
        } else {
            varFiltro.put("filtroFilial", Variaveis.filialPadrao);
        }
        buf.delete(0, buf.length());
        if (this.service.getFiltroDestinos() != null) {
            for (i = 0; i < this.service.getFiltroDestinos().length; ++i) {
                buf.append(this.service.getFiltroDestinos()[i]);
                if (i >= this.service.getFiltroDestinos().length - 1) continue;
                buf.append(", ");
            }
            varFiltro.put("filtroDestino", buf.toString());
        }
        buf.delete(0, buf.length());
        if (this.service.getFiltroColetas() != null) {
            for (i = 0; i < this.service.getFiltroColetas().length; ++i) {
                buf.append(this.service.getFiltroColetas()[i]);
                if (i >= this.service.getFiltroColetas().length - 1) continue;
                buf.append(", ");
            }
            varFiltro.put("filtroColeta", buf.toString());
        }
        buf.delete(0, buf.length());
        if (this.service.getFiltroConvenios() != null) {
            for (i = 0; i < this.service.getFiltroConvenios().length; ++i) {
                buf.append(this.service.getFiltroConvenios()[i]);
                if (i >= this.service.getFiltroConvenios().length - 1) continue;
                buf.append(", ");
            }
            varFiltro.put("filtroConvenio", buf.toString());
        }
        buf.delete(0, buf.length());
        if (this.service.getFiltroConselhos() != null) {
            for (i = 0; i < this.service.getCrms().length; ++i) {
                buf.append(this.service.getCrms()[i]);
                if (i >= this.service.getCrms().length - 1) continue;
                buf.append(", ");
            }
            varFiltro.put("filtroMedico", buf.toString());
        }
        buf.delete(0, buf.length());
        if (this.service.getFiltroExames() != null) {
            for (i = 0; i < this.service.getFiltroExames().length; ++i) {
                buf.append(this.service.getFiltroExames()[i]);
                if (i >= this.service.getFiltroExames().length - 1) continue;
                buf.append(", ");
            }
            varFiltro.put("filtroExame", buf.toString());
        }
        buf.delete(0, buf.length());
        if (this.service.getFiltroMateriais() != null) {
            for (i = 0; i < this.service.getFiltroMateriais().length; ++i) {
                buf.append(this.service.getFiltroMateriais()[i]);
                if (i >= this.service.getFiltroMateriais().length - 1) continue;
                buf.append(", ");
            }
            varFiltro.put("filtroMaterialColeta", buf.toString());
        }
        buf.delete(0, buf.length());
        if (this.service.getFiltroSetores() != null) {
            for (i = 0; i < this.service.getFiltroSetores().length; ++i) {
                buf.append(this.service.getFiltroSetores()[i]);
                if (i >= this.service.getFiltroSetores().length - 1) continue;
                buf.append(", ");
            }
            varFiltro.put("filtroSetor", buf.toString());
        }
        buf.delete(0, buf.length());
        if (this.service.getFiltroMotivoRecoleta() != null) {
            for (i = 0; i < this.service.getFiltroMotivoRecoleta().length; ++i) {
                buf.append(this.service.getFiltroMotivoRecoleta()[i]);
                if (i >= this.service.getFiltroMotivoRecoleta().length - 1) continue;
                buf.append(", ");
            }
            varFiltro.put("filtroMotivoRecoleta", buf.toString());
        }
        if (this.service.getDataInicial() != null) {
            varFiltro.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
        }
        if (this.service.getDataFinal() != null) {
            varFiltro.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
        }
        if (this.service.getHoraInicial() != null) {
            varFiltro.put("filtroHoraInicial", this.getFiltroData("filtroHoraInicial"));
        }
        if (this.service.getHoraFinal() != null) {
            varFiltro.put("filtroHoraFinal", this.getFiltroData("filtroHoraFinal"));
        }
        if (this.service.getFiltroIntervaloHora() != null) {
            varFiltro.put("intervaloHora", this.getFiltroCombo("intervaloHora"));
        }
        if (this.service.getFiltroApresentarHistorico() != null) {
            varFiltro.put("apresentarHistorico", this.getFiltroCombo("apresentarHistorico"));
        }
        if (this.service.getFiltroOrdem() != null) {
            varFiltro.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
        }
        return varFiltro;
    }

    private boolean isDataValida() {
        if (Funcoes.textoVazio(this.getFiltroData("filtroDataInicial"))) {
            Funcoes.mensagem(this, "Campo Data deve ser preenchido.", 2);
            this.habilitaBotaoImprimir(true);
            return false;
        }
        if (this.getFiltroCheck("intervaloHora") && (Funcoes.textoVazio(this.getFiltroData("filtroDataInicial")) || Funcoes.textoVazio(this.getFiltroHora("filtroHoraInicial")) || Funcoes.textoVazio(this.getFiltroData("filtroDataFinal")) || Funcoes.textoVazio(this.getFiltroHora("filtroHoraFinal")))) {
            Funcoes.mensagem(this, "Os campos de Data e Hora devem ser preenchidos.", 2);
            this.habilitaBotaoImprimir(true);
            return false;
        }
        return true;
    }

    private String concatenarFiltro(String[] filtro) {
        StringBuilder buf = new StringBuilder();
        if (filtro != null) {
            for (int i = 0; i < filtro.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(filtro[i]);
            }
            return buf.toString();
        }
        return "";
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0880101700");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0880101701");
    }

    public static long getModuloAcessoHistoricoRecoleta() {
        return Long.parseLong("0880101702");
    }
}

