/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.gerencial.recepcao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.relatorio.Gerador;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioPacientesPorBairro
extends FrmRelPadrao {
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_CIDADE = "filtroCidade";
    private final String FILTRO_BAIRRO = "filtroBairro";
    private final String FILTRO_ORDEM = "filtroOrdem";
    private final long ACESSO_CONFIGURAR = Long.parseLong("0880101401");
    private final String[] ordem = new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Quantidade"};
    protected static final String[] campos = new String[]{"codigoBairro", "nomeBairro", "codigoCidade", "nomeCidade", "estadoCidade", "quantidadePaciente"};

    public RelatorioPacientesPorBairro() {
        this.montaBarraDescricao("Relat\u00f3rio de pacientes/bairro", "Listagem da quantidade de pacientes por bairro", "relatorios/rel_paciente_por_bairro.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroCidade", "Cidade", "cidades", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"cid_codigo", "cid_nome", "cid_uf"}, new String[]{"C\u00f3digo", "Nome", "UF"}, new int[]{70, 0, 30});
        this.adicionaItemFiltro("filtroBairro", "Bairro", "bairro", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"bai_codigo", "bai_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroCombo("filtroOrdem", "Ordem", this.ordem, 0);
        this.setModuloConfigurar(this.ACESSO_CONFIGURAR);
        this.setModuloAcesso(RelatorioPacientesPorBairro.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    @Override
    public void imprimirPressionado() {
        if (this.getSelecionadosFiltro("filtroCidade", 0) == null || this.getSelecionadosFiltro("filtroCidade", 0).length == 0) {
            Funcoes.mensagem(this, "Cidade n\u00e3o selecionada, pelo menos uma cidade deve ser selecionada", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            String[] bairros;
            Statement st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            buf.append("select a.cid_codigo as codigoCidade, a.bai_codigo as codigoBairro, ");
            buf.append("b.cid_nome as nomeCidade, b.cid_uf as estadoCidade, c.bai_descricao as nomeBairro, ");
            buf.append("count(a.pac_codigo) as quantidadePaciente ");
            buf.append("from paciente a ");
            buf.append("left join cidades b on a.fil_codigo = b.fil_codigo and a.cid_codigo = b.cid_codigo ");
            buf.append("left join bairro c on a.fil_codigo = c.fil_codigo and a.bai_codigo = c.bai_codigo ");
            String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
            if (filiais == null) {
                filiais = new String[]{Variaveis.filialPadrao};
            }
            buf.append(" where a.fil_codigo in (");
            for (int i = 0; i < filiais.length; ++i) {
                buf.append(filiais[i]);
                if (i >= filiais.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
            String[] cidades = this.getSelecionadosFiltro("filtroCidade", 0);
            if (cidades != null) {
                buf.append(" and a.cid_codigo in (");
                for (int i = 0; i < cidades.length; ++i) {
                    buf.append(cidades[i]);
                    if (i >= cidades.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            }
            if ((bairros = this.getSelecionadosFiltro("filtroBairro", 0)) != null) {
                buf.append(" and a.bai_codigo in (");
                for (int i = 0; i < bairros.length; ++i) {
                    buf.append("'").append(bairros[i]).append("'");
                    if (i >= bairros.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            }
            buf.append(" group by a.cid_codigo, a.bai_codigo, b.cid_nome, b.cid_uf, c.bai_descricao ");
            buf.append(" order by b.cid_nome, ");
            String tmp = this.getFiltroCombo("filtroOrdem").toString();
            if (tmp.equals(this.ordem[0])) {
                buf.append("a.bai_codigo");
            } else if (tmp.equals(this.ordem[1])) {
                buf.append("c.bai_descricao");
            } else {
                buf.append("6 ");
            }
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(campos);
                do {
                    Object[] o = new Object[campos.length];
                    for (int i = 0; i < campos.length; ++i) {
                        o[i] = rs.getObject(campos[i]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioPacientesPorBairro.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    int i;
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioPacientesPorBairro.this.panelCentro.removeAll();
                            RelatorioPacientesPorBairro.this.panelCentro.repaint();
                            RelatorioPacientesPorBairro.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    buf.delete(0, buf.length());
                    if (cidades != null) {
                        for (i = 0; i < cidades.length; ++i) {
                            buf.append(cidades[i]);
                            if (i >= cidades.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroCidade", buf.toString());
                    buf.delete(0, buf.length());
                    if (bairros != null) {
                        for (i = 0; i < bairros.length; ++i) {
                            buf.append(bairros[i]);
                            if (i >= bairros.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroBairro", buf.toString());
                    var.put("filtroOrdem", this.getFiltroCombo("filtroOrdem"));
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
            Conexao.fecharStatement(st);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return new Long("0880101400");
    }
}

