/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.gerencial.recepcao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.laboratorio.relatorios.util.RelatorioUtil;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioExamesColetaMedico
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    public static final int TIPO_SOLICITADO = 1;
    public static final int TIPO_REALIZADO = 2;
    private int tipoRelatorio = 1;
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_COLETA = "filtroColeta";
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_MEDICO = "filtroMedico";
    private final String FILTRO_EXAME = "filtroExame";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_HORA_INICIAL = "filtroHoraInicial";
    private final String FILTRO_HORA_FINAL = "filtroHoraFinal";
    private final String FILTRO_INTERVALO_HORA = "intervaloHora";
    public static final String PARAMETROS_RELATORIOEXAMESREALIZADOS = "RelatorioExamesRealizadosSocilitados.ultimoFiltro";
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"crmMedico", "conselhoMedico", "ufmedico", "nomeMedico", "codigoConvenio", "razaoSocialConvenio", "comissaoMedicoConvenio", "comissaoMedico", "fantasiaConvenio", "qtdeExames", "valorTotalExame", "valorTotalCustoSimplesExameAtual", "valorTotalCustoSimplesExameHistorico", "codigoColeta", "descricaoColeta"});

    public RelatorioExamesColetaMedico(int tipoRelatorio) {
        this.tipoRelatorio = tipoRelatorio;
        String titulo = "";
        String descricao = "";
        String imagem = "";
        if (Variaveis.tipoFilialPadrao.equals("A")) {
            if (this.tipoRelatorio == 1) {
                titulo = "Relat\u00f3rio de Exames Solicitados por Coletador/Conv\u00eanio";
                imagem = "relatorios/rel_ger_exames_solicitados_coletador-exame.jpg";
                descricao = "Listagem das exames solicitados agrupados coleta, coletador e conv\u00eanio";
            } else {
                titulo = "Relat\u00f3rio de Exames Realizados por Coletador/Conv\u00eanio";
                descricao = "Listagem das exames realizados agrupados coleta, coletador e conv\u00eanio";
                imagem = "relatorios/rel_ger_exames_realizados_coletador-exame.jpg";
            }
        } else if (this.tipoRelatorio == 1) {
            titulo = "Relat\u00f3rio de Exames Solicitados por M\u00e9dico/Conv\u00eanio";
            imagem = "relatorios/rel_gerencia_exames_solicitados_medico-exame.jpg";
            descricao = "Listagem das exames solicitados agrupados coleta, m\u00e9dico e conv\u00eanio";
        } else {
            titulo = "Relat\u00f3rio de Exames Realizados por M\u00e9dico/Conv\u00eanio";
            descricao = "Listagem das exames realizados agrupados coleta, m\u00e9dico e conv\u00eanio";
            imagem = "relatorios/rel_ger_exames_realizados_medico-exame.jpg";
        }
        this.montaBarraDescricao(titulo, descricao, imagem);
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroColeta", "Coleta", "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltroAvancado("filtroMedico", "M\u00e9dico", "medico", "fil_codigo = " + Variaveis.filialPadrao, 4, new String[]{"med_conselho", "med_crm", "med_uf", "med_nome"}, new String[]{"Conselho", "N\u00famero", "UF", "Nome"}, new int[]{70, 70, 40, 0}, false, new int[]{0, 1, 2});
        this.adicionaItemFiltro("filtroExame", "Exame", "exames", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroHora("filtroHoraInicial", "Hora inicial:");
        this.adicionaFiltroHora("filtroHoraFinal", "Hora final:");
        this.adicionaFiltroCheck("intervaloHora", "Intervalo de Hora", false);
        this.setModuloConfigurar(this.getModuloConfigurar(this.tipoRelatorio));
        this.setModuloAcesso(RelatorioExamesColetaMedico.getModuloAcesso(this.tipoRelatorio));
        this.setCamposConfigurador(campos);
        String parametros = ParametrosUsuarios.getValor(PARAMETROS_RELATORIOEXAMESREALIZADOS);
        if (!Funcoes.textoVazio(parametros)) {
            String tmp = StringUtil.getValor(parametros, "filial");
            if (!Funcoes.textoVazio(tmp)) {
                this.setSelecionadosFiltro("filtroFilial", 0, tmp.split(","));
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "convenio"))) {
                this.setSelecionadosFiltro("filtroConvenio", 0, tmp.split(","));
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "coleta"))) {
                this.setSelecionadosFiltro("filtroColeta", 0, tmp.split(","));
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "exame"))) {
                this.setSelecionadosFiltro("filtroExame", 0, tmp.split(","));
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "datainicial"))) {
                this.setFiltroData("filtroDataInicial", tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "datafinal"))) {
                this.setFiltroData("filtroDataFinal", tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "horainicial"))) {
                this.setFiltroData("filtroHoraInicial", tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "horafinal"))) {
                this.setFiltroData("filtroHoraFinal", tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "intervaloHora"))) {
                this.setFiltroCheck("intervaloHora", tmp.equalsIgnoreCase("true"));
            }
        }
    }

    @Override
    public void imprimirPressionado() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Statement st = Conexao.getStatement();
        Statement stTemp = Conexao.getStatement();
        try {
            String[] exame;
            String[] coleta;
            String[] filiais;
            StringBuilder buf = new StringBuilder();
            buf.append("select ");
            buf.append(" SUM(COALESCE(emc.emc_custosimples,0.0)) as valorTotalCustoSimplesExameAtual, SUM(COALESCE(b.exr_custosimples,0.0)) as valorTotalCustoSimplesExameHistorico, coalesce(d.med_comissao, 0) as comissaoMedico, ");
            buf.append(" a.fil_codigo, a.med_crm as crmMedico, a.med_conselho as conselhoMedico, a.med_uf as ufMedico, pegavalorcomissaomedicoconvenio(a.fil_codigo, a.con_codigo, a.med_crm, a.med_conselho, a.med_uf) as comissaoMedicoConvenio, ");
            buf.append("a.con_codigo as codigoConvenio, c.con_fantasia as fantasiaConvenio, count(b.exa_codigo) as qtdeExames, ");
            buf.append(" sum(calculaprecototalexamerequisicao(a.fil_codigo, a.con_codigo, a.req_codigo, b.exa_codigo, b.mco_codigo, true, false, true, b.exr_vlrchexame, b.exr_vlrch, b.exr_valorporte, b.exr_valorcusto, b.exr_valoruco, b.exr_vlrbalcaoconvenio, b.exr_datafatura IS NOT NULL OR b.usr_codfatura IS NOT NULL, b.exr_vlrmaterial, b.exr_vlrbalcaoconvenio, c.con_precosdiferenciados, c.con_reajuste, c.con_cobrmaterial, c.con_percpgtomaterial, c.con_percpgto, c.con_tpcalcfatu, c.con_tpcalcch, c.con_perguntarpercbalcao, c.con_acrescimo, c.con_bonus, c.tpe_codigo, c.con_acrescimoporte, c.con_acrescimouco, c.con_descontoporte, c.con_descontouco, c.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", b.met_codigo").append(")) as valorTotalExame, ");
            buf.append(" c.con_razao as razaoSocialConvenio, d.med_nome as nomeMedico, e.col_codigo as codigoColeta, e.col_descricao as descricaoColeta ");
            if (this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
                buf.append(",").append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            }
            buf.append(" from ");
            buf.append(" requisicao a ");
            buf.append(" left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            buf.append(" left join examematcoleta emc ON emc.fil_codigo = b.fil_codigo AND emc.exa_codigo = b.exa_codigo AND emc.mco_codigo = b.mco_codigo");
            buf.append(" left join convenios c on a.fil_codigo = c.fil_codigo and a.con_codigo = c.con_codigo ");
            buf.append(" left join medico d on a.fil_codigo = d.fil_codigo and a.med_conselho = d.med_conselho and a.med_crm = d.med_crm and a.med_uf = d.med_uf ");
            buf.append(" left join coletas e on a.fil_codigo = e.fil_codigo and a.col_codigo = e.col_codigo ");
            if (this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            }
            if ((filiais = this.getSelecionadosFiltro("filtroFilial", 0)) == null) {
                filiais = new String[]{Variaveis.filialPadrao};
            }
            buf.append("where a.fil_codigo in (");
            for (int i = 0; i < filiais.length; ++i) {
                buf.append(filiais[i]);
                if (i >= filiais.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
            String[] convenio = this.getSelecionadosFiltro("filtroConvenio", 0);
            if (convenio != null) {
                buf.append(" and a.con_codigo in (");
                for (int i = 0; i < convenio.length; ++i) {
                    buf.append(convenio[i]);
                    if (i >= convenio.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((coleta = this.getSelecionadosFiltro("filtroColeta", 0)) != null) {
                buf.append(" and a.col_codigo in (");
                for (int i = 0; i < coleta.length; ++i) {
                    buf.append("'").append(coleta[i]).append("'");
                    if (i >= coleta.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            String[] conselho = this.getSelecionadosFiltroAvancado("filtroMedico", 0);
            String[] crm = this.getSelecionadosFiltroAvancado("filtroMedico", 1);
            String[] uf = this.getSelecionadosFiltroAvancado("filtroMedico", 2);
            if (conselho != null && crm != null && uf != null && crm.length <= ParametrosGerais.getQuantidadeMaximoFiltroAvancado()) {
                buf.append(" and (");
                for (int i = 0; i < crm.length; ++i) {
                    buf.append("(a.med_conselho = '");
                    buf.append(conselho[i]);
                    buf.append("' and a.med_crm = '");
                    buf.append(crm[i]);
                    buf.append("' and a.med_uf = '");
                    buf.append(uf[i]);
                    buf.append("')");
                    if (i >= crm.length - 1) continue;
                    buf.append(" or ");
                }
                buf.append(")");
            }
            if ((exame = this.getSelecionadosFiltro("filtroExame", 0)) != null) {
                buf.append(" and b.exa_codigo in (");
                for (int i = 0; i < exame.length; ++i) {
                    buf.append("'");
                    buf.append(exame[i]);
                    buf.append("'");
                    if (i >= exame.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if (!this.getFiltroCheck("intervaloHora")) {
                if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                    buf.append(" and a.req_data >= '");
                    buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial")));
                    buf.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                    buf.append(" and a.req_data <= '");
                    buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal")));
                    buf.append("'");
                }
                if (Funcoes.verificaHora(this.getFiltroHora("filtroHoraInicial"))) {
                    buf.append(" and a.req_hora >= '");
                    buf.append(this.getFiltroHora("filtroHoraInicial"));
                    buf.append("'");
                }
                if (Funcoes.verificaHora(this.getFiltroHora("filtroHoraFinal"))) {
                    buf.append(" and a.req_hora <= '");
                    buf.append(this.getFiltroHora("filtroHoraFinal"));
                    buf.append("'");
                }
            } else {
                buf.append(" and (a.req_data + a.req_hora >= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial")));
                buf.append(" ");
                buf.append(this.getFiltroHora("filtroHoraInicial"));
                buf.append("') and (a.req_data + a.req_hora <= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal")));
                buf.append(" ");
                buf.append(this.getFiltroHora("filtroHoraFinal"));
                buf.append("')");
            }
            if (this.tipoRelatorio == 2) {
                buf.append(" and b.exr_situacao not in ('");
                buf.append("T");
                buf.append("', '");
                buf.append("A");
                buf.append("', '");
                buf.append("F");
                buf.append("', '").append("R");
                buf.append("', '', ' ') and b.exr_situacao is not null ");
            }
            buf.append(" and a.req_excluida = false and b.exr_excluido = false ");
            buf.append(" group by a.fil_codigo, ");
            buf.append(" a.med_crm, a.med_conselho, a.med_uf, a.con_codigo, c.con_razao, c.con_fantasia, d.med_nome, e.col_codigo, e.col_descricao, d.med_comissao ");
            if (this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
                buf.append(", a.fil_codigo ");
                for (String s : Constantes.CAMPOS_FILIAL) {
                    buf.append(", ").append(s);
                }
            }
            buf.append(" order by ");
            if (this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
                buf.append("a.fil_codigo, ");
            }
            buf.append("e.col_codigo, a.med_crm, a.med_conselho, a.med_uf, c.con_fantasia, a.con_codigo ");
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(campos);
                do {
                    Object[] o = new Object[campos.length];
                    for (int i = 0; i < campos.length; ++i) {
                        if (RelatorioUtil.possuiColuna(rs, campos[i]) <= -1) continue;
                        o[i] = rs.getObject(campos[i]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                String codigoFilial = Variaveis.filialPadrao;
                if (this.getSelecionadosFiltro("filtroFilial", 0) != null && this.getSelecionadosFiltro("filtroFilial", 0).length == 1) {
                    codigoFilial = this.getSelecionadosFiltro("filtroFilial", 0)[0];
                }
                Registro regFilial = RelatorioUtil.pegaDadosFilial(st, codigoFilial);
                RelatorioUtil.preencheDadosFilial(regFilial, modelo);
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioExamesColetaMedico.getModuloAcesso(this.tipoRelatorio));
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next() && modelo.getRowCount() > 0) {
                    int i;
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioExamesColetaMedico.this.panelCentro.removeAll();
                            RelatorioExamesColetaMedico.this.panelCentro.repaint();
                            RelatorioExamesColetaMedico.this.habilitaBotaoImprimir(true);
                        }
                    });
                    StringBuilder p = new StringBuilder();
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                    var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                    var.put("filtroHoraInicial", this.getFiltroHora("filtroHoraInicial"));
                    var.put("filtroHoraFinal", this.getFiltroHora("filtroHoraFinal"));
                    p.append("<datainicial>").append(this.getFiltroData("filtroDataInicial")).append("</datainicial>");
                    p.append("<datafinal>").append(this.getFiltroData("filtroDataFinal")).append("</datafinal>");
                    p.append("<horainicial>").append(this.getFiltroHora("filtroHoraInicial")).append("</horainicial>");
                    p.append("<horafinal>").append(this.getFiltroHora("filtroHoraFinal")).append("</horafinal>");
                    buf.delete(0, buf.length());
                    if (filiais != null) {
                        p.append("<filial>");
                        for (i = 0; i < filiais.length; ++i) {
                            buf.append(filiais[i]);
                            if (i >= filiais.length - 1) continue;
                            buf.append(",");
                        }
                        p.append(buf.toString());
                        p.append("</filial>");
                    }
                    var.put("filtroFilial", buf.toString());
                    buf.delete(0, buf.length());
                    if (convenio != null) {
                        p.append("<convenio>");
                        for (i = 0; i < convenio.length; ++i) {
                            buf.append(convenio[i]);
                            if (i >= convenio.length - 1) continue;
                            buf.append(",");
                        }
                        p.append(buf.toString());
                        p.append("</convenio>");
                    }
                    var.put("filtroConvenio", buf.toString());
                    buf.delete(0, buf.length());
                    if (coleta != null) {
                        p.append("<coleta>");
                        for (i = 0; i < coleta.length; ++i) {
                            buf.append(coleta[i]);
                            if (i >= coleta.length - 1) continue;
                            buf.append(",");
                        }
                        p.append(buf.toString());
                        p.append("</coleta>");
                    }
                    var.put("filtroColeta", buf.toString());
                    buf.delete(0, buf.length());
                    if (conselho != null && crm != null && uf != null) {
                        for (i = 0; i < crm.length; ++i) {
                            buf.append(conselho[i]).append(": ");
                            buf.append(crm[i]);
                            buf.append("(");
                            buf.append(uf[i]);
                            buf.append(")");
                            if (i >= crm.length - 1) continue;
                            buf.append(",");
                        }
                    }
                    var.put("filtroMedico", buf.toString());
                    buf.delete(0, buf.length());
                    if (exame != null) {
                        p.append("<exame>");
                        for (i = 0; i < exame.length; ++i) {
                            buf.append(exame[i]);
                            if (i >= exame.length - 1) continue;
                            buf.append(",");
                        }
                        p.append(buf.toString());
                        p.append("</exame>");
                    }
                    var.put("filtroExame", buf.toString());
                    ParametrosUsuarios.setValor(PARAMETROS_RELATORIOEXAMESREALIZADOS, p.toString());
                    ParametrosUsuarios.salvarParametros(true);
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                } else if (modelo.getRowCount() == 0) {
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
            Conexao.fecharStatement(st);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso(int tipoRelatorio) {
        if (tipoRelatorio == 1) {
            return Long.parseLong("0880101500");
        }
        return Long.parseLong("0880101600");
    }

    private long getModuloConfigurar(int tipoRelatorio) {
        if (tipoRelatorio == 1) {
            return Long.parseLong("0880101501");
        }
        return Long.parseLong("0880101601");
    }
}

