/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.gerencial.recepcao;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.laboratorio.relatorios.util.RelatorioUtil;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioAgendamentoAcumuladoPorConvenio
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_SALA = "filtroSala";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_HORA_INICIAL = "filtroHoraInicial";
    private final String FILTRO_HORA_FINAL = "filtroHoraFinal";
    private final String FILTRO_INTERVALO_HORA = "filtroIntervaloHora";
    private final String FILTRO_SITUACAO = "filtroSituacao";
    private final String FILTRO_ORDEM = "filtroOrdem";
    private final String FILTRO_REMARCADO = "filtroRemarcado";
    private final String FILTRO_CANCELADO = "filtroCancelado";
    private final String[] situacao = new String[]{"Todas", Tipos.tipoSituacaoAgendamento("A"), Tipos.tipoSituacaoAgendamento("T"), Tipos.tipoSituacaoAgendamento("F")};
    private final String[] campos = new String[]{"codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio", "cnpjConvenio", "codigoReqisicao", "codigoExame", "observacaoConvenio", "tipoPagamentoConvenio", "faturarFaltaMaterialConvenio", "endefarecoConvenio", "cepCobrancaConvenio", "complementoCobrancaConvenio", "enderecoCobrancaConvenio", "faxConvenio", "foneConvenio", "inscricaoMunicipalConvenio", "codigoSalaAtendimento", "descricaoSalaAtendimento", "quantidadeRequisicoes", "quantidadeExames", "numeroEnderecoConvenio", "numeroEnderecoCobrancaConvenio", "tipoLogradouroConvenio", "tipoLogradouroCobrancaConvenio"};
    private final String[] camposRelatorio = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, this.campos);

    public RelatorioAgendamentoAcumuladoPorConvenio() {
        this.montaBarraDescricao("Relat\u00f3rio de Agendamento Acumulado por Conv\u00eanio", "Listagem de quantidade de exames e requisi\u00e7\u00f5es Agendadas por conv\u00eanio", "relatorios/rel_ger_acumulado_agenda_convenio.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroSala", "Sala", "salaatendimento", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"sal_codigo", "sal_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "Data Inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data Final:");
        this.adicionaFiltroHora("filtroHoraInicial", "Hora Inicial:");
        this.adicionaFiltroHora("filtroHoraFinal", "Hora Final:");
        this.adicionaFiltroCombo("filtroSituacao", "Situa\u00e7\u00e3o:", this.situacao, 0);
        this.adicionaFiltroCheck("filtroIntervaloHora", "Intervalo de Hora", false);
        this.adicionaFiltroCheck("filtroRemarcado", "Mostrar remarcados", false);
        this.adicionaFiltroCheck("filtroCancelado", "Mostrar cancelados", false);
        this.setModuloConfigurar(RelatorioAgendamentoAcumuladoPorConvenio.getModuloConfigurar());
        this.setModuloAcesso(RelatorioAgendamentoAcumuladoPorConvenio.getModuloAcesso());
        this.setCamposConfigurador(this.camposRelatorio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement st;
        block35: {
            String s;
            String[] convenio;
            this.setCursor(Cursor.getPredefinedCursor(3));
            boolean intervaloHora = this.getFiltroCheck("filtroIntervaloHora");
            StringBuilder buf = new StringBuilder();
            buf.append(" SELECT con.con_codigo, count(distinct req.req_codigo) as quantidadeRequisicoes ");
            buf.append("  ,count(a.exa_codigo) as quantidadeExames ");
            buf.append(" \t,req.fil_codigo as codigoFilial ");
            buf.append("\t,sal.sal_codigo\t\t\t  as codigoSalaAtendimento\t");
            buf.append("\t,sal.sal_descricao \t\tas descricaoSalaAtendimento\t");
            buf.append("\t,con.con_codigo \t \t\tas codigoConvenio\t");
            buf.append("\t,con.con_razao \t  \t\tas razaoSocialConvenio\t");
            buf.append("\t,con.con_fantasia  \t\tas fantasiaConvenio\t");
            buf.append("\t,con.con_cnpjcpf\t  \tas cnpjConvenio\t");
            buf.append("\t,con.con_observ \t  \tas observacaoConvenio\t");
            buf.append("\t,con.con_fatfmaterial as faturarFaltaMaterial\t");
            buf.append("\t,con.con_endereco  \t\tas convenioEndereco\t");
            buf.append("\t,con.con_numeroendereco as numeroEnderecoConvenio ");
            buf.append("  ,con.con_tipologradouroendereco as tipoLogradouroConvenio ");
            buf.append("\t,con.con_numeroendcobranca as numeroEnderecoCobrancaConvenio ");
            buf.append("\t,con.con_tipologradouroendcobranca as tipoLogradouroCobrancaConvenio ");
            buf.append("\t,con.con_cepcobranca  as cepCobrancaConvenio\t");
            buf.append("\t,con.con_complemento \tas complementocobrancaConvenio\t");
            buf.append("\t,con.con_endcobranca  as enderecoCobrancaConvenio\t");
            buf.append("\t,con.con_fax\t\t\t\t\tas faxConvenio\t");
            buf.append("\t,con.con_fone\t\t\t\t\tas foneConvenio\t");
            buf.append("\t,con.con_inscmunic\t\tas incricaoMunicipalConvenio\t");
            buf.append(" from examerequisicao a ");
            buf.append(" JOIN requisicao req ON a.fil_codigo = req.fil_codigo AND a.req_codigo = req.req_codigo ");
            buf.append(" JOIN agendamento agd ON a.fil_codigo = agd.fil_codigo AND req.req_codigo = agd.req_codigo ");
            buf.append(" JOIN convenios con ON req.fil_codigo = con.fil_codigo AND req.con_codigo = con.con_codigo ");
            buf.append(" JOIN salaatendimento sal ON agd.fil_codigo = sal.fil_codigo AND agd.sal_codigo = sal.sal_codigo ");
            String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
            if (filiais == null) {
                filiais = new String[]{Variaveis.filialPadrao};
            }
            buf.append(" WHERE a.fil_codigo in (");
            for (int i = 0; i < filiais.length; ++i) {
                buf.append(filiais[i]);
                if (i >= filiais.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
            String[] sala = this.getSelecionadosFiltro("filtroSala", 0);
            if (sala != null) {
                buf.append(" AND sal.sal_codigo in (");
                for (int i = 0; i < sala.length; ++i) {
                    buf.append(sala[i]);
                    if (i >= sala.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            }
            if ((convenio = this.getSelecionadosFiltro("filtroConvenio", 0)) != null) {
                buf.append(" AND con.con_codigo in (");
                for (int i = 0; i < convenio.length; ++i) {
                    buf.append(convenio[i]);
                    if (i >= convenio.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            }
            if (intervaloHora) {
                if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial")) && Funcoes.verificaHora(this.getFiltroHora("filtroHoraInicial"))) {
                    buf.append(" AND date_trunc('minute', agd.agd_datahoraagenda) >= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial"))).append(" ").append(this.getFiltroHora("filtroHoraInicial"));
                    buf.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal")) && Funcoes.verificaHora(this.getFiltroHora("filtroHoraFinal"))) {
                    buf.append(" AND date_trunc('minute', agd.agd_datahoraagenda) <= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataFinal"))).append(" ").append(this.getFiltroHora("filtroHoraFinal"));
                    buf.append("'");
                }
            } else {
                if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                    buf.append(" AND cast(agd.agd_datahoraagenda as date) >= '").append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial"))).append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                    buf.append(" AND cast(agd.agd_datahoraagenda as date) <= '").append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataFinal"))).append("'");
                }
                if (!Funcoes.textoVazio(this.getFiltroHora("filtroHoraInicial")) && Funcoes.verificaHora(this.getFiltroHora("filtroHoraInicial"))) {
                    buf.append(" AND cast(agd.agd_datahoraagenda as time) >= '").append(this.getFiltroHora("filtroHoraInicial")).append("'");
                }
                if (!Funcoes.textoVazio(this.getFiltroHora("filtroHoraInicial")) && Funcoes.verificaHora(this.getFiltroHora("filtroHoraFinal"))) {
                    buf.append(" AND cast(agd.agd_datahoraagenda as time) <= '").append(this.getFiltroHora("filtroHoraFinal")).append("'");
                }
            }
            if ((s = this.getFiltroCombo("filtroSituacao").toString()).equals(this.situacao[1])) {
                buf.append(" AND agd.agd_situacao = '").append("A").append("' ");
            } else if (s.equals(this.situacao[2])) {
                buf.append(" AND agd.agd_situacao = '").append("T").append("' ");
            } else if (s.equals(this.situacao[3])) {
                buf.append(" AND agd.agd_situacao = '").append("F").append("' ");
            }
            if (!this.getFiltroCheck("filtroRemarcado")) {
                buf.append(" AND agd.agd_situacao <> '").append("R").append("' ");
            }
            if (!this.getFiltroCheck("filtroCancelado")) {
                buf.append(" AND agd.agd_situacao <> '").append("C").append("' ");
            }
            buf.append(" AND (req.req_origemagendamento = true or (req.req_excluida = false  AND a.exr_excluido = false))  ");
            buf.append(" AND a.exr_excluido = false ");
            buf.append(" group by con.con_codigo ");
            buf.append("\t,con.con_razao \t");
            buf.append("\t,con.con_fantasia");
            buf.append("\t,con.con_cnpjcpf");
            buf.append("\t,con.con_observ ");
            buf.append("\t,con.con_fatfmaterial");
            buf.append("\t,con.con_endereco  \t");
            buf.append("\t,con.con_numeroendereco ");
            buf.append("\t,con.con_tipologradouroendereco ");
            buf.append("\t,con.con_numeroendcobranca ");
            buf.append("\t,con.con_tipologradouroendcobranca ");
            buf.append("\t,con.con_cepcobranca   ");
            buf.append("\t,con.con_complemento \t");
            buf.append("\t,con.con_endcobranca  \t");
            buf.append("\t,con.con_fax\t\t");
            buf.append("\t,con.con_fone\t\t");
            buf.append("\t,con.con_inscmunic ");
            buf.append("\t,sal.sal_codigo ");
            buf.append("\t,sal.sal_descricao ");
            buf.append("\t,req.fil_codigo ");
            buf.append(" order by sal.sal_codigo, con.con_codigo ");
            st = Conexao.getStatement();
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    int i;
                    ModeloGridTable modelo = new ModeloGridTable(this.camposRelatorio);
                    do {
                        Object[] o = new Object[this.camposRelatorio.length];
                        int pos = -1;
                        for (i = 0; i < this.camposRelatorio.length; ++i) {
                            if (RelatorioUtil.possuiColuna(rs, this.camposRelatorio[i]) <= -1) continue;
                            pos = modelo.findColumn(this.camposRelatorio[i]);
                            o[pos] = this.camposRelatorio[i].equalsIgnoreCase("tipoLogradouroConvenio") || this.camposRelatorio[i].equalsIgnoreCase("tipoLogradouroCobrancaConvenio") ? Tipos.tipoLogradouroDescricao(rs.getString(this.camposRelatorio[i])) : rs.getObject(this.camposRelatorio[i]);
                        }
                        modelo.addLine(o);
                    } while (rs.next());
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(RelatorioAgendamentoAcumuladoPorConvenio.getModuloAcesso());
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(0.5f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioAgendamentoAcumuladoPorConvenio.this.panelCentro.removeAll();
                                RelatorioAgendamentoAcumuladoPorConvenio.this.panelCentro.repaint();
                                RelatorioAgendamentoAcumuladoPorConvenio.this.habilitaBotaoImprimir(true);
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put("filtroOrdem", this.getFiltroCombo("filtroOrdem"));
                        var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                        var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                        var.put("filtroHoraInicial", this.getFiltroData("filtroHoraInicial"));
                        var.put("filtroHoraFinal", this.getFiltroData("filtroHoraFinal"));
                        var.put("filtroRemarcado", this.getFiltroCheck("filtroRemarcado") ? "Sim" : "N\u00e3o");
                        var.put("filtroCancelado", this.getFiltroCheck("filtroCancelado") ? "Sim" : "N\u00e3o");
                        var.put("filtroIntervaloHora", this.getFiltroCheck("filtroIntervaloHora") ? "Sim" : "N\u00e3o");
                        var.put("filtroSituacao", this.getFiltroCombo("filtroSituacao"));
                        buf.delete(0, buf.length());
                        if (filiais != null) {
                            for (i = 0; i < filiais.length; ++i) {
                                buf.append(filiais[i]);
                                if (i >= filiais.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroFilial", buf.toString());
                        buf.delete(0, buf.length());
                        if (convenio != null) {
                            for (i = 0; i < convenio.length; ++i) {
                                buf.append(convenio[i]);
                                if (i >= convenio.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroConvenio", buf.toString());
                        buf.delete(0, buf.length());
                        if (sala != null) {
                            for (i = 0; i < sala.length; ++i) {
                                buf.append(sala[i]);
                                if (i >= sala.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroSala", buf.toString());
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelCentro.revalidate();
                    }
                    break block35;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0880301100");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0880301101");
    }
}

