/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.gerencial;

import jalis.comum.Conexao;
import jalis.comum.ConstantesGerais;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.ValorCustoExameProducaoMensal;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.table.TableModel;

public class RelatorioResumoProducaoMensal
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private static final double VALOR_PADRAO = 0.0;
    private static final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_ANO = "filtroAno";
    private static final String FILTRO_MES = "filtroMes";
    protected static String[] campos;
    private final String[] MESES = ConstantesGerais.MESES_ANO;

    public RelatorioResumoProducaoMensal() {
        String[] campoSoma = new String[]{"somaTotalReceber", "somaTotalPagar", "somaTotalExame", "somaDias", "somaValorTotalRequisicao", "somaTotalPagoRequisicao", "somaValorTotalDesconto", "somaValorTotalAcrescimo", "somaValorAcumuladoMensalFaturar", "somaTotalFaturado", "somaTotalFaturar", "somaRealRecebido", "somaRealPago", "somaTotalRequisicao", "somaTotalPrevisto", "somaTotalReal", "somaPrevisto", "somaReal", "somaTotalCustoSimplesExameHistorico", "somaExameRequisicao", "somaTotalCustoSimplesExameAtual", "valorDiarioContasCaixa", "valorDiarioContasCaixaConciliado", "valorDiarioContasCorrente", "valorDiarioContasCorrenteConciliado"};
        campos = ArraysUtil.concatenar(new String[]{"mes", "totalExame", "totalRequisicao", "dias", "totalFaturar", "totalFaturado", "valorTotalRequisicao", "totalPagoRequisicao", "valorTotalDesconto", "valorTotalAcrescimo", "valorAcumuladoMensalFaturar", "totalReceber", "totalPagar", "realRecebido", "realPago", "mesCod", FILTRO_FILIAL, "totalCustoSimplesExameHistorico", "totalCustoSimplesExameAtual", "exameRequisicao", "quantidadeDiasMes"}, campoSoma);
        this.montaBarraDescricao("Resumo de produ\u00e7\u00e3o mensal", "Resumo de produ\u00e7\u00e3o mensal", "relatorios/rel_ger_analitico_producao_mensal.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro(FILTRO_FILIAL, "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroNumero("filtroAno", "Ano:", 4);
        this.adicionaFiltroCombo(FILTRO_MES, "M\u00eas:", this.MESES, 0);
        this.setModuloConfigurar(RelatorioResumoProducaoMensal.getModuloConfigurar());
        this.setModuloAcesso(RelatorioResumoProducaoMensal.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    @Override
    public void imprimirPressionado() {
        if (StringUtil.isEmpty(this.getFiltroTexto("filtroAno"))) {
            Funcoes.mensagem(this, "O ano deve ser informado.", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        BigDecimal somaTotalReceber = BigDecimal.ZERO;
        BigDecimal somaTotalPagar = BigDecimal.ZERO;
        BigDecimal somaValorTotalRequisicao = BigDecimal.ZERO;
        BigDecimal somaTotalPagoRequisicao = BigDecimal.ZERO;
        BigDecimal somaValorTotalDesconto = BigDecimal.ZERO;
        BigDecimal somaValorTotalAcrescimo = BigDecimal.ZERO;
        BigDecimal somaValorAcumuladoMensalFaturar = BigDecimal.ZERO;
        BigDecimal somaTotalFaturado = BigDecimal.ZERO;
        BigDecimal somaTotalFaturar = BigDecimal.ZERO;
        BigDecimal somaRealRecebido = BigDecimal.ZERO;
        BigDecimal somaRealPago = BigDecimal.ZERO;
        BigDecimal somaExameRequisicao = BigDecimal.ZERO;
        BigDecimal somaTotalPrevisto = BigDecimal.ZERO;
        BigDecimal somaTotalReal = BigDecimal.ZERO;
        BigDecimal somaPrevisto = BigDecimal.ZERO;
        BigDecimal somaReal = BigDecimal.ZERO;
        BigDecimal somaTotalCustoSimplesAtual = BigDecimal.ZERO;
        BigDecimal somaTotalCustoSimplesHistorico = BigDecimal.ZERO;
        BigDecimal somaDiarioContasCorrenteConciliado = BigDecimal.ZERO;
        BigDecimal somaDiarioContasCaixaConciliado = BigDecimal.ZERO;
        BigDecimal somaDiarioContasCorrente = BigDecimal.ZERO;
        BigDecimal somaDiarioContasCaixa = BigDecimal.ZERO;
        String filial = "";
        Integer somaTotalRequisicao = 0;
        Integer somaTotalExame = 0;
        try {
            filial = this.getDescricaoFilial();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "RelatorioExameMesPorAno");
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        Statement st = Conexao.getStatement();
        SplashMensagem splashMensagem = SplashMensagem.getInstancia(this);
        try {
            StringBuilder sql = new StringBuilder();
            ModeloGridTable modelo = new ModeloGridTable(campos);
            ResultSet rs = null;
            HashSet<Integer> diaEncontrado = new HashSet<Integer>();
            splashMensagem.mostrar("");
            Calendar calFinal = Calendar.getInstance();
            calFinal.setTime(Funcoes.getData("dd/MM/yyyy", "01/" + (this.getFiltroComboIndice(FILTRO_MES) + 1) + "/" + this.getFiltroTexto("filtroAno")));
            int diaMaximo = calFinal.getActualMaximum(5);
            splashMensagem.setText("Processando m\u00eas de " + ConstantesGerais.MESES_ANO[this.getFiltroComboIndice(FILTRO_MES)] + " de " + this.getFiltroTexto("filtroAno"));
            HashMap<Integer, BigDecimal> totaisFaturar = this.getTotalFaturar();
            HashMap<Integer, BigDecimal> totaisFaturados = this.getTotalFaturado();
            HashMap<Integer, BigDecimal> valorReceber = this.getValorReceberPagar("R");
            HashMap<Integer, BigDecimal> valorPagar = this.getValorReceberPagar("P");
            HashMap<Integer, BigDecimal> totalRequisicao = this.getTotalRequisicao();
            HashMap<Integer, BigDecimal> totalExame = this.getTotalExame();
            HashMap<Integer, BigDecimal> valorTotalRequisicao = this.getValorTotalRequisicao();
            HashMap<Integer, BigDecimal> valorTotalPagoRequisicao = this.getValorTotalPagoRequisicao();
            HashMap<Integer, BigDecimal> valorTotalDesconto = this.getValorTotalDesconto();
            HashMap<Integer, BigDecimal> valorTotalAcrescimo = this.getValorTotalAcrescimo();
            HashMap<Integer, BigDecimal> valorAcumuladoMensalFaturar = this.getValorAcumuladoMensalFaturar();
            HashMap<Integer, ValorCustoExameProducaoMensal> geValorTotalCustoSimplesExame = this.geValorTotalCustoSimplesExame();
            HashMap<Integer, BigDecimal> valorRealRecebidoReceber = this.getValorRealRecebidoPago("R");
            HashMap<Integer, BigDecimal> valorRealRecebidoPagar = this.getValorRealRecebidoPago("P");
            Map<Integer, BigDecimal> valorDiarioContasCaixa = this.getValorDiarioContasCaixa();
            Map<Integer, BigDecimal> valorDiarioContasCorrente = this.getValorDiarioContasCorrente();
            Map<Integer, BigDecimal> valorDiarioContasCaixaConciliado = this.getValorDiarioContasCaixaConciliado();
            Map<Integer, BigDecimal> valorDiarioContasCorrenteConciliado = this.getValorDiarioContasCorrenteConciliado();
            for (int diaConsulta = 1; diaConsulta <= diaMaximo; ++diaConsulta) {
                Object[] o = new Object[campos.length];
                for (int i = 0; i < campos.length; ++i) {
                    Number valor;
                    if (campos[i].equalsIgnoreCase("totalReceber")) {
                        valor = valorReceber.containsKey(diaConsulta) ? valorReceber.get(diaConsulta) : BigDecimal.ZERO;
                        somaTotalReceber = somaTotalReceber.add((BigDecimal)valor);
                        o[i] = valor;
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("totalPagar")) {
                        valor = valorPagar.containsKey(diaConsulta) ? valorPagar.get(diaConsulta) : BigDecimal.ZERO;
                        somaTotalPagar = somaTotalPagar.add((BigDecimal)valor);
                        o[i] = valor;
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("mes")) {
                        o[i] = this.MESES[this.getFiltroComboIndice(FILTRO_MES)];
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("totalRequisicao")) {
                        valor = totalRequisicao.containsKey(diaConsulta) ? totalRequisicao.get(diaConsulta).intValue() : 0;
                        somaTotalRequisicao = somaTotalRequisicao + (Integer)valor;
                        o[i] = this.validarValor(valor);
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("totalExame")) {
                        valor = totalExame.containsKey(diaConsulta) ? totalExame.get(diaConsulta).intValue() : 0;
                        somaTotalExame = somaTotalExame + (Integer)valor;
                        o[i] = this.validarValor(valor);
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("dias")) {
                        o[i] = diaConsulta;
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("valorTotalRequisicao")) {
                        valor = valorTotalRequisicao.containsKey(diaConsulta) ? valorTotalRequisicao.get(diaConsulta) : BigDecimal.ZERO;
                        somaValorTotalRequisicao = somaValorTotalRequisicao.add((BigDecimal)valor).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                        o[i] = valor;
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("totalPagoRequisicao")) {
                        valor = valorTotalPagoRequisicao.containsKey(diaConsulta) ? valorTotalPagoRequisicao.get(diaConsulta) : BigDecimal.ZERO;
                        somaTotalPagoRequisicao = somaTotalPagoRequisicao.add((BigDecimal)valor).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                        o[i] = valor;
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("valorTotalDesconto")) {
                        valor = valorTotalDesconto.containsKey(diaConsulta) ? valorTotalDesconto.get(diaConsulta) : BigDecimal.ZERO;
                        somaValorTotalDesconto = somaValorTotalDesconto.add((BigDecimal)valor).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                        o[i] = valor;
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("valorTotalAcrescimo")) {
                        valor = valorTotalAcrescimo.containsKey(diaConsulta) ? valorTotalAcrescimo.get(diaConsulta) : BigDecimal.ZERO;
                        somaValorTotalAcrescimo = somaValorTotalAcrescimo.add((BigDecimal)valor).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                        o[i] = valor;
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("valorAcumuladoMensalFaturar")) {
                        valor = valorAcumuladoMensalFaturar.containsKey(diaConsulta) ? valorAcumuladoMensalFaturar.get(diaConsulta) : BigDecimal.ZERO;
                        somaValorAcumuladoMensalFaturar = somaValorAcumuladoMensalFaturar.add((BigDecimal)valor).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                        o[i] = valor;
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("totalFaturado")) {
                        valor = totaisFaturados.containsKey(diaConsulta) ? totaisFaturados.get(diaConsulta) : BigDecimal.ZERO;
                        valor = (BigDecimal)this.validarValor(valor);
                        somaTotalFaturado = somaTotalFaturado.add((BigDecimal)valor).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                        o[i] = valor;
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("totalFaturar")) {
                        valor = totaisFaturar.containsKey(diaConsulta) ? totaisFaturar.get(diaConsulta) : BigDecimal.ZERO;
                        somaTotalFaturar = somaTotalFaturar.add((BigDecimal)valor).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                        o[i] = valor;
                        continue;
                    }
                    if (campos[i].contains("totalCustoSimplesExameHistorico")) {
                        ValorCustoExameProducaoMensal custos = geValorTotalCustoSimplesExame.containsKey(diaConsulta) ? geValorTotalCustoSimplesExame.get(diaConsulta) : new ValorCustoExameProducaoMensal();
                        BigDecimal valorHistorico = custos == null ? BigDecimal.ZERO : new BigDecimal(custos.getSomaTotalCustoSimplesExameHistorico());
                        BigDecimal valorAtual = custos == null ? BigDecimal.ZERO : new BigDecimal(custos.getSomaTotalCustoSimplesExameAtual());
                        somaTotalCustoSimplesHistorico = somaTotalCustoSimplesHistorico.add(valorHistorico).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                        somaTotalCustoSimplesAtual = somaTotalCustoSimplesAtual.add(valorAtual).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                        o[modelo.findColumn((String)"totalCustoSimplesExameAtual")] = valorAtual;
                        o[i] = valorHistorico;
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("realRecebido")) {
                        valor = valorRealRecebidoReceber.containsKey(diaConsulta) ? valorRealRecebidoReceber.get(diaConsulta) : BigDecimal.ZERO;
                        somaRealRecebido = somaRealRecebido.add((BigDecimal)valor).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                        o[i] = valor;
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("realPago")) {
                        valor = valorRealRecebidoPagar.containsKey(diaConsulta) ? valorRealRecebidoPagar.get(diaConsulta) : BigDecimal.ZERO;
                        somaRealPago = somaRealPago.add((BigDecimal)valor).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                        o[i] = valor;
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("valorDiarioContasCorrenteConciliado")) {
                        valor = valorDiarioContasCorrenteConciliado.containsKey(diaConsulta) ? valorDiarioContasCorrenteConciliado.get(diaConsulta) : BigDecimal.ZERO;
                        somaDiarioContasCorrenteConciliado = somaDiarioContasCorrenteConciliado.add((BigDecimal)valor);
                        o[i] = valor;
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("valorDiarioContasCaixaConciliado")) {
                        valor = valorDiarioContasCaixaConciliado.containsKey(diaConsulta) ? valorDiarioContasCaixaConciliado.get(diaConsulta) : BigDecimal.ZERO;
                        somaDiarioContasCaixaConciliado = somaDiarioContasCaixaConciliado.add((BigDecimal)valor);
                        o[i] = valor;
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("valorDiarioContasCaixa")) {
                        valor = valorDiarioContasCaixa.containsKey(diaConsulta) ? valorDiarioContasCaixa.get(diaConsulta) : BigDecimal.ZERO;
                        somaDiarioContasCaixa = somaDiarioContasCaixa.add((BigDecimal)valor);
                        o[i] = valor;
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("valorDiarioContasCorrente")) {
                        valor = valorDiarioContasCorrente.containsKey(diaConsulta) ? valorDiarioContasCorrente.get(diaConsulta) : BigDecimal.ZERO;
                        somaDiarioContasCorrente = somaDiarioContasCorrente.add((BigDecimal)valor);
                        o[i] = valor;
                        continue;
                    }
                    o[i] = campos[i].equals(FILTRO_FILIAL) ? filial : Double.valueOf(0.0);
                }
                o[this.obterPosicao((Object[])RelatorioResumoProducaoMensal.campos)] = diaConsulta;
                diaEncontrado.add(diaConsulta);
                modelo.addLine(o);
            }
            modelo.ordenarColuna(modelo.findColumn("mesCod"));
            Object[] linhaSomaTotal = new Object[campos.length];
            for (int i = 0; i < campos.length; ++i) {
                if (campos[i].equals("somaTotalFaturar")) {
                    linhaSomaTotal[i] = somaTotalFaturar.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                }
                if (campos[i].equalsIgnoreCase("quantidadeDiasMes")) {
                    linhaSomaTotal[i] = diaMaximo;
                }
                if (campos[i].equals("somaTotalFaturado")) {
                    linhaSomaTotal[i] = somaTotalFaturado.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                }
                if (campos[i].equals("somaValorTotalRequisicao")) {
                    linhaSomaTotal[i] = somaValorTotalRequisicao.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                }
                if (campos[i].equals("somaTotalPagoRequisicao")) {
                    linhaSomaTotal[i] = somaTotalPagoRequisicao.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                }
                if (campos[i].equals("somaValorTotalDesconto")) {
                    linhaSomaTotal[i] = somaValorTotalDesconto.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                }
                if (campos[i].equals("somaValorTotalAcrescimo")) {
                    linhaSomaTotal[i] = somaValorTotalAcrescimo.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                }
                if (campos[i].equals("somaValorAcumuladoMensalFaturar")) {
                    linhaSomaTotal[i] = somaValorAcumuladoMensalFaturar.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                }
                if (campos[i].equals("somaTotalReceber")) {
                    linhaSomaTotal[i] = somaTotalReceber.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                }
                if (campos[i].equals("somaTotalPagar")) {
                    linhaSomaTotal[i] = somaTotalPagar.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                }
                if (campos[i].equals("somaRealRecebido")) {
                    linhaSomaTotal[i] = somaRealRecebido.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                }
                if (campos[i].equals("somaRealPago")) {
                    linhaSomaTotal[i] = somaRealPago.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                }
                if (campos[i].equals("somaTotalRequisicao")) {
                    linhaSomaTotal[i] = somaTotalRequisicao;
                }
                if (campos[i].equals("somaTotalExame")) {
                    linhaSomaTotal[i] = somaTotalExame;
                }
                if (campos[i].equals("somaExameRequisicao")) {
                    if (somaTotalExame.doubleValue() > 0.0 && somaTotalRequisicao.doubleValue() > 0.0) {
                        somaExameRequisicao = somaExameRequisicao.add(BigDecimal.valueOf(somaTotalExame.doubleValue() / somaTotalRequisicao.doubleValue()));
                    }
                    linhaSomaTotal[i] = somaExameRequisicao.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                }
                if (campos[i].equals("somaTotalPrevisto")) {
                    linhaSomaTotal[i] = somaTotalPrevisto.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                }
                if (campos[i].equals("somaTotalReal")) {
                    linhaSomaTotal[i] = somaTotalReal.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                }
                if (campos[i].equalsIgnoreCase("somaPrevisto")) {
                    somaPrevisto = somaPrevisto.add(somaTotalFaturar.add(somaValorTotalRequisicao.add(somaTotalReceber)).subtract(somaTotalPagar));
                    linhaSomaTotal[i] = somaPrevisto.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                }
                if (campos[i].equalsIgnoreCase("somaReal")) {
                    somaReal = somaReal.add(somaTotalFaturado.add(somaTotalPagoRequisicao.add(somaRealRecebido))).subtract(somaRealPago);
                    linhaSomaTotal[i] = somaReal.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                }
                if (campos[i].equalsIgnoreCase("somaTotalCustoSimplesExameHistorico")) {
                    linhaSomaTotal[i] = somaTotalCustoSimplesHistorico.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                }
                if (!campos[i].equalsIgnoreCase("somaTotalCustoSimplesExameAtual")) continue;
                linhaSomaTotal[i] = somaTotalCustoSimplesAtual.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
            }
            modelo.addLine(linhaSomaTotal);
            sql.delete(0, sql.length());
            sql.append("select rel_xml from relatoriosistema where rel_codigo = ");
            sql.append(RelatorioResumoProducaoMensal.getModuloAcesso());
            rs = Conexao.executeQuery(st, sql.toString());
            if (rs.next()) {
                Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                gerador.setPai(this.panelCentro);
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                gerador.setAcaoFechar(new Runnable(){

                    @Override
                    public void run() {
                        RelatorioResumoProducaoMensal.this.panelCentro.removeAll();
                        RelatorioResumoProducaoMensal.this.panelCentro.repaint();
                        RelatorioResumoProducaoMensal.this.habilitaBotaoImprimir(true);
                    }
                });
                HashMap<String, Object> var = new HashMap<String, Object>();
                var.put("filtroAno", this.getFiltroTexto("filtroAno"));
                var.put(FILTRO_MES, this.MESES[this.getFiltroComboIndice(FILTRO_MES)]);
                var.put(FILTRO_FILIAL, this.getDescricaoFilial());
                gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                this.panelCentro.revalidate();
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RelatorioResumoProducaoMensal");
        }
        this.apagarSplash(splashMensagem);
        Conexao.fecharStatement(st);
        System.gc();
        this.setCursor(Cursor.getDefaultCursor());
    }

    private HashMap<Integer, BigDecimal> getTotalFaturado() throws SQLException {
        HashMap<Integer, BigDecimal> totaisFaturados = new HashMap<Integer, BigDecimal>();
        StringBuilder sql = new StringBuilder();
        Statement st = Conexao.getStatement();
        sql.append(" select extract(day from  fat.fat_dtemis) as dia, sum(fat.fat_adicional + fat.fat_despcobranca + fat.fat_totalmateriais + fat.fat_totalexames ");
        sql.append("        + ((fat.fat_totalexames * fat.fat_percacrescimo) / 100)  - ( (fat.fat_totalexames * fat.fat_percdesconto) /100 )) as totalFaturado ");
        sql.append("   from fatura fat where fat.fil_codigo ").append(this.getCodFilial());
        sql.append("        and fat.fat_datacancelamento is null and extract(YEAR from  fat.fat_dtemis) = '").append(this.getFiltroTexto("filtroAno")).append("'");
        sql.append("        and extract(month from  fat.fat_dtemis) = '").append(this.getFiltroComboIndice(FILTRO_MES) + 1).append("'");
        sql.append(" group by fat.fat_dtemis ");
        ResultSet rs = Conexao.executeQuery(st, sql);
        while (rs.next()) {
            totaisFaturados.put(rs.getInt("dia"), rs.getBigDecimal("totalFaturado"));
        }
        return totaisFaturados;
    }

    private HashMap<Integer, BigDecimal> getTotalFaturar() throws SQLException {
        HashMap<Integer, BigDecimal> totaisFaturar = new HashMap<Integer, BigDecimal>();
        StringBuilder sql = new StringBuilder();
        Statement st = Conexao.getStatement();
        sql.append(" select extract(day from req.req_dtfatura) as dia, Sum(CASE  WHEN exa.fil_codigo IS NOT NULL THEN Calculaprecototalexamerequisicao(a.fil_codigo, req.con_codigo, req.req_codigo, ");
        sql.append("      COALESCE(exg.exa_codfilho, exa.exa_codigo), COALESCE(exg.mco_codfilho, a.mco_codigo), false, true, true, a.exr_vlrchexame, ");
        sql.append("   \t\t a.exr_vlrch, a.exr_valorporte,a.exr_valorcusto,  a.exr_valoruco , a.exr_vlrbalcaoconvenio, ");
        sql.append("   \t\t false,  a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, con.con_precosdiferenciados ");
        sql.append("   \t\t ,con.con_reajuste, con.con_cobrmaterial,con.con_percpgtomaterial, con.con_percpgto , con.con_tpcalcfatu,con.con_tpcalcch, ");
        sql.append("   \t\t con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo,con.con_acrescimoporte,con.con_acrescimouco, con.con_descontoporte, ");
        sql.append("   \t\t con.con_descontouco, con.con_valorch,").append(ParametrosGerais.getCasasPrecoExame()).append(",");
        sql.append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", false,");
        sql.append(" \t\t  COALESCE(a.met_codigo, elm.met_codigo,  emc.met_codigo)) ELSE Calculaprecototalexamerequisicao(a.fil_codigo, req.con_codigo,  req.req_codigo, ");
        sql.append(" \t\t\tCOALESCE(exg.exa_codfilho, w.exa_codigo), COALESCE(exg.mco_codfilho, a.mco_codigo), false, true, ");
        sql.append("   \t\t true,a.exr_vlrchexame , a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, false, a.exr_vlrmaterial, ");
        sql.append("   \t\t a.exr_vlrbalcaoconvenio,con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial,con.con_percpgto, con.con_tpcalcfatu, ");
        sql.append("   \t\t con.con_tpcalcch,con.con_perguntarpercbalcao, con.con_acrescimo ,con.con_bonus,con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, ");
        sql.append("   \t\t con.con_descontoporte, con.con_descontouco,con.con_valorch,").append(ParametrosGerais.getCasasPrecoExame()).append(",").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", false, ");
        sql.append(" \t\t\tCOALESCE(a.met_codigo, elm.met_codigo,emc.met_codigo))  END) AS totalFaturar ");
        this.geraSqlFaturarFaturado(sql);
        ResultSet rs = Conexao.executeQuery(st, sql);
        while (rs.next()) {
            totaisFaturar.put(rs.getInt("dia"), rs.getBigDecimal("totalFaturar"));
        }
        return totaisFaturar;
    }

    private void geraSqlFaturarFaturado(StringBuilder sql) {
        sql.append("  FROM examerequisicao AS a ");
        sql.append("       JOIN requisicao req ON a.req_codigo = req.req_codigo AND a.fil_codigo = req.fil_codigo ");
        sql.append("  LEFT JOIN convenios con ON req.con_codigo = con.con_codigo AND req.fil_codigo = con.fil_codigo ");
        sql.append("  LEFT JOIN examerequisicaoguiaagrupada exg ON a.fil_codigo = exg.fil_codigo AND a.req_codigo = exg.req_codigo AND a.exa_codigo = exg.exa_codigo AND a.mco_codigo = exg.mco_codigo ");
        sql.append("  LEFT JOIN exames exa ON exg.fil_codigo = exa.fil_codigo AND exg.exa_codfilho = exa.exa_codigo ");
        sql.append("  LEFT JOIN materialcoleta mco ON exg.fil_codigo = mco.fil_codigo  AND exg.mco_codfilho = mco.mco_codigo ");
        sql.append("  LEFT JOIN examematcoleta emc ON exg.fil_codigo = emc.fil_codigo AND exg.exa_codfilho = emc.exa_codigo AND exg.mco_codfilho = emc.mco_codigo ");
        sql.append("  LEFT JOIN examelayoutmetodo elm ON exg.fil_codigo = elm.fil_codigo AND exg.exa_codfilho = elm.exa_codigo AND exg.mco_codfilho = elm.mco_codigo AND con.lay_codigo = elm.lay_codigo AND a.met_codigo = elm.met_codigo ");
        sql.append("  LEFT JOIN detalhetabelapreco dtp ON exg.fil_codigo = dtp.fil_codigo AND exg.exa_codfilho = dtp.exa_codigo  AND exg.mco_codfilho = dtp.mco_codigo  AND con.tpe_codigo = dtp.tpe_codigo ");
        sql.append("  LEFT JOIN tabelaprecoexamesporte tpp ON dtp.fil_codigo = tpp.fil_codigo  AND dtp.tpe_codigo = tpp.tpe_codigo AND dtp.tpp_porte = tpp.tpp_porte ");
        sql.append("  LEFT JOIN tabelaprecoexames tpe ON con.fil_codigo = tpe.fil_codigo  AND con.tpe_codigo = tpe.tpe_codigo ");
        sql.append("  LEFT JOIN examematcoleta u  ON a.fil_codigo = u.fil_codigo AND a.exa_codigo = u.exa_codigo AND a.mco_codigo = u.mco_codigo ");
        sql.append("  LEFT JOIN materialcoleta v ON u.fil_codigo = v.fil_codigo AND u.mco_codigo = v.mco_codigo ");
        sql.append("  LEFT JOIN exames w  ON a.fil_codigo = w.fil_codigo AND a.exa_codigo = w.exa_codigo ");
        sql.append("  LEFT JOIN detalhetabelapreco dtp2 ON con.fil_codigo = dtp2.fil_codigo  AND con.tpe_codigo = dtp2.tpe_codigo AND a.exa_codigo = dtp2.exa_codigo AND a.mco_codigo = dtp2.mco_codigo ");
        sql.append(" WHERE extract(YEAR from  req.req_dtfatura) = '").append(this.getFiltroTexto("filtroAno")).append("'");
        sql.append("   AND extract(month from  req.req_dtfatura) = '").append(this.getFiltroComboIndice(FILTRO_MES) + 1).append("'");
        sql.append("   AND a.exr_excluido = false ");
        sql.append("   AND req.req_excluida = false ");
        sql.append("   AND a.fil_codigo ").append(this.getCodFilial());
        sql.append("   AND a.exr_datafatura is null ");
        sql.append(" GROUP BY req.req_dtfatura ");
    }

    private int obterPosicao(Object[] o) {
        for (int i = 0; i <= o.length; ++i) {
            if (!o[i].equals("mesCod")) continue;
            return i;
        }
        return 0;
    }

    private void apagarSplash(SplashMensagem splashMensagem) {
        if (splashMensagem != null) {
            splashMensagem.apagar();
        }
    }

    private String getDescricaoFilial() throws SQLException {
        StringBuilder sql = new StringBuilder();
        Statement st = Conexao.getStatement();
        sql.append(" select array_to_string(array_agg(DISTINCT fil_descricao), ', ') as filtroFilial from filiais_postocoleta where fil_codigo ");
        sql.append(this.getCodFilial());
        ResultSet rs = Conexao.executeQuery(st, sql);
        if (rs.next()) {
            return rs.getString(FILTRO_FILIAL);
        }
        return "";
    }

    public HashMap<Integer, BigDecimal> getValorRealRecebidoPago(String tipoReceberpagarReceber) throws SQLException {
        HashMap<Integer, BigDecimal> totalRealRecebidoPago = new HashMap<Integer, BigDecimal>();
        StringBuilder sql = new StringBuilder();
        Statement st = Conexao.getStatement();
        sql.append(" select extract( day from rpg.rpg_vencimento) as dia, case when sum(rpg.rpg_valortotal) > 0.0 then sum(rpg.rpg_valortotal) else 0.0 end as valor  ");
        sql.append(" \t from receberpagar rpg  ");
        sql.append("   join baixareceberpagar brp on rpg.fil_codigo = brp.fil_codigo and rpg.rpg_codigo = brp.rpg_codigo ");
        sql.append("   join baixa bxa on brp.fil_codigo = bxa.fil_codigo and brp.bxa_codigo = bxa.bxa_codigo ");
        sql.append("  where DATE_PART('YEAR', rpg.rpg_vencimento) = '").append(this.getFiltroTexto("filtroAno")).append("'");
        sql.append(" \t  and extract( month from rpg.rpg_vencimento) ='").append(this.getFiltroComboIndice(FILTRO_MES) + 1).append("'");
        sql.append(" \t  and rpg.rpg_datacancelado is null ");
        sql.append(" \t  and rpg.rpg_tipo = '").append(tipoReceberpagarReceber).append("'");
        sql.append(" \t  and rpg.fil_codigo ").append(this.getCodFilial());
        sql.append("    and bxa.bxa_situacao ='").append("Q").append("'");
        sql.append("    and rpg.rpg_situacao = '").append("Q").append("'");
        sql.append("    and rpg.rpg_valortotal is not null ");
        sql.append("    and rpg.rpg_valortotal > 0.0 ");
        sql.append(" group by  rpg.rpg_vencimento");
        ResultSet rs = Conexao.executeQuery(st, sql);
        while (rs.next()) {
            totalRealRecebidoPago.put(rs.getInt("dia"), rs.getBigDecimal("valor"));
        }
        return totalRealRecebidoPago;
    }

    public HashMap<Integer, BigDecimal> getValorReceberPagar(String pagarReceberTipo) throws SQLException {
        HashMap<Integer, BigDecimal> valoresReceberPagar = new HashMap<Integer, BigDecimal>();
        StringBuilder sql = new StringBuilder();
        Statement st = Conexao.getStatement();
        sql.append(" select extract( day from rgp.rpg_vencimento) as dia, case when sum(rgp.rpg_valortotal) > 0.0 then sum(rgp.rpg_valortotal) else 0.0 end as valor from receberpagar as rgp ");
        sql.append(" \twhere DATE_PART('YEAR', rgp.rpg_vencimento) = '").append(this.getFiltroTexto("filtroAno")).append("'");
        sql.append(" \t  and extract( month from rgp.rpg_vencimento) ='").append(this.getFiltroComboIndice(FILTRO_MES) + 1).append("'");
        sql.append(" \t  and rgp.rpg_datacancelado is null and rgp.rpg_valortotal is not null ");
        sql.append("    and rgp.rpg_valortotal > 0.0 and rgp.rpg_tipo = '").append(pagarReceberTipo).append("'");
        sql.append(" \t  and rgp.fil_codigo ").append(this.getCodFilial());
        sql.append("    and rgp.rpg_situacao in('");
        sql.append("A").append("','").append("Q").append("')");
        sql.append(" GROUP BY rgp.rpg_vencimento ");
        ResultSet rs = Conexao.executeQuery(st, sql);
        while (rs.next()) {
            valoresReceberPagar.put(rs.getInt("dia"), rs.getBigDecimal("valor"));
        }
        return valoresReceberPagar;
    }

    public HashMap<Integer, BigDecimal> getTotalRequisicao() throws SQLException {
        HashMap<Integer, BigDecimal> valoresTotaisRequisicao = new HashMap<Integer, BigDecimal>();
        StringBuilder sql = new StringBuilder();
        Statement st = Conexao.getStatement();
        sql.append(" select extract( day from a.req_data) as dia, count(*) as totalRequisicao ");
        sql.append("    from requisicao a ");
        sql.append("   where fil_codigo ").append(this.getCodFilial());
        sql.append("     and extract(year from a.req_data)= '").append(this.getFiltroTexto("filtroAno")).append("'");
        sql.append("     and extract(month from a.req_data) = '").append(this.getFiltroComboIndice(FILTRO_MES) + 1).append("'");
        sql.append("     and a.req_excluida = false ");
        sql.append("  group by extract(day from a.req_data) ");
        ResultSet rs = Conexao.executeQuery(st, sql);
        while (rs.next()) {
            valoresTotaisRequisicao.put(rs.getInt("dia"), rs.getBigDecimal("totalRequisicao"));
        }
        rs.close();
        Conexao.fecharStatement(st);
        return valoresTotaisRequisicao;
    }

    public HashMap<Integer, BigDecimal> getTotalExame() throws SQLException {
        HashMap<Integer, BigDecimal> valoresTotaisExames = new HashMap<Integer, BigDecimal>();
        StringBuilder sql = new StringBuilder();
        Statement st = Conexao.getStatement();
        sql.append("   select extract(day from exr_data) as dia, count(*) as totalExame ");
        sql.append("    from examerequisicao ");
        sql.append("   where fil_codigo ").append(this.getCodFilial());
        sql.append("     and extract(year from exr_data)= '").append(this.getFiltroTexto("filtroAno")).append("'");
        sql.append("     and extract(month from exr_data) = '").append(this.getFiltroComboIndice(FILTRO_MES) + 1).append("'");
        sql.append("     and exr_excluido = false ");
        sql.append("  group by extract(day from exr_data) ");
        ResultSet rs = Conexao.executeQuery(st, sql);
        while (rs.next()) {
            valoresTotaisExames.put(rs.getInt("dia"), rs.getBigDecimal("totalExame"));
        }
        rs.close();
        Conexao.fecharStatement(st);
        return valoresTotaisExames;
    }

    public HashMap<Integer, ValorCustoExameProducaoMensal> geValorTotalCustoSimplesExame() throws SQLException {
        HashMap<Integer, ValorCustoExameProducaoMensal> totalCusto = new HashMap<Integer, ValorCustoExameProducaoMensal>();
        StringBuilder sql = new StringBuilder();
        Statement st = Conexao.getStatement();
        sql.append("   select extract(day from a.exr_data) as dia, SUM(a.exr_custosimples) as somaTotalCustoSimplesExameHistorico ");
        sql.append("        ,SUM(h.emc_custosimples) as somaTotalCustoSimplesExameAtual ");
        sql.append("    from examerequisicao a ");
        sql.append("    join examematcoleta h on a.fil_codigo = h.fil_codigo and a.exa_codigo = h.exa_codigo and a.mco_codigo = h.mco_codigo ");
        sql.append("   where a.fil_codigo ").append(this.getCodFilial());
        sql.append("     and extract(year from a.exr_data)= '").append(this.getFiltroTexto("filtroAno")).append("'");
        sql.append("     and extract(month from a.exr_data) = '").append(this.getFiltroComboIndice(FILTRO_MES) + 1).append("'");
        sql.append("     and a.exr_excluido = false ");
        sql.append("  group by a.exr_data ");
        ResultSet rs = Conexao.executeQuery(st, sql);
        while (rs.next()) {
            ValorCustoExameProducaoMensal custo = new ValorCustoExameProducaoMensal(rs.getInt("somaTotalCustoSimplesExameHistorico"), rs.getInt("somaTotalCustoSimplesExameAtual"));
            totalCusto.put(rs.getInt("dia"), custo);
        }
        rs.close();
        Conexao.fecharStatement(st);
        return totalCusto;
    }

    public Integer getDias(int dia) throws SQLException {
        StringBuilder sql = new StringBuilder();
        Statement st = Conexao.getStatement();
        sql.append(" select Count(DISTINCT( Cast(req_data AS DATE) ))  AS  dias   ");
        sql.append("   from requisicao                                                     ");
        sql.append("  where fil_codigo ").append(this.getCodFilial());
        sql.append("    and extract(year from req_data)= '").append(this.getFiltroTexto("filtroAno")).append("'");
        sql.append("    and extract(month from req_data) = '").append(this.getFiltroComboIndice(FILTRO_MES) + 1).append("'");
        sql.append("    and extract(day from req_data) = '").append(dia).append("'");
        sql.append("    and req_excluida = false                                           ");
        ResultSet rs = Conexao.executeQuery(st, sql);
        if (rs.next()) {
            return rs.getInt("dias");
        }
        return 0;
    }

    public HashMap<Integer, BigDecimal> getValorTotalRequisicao() throws SQLException {
        HashMap<Integer, BigDecimal> totalRequisicao = new HashMap<Integer, BigDecimal>();
        StringBuilder sql = new StringBuilder();
        Statement st = Conexao.getStatement();
        sql.append("    select Extract(day FROM a.req_data) as dia, case when Sum(a.req_total) is null then 0.0 else Sum(a.req_total) end  AS valorTotalRequisicao    ");
        sql.append("    from requisicao a                                 ");
        sql.append("    WHERE Extract(YEAR from  a.req_data) ='").append(this.getFiltroTexto("filtroAno")).append("'");
        sql.append("      AND Extract(month FROM a.req_data) = '").append(this.getFiltroComboIndice(FILTRO_MES) + 1).append("'");
        sql.append("      AND a.req_excluida = false                      ");
        sql.append("      AND a.fil_codigo ").append(this.getCodFilial());
        sql.append("      AND a.req_total is not null ");
        sql.append("      AND a.req_total > 0 ");
        sql.append("  group by a.req_data ");
        ResultSet rs = Conexao.executeQuery(st, sql);
        while (rs.next()) {
            totalRequisicao.put(rs.getInt("dia"), rs.getBigDecimal("valorTotalRequisicao"));
        }
        rs.close();
        Conexao.fecharStatement(st);
        return totalRequisicao;
    }

    public HashMap<Integer, BigDecimal> getValorTotalPagoRequisicao() throws SQLException {
        HashMap<Integer, BigDecimal> totalPagoRequisicao = new HashMap<Integer, BigDecimal>();
        StringBuilder sql = new StringBuilder();
        Statement st = Conexao.getStatement();
        sql.append("  select Extract(day FROM a.req_data) as dia , case when Sum(a.req_totpago) > 0.0 then Sum(a.req_totpago) else 0.0 end AS totalPagoRequisicao    ");
        sql.append("     from requisicao a ");
        sql.append("     WHERE Extract(YEAR from  a.req_data) = '").append(this.getFiltroTexto("filtroAno")).append("'");
        sql.append("      AND Extract(month FROM a.req_data) = '").append(this.getFiltroComboIndice(FILTRO_MES) + 1).append("'");
        sql.append("      AND a.req_excluida = false ");
        sql.append("      and a.req_totpago is not null ");
        sql.append("      and a.req_totpago > 0.0 ");
        sql.append("      AND a.fil_codigo ").append(this.getCodFilial());
        sql.append("  group by a.req_data ");
        ResultSet rs = Conexao.executeQuery(st, sql);
        while (rs.next()) {
            totalPagoRequisicao.put(rs.getInt("dia"), rs.getBigDecimal("totalPagoRequisicao"));
        }
        rs.close();
        Conexao.fecharStatement(st);
        return totalPagoRequisicao;
    }

    public HashMap<Integer, BigDecimal> getValorTotalDesconto() throws SQLException {
        HashMap<Integer, BigDecimal> totalDesconto = new HashMap<Integer, BigDecimal>();
        StringBuilder sql = new StringBuilder();
        Statement st = Conexao.getStatement();
        sql.append(" select Extract(day FROM a.req_data) as dia, case when Sum(a.req_vlrdesconto) > 0.0 then Sum(a.req_vlrdesconto) else 0.0 end AS valorTotalDesconto ");
        sql.append("     from requisicao a                                  ");
        sql.append("    WHERE Extract(YEAR from  a.req_data) = '").append(this.getFiltroTexto("filtroAno")).append("'");
        sql.append("      AND Extract(month FROM a.req_data) = '").append(this.getFiltroComboIndice(FILTRO_MES) + 1).append("'");
        sql.append("      AND a.req_excluida = false                       ");
        sql.append("      and a.req_vlrdesconto is not null ");
        sql.append("      and a.req_vlrdesconto > 0.0 ");
        sql.append("      AND a.fil_codigo ").append(this.getCodFilial());
        sql.append("  group by a.req_data ");
        ResultSet rs = Conexao.executeQuery(st, sql);
        while (rs.next()) {
            totalDesconto.put(rs.getInt("dia"), rs.getBigDecimal("valorTotalDesconto"));
        }
        rs.close();
        Conexao.fecharStatement(st);
        return totalDesconto;
    }

    public HashMap<Integer, BigDecimal> getValorTotalAcrescimo() throws SQLException {
        HashMap<Integer, BigDecimal> totalAcrescimo = new HashMap<Integer, BigDecimal>();
        StringBuilder sql = new StringBuilder();
        Statement st = Conexao.getStatement();
        sql.append(" select Extract(day FROM a.req_data) as dia, case when Sum(a.req_vlracrescimo) > 0.0 then Sum(a.req_vlracrescimo) else 0.0 end AS valorTotalAcrescimo ");
        sql.append("     from requisicao a                                  ");
        sql.append("    WHERE Extract(YEAR from  a.req_data) = '").append(this.getFiltroTexto("filtroAno")).append("'");
        sql.append("      AND Extract(month FROM a.req_data) = '").append(this.getFiltroComboIndice(FILTRO_MES) + 1).append("'");
        sql.append("      AND a.req_excluida = false                       ");
        sql.append("      and a.req_vlracrescimo is not null ");
        sql.append("      and a.req_vlracrescimo > 0.0 ");
        sql.append("      AND a.fil_codigo ").append(this.getCodFilial());
        sql.append("  group by a.req_data ");
        ResultSet rs = Conexao.executeQuery(st, sql);
        while (rs.next()) {
            totalAcrescimo.put(rs.getInt("dia"), rs.getBigDecimal("valorTotalAcrescimo"));
        }
        rs.close();
        Conexao.fecharStatement(st);
        return totalAcrescimo;
    }

    public HashMap<Integer, BigDecimal> getValorAcumuladoMensalFaturar() throws SQLException {
        HashMap<Integer, BigDecimal> totalAcumulado = new HashMap<Integer, BigDecimal>();
        StringBuilder sql = new StringBuilder();
        Statement st = Conexao.getStatement();
        sql.append("    select Extract(day from b.req_data) as dia, case when sum(round((calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo, true, false, false, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, d.con_precosdiferenciados, d.con_reajuste, d.con_cobrmaterial, d.con_percpgtomaterial, d.con_percpgto, d.con_tpcalcfatu, d.con_tpcalcch, d.con_perguntarpercbalcao, d.con_acrescimo, d.con_bonus, d.tpe_codigo, d.con_acrescimoporte, d.con_acrescimouco, d.con_descontoporte, d.con_descontouco, d.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", a.met_codigo) + a.exr_vlrmaterial) - a.exr_vlrmaterial, ").append(ParametrosGerais.getCasasPrecoExame()).append(")) > 0.0");
        sql.append("    then sum(round((calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo, true, false, false, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, d.con_precosdiferenciados, d.con_reajuste, d.con_cobrmaterial, d.con_percpgtomaterial, d.con_percpgto, d.con_tpcalcfatu, d.con_tpcalcch, d.con_perguntarpercbalcao, d.con_acrescimo, d.con_bonus, d.tpe_codigo, d.con_acrescimoporte, d.con_acrescimouco, d.con_descontoporte, d.con_descontouco, d.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", a.met_codigo) + a.exr_vlrmaterial) - a.exr_vlrmaterial, ").append(ParametrosGerais.getCasasPrecoExame()).append(")) else 0.0 end as valorAcumuladoMensalFaturar ");
        sql.append("    from examerequisicao a ");
        sql.append("    join requisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo");
        sql.append("    left join exames c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo");
        sql.append("    left join convenios d on a.fil_codigo = d.fil_codigo and b.con_codigo = d.con_codigo");
        sql.append("    left join examematcoleta e on a.mco_codigo = e.mco_codigo and a.fil_codigo = e.fil_codigo and c.exa_codigo = e.exa_codigo");
        sql.append("    left join examesetor es on a.fil_codigo = es.fil_codigo and a.exa_codigo = es.exa_codigo and es.ese_default = true");
        sql.append("    left join examematgrupo g on a.fil_codigo = g.fil_codigo and a.exa_codigo = g.exa_codigo and a.mco_codigo = g.mco_codigo");
        sql.append("    left join setores f on es.fil_codigo = f.fil_codigo and es.set_codigo = f.set_codigo");
        sql.append("    left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo");
        sql.append("    left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo");
        sql.append("    left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo");
        sql.append("    WHERE Extract(year from  b.req_data) = '").append(this.getFiltroTexto("filtroAno")).append("'");
        sql.append("      AND Extract(month from b.req_data) = '").append(this.getFiltroComboIndice(FILTRO_MES) + 1).append("'");
        sql.append("      AND b.req_excluida = false                       ");
        sql.append("      AND a.exr_excluido = false");
        sql.append("      AND d.con_cobrexame = false");
        sql.append("      AND b.fil_codigo ").append(this.getCodFilial());
        sql.append("  group by b.req_data ");
        ResultSet rs = Conexao.executeQuery(st, sql);
        while (rs.next()) {
            totalAcumulado.put(rs.getInt("dia"), rs.getBigDecimal("valorAcumuladoMensalFaturar"));
        }
        rs.close();
        Conexao.fecharStatement(st);
        return totalAcumulado;
    }

    private Map<Integer, BigDecimal> getValorDiarioContasCorrenteConciliado() throws SQLException {
        String nomeRelatorio = "valorDiarioContasCorrenteConciliado";
        StringBuilder sql = new StringBuilder();
        StringBuilder sqlDebito = new StringBuilder();
        StringBuilder sqlCredito = new StringBuilder();
        sql.append((CharSequence)this.getSqlContas(nomeRelatorio));
        sql.append(" AND ccr.cco_tipo in('C')");
        sql.append(" AND lancto.lcx_situacao in('O')");
        sql.append(" AND lancto.lcx_conciliacao is not NULL");
        sqlCredito.append((CharSequence)sql);
        sqlDebito.append((CharSequence)sql);
        sqlDebito.append(" AND lancto.lcx_tipo in ('").append("D").append("') ");
        sqlCredito.append(" AND lancto.lcx_tipo in ('").append("C").append("') ");
        sqlCredito.append(" group by dia");
        sqlDebito.append(" group by dia");
        return this.subtraiValores(sqlCredito, sqlDebito, nomeRelatorio);
    }

    private Map<Integer, BigDecimal> getValorDiarioContasCaixaConciliado() throws SQLException {
        String nomeRelatorio = "valorDiarioContasCaixaConciliado";
        StringBuilder sql = new StringBuilder();
        StringBuilder sqlDebito = new StringBuilder();
        StringBuilder sqlCredito = new StringBuilder();
        sql.append((CharSequence)this.getSqlContas(nomeRelatorio));
        sql.append(" AND ccr.cco_tipo in('X')");
        sql.append(" AND lancto.lcx_situacao in('O')");
        sql.append(" AND lancto.lcx_conciliacao is not NULL");
        sqlCredito.append((CharSequence)sql);
        sqlDebito.append((CharSequence)sql);
        sqlDebito.append(" AND lancto.lcx_tipo in ('").append("D").append("') ");
        sqlCredito.append(" AND lancto.lcx_tipo in ('").append("C").append("') ");
        sqlCredito.append(" group by dia");
        sqlDebito.append(" group by dia");
        return this.subtraiValores(sqlCredito, sqlDebito, nomeRelatorio);
    }

    private Map<Integer, BigDecimal> getValorDiarioContasCorrente() throws SQLException {
        String nomeRelatorio = "valorDiarioContasCorrente";
        StringBuilder sql = new StringBuilder();
        StringBuilder sqlDebito = new StringBuilder();
        StringBuilder sqlCredito = new StringBuilder();
        sql.append((CharSequence)this.getSqlContas(nomeRelatorio));
        sql.append(" AND ccr.cco_tipo in('C')");
        sqlCredito.append((CharSequence)sql);
        sqlDebito.append((CharSequence)sql);
        sqlDebito.append(" AND lancto.lcx_tipo in ('").append("D").append("') ");
        sqlCredito.append(" AND lancto.lcx_tipo in ('").append("C").append("') ");
        sqlCredito.append(" group by dia");
        sqlDebito.append(" group by dia");
        return this.subtraiValores(sqlCredito, sqlDebito, nomeRelatorio);
    }

    private Map<Integer, BigDecimal> getValorDiarioContasCaixa() throws SQLException {
        String nomeRelatorio = "valorDiarioContasCaixa";
        StringBuilder sql = new StringBuilder();
        StringBuilder sqlDebito = new StringBuilder();
        StringBuilder sqlCredito = new StringBuilder();
        sql.append((CharSequence)this.getSqlContas(nomeRelatorio));
        sql.append(" AND ccr.cco_tipo in('X')");
        sqlCredito.append((CharSequence)sql);
        sqlDebito.append((CharSequence)sql);
        sqlDebito.append(" AND lancto.lcx_tipo in ('").append("D").append("') ");
        sqlCredito.append(" AND lancto.lcx_tipo in ('").append("C").append("') ");
        sqlCredito.append(" group by dia");
        sqlDebito.append(" group by dia");
        return this.subtraiValores(sqlCredito, sqlDebito, nomeRelatorio);
    }

    private StringBuilder getSqlContas(String nomeRelatorio) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select extract( day from lancto.lcx_datahora) as dia,");
        sql.append(" case");
        sql.append(" when sum(lcx_valor) >= 0.0  then  sum(lcx_valor)");
        sql.append(" else 0.0");
        sql.append(" end as ").append(nomeRelatorio);
        sql.append(" from lanctocaixa  as lancto");
        sql.append(" left join contacorrente as ccr on");
        sql.append(" lancto.fil_codigo = ccr.fil_codigo and");
        sql.append(" lancto.cco_reduzido  =  ccr.cco_reduzido  ");
        sql.append(" WHERE Extract(year from  lancto.lcx_datahora) =").append(this.getFiltroTexto("filtroAno"));
        sql.append(" AND Extract(month from lancto.lcx_datahora) = ").append(this.getFiltroComboIndice(FILTRO_MES) + 1);
        sql.append(" AND lancto.fil_codigo ").append(this.getCodFilial());
        return sql;
    }

    private Map<Integer, BigDecimal> subtraiValores(StringBuilder sqlCredito, StringBuilder sqlDebito, String nomeRelatorio) throws SQLException {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        ResultSet rsDebito = Conexao.executeQuery(st, sqlDebito);
        ResultSet rsCredito = Conexao.executeQuery(st2, sqlCredito);
        HashMap<Integer, BigDecimal> totalAcumulado = new HashMap<Integer, BigDecimal>();
        while (rsCredito.next()) {
            totalAcumulado.put(rsCredito.getInt("dia"), rsCredito.getBigDecimal(nomeRelatorio));
        }
        while (rsDebito.next()) {
            for (Map.Entry entry : totalAcumulado.entrySet()) {
                if (rsDebito.getInt("dia") != ((Integer)entry.getKey()).intValue()) continue;
                entry.setValue(((BigDecimal)entry.getValue()).subtract(rsDebito.getBigDecimal(nomeRelatorio)));
            }
        }
        rsCredito.close();
        rsDebito.close();
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        return totalAcumulado;
    }

    private String getCodFilial() {
        StringBuilder retornoCod = new StringBuilder();
        String[] filiais = this.getSelecionadosFiltro(FILTRO_FILIAL, 0);
        if (filiais == null) {
            filiais = new String[]{Variaveis.filialPadrao};
        }
        retornoCod.append(" in(");
        for (int i = 0; i < filiais.length; ++i) {
            retornoCod.append(filiais[i]);
            if (i >= filiais.length - 1) continue;
            retornoCod.append(", ");
        }
        retornoCod.append(")");
        return retornoCod.toString();
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0880401400");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0880401401");
    }

    private Object validarValor(Object valor) {
        if (valor != null && !valor.toString().trim().isEmpty()) {
            return valor;
        }
        return 0;
    }
}

