/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.gerencial;

import jalis.comum.Conexao;
import jalis.comum.ConstantesGerais;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.SplashMensagem;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.table.TableModel;

public class RelatorioResumoProducaoAnual
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private static final double VALOR_PADRAO = 0.0;
    private static final int TOTAL_MESES = 12;
    private final String FILTRO_ANO = "filtroData";
    private String[] ordem = new String[]{"Ano"};
    private final String FILTRO_FILIAL = "filtroFilial";
    protected static String[] campos;

    public RelatorioResumoProducaoAnual() {
        String[] campoSoma = new String[]{"somaTotalReceber", "somaTotalPagar", "somaTotalExame", "somaDiaTrabalhado", "somaValorTotalRequisicao", "somaTotalPagoRequisicao", "somaValorTotalDesconto", "somaValorTotalAcrescimo", "somaValorAcumuladoMensalFaturar", "somaTotalFaturado", "somaTotalFaturar", "somaRealRecebido", "somaRealPago", "somaTotalRequisicao", "somaExameRequisicao", "somaTotalPrevisto", "somaTotalReal", "somaPrevisto", "somaReal", "somaTotalCustoSimplesExameHistorico", "somaTotalCustoSimplesExameAtual", "valorMensalContasCorrenteConciliado", "valorMensalContasCaixaConciliado", "valorMensalContasCorrente", "valorMensalContasCaixa"};
        campos = ArraysUtil.concatenar(new String[]{"mes", "totalExame", "totalRequisicao", "diaTrabalhado", "totalFaturar", "totalFaturado", "valorTotalRequisicao", "totalPagoRequisicao", "valorTotalDesconto", "valorTotalAcrescimo", "valorAcumuladoMensalFaturar", "totalReceber", "totalPagar", "realRecebido", "realPago", "mesCod", "filtroFilial", "totalCustoSimplesExameHistorico", "totalCustoSimplesExameAtual", "exameRequisicao"}, campoSoma);
        this.montaBarraDescricao("Resumo de produ\u00e7\u00e3o anual", "Resumo de produ\u00e7\u00e3o anual", "relatorios/rel_ger_analitico_producao_anual.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroNumero("filtroData", "Ano:", 4);
        this.setModuloConfigurar(this.getModuloConfigurar());
        this.setModuloAcesso(this.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    @Override
    public void imprimirPressionado() {
        Integer ano;
        BigDecimal somaTotalReceber = BigDecimal.ZERO;
        BigDecimal somaTotalPagar = BigDecimal.ZERO;
        BigDecimal somaValorTotalRequisicao = BigDecimal.ZERO;
        BigDecimal somaTotalPagoRequisicao = BigDecimal.ZERO;
        BigDecimal somaValorTotalDesconto = BigDecimal.ZERO;
        BigDecimal somaValorTotalAcrescimo = BigDecimal.ZERO;
        BigDecimal somaValorAcumuladoMensalFaturar = BigDecimal.ZERO;
        BigDecimal somaTotalFaturado = BigDecimal.ZERO;
        BigDecimal somaTotalFaturar = BigDecimal.ZERO;
        BigDecimal somaRealRecebido = BigDecimal.ZERO;
        BigDecimal somaRealPago = BigDecimal.ZERO;
        BigDecimal somaExameRequisicao = BigDecimal.ZERO;
        BigDecimal somaTotalPrevisto = BigDecimal.ZERO;
        BigDecimal somaTotalReal = BigDecimal.ZERO;
        BigDecimal somaPrevisto = BigDecimal.ZERO;
        BigDecimal somaReal = BigDecimal.ZERO;
        BigDecimal somaTotalCustoSimplesAtual = BigDecimal.ZERO;
        BigDecimal somaTotalCustoSimplesHistorico = BigDecimal.ZERO;
        String filial = "";
        Integer somaTotalRequisicao = 0;
        Integer somaTotalExame = 0;
        if (this.getFiltroTexto("filtroData") == null || this.getFiltroTexto("filtroData").trim().isEmpty()) {
            this.requisitaFocoComponente("filtroData");
            Funcoes.mensagem(this, "O ano deve ser informado.", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        if (this.getFiltroTexto("filtroData") != null && !this.getFiltroTexto("filtroData").trim().isEmpty() && (ano = Integer.valueOf(Integer.parseInt(this.getFiltroTexto("filtroData")))) < 1900) {
            Funcoes.mensagem(this, "O valor do ano n\u00e3o deve ser menor que 1900.", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        try {
            filial = this.getDescricaoFilial();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "RelatorioResumoProducaoAnual");
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        Statement st = Conexao.getStatement();
        SplashMensagem splashMensagem = SplashMensagem.getInstancia(this);
        try {
            int i;
            Object[] o;
            StringBuilder sql = new StringBuilder();
            ModeloGridTable modelo = new ModeloGridTable(campos);
            ResultSet rs = null;
            HashSet<Integer> mesEncontrado = new HashSet<Integer>();
            splashMensagem.mostrar("");
            for (int mesConsulta = 0; mesConsulta <= 11; ++mesConsulta) {
                splashMensagem.setText("Processando m\u00eas de " + ConstantesGerais.MESES_ANO[mesConsulta] + " de " + this.getFiltroTexto("filtroData"));
                o = new Object[campos.length];
                for (i = 0; i < campos.length; ++i) {
                    Number valor;
                    if (campos[i].equalsIgnoreCase("totalReceber")) {
                        valor = this.getValorReceberPagar(mesConsulta + 1, "R");
                        somaTotalReceber = somaTotalReceber.add((BigDecimal)valor);
                        o[i] = valor;
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("totalPagar")) {
                        valor = this.getValorReceberPagar(mesConsulta + 1, "P");
                        somaTotalPagar = somaTotalPagar.add((BigDecimal)valor);
                        o[i] = valor;
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("mes")) {
                        o[i] = ConstantesGerais.MESES_ANO[mesConsulta];
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("totalRequisicao")) {
                        valor = this.getTotalRequisicao(mesConsulta + 1);
                        somaTotalRequisicao = somaTotalRequisicao + (Integer)valor;
                        o[i] = this.validarValor(valor);
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("totalExame")) {
                        valor = this.getTotalExame(mesConsulta + 1);
                        somaTotalExame = somaTotalExame + (Integer)valor;
                        o[i] = this.validarValor(valor);
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("diaTrabalhado")) {
                        valor = this.getDiaTrabalhado(mesConsulta + 1);
                        o[i] = valor;
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("valorTotalRequisicao")) {
                        valor = this.getValorTotalRequisicao(mesConsulta + 1);
                        if (valor == null) {
                            valor = BigDecimal.ZERO;
                        }
                        somaValorTotalRequisicao = somaValorTotalRequisicao.add((BigDecimal)valor).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                        o[i] = valor;
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("totalPagoRequisicao")) {
                        valor = this.getValorTotalPagoRequisicao(mesConsulta + 1);
                        if (valor == null) {
                            valor = BigDecimal.ZERO;
                        }
                        somaTotalPagoRequisicao = somaTotalPagoRequisicao.add((BigDecimal)valor).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                        o[i] = valor;
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("valorTotalDesconto")) {
                        valor = this.getValorTotalDesconto(mesConsulta + 1);
                        if (valor == null) {
                            valor = BigDecimal.ZERO;
                        }
                        somaValorTotalDesconto = somaValorTotalDesconto.add((BigDecimal)valor).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                        o[i] = valor;
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("valorTotalAcrescimo")) {
                        valor = this.getValorTotalAcrescimo(mesConsulta + 1);
                        if (valor == null) {
                            valor = BigDecimal.ZERO;
                        }
                        somaValorTotalAcrescimo = somaValorTotalAcrescimo.add((BigDecimal)valor).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                        o[i] = valor;
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("valorAcumuladoMensalFaturar")) {
                        valor = this.getValorAcumuladoMensalFaturar(mesConsulta + 1);
                        if (valor == null) {
                            valor = BigDecimal.ZERO;
                        }
                        somaValorAcumuladoMensalFaturar = somaValorAcumuladoMensalFaturar.add((BigDecimal)valor).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                        o[i] = valor;
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("totalFaturado")) {
                        valor = this.getTotalFaturado(mesConsulta + 1);
                        if (valor == null) {
                            valor = BigDecimal.ZERO;
                        }
                        valor = (BigDecimal)this.validarValor(valor);
                        somaTotalFaturado = somaTotalFaturado.add((BigDecimal)valor).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                        o[i] = valor;
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("totalFaturar")) {
                        valor = this.getTotalFaturar(mesConsulta + 1);
                        if (valor == null) {
                            valor = BigDecimal.ZERO;
                        }
                        somaTotalFaturar = somaTotalFaturar.add((BigDecimal)valor).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                        o[i] = valor;
                        continue;
                    }
                    if (campos[i].contains("totalCustoSimplesExameHistorico")) {
                        Integer[] custos = this.geValorTotalCustoSimplesExame(mesConsulta + 1);
                        BigDecimal valorHistorico = custos == null ? BigDecimal.ZERO : new BigDecimal(custos[0]);
                        BigDecimal valorAtual = custos == null ? BigDecimal.ZERO : new BigDecimal(custos[1]);
                        somaTotalCustoSimplesHistorico = somaTotalCustoSimplesHistorico.add(valorHistorico).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                        somaTotalCustoSimplesAtual = somaTotalCustoSimplesAtual.add(valorAtual).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                        o[modelo.findColumn((String)"totalCustoSimplesExameAtual")] = valorAtual;
                        o[i] = valorHistorico;
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("realRecebido")) {
                        valor = this.getValorRealRecebidoPago(mesConsulta + 1, "R");
                        if (valor == null) {
                            valor = BigDecimal.ZERO;
                        }
                        somaRealRecebido = somaRealRecebido.add((BigDecimal)valor).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                        o[i] = valor;
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("realPago")) {
                        valor = this.getValorRealRecebidoPago(mesConsulta + 1, "P");
                        if (valor == null) {
                            valor = BigDecimal.ZERO;
                        }
                        somaRealPago = somaRealPago.add((BigDecimal)valor).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                        o[i] = valor;
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("valorMensalContasCorrenteConciliado")) {
                        valor = this.getvalorMensalContasCorrenteConciliado(mesConsulta + 1);
                        if (valor == null) {
                            valor = BigDecimal.ZERO;
                        }
                        somaRealPago = somaRealPago.add((BigDecimal)valor).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                        o[i] = valor;
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("valorMensalContasCaixaConciliado")) {
                        valor = this.getvalorMensalContasCaixaConciliado(mesConsulta + 1);
                        if (valor == null) {
                            valor = BigDecimal.ZERO;
                        }
                        somaRealPago = somaRealPago.add((BigDecimal)valor).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                        o[i] = valor;
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("valorMensalContasCorrente")) {
                        valor = this.getvalorMensalContasCorrente(mesConsulta + 1);
                        if (valor == null) {
                            valor = BigDecimal.ZERO;
                        }
                        somaRealPago = somaRealPago.add((BigDecimal)valor).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                        o[i] = valor;
                        continue;
                    }
                    if (campos[i].equalsIgnoreCase("valorMensalContasCaixa")) {
                        valor = this.getvalorMensalContasCaixa(mesConsulta + 1);
                        if (valor == null) {
                            valor = BigDecimal.ZERO;
                        }
                        somaRealPago = somaRealPago.add((BigDecimal)valor).setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                        o[i] = valor;
                        continue;
                    }
                    o[i] = campos[i].equals("filtroFilial") ? filial : Double.valueOf(0.0);
                }
                o[this.obterPosicao((Object[])RelatorioResumoProducaoAnual.campos)] = mesConsulta;
                mesEncontrado.add(mesConsulta);
                modelo.addLine(o);
            }
            for (int m = 0; m < ConstantesGerais.MESES_ANO.length; ++m) {
                if (mesEncontrado.contains(m)) continue;
                o = new Object[campos.length];
                for (i = 0; i < campos.length; ++i) {
                    o[i] = campos[i].equals("mes") ? ConstantesGerais.MESES_ANO[m] : (!campos[i].equals("filtroFilial") ? Double.valueOf(0.0) : Double.valueOf(0.0));
                }
                o[this.obterPosicao((Object[])RelatorioResumoProducaoAnual.campos)] = m;
                modelo.addLine(o);
            }
            modelo.ordenarColuna(modelo.findColumn("mesCod"));
            Object[] linhaSomaTotal = new Object[campos.length];
            for (int i2 = 0; i2 < campos.length; ++i2) {
                if (campos[i2].equals("somaTotalFaturar")) {
                    linhaSomaTotal[i2] = somaTotalFaturar.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                }
                if (campos[i2].equals("somaTotalFaturado")) {
                    linhaSomaTotal[i2] = somaTotalFaturado.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                }
                if (campos[i2].equals("somaValorTotalRequisicao")) {
                    linhaSomaTotal[i2] = somaValorTotalRequisicao.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                }
                if (campos[i2].equals("somaTotalPagoRequisicao")) {
                    linhaSomaTotal[i2] = somaTotalPagoRequisicao.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                }
                if (campos[i2].equals("somaValorTotalDesconto")) {
                    linhaSomaTotal[i2] = somaValorTotalDesconto.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                }
                if (campos[i2].equals("somaValorTotalAcrescimo")) {
                    linhaSomaTotal[i2] = somaValorTotalAcrescimo.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                }
                if (campos[i2].equals("somaValorAcumuladoMensalFaturar")) {
                    linhaSomaTotal[i2] = somaValorAcumuladoMensalFaturar.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                }
                if (campos[i2].equals("somaTotalReceber")) {
                    linhaSomaTotal[i2] = somaTotalReceber.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                }
                if (campos[i2].equals("somaTotalPagar")) {
                    linhaSomaTotal[i2] = somaTotalPagar.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                }
                if (campos[i2].equals("somaRealRecebido")) {
                    linhaSomaTotal[i2] = somaRealRecebido.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                }
                if (campos[i2].equals("somaRealPago")) {
                    linhaSomaTotal[i2] = somaRealPago.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                }
                if (campos[i2].equals("somaTotalRequisicao")) {
                    linhaSomaTotal[i2] = somaTotalRequisicao;
                }
                if (campos[i2].equals("somaTotalExame")) {
                    linhaSomaTotal[i2] = somaTotalExame;
                }
                if (campos[i2].equals("somaExameRequisicao")) {
                    if (somaTotalExame.doubleValue() > 0.0 && somaTotalRequisicao.doubleValue() > 0.0) {
                        somaExameRequisicao = somaExameRequisicao.add(BigDecimal.valueOf(somaTotalExame.doubleValue() / somaTotalRequisicao.doubleValue()));
                    }
                    linhaSomaTotal[i2] = somaExameRequisicao.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                }
                if (campos[i2].equals("somaTotalPrevisto")) {
                    linhaSomaTotal[i2] = somaTotalPrevisto.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                }
                if (campos[i2].equals("somaTotalReal")) {
                    linhaSomaTotal[i2] = somaTotalReal.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                }
                if (campos[i2].equalsIgnoreCase("somaPrevisto")) {
                    somaPrevisto = somaPrevisto.add(somaTotalFaturar.add(somaValorTotalRequisicao.add(somaTotalReceber)).subtract(somaTotalPagar));
                    linhaSomaTotal[i2] = somaPrevisto.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                }
                if (campos[i2].equalsIgnoreCase("somaReal")) {
                    somaReal = somaReal.add(somaTotalFaturado.add(somaTotalPagoRequisicao.add(somaRealRecebido))).subtract(somaRealPago);
                    linhaSomaTotal[i2] = somaReal.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                }
                if (campos[i2].equalsIgnoreCase("somaTotalCustoSimplesExameHistorico")) {
                    linhaSomaTotal[i2] = somaTotalCustoSimplesHistorico.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                }
                if (!campos[i2].equalsIgnoreCase("somaTotalCustoSimplesExameAtual")) continue;
                linhaSomaTotal[i2] = somaTotalCustoSimplesAtual.setScale(ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
            }
            modelo.addLine(linhaSomaTotal);
            sql.delete(0, sql.length());
            sql.append("select rel_xml from relatoriosistema where rel_codigo = ");
            sql.append(RelatorioResumoProducaoAnual.getModuloAcesso());
            rs = Conexao.executeQuery(st, sql.toString());
            if (rs.next()) {
                Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                gerador.setPai(this.panelCentro);
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                gerador.setAcaoFechar(new Runnable(){

                    @Override
                    public void run() {
                        RelatorioResumoProducaoAnual.this.panelCentro.removeAll();
                        RelatorioResumoProducaoAnual.this.panelCentro.repaint();
                        RelatorioResumoProducaoAnual.this.habilitaBotaoImprimir(true);
                    }
                });
                HashMap<String, Object> var = new HashMap<String, Object>();
                var.put("filtroData", this.getFiltroTexto("filtroData"));
                var.put("filtroFilial", this.getDescricaoFilial());
                gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                this.panelCentro.revalidate();
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RelatorioResumoProducaoAnual");
        }
        this.apagarSplash(splashMensagem);
        Conexao.fecharStatement(st);
        System.gc();
        this.setCursor(Cursor.getDefaultCursor());
    }

    private BigDecimal getTotalFaturado(int mesConsulta) throws SQLException {
        StringBuilder sql = new StringBuilder();
        Statement st = Conexao.getStatement();
        sql.append(" select sum(fat.fat_adicional + fat.fat_despcobranca + fat.fat_totalmateriais + fat.fat_totalexames ");
        sql.append("        + ((fat.fat_totalexames * fat.fat_percacrescimo) / 100)  - ( (fat.fat_totalexames * fat.fat_percdesconto) /100 )) as totalFaturado ");
        sql.append("   from fatura fat where fat.fil_codigo ").append(this.getCodFilial());
        sql.append("        and fat.fat_datacancelamento is null and extract(YEAR from  fat.fat_dtemis) = '").append(this.getFiltroTexto("filtroData")).append("'");
        sql.append("        and extract(month from  fat.fat_dtemis) = '").append(mesConsulta).append("'");
        ResultSet rs = Conexao.executeQuery(st, sql);
        if (rs.next()) {
            return rs.getBigDecimal("totalFaturado");
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal getTotalFaturar(int mesConsulta) throws SQLException {
        StringBuilder sql = new StringBuilder();
        Statement st = Conexao.getStatement();
        sql.append(" select Sum(CASE  WHEN exa.fil_codigo IS NOT NULL THEN Calculaprecototalexamerequisicao(a.fil_codigo, req.con_codigo, req.req_codigo, ");
        sql.append("      COALESCE(exg.exa_codfilho, exa.exa_codigo), COALESCE(exg.mco_codfilho, a.mco_codigo), false, true, true, a.exr_vlrchexame, ");
        sql.append("   \t\t a.exr_vlrch, a.exr_valorporte,a.exr_valorcusto,  a.exr_valoruco , a.exr_vlrbalcaoconvenio, ");
        sql.append("   \t\t false,  a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, con.con_precosdiferenciados ");
        sql.append("   \t\t ,con.con_reajuste, con.con_cobrmaterial,con.con_percpgtomaterial, con.con_percpgto , con.con_tpcalcfatu,con.con_tpcalcch, ");
        sql.append("   \t\t con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo,con.con_acrescimoporte,con.con_acrescimouco, con.con_descontoporte, ");
        sql.append("   \t\t con.con_descontouco, con.con_valorch,").append(ParametrosGerais.getCasasPrecoExame()).append(",");
        sql.append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", false,");
        sql.append(" \t\t  COALESCE(a.met_codigo, elm.met_codigo,  emc.met_codigo)) ELSE Calculaprecototalexamerequisicao(a.fil_codigo, req.con_codigo,  req.req_codigo, ");
        sql.append(" \t\t\tCOALESCE(exg.exa_codfilho, w.exa_codigo), COALESCE(exg.mco_codfilho, a.mco_codigo), false, true, ");
        sql.append("   \t\t true,a.exr_vlrchexame , a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, false, a.exr_vlrmaterial, ");
        sql.append("   \t\t a.exr_vlrbalcaoconvenio,con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial,con.con_percpgto, con.con_tpcalcfatu, ");
        sql.append("   \t\t con.con_tpcalcch,con.con_perguntarpercbalcao, con.con_acrescimo ,con.con_bonus,con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, ");
        sql.append("   \t\t con.con_descontoporte, con.con_descontouco,con.con_valorch,").append(ParametrosGerais.getCasasPrecoExame()).append(",").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", false, ");
        sql.append(" \t\t\tCOALESCE(a.met_codigo, elm.met_codigo,emc.met_codigo))  END) AS totalFaturar ");
        this.geraSqlFaturarFaturado(mesConsulta, sql);
        ResultSet rs = Conexao.executeQuery(st, sql);
        if (rs.next()) {
            return rs.getBigDecimal("totalFaturar");
        }
        return BigDecimal.ZERO;
    }

    private void geraSqlFaturarFaturado(int mesConsulta, StringBuilder sql) {
        sql.append("  FROM examerequisicao AS a ");
        sql.append("       JOIN requisicao req ON a.req_codigo = req.req_codigo AND a.fil_codigo = req.fil_codigo ");
        sql.append("  LEFT JOIN convenios con ON req.con_codigo = con.con_codigo AND req.fil_codigo = con.fil_codigo ");
        sql.append("  LEFT JOIN examerequisicaoguiaagrupada exg ON a.fil_codigo = exg.fil_codigo AND a.req_codigo = exg.req_codigo AND a.exa_codigo = exg.exa_codigo AND a.mco_codigo = exg.mco_codigo ");
        sql.append("  LEFT JOIN exames exa ON exg.fil_codigo = exa.fil_codigo AND exg.exa_codfilho = exa.exa_codigo ");
        sql.append("  LEFT JOIN materialcoleta mco ON exg.fil_codigo = mco.fil_codigo  AND exg.mco_codfilho = mco.mco_codigo ");
        sql.append("  LEFT JOIN examematcoleta emc ON exg.fil_codigo = emc.fil_codigo AND exg.exa_codfilho = emc.exa_codigo AND exg.mco_codfilho = emc.mco_codigo ");
        sql.append("  LEFT JOIN examelayoutmetodo elm ON exg.fil_codigo = elm.fil_codigo AND exg.exa_codfilho = elm.exa_codigo AND exg.mco_codfilho = elm.mco_codigo AND con.lay_codigo = elm.lay_codigo AND a.met_codigo = elm.met_codigo ");
        sql.append("  LEFT JOIN detalhetabelapreco dtp ON exg.fil_codigo = dtp.fil_codigo AND exg.exa_codfilho = dtp.exa_codigo  AND exg.mco_codfilho = dtp.mco_codigo  AND con.tpe_codigo = dtp.tpe_codigo ");
        sql.append("  LEFT JOIN tabelaprecoexamesporte tpp ON dtp.fil_codigo = tpp.fil_codigo  AND dtp.tpe_codigo = tpp.tpe_codigo AND dtp.tpp_porte = tpp.tpp_porte ");
        sql.append("  LEFT JOIN tabelaprecoexames tpe ON con.fil_codigo = tpe.fil_codigo  AND con.tpe_codigo = tpe.tpe_codigo ");
        sql.append("  LEFT JOIN examematcoleta u  ON a.fil_codigo = u.fil_codigo AND a.exa_codigo = u.exa_codigo AND a.mco_codigo = u.mco_codigo ");
        sql.append("  LEFT JOIN materialcoleta v ON u.fil_codigo = v.fil_codigo AND u.mco_codigo = v.mco_codigo ");
        sql.append("  LEFT JOIN exames w  ON a.fil_codigo = w.fil_codigo AND a.exa_codigo = w.exa_codigo ");
        sql.append("  LEFT JOIN detalhetabelapreco dtp2 ON con.fil_codigo = dtp2.fil_codigo  AND con.tpe_codigo = dtp2.tpe_codigo AND a.exa_codigo = dtp2.exa_codigo AND a.mco_codigo = dtp2.mco_codigo ");
        sql.append(" WHERE extract(YEAR from  req.req_dtfatura) = '").append(this.getFiltroTexto("filtroData")).append("'");
        sql.append("   AND extract(month from  req.req_dtfatura) = '").append(mesConsulta).append("'");
        sql.append("   AND a.exr_excluido = false ");
        sql.append("   AND req.req_excluida = false ");
        sql.append("   AND a.fil_codigo ").append(this.getCodFilial());
        sql.append("   AND a.exr_datafatura is null ");
    }

    private int obterPosicao(Object[] o) {
        for (int i = 0; i <= o.length; ++i) {
            if (!o[i].equals("mesCod")) continue;
            return i;
        }
        return 0;
    }

    private void apagarSplash(SplashMensagem splashMensagem) {
        if (splashMensagem != null) {
            splashMensagem.apagar();
        }
    }

    private String getDescricaoFilial() throws SQLException {
        StringBuilder sql = new StringBuilder();
        Statement st = Conexao.getStatement();
        sql.append(" select array_to_string(array_agg(DISTINCT fil_descricao), ', ') as filtroFilial from filiais_postocoleta where fil_codigo ");
        sql.append(this.getCodFilial());
        ResultSet rs = Conexao.executeQuery(st, sql);
        if (rs.next()) {
            return rs.getString("filtroFilial");
        }
        return "";
    }

    public BigDecimal getValorRealRecebidoPago(int mes, String tipoReceberpagarReceber) throws SQLException {
        StringBuilder sql = new StringBuilder();
        Statement st = Conexao.getStatement();
        sql.append(" select case when sum(rpg.rpg_valortotal) > 0.0 then sum(rpg.rpg_valortotal) else 0.0 end as valor  ");
        sql.append(" \t from receberpagar rpg  ");
        sql.append("   join baixareceberpagar brp on rpg.fil_codigo = brp.fil_codigo and rpg.rpg_codigo = brp.rpg_codigo ");
        sql.append("   join baixa bxa on brp.fil_codigo = bxa.fil_codigo and brp.bxa_codigo = bxa.bxa_codigo ");
        sql.append("  where DATE_PART('YEAR', rpg.rpg_vencimento) = '").append(this.getFiltroTexto("filtroData")).append("'");
        sql.append(" \t  and extract( month from rpg.rpg_vencimento) ='").append(mes).append("'");
        sql.append(" \t  and rpg.rpg_datacancelado is null ");
        sql.append(" \t  and rpg.rpg_tipo = '").append(tipoReceberpagarReceber).append("'");
        sql.append(" \t  and rpg.fil_codigo ").append(this.getCodFilial());
        sql.append("    and bxa.bxa_situacao ='").append("Q").append("'");
        sql.append("    and rpg.rpg_situacao = '").append("Q").append("'");
        sql.append("    and rpg.rpg_valortotal is not null ");
        sql.append("    and rpg.rpg_valortotal > 0.0 ");
        ResultSet rs = Conexao.executeQuery(st, sql);
        if (rs.next()) {
            return rs.getBigDecimal("valor");
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getValorReceberPagar(int mes, String pagarReceberTipo) throws SQLException {
        StringBuilder sql = new StringBuilder();
        Statement st = Conexao.getStatement();
        sql.append(" select case when sum(rgp.rpg_valortotal) > 0.0 then sum(rgp.rpg_valortotal) else 0.0 end as valor from receberpagar as rgp ");
        sql.append(" \twhere DATE_PART('YEAR', rgp.rpg_vencimento) = '").append(this.getFiltroTexto("filtroData")).append("'");
        sql.append(" \t  and extract( month from rgp.rpg_vencimento) ='").append(mes).append("'");
        sql.append(" \t  and rgp.rpg_datacancelado is null and rgp.rpg_valortotal is not null ");
        sql.append("    and rgp.rpg_valortotal > 0.0 and rgp.rpg_tipo = '").append(pagarReceberTipo).append("'");
        sql.append(" \t  and rgp.fil_codigo ").append(this.getCodFilial());
        sql.append("    and rgp.rpg_situacao in('");
        sql.append("A").append("','").append("Q").append("')");
        ResultSet rs = Conexao.executeQuery(st, sql);
        if (rs.next()) {
            return rs.getBigDecimal("valor");
        }
        return BigDecimal.ZERO;
    }

    public Integer getTotalRequisicao(int mes) throws SQLException {
        StringBuilder sql = new StringBuilder();
        Statement st = Conexao.getStatement();
        sql.append(" \tselect count(*) as totalRequisicao ");
        sql.append("    from requisicao a ");
        sql.append("   where fil_codigo ").append(this.getCodFilial());
        sql.append("     and extract(year from a.req_data)= '").append(this.getFiltroTexto("filtroData")).append("'");
        sql.append("     and extract(month from a.req_data) = '").append(mes).append("'");
        sql.append("     and a.req_excluida = false ");
        ResultSet rs = Conexao.executeQuery(st, sql);
        if (rs.next()) {
            return rs.getInt("totalRequisicao");
        }
        return 0;
    }

    public Integer getTotalExame(int mes) throws SQLException {
        StringBuilder sql = new StringBuilder();
        Statement st = Conexao.getStatement();
        sql.append("   select count(*) as totalExame ");
        sql.append("    from examerequisicao ");
        sql.append("   where fil_codigo ").append(this.getCodFilial());
        sql.append("     and extract(year from exr_data)= '").append(this.getFiltroTexto("filtroData")).append("'");
        sql.append("     and extract(month from exr_data) = '").append(mes).append("'");
        sql.append("     and exr_excluido = false ");
        ResultSet rs = Conexao.executeQuery(st, sql);
        if (rs.next()) {
            return rs.getInt("totalExame");
        }
        return 0;
    }

    public Integer[] geValorTotalCustoSimplesExame(int mes) throws SQLException {
        StringBuilder sql = new StringBuilder();
        Statement st = Conexao.getStatement();
        sql.append("   select SUM(a.exr_custosimples) as somaTotalCustoSimplesExameHistorico ");
        sql.append("        ,SUM(h.emc_custosimples) as somaTotalCustoSimplesExameAtual ");
        sql.append("    from examerequisicao a ");
        sql.append("    join examematcoleta h on a.fil_codigo = h.fil_codigo and a.exa_codigo = h.exa_codigo and a.mco_codigo = h.mco_codigo ");
        sql.append("   where a.fil_codigo ").append(this.getCodFilial());
        sql.append("     and extract(year from a.exr_data)= '").append(this.getFiltroTexto("filtroData")).append("'");
        sql.append("     and extract(month from a.exr_data) = '").append(mes).append("'");
        sql.append("     and a.exr_excluido = false ");
        ResultSet rs = Conexao.executeQuery(st, sql);
        Integer[] total = new Integer[2];
        if (rs.next()) {
            total[0] = rs.getInt("somaTotalCustoSimplesExameHistorico");
            total[1] = rs.getInt("somaTotalCustoSimplesExameAtual");
            return total;
        }
        return null;
    }

    public Integer getDiaTrabalhado(int mes) throws SQLException {
        StringBuilder sql = new StringBuilder();
        Statement st = Conexao.getStatement();
        sql.append(" select Count(DISTINCT( Cast(req_data AS DATE) ))  AS  diaTrabalhado   ");
        sql.append("   from requisicao                                                     ");
        sql.append("  where fil_codigo ").append(this.getCodFilial());
        sql.append("    and extract(year from req_data)= '").append(this.getFiltroTexto("filtroData")).append("'");
        sql.append("    and extract(month from req_data) = '").append(mes).append("'");
        sql.append("    and req_excluida = false                                           ");
        ResultSet rs = Conexao.executeQuery(st, sql);
        if (rs.next()) {
            return rs.getInt("diaTrabalhado");
        }
        return 0;
    }

    public BigDecimal getValorTotalRequisicao(int mes) throws SQLException {
        StringBuilder sql = new StringBuilder();
        Statement st = Conexao.getStatement();
        sql.append("    select case when Sum(a.req_total) is null then 0.0 else Sum(a.req_total) end  AS valorTotalRequisicao    ");
        sql.append("    from requisicao a                                 ");
        sql.append("    WHERE Extract(YEAR from  a.req_data) ='").append(this.getFiltroTexto("filtroData")).append("'");
        sql.append("      AND Extract(month FROM a.req_data) = '").append(mes).append("'");
        sql.append("      AND a.req_excluida = false                      ");
        sql.append("      AND a.fil_codigo ").append(this.getCodFilial());
        sql.append("      AND a.req_total is not null ");
        sql.append("      AND a.req_total > 0 ");
        ResultSet rs = Conexao.executeQuery(st, sql);
        if (rs.next()) {
            return rs.getBigDecimal("valorTotalRequisicao");
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getValorTotalPagoRequisicao(int mes) throws SQLException {
        StringBuilder sql = new StringBuilder();
        Statement st = Conexao.getStatement();
        sql.append("  select case when Sum(a.req_totpago) > 0.0 then Sum(a.req_totpago) else 0.0 end AS totalPagoRequisicao    ");
        sql.append("     from requisicao a ");
        sql.append("     WHERE Extract(YEAR from  a.req_data) = '").append(this.getFiltroTexto("filtroData")).append("'");
        sql.append("      AND Extract(month FROM a.req_data) = '").append(mes).append("'");
        sql.append("      AND a.req_excluida = false ");
        sql.append("      and a.req_totpago is not null ");
        sql.append("      and a.req_totpago > 0.0 ");
        sql.append("      AND a.fil_codigo ").append(this.getCodFilial());
        ResultSet rs = Conexao.executeQuery(st, sql);
        if (rs.next()) {
            return rs.getBigDecimal("totalPagoRequisicao");
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getValorTotalDesconto(int mes) throws SQLException {
        StringBuilder sql = new StringBuilder();
        Statement st = Conexao.getStatement();
        sql.append(" select case when Sum(a.req_vlrdesconto) > 0.0 then Sum(a.req_vlrdesconto) else 0.0 end AS valorTotalDesconto ");
        sql.append("     from requisicao a                                  ");
        sql.append("    WHERE Extract(YEAR from  a.req_data) = '").append(this.getFiltroTexto("filtroData")).append("'");
        sql.append("      AND Extract(month FROM a.req_data) = '").append(mes).append("'");
        sql.append("      AND a.req_excluida = false                       ");
        sql.append("      and a.req_vlrdesconto is not null ");
        sql.append("      and a.req_vlrdesconto > 0.0 ");
        sql.append("      AND a.fil_codigo ").append(this.getCodFilial());
        ResultSet rs = Conexao.executeQuery(st, sql);
        if (rs.next()) {
            return rs.getBigDecimal("valorTotalDesconto");
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getValorTotalAcrescimo(int mes) throws SQLException {
        StringBuilder sql = new StringBuilder();
        Statement st = Conexao.getStatement();
        sql.append(" select case when Sum(a.req_vlracrescimo) > 0.0 then Sum(a.req_vlracrescimo) else 0.0 end AS valorTotalAcrescimo ");
        sql.append("     from requisicao a                                  ");
        sql.append("    WHERE Extract(YEAR from  a.req_data) = '").append(this.getFiltroTexto("filtroData")).append("'");
        sql.append("      AND Extract(month FROM a.req_data) = '").append(mes).append("'");
        sql.append("      AND a.req_excluida = false                       ");
        sql.append("      and a.req_vlracrescimo is not null ");
        sql.append("      and a.req_vlracrescimo > 0.0 ");
        sql.append("      AND a.fil_codigo ").append(this.getCodFilial());
        ResultSet rs = Conexao.executeQuery(st, sql);
        if (rs.next()) {
            return rs.getBigDecimal("valorTotalAcrescimo");
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getValorAcumuladoMensalFaturar(int mes) throws SQLException {
        StringBuilder sql = new StringBuilder();
        Statement st = Conexao.getStatement();
        sql.append("    select case when sum(round((calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo, true, false, false, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, d.con_precosdiferenciados, d.con_reajuste, d.con_cobrmaterial, d.con_percpgtomaterial, d.con_percpgto, d.con_tpcalcfatu, d.con_tpcalcch, d.con_perguntarpercbalcao, d.con_acrescimo, d.con_bonus, d.tpe_codigo, d.con_acrescimoporte, d.con_acrescimouco, d.con_descontoporte, d.con_descontouco, d.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", a.met_codigo) + a.exr_vlrmaterial) - a.exr_vlrmaterial, ").append(ParametrosGerais.getCasasPrecoExame()).append(")) > 0.0");
        sql.append("    then sum(round((calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo, true, false, false, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, d.con_precosdiferenciados, d.con_reajuste, d.con_cobrmaterial, d.con_percpgtomaterial, d.con_percpgto, d.con_tpcalcfatu, d.con_tpcalcch, d.con_perguntarpercbalcao, d.con_acrescimo, d.con_bonus, d.tpe_codigo, d.con_acrescimoporte, d.con_acrescimouco, d.con_descontoporte, d.con_descontouco, d.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", a.met_codigo) + a.exr_vlrmaterial) - a.exr_vlrmaterial, ").append(ParametrosGerais.getCasasPrecoExame()).append(")) else 0.0 end as valorAcumuladoMensalFaturar ");
        sql.append("    from examerequisicao a ");
        sql.append("    join requisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo");
        sql.append("    left join exames c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo");
        sql.append("    left join convenios d on a.fil_codigo = d.fil_codigo and b.con_codigo = d.con_codigo");
        sql.append("    left join examematcoleta e on a.mco_codigo = e.mco_codigo and a.fil_codigo = e.fil_codigo and c.exa_codigo = e.exa_codigo");
        sql.append("    left join examesetor es on a.fil_codigo = es.fil_codigo and a.exa_codigo = es.exa_codigo and es.ese_default = true");
        sql.append("    left join examematgrupo g on a.fil_codigo = g.fil_codigo and a.exa_codigo = g.exa_codigo and a.mco_codigo = g.mco_codigo");
        sql.append("    left join setores f on es.fil_codigo = f.fil_codigo and es.set_codigo = f.set_codigo");
        sql.append("    left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo");
        sql.append("    left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo");
        sql.append("    left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo");
        sql.append("    WHERE Extract(year from  b.req_data) = '").append(this.getFiltroTexto("filtroData")).append("'");
        sql.append("      AND Extract(month from b.req_data) = '").append(mes).append("'");
        sql.append("      AND b.req_excluida = false                       ");
        sql.append("      AND a.exr_excluido = false");
        sql.append("      AND d.con_cobrexame = false");
        sql.append("      AND b.fil_codigo ").append(this.getCodFilial());
        ResultSet rs = Conexao.executeQuery(st, sql);
        if (rs.next()) {
            return rs.getBigDecimal("valorAcumuladoMensalFaturar");
        }
        rs.close();
        Conexao.fecharStatement(st);
        return BigDecimal.ZERO;
    }

    private String getCodFilial() {
        StringBuilder retornoCod = new StringBuilder();
        String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
        if (filiais == null) {
            filiais = new String[]{Variaveis.filialPadrao};
        }
        retornoCod.append(" in(");
        for (int i = 0; i < filiais.length; ++i) {
            retornoCod.append(filiais[i]);
            if (i >= filiais.length - 1) continue;
            retornoCod.append(", ");
        }
        retornoCod.append(")");
        return retornoCod.toString();
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0880400800");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0880400801");
    }

    private Object validarValor(Object valor) {
        if (valor != null && !valor.toString().trim().isEmpty()) {
            return valor;
        }
        return 0;
    }

    public BigDecimal getvalorMensalContasCaixa(int mes) throws SQLException {
        String nomeRelatorio = "valorMensalContasCaixa";
        StringBuilder sql = new StringBuilder();
        StringBuilder sqlDebito = new StringBuilder();
        StringBuilder sqlCredito = new StringBuilder();
        sql.append((CharSequence)this.getSqlContas(nomeRelatorio));
        sql.append(" AND Extract(month from lancto.lcx_datahora) = ").append(mes);
        sql.append(" AND lancto.fil_codigo ").append(this.getCodFilial());
        sql.append(" AND ccr.cco_tipo in('X')");
        sqlDebito.append((CharSequence)sql);
        sqlCredito.append((CharSequence)sql);
        sqlCredito.append(" AND lancto.lcx_tipo in ('").append("C").append("') ");
        sqlDebito.append(" AND lancto.lcx_tipo in ('").append("D").append("') ");
        return this.subtraiDebito(sqlDebito, sqlCredito, nomeRelatorio);
    }

    public BigDecimal getvalorMensalContasCorrente(int mes) throws SQLException {
        String nomeRelatorio = "valorMensalContasCorrente";
        StringBuilder sql = new StringBuilder();
        StringBuilder sqlCredito = new StringBuilder();
        StringBuilder sqlDebito = new StringBuilder();
        sql.append((CharSequence)this.getSqlContas(nomeRelatorio));
        sql.append(" AND Extract(month from lancto.lcx_datahora) = ").append(mes);
        sql.append(" AND lancto.fil_codigo ").append(this.getCodFilial());
        sql.append(" AND ccr.cco_tipo in('C')");
        sqlDebito.append((CharSequence)sql);
        sqlCredito.append((CharSequence)sql);
        sqlCredito.append(" AND lancto.lcx_tipo in ('").append("C").append("') ");
        sqlDebito.append(" AND lancto.lcx_tipo in ('").append("D").append("') ");
        return this.subtraiDebito(sqlDebito, sqlCredito, nomeRelatorio);
    }

    public BigDecimal getvalorMensalContasCaixaConciliado(int mes) throws SQLException {
        String nomeRelatorio = "valorMensalContasCaixaConciliado";
        StringBuilder sql = new StringBuilder();
        StringBuilder sqlDebito = new StringBuilder();
        StringBuilder sqlCredito = new StringBuilder();
        sql.append((CharSequence)this.getSqlContas(nomeRelatorio));
        sql.append(" AND Extract(month from lancto.lcx_datahora) = ").append(mes);
        sql.append(" AND lancto.fil_codigo ").append(this.getCodFilial());
        sql.append(" AND ccr.cco_tipo in('X')");
        sql.append(" AND lancto.lcx_situacao in('O')");
        sql.append(" AND lancto.lcx_conciliacao is not NULL");
        sqlDebito.append((CharSequence)sql);
        sqlCredito.append((CharSequence)sql);
        sqlCredito.append(" AND lancto.lcx_tipo in ('").append("C").append("') ");
        sqlDebito.append(" AND lancto.lcx_tipo in ('").append("D").append("') ");
        return this.subtraiDebito(sqlDebito, sqlCredito, nomeRelatorio);
    }

    public BigDecimal getvalorMensalContasCorrenteConciliado(int mes) throws SQLException {
        String nomeRelatorio = "valorMensalContasCorrenteConciliado";
        StringBuilder sql = new StringBuilder();
        StringBuilder sqlCredito = new StringBuilder();
        StringBuilder sqlDebito = new StringBuilder();
        sql.append((CharSequence)this.getSqlContas(nomeRelatorio));
        sql.append(" AND Extract(month from lancto.lcx_datahora) = ").append(mes);
        sql.append(" AND lancto.fil_codigo ").append(this.getCodFilial());
        sql.append(" AND ccr.cco_tipo in('C')");
        sql.append(" AND lancto.lcx_situacao in('O')");
        sql.append(" AND lancto.lcx_conciliacao is not NULL");
        sqlDebito.append((CharSequence)sql);
        sqlCredito.append((CharSequence)sql);
        sqlCredito.append(" AND lancto.lcx_tipo in ('").append("C").append("') ");
        sqlDebito.append(" AND lancto.lcx_tipo in ('").append("D").append("') ");
        return this.subtraiDebito(sqlDebito, sqlCredito, nomeRelatorio);
    }

    private StringBuilder getSqlContas(String nomeRelatorio) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select");
        sql.append(" case");
        sql.append(" when sum(lcx_valor) >= 0.0  then  sum(lcx_valor)");
        sql.append(" else 0.0");
        sql.append(" end as ").append(nomeRelatorio);
        sql.append(" from lanctocaixa  as lancto");
        sql.append(" left join contacorrente as ccr on");
        sql.append(" lancto.fil_codigo = ccr.fil_codigo and");
        sql.append(" lancto.cco_reduzido  =  ccr.cco_reduzido  ");
        sql.append(" WHERE Extract(year from  lancto.lcx_datahora) =").append(this.getFiltroTexto("filtroData"));
        return sql;
    }

    private BigDecimal subtraiDebito(StringBuilder sqlDebito, StringBuilder sqlCredito, String nomeRelatorio) throws SQLException {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        BigDecimal totalAcumulado = new BigDecimal(0);
        ResultSet rsCredito = Conexao.executeQuery(st, sqlCredito);
        ResultSet rsDebito = Conexao.executeQuery(st2, sqlDebito);
        if (rsCredito.next()) {
            totalAcumulado = rsCredito.getBigDecimal(nomeRelatorio);
        }
        if (rsDebito.next()) {
            totalAcumulado = totalAcumulado.subtract(rsDebito.getBigDecimal(nomeRelatorio));
        }
        rsDebito.close();
        rsCredito.close();
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        return totalAcumulado;
    }
}

