/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.gerencial;

import jalis.comum.Conexao;
import jalis.comum.ConstantesGerais;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.laboratorio.relatorios.util.RelatorioUtil;
import jalis.relatorio.Gerador;
import jalis.relatorio.gerador.Relatorio;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.SplashMensagem;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.swing.table.TableModel;

public class RelatorioRealizadosAnual
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String[] ordem = new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"};
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_SETOR = "filtroSetor";
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_MEDICO = "filtroMedico";
    private final String FILTRO_ESTACAO = "filtroEstacao";
    private final String FILTRO_COLETA = "filtroColeta";
    private final String FILTRO_ANO = "filtroAno";
    private final String FILTRO_MES = "filtroMes";
    private final String FILTRO_EXAME = "filtroExame";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String FILTRO_GRUPO = "filtroGrupo";
    private final String FILTRO_MATERIAL = "filtroMaterial";
    private final String FILTRO_DESMEMBRAR_MATERIAL = "filtroDesmembrarMaterial";
    private final String FILTRO_TIPO_DATA = "filtroDataResultado";
    public static final int TIPO_REALIZADOS = 1;
    public static final int TIPO_SOLICITADOS = 2;
    public static final int TIPO_SOLICITADOS_CONVENIO = 3;
    public static final int TIPO_REALIZADOS_CONVENIO = 4;
    private int tipoRelatorio = 1;
    protected static String[] campos;
    protected static String[] camposParaValores;

    public RelatorioRealizadosAnual(int tipo) {
        campos = Constantes.CAMPOS_FILIAL;
        campos = ArraysUtil.concatenar(campos, camposParaValores);
        this.tipoRelatorio = tipo;
        if (tipo == 1 || tipo == 2) {
            campos = ArraysUtil.concatenar(campos, new String[]{"codigoExame", "descricaoExame"});
        } else if (tipo == 4 || tipo == 3) {
            campos = ArraysUtil.concatenar(campos, new String[]{"codigoConvenio", "fantasiaConvenio"});
        }
        if (tipo == 1) {
            this.montaBarraDescricao("Relat\u00f3rio de exames realizados anual", "Contagem dos exames realizados no per\u00edodo anual", "relatorios/rel_ger_analitico_realizados_anual.jpg");
        } else if (tipo == 3) {
            this.montaBarraDescricao("Relat\u00f3rio de exames solicitados anual por conv\u00eanio", "Contagem dos exames solicitados por conv\u00eanio no per\u00edodo anual", "relatorios/rel_ger_analitico_solicitados_anual.jpg");
        }
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroSetor", "Setor", "setores", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroEstacao", "Esta\u00e7\u00e3o", "estacoes", "", 1, new String[]{"est_codigo", "est_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroColeta", "Coleta", "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroExame", "Exame", "exames", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroMaterial", "Material", "materialcoleta", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"mco_codigo", "mco_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroGrupo", "Grupo", "grupo", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"grp_codigo", "grp_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltroAvancado("filtroMedico", "M\u00e9dico", "medico", "fil_codigo = " + Variaveis.filialPadrao, 4, new String[]{"med_conselho", "med_crm", "med_uf", "med_nome"}, new String[]{"Conselho", "N\u00famero", "UF", "Nome"}, new int[]{70, 70, 40, 0}, false, new int[]{0, 1, 2});
        this.adicionaFiltroNumero("filtroMes", "M\u00eas inicial:", 2);
        this.adicionaFiltroNumero("filtroAno", "Ano:", 4);
        this.adicionaNomeVariavel("descricaoMes1");
        this.adicionaNomeVariavel("descricaoMes2");
        this.adicionaNomeVariavel("descricaoMes3");
        this.adicionaNomeVariavel("descricaoMes4");
        this.adicionaNomeVariavel("descricaoMes5");
        this.adicionaNomeVariavel("descricaoMes6");
        this.adicionaNomeVariavel("descricaoMes7");
        this.adicionaNomeVariavel("descricaoMes8");
        this.adicionaNomeVariavel("descricaoMes9");
        this.adicionaNomeVariavel("descricaoMes10");
        this.adicionaNomeVariavel("descricaoMes11");
        this.adicionaNomeVariavel("descricaoMes12");
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.adicionaRetornaFiltroCheck("filtroDataResultado", "Filtrar por data de resultado", false);
        this.setModuloConfigurar(RelatorioRealizadosAnual.getModuloConfigurar(tipo));
        this.setModuloAcesso(RelatorioRealizadosAnual.getModuloAcesso(tipo));
        this.setCamposConfigurador(campos);
    }

    private HashMap<String, String> getCamposSelect() {
        LinkedHashMap<String, String> mapaTodosCampos = new LinkedHashMap<String, String>();
        for (int i = 1; i <= 12; ++i) {
            mapaTodosCampos.put("valorExameMes" + String.valueOf(i), "sum(calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo, true, false, false, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, d.con_precosdiferenciados, d.con_reajuste, d.con_cobrmaterial, d.con_percpgtomaterial, d.con_percpgto, d.con_tpcalcfatu, d.con_tpcalcch, d.con_perguntarpercbalcao, d.con_acrescimo, d.con_bonus, d.tpe_codigo, d.con_acrescimoporte, d.con_acrescimouco, d.con_descontoporte, d.con_descontouco, d.con_valorch, " + ParametrosGerais.getCasasPrecoExame() + ", " + ParametrosGerais.getArredondamentoPrecoExame().ordinal() + ", " + (ParametrosGerais.getPrecoMetodologia() ? "true" : "false") + ", a.met_codigo))");
            mapaTodosCampos.put("valorTotalExameMes" + String.valueOf(i), "sum(calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo, true, false, true, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, d.con_precosdiferenciados, d.con_reajuste, d.con_cobrmaterial, d.con_percpgtomaterial, d.con_percpgto, d.con_tpcalcfatu, d.con_tpcalcch, d.con_perguntarpercbalcao, d.con_acrescimo, d.con_bonus, d.tpe_codigo, d.con_acrescimoporte, d.con_acrescimouco, d.con_descontoporte, d.con_descontouco, d.con_valorch, " + ParametrosGerais.getCasasPrecoExame() + ", " + ParametrosGerais.getArredondamentoPrecoExame().ordinal() + ", " + (ParametrosGerais.getPrecoMetodologia() ? "true" : "false") + ", a.met_codigo))");
            mapaTodosCampos.put("valorLiquidoTotalExameMes" + String.valueOf(i), "sum(round(calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo, true, false, false, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, d.con_precosdiferenciados, d.con_reajuste, d.con_cobrmaterial, d.con_percpgtomaterial, d.con_percpgto, d.con_tpcalcfatu, d.con_tpcalcch, d.con_perguntarpercbalcao, d.con_acrescimo, d.con_bonus, d.tpe_codigo, d.con_acrescimoporte, d.con_acrescimouco, d.con_descontoporte, d.con_descontouco, d.con_valorch, " + ParametrosGerais.getCasasPrecoExame() + ", " + ParametrosGerais.getArredondamentoPrecoExame().ordinal() + ", " + (ParametrosGerais.getPrecoMetodologia() ? "true" : "false") + ", a.met_codigo) * ((100 - b.req_desconto)/100), " + ParametrosGerais.getCasasPrecoExame() + "))");
            mapaTodosCampos.put("valorCHOriginalMes" + String.valueOf(i), "sum(a.exr_vlrchexame)");
            mapaTodosCampos.put("valorCHMes" + String.valueOf(i), "sum(calculachexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo))");
            mapaTodosCampos.put("valorMaterialMes" + String.valueOf(i), "sum(a.exr_vlrmaterial)");
            mapaTodosCampos.put("valorCustoSimplesExameAgrupadoMes" + String.valueOf(i), "sum(COALESCE(a.exr_custosimples, 0.0))");
            mapaTodosCampos.put("valorCustoSimplesExameMes" + String.valueOf(i), "COALESCE(avg(a.exr_custosimples), 0.0)");
            mapaTodosCampos.put("valorCustoSimplesExameAtualMes" + String.valueOf(i), "sum(COALESCE(emc.emc_custosimples, 0.0))");
            mapaTodosCampos.put("quantidadeExamesMes" + String.valueOf(i), "count(a.exa_codigo)");
            mapaTodosCampos.put("quantidadeRequisicoesMes" + String.valueOf(i), "count(distinct b.req_codigo)");
        }
        mapaTodosCampos.put("codigoExame", "a.exa_codigo");
        mapaTodosCampos.put("descricaoExame", "c.exa_descricao");
        mapaTodosCampos.put("descricaoExameAscii", "UPPER(TO_ASCII(c.exa_descricao))");
        mapaTodosCampos.put("codigoConvenio", "b.con_codigo");
        mapaTodosCampos.put("fantasiaConvenio", "d.con_fantasia");
        if (this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
            mapaTodosCampos.putAll(Constantes.MAPA_SELECT_FILIAL);
        }
        return mapaTodosCampos;
    }

    private String getLayoutRelatorio(Statement st) {
        StringBuilder buf = new StringBuilder();
        try {
            buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
            buf.append(RelatorioRealizadosAnual.getModuloAcesso(this.tipoRelatorio));
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                return rs.getString("rel_xml");
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar layout do relat\u00f3rio.\n" + e.getMessage(), e.getStackTrace());
        }
        return null;
    }

    private ModeloGridTable getModeloMes(Statement st, Statement st2, String layoutRelatorio, HashMap<String, String> mapaTodosCampos, HashMap<String, String> mapaCamposObrigatorios, int ano, int mes, int indiceColuna, String[] filiais, String[] convenio, String[] setor, String[] estacoes, String[] coletas, String[] exames, String[] materiais, String[] grupos, String[] crm, String[] uf, String[] conselho) throws SQLException {
        int i;
        StringBuilder buf = new StringBuilder();
        HashMap<String, String> camposUtilizadosOriginal = Relatorio.getCamposBancoLayout(layoutRelatorio, mapaTodosCampos, mapaCamposObrigatorios);
        String fimMes = "mes" + String.valueOf(indiceColuna);
        HashMap<String, String> camposUtilizados = new HashMap<String, String>();
        HashMap<String, String> camposFilial = new HashMap<String, String>();
        for (String campof : Constantes.MAPA_SELECT_FILIAL.keySet()) {
            camposFilial.put(campof.toLowerCase(), Constantes.MAPA_SELECT_FILIAL.get(campof));
        }
        for (String chave : camposUtilizadosOriginal.keySet()) {
            if (chave.equalsIgnoreCase("codigoExame") || chave.equalsIgnoreCase("descricaoExame") || chave.equalsIgnoreCase("descricaoExameAscii") || chave.equalsIgnoreCase("codigoConvenio") || chave.equalsIgnoreCase("fantasiaConvenio")) {
                camposUtilizados.put(chave, camposUtilizadosOriginal.get(chave));
                continue;
            }
            if (camposFilial.containsKey(chave)) {
                camposUtilizados.put(chave, camposUtilizadosOriginal.get(chave));
                continue;
            }
            if (!chave.toLowerCase().endsWith(fimMes.toLowerCase())) continue;
            camposUtilizados.put(chave, camposUtilizadosOriginal.get(chave));
        }
        if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[1]) && (this.tipoRelatorio == 2 || this.tipoRelatorio == 1) && !camposUtilizados.containsKey("descricaoExameAscii".toLowerCase())) {
            camposUtilizados.put("descricaoExameAscii".toLowerCase(), "UPPER(TO_ASCII(c.exa_descricao))");
        }
        buf.append("select distinct ");
        buf.append(Relatorio.getFieldsSelect(camposUtilizados));
        buf.append(" from examerequisicao a ");
        buf.append(" left join requisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
        buf.append(" left join destino des on b.fil_codigo = des.fil_codigo and b.des_codigo = des.des_codigo ");
        buf.append(" left join exames c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo ");
        buf.append(" left join convenios d on a.fil_codigo = d.fil_codigo and b.con_codigo = d.con_codigo ");
        buf.append(" left join examesetor e on a.fil_codigo = e.fil_codigo and a.exa_codigo = e.exa_codigo and e.ese_default = true ");
        buf.append(" left join setores f on e.fil_codigo = f.fil_codigo and e.set_codigo = f.set_codigo ");
        buf.append(" left join medico med on b.fil_codigo =  med.fil_codigo and b.med_conselho = med.med_conselho and b.med_crm = med.med_crm and b.med_uf = med.med_uf ");
        buf.append(" left join examematgrupo g on a.fil_codigo = g.fil_codigo and a.exa_codigo = g.exa_codigo and a.mco_codigo = g.mco_codigo ");
        buf.append(" left join materialcoleta h on a.fil_codigo = h.fil_codigo and  a.mco_codigo = h.mco_codigo ");
        buf.append(" left join grupo i on a.fil_codigo = i.fil_codigo and g.grp_codigo = i.grp_codigo ");
        buf.append(" left join examematcoleta emc on a.fil_codigo = emc.fil_codigo and a.exa_codigo = emc.exa_codigo and a.mco_codigo = emc.mco_codigo ");
        if (this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
        }
        StringBuilder bufWhere = new StringBuilder();
        if (filiais == null) {
            filiais = new String[]{Variaveis.filialPadrao};
        }
        bufWhere.append(" where a.fil_codigo in (");
        for (i = 0; i < filiais.length; ++i) {
            bufWhere.append(filiais[i]);
            if (i >= filiais.length - 1) continue;
            bufWhere.append(", ");
        }
        bufWhere.append(") ");
        if (convenio != null) {
            bufWhere.append(" and b.con_codigo in (");
            for (i = 0; i < convenio.length; ++i) {
                bufWhere.append(convenio[i]);
                if (i >= convenio.length - 1) continue;
                bufWhere.append(", ");
            }
            bufWhere.append(")");
        }
        if (setor != null) {
            bufWhere.append(" and e.set_codigo in (");
            for (i = 0; i < setor.length; ++i) {
                bufWhere.append("'");
                bufWhere.append(setor[i]);
                bufWhere.append("'");
                if (i >= setor.length - 1) continue;
                bufWhere.append(", ");
            }
            bufWhere.append(")");
        }
        if (estacoes != null) {
            bufWhere.append(" and b.est_codigo in (");
            for (i = 0; i < estacoes.length; ++i) {
                bufWhere.append(estacoes[i]);
                if (i >= estacoes.length - 1) continue;
                bufWhere.append(", ");
            }
            bufWhere.append(")");
        }
        if (coletas != null) {
            bufWhere.append(" and b.col_codigo in (");
            for (i = 0; i < coletas.length; ++i) {
                bufWhere.append("'");
                bufWhere.append(coletas[i]);
                bufWhere.append("'");
                if (i >= coletas.length - 1) continue;
                bufWhere.append(", ");
            }
            bufWhere.append(")");
        }
        if (exames != null) {
            bufWhere.append(" and a.exa_codigo in (");
            for (i = 0; i < exames.length; ++i) {
                bufWhere.append("'");
                bufWhere.append(exames[i]);
                bufWhere.append("'");
                if (i >= exames.length - 1) continue;
                bufWhere.append(", ");
            }
            bufWhere.append(")");
        }
        if (materiais != null) {
            bufWhere.append(" and a.mco_codigo in (");
            for (i = 0; i < materiais.length; ++i) {
                bufWhere.append(materiais[i]);
                if (i >= materiais.length - 1) continue;
                bufWhere.append(", ");
            }
            bufWhere.append(")");
        }
        if (grupos != null) {
            bufWhere.append(" and g.grp_codigo in (");
            for (i = 0; i < grupos.length; ++i) {
                bufWhere.append("'");
                bufWhere.append(grupos[i]);
                bufWhere.append("'");
                if (i >= grupos.length - 1) continue;
                bufWhere.append(", ");
            }
            bufWhere.append(")");
        }
        if (crm != null && uf != null && crm.length <= ParametrosGerais.getQuantidadeMaximoFiltroAvancado()) {
            bufWhere.append(" and (");
            for (i = 0; i < crm.length; ++i) {
                bufWhere.append("(b.med_conselho = '");
                bufWhere.append(conselho[i]);
                bufWhere.append("' and b.med_crm = '");
                bufWhere.append(crm[i]);
                bufWhere.append("' and b.med_uf = '");
                bufWhere.append(uf[i]);
                bufWhere.append("')");
                if (i >= crm.length - 1) continue;
                bufWhere.append(" or ");
            }
            bufWhere.append(")");
        }
        if (this.tipoRelatorio == 1 || this.tipoRelatorio == 4) {
            bufWhere.append(" and a.exr_situacao not in ('");
            bufWhere.append("T");
            bufWhere.append("', '");
            bufWhere.append("A");
            bufWhere.append("', '");
            bufWhere.append("F");
            bufWhere.append("', '").append("R");
            bufWhere.append("', '', ' ') and a.exr_situacao is not null ");
        }
        bufWhere.append(" and b.req_excluida = false and a.exr_excluido = false ");
        bufWhere.append(" and extract(year from ").append(this.getCampoData()).append(") = ").append(ano);
        bufWhere.append(" and extract(month from ").append(this.getCampoData()).append(") = ").append(mes);
        buf.append(bufWhere.toString());
        buf.append(" group by ");
        if (this.tipoRelatorio == 1 || this.tipoRelatorio == 2) {
            buf.append(" a.exa_codigo, c.exa_descricao ");
        } else {
            buf.append(" b.con_codigo, d.con_fantasia ");
        }
        if (this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
            buf.append(" ,filial.fil_codigo, filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, ");
            buf.append(" filial.fil_complemento, filial.fil_cep, filial.fil_fone, filial.fil_cnes, ");
            buf.append(" filial.fil_fax, filial.fil_razaosocial, cidadefilial.cid_codigo, ");
            buf.append(" cidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo, ");
            buf.append(" bairrofilial.bai_descricao ");
        }
        buf.append(" order by ");
        if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[0])) {
            if (this.tipoRelatorio == 1 || this.tipoRelatorio == 2) {
                buf.append(" a.exa_codigo ");
            } else {
                buf.append(" b.con_codigo ");
            }
        } else if (this.tipoRelatorio == 4 || this.tipoRelatorio == 3) {
            buf.append(" d.con_fantasia ");
        } else {
            buf.append(" c.exa_descricao ");
        }
        String[] listaCamposUtilizados = new String[camposUtilizados.size()];
        Iterator<String> it = camposUtilizados.keySet().iterator();
        int i2 = 0;
        while (it.hasNext()) {
            listaCamposUtilizados[i2] = it.next().toString();
            ++i2;
        }
        ModeloGridTable modelo = new ModeloGridTable(listaCamposUtilizados);
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
        if (rs.next()) {
            do {
                Object[] o = new Object[listaCamposUtilizados.length];
                for (int i3 = 0; i3 < listaCamposUtilizados.length; ++i3) {
                    if (RelatorioUtil.possuiColuna(rs, listaCamposUtilizados[i3]) <= 0) continue;
                    o[i3] = (this.tipoRelatorio == 3 || this.tipoRelatorio == 4) && listaCamposUtilizados[i3].equalsIgnoreCase("quantidadeRequisicoes" + fimMes) ? rs.getObject("quantidadeRequisicoes" + fimMes) : rs.getObject(listaCamposUtilizados[i3]);
                }
                modelo.addLine(o);
            } while (rs.next());
            String codigoFilial = Variaveis.filialPadrao;
            if (this.getSelecionadosFiltro("filtroFilial", 0) != null && this.getSelecionadosFiltro("filtroFilial", 0).length == 1) {
                codigoFilial = this.getSelecionadosFiltro("filtroFilial", 0)[0];
            }
            Registro regFilial = RelatorioUtil.pegaDadosFilial(st, codigoFilial);
            RelatorioUtil.preencheDadosFilial(regFilial, modelo);
        }
        return modelo;
    }

    @Override
    public void imprimirPressionado() {
        HashMap<String, String> mapaTodosCampos = this.getCamposSelect();
        HashMap<String, String> mapaCamposObrigatorios = this.getCamposObrigatorios();
        if (this.getFiltroTexto("filtroMes") == null || this.getFiltroTexto("filtroMes").trim().isEmpty()) {
            this.requisitaFocoComponente("filtroMes");
            Funcoes.mensagem(this, "O m\u00eas inicial deve ser informado.", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        if (Funcoes.isNumeric(this.getFiltroTexto("filtroMes")) && (Integer.parseInt(this.getFiltroTexto("filtroMes")) < 1 || Integer.parseInt(this.getFiltroTexto("filtroMes")) > 12)) {
            this.requisitaFocoComponente("filtroMes");
            Funcoes.mensagem(this, "O m\u00eas inicial precisa ter um valor entre 1 e 12.", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        if (this.getFiltroTexto("filtroAno") == null || this.getFiltroTexto("filtroAno").trim().isEmpty()) {
            this.requisitaFocoComponente("filtroAno");
            Funcoes.mensagem(this, "O ano deve ser informado.", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        String ano = this.getFiltroNumero("filtroAno");
        SplashMensagem splashMensagem = SplashMensagem.getInstancia(this);
        try {
            StringBuilder buf = new StringBuilder();
            String layoutRelatorio = this.getLayoutRelatorio(st);
            if (Funcoes.textoVazio(layoutRelatorio)) {
                this.habilitaBotaoImprimir(true);
                Conexao.fecharStatement(st);
                Conexao.fecharStatement(st2);
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
            String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
            String[] convenio = this.getSelecionadosFiltro("filtroConvenio", 0);
            String[] setor = this.getSelecionadosFiltro("filtroSetor", 0);
            String[] estacoes = this.getSelecionadosFiltro("filtroEstacao", 0);
            String[] coletas = this.getSelecionadosFiltro("filtroColeta", 0);
            String[] exames = this.getSelecionadosFiltro("filtroExame", 0);
            String[] materiais = this.getSelecionadosFiltro("filtroMaterial", 0);
            String[] grupos = this.getSelecionadosFiltro("filtroGrupo", 0);
            String[] conselho = this.getSelecionadosFiltroAvancado("filtroMedico", 0);
            String[] crm = this.getSelecionadosFiltroAvancado("filtroMedico", 1);
            String[] uf = this.getSelecionadosFiltroAvancado("filtroMedico", 2);
            HashMap<String, String> camposUtilizados = Relatorio.getCamposBancoLayout(layoutRelatorio, mapaTodosCampos, mapaCamposObrigatorios);
            String[] listaCamposUtilizados = new String[camposUtilizados.size()];
            Iterator<String> it = camposUtilizados.keySet().iterator();
            int i = 0;
            while (it.hasNext()) {
                listaCamposUtilizados[i] = it.next().toString();
                ++i;
            }
            String campoChave = "codigoexame";
            String descricaoCampoChave = "descricaoexame";
            if (this.tipoRelatorio == 3 || this.tipoRelatorio == 4) {
                campoChave = "codigoconvenio";
                descricaoCampoChave = "fantasiaconvenio";
            }
            splashMensagem.mostrar("");
            ModeloGridTable modelo = new ModeloGridTable(listaCamposUtilizados);
            Integer contaAno = Integer.parseInt(ano);
            Integer contaMes = Integer.parseInt(this.getFiltroTexto("filtroMes"));
            for (int mes = 1; mes <= 12; ++mes) {
                splashMensagem.setText("Processando m\u00eas de " + ConstantesGerais.MESES_ANO[contaMes - 1] + "/" + String.valueOf(contaAno));
                ModeloGridTable g = this.getModeloMes(st, st2, layoutRelatorio, mapaTodosCampos, mapaCamposObrigatorios, contaAno, contaMes, mes, filiais, convenio, setor, estacoes, coletas, exames, materiais, grupos, crm, uf, conselho);
                Integer n = contaMes;
                Integer n2 = contaMes = Integer.valueOf(contaMes + 1);
                if (contaMes > 12) {
                    contaMes = 1;
                    n = contaAno;
                    n2 = contaAno = Integer.valueOf(contaAno + 1);
                }
                if (g.getRowCount() <= 0) continue;
                for (int i2 = 0; i2 < g.getRowCount(); ++i2) {
                    int posLinha = i2;
                    Object[] linha = this.preencheComZeros(new Object[listaCamposUtilizados.length], listaCamposUtilizados, modelo);
                    if (mes == 1) {
                        modelo.addLine(linha);
                        posLinha = modelo.getRowCount() - 1;
                    }
                    for (int col = 0; col < g.getColumnCount(); ++col) {
                        int posColunaG = modelo.findColumn(g.getColumnName(col));
                        if (posColunaG < 0) continue;
                        if (mes == 1) {
                            modelo.setValueAt(g.getValueAt(i2, col), posLinha, posColunaG);
                            continue;
                        }
                        int colunaCampoChave = g.findColumn(campoChave);
                        if (colunaCampoChave < 0) continue;
                        String codigoCampoChave = String.valueOf(g.getValueAt(i2, colunaCampoChave));
                        colunaCampoChave = modelo.findColumn(campoChave);
                        int posCampoChave = modelo.localizar(colunaCampoChave, codigoCampoChave);
                        if (posCampoChave > -1) {
                            posLinha = posCampoChave;
                            modelo.setValueAt(g.getValueAt(i2, col), posLinha, posColunaG);
                            continue;
                        }
                        Object[] novaLinhaExame = this.preencheComZeros(new Object[listaCamposUtilizados.length], listaCamposUtilizados, modelo);
                        novaLinhaExame[colunaCampoChave] = codigoCampoChave;
                        modelo.addLine(novaLinhaExame);
                        posLinha = modelo.getRowCount() - 1;
                        if (g.getColumnName(col).equalsIgnoreCase(campoChave)) continue;
                        modelo.setValueAt(g.getValueAt(i2, col), posLinha, posColunaG);
                    }
                }
            }
            if (modelo.getRowCount() > 0) {
                String campoOrdenacao = "codigoexame";
                campoOrdenacao = this.getFiltroCombo("ordemRelatorio").equals(this.ordem[0]) ? (this.tipoRelatorio == 1 || this.tipoRelatorio == 2 ? "codigoexame" : "codigoconvenio") : (this.tipoRelatorio == 4 || this.tipoRelatorio == 3 ? "fantasiaconvenio" : "descricaoexame");
                int posColuna = modelo.findColumn(campoOrdenacao);
                if (posColuna > -1) {
                    modelo.ordenarColuna(posColuna, 1, false);
                }
                if (!Funcoes.textoVazio(layoutRelatorio)) {
                    int i3;
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioRealizadosAnual.this.panelCentro.removeAll();
                            RelatorioRealizadosAnual.this.panelCentro.repaint();
                            RelatorioRealizadosAnual.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                    var.put("filtroMes", this.getFiltroTexto("filtroMes"));
                    var.put("filtroAno", this.getFiltroTexto("filtroAno"));
                    var.put("filtroDesmembrarMaterial", this.getFiltroCheck("filtroDesmembrarMaterial"));
                    contaMes = Integer.parseInt(this.getFiltroTexto("filtroMes"));
                    contaAno = Integer.parseInt(ano);
                    for (i3 = 1; i3 <= 12; ++i3) {
                        var.put("descricaoMes" + String.valueOf(i3), ConstantesGerais.MESES_ANO[contaMes - 1] + "/" + String.valueOf(contaAno));
                        Integer n = contaMes;
                        Integer n3 = contaMes = Integer.valueOf(contaMes + 1);
                        if (contaMes <= 12) continue;
                        contaMes = 1;
                        n = contaAno;
                        n3 = contaAno = Integer.valueOf(contaAno + 1);
                    }
                    buf.delete(0, buf.length());
                    if (filiais != null) {
                        for (i3 = 0; i3 < filiais.length; ++i3) {
                            buf.append(filiais[i3]);
                            if (i3 >= filiais.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroFilial", buf.toString());
                    buf.delete(0, buf.length());
                    if (convenio != null) {
                        for (i3 = 0; i3 < convenio.length; ++i3) {
                            buf.append(convenio[i3]);
                            if (i3 >= convenio.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroConvenio", buf.toString());
                    buf.delete(0, buf.length());
                    if (estacoes != null) {
                        for (i3 = 0; i3 < estacoes.length; ++i3) {
                            buf.append(estacoes[i3]);
                            if (i3 >= estacoes.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroEstacao", buf.toString());
                    buf.delete(0, buf.length());
                    if (conselho != null && crm != null && uf != null) {
                        for (i3 = 0; i3 < crm.length; ++i3) {
                            buf.append(conselho[i3]).append(": ");
                            buf.append(crm[i3]);
                            buf.append("(");
                            buf.append(uf[i3]);
                            buf.append(")");
                            if (i3 >= crm.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroMedico", buf.toString());
                    buf.delete(0, buf.length());
                    if (coletas != null) {
                        for (i3 = 0; i3 < coletas.length; ++i3) {
                            buf.append(coletas[i3]);
                            if (i3 >= coletas.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroColeta", buf.toString());
                    buf.delete(0, buf.length());
                    if (exames != null) {
                        for (i3 = 0; i3 < exames.length; ++i3) {
                            buf.append(exames[i3]);
                            if (i3 >= exames.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroExame", buf.toString());
                    buf.delete(0, buf.length());
                    if (setor != null) {
                        for (i3 = 0; i3 < setor.length; ++i3) {
                            buf.append(setor[i3]);
                            if (i3 >= setor.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroSetor", buf.toString());
                    buf.delete(0, buf.length());
                    if (materiais != null) {
                        for (i3 = 0; i3 < materiais.length; ++i3) {
                            buf.append(materiais[i3]);
                            if (i3 >= materiais.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroMaterial", buf.toString());
                    buf.delete(0, buf.length());
                    if (grupos != null) {
                        for (i3 = 0; i3 < grupos.length; ++i3) {
                            buf.append(grupos[i3]);
                            if (i3 >= grupos.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroGrupo", buf.toString());
                    gerador.executar(layoutRelatorio, (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        if (splashMensagem != null) {
            splashMensagem.apagar();
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private Object[] preencheComZeros(Object[] array, String[] camposUtilizados, ModeloGridTable modelo) {
        Object[] a = array;
        if (array != null && camposUtilizados != null && modelo != null) {
            for (String campo : camposUtilizados) {
                int pos;
                if (!ArraysUtil.contem(camposParaValores, campo, true) || (pos = modelo.findColumn(campo)) <= -1) continue;
                a[pos] = 0;
            }
        }
        return a;
    }

    private HashMap<String, String> getCamposObrigatorios() {
        HashMap<String, String> camposObrigatorios = new HashMap<String, String>();
        if (!camposObrigatorios.isEmpty()) {
            return camposObrigatorios;
        }
        return null;
    }

    private String getSqlExamePai(String string) {
        String retorno = string;
        retorno = retorno.replaceAll("interfaceexamerequisicaodesm", "interfaceexamerequisicao");
        retorno = retorno.replaceAll("intexr.erd_situacao", "intexr.ier_situacao");
        retorno = retorno.replaceAll("intexr.exa_kodigo", "intexr.exa_codigo");
        retorno = retorno.replaceAll("and a.fil_codigo > 0", "and intexr.req_codigo not in(select req_codigo from interfaceexamerequisicaodesm where intexr.exa_codigo = exa_codigo)");
        return retorno;
    }

    public static long getModuloAcesso(int tipo) {
        if (tipo == 3) {
            return Long.parseLong("0880401100");
        }
        return Long.parseLong("0880401000");
    }

    public static long getModuloConfigurar(int tipo) {
        if (tipo == 3) {
            return Long.parseLong("0880401101");
        }
        return Long.parseLong("0880401001");
    }

    private String getCampoData() {
        if (this.getFiltroCheck("filtroDataResultado")) {
            return "a.exr_datadigita";
        }
        return "b.req_data";
    }

    static {
        camposParaValores = new String[]{"valorExameMes1", "valorTotalExameMes1", "valorMaterialMes1", "quantidadeExamesMes1", "valorCHOriginalMes1", "valorCHMes1", "valorLiquidoTotalExameMes1", "valorCustoSimplesExameAgrupadoMes1", "valorCustoSimplesExameMes1", "quantidadeRequisicoesMes1", "valorExameMes2", "valorTotalExameMes2", "valorMaterialMes2", "quantidadeExamesMes2", "valorCHOriginalMes2", "valorCHMes2", "valorLiquidoTotalExameMes2", "valorCustoSimplesExameAgrupadoMes2", "valorCustoSimplesExameMes2", "quantidadeRequisicoesMes2", "valorExameMes3", "valorTotalExameMes3", "valorMaterialMes3", "quantidadeExamesMes3", "valorCHOriginalMes3", "valorCHMes3", "valorLiquidoTotalExameMes3", "valorCustoSimplesExameAgrupadoMes3", "valorCustoSimplesExameMes3", "quantidadeRequisicoesMes3", "valorExameMes4", "valorTotalExameMes4", "valorMaterialMes4", "quantidadeExamesMes4", "valorCHOriginalMes4", "valorCHMes4", "valorLiquidoTotalExameMes4", "valorCustoSimplesExameAgrupadoMes4", "valorCustoSimplesExameMes4", "quantidadeRequisicoesMes4", "valorExameMes5", "valorTotalExameMes5", "valorMaterialMes5", "quantidadeExamesMes5", "valorCHOriginalMes5", "valorCHMes5", "valorLiquidoTotalExameMes5", "valorCustoSimplesExameAgrupadoMes5", "valorCustoSimplesExameMes5", "quantidadeRequisicoesMes5", "valorExameMes6", "valorTotalExameMes6", "valorMaterialMes6", "quantidadeExamesMes6", "valorCHOriginalMes6", "valorCHMes6", "valorLiquidoTotalExameMes6", "valorCustoSimplesExameAgrupadoMes6", "valorCustoSimplesExameMes6", "quantidadeRequisicoesMes6", "valorExameMes7", "valorTotalExameMes7", "valorMaterialMes7", "quantidadeExamesMes7", "valorCHOriginalMes7", "valorCHMes7", "valorLiquidoTotalExameMes7", "valorCustoSimplesExameAgrupadoMes7", "valorCustoSimplesExameMes7", "quantidadeRequisicoesMes7", "valorExameMes8", "valorTotalExameMes8", "valorMaterialMes8", "quantidadeExamesMes8", "valorCHOriginalMes8", "valorCHMes8", "valorLiquidoTotalExameMes8", "valorCustoSimplesExameAgrupadoMes8", "valorCustoSimplesExameMes8", "quantidadeRequisicoesMes8", "valorExameMes9", "valorTotalExameMes9", "valorMaterialMes9", "quantidadeExamesMes9", "valorCHOriginalMes9", "valorCHMes9", "valorLiquidoTotalExameMes9", "valorCustoSimplesExameAgrupadoMes9", "valorCustoSimplesExameMes9", "quantidadeRequisicoesMes9", "valorExameMes10", "valorTotalExameMes10", "valorMaterialMes10", "quantidadeExamesMes10", "valorCHOriginalMes10", "valorCHMes10", "valorLiquidoTotalExameMes10", "valorCustoSimplesExameAgrupadoMes10", "valorCustoSimplesExameMes10", "quantidadeRequisicoesMes10", "valorExameMes11", "valorTotalExameMes11", "valorMaterialMes11", "quantidadeExamesMes11", "valorCHOriginalMes11", "valorCHMes11", "valorLiquidoTotalExameMes11", "valorCustoSimplesExameAgrupadoMes11", "valorCustoSimplesExameMes11", "quantidadeRequisicoesMes11", "valorExameMes12", "valorTotalExameMes12", "valorMaterialMes12", "quantidadeExamesMes12", "valorCHOriginalMes12", "valorCHMes12", "valorLiquidoTotalExameMes12", "valorCustoSimplesExameAgrupadoMes12", "valorCustoSimplesExameMes12", "quantidadeRequisicoesMes12", "valorCustoSimplesExameAtualMes1", "valorCustoSimplesExameAtualMes2", "valorCustoSimplesExameAtualMes3", "valorCustoSimplesExameAtualMes4", "valorCustoSimplesExameAtualMes5", "valorCustoSimplesExameAtualMes6", "valorCustoSimplesExameAtualMes7", "valorCustoSimplesExameAtualMes8", "valorCustoSimplesExameAtualMes9", "valorCustoSimplesExameAtualMes10", "valorCustoSimplesExameAtualMes11", "valorCustoSimplesExameAtualMes12"};
    }
}

