/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.gerencial;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.laboratorio.relatorios.gerencial.ValorLabExterno;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioComparativoProducao
extends FrmRelPadrao {
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_EXAME = "filtroExame";
    private final String FILTRO_SETOR = "filtroSetor";
    private final String FILTRO_LAB_EXTERNO = "filtroLabApoio";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_HORA_INICIAL = "filtroHoraInicial";
    private final String FILTRO_HORA_FINAL = "filtroHoraFinal";
    private final String FILTRO_ORDEM = "filtroOrdem";
    private final String FILTRO_INTERVALO_HORA = "filtroIntervaloHora";
    private final String FILTRO_VALOR_SIMPLES = "filtroValorSimples";
    private final String FILTRO_VALOR_LAB_EXTERNO = "filtroValorLabExterno";
    private final String FILTRO_AGRUPAR_FILIAIS = "filtroAgruparFiliais";
    private final int ORDEM_CODIGO = 0;
    private final int ORDEM_V_LABEXTERNO = 1;
    private final int ORDEM_V_CONVENIO = 2;
    private final int ORDEM_QTDE_ENVIADOS = 3;
    private final int ORDEM_QTDE_SOLICITADOS_ASC = 4;
    private final int ORDEM_QTDE_SOLICITADOS_DESC = 5;
    public static final String PARAMETROS_RELATORIOCOMPARATIVOPRODUCAO = "RelatorioComparativoProducao.ultimoFiltro";
    private final String[] opcoesOrdem = new String[]{"C\u00f3digo", "V. LabExterno", "V. Conv\u00eanio", "Qtde. enviados", "Menos Solicitados", "Mais Solicitados"};
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio", "cnpjConvenio", "codigoLaboratorioExterno", "descricaoLaboratorioExterno", "codigoExame", "descricaoExame", "abreviaturaMaterialColetado", "codigoMaterialColetado", "descricaoMaterialColetado", "cbhpmExame", "ambExame", "totalExamesSolicitados", "custoSimplesExame", "valorTotalExameRequisicao", "valorLiquidoTotalExameRequisicao", "valorExameMaterialLaboratorioExterno", "totalExamesLaboratorioApoio", "valorTotalEnviadoLaboratorioExterno", "valorCustoLaboratorioExterno"});

    public RelatorioComparativoProducao() {
        this.montaBarraDescricao("Relat\u00f3rio comparativo de produ\u00e7\u00e3o", "Diferen\u00e7as de pre\u00e7os entre os exames solicitados", "relatorios/rel_ger_analitico_compara_producao.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroSetor", "Setor", "setores", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroExame", "Exame", "exames", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroLabApoio", "Lab. Apoio", "labexterno", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"lae_codigo", "lae_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroHora("filtroHoraInicial", "Hora inicial:");
        this.adicionaFiltroHora("filtroHoraFinal", "Hora final:");
        this.adicionaFiltroCombo("filtroOrdem", "Ordem:", this.opcoesOrdem, 0);
        this.adicionaFiltroCheck("filtroIntervaloHora", "Intervalo de hora", false);
        this.adicionaFiltroCheck("filtroValorSimples", "Valor atual do Custo Simples", false);
        this.adicionaFiltroCheck("filtroValorLabExterno", "Valor atual do Lab. Externo", false);
        this.adicionaFiltroCheck("filtroAgruparFiliais", "Agrupar filiais", false);
        this.carregarParametrosUsuarios();
        this.setCamposConfigurador(campos);
        this.setModuloAcesso(RelatorioComparativoProducao.getModuloAcesso());
        this.setModuloConfigurar(RelatorioComparativoProducao.getModuloConfigurar());
    }

    private void carregarParametrosUsuarios() {
        String parametros = ParametrosUsuarios.getValor(PARAMETROS_RELATORIOCOMPARATIVOPRODUCAO);
        if (!Funcoes.textoVazio(parametros)) {
            String tmp = StringUtil.getValor(parametros, "filial");
            if (!Funcoes.textoVazio(tmp)) {
                this.setSelecionadosFiltro("filtroFilial", 0, tmp.split(","));
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "convenio"))) {
                this.setSelecionadosFiltro("filtroConvenio", 0, tmp.split(","));
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "setor"))) {
                this.setSelecionadosFiltro("filtroSetor", 0, tmp.trim().split(","));
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "exame"))) {
                this.setSelecionadosFiltro("filtroExame", 0, tmp.split(","));
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "labexterno"))) {
                this.setSelecionadosFiltro("filtroLabApoio", 0, tmp.split(","));
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "datainicial"))) {
                this.setFiltroData("filtroDataInicial", tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "datafinal"))) {
                this.setFiltroData("filtroDataFinal", tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "horainicial"))) {
                this.setFiltroData("filtroHoraInicial", tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "horafinal"))) {
                this.setFiltroData("filtroHoraFinal", tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "intervalohora"))) {
                this.setFiltroCheck("filtroIntervaloHora", tmp.equalsIgnoreCase("true"));
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "valoracustolabexterno"))) {
                this.setFiltroCheck("filtroValorLabExterno", tmp.equalsIgnoreCase("true"));
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "valoratualcustosimples"))) {
                this.setFiltroCheck("filtroValorSimples", tmp.equalsIgnoreCase("true"));
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "ordem"))) {
                this.setFiltroCombo("filtroOrdem", tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "agruparfiliais"))) {
                this.setFiltroCheck("filtroAgruparFiliais", tmp.equalsIgnoreCase("true"));
            }
        }
    }

    private int contaFiltroLabExterno() {
        String[] f = this.getSelecionadosFiltro("filtroLabApoio", 0);
        return !Funcoes.objectIsNull(f) ? f.length : 0;
    }

    private String montaChaveHash(String codigoExame, int codigoMaterial) {
        return codigoExame.trim() + "|" + String.valueOf(codigoMaterial);
    }

    @Override
    public void imprimirPressionado() {
        if (this.getFiltroCheck("filtroIntervaloHora")) {
            if (this.getFiltroData("filtroDataInicial").isEmpty()) {
                Funcoes.mensagem(this, "O filtro de DATA INICIAL deve ser preenchido.", 2);
                this.habilitaBotaoImprimir(true);
                this.requisitaFocoComponente("filtroDataInicial");
                return;
            }
            if (this.getFiltroHora("filtroDataFinal").isEmpty()) {
                Funcoes.mensagem(this, "O filtro de DATA FINAL deve ser preenchido.", 2);
                this.habilitaBotaoImprimir(true);
                this.requisitaFocoComponente("filtroDataFinal");
                return;
            }
            if (this.getFiltroHora("filtroHoraInicial").isEmpty()) {
                Funcoes.mensagem(this, "O filtro de HORA INICIAL deve ser preenchido.", 2);
                this.habilitaBotaoImprimir(true);
                this.requisitaFocoComponente("filtroHoraInicial");
                return;
            }
            if (this.getFiltroHora("filtroHoraFinal").isEmpty()) {
                Funcoes.mensagem(this, "O filtro de HORA FINAL deve ser preenchido.", 2);
                this.habilitaBotaoImprimir(true);
                this.requisitaFocoComponente("filtroHoraFinal");
                return;
            }
        }
        if (this.contaFiltroLabExterno() > 1) {
            Funcoes.mensagem(this, "Apenas um laborat\u00f3rio externo pode ser selecionado", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        if (!ArraysUtil.contem(this.verificaCamposNoModelo(), true)) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        try {
            HashMap<String, ValorLabExterno> valores = new HashMap<String, ValorLabExterno>();
            ResultSet rsContar = Conexao.executeQuery(st, this.getSelect(true));
            while (rsContar.next()) {
                ValorLabExterno v = new ValorLabExterno();
                v.totalExamesLaboratorioApoio = rsContar.findColumn("totalExamesLaboratorioApoio") > 0 ? rsContar.getInt("totalExamesLaboratorioApoio") : 0;
                v.valorExameMaterialLaboratorioExterno = rsContar.findColumn("valorExameMaterialLaboratorioExterno") > 0 ? rsContar.getBigDecimal("valorExameMaterialLaboratorioExterno") : BigDecimal.ZERO;
                v.valorTotalEnviadoLaboratorioExterno = rsContar.findColumn("valorTotalEnviadoLaboratorioExterno") > 0 ? rsContar.getBigDecimal("valorTotalEnviadoLaboratorioExterno") : BigDecimal.ZERO;
                valores.put(this.montaChaveHash(rsContar.getString("codigoExame"), rsContar.getInt("codigoMaterialColetado")), v);
            }
            rsContar.close();
            String select = this.getSelect(false);
            ResultSet rs = Conexao.executeQuery(st, select);
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(campos);
                String codigoColetador = "";
                boolean qtdeAux = false;
                do {
                    Object[] o = new Object[campos.length];
                    ValorLabExterno valorExame = (ValorLabExterno)valores.get(this.montaChaveHash(rs.getString("codigoExame"), rs.getInt("codigoMaterialColetado")));
                    if (null == valorExame) {
                        valorExame = new ValorLabExterno();
                    }
                    for (int i = 0; i < campos.length; ++i) {
                        if (campos[i].equalsIgnoreCase("totalExamesLaboratorioApoio")) {
                            o[i] = valorExame.totalExamesLaboratorioApoio;
                            continue;
                        }
                        if (campos[i].equalsIgnoreCase("valorExameMaterialLaboratorioExterno")) {
                            o[i] = valorExame.valorExameMaterialLaboratorioExterno;
                            continue;
                        }
                        if (campos[i].equalsIgnoreCase("valorTotalEnviadoLaboratorioExterno")) {
                            o[i] = valorExame.valorTotalEnviadoLaboratorioExterno;
                            continue;
                        }
                        if (campos[i].equalsIgnoreCase("valorCustoLaboratorioExterno")) {
                            o[i] = this.getCustoLabApoio(rs.getString("codigoExame"), rs.getString("codigoMaterialColetado"));
                            continue;
                        }
                        if (!select.contains(campos[i])) continue;
                        o[i] = rs.getObject(campos[i]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                StringBuilder buffer = new StringBuilder("select rel_xml from relatoriosistema where rel_codigo = ");
                buffer.append(RelatorioComparativoProducao.getModuloAcesso());
                rs = Conexao.executeQuery(st, buffer.toString());
                if (rs.next()) {
                    int i;
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioComparativoProducao.this.panelCentro.removeAll();
                            RelatorioComparativoProducao.this.panelCentro.repaint();
                            RelatorioComparativoProducao.this.habilitaBotaoImprimir(true);
                        }
                    });
                    StringBuilder p = new StringBuilder();
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("filtroOrdem", this.getFiltroCombo("filtroOrdem"));
                    var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                    var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                    var.put("filtroHoraInicial", this.getFiltroHora("filtroHoraInicial"));
                    var.put("filtroHoraFinal", this.getFiltroHora("filtroHoraFinal"));
                    p.append("<datainicial>").append(this.getFiltroData("filtroDataInicial")).append("</datainicial>");
                    p.append("<datafinal>").append(this.getFiltroData("filtroDataFinal")).append("</datafinal>");
                    p.append("<horainicial>").append(this.getFiltroHora("filtroHoraInicial")).append("</horainicial>");
                    p.append("<horafinal>").append(this.getFiltroHora("filtroHoraFinal")).append("</horafinal>");
                    p.append("<horafinal>").append(this.getFiltroHora("filtroHoraFinal")).append("</horafinal>");
                    p.append("<valoratualcustosimples>").append(String.valueOf(this.getFiltroCheck("filtroValorSimples"))).append("</valoratualcustosimples>");
                    p.append("<valoracustolabexterno>").append(String.valueOf(this.getFiltroCheck("filtroValorLabExterno"))).append("</valoracustolabexterno>");
                    p.append("<intervalohora>").append(String.valueOf(this.getFiltroCheck("filtroIntervaloHora"))).append("</intervalohora>");
                    p.append("<ordem>").append(this.getFiltroCombo("filtroOrdem")).append("</ordem>");
                    p.append("<agruparfiliais>").append(String.valueOf(this.getFiltroCheck("filtroAgruparFiliais"))).append("</agruparfiliais>");
                    StringBuilder buf = new StringBuilder();
                    if (!Funcoes.objectIsNull(this.getSelecionadosFiltro("filtroFilial", 0))) {
                        p.append("<filial>");
                        for (i = 0; i < this.getSelecionadosFiltro("filtroFilial", 0).length; ++i) {
                            buf.append(this.getSelecionadosFiltro("filtroFilial", 0)[i]);
                            if (i >= this.getSelecionadosFiltro("filtroFilial", 0).length - 1) continue;
                            buf.append(",");
                        }
                        p.append(buf.toString());
                        p.append("</filial>");
                    }
                    var.put("filtroFilial", buf.toString());
                    buf.delete(0, buf.length());
                    if (!Funcoes.objectIsNull(this.getSelecionadosFiltro("filtroConvenio", 0))) {
                        p.append("<convenio>");
                        for (i = 0; i < this.getSelecionadosFiltro("filtroConvenio", 0).length; ++i) {
                            buf.append(this.getSelecionadosFiltro("filtroConvenio", 0)[i]);
                            if (i >= this.getSelecionadosFiltro("filtroConvenio", 0).length - 1) continue;
                            buf.append(",");
                        }
                        p.append(buf.toString());
                        p.append("</convenio>");
                    }
                    var.put("filtroConvenio", buf.toString());
                    buf.delete(0, buf.length());
                    if (!Funcoes.objectIsNull(this.getSelecionadosFiltro("filtroExame", 0))) {
                        p.append("<exame>");
                        for (i = 0; i < this.getSelecionadosFiltro("filtroExame", 0).length; ++i) {
                            buf.append(this.getSelecionadosFiltro("filtroExame", 0)[i]);
                            if (i >= this.getSelecionadosFiltro("filtroExame", 0).length - 1) continue;
                            buf.append(",");
                        }
                        p.append(buf.toString());
                        p.append("</exame>");
                    }
                    var.put("filtroExame", buf.toString());
                    buf.delete(0, buf.length());
                    if (!Funcoes.objectIsNull(this.getSelecionadosFiltro("filtroSetor", 0))) {
                        p.append("<setor>");
                        for (i = 0; i < this.getSelecionadosFiltro("filtroSetor", 0).length; ++i) {
                            buf.append(this.getSelecionadosFiltro("filtroSetor", 0)[i]);
                            if (i >= this.getSelecionadosFiltro("filtroSetor", 0).length - 1) continue;
                            buf.append(",");
                        }
                        p.append(buf.toString());
                        p.append("</setor>");
                    }
                    var.put("filtroSetor", buf.toString());
                    buf.delete(0, buf.length());
                    if (!Funcoes.objectIsNull(this.getSelecionadosFiltro("filtroLabApoio", 0))) {
                        p.append("<labexterno>");
                        for (i = 0; i < this.getSelecionadosFiltro("filtroLabApoio", 0).length; ++i) {
                            buf.append(this.getSelecionadosFiltro("filtroLabApoio", 0)[i]);
                            if (i >= this.getSelecionadosFiltro("filtroLabApoio", 0).length - 1) continue;
                            buf.append(",");
                        }
                        p.append(buf.toString());
                        p.append("</labexterno>");
                    }
                    var.put("filtroLabApoio", buf.toString());
                    ParametrosUsuarios.setValor(PARAMETROS_RELATORIOCOMPARATIVOPRODUCAO, p.toString());
                    ParametrosUsuarios.salvarParametros(true);
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RelatorioAcumuladoConvenios");
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private String getSelect(boolean contarEnviados) {
        int i;
        String[] setor;
        String[] exame;
        String[] filiais;
        Boolean[] camposUtilizados = this.verificaCamposNoModelo();
        StringBuilder buffer = new StringBuilder();
        StringBuilder bufferGroupBy = new StringBuilder();
        String[] labExterno = this.getSelecionadosFiltro("filtroLabApoio", 0);
        buffer.append("select ");
        if (camposUtilizados[ArraysUtil.indice((Object[])campos, "codigoConvenio")].booleanValue()) {
            buffer.append("con.con_codigo as codigoConvenio, ");
            bufferGroupBy.append("codigoConvenio, ");
        }
        if (camposUtilizados[ArraysUtil.indice((Object[])campos, "razaoSocialConvenio")].booleanValue()) {
            buffer.append("con.con_razao as razaoSocialConvenio, ");
            bufferGroupBy.append("razaoSocialConvenio, ");
        }
        if (camposUtilizados[ArraysUtil.indice((Object[])campos, "fantasiaConvenio")].booleanValue()) {
            buffer.append("con.con_fantasia as fantasiaConvenio, ");
            bufferGroupBy.append("fantasiaConvenio, ");
        }
        if (camposUtilizados[ArraysUtil.indice((Object[])campos, "cnpjConvenio")].booleanValue()) {
            buffer.append("con.con_cnpjcpf as cnpjConvenio, ");
            bufferGroupBy.append("cnpjConvenio, ");
        }
        if (camposUtilizados[ArraysUtil.indice((Object[])campos, "codigoLaboratorioExterno")].booleanValue()) {
            buffer.append("lae.lae_codigo AS codigoLaboratorioExterno, ");
            bufferGroupBy.append("codigoLaboratorioExterno, ");
        }
        if (camposUtilizados[ArraysUtil.indice((Object[])campos, "descricaoLaboratorioExterno")].booleanValue()) {
            buffer.append("lae.lae_descricao AS descricaoLaboratorioExterno, ");
            bufferGroupBy.append("descricaoLaboratorioExterno, ");
        }
        buffer.append("exa.exa_codigo as codigoExame, ");
        bufferGroupBy.append("codigoExame, ");
        if (camposUtilizados[ArraysUtil.indice((Object[])campos, "descricaoExame")].booleanValue()) {
            buffer.append("exa.exa_descricao as descricaoExame, ");
            bufferGroupBy.append("descricaoExame, ");
        }
        if (camposUtilizados[ArraysUtil.indice((Object[])campos, "abreviaturaMaterialColetado")].booleanValue()) {
            buffer.append("mco.mco_abreviatura as abreviaturaMaterialColetado, ");
            bufferGroupBy.append("abreviaturaMaterialColetado, ");
        }
        buffer.append("mco.mco_codigo as codigoMaterialColetado, ");
        bufferGroupBy.append("codigoMaterialColetado, ");
        if (camposUtilizados[ArraysUtil.indice((Object[])campos, "descricaoMaterialColetado")].booleanValue()) {
            buffer.append("mco.mco_descricao as descricaoMaterialColetado, ");
            bufferGroupBy.append("descricaoMaterialColetado, ");
        }
        if (camposUtilizados[ArraysUtil.indice((Object[])campos, "cbhpmExame")].booleanValue()) {
            buffer.append("emc.emc_codigocbhpm as cbhpmExame, ");
        }
        if (camposUtilizados[ArraysUtil.indice((Object[])campos, "ambExame")].booleanValue()) {
            buffer.append("emc.emc_codigoamb as ambExame, ");
            bufferGroupBy.append("ambExame, ");
        }
        if (camposUtilizados[ArraysUtil.indice((Object[])campos, "totalExamesSolicitados")].booleanValue()) {
            buffer.append("count(exr.exa_codigo) as totalExamesSolicitados, ");
        }
        if (camposUtilizados[ArraysUtil.indice((Object[])campos, "custoSimplesExame")].booleanValue()) {
            if (this.getFiltroCheck("filtroValorSimples")) {
                buffer.append("SUM(case when emc.emc_custosimples is null then 0 else emc.emc_custosimples end)/count (*) as custoSimplesExame, ");
            } else {
                buffer.append("SUM(case when exr.exr_custosimples is null then 0 else exr.exr_custosimples end)/count (*) as custoSimplesExame, ");
            }
        }
        if (camposUtilizados[ArraysUtil.indice((Object[])campos, "valorTotalExameRequisicao")].booleanValue()) {
            buffer.append("SUM(calculaprecototalexamerequisicao(a.fil_codigo, a.con_codigo, a.req_codigo, exr.exa_codigo, exr.mco_codigo, true, false, true, exr.exr_vlrchexame, exr.exr_vlrch, exr.exr_valorporte, exr.exr_valorcusto, exr.exr_valoruco, exr.exr_vlrbalcaoconvenio, exr.exr_datafatura IS NOT NULL OR exr.usr_codfatura IS NOT NULL, exr.exr_vlrmaterial, exr.exr_vlrbalcaoconvenio, con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", exr.met_codigo").append("))/count(*) as valorTotalExameRequisicao, ");
        }
        if (camposUtilizados[ArraysUtil.indice((Object[])campos, "valorLiquidoTotalExameRequisicao")].booleanValue()) {
            buffer.append("sum(calculaprecototalexamerequisicao(a.fil_codigo, a.con_codigo, a.req_codigo, exr.exa_codigo, exr.mco_codigo, true, false, true, exr.exr_vlrchexame, exr.exr_vlrch, exr.exr_valorporte, exr.exr_valorcusto, exr.exr_valoruco, exr.exr_vlrbalcaoconvenio, exr.exr_datafatura IS NOT NULL OR exr.usr_codfatura IS NOT NULL, exr.exr_vlrmaterial, exr.exr_vlrbalcaoconvenio, con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", exr.met_codigo) * ((100 - (a.req_desconto - a.req_acrescimo))/100))/count(*) as valorLiquidoTotalExameRequisicao, ");
        }
        if (contarEnviados) {
            buffer.append("SUM(case when (leer.ler_custo is null or leer.ler_datahoraestorno is not null) then 0 else leer.ler_custo end) / case when count(emcle.exa_codigo) = 0 then 1 else count(emcle.exa_codigo) end as valorExameMaterialLaboratorioExterno, ");
            if (camposUtilizados[ArraysUtil.indice((Object[])campos, "valorTotalEnviadoLaboratorioExterno")].booleanValue()) {
                buffer.append("COALESCE(SUM(case when (leer.ler_custo is null or leer.ler_datahoraestorno is not null) then 0 else leer.ler_custo end),0) as valorTotalEnviadoLaboratorioExterno,");
            }
            if (camposUtilizados[ArraysUtil.indice((Object[])campos, "totalExamesLaboratorioApoio")].booleanValue()) {
                buffer.append("sum(case when (ler.usr_codestorno is null and leer.ler_datahoraestorno is null) and lae.lae_codigo is not null then 1 else 0 end) as totalExamesLaboratorioApoio, ");
            }
        } else {
            buffer.append(" 0 as valorExameMaterialLaboratorioExterno, ");
            buffer.append(" 0 as valorTotalEnviadoLaboratorioExterno, ");
            buffer.append(" 0 as totalExamesLaboratorioApoio, ");
        }
        if (!this.getFiltroCheck("filtroAgruparFiliais") || this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
            for (String campo : Constantes.CAMPOS_FILIAL) {
                if (!camposUtilizados[ArraysUtil.indice((Object[])campos, campo)].booleanValue()) continue;
                buffer.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                bufferGroupBy.append("filial.fil_codigo, filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, filial.fil_complemento, filial.fil_cep, filial.fil_fone, filial.fil_fax, filial.fil_razaosocial, filial.fil_cnes, cidadefilial.cid_codigo, cidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo, bairrofilial.bai_descricao ");
                break;
            }
        }
        if (buffer.toString().trim().substring(buffer.toString().trim().length() - 1, buffer.toString().trim().length()).equals(",")) {
            buffer.replace(buffer.toString().trim().length() - 1, buffer.toString().trim().length(), "");
        }
        buffer.append("FROM ");
        buffer.append("requisicao a  ");
        buffer.append("INNER JOIN examerequisicao exr ON exr.fil_codigo = a.fil_codigo ").append("AND exr.req_codigo = a.req_codigo ");
        if (contarEnviados) {
            buffer.append("LEFT JOIN loteexternoexamerequisicao leer ON leer.fil_kodigo = exr.fil_codigo ");
            buffer.append("\t\t\t AND leer.req_codigo = exr.req_codigo ");
            buffer.append("\t\t\t AND leer.exa_codigo = exr.exa_codigo ");
            buffer.append("\t\t\t AND leer.mco_codigo = exr.mco_codigo ");
            buffer.append("LEFT JOIN loteexternorequisicao ler ").append("ON leer.fil_codigo = ler.fil_kodigo ");
            buffer.append("\t\t\t AND leer.req_codigo = ler.req_codigo ");
            buffer.append("\t\t\t AND leer.lae_codigo = ler.lae_codigo ");
            buffer.append("LEFT JOIN examematcoletalabexterno emcle ").append("ON emcle.fil_codigo = leer.fil_kodigo ");
            buffer.append("\t\t\t AND emcle.exa_codigo = leer.exa_codigo ");
            buffer.append("\t\t\t AND emcle.mco_codigo = leer.mco_codigo ");
            buffer.append("\t\t\t AND emcle.lae_codigo = ler.lae_codigo ");
        } else {
            buffer.append("LEFT JOIN examematcoletalabexterno emcle ").append("ON emcle.fil_codigo = exr.fil_codigo ");
            buffer.append("\t\t\t AND emcle.exa_codigo = exr.exa_codigo ");
            buffer.append("\t\t\t AND emcle.mco_codigo = exr.mco_codigo ");
            buffer.append("\t\t\t AND emcle.ele_bloqueado = false ");
            if (this.contaFiltroLabExterno() > 0) {
                buffer.append("      AND emcle.lae_codigo = ").append(labExterno[0]);
            } else {
                buffer.append("\t\t\t AND emcle.ele_padrao = true ");
            }
        }
        buffer.append("LEFT JOIN examesetor es ON es.fil_codigo = exr.fil_codigo ");
        buffer.append("\t\t\t AND es.exa_codigo = exr.exa_codigo AND es.ese_default ");
        buffer.append("LEFT JOIN materialcoleta mco ON mco.fil_codigo = exr.fil_codigo ");
        buffer.append("\t\t\t AND mco.mco_codigo = exr.mco_codigo ");
        buffer.append("LEFT JOIN examematcoleta emc ON emc.fil_codigo = exr.fil_codigo ");
        buffer.append("\t\t\t AND emc.exa_codigo = exr.exa_codigo ");
        buffer.append("\t\t\t AND emc.mco_codigo = exr.mco_codigo ");
        buffer.append("LEFT JOIN exames exa ON exa.fil_codigo = exr.fil_codigo ");
        buffer.append("\t\t\t AND exa.exa_codigo = exr.exa_codigo ");
        buffer.append("LEFT JOIN convenios con ON con.fil_codigo = exr.fil_codigo ");
        buffer.append("\t\t\t AND con.con_codigo = a.con_codigo ");
        buffer.append("LEFT JOIN labexterno lae ON lae.fil_codigo = exr.fil_codigo ");
        buffer.append("\t\t\t AND lae.lae_codigo = emcle.lae_codigo ");
        if (!this.getFiltroCheck("filtroAgruparFiliais") || this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
            buffer.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
        }
        if (Funcoes.objectIsNull(filiais = this.getSelecionadosFiltro("filtroFilial", 0))) {
            filiais = new String[]{Variaveis.filialPadrao};
        }
        buffer.append(" WHERE a.fil_codigo in ( ");
        for (int i2 = 0; i2 < filiais.length; ++i2) {
            buffer.append(filiais[i2]);
            if (i2 >= filiais.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append(" ) ");
        buffer.append(" and (not exr.exr_excluido and NOT a.req_excluida) ");
        String[] convenio = this.getSelecionadosFiltro("filtroConvenio", 0);
        if (!Funcoes.objectIsNull(convenio)) {
            buffer.append("AND a.con_codigo in ( ");
            for (int i3 = 0; i3 < convenio.length; ++i3) {
                buffer.append(convenio[i3]);
                if (i3 >= convenio.length - 1) continue;
                buffer.append(", ");
            }
            buffer.append(" ) ");
        }
        if (!Funcoes.objectIsNull(exame = this.getSelecionadosFiltro("filtroExame", 0))) {
            buffer.append("AND exr.exa_codigo in ( '");
            for (int i4 = 0; i4 < exame.length; ++i4) {
                buffer.append(exame[i4]);
                if (i4 >= exame.length - 1) continue;
                buffer.append("', '");
            }
            buffer.append("' ) ");
        }
        if (!Funcoes.objectIsNull(setor = this.getSelecionadosFiltro("filtroSetor", 0))) {
            buffer.append("AND es.set_codigo in ( ");
            for (i = 0; i < setor.length; ++i) {
                buffer.append(setor[i]);
                if (i >= setor.length - 1) continue;
                buffer.append(", ");
            }
            buffer.append(" ) ");
        }
        if (contarEnviados && !Funcoes.objectIsNull(labExterno) && labExterno.length > 0) {
            buffer.append("AND ler.lae_codigo in ( ");
            for (i = 0; i < labExterno.length; ++i) {
                buffer.append(labExterno[i]);
                if (i >= labExterno.length - 1) continue;
                buffer.append(", ");
            }
            buffer.append(" ) ");
        }
        if (this.getFiltroCheck("filtroIntervaloHora")) {
            buffer.append("AND date_trunc('minute', req_data + req_hora) > '").append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial"))).append(" ").append(this.getFiltroHora("filtroHoraInicial")).append("' ");
            buffer.append("AND date_trunc('minute', req_data + req_hora) < '").append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataFinal"))).append(" ").append(this.getFiltroHora("filtroHoraFinal")).append("' ");
        } else {
            if (!this.getFiltroData("filtroDataInicial").isEmpty()) {
                buffer.append("AND a.req_data >= '").append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial"))).append("' ");
            }
            if (!this.getFiltroData("filtroDataFinal").isEmpty()) {
                buffer.append("AND a.req_data <= '").append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataFinal"))).append("' ");
            }
            if (!this.getFiltroData("filtroHoraInicial").isEmpty()) {
                buffer.append("AND a.req_hora >= '").append(this.getFiltroHora("filtroHoraInicial")).append("' ");
            }
            if (!this.getFiltroData("filtroHoraFinal").isEmpty()) {
                buffer.append("AND a.req_hora <= '").append(this.getFiltroHora("filtroHoraFinal")).append("' ");
            }
        }
        if (!bufferGroupBy.toString().isEmpty()) {
            buffer.append("GROUP BY ");
            buffer.append((CharSequence)bufferGroupBy);
            if (buffer.toString().trim().substring(buffer.toString().trim().length() - 1, buffer.toString().trim().length()).equals(",")) {
                buffer.replace(buffer.toString().trim().length() - 1, buffer.toString().trim().length(), "");
            }
        }
        buffer.append("ORDER BY ");
        buffer.append(this.getOrdenacao(camposUtilizados));
        return buffer.toString();
    }

    private Object getOrdenacao(Boolean[] camposUtilizados) {
        StringBuilder bufferOrderBy = new StringBuilder();
        switch (this.getFiltroComboIndice("filtroOrdem")) {
            case 0: {
                bufferOrderBy.append("codigoExame asc");
                break;
            }
            case 1: {
                bufferOrderBy.append("valorExameMaterialLaboratorioExterno asc");
                break;
            }
            case 2: {
                bufferOrderBy.append("valorTotalExameRequisicao asc");
                break;
            }
            case 3: {
                bufferOrderBy.append("totalExamesLaboratorioApoio asc");
                break;
            }
            case 4: {
                bufferOrderBy.append("totalExamesSolicitados asc");
                break;
            }
            case 5: {
                bufferOrderBy.append("totalExamesSolicitados desc");
            }
        }
        return bufferOrderBy.toString();
    }

    private BigDecimal getCustoLabApoio(String exaCodigo, String mcoCodigo) throws SQLException {
        boolean apoioSelecionado;
        String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
        String[] labExterno = this.getSelecionadosFiltro("filtroLabApoio", 0);
        boolean bl = apoioSelecionado = !Funcoes.objectIsNull(labExterno) && labExterno.length > 0;
        if (Funcoes.objectIsNull(filiais)) {
            filiais = new String[]{Variaveis.filialPadrao};
        }
        StringBuilder buffer = new StringBuilder();
        if (apoioSelecionado && this.getFiltroCheck("filtroValorLabExterno")) {
            int i;
            buffer.append("select avg(ele_valorexame) as valorCustoLaboratorioExterno from examematcoletalabexterno ");
            buffer.append(" WHERE fil_codigo in ( ");
            for (i = 0; i < filiais.length; ++i) {
                buffer.append(filiais[i]);
                if (i >= filiais.length - 1) continue;
                buffer.append(", ");
            }
            buffer.append(") AND exa_codigo = '").append(exaCodigo).append("' ");
            buffer.append("AND mco_codigo = ").append(mcoCodigo);
            if (!Funcoes.objectIsNull(labExterno)) {
                buffer.append(" AND lae_codigo in ( ");
                for (i = 0; i < labExterno.length; ++i) {
                    buffer.append(labExterno[i]);
                    if (i >= labExterno.length - 1) continue;
                    buffer.append(", ");
                }
                buffer.append(")");
            }
        } else {
            int i;
            buffer.append("select ");
            if (this.getFiltroCheck("filtroValorLabExterno")) {
                buffer.append("SUM(Coalesce(emcle1.ele_valorexame, 0)) / count(exr.exa_codigo)  as valorCustoLaboratorioExterno");
            } else {
                buffer.append("SUM(CASE WHEN leer.ler_custo > 0 THEN  leer.ler_custo ELSE Coalesce(emcle1.ele_valorexame, 0) END ) / count(exr.exa_codigo) as valorCustoLaboratorioExterno");
            }
            buffer.append(" FROM requisicao a  ");
            buffer.append("INNER JOIN examerequisicao exr ON exr.fil_codigo = a.fil_codigo and exr.req_codigo = a.req_codigo ");
            buffer.append("LEFT JOIN loteexternoexamerequisicao leer ON leer.fil_kodigo = exr.fil_codigo ");
            buffer.append("\t\t\t  AND leer.req_codigo = exr.req_codigo ");
            buffer.append("\t\t\t\tAND leer.exa_codigo = exr.exa_codigo ");
            buffer.append("\t\t\t\tAND leer.mco_codigo = exr.mco_codigo ");
            buffer.append("LEFT JOIN loteexternorequisicao ler ").append("ON leer.fil_codigo = ler.fil_kodigo ");
            buffer.append("\t\t\t\tAND leer.req_codigo = ler.req_codigo ");
            buffer.append("\t\t\t\tAND leer.lex_codigo = ler.lex_codigo ");
            buffer.append("LEFT JOIN examesetor es ON es.fil_codigo = exr.fil_codigo ");
            buffer.append("\t\t\t\tAND es.exa_codigo = exr.exa_codigo and es.ese_default ");
            buffer.append("LEFT JOIN examematcoletalabexterno emcle1 ").append("ON emcle1.fil_codigo = exr.fil_codigo ");
            buffer.append("\t\t\t\tAND emcle1.exa_codigo = exr.exa_codigo ");
            buffer.append("\t\t\t\tAND emcle1.mco_codigo = exr.mco_codigo ");
            if (this.contaFiltroLabExterno() <= 0) {
                buffer.append("\t\t\t\tAND emcle1.ele_padrao ");
            }
            buffer.append("LEFT JOIN convenios con ON con.fil_codigo = exr.fil_codigo ");
            buffer.append("\t\t\t\tAND con.con_codigo = a.con_codigo ");
            if (!this.getFiltroCheck("filtroAgruparFiliais") || this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
                buffer.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            }
            buffer.append(" WHERE a.fil_codigo in ( ");
            for (int i2 = 0; i2 < filiais.length; ++i2) {
                buffer.append(filiais[i2]);
                if (i2 >= filiais.length - 1) continue;
                buffer.append(", ");
            }
            buffer.append(" ) ");
            buffer.append(" and a.req_excluida = false and exr_excluido = false ");
            String[] convenio = this.getSelecionadosFiltro("filtroConvenio", 0);
            if (!Funcoes.objectIsNull(convenio)) {
                buffer.append("AND a.con_codigo in ( ");
                for (int i3 = 0; i3 < convenio.length; ++i3) {
                    buffer.append(convenio[i3]);
                    if (i3 >= convenio.length - 1) continue;
                    buffer.append(", ");
                }
                buffer.append(" ) ");
            }
            buffer.append("AND exr.exa_codigo = '").append(exaCodigo).append("' ");
            buffer.append("AND exr.mco_codigo = ").append(mcoCodigo).append(" ");
            String[] setor = this.getSelecionadosFiltro("filtroSetor", 0);
            if (!Funcoes.objectIsNull(setor)) {
                buffer.append("AND es.set_codigo in ( ");
                for (i = 0; i < setor.length; ++i) {
                    buffer.append(setor[i]);
                    if (i >= setor.length - 1) continue;
                    buffer.append(", ");
                }
                buffer.append(" ) ");
            }
            if (!Funcoes.objectIsNull(labExterno)) {
                buffer.append("AND ler.lae_codigo in ( ");
                for (i = 0; i < labExterno.length; ++i) {
                    buffer.append(labExterno[i]);
                    if (i >= labExterno.length - 1) continue;
                    buffer.append(", ");
                }
                buffer.append(" ) ");
            }
            if (this.getFiltroCheck("filtroIntervaloHora")) {
                buffer.append("AND date_trunc('minute', req_data + req_hora) > '").append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial"))).append(" ").append(this.getFiltroHora("filtroHoraInicial")).append("' ");
                buffer.append("AND date_trunc('minute', req_data + req_hora) < '").append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataFinal"))).append(" ").append(this.getFiltroHora("filtroHoraFinal")).append("' ");
            } else {
                if (!this.getFiltroData("filtroDataInicial").isEmpty()) {
                    buffer.append("AND a.req_data >= '").append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial"))).append("' ");
                }
                if (!this.getFiltroData("filtroDataFinal").isEmpty()) {
                    buffer.append("AND a.req_data <= '").append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataFinal"))).append("' ");
                }
                if (!this.getFiltroData("filtroHoraInicial").isEmpty()) {
                    buffer.append("AND a.req_hora >= '").append(this.getFiltroHora("filtroHoraInicial")).append("' ");
                }
                if (!this.getFiltroData("filtroHoraFinal").isEmpty()) {
                    buffer.append("AND a.req_hora <= '").append(this.getFiltroHora("filtroHoraFinal")).append("' ");
                }
            }
        }
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buffer.toString());
        BigDecimal custo = BigDecimal.ZERO;
        if (rs.next()) {
            custo = !DBUtil.campoNull(rs.getString("valorCustoLaboratorioExterno")) ? rs.getBigDecimal("valorCustoLaboratorioExterno") : BigDecimal.ZERO;
        }
        return custo;
    }

    private Boolean[] verificaCamposNoModelo() {
        Object[] camposUtilizados = new Boolean[campos.length];
        Arrays.fill(camposUtilizados, Boolean.FALSE);
        StringBuilder buffer = new StringBuilder("select rel_xml from relatoriosistema where rel_codigo = ");
        buffer.append(RelatorioComparativoProducao.getModuloAcesso());
        try {
            String xml;
            ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), buffer.toString());
            if (rs.next() && !Funcoes.textoVazio(xml = rs.getString("rel_xml"))) {
                for (String campo : campos) {
                    if (!xml.contains(campo)) continue;
                    for (String itemBanda : xml.split("<itemBanda>")) {
                        String tipoCampo = StringUtil.getTag("tipoItem", itemBanda);
                        if (!tipoCampo.contains("CampoBanco") && !tipoCampo.contains("Expressao") || !StringUtil.getTag("nomeCampo", itemBanda).contains(campo) && !StringUtil.getTag("expressao", itemBanda).contains(campo)) continue;
                        camposUtilizados[ArraysUtil.indice((Object[])RelatorioComparativoProducao.campos, (String)campo)] = true;
                    }
                }
            }
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return camposUtilizados;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0880401200");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0880401201");
    }
}

