/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.gerencial;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.laboratorio.relatorios.util.RelatorioUtil;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioComparativoPrecosDiferenciados
extends FrmRelPadrao {
    private static final long ACESSO_ACESSAR = Long.parseLong("0880400600");
    private static final long ACESSO_CONFIGURAR = Long.parseLong("0880400601");
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String[] CAMPOS_EXAME = new String[]{"codigoExame", "descricaoExame", "valorExame", "valorExameDiferenciado", "valorTotalExame", "valorTotalExameDiferenciado", "quantidadeExames", "valorCustoSimplesExameHistorico", "valorCustoSimplesExameAtual"};
    private final String[] CAMPOS_MATERIAL = new String[]{"codigoMaterial", "descricaoMaterial", "abreviaturaMaterial"};
    private final String[] CAMPOS_CONVENIO = new String[]{"codigoConvenio", "fantasiaConvenio", "razaoSocialConvenio"};
    private String[] campos = Constantes.CAMPOS_FILIAL;

    public RelatorioComparativoPrecosDiferenciados() {
        this.montaBarraDescricao("Relat\u00f3rio comparativo de pre\u00e7os diferenciados", "Listagem das requisi\u00e7\u00f5es solicitadas no per\u00edodo por conv\u00eanio comparadas por valor diferenciado", "relatorios/rel_ger_analitico_preco_diferente.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.setModuloAcesso(RelatorioComparativoPrecosDiferenciados.getModuloAcesso());
        this.setModuloConfigurar(RelatorioComparativoPrecosDiferenciados.getModuloConfigurar());
        this.campos = ArraysUtil.concatenar(this.campos, this.CAMPOS_EXAME);
        this.campos = ArraysUtil.concatenar(this.campos, this.CAMPOS_MATERIAL);
        this.campos = ArraysUtil.concatenar(this.campos, this.CAMPOS_CONVENIO);
        this.setCamposConfigurador(this.campos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        if (Funcoes.textoVazio(this.getFiltroData("filtroDataInicial"))) {
            Funcoes.mensagem(this, "A data inicial deve ser informada.", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        if (Funcoes.textoVazio(this.getFiltroData("filtroDataFinal"))) {
            Funcoes.mensagem(this, "A data final deve ser informada.", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        String[] convenio = this.getSelecionadosFiltro("filtroConvenio", 0);
        if (convenio == null) {
            Funcoes.mensagem(this, "O conv\u00eanio deve ser informado.", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        if (convenio.length > 1) {
            Funcoes.mensagem(this, "Somente um conv\u00eanio pode ser selecionado.", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        Statement st = Conexao.getStatement();
        try {
            int i;
            StringBuilder buf = new StringBuilder();
            buf.append(" select a.exa_codigo as codigoExame ");
            buf.append("       ,exa.exa_descricao as descricaoExame ");
            buf.append("       ,mco.mco_codigo as codigoMaterial ");
            buf.append("       ,mco.mco_descricao as descricaoMaterial ");
            buf.append("       ,mco.mco_abreviatura as abreviaturaMaterial ");
            buf.append("       ,con.con_codigo as codigoConvenio ");
            buf.append("       ,con.con_fantasia as fantasiaConvenio ");
            buf.append("       ,con.con_razao as razaoSocialConvenio ");
            buf.append("\t\t\t ,emc.emc_custosimples as valorCustoSimplesExameAtual ");
            buf.append("\t\t\t ,SUM(a.exr_custosimples) as valorCustoSimplesExameHistorico ");
            buf.append("       ,COUNT(a.exa_codigo) as quantidadeExames ");
            buf.append("       ,SUM(calculaprecototalexamerequisicao(req.fil_codigo, req.con_codigo, req.req_codigo, a.exa_codigo, a.mco_codigo, true, false, false, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, false, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", a.met_codigo").append(")) as valorExame ");
            buf.append("       ,SUM(calculaprecototalexamerequisicao(req.fil_codigo, req.con_codigo, req.req_codigo, a.exa_codigo, a.mco_codigo, true, false, true, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, false, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", a.met_codigo").append(")) as valorTotalExame ");
            buf.append("       ,SUM(calculaprecototalexamerequisicao(req.fil_codigo, req.con_codigo, req.req_codigo, a.exa_codigo, a.mco_codigo, true, false, false, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, true, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", a.met_codigo").append(")) as valorExameDiferenciado ");
            buf.append("       ,SUM(calculaprecototalexamerequisicao(req.fil_codigo, req.con_codigo, req.req_codigo, a.exa_codigo, a.mco_codigo, true, false, true, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, true, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", a.met_codigo").append(")) as valorTotalExameDiferenciado ");
            buf.append("       ,SUM(a.exr_vlrmaterial) as valorMaterial ");
            buf.append("       ,").append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append("   from examerequisicao a ");
            buf.append("   join requisicao      req on a.fil_codigo = req.fil_codigo and a.req_codigo = req.req_codigo ");
            buf.append("   join exames          exa on a.fil_codigo = exa.fil_codigo and a.exa_codigo = exa.exa_codigo ");
            buf.append("   join convenios       con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
            buf.append("   join materialcoleta  mco on a.fil_codigo = mco.fil_codigo and a.mco_codigo = mco.mco_codigo ");
            buf.append("   join examematcoleta  emc on a.fil_codigo = emc.fil_codigo and a.exa_codigo = emc.exa_codigo and a.mco_codigo = emc.mco_codigo ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            StringBuilder bufWhere = new StringBuilder();
            String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
            if (filiais == null) {
                filiais = new String[]{Variaveis.filialPadrao};
            }
            bufWhere.append(" where a.fil_codigo in (");
            for (i = 0; i < filiais.length; ++i) {
                bufWhere.append(filiais[i]);
                if (i >= filiais.length - 1) continue;
                bufWhere.append(", ");
            }
            bufWhere.append(") ");
            if (convenio != null) {
                bufWhere.append(" and con.con_codigo in (");
                for (i = 0; i < convenio.length; ++i) {
                    bufWhere.append(convenio[i]);
                    if (i >= convenio.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                bufWhere.append(" and req.req_data >= '").append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial"))).append("' ");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                bufWhere.append(" and req.req_data <= '").append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataFinal"))).append("' ");
            }
            bufWhere.append(" and req.req_excluida = false ");
            bufWhere.append(" and a.exr_excluido = false ");
            buf.append(bufWhere.toString());
            buf.append(" group by a.exa_codigo ");
            buf.append("         ,exa.exa_descricao ");
            buf.append("         ,mco.mco_codigo ");
            buf.append("         ,mco.mco_descricao ");
            buf.append("         ,mco.mco_abreviatura ");
            buf.append("         ,con.con_codigo ");
            buf.append("         ,con.con_fantasia ");
            buf.append("         ,con.con_razao ");
            buf.append("\t\t\t   ,a.exr_custosimples ");
            buf.append("\t\t\t   ,emc.emc_custosimples ");
            buf.append("         ,").append("filial.fil_codigo, filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, filial.fil_complemento, filial.fil_cep, filial.fil_fone, filial.fil_fax, filial.fil_razaosocial, filial.fil_cnes, cidadefilial.cid_codigo, cidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo, bairrofilial.bai_descricao ");
            buf.append(" order by a.exa_codigo ");
            buf.append("         ,exa.exa_descricao ");
            buf.append("         ,mco.mco_codigo ");
            buf.append("         ,mco.mco_descricao ");
            buf.append("         ,mco.mco_abreviatura ");
            buf.append("         ,con.con_codigo ");
            buf.append("         ,con.con_fantasia ");
            buf.append("         ,con.con_razao ");
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(this.campos);
                do {
                    Object[] o = new Object[this.campos.length];
                    for (int i2 = 0; i2 < this.campos.length; ++i2) {
                        if (RelatorioUtil.possuiColuna(rs, this.campos[i2]) <= 0) continue;
                        o[i2] = rs.getObject(this.campos[i2]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioComparativoPrecosDiferenciados.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    int i3;
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioComparativoPrecosDiferenciados.this.panelCentro.removeAll();
                            RelatorioComparativoPrecosDiferenciados.this.panelCentro.repaint();
                            RelatorioComparativoPrecosDiferenciados.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                    var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                    buf.delete(0, buf.length());
                    if (filiais != null) {
                        for (i3 = 0; i3 < filiais.length; ++i3) {
                            buf.append(filiais[i3]);
                            if (i3 >= filiais.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroFilial", buf.toString());
                    buf.delete(0, buf.length());
                    if (convenio != null) {
                        for (i3 = 0; i3 < convenio.length; ++i3) {
                            buf.append(convenio[i3]);
                            if (i3 >= convenio.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroConvenio", buf.toString());
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                this.setCursor(Cursor.getDefaultCursor());
                throw throwable;
            }
            Conexao.fecharStatement(st);
            this.setCursor(Cursor.getDefaultCursor());
        }
        Conexao.fecharStatement(st);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return ACESSO_ACESSAR;
    }

    public static long getModuloConfigurar() {
        return ACESSO_CONFIGURAR;
    }
}

