/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.gerencial;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.table.TableModel;

public class RelatorioComparativoPrecoLabExterno
extends FrmRelPadrao {
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_LAB_EXTERNO = "filtroLabExterno";
    private final String FILTRO_ORDEM = "filtroOrdem";
    private final String FILTRO_VALOR_MENOR = "filtroValorMenor";
    private final String FILTRO_EXAME = "filtroExameSelecionado";
    private final String[] ordem = new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "C\u00f3digo AMB"};
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoExame", "descricaoExame", "sexoExame", "materialPadraoExame", "horaEntradaExame", "horaSaidaExame", "filtroExame", "proibidoExame", "diagnosticoExame", "interferenciaExame", "sinonimoExame", "salvaParcialExame", "idadeMaximaExame", "idadeMinimaExame", "tipoIdadeMaximaExame", "tipoIdadeMinimaExame", "proibidoWebExame", "quantidadeAmostrasExame", "materialPadraoExame", "preaparoExame", "inadequadaExame", "codigoPrazoEntrega", "codigoMetodologia", "ordemExame", "paginaExame", "cbhpmExame", "ambExame", "conservacaoExame", "diasConservacaoExame", "temperaturaInicialExame", "temperaturaFinalExame", "referenciaExame", "procedimentoExame", "solicitarJejumExame", "solicitarMedicamentoExame", "solicitarDUMExame", "solicitarTempoDiureseExame", "instrucaoColetaExame", "marcarExternoExame", "descricaoPrazoEntrega", "rotinaPrazoEntrega", "diasPrazoEntrega", "horaEntradaPrazoEntrega", "horaSaidaPrazoEntrega", "descricaoMetodologia", "codigoMaterialColetado", "descricaoMaterialColetado", "solicitarMaterialMaterialColetado", "abreviaturaMaterialColetado", "codigoSetor", "descricaoSetor", "responsavelSetor", "corSetor", "siglaSetor", "codigoUsuario", "nomeUsuario", "codigoTabelaPreco", "descricaoTabelaPreco", "valorCHTabelaPreco", "moedaTabelaPreco", "codigoAmbTabelaPrecoExame", "valorCHTabelaPrecoExame", "valorTabelaPrecoExame", "percentualTabelaPrecoExame", "custoTabelaPrecoExame", "porteTabelaPrecoExame", "valorPorteTabelaPrecoExame", "valorUCOTabelaPrecoExame", "proibidoTabelaPrecoExame", "codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio", "cnpjConvenio", "tipoPagamentoConvenio", "faturarFaltaMaterialConvenio", "habilitarDescontoConvenio", "multaConvenio", "moraConvenio", "faturarFiliaisConvenio", "quantidade1ViaConvenio", "numeroExamesConvenio", "viasFaturaConvenio", "imprimirBloquetoConvenio", "quantidade2ViaConvenio", "tipoCalculoFaturaConvenio", "percentualBalcaoConvenio", "cobrarExameBalcaoConvenio", "inscricaoEstadualConvenio", "titularDependenteConvenio", "mascaraCarteiraConvenio", "contatoConvenio", "obrigaMatriculaConvenio", "cepConvenio", "complementoConvenio", "enderecoConvenio", "cepCobrancaConvenio", "complementoCobrancaConvenio", "enderecoCobrancaConvenio", "faxConvenio", "reajusteConvenio", "foneConvenio", "valorFilmeConvenio", "valorCHConvenio", "siteConvenio", "email2Convenio", "email1Convenio", "tipoCalculoCHConvenio", "inscricaoMunicipalConvenio", "percentualBonusConvenio", "senhaWebConvenio", "percentualAcrescimoConvenio", "proibidoWebConvenio", "obrigaValidadeGuiaConvenio", "obrigaGuiaConvenio", "diasValidadeGuia", "ordemFaturaConvenio", "cobrarMateriaisConvenio", "valorExameLabExterno", "prazoExameLabExterno", "codigoLabExterno", "descricaoLabExterno", "codigoMetodologia", "numeroEnderecoConvenio", "numeroEnderecoCobrancaConvenio", "tipoLogradouroConvenio", "tipoLogradouroCobrancaConvenio", "valorCustoSimplesExameAtual"});

    public RelatorioComparativoPrecoLabExterno() {
        this.montaBarraDescricao("Relat\u00f3rio comparativo de pre\u00e7os de laborat\u00f3rio externo", "Listagem das diferen\u00e7as de pre\u00e7os entre exames do laboratorio e de laborat\u00f3rios externos", "relatorios/rel_ger_analitico_preco_labexterno.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroLabExterno", "Lab. Externo", "labexterno", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"lae_codigo", "lae_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroExameSelecionado", "Exame", "exames", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroCombo("filtroOrdem", "Ordem:", this.ordem, 0);
        this.adicionaFiltroCheck("filtroValorMenor", "Exames acima da tabela", false);
        this.setCamposConfigurador(campos);
        this.setModuloAcesso(RelatorioComparativoPrecoLabExterno.getModuloAcesso());
        this.setModuloConfigurar(RelatorioComparativoPrecoLabExterno.getModuloConfigurar());
    }

    @Override
    public void imprimirPressionado() {
        if (this.getSelecionadosFiltro("filtroConvenio", 0) == null) {
            Funcoes.mensagem(this, "O conv\u00eanio deve ser informado.", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        if (this.getSelecionadosFiltro("filtroConvenio", 0).length > 1) {
            Funcoes.mensagem(this, "Selecione apenas um conv\u00eanio.", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        if (this.getSelecionadosFiltro("filtroLabExterno", 0) == null) {
            Funcoes.mensagem(this, "O laborat\u00f3rio externo deve ser informado.", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        if (this.getSelecionadosFiltro("filtroLabExterno", 0).length > 1) {
            Funcoes.mensagem(this, "Selecione apenas um laborat\u00f3rio externo.", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            int i;
            String[] exame;
            String[] labexterno;
            Statement st = Conexao.getStatement();
            StringBuilder bufNormal = new StringBuilder();
            StringBuilder bufMetodologia = new StringBuilder();
            StringBuilder buf = new StringBuilder();
            buf.append(" select ele.ele_valorexame AS valorExameLabExterno ");
            buf.append("       ,ele.ele_diasprazo AS prazoexamelabexterno ");
            buf.append("       ,lae.lae_codigo AS codigolabexterno ");
            buf.append("       ,lae.lae_descricao AS descricaolabexterno ");
            buf.append("       ,d.met_codigo AS codigometodologia ");
            buf.append("       ,d.met_descricao as descricaometodologia ");
            buf.append("       ,a.exa_codigo as codigoExame ");
            buf.append("       ,a.exa_descricao as descricaoExame ");
            buf.append("       ,a.exa_sexo as sexoExame ");
            buf.append("       ,a.exa_horaentrada as horaEntradaExame ");
            buf.append("       ,a.exa_horasaida as horaSaidaExame ");
            buf.append("       ,a.exa_filtro as filtroExame ");
            buf.append("       ,a.exa_proibido as proibidoExame ");
            buf.append("       ,a.exa_diagnostico as diagnosticoExame ");
            buf.append("       ,a.exa_interferencia as interferenciaExame ");
            buf.append("       ,a.exa_sinonimo as sinonimoExame ");
            buf.append("       ,a.exa_salvaparcial as salvaParcialExame ");
            buf.append("       ,a.exa_idademax as idadeMaximaExame ");
            buf.append("       ,a.exa_idademin as idadeMinimaExame ");
            buf.append("       ,a.exa_idademaxtipo as tipoIdadeMaximaExame ");
            buf.append("       ,a.exa_idademintipo as tipoIdadeMinimaExame ");
            buf.append("       ,a.exa_proibidoweb as proibidoWebExame ");
            buf.append("       ,a.exa_qtdeamostras as quantidadeAmostrasExame ");
            buf.append("       ,b.emc_default as materialPadraoExame ");
            buf.append("       ,b.emc_preparo as preaparoExame ");
            buf.append("       ,b.emc_inadequada as inadequadaExame ");
            buf.append("       ,b.prz_codigo as codigoPrazoEntrega ");
            buf.append("       ,b.met_codigo as codigoMetodologia ");
            buf.append("       ,b.emc_ordem as ordemExame ");
            buf.append("       ,b.emc_pagina as paginaExame ");
            buf.append("       ,b.emc_codigocbhpm as cbhpmExame ");
            buf.append("       ,b.emc_codigoamb as ambExame ");
            buf.append("       ,b.emc_conservacao as conservacaoExame ");
            buf.append("       ,b.emc_diasconserva as diasConservacaoExame ");
            buf.append("       ,b.emc_temperaturainicial as temperaturaInicialExame ");
            buf.append("       ,b.emc_temperaturafinal as temperaturaFinalExame ");
            buf.append("       ,b.emc_referencia as referenciaExame ");
            buf.append("       ,b.emc_procedimento as procedimentoExame");
            buf.append("       ,b.emc_solicitarjejum as solicitarJejumExame ");
            buf.append("       ,b.emc_obrigamedicamento as solicitarMedicamentoExame ");
            buf.append("       ,b.emc_obrigadum as solicitarDUMExame ");
            buf.append("       ,b.emc_obrigapeso as solicitarPesoExame");
            buf.append("       ,b.emc_obrigaaltura as solicitarAlturaExame");
            buf.append("       ,b.emc_obrigavolume as solicitarVolumeExame ");
            buf.append("       ,b.emc_obrigatempodiurese as solicitarTempoDiureseExame ");
            buf.append("       ,b.emc_instrcoleta as instrucaoColetaExame ");
            buf.append("       ,b.emc_marcarexterno as marcarExternoExame ");
            buf.append("       ,b.emc_custosimples as valorCustoSimplesExameAtual ");
            buf.append("       ,c.prz_descricao as descricaoPrazoEntrega ");
            buf.append("       ,c.prz_prazo as rotinaPrazoEntrega ");
            buf.append("       ,c.prz_dias as diasPrazoEntrega ");
            buf.append("       ,c.prz_horaentrada as horaEntradaPrazoEntrega ");
            buf.append("       ,c.prz_horasaida as horaSaidaPrazoEntrega ");
            buf.append("       ,d.met_descricao as descricaoMetodologia ");
            buf.append("       ,e.mco_codigo as codigoMaterialColetado ");
            buf.append("       ,e.mco_descricao as descricaoMaterialColetado ");
            buf.append("       ,e.mco_solicitarmat as solicitarMaterialMaterialColetado ");
            buf.append("       ,e.mco_abreviatura as abreviaturaMaterialColetado ");
            buf.append("       ,f.set_codigo as codigoSetor ");
            buf.append("       ,g.set_descricao as descricaoSetor ");
            buf.append("       ,g.set_responsavel as responsavelSetor ");
            buf.append("       ,g.set_cor as corSetor ");
            buf.append("       ,g.set_sigla as siglaSetor ");
            buf.append("       ,h.usr_codigo as codigoUsuario ");
            buf.append("       ,h.usr_nome as nomeUsuario ");
            buf.append("       ,j.tpe_codigo as codigoTabelaPreco ");
            buf.append("       ,j.tpe_descricao as descricaoTabelaPreco ");
            buf.append("       ,j.tpe_valorch as valorCHTabelaPreco ");
            buf.append("       ,j.tpe_moeda as moedaTabelaPreco ");
            buf.append("       ,case when i.con_precosdiferenciados = true and cpr.cpr_valor is not null then ");
            buf.append("             case when j.tpe_tipocbhpm = false then cpr.cpr_valor ");
            buf.append("                  else ((cpr.cpr_percentual * p.tpp_valor) + (cpr.cpr_valor * j.tpe_uco)) end ");
            buf.append("        else case when j.tpe_tipocbhpm = false then dtp.dtp_valor ");
            buf.append("                  else ((dtp.dtp_percentual * p.tpp_valor) + (dtp.dtp_valor * j.tpe_uco)) end ");
            buf.append("        end as valorCHTabelaPrecoExame ");
            buf.append("       ,dtp.dtp_valor as valorTabelaPrecoExame ");
            buf.append("       ,dtp.dtp_codamb as codigoAmbTabelaPrecoExame ");
            buf.append("       ,dtp.dtp_valor as custoTabelaPrecoExame ");
            buf.append("       ,dtp.dtp_percentual as percentualTabelaPrecoExame ");
            buf.append("       ,dtp.tpp_porte as porteTabelaPrecoExame ");
            buf.append("       ,j.tpe_uco as valorUCOTabelaPrecoExame");
            buf.append("       ,p.tpp_valor as valorPorteTabelaPrecoExame ");
            buf.append("       ,dtp.dtp_proibido as proibidoTabelaPrecoExame ");
            buf.append("       ,i.con_codigo as codigoConvenio ");
            buf.append("       ,i.con_razao as razaoSocialConvenio ");
            buf.append("       ,i.con_fantasia as fantasiaConvenio ");
            buf.append("       ,i.con_cnpjcpf as cnpjConvenio ");
            buf.append("       ,i.con_tppgto as tipoPagamentoConvenio ");
            buf.append("       ,i.con_fatfmaterial as faturarFaltaMaterialConvenio ");
            buf.append("       ,i.con_descexame as habilitarDescontoConvenio  ");
            buf.append("       ,i.con_multa as multaConvenio ");
            buf.append("       ,i.con_mora as moraConvenio ");
            buf.append("       ,i.con_fatfiliais as faturarFiliaisConvenio ");
            buf.append("       ,i.con_nr1via as quantidade1ViaConvenio ");
            buf.append("       ,i.con_nrexames as numeroExamesConvenio  ");
            buf.append("       ,i.con_viasfatura as viasFaturaConvenio ");
            buf.append("       ,i.con_impbloqueto as imprimirBloquetoConvenio ");
            buf.append("       ,i.con_nr2via as quantidade2ViaConvenio ");
            buf.append("       ,i.con_tpcalcfatu as tipoCalculoFaturaConvenio ");
            buf.append("       ,i.con_percpgto as percentualBalcaoConvenio ");
            buf.append("       ,i.con_cobrexame as cobrarExameBalcaoConvenio ");
            buf.append("       ,i.con_inscrest as inscricaoEstadualConvenio ");
            buf.append("       ,i.con_titdep as titularDependenteConvenio ");
            buf.append("       ,i.con_maskcart as mascaraCarteiraConvenio ");
            buf.append("       ,i.con_contato as contatoConvenio ");
            buf.append("       ,i.con_informarmat as obrigaMatriculaConvenio ");
            buf.append("       ,i.con_cep as cepConvenio  ");
            buf.append("       ,i.con_complemento as complementoConvenio ");
            buf.append("       ,i.con_endereco as enderecoConvenio  ");
            buf.append("       ,i.con_numeroendereco as numeroEnderecoConvenio ");
            buf.append("       ,i.con_numeroendcobranca as numeroEnderecoCobrancaConvenio ");
            buf.append("       ,i.con_tipologradouroendereco as tipoLogradouroConvenio ");
            buf.append("       ,i.con_tipologradouroendcobranca as tipoLogradouroCobrancaConvenio ");
            buf.append("       ,i.con_cepcobranca as cepCobrancaConvenio ");
            buf.append("       ,i.con_complcobranca as complementoCobrancaConvenio ");
            buf.append("       ,i.con_endcobranca as enderecoCobrancaConvenio ");
            buf.append("       ,i.con_fax as faxConvenio ");
            buf.append("       ,i.con_fone as foneConvenio ");
            buf.append("       ,i.con_valorfilme as valorFilmeConvenio ");
            buf.append("       ,i.con_valorch as valorCHConvenio ");
            buf.append("       ,i.con_site as siteConvenio ");
            buf.append("       ,i.con_email2 as email2Convenio ");
            buf.append("       ,i.con_email1 as email1Convenio ");
            buf.append("       ,i.con_tpcalcch as tipoCalculoCHConvenio ");
            buf.append("       ,i.con_inscmunic as inscricaoMunicipalConvenio ");
            buf.append("       ,i.con_bonus as percentualBonusConvenio ");
            buf.append("       ,i.con_senhaweb as senhaWebConvenio ");
            buf.append("       ,i.con_acrescimo as percentualAcrescimoConvenio ");
            buf.append("       ,i.con_reajuste as reajusteConvenio ");
            buf.append("       ,i.con_proibidoweb as proibidoWebConvenio ");
            buf.append("       ,i.con_validadeguia as obrigaValidadeGuiaConvenio ");
            buf.append("       ,i.con_codigoguia as obrigaGuiaConvenio ");
            buf.append("       ,i.con_diasvalidade as diasValidadeGuia ");
            buf.append("       ,i.con_ordemfatura as ordemFaturaConvenio ");
            buf.append("       ,i.con_cobrmaterial as cobrarMateriaisConvenio ");
            buf.append("       , ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            bufMetodologia.append(buf.toString().replaceAll("dtp", "dtm"));
            bufNormal.append(buf.toString());
            bufNormal.append("from convenios i ");
            bufNormal.append(" left join tabelaprecoexames j on i.fil_codigo = j.fil_codigo and i.tpe_codigo = j.tpe_codigo ");
            bufNormal.append(" left join detalhetabelapreco dtp on i.fil_codigo = dtp.fil_codigo and j.tpe_codigo = dtp.tpe_codigo ");
            bufNormal.append(" left join examematcoletalabexterno ele on i.fil_codigo = ele.fil_codigo and dtp.exa_codigo = ele.exa_codigo and dtp.mco_codigo = ele.mco_codigo ");
            bufNormal.append(" left join labexterno lae on i.fil_codigo = lae.fil_codigo and ele.lae_codigo = lae.lae_codigo ");
            bufNormal.append(" left join examematcoleta b on dtp.fil_codigo = b.fil_codigo and dtp.exa_codigo = b.exa_codigo and dtp.mco_codigo = b.mco_codigo");
            bufNormal.append(" left join exames a on b.fil_codigo = a.fil_codigo and b.exa_codigo = a.exa_codigo ");
            bufNormal.append(" left join prazoentrega c on a.fil_codigo = c.fil_codigo and b.prz_codigo = c.prz_codigo ");
            bufNormal.append(" left join metodologia d on a.fil_codigo = d.fil_codigo and b.met_codigo = d.met_codigo ");
            bufNormal.append(" left join materialcoleta e on a.fil_codigo = e.fil_codigo and b.mco_codigo = e.mco_codigo ");
            bufNormal.append(" left join examesetor f on a.fil_codigo = f.fil_codigo and a.exa_codigo = f.exa_codigo and f.ese_default = true");
            bufNormal.append(" left join setores g on a.fil_codigo = g.fil_codigo and f.set_codigo = g.set_codigo ");
            bufNormal.append(" left join usuario h on g.usr_codigo = h.usr_codigo ");
            bufNormal.append(" left join tabelaprecoexamesporte p on dtp.fil_codigo = p.fil_codigo and dtp.tpe_codigo = p.tpe_codigo and dtp.tpp_porte = p.tpp_porte ");
            bufNormal.append(" left join conveniospreco cpr on i.fil_codigo = cpr.fil_codigo and i.con_codigo = cpr.con_codigo and dtp.exa_codigo = cpr.exa_codigo and dtp.mco_codigo = cpr.mco_codigo ");
            bufNormal.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            bufMetodologia.append("from convenios i ");
            bufMetodologia.append(" left join tabelaprecoexames j on i.fil_codigo = j.fil_codigo and i.tpe_codigo = j.tpe_codigo ");
            bufMetodologia.append(" left join detalhetabelaprecometodologia dtm on i.fil_codigo = dtm.fil_codigo and j.tpe_codigo = dtm.tpe_codigo ");
            bufMetodologia.append(" left join examematcoletalabexterno ele on i.fil_codigo = ele.fil_codigo and dtm.exa_codigo = ele.exa_codigo and dtm.mco_codigo = ele.mco_codigo ");
            bufMetodologia.append(" left join labexterno lae on i.fil_codigo = lae.fil_codigo and ele.lae_codigo = lae.lae_codigo ");
            bufMetodologia.append(" left join examematcoleta b on dtm.fil_codigo = b.fil_codigo and dtm.exa_codigo = b.exa_codigo and dtm.mco_codigo = b.mco_codigo");
            bufMetodologia.append(" left join exames a on b.fil_codigo = a.fil_codigo and b.exa_codigo = a.exa_codigo ");
            bufMetodologia.append(" left join prazoentrega c on a.fil_codigo = c.fil_codigo and b.prz_codigo = c.prz_codigo ");
            bufMetodologia.append(" left join metodologia d on a.fil_codigo = d.fil_codigo and b.met_codigo = d.met_codigo ");
            bufMetodologia.append(" left join materialcoleta e on a.fil_codigo = e.fil_codigo and b.mco_codigo = e.mco_codigo ");
            bufMetodologia.append(" left join examesetor f on a.fil_codigo = f.fil_codigo and a.exa_codigo = f.exa_codigo and f.ese_default = true");
            bufMetodologia.append(" left join setores g on a.fil_codigo = g.fil_codigo and f.set_codigo = g.set_codigo ");
            bufMetodologia.append(" left join usuario h on g.usr_codigo = h.usr_codigo ");
            bufMetodologia.append(" left join tabelaprecoexamesporte p on dtm.fil_codigo = p.fil_codigo and dtm.tpe_codigo = p.tpe_codigo and dtm.tpp_porte = p.tpp_porte ");
            bufMetodologia.append(" left join conveniospreco cpr on i.fil_codigo = cpr.fil_codigo and i.con_codigo = cpr.con_codigo and dtm.exa_codigo = cpr.exa_codigo and dtm.mco_codigo = cpr.mco_codigo ");
            bufMetodologia.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            buf.setLength(0);
            buf.append("where ");
            String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
            if (filiais != null) {
                buf.append(" a.fil_codigo in (");
                for (int i2 = 0; i2 < filiais.length; ++i2) {
                    buf.append(filiais[i2]);
                    if (i2 >= filiais.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            } else {
                buf.append("a.fil_codigo = ").append(Variaveis.filialPadrao);
            }
            String[] convenios = this.getSelecionadosFiltro("filtroConvenio", 0);
            if (convenios != null) {
                buf.append("and i.con_codigo in (");
                for (int i3 = 0; i3 < convenios.length; ++i3) {
                    buf.append(convenios[i3]);
                    if (i3 >= convenios.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            }
            if ((labexterno = this.getSelecionadosFiltro("filtroLabExterno", 0)) != null) {
                buf.append(" and lae.lae_codigo in (");
                for (int i4 = 0; i4 < labexterno.length; ++i4) {
                    buf.append(labexterno[i4]);
                    if (i4 >= labexterno.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            }
            if ((exame = this.getSelecionadosFiltro("filtroExameSelecionado", 0)) != null) {
                buf.append(" and a.exa_codigo in (");
                for (int i5 = 0; i5 < exame.length; ++i5) {
                    buf.append("'");
                    buf.append(exame[i5]);
                    buf.append("'");
                    if (i5 >= exame.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            }
            if (this.getFiltroCheck("filtroValorMenor")) {
                buf.append("and dtp.dtp_valor < ele.ele_valorexame ");
            }
            buf.append("and a.exa_proibido = false ");
            buf.append("and dtp.dtp_proibido = false ");
            buf.append("and b.emc_proibido = false ");
            bufNormal.append(buf.toString());
            bufMetodologia.append(buf.toString().replaceAll("dtp", "dtm"));
            ListaDados listaDados = new ListaDados();
            if (ParametrosGerais.getPrecoMetodologia()) {
                ResultSet rsMetodologia = Conexao.executeQuery(st, bufMetodologia.toString());
                while (rsMetodologia.next()) {
                    listaDados.addExame(rsMetodologia.getString("codigoExame"), rsMetodologia.getInt("codigoMaterialColetado"), rsMetodologia.getInt("codigoMetodologia"));
                    for (i = 0; i < campos.length; ++i) {
                        listaDados.addValor(rsMetodologia.getString("codigoExame"), rsMetodologia.getInt("codigoMaterialColetado"), rsMetodologia.getInt("codigoMetodologia"), campos[i], rsMetodologia.getObject(campos[i]));
                    }
                }
            }
            ResultSet rsNormal = Conexao.executeQuery(st, bufNormal.toString());
            while (rsNormal.next()) {
                if (!listaDados.addExame(rsNormal.getString("codigoExame"), rsNormal.getInt("codigoMaterialColetado"))) continue;
                for (i = 0; i < campos.length; ++i) {
                    listaDados.addValor(rsNormal.getString("codigoExame"), rsNormal.getInt("codigoMaterialColetado"), campos[i], rsNormal.getObject(campos[i]));
                }
            }
            if (this.getFiltroCombo("filtroOrdem").equals(this.ordem[0])) {
                listaDados.ordenarDados(new String[]{"codigoExame", "codigoMaterialColetado"});
            }
            if (this.getFiltroCombo("filtroOrdem").equals(this.ordem[1])) {
                listaDados.ordenarDados(new String[]{"descricaoExame"});
            } else if (this.getFiltroCombo("filtroOrdem").equals(this.ordem[2])) {
                listaDados.ordenarDados(new String[]{"codigoAmbTabelaPrecoExame"});
            }
            ModeloGridTable modelo = new ModeloGridTable(campos);
            Iterator<Dados> it = listaDados.getIterator();
            if (it.hasNext()) {
                while (it.hasNext()) {
                    Dados dados = it.next();
                    Object[] o = new Object[campos.length];
                    for (int i6 = 0; i6 < campos.length; ++i6) {
                        o[i6] = campos[i6].equalsIgnoreCase("tipoLogradouroConvenio") || campos[i6].equalsIgnoreCase("tipoLogradouroCobrancaConvenio") ? Tipos.tipoLogradouroDescricao((String)dados.getValor(campos[i6])) : (campos[i6].indexOf("tipo") >= 0 ? Tipos.tipoIdade(dados.getValor(campos[i6]).toString()) : dados.getValor(campos[i6]));
                    }
                    modelo.addLine(o);
                }
                buf.setLength(0);
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioComparativoPrecoLabExterno.getModuloAcesso());
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    int i7;
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioComparativoPrecoLabExterno.this.panelCentro.removeAll();
                            RelatorioComparativoPrecoLabExterno.this.panelCentro.repaint();
                            RelatorioComparativoPrecoLabExterno.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("filtroOrdem", this.getFiltroCombo("filtroOrdem"));
                    buf.setLength(0);
                    if (convenios != null) {
                        var.put("filtroConvenio", convenios[0]);
                    }
                    buf.setLength(0);
                    if (exame != null) {
                        for (i7 = 0; i7 < exame.length; ++i7) {
                            buf.append(exame[i7]);
                            if (i7 >= exame.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroExameSelecionado", buf.toString());
                    buf.setLength(0);
                    if (labexterno != null) {
                        var.put("filtroLabExterno", labexterno[0]);
                    }
                    buf.setLength(0);
                    if (filiais != null) {
                        for (i7 = 0; i7 < filiais.length; ++i7) {
                            buf.append(filiais[i7]);
                            if (i7 >= filiais.length - 1) continue;
                            buf.append(", ");
                        }
                    } else {
                        buf.append(Variaveis.filialPadrao);
                    }
                    var.put("filtroFilial", buf.toString());
                    var.put("filtroValorMenor", this.getFiltroCheck("filtroValorMenor") ? "Sim" : "N\u00e3o");
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            Conexao.fecharStatement(st);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0880400700");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0880400701");
    }

    class Dados
    implements Comparable {
        String[] colunasOrdenacao = null;
        String codigoExame = null;
        Integer codigoMaterial = null;
        Integer codigoMetodologia = null;
        HashMap<String, Object> dados = null;

        public Dados(String codigoExame, Integer codigoMaterial, Integer codigoMetodologia) {
            this.codigoExame = codigoExame;
            this.codigoMaterial = codigoMaterial;
            this.codigoMetodologia = codigoMetodologia == null ? -1 : codigoMetodologia;
            this.dados = new HashMap();
        }

        public void put(String coluna, Object valor) {
            this.dados.put(coluna, valor);
        }

        public boolean equals(String codigoExame, Integer codigoMaterial) {
            if (this.codigoExame != null && this.codigoMaterial != null && codigoExame != null && codigoMaterial != null) {
                return this.codigoExame.equalsIgnoreCase(codigoExame) && this.codigoMaterial.equals(codigoMaterial);
            }
            return false;
        }

        public boolean equals(String codigoExame, Integer codigoMaterial, Integer codigoMetodologia) {
            if (this.codigoExame != null && this.codigoMaterial != null && codigoExame != null && codigoMaterial != null && this.codigoMetodologia != null && codigoMetodologia != null) {
                return this.codigoExame.equalsIgnoreCase(codigoExame) && this.codigoMaterial.equals(codigoMaterial) && this.codigoMetodologia.equals(codigoMetodologia);
            }
            return false;
        }

        public Object getValor(String coluna) {
            return this.dados.get(coluna);
        }

        public int compareTo(Object o) {
            if (o instanceof Dados) {
                Dados aux = (Dados)o;
                int resultado = 0;
                for (int i = 0; i < this.colunasOrdenacao.length; ++i) {
                    Object valor2;
                    Object valor1;
                    if (this.dados.get(this.colunasOrdenacao[i]) instanceof String) {
                        valor1 = (String)this.dados.get(this.colunasOrdenacao[i]);
                        valor2 = (String)aux.dados.get(this.colunasOrdenacao[i]);
                        resultado = ((String)valor1).compareTo((String)valor2);
                    } else if (this.dados.get(this.colunasOrdenacao[i]) instanceof Integer) {
                        valor1 = (Integer)this.dados.get(this.colunasOrdenacao[i]);
                        valor2 = (Integer)aux.dados.get(this.colunasOrdenacao[i]);
                        resultado = ((Integer)valor1).compareTo((Integer)valor2);
                    } else if (this.dados.get(this.colunasOrdenacao[i]) instanceof BigDecimal) {
                        valor1 = (BigDecimal)this.dados.get(this.colunasOrdenacao[i]);
                        valor2 = (BigDecimal)aux.dados.get(this.colunasOrdenacao[i]);
                        resultado = ((BigDecimal)valor1).compareTo((BigDecimal)valor2);
                    }
                    if (resultado == 0 && i != this.colunasOrdenacao.length - 1) continue;
                    return resultado;
                }
            }
            return 0;
        }
    }

    class ListaDados {
        ArrayList<Dados> exames = new ArrayList();
        Dados auxExame = null;

        public Iterator<Dados> getIterator() {
            return this.exames.iterator();
        }

        public boolean addExame(String codigoExame, Integer codigoMaterial) {
            for (Dados aux : this.exames) {
                if (!aux.equals(codigoExame, codigoMaterial)) continue;
                this.auxExame = aux;
                return false;
            }
            this.auxExame = new Dados(codigoExame, codigoMaterial, null);
            this.exames.add(this.auxExame);
            return true;
        }

        public void addExame(String codigoExame, Integer codigoMaterial, Integer codigoMetodologia) {
            for (Dados aux : this.exames) {
                if (!aux.equals(codigoExame, codigoMaterial, codigoMetodologia)) continue;
                this.auxExame = aux;
                return;
            }
            this.auxExame = new Dados(codigoExame, codigoMaterial, codigoMetodologia);
            this.exames.add(this.auxExame);
        }

        public void addValor(String codigoExame, Integer codigoMaterial, Integer codigoMetodologia, String coluna, Object valor) {
            if (this.auxExame != null && this.auxExame.codigoExame.equalsIgnoreCase(codigoExame) && this.auxExame.codigoMaterial.equals(codigoMaterial) && this.auxExame.codigoMetodologia.equals(codigoMetodologia)) {
                this.auxExame.put(coluna, valor);
            } else {
                for (Dados aux : this.exames) {
                    if (!aux.equals(codigoExame, codigoMaterial, codigoMetodologia)) continue;
                    this.auxExame = aux;
                    this.auxExame.put(coluna, valor);
                }
            }
        }

        public void addValor(String codigoExame, Integer codigoMaterial, String coluna, Object valor) {
            if (this.auxExame != null && this.auxExame.codigoExame.equalsIgnoreCase(codigoExame) && this.auxExame.codigoMaterial.equals(codigoMaterial)) {
                this.auxExame.put(coluna, valor);
            } else {
                for (Dados aux : this.exames) {
                    if (!aux.equals(codigoExame, codigoMaterial)) continue;
                    this.auxExame = aux;
                    this.auxExame.put(coluna, valor);
                }
            }
        }

        public void ordenarDados(String[] colunasOrdenacao) {
            for (int i = 0; i < this.exames.size(); ++i) {
                this.exames.get((int)i).colunasOrdenacao = colunasOrdenacao;
            }
            Collections.sort(this.exames);
        }
    }
}

