/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.gerencial;

import jalis.comum.Conexao;
import jalis.comum.ConstantesGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.relatorio.Gerador;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableModel;

public class RelatorioAnaliticoCotaExameConvenio
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String[] campos = new String[]{"codigoConvenio", "razaoSocialConvenio", "politicaConvenio", "codigoExame", "descricaoExame", "descricaoMaterialExame", "cotaExame", "quantidadeCadastrados", "quantidadeAgendados", "codigoMaterialExame", "saldoExame", "mesAno"};
    private final String[] camposConvenios = new String[]{"codigoConvenio", "razaoSocialConvenio", "meses"};
    private final String[] ordem = new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"};
    private final String[] politica = new String[]{"Todas", "Cota m\u00e1xima por exame", "Cota m\u00ednima por exame"};
    private final String[] tipoData = new String[]{"Data Requisi\u00e7\u00e3o", "Data Fatura"};
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_EXAME = "filtroExame";
    private final String FILTRO_POLITICA = "filtroPolitica";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String FILTRO_TIPODATA = "tipoData";
    private String dataInicialEscolhida = "";
    private String dataFinalEscolhida = "";
    private int mesInicial;
    private int anoInicial;
    private int mesFinal;
    private int anoFinal;
    private TTextField componenteDataInicial = null;
    private TTextField componenteDataFinal = null;
    private ModeloGridTable modelo;
    private List<Registro> registros = new ArrayList<Registro>();
    String tipoDataEscolhida = this.getFiltroCombo("tipoData").toString();

    public RelatorioAnaliticoCotaExameConvenio() {
        this.buttonImportarLayout.setVisible(true);
        this.montaBarraDescricao("Relat\u00f3rio de cota de exames por conv\u00eanio", "Listagem com resumo das Cotas M\u00e1ximas e M\u00ednimas de Exames por conv\u00eanio", "relatorios/rel_cota_de_exames_por_convenio.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroExame", "Exame", "exames", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroCombo("filtroPolitica", "Pol\u00edtica:", this.politica, 0);
        this.adicionaFiltroCombo("tipoData", "Data:", this.tipoData, 0);
        this.componenteDataInicial = this.adicionaRetornaFiltroData("filtroDataInicial", "Data inicial:");
        this.componenteDataFinal = this.adicionaRetornaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.setModuloConfigurar(Long.parseLong("0880401501"));
        this.setModuloAcesso(Long.parseLong("0880401500"));
        this.setCamposConfigurador(this.campos);
    }

    @Override
    public void imprimirPressionado() {
        if (!Funcoes.verificaData(this.getFiltroData("filtroDataInicial")) || !Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
            Funcoes.mensagem(this, "Os campos \"Data inicial\" e \"Data final\" devem ser informados!", 2);
            this.setCursor(Cursor.getDefaultCursor());
            this.habilitaBotaoImprimir(true);
            ScreenUtil.requisitarFoco(this.componenteDataInicial);
            return;
        }
        if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
            this.dataInicialEscolhida = this.getFiltroData("filtroDataInicial");
            this.dataFinalEscolhida = this.getFiltroData("filtroDataFinal");
            try {
                Calendar calInicial = Calendar.getInstance();
                calInicial.setTime(Funcoes.getData("dd/MM/yyyy", this.dataInicialEscolhida));
                this.mesInicial = calInicial.get(2) + 1;
                this.anoInicial = calInicial.get(1);
                Calendar calFinal = Calendar.getInstance();
                calFinal.setTime(Funcoes.getData("dd/MM/yyyy", this.dataFinalEscolhida));
                this.mesFinal = calFinal.get(2) + 1;
                this.anoFinal = calFinal.get(1);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "RelatorioAnaliticoCotaExameConvenio");
            }
        }
        ArrayList dadosConvenios = new ArrayList();
        try {
            if (Funcoes.textoVazio(this.getLayoutRelatorio())) {
                Funcoes.mensagem(null, "Modelo n\u00e3o localizado ou n\u00e3o definido.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            if (!this.modeloPreenchido()) {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.gerarRelatorio();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void gerarRelatorio() throws SQLException {
        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
        gerador.setPai(this.panelCentro);
        gerador.setPreVisualizar(true);
        gerador.setZoomPreVisualizar(0.5f);
        gerador.setAcaoFechar(new Runnable(){

            @Override
            public void run() {
                RelatorioAnaliticoCotaExameConvenio.this.panelCentro.removeAll();
                RelatorioAnaliticoCotaExameConvenio.this.panelCentro.repaint();
                RelatorioAnaliticoCotaExameConvenio.this.habilitaBotaoImprimir(true);
            }
        });
        gerador.executar(this.getLayoutRelatorio(), (TableModel)this.getModelo(), this.adicionarVariaveisAoRelatorio());
        this.panelCentro.revalidate();
    }

    private Map<String, Object> adicionarVariaveisAoRelatorio() {
        HashMap<String, Object> var = new HashMap<String, Object>();
        var.put("filtroFilial", this.getSelecionadosFiltro("filtroFilial", 0));
        var.put("filtroConvenio", this.getSelecionadosFiltro("filtroConvenio", 0));
        var.put("filtroExame", this.getSelecionadosFiltro("filtroExame", 0));
        var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
        var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
        var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
        var.put("filtroPolitica", this.getFiltroCombo("filtroPolitica"));
        var.put("tipoData", this.getFiltroCombo("tipoData").toString());
        return var;
    }

    private boolean modeloPreenchido() throws SQLException {
        this.modelo = new ModeloGridTable(this.campos);
        this.registros = this.getDados();
        Object linhas = null;
        if (!this.registros.isEmpty()) {
            for (Registro registro : this.registros) {
                this.converterRegistroParaModelo(registro);
            }
            return true;
        }
        return false;
    }

    private void converterRegistroParaModelo(Registro registro) throws SQLException {
        Object[] o = new Object[this.campos.length];
        o[0] = registro.getValor(this.campos[0]);
        o[1] = registro.getValor(this.campos[1]);
        o[2] = registro.getValor(this.campos[2]);
        o[3] = registro.getValor(this.campos[3]);
        o[4] = registro.getValor(this.campos[4]);
        o[5] = registro.getValor(this.campos[5]);
        o[6] = registro.getValor(this.campos[6]);
        o[7] = registro.getValor(this.campos[7]);
        o[8] = registro.getValor(this.campos[8]);
        o[9] = registro.getValor(this.campos[9]);
        o[10] = registro.getValor(this.campos[10]);
        o[11] = registro.getValor(this.campos[11]);
        this.modelo.addLine(o);
    }

    public String getLayoutRelatorio() throws SQLException {
        String layout = "";
        StringBuilder builder = new StringBuilder();
        builder.append("select rel_xml from relatoriosistema where rel_codigo = ");
        builder.append(RelatorioAnaliticoCotaExameConvenio.getModuloAcesso());
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), builder.toString());
        if (rs.next()) {
            layout = rs.getString("rel_xml");
        }
        return layout;
    }

    private List<Registro> getDados() {
        ArrayList<Registro> registros = new ArrayList<Registro>();
        Statement st = Conexao.getStatement();
        String tipoDataEscolhida = this.getFiltroCombo("tipoData").toString();
        try {
            StringBuilder buf = new StringBuilder();
            buf.append("SELECT c.con_codigo AS codigoConvenio, c.exa_codigo AS codigoExame, c.fil_codigo AS filcodigo, ");
            buf.append(" EXTRACT(MONTH FROM r.req_data) AS mes, EXTRACT(YEAR FROM r.req_data) AS ano, ");
            buf.append(" 0 AS cotaExame, con.con_razao AS razaoSocialConvenio, con.con_tipopolitica AS politicaConvenio, ");
            buf.append(" exa.exa_descricao AS descricaoExame, mat.mco_descricao AS descricaoMaterialExame, mat.mco_codigo AS codigoMaterialExame, ");
            buf.append(" 0 AS  quantidadeCadastrados, ");
            buf.append(" 0 AS  quantidadeAgendados, ");
            buf.append(" 0 AS  saldoExame ");
            buf.append(" FROM conveniocotaexame c ");
            buf.append(" INNER JOIN convenios con ON con.fil_codigo = c.fil_codigo AND c.con_codigo = con.con_codigo ");
            buf.append(" INNER JOIN examerequisicao e ON e.exa_codigo = c.exa_codigo AND e.fil_codigo = con.fil_codigo AND e.mco_codigo = c.mco_codigo ");
            if (tipoDataEscolhida.equals(this.tipoData[1])) {
                buf.append(" AND date(e.exr_datafatura) >= '").append(Funcoes.formataData("yyyy-MM-dd", this.dataInicialEscolhida)).append("'");
                buf.append(" AND date(e.exr_datafatura) <= '").append(Funcoes.formataData("yyyy-MM-dd", this.dataFinalEscolhida)).append("'");
            }
            buf.append(" INNER JOIN materialcoleta mat ON mat.fil_codigo = e.fil_codigo AND mat.mco_codigo = e.mco_codigo ");
            buf.append(" INNER JOIN exames exa ON exa.exa_codigo = e.exa_codigo AND e.fil_codigo = exa.fil_codigo ");
            buf.append(" INNER JOIN requisicao r ON e.req_codigo = r.req_codigo AND c.con_codigo = r.con_codigo ");
            buf.append(this.getFiltroData());
            buf.append(this.getFiltroFilial());
            buf.append(this.getFiltroConvenio());
            buf.append(this.getFiltroExames());
            buf.append(this.getFiltroTipoPolitica());
            buf.append(" GROUP BY c.exa_codigo, c.con_codigo, c.fil_codigo, ");
            buf.append(" EXTRACT(MONTH FROM r.req_data), EXTRACT(YEAR FROM r.req_data), ");
            buf.append(" con.con_razao,\tcon.con_tipopolitica, exa.exa_descricao, mat.mco_codigo, mat.mco_descricao ");
            buf.append(this.getOrdemEscolhida());
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                do {
                    Registro reg = new Registro();
                    reg.setValor("codigoConvenio", rs.getInt("codigoConvenio"));
                    reg.setValor("codigoExame", rs.getString("codigoExame"));
                    reg.setValor("filcodigo", rs.getString("filcodigo"));
                    reg.setValor("mes", rs.getInt("mes"));
                    reg.setValor("ano", rs.getInt("ano"));
                    reg.setValor("razaoSocialConvenio", rs.getString("razaoSocialConvenio"));
                    reg.setValor("politicaConvenio", this.retornaTipoPolitica(rs.getString("politicaConvenio")));
                    reg.setValor("descricaoExame", rs.getString("descricaoExame"));
                    reg.setValor("descricaoMaterialExame", rs.getString("descricaoMaterialExame"));
                    reg.setValor("codigoMaterialExame", rs.getInt("codigoMaterialExame"));
                    reg.setValor("mesAno", ConstantesGerais.MESES_ANO[rs.getInt("mes") - 1].concat("/").concat(String.valueOf(rs.getInt("ano"))));
                    int cadastrados = this.getCadastrados(rs.getString("filcodigo"), rs.getString("codigoExame"), rs.getString("codigoConvenio"), rs.getString("codigoMaterialExame"));
                    int agendados = this.getAgendados(rs.getString("filcodigo"), rs.getString("codigoExame"), rs.getString("codigoConvenio"), rs.getString("codigoMaterialExame"));
                    int cotas = this.getCotas(rs.getString("filcodigo"), rs.getString("codigoExame"), rs.getString("codigoConvenio"), rs.getString("codigoMaterialExame"));
                    reg.setValor("quantidadeCadastrados", cadastrados);
                    reg.setValor("quantidadeAgendados", agendados);
                    reg.setValor("cotaExame", cotas);
                    int saldoExame = cotas - (cadastrados + agendados);
                    reg.setValor("saldoExame", saldoExame);
                    registros.add(reg);
                } while (rs.next());
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "RelatorioAnaliticoCotaExameConvenio");
        }
        return registros;
    }

    private int getCotas(String filialCodigo, String codigoExame, String codigoConvenio, String codigoMaterial) {
        Statement st = Conexao.getStatement();
        try {
            StringBuilder buf = new StringBuilder();
            buf.append("SELECT cct_quantidade AS quantidade FROM conveniocotaexame ");
            buf.append(" WHERE fil_codigo = ");
            buf.append(filialCodigo);
            buf.append(" AND exa_codigo = '");
            buf.append(codigoExame);
            buf.append("'");
            buf.append(" AND con_codigo = ");
            buf.append(codigoConvenio);
            buf.append(" AND mco_codigo = ");
            buf.append(codigoMaterial);
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                return rs.getInt("quantidade");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "RelatorioAnaliticoCotaExameConvenio");
        }
        return 0;
    }

    private int getAgendados(String filialCodigo, String codigoExame, String codigoConvenio, String codigoMaterial) {
        Statement st = Conexao.getStatement();
        String tipoDataEscolhida = this.getFiltroCombo("tipoData").toString();
        try {
            StringBuilder buf = new StringBuilder();
            buf.append("SELECT COUNT(er.*) AS quantidade FROM examerequisicao er ");
            buf.append(" INNER JOIN requisicao r ON r.req_codigo = er.req_codigo ");
            buf.append(" INNER JOIN materialcoleta mat ON mat.fil_codigo = er.fil_codigo AND mat.mco_codigo = ");
            buf.append(" er.mco_codigo ");
            buf.append(" WHERE er.fil_codigo = ");
            buf.append(filialCodigo);
            buf.append(" AND er.exa_codigo = '");
            buf.append(codigoExame);
            buf.append("'");
            buf.append(" AND r.con_codigo = ");
            buf.append(codigoConvenio);
            buf.append(" AND mat.mco_codigo = ");
            buf.append(codigoMaterial);
            buf.append(" AND (SELECT COUNT(*) > 0 FROM agendamentoexamerequisicao WHERE fil_codigo = ");
            buf.append(filialCodigo);
            buf.append(" AND exa_codigo = '");
            buf.append(codigoExame);
            buf.append("'");
            buf.append(" AND req_codigo = r.req_codigo) ");
            if (tipoDataEscolhida.equals(this.tipoData[1])) {
                buf.append(" AND date(er.exr_datafatura) >= '").append(Funcoes.formataData("yyyy-MM-dd", this.dataInicialEscolhida)).append("'");
                buf.append(" AND date(er.exr_datafatura) <= '").append(Funcoes.formataData("yyyy-MM-dd", this.dataFinalEscolhida)).append("'");
            } else {
                buf.append(this.getFiltroData());
            }
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                return rs.getInt("quantidade");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "RelatorioAnaliticoCotaExameConvenio");
        }
        return 0;
    }

    private int getCadastrados(String filialCodigo, String codigoExame, String codigoConvenio, String codigoMaterial) {
        Statement st = Conexao.getStatement();
        String tipoDataEscolhida = this.getFiltroCombo("tipoData").toString();
        try {
            StringBuilder buf = new StringBuilder();
            buf.append("SELECT COUNT(er.*) AS quantidade FROM examerequisicao er ");
            buf.append(" INNER JOIN requisicao r ON r.req_codigo = er.req_codigo ");
            buf.append(" INNER JOIN materialcoleta mat ON mat.fil_codigo = er.fil_codigo AND mat.mco_codigo = ");
            buf.append(" er.mco_codigo ");
            buf.append(" WHERE er.fil_codigo = ");
            buf.append(filialCodigo);
            buf.append(" AND er.exa_codigo = '");
            buf.append(codigoExame);
            buf.append("'");
            buf.append(" AND r.con_codigo = ");
            buf.append(codigoConvenio);
            buf.append(" AND mat.mco_codigo = ");
            buf.append(codigoMaterial);
            buf.append(" AND (SELECT COUNT(*) = 0 FROM agendamentoexamerequisicao WHERE fil_codigo = ");
            buf.append(filialCodigo);
            buf.append(" AND exa_codigo = '");
            buf.append(codigoExame);
            buf.append("'");
            buf.append(" AND req_codigo = r.req_codigo) ");
            if (tipoDataEscolhida.equals(this.tipoData[1])) {
                buf.append(" AND date(er.exr_datafatura) >= '").append(Funcoes.formataData("yyyy-MM-dd", this.dataInicialEscolhida)).append("'");
                buf.append(" AND date(er.exr_datafatura) <= '").append(Funcoes.formataData("yyyy-MM-dd", this.dataFinalEscolhida)).append("'");
            } else {
                buf.append(this.getFiltroData());
            }
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                return rs.getInt("quantidade");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "RelatorioAnaliticoCotaExameConvenio");
        }
        return 0;
    }

    private String getFiltroFilial() {
        StringBuilder bufWhere = new StringBuilder();
        bufWhere.append("WHERE con.fil_codigo ");
        String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
        if (filiais == null || filiais.length == 0) {
            bufWhere.append("= ").append(Variaveis.filialPadrao);
        } else {
            bufWhere.append(" IN (");
            for (int i = 0; i < filiais.length; ++i) {
                bufWhere.append(filiais[i]);
                if (i >= filiais.length - 1) continue;
                bufWhere.append(", ");
            }
            bufWhere.append(")");
        }
        return bufWhere.toString();
    }

    private String getFiltroExames() {
        StringBuilder bufWhere = new StringBuilder();
        String[] exames = this.getSelecionadosFiltro("filtroExame", 0);
        if (exames != null) {
            bufWhere.append(" AND c.exa_codigo IN (");
            for (int i = 0; i < exames.length; ++i) {
                bufWhere.append("'");
                bufWhere.append(exames[i]);
                bufWhere.append("'");
                if (i >= exames.length - 1) continue;
                bufWhere.append(",");
            }
            bufWhere.append(")");
        }
        return bufWhere.toString();
    }

    private String getFiltroConvenio() {
        StringBuilder bufWhere = new StringBuilder();
        String[] convenio = this.getSelecionadosFiltro("filtroConvenio", 0);
        if (convenio != null) {
            bufWhere.append(" AND con.con_codigo IN(");
            for (int i = 0; i < convenio.length; ++i) {
                bufWhere.append(convenio[i]);
                if (i >= convenio.length - 1) continue;
                bufWhere.append(",");
            }
            bufWhere.append(")");
        }
        return bufWhere.toString();
    }

    private String getFiltroTipoPolitica() {
        String politicaCombo = this.getFiltroCombo("filtroPolitica").toString();
        StringBuilder bufWhere = new StringBuilder();
        if (!politicaCombo.equals("Todas")) {
            bufWhere.append(" AND con.con_tipopolitica = '").append(this.retornaTipoPolitica(politicaCombo)).append("'");
        } else {
            bufWhere.append(" AND (con.con_tipopolitica = '").append("E").append("'");
            bufWhere.append(" OR con.con_tipopolitica = '").append("M").append("')");
        }
        return bufWhere.toString();
    }

    private String getOrdemEscolhida() {
        String ordemEscolhida = this.getFiltroCombo("ordemRelatorio").toString();
        StringBuilder bufWhere = new StringBuilder();
        bufWhere.append(" ORDER BY ");
        if (ordemEscolhida != null) {
            if (ordemEscolhida.equals(this.ordem[0])) {
                bufWhere.append("c.con_codigo");
            } else if (ordemEscolhida.equals(this.ordem[1])) {
                bufWhere.append("con.con_razao");
            }
        }
        bufWhere.append(", ano, mes, c.fil_codigo ");
        return bufWhere.toString();
    }

    private String getFiltroData() {
        StringBuilder bufWhere = new StringBuilder();
        String tipoDataEscolhida = this.getFiltroCombo("tipoData").toString();
        if (tipoDataEscolhida.equals(this.tipoData[0])) {
            bufWhere.append(" AND r.req_data >= '").append(Funcoes.formataData("yyyy-MM-dd", this.dataInicialEscolhida)).append("'");
            bufWhere.append(" AND r.req_data <= '").append(Funcoes.formataData("yyyy-MM-dd", this.dataFinalEscolhida)).append("'");
        }
        return bufWhere.toString();
    }

    private String retornaTipoPolitica(String politica) {
        String tipoPolitica = "";
        switch (politica) {
            case "Cota m\u00e1xima por exame": {
                tipoPolitica = "M";
                break;
            }
            case "Cota m\u00ednima por exame": {
                tipoPolitica = "E";
                break;
            }
            case "M": {
                tipoPolitica = "Cota m\u00e1xima por exame";
                break;
            }
            case "E": {
                tipoPolitica = "Cota m\u00ednima por exame";
                break;
            }
        }
        return tipoPolitica;
    }

    public ModeloGridTable getModelo() {
        return this.modelo;
    }

    public static long getModuloAcesso() {
        String acesso = "0880401500";
        return Long.parseLong(acesso);
    }
}

