/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.gerencial;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.Laboratorio;
import jalis.relatorio.Gerador;
import jalis.relatorio.gerador.Relatorio;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.HashMap;
import javax.swing.JComboBox;
import org.joda.time.DateTime;

public class RelatorioAnaliticoCotaConvenio
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String[] ordem = new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"};
    private final String[] campos = new String[]{"codigoFilial", "valorCota", "codigoConvenio", "descricaoFilial", "fantasiaConvenio", "razaoSocialConvenio", "razaoSocialFilial", "tipoPoliticaCotaConvenio", "politicaCotaConvenio", "valorPoliticaCotaConvenio", "valorCotaAtual", "consumoPoliticaCotaConvenio", "consumoPoliticaCreditoConvenio", "valorCotaConvenio", "valorCreditoConvenio", "consumoPoliticaCotaUnidadeSaude", "saldoPoliticaCotaUnidadeSaude", "descricaoUnidadeSaude", "codigoUnidadeSaude"};
    private final String[] politica = new String[]{"Todas", "Nenhuma", "Cota", "Cr\u00e9dito", "Unidade de Sa\u00fade"};
    private final String[] tipoData = new String[]{"Data Requisi\u00e7\u00e3o", "Data Fatura"};
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_POLITICA = "filtroPolitica";
    private final String FILTRO_POLITICA_COTA = "filtroPoliticaCota";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String FILTRO_TIPODATA = "tipoData";
    private String dataInicialEscolhida = "";
    private String dataFinalEscolhida = "";
    private TTextField componenteDataInicial = null;
    private TTextField componenteDataFinal = null;

    public RelatorioAnaliticoCotaConvenio() {
        this.montaBarraDescricao("Relat\u00f3rio de cota por conv\u00eanio", "Listagem de cota por conv\u00eanio", "relatorios/rel_cota_por_convenio.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        JComboBox politicaBox = this.adicionaRetornaFiltroCombo("filtroPolitica", "Pol\u00edtica:", this.politica, 0);
        politicaBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RelatorioAnaliticoCotaConvenio.this.setModuloConfigurar(RelatorioAnaliticoCotaConvenio.this.getModuloConfigurar(""));
                RelatorioAnaliticoCotaConvenio.this.setModuloAcesso(RelatorioAnaliticoCotaConvenio.getModuloAcesso(RelatorioAnaliticoCotaConvenio.this.getFiltroCombo("filtroPolitica").toString()));
            }
        });
        this.adicionaFiltroCombo("tipoData", "Data:", this.tipoData, 0);
        this.componenteDataInicial = this.adicionaRetornaFiltroData("filtroDataInicial", "Data inicial:");
        this.componenteDataFinal = this.adicionaRetornaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.setModuloConfigurar(this.getModuloConfigurar(this.getFiltroCombo("filtroPolitica").toString()));
        this.setModuloAcesso(RelatorioAnaliticoCotaConvenio.getModuloAcesso(this.getFiltroCombo("filtroPolitica").toString()));
        this.setCamposConfigurador(this.campos);
    }

    public static long getModuloAcesso(String politica) {
        String acesso = "0880400900";
        switch (politica) {
            case "Unidade de Sa\u00fade": {
                acesso = "0880400902";
                break;
            }
        }
        return Long.parseLong(acesso);
    }

    public static long getModuloAcesso() {
        String acesso = "0880400900";
        return Long.parseLong(acesso);
    }

    private long getModuloConfigurar(String politica) {
        String acesso = "0880400901";
        switch (politica) {
            case "Unidade de Sa\u00fade": {
                acesso = "0880400902";
                break;
            }
        }
        return Long.parseLong(acesso);
    }

    @Override
    public void imprimirPressionado() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Statement st = Conexao.getStatement();
        this.dataInicialEscolhida = "";
        this.dataFinalEscolhida = "";
        java.util.Date dataInicial = null;
        java.util.Date dataFinal = null;
        HashMap<String, Object> var = new HashMap<String, Object>();
        String tipoDataEscolhida = this.getFiltroCombo("tipoData").toString();
        if (!Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
            Funcoes.mensagem(this, "Informe a data inicial.", 2);
            this.setCursor(Cursor.getDefaultCursor());
            this.habilitaBotaoImprimir(true);
            ScreenUtil.requisitarFoco(this.componenteDataInicial);
            return;
        }
        if (!Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
            Funcoes.mensagem(this, "Informe a data final.", 2);
            this.setCursor(Cursor.getDefaultCursor());
            this.habilitaBotaoImprimir(true);
            ScreenUtil.requisitarFoco(this.componenteDataFinal);
            return;
        }
        if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
            this.dataInicialEscolhida = this.getFiltroData("filtroDataInicial");
            this.dataFinalEscolhida = this.getFiltroData("filtroDataFinal");
            try {
                Calendar calInicial = Calendar.getInstance();
                dataInicial = Funcoes.getData("dd/MM/yyyy", this.dataInicialEscolhida);
                calInicial.setTime(dataInicial);
                calInicial.set(5, 1);
                dataInicial = calInicial.getTime();
                Calendar calFinal = Calendar.getInstance();
                dataFinal = Funcoes.getData("dd/MM/yyyy", this.dataFinalEscolhida);
                calFinal.setTime(dataFinal);
                calFinal.set(5, calFinal.getActualMaximum(5));
                dataFinal = calFinal.getTime();
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "RelatorioAnaliticoCotaConvenio");
            }
        }
        try {
            ResultSet rs;
            StringBuilder buf = new StringBuilder();
            buf.append("SELECT DISTINCT fpc.fil_codigo as codigoFilial,con.con_codigo as codigoConvenio,");
            buf.append(" COALESCE((SELECT EXTRACT(year FROM age('").append(Funcoes.formataData("yyyy-MM-dd", dataFinal)).append("','").append(Funcoes.formataData("yyyy-MM-dd", dataInicial)).append("'))*12 + EXTRACT(month FROM age('").append(Funcoes.formataData("yyyy-MM-dd", dataFinal)).append("','").append(Funcoes.formataData("yyyy-MM-dd", dataInicial)).append("'))");
            buf.append(" ),0) as qtdMeses,");
            buf.append("fpc.fil_descricao as descricaoFilial,con.con_fantasia as fantasiaConvenio,");
            buf.append("con.con_razao as razaoSocialConvenio,");
            buf.append("fpc.fil_razaosocial as razaoSocialFilial,con.con_tipopolitica,con.con_tipopolitica as politicaCotaConvenio,");
            buf.append("CASE WHEN con.con_tipopolitica = 'C' then 'Cota'");
            buf.append("WHEN con.con_tipopolitica = 'E' then 'Exame'");
            buf.append("WHEN con.con_tipopolitica = 'T' then 'Cr\u00e9dito'");
            buf.append("WHEN con.con_tipopolitica = 'N' then 'Nenhuma'");
            buf.append("WHEN con.con_tipopolitica = 'U' then 'Unidade de Sa\u00fade'");
            buf.append("else '' end as tipoPoliticaCotaConvenio,");
            buf.append("CASE WHEN con.con_tipopolitica = 'C' THEN COALESCE(con.con_valorcota, 0 ) ELSE 0  END AS valorCotaConvenio,");
            buf.append("CASE WHEN con.con_tipopolitica = 'T' THEN COALESCE(con.con_valorcredito, 0) ELSE 0 END as valorCreditoConvenio,");
            buf.append("COALESCE(con.con_valorcota,0) as valorPoliticaCotaConvenio,");
            buf.append("0 valorCota,");
            buf.append("0 valorCotaAtual,");
            buf.append("0 as consumoPoliticaCotaConvenio,");
            buf.append("0 as consumoPoliticaCreditoConvenio, ");
            buf.append("(select count(*)");
            buf.append("from requisicao req ");
            buf.append("inner join examerequisicao exr on exr.fil_codigo = req.fil_codigo and exr.req_codigo = req.req_codigo ");
            buf.append("left join agendamento a on req.fil_codigo = a.fil_codigo ");
            buf.append("and req.req_codigo = a.req_codigo ");
            buf.append("and a.agd_datahoracancelamento IS NULL ");
            buf.append("where cus.fil_codigo = req.fil_codigo ");
            buf.append("and cus.uns_codigo = req.uns_codigo ");
            buf.append("and cus.con_codigo = req.con_codigo ");
            buf.append("and not exr.exr_excluido ");
            buf.append("and CASE WHEN con_usaragendamentopolitica ");
            buf.append("THEN not req.req_excluida or (req.req_excluida and a.agd_codigo is not null) ELSE not req.req_excluida END ");
            if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                if (tipoDataEscolhida.equals(this.tipoData[0])) {
                    buf.append(" AND req.req_data >= '").append(Funcoes.formataData("yyyy-MM-dd", this.dataInicialEscolhida)).append("'");
                    buf.append(" AND req.req_data <= '").append(Funcoes.formataData("yyyy-MM-dd", this.dataFinalEscolhida)).append("'");
                } else if (tipoDataEscolhida.equals(this.tipoData[1])) {
                    buf.append(" AND req.req_dtfatura >= '").append(Funcoes.formataData("yyyy-MM-dd", this.dataInicialEscolhida)).append("'");
                    buf.append(" AND req.req_dtfatura <= '").append(Funcoes.formataData("yyyy-MM-dd", this.dataFinalEscolhida)).append("'");
                }
            }
            buf.append(") as consumoPoliticaCotaUnidadeSaude, ");
            buf.append("COALESCE(cus.cus_qtdeexame,0) as quantidadeExames, ");
            buf.append("uns.uns_descricao as descricaoUnidadeSaude, ");
            buf.append("uns.uns_codigo as codigoUnidadeSaude ");
            buf.append("FROM  convenios con ");
            buf.append("JOIN filiais_postocoleta fpc ON con.fil_codigo = fpc.fil_codigo ");
            buf.append("LEFT JOIN requisicao req ON ");
            buf.append("req.fil_codigo = con.fil_codigo AND ");
            buf.append("req.con_codigo = con.con_codigo ");
            buf.append("LEFT JOIN  conveniounidadesaude cus ON con.fil_codigo = cus.fil_codigo ");
            buf.append("AND con.con_codigo = cus.con_codigo ");
            buf.append("LEFT JOIN  unidadesaude us ON cus.fil_codigo = us.fil_codigo ");
            buf.append("AND cus.uns_codigo = us.uns_codigo ");
            buf.append("LEFT JOIN unidadesaude uns ON uns.fil_codigo = cus.fil_codigo ");
            buf.append("AND uns.uns_codigo = cus.uns_codigo ");
            StringBuilder bufWhere = new StringBuilder();
            bufWhere.append("WHERE con.fil_codigo ");
            String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
            if (filiais == null || filiais.length == 0) {
                bufWhere.append("= ").append(Variaveis.filialPadrao);
            } else {
                bufWhere.append(" in (");
                for (int i = 0; i < filiais.length; ++i) {
                    bufWhere.append(filiais[i]);
                    if (i >= filiais.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            var.put("filtroFilial", this.getSelecionadosFiltro("filtroFilial", 0));
            String[] convenio = this.getSelecionadosFiltro("filtroConvenio", 0);
            if (convenio != null) {
                bufWhere.append(" AND con.con_codigo IN(");
                for (int i = 0; i < convenio.length; ++i) {
                    bufWhere.append(convenio[i]);
                    if (i >= convenio.length - 1) continue;
                    bufWhere.append(",");
                }
                bufWhere.append(")");
            }
            var.put("filtroConvenio", this.getSelecionadosFiltro("filtroConvenio", 0));
            String politica = this.getFiltroCombo("filtroPolitica").toString();
            if (!politica.equals("Todas")) {
                bufWhere.append(" AND con.con_tipopolitica = '").append(this.retornaTipoPolitica(politica)).append("'");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                if (tipoDataEscolhida.equals(this.tipoData[0])) {
                    bufWhere.append(" AND req.req_data >= '").append(Funcoes.formataData("yyyy-MM-dd", this.dataInicialEscolhida)).append("'");
                    bufWhere.append(" AND req.req_data <= '").append(Funcoes.formataData("yyyy-MM-dd", this.dataFinalEscolhida)).append("'");
                } else if (tipoDataEscolhida.equals(this.tipoData[1])) {
                    bufWhere.append(" AND req.req_dtfatura >= '").append(Funcoes.formataData("yyyy-MM-dd", this.dataInicialEscolhida)).append("'");
                    bufWhere.append(" AND req.req_dtfatura <= '").append(Funcoes.formataData("yyyy-MM-dd", this.dataFinalEscolhida)).append("'");
                }
            }
            buf.append(bufWhere.toString());
            String ordemEscolhida = this.getFiltroCombo("ordemRelatorio").toString();
            buf.append(" ORDER BY fpc.fil_codigo, ");
            if (this.getFiltroCombo("filtroPolitica").toString().equals("Unidade de Sa\u00fade")) {
                if (ordemEscolhida != null) {
                    buf.append("con.con_codigo, ");
                    if (ordemEscolhida.equals(this.ordem[0])) {
                        buf.append("uns.uns_codigo");
                    } else if (ordemEscolhida.equals(this.ordem[1])) {
                        buf.append("uns.uns_descricao");
                    }
                }
            } else if (ordemEscolhida != null) {
                if (ordemEscolhida.equals(this.ordem[0])) {
                    buf.append("con.con_codigo");
                } else if (ordemEscolhida.equals(this.ordem[1])) {
                    buf.append("con.con_fantasia");
                }
            }
            if ((rs = Conexao.executeQuery(st, buf.toString())).next()) {
                ModeloGridTable modelo = new ModeloGridTable(this.campos);
                do {
                    Object[] o = new Object[this.campos.length];
                    for (int i = 0; i < this.campos.length; ++i) {
                        java.util.Date dataAtual;
                        DateTime dateFinal;
                        DateTime dateInicial;
                        String periodoCotaCredito;
                        if (this.campos[i].equals("consumoPoliticaCotaConvenio") && rs.getString("con_tipopolitica").equals("C")) {
                            periodoCotaCredito = "";
                            if (!Funcoes.textoVazio(this.dataInicialEscolhida) && !Funcoes.textoVazio(this.dataFinalEscolhida)) {
                                dateInicial = new DateTime((Object)Funcoes.stringToDate(this.dataInicialEscolhida));
                                dateFinal = new DateTime((Object)Funcoes.stringToDate(this.dataFinalEscolhida));
                                dataAtual = Funcoes.getDataHoraAtual();
                                if (dateInicial.getMonthOfYear() == dateFinal.getMonthOfYear() && DateTime.now().getMonthOfYear() == dateInicial.getMonthOfYear() && DateTime.now().getYear() == dateInicial.getYear()) {
                                    periodoCotaCredito = "M";
                                }
                            }
                            o[i] = RelatorioAnaliticoCotaConvenio.getUtilizadoPoliticaCota(filiais, rs.getString("codigoConvenio"), rs.getString("codigoFilial"), periodoCotaCredito, this.dataInicialEscolhida, this.dataFinalEscolhida);
                            continue;
                        }
                        if (this.campos[i].equals("consumoPoliticaCreditoConvenio") && rs.getString("con_tipopolitica").equals("T")) {
                            periodoCotaCredito = "";
                            if (!Funcoes.textoVazio(this.dataInicialEscolhida) && !Funcoes.textoVazio(this.dataFinalEscolhida)) {
                                dateInicial = new DateTime((Object)Funcoes.stringToDate(this.dataInicialEscolhida));
                                dateFinal = new DateTime((Object)Funcoes.stringToDate(this.dataFinalEscolhida));
                                dataAtual = Funcoes.getDataHoraAtual();
                                if (dateInicial.getMonthOfYear() == dateFinal.getMonthOfYear() && DateTime.now().getMonthOfYear() == dateInicial.getMonthOfYear() && DateTime.now().getYear() == dateInicial.getYear()) {
                                    periodoCotaCredito = "M";
                                }
                            }
                            o[i] = RelatorioAnaliticoCotaConvenio.getUtilizadoPoliticaCredito(filiais, rs.getString("codigoConvenio"), rs.getString("codigoFilial"), periodoCotaCredito, this.dataInicialEscolhida, this.dataFinalEscolhida);
                            continue;
                        }
                        if (this.campos[i].equals("valorCota")) {
                            if (rs.getString("con_tipopolitica").equals("C")) {
                                o[i] = rs.getDouble("valorCotaConvenio") * (double)(rs.getInt("qtdMeses") + 1);
                                continue;
                            }
                            if (rs.getString("con_tipopolitica").equals("T")) {
                                o[i] = rs.getDouble("valorCreditoConvenio") * (double)(rs.getInt("qtdMeses") + 1);
                                continue;
                            }
                            if (rs.getString("con_tipopolitica").equals("U")) {
                                o[i] = rs.getInt("quantidadeExames");
                                continue;
                            }
                            o[i] = 0.0;
                            continue;
                        }
                        if (this.campos[i].equals("valorCotaAtual") && rs.getString("con_tipopolitica").equals("C")) {
                            o[i] = RelatorioAnaliticoCotaConvenio.getUtilizadoPoliticaCota(filiais, rs.getString("codigoConvenio"), rs.getString("codigoFilial"), "M", "", "");
                            if (rs.getInt("valorCotaConvenio") - (Integer)o[i] < 0) {
                                o[i] = 0.0;
                                continue;
                            }
                            o[i] = rs.getDouble("valorCotaConvenio") - (double)((Integer)o[i]).intValue();
                            continue;
                        }
                        if (this.campos[i].equals("valorCotaAtual") && rs.getString("con_tipopolitica").equals("T")) {
                            o[i] = RelatorioAnaliticoCotaConvenio.getUtilizadoPoliticaCredito(filiais, rs.getString("codigoConvenio"), rs.getString("codigoFilial"), "M", "", "");
                            if (rs.getDouble("valorCreditoConvenio") - (Double)o[i] < 0.0) {
                                o[i] = 0.0;
                                continue;
                            }
                            o[i] = rs.getDouble("valorCreditoConvenio") - (Double)o[i];
                            continue;
                        }
                        o[i] = this.campos[i].equals("valorCotaConvenio") ? Double.valueOf(rs.getDouble("valorCotaConvenio") * (double)(rs.getInt("qtdMeses") + 1)) : (this.campos[i].equals("valorCreditoConvenio") ? Double.valueOf(rs.getDouble("valorCreditoConvenio") * (double)(rs.getInt("qtdMeses") + 1)) : (this.campos[i].equals("saldoPoliticaCotaUnidadeSaude") ? Integer.valueOf(rs.getInt("quantidadeExames") - rs.getInt("consumoPoliticaCotaUnidadeSaude")) : rs.getObject(this.campos[i])));
                    }
                    modelo.addLine(o);
                } while (rs.next());
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioAnaliticoCotaConvenio.getModuloAcesso(this.getFiltroCombo("filtroPolitica").toString()));
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioAnaliticoCotaConvenio.this.panelCentro.removeAll();
                            RelatorioAnaliticoCotaConvenio.this.panelCentro.repaint();
                            RelatorioAnaliticoCotaConvenio.this.habilitaBotaoImprimir(true);
                        }
                    });
                    var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                    var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                    var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                    var.put("filtroPolitica", politica);
                    var.put("tipoData", tipoDataEscolhida);
                    Relatorio rel = new Relatorio(modelo, var, ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                    rel.setConfiguracao(rs.getString("rel_xml"));
                    gerador.executar(rel);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RelatorioAcumuladoConvenios");
        }
        Conexao.fecharStatement(st);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static Double getUtilizadoPoliticaCredito(String[] filial, String codigoConvenio, String codigoFilial, String zerarPolitica, String dataInicial, String dataFinal) {
        ResultSet rs;
        if (codigoConvenio == null || zerarPolitica == null) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o \u00e9 poss\u00edvel buscar o cr\u00e9dito utilizado do conv\u00eanio.", 2);
            return 0.0;
        }
        Date dataFatura = null;
        if (zerarPolitica.equalsIgnoreCase("F")) {
            StringBuilder buf = new StringBuilder();
            buf.append(" select MAX(fat_datahora) as data ");
            buf.append("   from fatura ");
            buf.append("  where con_codigo = ").append(codigoConvenio);
            buf.append("  and fil_codigo = ").append(codigoFilial);
            try {
                ResultSet rs2 = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
                if (rs2.next()) {
                    dataFatura = rs2.getDate("data");
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar a data da \u00faltima fatura do convenio.\n" + e.getMessage(), e.getStackTrace());
                return 0.0;
            }
        }
        boolean isConsiderarAgendamentoCota = false;
        StringBuilder buf = new StringBuilder();
        buf.append(" select con_usaragendamentopolitica ");
        buf.append("   from convenios ");
        buf.append("  where con_codigo = ").append(codigoConvenio);
        buf.append("  and fil_codigo = ").append(codigoFilial);
        try {
            rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
            if (rs.next()) {
                isConsiderarAgendamentoCota = rs.getBoolean("con_usaragendamentopolitica");
            }
        }
        catch (SQLException sqle) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar as informa\u00e7\u00f5es do conv\u00eanio.\n" + sqle.getMessage(), sqle.getStackTrace());
        }
        buf.setLength(0);
        buf.append(" select SUM(calculaprecototalexamerequisicao(req.fil_codigo, req.con_codigo, req.req_codigo, exr.exa_codigo, exr.mco_codigo, false, true, true, exr.exr_vlrchexame, exr.exr_vlrch, exr.exr_valorporte, exr.exr_valorcusto, exr.exr_valoruco, exr.exr_vlrbalcaoconvenio, exr.exr_datafatura IS NOT NULL OR exr.usr_codfatura IS NOT NULL, exr.exr_vlrmaterial, exr.exr_vlrbalcaoconvenio, con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", exr.met_codigo").append(")) as valor ");
        buf.append("   from requisicao req ");
        buf.append("   join examerequisicao exr on req.fil_codigo = exr.fil_codigo and req.req_codigo = exr.req_codigo ");
        buf.append("   join convenios con on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
        if (isConsiderarAgendamentoCota) {
            buf.append(" left join agendamento a on req.fil_codigo = a.fil_codigo and req.req_codigo = a.req_codigo and a.agd_datahoracancelamento IS NULL ");
        }
        buf.append("  where req.con_codigo = ").append(codigoConvenio);
        buf.append("  and req.fil_codigo = ").append(codigoFilial);
        buf.append("    and not req.req_excluida ");
        buf.append("    and not exr.exr_excluido");
        if (zerarPolitica.equalsIgnoreCase("F")) {
            buf.append("    and exr.exr_datafatura is null ");
        }
        if (zerarPolitica.equalsIgnoreCase("M")) {
            buf.append("    and date_trunc('month', req.req_data) = cast('").append(Funcoes.formataData("yyyy-MM", new java.util.Date())).append("-01' as timestamp) ");
        } else if (dataInicial.length() > 0 && dataFinal.length() > 0) {
            buf.append("    and req.req_dtfatura >= '").append(Funcoes.formataData("yyyy-MM-dd", dataInicial)).append("' ");
            buf.append("    and req.req_dtfatura <= '").append(Funcoes.formataData("yyyy-MM-dd", dataFinal)).append("' ");
        } else if (dataFatura != null) {
            buf.append("    and req.req_dtfatura >= '").append(Funcoes.formataData("yyyy-MM-dd", dataFatura)).append("' ");
        }
        try {
            rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
            BigDecimal aux = BigDecimal.ZERO;
            if (rs.next()) {
                return rs.getDouble("valor");
            }
            return 0.0;
        }
        catch (SQLException sqle) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar o valor de cr\u00e9dito dispon\u00edvel do conv\u00eanio.\n" + sqle.getMessage(), sqle.getStackTrace());
            return 0.0;
        }
    }

    private Object retornaTipoPolitica(String politica) {
        String tipoPolitica = "";
        switch (politica) {
            case "Cota": {
                tipoPolitica = "C";
                break;
            }
            case "Cr\u00e9dito": {
                tipoPolitica = "T";
                break;
            }
            case "Nenhuma": {
                tipoPolitica = "N";
                break;
            }
            case "Unidade de Sa\u00fade": {
                tipoPolitica = "U";
                break;
            }
        }
        return tipoPolitica;
    }

    public static Integer getUtilizadoPoliticaCota(String[] filial, String codigoConvenio, String codigoFilial, String zerarPolitica, String dataInicial, String dataFinal) {
        ResultSet rs;
        if (codigoConvenio == null || zerarPolitica == null) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o \u00e9 poss\u00edvel buscar a cota utilizada do conv\u00eanio. 1", 2);
            return 0;
        }
        boolean isConsiderarAgendamentoCota = false;
        StringBuilder buf = new StringBuilder();
        buf.append(" select con_usaragendamentopolitica ");
        buf.append(" from convenios ");
        buf.append(" where con_codigo = ").append(codigoConvenio);
        buf.append(" and fiL_codigo = ").append(codigoFilial);
        try {
            rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
            if (rs.next()) {
                isConsiderarAgendamentoCota = rs.getBoolean("con_usaragendamentopolitica");
            }
        }
        catch (SQLException sqle) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar as informa\u00e7\u00f5es do conv\u00eanio.\n" + sqle.getMessage(), sqle.getStackTrace());
        }
        if (zerarPolitica.equalsIgnoreCase("M")) {
            buf.setLength(0);
            buf.append(" select COUNT(1) as qtde ");
            buf.append("   from requisicao r");
            if (isConsiderarAgendamentoCota) {
                buf.append(" left join agendamento a on r.fil_codigo = a.fil_codigo and r.req_codigo = a.req_codigo and a.agd_datahoracancelamento IS NULL ");
            }
            buf.append("  where r.con_codigo = ").append(codigoConvenio);
            buf.append(" and r.fiL_codigo = ").append(codigoFilial);
            buf.append("    and date_trunc('month', req_data) = cast('").append(Funcoes.formataData("yyyy-MM", new java.util.Date())).append("-01' as timestamp) ");
            buf.append("    and not r.req_excluida ");
            try {
                rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
                if (rs.next()) {
                    return rs.getInt("qtde");
                }
                return 0;
            }
            catch (SQLException sqle) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar a cota utilizada do conv\u00eanio.\n" + sqle.getMessage(), sqle.getStackTrace());
                return 0;
            }
        }
        buf.setLength(0);
        buf.append(" select MAX(fat_datahora) as data ");
        buf.append("   from fatura ");
        buf.append("  where con_codigo = ").append(codigoConvenio);
        buf.append(" and fiL_codigo = ").append(codigoFilial);
        buf.append("    and fat_datacancelamento IS NULL ");
        try {
            rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
            if (rs.next() || dataInicial.length() > 0 && dataFinal.length() > 0) {
                Date dataFatura = rs.getDate("data");
                buf.setLength(0);
                buf.append(" select COUNT(1) as qtde ");
                buf.append("   from requisicao a ");
                buf.append("   left join faturarequisicao b on a.fil_codigo = b.fil_kodigo and a.req_codigo = b.req_codigo ");
                buf.append("   left join fatura c on b.fil_codigo = c.fil_codigo and b.fat_codigo = c.fat_codigo ");
                if (isConsiderarAgendamentoCota) {
                    buf.append(" left join agendamento agend on a.fil_codigo = agend.fil_codigo and a.req_codigo = agend.req_codigo and agend.agd_datahoracancelamento IS NULL ");
                }
                buf.append("  where a.con_codigo = ").append(codigoConvenio);
                buf.append(" and a.fiL_codigo = ").append(codigoFilial);
                buf.append("    and not a.req_excluida");
                buf.append("    and c.fat_datacancelamento is null ");
                buf.append("    and b.req_codigo is null ");
                if (dataInicial.length() > 0 && dataFinal.length() > 0) {
                    buf.append("    and a.req_dtfatura >= '").append(Funcoes.formataData("yyyy-MM-dd", dataInicial)).append("' ");
                    buf.append("    and a.req_dtfatura <= '").append(Funcoes.formataData("yyyy-MM-dd", dataFinal)).append("' ");
                } else if (dataFatura != null) {
                    buf.append("    and a.req_dtfatura >= '").append(Funcoes.formataData("yyyy-MM-dd", dataFatura)).append("' ");
                }
                rs = Conexao.executeQuery(Conexao.getStatement(), buf.toString());
                if (rs.next()) {
                    return rs.getInt("qtde");
                }
                return 0;
            }
            return 0;
        }
        catch (SQLException sqle) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar a cota utilizada do conv\u00eanio. \n" + sqle.getMessage(), sqle.getStackTrace());
            return 0;
        }
    }
}

