/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.gerencial;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.laboratorio.relatorios.util.RelatorioUtil;
import jalis.relatorio.Gerador;
import jalis.relatorio.gerador.Relatorio;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;

public class RelatorioAnaliticoConvenios
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String[] ordem = new String[]{"C\u00f3digo", "Raz\u00e3o Social", "Fantasia", "Quantidade", "Qtde decrescente", "Valor exame", "Valor exame decrescente"};
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_COLETA = "filtroColeta";
    private final String FILTRO_DESTINO = "filtroDestino";
    private final String FILTRO_SETOR = "filtroSetor";
    private final String FILTRO_GRUPO = "filtroGrupo";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_AGRUPAR_FILIAIS = "filtroAgruparFiliais";
    protected static String[] campos;
    protected static String[] camposEspeciais;

    public RelatorioAnaliticoConvenios() {
        campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"valorTotalExameComDesconto", "codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio", "valorExame", "valorMaterial", "valorCH", "valorTotalExame", "quantidadeExames", "quantidadeRequisicoes", "quantidadeExamesRealizados", "valorCHOriginal", "valorCustoSimplesExameHistorico", "valorCustoSimplesExameAtual"});
        camposEspeciais = new String[]{"quantidadeTotalRequisicoes", "quantidadeTotalExames", "percentualRequisicoes", "percentualExames", "somatorioExames"};
        this.montaBarraDescricao("Relat\u00f3rio acumulado por conv\u00eanios", "Listagem de quantidade de exames e requisi\u00e7\u00f5es no per\u00edodo", "relatorios/rel_gerencial_analitico_acumulado_convenio.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroColeta", "Coleta", "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroDestino", "Destino", "destino", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroGrupo", "Grupo", "grupo", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"grp_codigo", "grp_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroSetor", "Setor", "setores", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.adicionaFiltroCheck("filtroAgruparFiliais", "Agrupar Filiais", true);
        this.setModuloConfigurar(this.getModuloConfigurar());
        this.setModuloAcesso(RelatorioAnaliticoConvenios.getModuloAcesso());
        this.setCamposConfigurador(ArraysUtil.concatenar(campos, camposEspeciais));
    }

    @Override
    public void imprimirPressionado() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        StringBuilder situacoesExamesRealizados = new StringBuilder();
        situacoesExamesRealizados.append("('");
        situacoesExamesRealizados.append("P").append("', '");
        situacoesExamesRealizados.append("L").append("', '");
        situacoesExamesRealizados.append("C").append("', '");
        situacoesExamesRealizados.append("I").append("', '");
        situacoesExamesRealizados.append("E");
        situacoesExamesRealizados.append("') ");
        try {
            String[] setor;
            String[] destinos;
            String[] coletas;
            String[] grupos;
            StringBuilder buf = new StringBuilder();
            buf.append("select count(a.exa_codigo) as quantidadeExames, ");
            buf.append("sum(case when a.exr_situacao IN ").append((CharSequence)situacoesExamesRealizados).append(" then 1 else 0 end) as quantidadeExamesRealizados, ");
            buf.append("sum(calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo, true, false, false, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, d.con_precosdiferenciados, d.con_reajuste, d.con_cobrmaterial, d.con_percpgtomaterial, d.con_percpgto, d.con_tpcalcfatu, d.con_tpcalcch, d.con_perguntarpercbalcao, d.con_acrescimo, d.con_bonus, d.tpe_codigo, d.con_acrescimoporte, d.con_acrescimouco, d.con_descontoporte, d.con_descontouco, d.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", a.met_codigo").append(")) as valorExame, ");
            buf.append("sum(calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo, true, false, true, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, d.con_precosdiferenciados, d.con_reajuste, d.con_cobrmaterial, d.con_percpgtomaterial, d.con_percpgto, d.con_tpcalcfatu, d.con_tpcalcch, d.con_perguntarpercbalcao, d.con_acrescimo, d.con_bonus, d.tpe_codigo, d.con_acrescimoporte, d.con_acrescimouco, d.con_descontoporte, d.con_descontouco, d.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", a.met_codigo").append(")) as valorTotalExame, ");
            buf.append("sum(a.exr_vlrmaterial) as valorMaterial, ");
            buf.append("sum(a.exr_vlrchexame) as valorCHOriginal, ");
            buf.append("sum(calculachexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo)) as valorCH, ");
            buf.append("d.con_fantasia as fantasiaConvenio, ");
            buf.append("d.con_codigo as codigoConvenio, ");
            buf.append("d.con_razao as razaoSocialConvenio, ");
            buf.append("d.con_percpgto as percentualConvenio, ");
            buf.append("sum(a.exr_custosimples) as valorCustoSimplesExameHistorico, ");
            buf.append("sum(h.emc_custosimples) as valorCustoSimplesExameAtual, ");
            buf.append("0 as somatorioExames, ");
            buf.append("0 as quantidadeRequisicoes ");
            buf.append(" ,Sum(Round((Calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo ");
            buf.append("    ,b.req_codigo, a.exa_codigo, a.mco_codigo, false, d.con_percpgto < 100, true, a.exr_vlrchexame ");
            buf.append("    ,a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco ");
            buf.append("    ,a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial ");
            buf.append("    ,a.exr_vlrbalcaoconvenio, d.con_precosdiferenciados, d.con_reajuste, d.con_cobrmaterial ");
            buf.append("    ,d.con_percpgtomaterial,d.con_percpgto, d.con_tpcalcfatu, d.con_tpcalcch ");
            buf.append("    ,d.con_perguntarpercbalcao,d.con_acrescimo, d.con_bonus, d.tpe_codigo, d.con_acrescimoporte ");
            buf.append("    ,d.con_acrescimouco,d.con_descontoporte, d.con_descontouco, d.con_valorch ");
            buf.append("    ,").append(ParametrosGerais.getCasasPrecoExame());
            buf.append("    ,").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal());
            buf.append("    ,false, a.met_codigo)) ");
            buf.append("    ,").append(ParametrosGerais.getCasasPrecoExame());
            buf.append("    ,").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(")) AS valorTotalExameComDesconto ");
            if (!this.getFiltroCheck("filtroAgruparFiliais") || this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
                buf.append(",").append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            }
            buf.append("from examerequisicao a ");
            buf.append("join requisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            buf.append("left join exames c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo ");
            buf.append("left join convenios d on a.fil_codigo = d.fil_codigo and b.con_codigo = d.con_codigo ");
            buf.append("left join examesetor e on a.fil_codigo = e.fil_codigo and a.exa_codigo = e.exa_codigo and e.ese_default = true ");
            buf.append("left join examematgrupo g on a.fil_codigo = g.fil_codigo and a.exa_codigo = g.exa_codigo and a.mco_codigo = g.mco_codigo ");
            buf.append("left join setores f on e.fil_codigo = f.fil_codigo and e.set_codigo = f.set_codigo ");
            buf.append("left join examematcoleta h on a.fil_codigo = h.fil_codigo and a.exa_codigo = h.exa_codigo and a.mco_codigo = h.mco_codigo ");
            if (!this.getFiltroCheck("filtroAgruparFiliais") || this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            }
            StringBuilder bufWhere = new StringBuilder();
            bufWhere.append("where a.fil_codigo ");
            String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
            if (filiais == null || filiais.length == 0) {
                bufWhere.append(" = ").append(Variaveis.filialPadrao);
            } else {
                bufWhere.append(" in (");
                for (int i = 0; i < filiais.length; ++i) {
                    bufWhere.append(filiais[i]);
                    if (i >= filiais.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            String[] convenio = this.getSelecionadosFiltro("filtroConvenio", 0);
            if (convenio != null) {
                bufWhere.append(" and b.con_codigo in (");
                for (int i = 0; i < convenio.length; ++i) {
                    bufWhere.append(convenio[i]);
                    if (i >= convenio.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((grupos = this.getSelecionadosFiltro("filtroGrupo", 0)) != null) {
                bufWhere.append(" and g.grp_codigo in (");
                for (int i = 0; i < grupos.length; ++i) {
                    bufWhere.append("'");
                    bufWhere.append(grupos[i]);
                    bufWhere.append("'");
                    if (i >= grupos.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((coletas = this.getSelecionadosFiltro("filtroColeta", 0)) != null) {
                bufWhere.append(" and b.col_codigo in (");
                for (int i = 0; i < coletas.length; ++i) {
                    bufWhere.append("'");
                    bufWhere.append(coletas[i]);
                    bufWhere.append("'");
                    if (i >= coletas.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((destinos = this.getSelecionadosFiltro("filtroDestino", 0)) != null) {
                bufWhere.append(" and b.des_codigo in (");
                for (int i = 0; i < destinos.length; ++i) {
                    bufWhere.append("'");
                    bufWhere.append(destinos[i]);
                    bufWhere.append("'");
                    if (i >= destinos.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((setor = this.getSelecionadosFiltro("filtroSetor", 0)) != null) {
                bufWhere.append(" and e.set_codigo in (");
                for (int i = 0; i < setor.length; ++i) {
                    bufWhere.append(setor[i]);
                    if (i >= setor.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                bufWhere.append(" and b.req_data >= '");
                bufWhere.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial")));
                bufWhere.append("'");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                bufWhere.append(" and b.req_data <= '");
                bufWhere.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataFinal")));
                bufWhere.append("'");
            }
            bufWhere.append(" and b.req_excluida = false and a.exr_excluido = false ");
            buf.append(bufWhere.toString());
            buf.append(" group by d.con_fantasia, d.con_codigo, d.con_razao, d.con_percpgto ");
            if (!this.getFiltroCheck("filtroAgruparFiliais") || this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
                buf.append(",filial.fil_codigo, ");
                buf.append("filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, ");
                buf.append("filial.fil_complemento, filial.fil_cep, filial.fil_fone, filial.fil_cnes, ");
                buf.append("filial.fil_fax, filial.fil_razaosocial, cidadefilial.cid_codigo, ");
                buf.append("cidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo, ");
                buf.append("bairrofilial.bai_descricao ");
            }
            StringBuilder bufOrder = new StringBuilder("");
            if (!this.getFiltroCheck("filtroAgruparFiliais") || this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
                bufOrder.append(" order by filial.fil_codigo, ");
            }
            if (bufOrder.toString().equals("")) {
                bufOrder.append(" order by ");
            }
            buf.append(bufOrder.toString());
            if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[1])) {
                buf.append("d.con_razao");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[2])) {
                buf.append("d.con_fantasia");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[3])) {
                buf.append("1");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[4])) {
                buf.append("1 desc");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[5])) {
                buf.append("3");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[6])) {
                buf.append("3 desc");
            } else {
                buf.append("d.con_codigo ");
            }
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                Object aux;
                int i;
                int i2;
                ModeloGridTable modelo = new ModeloGridTable(ArraysUtil.concatenar(campos, camposEspeciais));
                do {
                    Object[] o = new Object[campos.length + camposEspeciais.length];
                    String[] filial = new String[]{""};
                    if (this.getFiltroCheck("filtroAgruparFiliais") && filiais != null && filiais.length > 0) {
                        filial = filiais;
                    } else {
                        filial[0] = RelatorioUtil.possuiColuna(rs, "codigoFilial") > 0 ? rs.getString("codigoFilial") : Variaveis.filialPadrao;
                    }
                    HashMap<String, Double> totalizador = this.quantidadeRequisicoes(st2, bufWhere.toString(), rs.getString("codigoConvenio"), coletas, destinos, setor, filial);
                    for (int i3 = 0; i3 < campos.length + camposEspeciais.length; ++i3) {
                        if (i3 >= campos.length) {
                            o[i3] = "";
                            continue;
                        }
                        if (campos[i3].equalsIgnoreCase("valortotalexamecomdesconto")) {
                            Double valorLiquido = 0.0;
                            if (rs.getDouble("percentualConvenio") == 100.0) {
                                valorLiquido = rs.getDouble("valortotalexamecomdesconto") - rs.getDouble("valortotalexamecomdesconto") * 100.0 / rs.getDouble("valortotalexamecomdesconto") * totalizador.get("valorDescontoRequisicao") / 100.0;
                                valorLiquido = valorLiquido + rs.getDouble("valortotalexamecomdesconto") * 100.0 / rs.getDouble("valortotalexamecomdesconto") * totalizador.get("valorAcrescimoRequisicao") / 100.0;
                            }
                            o[i3] = valorLiquido;
                            continue;
                        }
                        if (campos[i3].equals("quantidadeRequisicoes")) {
                            if (filiais == null || filiais.length <= 0) {
                                filial[0] = Variaveis.filialPadrao;
                            } else if (filiais.length == 1) {
                                filial[0] = !this.getFiltroCheck("filtroAgruparFiliais") || this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1 ? rs.getString("codigoFilial") : Variaveis.filialPadrao;
                            }
                            if (filial == null) {
                                o[i3] = 0;
                                continue;
                            }
                            o[i3] = totalizador.get("quantidadeRequisicoes");
                            continue;
                        }
                        if (campos[i3].equals("quantidadeExames") || campos[i3].equals("quantidadeRequisicoes")) {
                            o[i3] = rs.getInt(campos[i3]);
                            continue;
                        }
                        if (RelatorioUtil.possuiColuna(rs, campos[i3]) <= 0) continue;
                        o[i3] = rs.getObject(campos[i3]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                String codigoFilial = Variaveis.filialPadrao;
                if (this.getFiltroCheck("filtroAgruparFiliais") && this.getSelecionadosFiltro("filtroFilial", 0) != null && this.getSelecionadosFiltro("filtroFilial", 0).length > 1) {
                    codigoFilial = this.getSelecionadosFiltro("filtroFilial", 0)[0];
                    Registro regFilial = RelatorioUtil.pegaDadosFilial(st, codigoFilial);
                    RelatorioUtil.preencheDadosFilial(regFilial, modelo);
                }
                ArrayQuantidades arrayQtde = new ArrayQuantidades();
                for (i2 = 0; i2 < modelo.getRowCount(); ++i2) {
                    HashMap<String, Object> aux2 = modelo.getLine(i2);
                    arrayQtde.somaQuantidadeExames((Integer)aux2.get("codigoFilial"), (Integer)aux2.get("quantidadeExames"));
                    arrayQtde.somaQuantidadeRequisicoes((Integer)aux2.get("codigoFilial"), ((Double)aux2.get("quantidadeRequisicoes")).intValue());
                    arrayQtde.somaValorExames((Integer)aux2.get("codigoFilial"), ((BigDecimal)aux2.get("valorExame")).doubleValue());
                }
                for (i2 = 0; i2 < modelo.getRowCount(); ++i2) {
                    QuantidadesFilial aux3 = arrayQtde.buscaFilial((Integer)modelo.getValueAt(i2, modelo.findColumn("codigoFilial")));
                    if (aux3 != null) {
                        modelo.setValueAt(new Integer(aux3.getQuantidadeExames()), i2, modelo.findColumn("quantidadeTotalExames"));
                        modelo.setValueAt(new Integer(aux3.getQuantidadeRequisicoes()), i2, modelo.findColumn("quantidadeTotalRequisicoes"));
                        Float auxFloat = Float.valueOf(((Integer)modelo.getValueAt(i2, modelo.findColumn("quantidadeExames"))).floatValue() * 100.0f / ((Integer)modelo.getValueAt(i2, modelo.findColumn("quantidadeTotalExames"))).floatValue());
                        Double auxDouble = Funcoes.arredondar(auxFloat.floatValue(), 2);
                        modelo.setValueAt(Float.valueOf(auxDouble.floatValue()), i2, modelo.findColumn("percentualExames"));
                        auxFloat = Float.valueOf(((Double)modelo.getValueAt(i2, modelo.findColumn("quantidadeRequisicoes"))).floatValue() * 100.0f / ((Integer)modelo.getValueAt(i2, modelo.findColumn("quantidadeTotalRequisicoes"))).floatValue());
                        auxDouble = Funcoes.arredondar(auxFloat.floatValue(), 2);
                        modelo.setValueAt(Float.valueOf(auxDouble.floatValue()), i2, modelo.findColumn("percentualRequisicoes"));
                        modelo.setValueAt(aux3.getValorExames(), i2, modelo.findColumn("somatorioExames"));
                        continue;
                    }
                    modelo.setValueAt(new Integer(0), i2, modelo.findColumn("quantidadeTotalExames"));
                    modelo.setValueAt(new Integer(0), i2, modelo.findColumn("quantidadeTotalRequisicoes"));
                }
                MathContext mathContext = new MathContext(5, RoundingMode.HALF_UP);
                ArrayQuantidades arrayPerc = new ArrayQuantidades();
                for (i = 0; i < modelo.getRowCount(); ++i) {
                    aux = modelo.getLine(i);
                    BigDecimal auxArred = new BigDecimal(((Float)((HashMap)aux).get("percentualExames")).floatValue(), mathContext);
                    auxArred = auxArred.multiply(new BigDecimal(100, mathContext), mathContext);
                    int perc = auxArred.intValue();
                    arrayPerc.somaQuantidadeExames((Integer)((HashMap)aux).get("codigoFilial"), perc);
                    auxArred = new BigDecimal(((Float)((HashMap)aux).get("percentualRequisicoes")).floatValue(), mathContext);
                    auxArred = auxArred.multiply(new BigDecimal(100, mathContext), mathContext);
                    perc = auxArred.intValue();
                    arrayPerc.somaQuantidadeRequisicoes((Integer)((HashMap)aux).get("codigoFilial"), new Integer(perc));
                }
                block13: for (i = 0; i < arrayPerc.size(); ++i) {
                    aux = arrayPerc.get(i);
                    if (aux == null) continue;
                    Integer percExame = (int)((QuantidadesFilial)aux).getQuantidadeExames();
                    Integer percReq = (int)((QuantidadesFilial)aux).getQuantidadeRequisicoes();
                    percExame = 10000 - percExame;
                    percReq = 10000 - percReq;
                    for (int j = 0; j < modelo.getRowCount(); ++j) {
                        HashMap<String, Object> linha = modelo.getLine(j);
                        int cod = (Integer)linha.get("codigoFilial");
                        if (cod != ((QuantidadesFilial)aux).getFilial()) continue;
                        BigDecimal arred = new BigDecimal(((Float)linha.get("percentualExames")).floatValue(), mathContext);
                        arred = arred.multiply(new BigDecimal(100, mathContext), mathContext);
                        arred = arred.add(new BigDecimal(percExame, mathContext), mathContext);
                        float percExameLinha = arred.divide(new BigDecimal(100, mathContext), mathContext).floatValue();
                        arred = new BigDecimal(((Float)linha.get("percentualRequisicoes")).floatValue(), mathContext);
                        arred = arred.multiply(new BigDecimal(100, mathContext), mathContext);
                        arred = arred.add(new BigDecimal(percReq, mathContext), mathContext);
                        float percReqLinha = arred.divide(new BigDecimal(100, mathContext), mathContext).floatValue();
                        modelo.setValueAt(Float.valueOf(percExameLinha), j, modelo.findColumn("percentualExames"));
                        modelo.setValueAt(Float.valueOf(percReqLinha), j, modelo.findColumn("percentualRequisicoes"));
                        continue block13;
                    }
                }
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioAnaliticoConvenios.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioAnaliticoConvenios.this.panelCentro.removeAll();
                            RelatorioAnaliticoConvenios.this.panelCentro.repaint();
                            RelatorioAnaliticoConvenios.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("filtroAgruparFiliais", this.getFiltroCheck("filtroAgruparFiliais"));
                    var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                    var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                    var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                    buf.delete(0, buf.length());
                    if (filiais != null) {
                        for (int i4 = 0; i4 < filiais.length; ++i4) {
                            buf.append(filiais[i4]);
                            if (i4 >= filiais.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroFilial", buf.toString());
                    buf.delete(0, buf.length());
                    if (convenio != null) {
                        for (int i5 = 0; i5 < convenio.length; ++i5) {
                            buf.append(convenio[i5]);
                            if (i5 >= convenio.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroConvenio", buf.toString());
                    buf.delete(0, buf.length());
                    if (grupos != null) {
                        for (int i6 = 0; i6 < grupos.length; ++i6) {
                            buf.append(grupos[i6]);
                            if (i6 >= grupos.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroGrupo", buf.toString());
                    buf.delete(0, buf.length());
                    if (setor != null) {
                        for (int i7 = 0; i7 < setor.length; ++i7) {
                            buf.append(setor[i7]);
                            if (i7 >= setor.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroSetor", buf.toString());
                    buf.delete(0, buf.length());
                    if (coletas != null) {
                        for (int i8 = 0; i8 < coletas.length; ++i8) {
                            buf.append(coletas[i8]);
                            if (i8 >= coletas.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroColeta", buf.toString());
                    buf.delete(0, buf.length());
                    if (destinos != null) {
                        for (int i9 = 0; i9 < destinos.length; ++i9) {
                            buf.append(destinos[i9]);
                            if (i9 >= destinos.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroDestino", buf.toString());
                    Relatorio rel = new Relatorio(modelo, var, ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                    rel.setConfiguracao(rs.getString("rel_xml"));
                    if (filiais == null || filiais.length <= 1 || this.getFiltroCheck("filtroAgruparFiliais")) {
                        rel.removerBandaCabecalhoGrupo("BandaFilial");
                    }
                    gerador.executar(rel);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RelatorioAcumuladoConvenios");
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private HashMap<String, Double> quantidadeRequisicoes(Statement st, String filtro, String convenio, String[] coletas, String[] destinos, String[] setores, String[] filial) throws Exception {
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append("select ");
        buf.append("distinct ");
        buf.append(" b.req_codigo as quantidadeRequisicoes, ");
        buf.append(" b.req_vlrdesconto as valorDescontoRequisicao, ");
        buf.append(" b.req_vlracrescimo as valorAcrescimoRequisicao ");
        buf.append("from requisicao b ");
        buf.append("join examerequisicao c on b.fil_codigo = c.fil_codigo and b.req_codigo = c.req_codigo and c.exr_excluido = false ");
        if (setores != null) {
            buf.append("join examesetor d on c.fil_codigo = d.fil_codigo and c.exa_codigo = d.exa_codigo and d.ese_default = true ");
        }
        if (filial == null) {
            buf.append("where b.fil_codigo IN (").append(Variaveis.filialPadrao).append(")");
        } else if (filial.length > 1) {
            buf.append("where b.fil_codigo IN (");
            for (i = 0; i < filial.length; ++i) {
                buf.append(filial[i]);
                if (i >= filial.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
        } else if (filial.length == 1) {
            buf.append("where b.fil_codigo = ").append(filial[0]);
        }
        if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
            buf.append(" and b.req_data >= '");
            buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial")));
            buf.append("'");
        }
        if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
            buf.append(" and b.req_data <= '");
            buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal")));
            buf.append("'");
        }
        if (!Funcoes.textoVazio(convenio)) {
            buf.append(" and b.con_codigo = ");
            buf.append(convenio);
        }
        if (coletas != null) {
            buf.append(" and b.col_codigo in (");
            for (i = 0; i < coletas.length; ++i) {
                buf.append("'");
                buf.append(coletas[i]);
                buf.append("'");
                if (i >= coletas.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (destinos != null) {
            buf.append(" and b.des_codigo in (");
            for (i = 0; i < destinos.length; ++i) {
                buf.append("'");
                buf.append(destinos[i]);
                buf.append("'");
                if (i >= destinos.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (setores != null) {
            buf.append(" and d.set_codigo in (");
            for (i = 0; i < setores.length; ++i) {
                buf.append(setores[i]);
                if (i >= setores.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        buf.append(" and b.req_excluida = false ");
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        int retorno = 0;
        BigDecimal percentualDesconto = BigDecimal.ZERO;
        BigDecimal valorDesconto = BigDecimal.ZERO;
        BigDecimal valorAcrescimo = BigDecimal.ZERO;
        BigDecimal percentualAcrescimo = BigDecimal.ZERO;
        HashMap<String, Double> campos = new HashMap<String, Double>();
        while (rs.next()) {
            ++retorno;
            valorDesconto = valorDesconto.add(rs.getBigDecimal("valorDescontoRequisicao"));
            valorAcrescimo = valorAcrescimo.add(rs.getBigDecimal("valorAcrescimoRequisicao"));
        }
        if (percentualDesconto.compareTo(BigDecimal.ZERO) > 0) {
            percentualDesconto = percentualDesconto.divide(new BigDecimal(retorno), ParametrosGerais.getArredondamentoPrecoExame()).setScale(percentualDesconto.scale());
        }
        if (percentualAcrescimo.compareTo(BigDecimal.ZERO) > 0) {
            percentualAcrescimo = percentualAcrescimo.divide(new BigDecimal(retorno), ParametrosGerais.getArredondamentoPrecoExame()).setScale(percentualAcrescimo.scale());
        }
        campos.put("quantidadeRequisicoes", new Double(retorno));
        campos.put("valorAcrescimoRequisicao", valorAcrescimo.doubleValue());
        campos.put("valorDescontoRequisicao", valorDesconto.doubleValue());
        rs.close();
        return campos;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0880400100");
    }

    private long getModuloConfigurar() {
        return Long.parseLong("0880400101");
    }

    private class ArrayQuantidades {
        private final ArrayList<QuantidadesFilial> arrayQuantidades = new ArrayList();

        private ArrayQuantidades() {
        }

        public int size() {
            return this.arrayQuantidades.size();
        }

        public QuantidadesFilial get(int i) {
            if (i < this.arrayQuantidades.size()) {
                return this.arrayQuantidades.get(i);
            }
            return null;
        }

        public QuantidadesFilial buscaFilial(Integer filial) {
            for (int i = 0; i < this.arrayQuantidades.size(); ++i) {
                if (this.arrayQuantidades.get(i).getFilial().intValue() != filial.intValue()) continue;
                return this.arrayQuantidades.get(i);
            }
            return null;
        }

        public void somaQuantidadeRequisicoes(Integer filial, Integer qtde) {
            QuantidadesFilial aux = this.buscaFilial(filial);
            if (aux == null) {
                this.arrayQuantidades.add(new QuantidadesFilial(filial, qtde, 0, 0.0));
            } else {
                aux.somaRequisicoes(qtde);
            }
        }

        public void somaQuantidadeExames(Integer filial, Integer qtde) {
            QuantidadesFilial aux = this.buscaFilial(filial);
            if (aux == null) {
                this.arrayQuantidades.add(new QuantidadesFilial(filial, 0, qtde, 0.0));
            } else {
                aux.somaExames(qtde);
            }
        }

        public void somaValorExames(Integer filial, Double valor) {
            QuantidadesFilial aux = this.buscaFilial(filial);
            if (aux == null) {
                this.arrayQuantidades.add(new QuantidadesFilial(filial, 0, 0, valor));
            } else {
                aux.somaValorExames(valor);
            }
        }
    }

    private class QuantidadesFilial {
        private final Integer filial;
        private Integer quantidadeRequisicoes = 0;
        private Integer quantidadeExames = 0;
        private Double valorExames = 0.0;

        public QuantidadesFilial(Integer filial, Integer quantidadeRequisicoes, Integer quantidadeExames, Double valorExames) {
            this.filial = filial;
            this.quantidadeExames = quantidadeExames;
            this.quantidadeRequisicoes = quantidadeRequisicoes;
            this.valorExames = valorExames;
        }

        public void somaRequisicoes(Integer qtde) {
            QuantidadesFilial quantidadesFilial = this;
            quantidadesFilial.quantidadeRequisicoes = quantidadesFilial.quantidadeRequisicoes + qtde;
        }

        public void somaExames(Integer qtde) {
            QuantidadesFilial quantidadesFilial = this;
            quantidadesFilial.quantidadeExames = quantidadesFilial.quantidadeExames + qtde;
        }

        public void somaValorExames(Double valor) {
            QuantidadesFilial quantidadesFilial = this;
            quantidadesFilial.valorExames = quantidadesFilial.valorExames + valor;
        }

        public Integer getFilial() {
            return this.filial;
        }

        public Integer getQuantidadeExames() {
            return this.quantidadeExames;
        }

        public Integer getQuantidadeRequisicoes() {
            return this.quantidadeRequisicoes;
        }

        public Double getValorExames() {
            return this.valorExames;
        }
    }
}

