/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.gerencial;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.laboratorio.relatorios.util.RelatorioUtil;
import jalis.relatorio.Gerador;
import jalis.relatorio.gerador.Relatorio;
import jalis.util.ArraysUtil;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RelatorioAnaliticoColetas
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String[] ordem = new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"};
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_COLETA = "filtroColeta";
    private final String FILTRO_DESTINO = "filtroDestino";
    private final String FILTRO_SETOR = "filtroSetor";
    private final String FILTRO_GRUPO = "filtroGrupo";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_AGRUPAR_FILIAIS = "filtroAgruparFiliais";
    private final String FILTRO_COMISSAO_DESTINO = "filtroComissaoDestino";
    private final String FILTRO_COMISSAO_COLETA = "filtroComissaoColeta";
    private final String FILTRO_SITUACAO_EXAMES = "filtroSituacaoExame";
    private String[] SITUACOES_EXAMES = new String[]{Tipos.tipoSituacaoExame("T"), Tipos.tipoSituacaoExame("C"), Tipos.tipoSituacaoExame("E"), Tipos.tipoSituacaoExame("F"), Tipos.tipoSituacaoExame("A"), Tipos.tipoSituacaoExame("I"), Tipos.tipoSituacaoExame("L"), Tipos.tipoSituacaoExame("R"), Tipos.tipoSituacaoExame("O"), Tipos.tipoSituacaoExame("P"), Tipos.tipoSituacaoExame("")};
    private static final Long ACESSO_CALCULAR_COMISSAO_COLETA = Long.parseLong("0880400302");
    private static final Long ACESSO_CALCULAR_COMISSAO_DESTINO = Long.parseLong("0880400303");
    private String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoColeta", "descricaoColeta", "valorExameRealizados", "valorExame", "valorMaterial", "valorCH", "valorTotalExame", "valorLiquidoTotalExame", "quantidadeExames", "quantidadeRequisicoes", "quantidadeExamesRealizados", "codigoDestino", "descricaoDestino", "percentualComissaoColeta", "quantidadePacientes", "percentualComissaoDestino", "valorCHOriginal", "valorLiquidoTotalExameComMaterial", "valorCustoSimplesExameHistorico", "valorCustoSimplesExameAtual", "valorTotalDesconto", "valorTotalAcrescimo"});
    protected static String[] camposEspeciais = new String[]{"quantidadeTotalRequisicoes", "quantidadeTotalExames", "percentualRequisicoes", "percentualExames"};
    protected static String[] camposConvenio = new String[]{"codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio", "quantidadeRequisicoesConvenio"};
    public static final int TIPO_SIMPLES = 1;
    public static final int TIPO_DETALHADO = 2;
    public static final int TIPO_CALCULAR_COMISSAO_COLETA = 3;
    public static final int TIPO_CALCULAR_COMISSAO_DESTINO = 4;
    private int tipoRelatorio = 1;
    private JCheckBox checkComissaoColeta = null;
    private JCheckBox checkComissaoDestino = null;

    public RelatorioAnaliticoColetas(int tipoRelatorio) {
        this.tipoRelatorio = tipoRelatorio;
        if (tipoRelatorio == 1) {
            this.montaBarraDescricao("Relat\u00f3rio acumulado por coleta", "Listagem de quantidade de exames e requisi\u00e7\u00f5es no per\u00edodo", "relatorios/rel_gerencial_analitico_acumulado_coleta.jpg");
        } else {
            this.montaBarraDescricao("Relat\u00f3rio acumulado por coleta detalhada", "Listagem de quantidade de exames e requisi\u00e7\u00f5es no per\u00edodo por coleta detalhada", "relatorios/rel_acumulado_por_coleta_detalhada.jpg");
        }
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroColeta", "Coleta", "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroDestino", "Destino", "destino", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroGrupo", "Grupo", "grupo", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"grp_codigo", "grp_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroSetor", "Setor", "setores", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        if (tipoRelatorio == 1) {
            this.adicionaItemFiltro("filtroSituacaoExame", "Situa\u00e7\u00e3o do Exame", this.SITUACOES_EXAMES, new String[]{"Descri\u00e7\u00e3o"});
        }
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.adicionaFiltroCheck("filtroAgruparFiliais", "Agrupar Filiais", true);
        this.checkComissaoColeta = null;
        this.checkComissaoDestino = null;
        if (tipoRelatorio == 2) {
            if (Acesso.getAcesso(ACESSO_CALCULAR_COMISSAO_COLETA)) {
                this.checkComissaoColeta = this.adicionaRetornaFiltroCheck("filtroComissaoColeta", "Calcular comiss\u00e3o coleta", false);
            }
            if (Acesso.getAcesso(ACESSO_CALCULAR_COMISSAO_DESTINO)) {
                this.checkComissaoDestino = this.adicionaRetornaFiltroCheck("filtroComissaoDestino", "Calcular comiss\u00e3o destino", false);
            }
        }
        if (this.checkComissaoColeta != null || this.checkComissaoDestino != null) {
            if (this.checkComissaoColeta != null) {
                this.checkComissaoColeta.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        RelatorioAnaliticoColetas.this.alternaComissaoSelecionada(3);
                    }
                });
            }
            if (this.checkComissaoDestino != null) {
                this.checkComissaoDestino.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        RelatorioAnaliticoColetas.this.alternaComissaoSelecionada(4);
                    }
                });
            }
        }
        this.setModuloConfigurar(this.getModuloConfigurar(tipoRelatorio));
        this.setModuloAcesso(RelatorioAnaliticoColetas.getModuloAcesso(tipoRelatorio));
        this.campos = ArraysUtil.concatenar(this.campos, camposEspeciais);
        if (tipoRelatorio == 1) {
            this.setCamposConfigurador(this.campos);
        } else {
            this.campos = ArraysUtil.concatenar(this.campos, camposConvenio);
            this.setCamposConfigurador(this.campos);
        }
    }

    @Override
    public void imprimirPressionado() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        StringBuilder situacoesExamesRealizados = new StringBuilder();
        situacoesExamesRealizados.append("('");
        situacoesExamesRealizados.append("P").append("', '");
        situacoesExamesRealizados.append("L").append("', '");
        situacoesExamesRealizados.append("C").append("', '");
        situacoesExamesRealizados.append("I").append("', '");
        situacoesExamesRealizados.append("E");
        situacoesExamesRealizados.append("') ");
        try {
            ResultSet rs;
            String[] situacao;
            String[] setor;
            String[] destinos;
            String[] coletas;
            int i;
            String[] grupos = this.getSelecionadosFiltro("filtroGrupo", 0);
            StringBuilder buf = new StringBuilder();
            buf.append("select count(a.exa_codigo) as quantidadeExames, ");
            buf.append("sum(case when a.exr_situacao IN ").append((CharSequence)situacoesExamesRealizados).append(" then 1 else 0 end) as quantidadeExamesRealizados, ");
            String descontoProducao = "";
            String comissao = "";
            if (this.getFiltroCheck("filtroComissaoColeta")) {
                descontoProducao = "*(case when   d.col_descontoproducao is null then 1 else (100.00-  d.col_descontoproducao)/100 end)";
                comissao = ", d.col_comissao ";
            } else if (this.getFiltroCheck("filtroComissaoDestino")) {
                descontoProducao = "*(case when des.des_descontoproducao is null then 1 else (100.00-des.des_descontoproducao)/100 end)";
                comissao = ", des.des_comissao ";
            }
            buf.append("sum(calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo, true, false, false, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", a.met_codigo").append(")").append(descontoProducao).append(") as valorExame, ");
            buf.append("sum((case when a.exr_situacao IN ").append((CharSequence)situacoesExamesRealizados).append(" then calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo, true, false, false, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", a.met_codigo").append(") else 0 end)").append(descontoProducao).append(") as valorExameRealizados, ");
            buf.append("sum(calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo, true, false, true, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", a.met_codigo").append(")").append(descontoProducao).append(") as valorTotalExame, ");
            buf.append("sum(round(calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo, true, false, false, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, " + ParametrosGerais.getCasasPrecoExame() + ", " + ParametrosGerais.getArredondamentoPrecoExame().ordinal() + ", " + (ParametrosGerais.getPrecoMetodologia() ? "true" : "false") + ", a.met_codigo) * ((100 - (b.req_desconto - b.req_acrescimo))/100), " + ParametrosGerais.getCasasPrecoExame() + "))" + descontoProducao + " as valorLiquidoTotalExame, ");
            buf.append("sum(round(calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo, true, false, false, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", a.met_codigo").append(")").append(descontoProducao).append(",").append(ParametrosGerais.getCasasPrecoExame()).append(") + (");
            buf.append("    calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo, true, false, true, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", a.met_codigo").append(") - ");
            buf.append("    calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo, true, false, false, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", a.met_codigo").append("))) as valorLiquidoTotalExameComMaterial, ");
            buf.append("sum(a.exr_vlrmaterial) as valorMaterial, ");
            buf.append("sum(a.exr_vlrchexame) as valorCHOriginal, ");
            buf.append("sum(calculachexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo)) as valorCH, ");
            buf.append("d.col_codigo as codigoColeta, ");
            buf.append("d.col_descricao as descricaoColeta, ");
            buf.append("sum(a.exr_custosimples) as valorCustoSimplesExameHistorico, ");
            buf.append("sum(h.emc_custosimples) as valorCustoSimplesExameAtual, ");
            buf.append("0 as quantidadePacientes, ");
            buf.append(" sum(distinct(b.req_vlrdesconto)) as valorTotalDesconto, ");
            buf.append(" sum(distinct(b.req_vlracrescimo)) as valorTotalAcrescimo, ");
            if (this.getFiltroCheck("filtroComissaoColeta")) {
                buf.append("case when   d.col_comissao is null then 0 else d.col_comissao   end as percentualComissaoColeta, ");
            }
            if (this.getFiltroCheck("filtroComissaoDestino")) {
                buf.append("case when des.des_comissao is null then 0 else des.des_comissao end as percentualComissaoDestino, ");
                buf.append("des.des_codigo as codigoDestino, ");
                buf.append("des.des_descricao as descricaoDestino, ");
            }
            if (this.tipoRelatorio == 2) {
                buf.append("con.con_codigo as codigoConvenio, ");
                buf.append("con.con_razao as razaoSocialConvenio, ");
                buf.append("con.con_fantasia as fantasiaConvenio, ");
            }
            buf.append("0 as quantidadeRequisicoes, ");
            buf.append(" count(distinct cast(b.fil_codigo as text)||b.req_codigo) as quantidadeRequisicoesConvenio ");
            if (!this.getFiltroCheck("filtroAgruparFiliais") || this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
                buf.append(",").append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            }
            buf.append("from examerequisicao a ");
            buf.append("join requisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            buf.append("left join exames c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo ");
            buf.append(" join coletas d on b.fil_codigo = d.fil_codigo and b.col_codigo = d.col_codigo ");
            buf.append("left join examesetor e on a.fil_codigo = e.fil_codigo and a.exa_codigo = e.exa_codigo and e.ese_default = true ");
            buf.append("left join setores f on e.fil_codigo = f.fil_codigo and e.set_codigo = f.set_codigo ");
            if (grupos != null && grupos.length > 0) {
                buf.append("left join examematgrupo g on a.fil_codigo = g.fil_codigo and a.exa_codigo = g.exa_codigo and a.mco_codigo = g.mco_codigo ");
            }
            buf.append("left join convenios con on a.fil_codigo = con.fil_codigo and b.con_codigo = con.con_codigo ");
            buf.append("left join destino des on b.fil_codigo = des.fil_codigo and b.des_codigo = des.des_codigo ");
            buf.append("left join examematcoleta h on a.fil_codigo = h.fil_codigo and a.exa_codigo = h.exa_codigo and a.mco_codigo = h.mco_codigo ");
            if (!this.getFiltroCheck("filtroAgruparFiliais") || this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            }
            StringBuilder bufWhere = new StringBuilder();
            bufWhere.append("where a.fil_codigo ");
            String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
            if (filiais == null || filiais.length == 0) {
                filiais = new String[]{Variaveis.filialPadrao};
                bufWhere.append(" =  ").append(Variaveis.filialPadrao);
            } else {
                bufWhere.append(" in (");
                for (int i2 = 0; i2 < filiais.length; ++i2) {
                    bufWhere.append(filiais[i2]);
                    if (i2 >= filiais.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            String[] convenios = this.getSelecionadosFiltro("filtroConvenio", 0);
            if (convenios != null) {
                bufWhere.append(" and b.con_codigo in (");
                for (i = 0; i < convenios.length; ++i) {
                    bufWhere.append(convenios[i]);
                    if (i >= convenios.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if (grupos != null) {
                bufWhere.append(" and g.grp_codigo in (");
                for (i = 0; i < grupos.length; ++i) {
                    bufWhere.append("'");
                    bufWhere.append(StringUtil.textoDB(grupos[i]));
                    bufWhere.append("'");
                    if (i >= grupos.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((coletas = this.getSelecionadosFiltro("filtroColeta", 0)) != null) {
                bufWhere.append(" and b.col_codigo in (");
                for (int i3 = 0; i3 < coletas.length; ++i3) {
                    bufWhere.append("'");
                    bufWhere.append(StringUtil.textoDB(coletas[i3]));
                    bufWhere.append("'");
                    if (i3 >= coletas.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((destinos = this.getSelecionadosFiltro("filtroDestino", 0)) != null) {
                bufWhere.append(" and b.des_codigo in (");
                for (int i4 = 0; i4 < destinos.length; ++i4) {
                    bufWhere.append("'");
                    bufWhere.append(StringUtil.textoDB(destinos[i4]));
                    bufWhere.append("'");
                    if (i4 >= destinos.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((setor = this.getSelecionadosFiltro("filtroSetor", 0)) != null) {
                bufWhere.append(" and e.set_codigo in (");
                for (int i5 = 0; i5 < setor.length; ++i5) {
                    bufWhere.append(setor[i5]);
                    if (i5 >= setor.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((situacao = this.getSelecionadosFiltroArray("filtroSituacaoExame")) != null) {
                bufWhere.append(" and a.exr_situacao in (");
                for (int i6 = 0; i6 < situacao.length; ++i6) {
                    bufWhere.append(StringUtil.textoDBEscape(Tipos.getCodigoSituacaoExame(situacao[i6])));
                    if (i6 >= situacao.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                bufWhere.append(" and b.req_data >= '");
                bufWhere.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial")));
                bufWhere.append("'");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                bufWhere.append(" and b.req_data <= '");
                bufWhere.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataFinal")));
                bufWhere.append("'");
            }
            bufWhere.append(" and b.req_excluida = false and a.exr_excluido = false ");
            buf.append(bufWhere.toString());
            buf.append(" group by d.col_codigo, d.col_descricao ");
            if (this.tipoRelatorio == 2) {
                buf.append(", con.con_codigo, con.con_razao, con.con_fantasia ").append(comissao);
                if (this.getFiltroCheck("filtroComissaoDestino")) {
                    buf.append(", des.des_codigo, des.des_descricao ");
                }
            }
            if (!this.getFiltroCheck("filtroAgruparFiliais") || this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
                buf.append(",filial.fil_codigo, ");
                buf.append("filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, ");
                buf.append("filial.fil_complemento, filial.fil_cep, filial.fil_fone, filial.fil_cnes, ");
                buf.append("filial.fil_fax, filial.fil_razaosocial, cidadefilial.cid_codigo, ");
                buf.append("cidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo, ");
                buf.append("bairrofilial.bai_descricao");
            }
            StringBuilder bufOrder = new StringBuilder("");
            if (!this.getFiltroCheck("filtroAgruparFiliais") || this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
                bufOrder.append(" order by filial.fil_codigo, ");
            }
            if (bufOrder.toString().equals("")) {
                bufOrder.append(" order by ");
            }
            buf.append(bufOrder.toString());
            if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[0])) {
                buf.append("d.col_codigo ");
            } else {
                buf.append("d.col_descricao ");
            }
            if (this.tipoRelatorio == 2) {
                buf.append(", con.con_codigo, con.con_razao, con.con_fantasia ");
            }
            if ((rs = Conexao.executeQuery(st, buf.toString())).next()) {
                int i7;
                ModeloGridTable modelo = new ModeloGridTable(this.campos);
                do {
                    Object[] o = new Object[this.campos.length];
                    String[] filial = new String[]{" "};
                    if (this.getFiltroCheck("filtroAgruparFiliais") && filiais != null && filiais.length > 0) {
                        filial = filiais;
                    } else {
                        filial[0] = RelatorioUtil.possuiColuna(rs, "codigoFilial") > 0 ? rs.getString("codigoFilial") : Variaveis.filialPadrao;
                    }
                    HashMap<String, Double> totalizador = this.quantidadeRequisicoes(st2, bufWhere.toString(), convenios, rs.getString("codigoColeta"), destinos, setor, filial);
                    for (int i8 = 0; i8 < this.campos.length; ++i8) {
                        if (RelatorioUtil.possuiColuna(rs, this.campos[i8]) < 0) continue;
                        if (this.campos[i8].equals("valorTotalExame") || this.campos[i8].equals("valorExameRealizados")) {
                            BigDecimal valor = new BigDecimal(0);
                            BigDecimal valorDoBanco = DBUtil.campoNull(rs.getString(this.campos[i8])) || rs.getBigDecimal(this.campos[i8]) == null ? new BigDecimal(0) : rs.getBigDecimal(this.campos[i8]);
                            o[i8] = valor.add(valorDoBanco).setScale(2, RoundingMode.HALF_UP);
                            continue;
                        }
                        if (this.campos[i8].equals("quantidadeRequisicoes")) {
                            if (filiais == null || filiais.length <= 0) {
                                filial[0] = Variaveis.filialPadrao;
                            } else if (filiais.length == 1) {
                                filial[0] = !this.getFiltroCheck("filtroAgruparFiliais") || this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1 ? rs.getString("codigoFilial") : Variaveis.filialPadrao;
                            }
                            if (filial == null) {
                                o[i8] = 0;
                                continue;
                            }
                            o[i8] = totalizador.get("quantidadeRequisicoes");
                            continue;
                        }
                        if (this.campos[i8].equals("quantidadeRequisicoesConvenio")) {
                            o[i8] = rs.getInt("quantidadeRequisicoesConvenio");
                            continue;
                        }
                        if (this.campos[i8].equals("quantidadeExames") || this.campos[i8].equals("quantidadeRequisicoes")) {
                            o[i8] = rs.getInt(this.campos[i8]);
                            continue;
                        }
                        if (this.tipoRelatorio == 2 && this.campos[i8].equals("quantidadePacientes")) {
                            if (filiais == null || filiais.length <= 0) {
                                filial[0] = Variaveis.filialPadrao;
                            } else if (filiais.length == 1) {
                                filial[0] = !this.getFiltroCheck("filtroAgruparFiliais") || this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1 ? rs.getString("codigoFilial") : Variaveis.filialPadrao;
                            }
                            o[i8] = this.quantidadePacientes(st2, filial, bufWhere.toString(), rs.getString("codigoConvenio"), rs.getString("codigoColeta"), destinos, setor);
                            continue;
                        }
                        if (RelatorioUtil.possuiColuna(rs, this.campos[i8]) <= 0) continue;
                        o[i8] = rs.getObject(this.campos[i8]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                String codigoFilial = Variaveis.filialPadrao;
                if (this.getFiltroCheck("filtroAgruparFiliais") && this.getSelecionadosFiltro("filtroFilial", 0) != null && this.getSelecionadosFiltro("filtroFilial", 0).length > 1) {
                    codigoFilial = this.getSelecionadosFiltro("filtroFilial", 0)[0];
                    Registro regFilial = RelatorioUtil.pegaDadosFilial(st, codigoFilial);
                    RelatorioUtil.preencheDadosFilial(regFilial, modelo);
                }
                ArrayQuantidades arrayQtde = new ArrayQuantidades();
                for (i7 = 0; i7 < modelo.getRowCount(); ++i7) {
                    HashMap<String, Object> aux = modelo.getLine(i7);
                    arrayQtde.somaQuantidadeExames(Integer.valueOf(aux.get("codigoFilial").toString()), (Integer)(aux.get("quantidadeExames") == null ? Integer.valueOf(0) : aux.get("quantidadeExames")));
                    if (this.tipoRelatorio == 1) {
                        arrayQtde.somaQuantidadeRequisicoes((Integer)aux.get("codigoFilial"), ((Double)aux.get("quantidadeRequisicoes")).intValue());
                        continue;
                    }
                    arrayQtde.somaQuantidadeRequisicoes((Integer)aux.get("codigoFilial"), ((Double)aux.get("quantidadeRequisicoes")).intValue());
                    arrayQtde.somaQuantidadeRequisicoes((Integer)aux.get("codigoFilial"), (int)((Integer)aux.get("quantidadeRequisicoesConvenio")));
                }
                for (i7 = 0; i7 < modelo.getRowCount(); ++i7) {
                    QuantidadesFilial aux = arrayQtde.buscaFilial((Integer)modelo.getValueAt(i7, modelo.findColumn("codigoFilial")));
                    if (aux != null) {
                        modelo.setValueAt(new Integer(aux.getQuantidadeExames()), i7, modelo.findColumn("quantidadeTotalExames"));
                        modelo.setValueAt(new Integer(aux.getQuantidadeRequisicoes()), i7, modelo.findColumn("quantidadeTotalRequisicoes"));
                        Float auxFloat = Float.valueOf(((Integer)modelo.getValueAt(i7, modelo.findColumn("quantidadeExames"))).floatValue() * 100.0f / ((Integer)modelo.getValueAt(i7, modelo.findColumn("quantidadeTotalExames"))).floatValue());
                        Double auxDouble = Funcoes.arredondar(auxFloat.floatValue(), 2);
                        modelo.setValueAt(Float.valueOf(auxDouble.floatValue()), i7, modelo.findColumn("percentualExames"));
                        auxFloat = Float.valueOf(((Double)modelo.getValueAt(i7, modelo.findColumn("quantidadeRequisicoes"))).floatValue() * 100.0f / ((Integer)modelo.getValueAt(i7, modelo.findColumn("quantidadeTotalRequisicoes"))).floatValue());
                        if (this.tipoRelatorio == 2) {
                            auxFloat = Float.valueOf(((Integer)modelo.getValueAt(i7, modelo.findColumn("quantidadeRequisicoesConvenio"))).floatValue() * 100.0f / ((Integer)modelo.getValueAt(i7, modelo.findColumn("quantidadeTotalRequisicoes"))).floatValue());
                        }
                        auxDouble = Funcoes.arredondar(auxFloat.floatValue(), 2);
                        modelo.setValueAt(Float.valueOf(auxDouble.floatValue()), i7, modelo.findColumn("percentualRequisicoes"));
                        continue;
                    }
                    modelo.setValueAt(new Integer(0), i7, modelo.findColumn("quantidadeTotalExames"));
                    modelo.setValueAt(new Integer(0), i7, modelo.findColumn("quantidadeTotalRequisicoes"));
                }
                MathContext mathContext = new MathContext(5, RoundingMode.HALF_UP);
                ArrayQuantidades arrayPerc = new ArrayQuantidades();
                for (int i9 = 0; i9 < modelo.getRowCount(); ++i9) {
                    HashMap<String, Object> aux = modelo.getLine(i9);
                    BigDecimal auxArred = new BigDecimal(aux.get("percentualExames") == null ? 0.0 : (double)((Float)aux.get("percentualExames")).floatValue(), mathContext);
                    auxArred = auxArred.multiply(new BigDecimal(100, mathContext), mathContext);
                    int perc = auxArred.intValue();
                    arrayPerc.somaQuantidadeExames((Integer)aux.get("codigoFilial"), perc);
                    auxArred = new BigDecimal(aux.get("percentualRequisicoes") == null ? 0.0 : (double)((Float)aux.get("percentualRequisicoes")).floatValue(), mathContext);
                    auxArred = auxArred.multiply(new BigDecimal(100, mathContext), mathContext);
                    perc = auxArred.intValue();
                    arrayPerc.somaQuantidadeRequisicoes((Integer)aux.get("codigoFilial"), new Integer(perc));
                }
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioAnaliticoColetas.getModuloAcesso(this.getFiltroCheck("filtroComissaoColeta") ? 3 : (this.getFiltroCheck("filtroComissaoDestino") ? 4 : this.tipoRelatorio)));
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioAnaliticoColetas.this.panelCentro.removeAll();
                            RelatorioAnaliticoColetas.this.panelCentro.repaint();
                            RelatorioAnaliticoColetas.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("filtroAgruparFiliais", this.getFiltroCheck("filtroAgruparFiliais"));
                    var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                    var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                    var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                    buf.delete(0, buf.length());
                    if (filiais != null) {
                        for (int i10 = 0; i10 < filiais.length; ++i10) {
                            buf.append(filiais[i10]);
                            if (i10 >= filiais.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroFilial", buf.toString());
                    buf.delete(0, buf.length());
                    if (convenios != null) {
                        for (int i11 = 0; i11 < convenios.length; ++i11) {
                            buf.append(convenios[i11]);
                            if (i11 >= convenios.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroConvenio", buf.toString());
                    buf.delete(0, buf.length());
                    if (grupos != null) {
                        for (int i12 = 0; i12 < grupos.length; ++i12) {
                            buf.append(grupos[i12]);
                            if (i12 >= grupos.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroGrupo", buf.toString());
                    buf.delete(0, buf.length());
                    if (setor != null) {
                        for (int i13 = 0; i13 < setor.length; ++i13) {
                            buf.append(setor[i13]);
                            if (i13 >= setor.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroSetor", buf.toString());
                    buf.delete(0, buf.length());
                    if (situacao != null) {
                        for (int i14 = 0; i14 < situacao.length; ++i14) {
                            buf.append(situacao[i14]);
                            if (i14 >= situacao.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroSituacaoExame", buf.toString());
                    buf.delete(0, buf.length());
                    if (coletas != null) {
                        for (int i15 = 0; i15 < coletas.length; ++i15) {
                            buf.append(coletas[i15]);
                            if (i15 >= coletas.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroColeta", buf.toString());
                    buf.delete(0, buf.length());
                    if (destinos != null) {
                        for (int i16 = 0; i16 < destinos.length; ++i16) {
                            buf.append(destinos[i16]);
                            if (i16 >= destinos.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroDestino", buf.toString());
                    Relatorio rel = new Relatorio(modelo, var, ParametrosGerais.getCasasPrecoExame(), ParametrosGerais.getArredondamentoPrecoExame());
                    rel.setConfiguracao(rs.getString("rel_xml"));
                    if (filiais == null || filiais.length <= 1 || this.getFiltroCheck("filtroAgruparFiliais")) {
                        rel.removerBandaCabecalhoGrupo("BandaFilial");
                    }
                    gerador.executar(rel);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RelatorioAcumuladoConvenios");
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private int quantidadePacientes(Statement st2, String[] filial, String filtro, String convenio, String coleta, String[] destinos, String[] setores) throws Exception {
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append("select count(distinct b.pac_codigo) as quantidadePacientes ");
        buf.append("from requisicao b ");
        buf.append("left join requisicaorequisicao rr on (b.fil_codigo = rr.fil_codigo and b.req_codigo = rr.req_kodigo) ");
        if (setores != null) {
            buf.append("join examerequisicao c on b.fil_codigo = c.fil_codigo and b.req_codigo = c.req_codigo and c.exr_excluido = false ");
            buf.append("join examesetor d on c.fil_codigo = d.fil_codigo and c.exa_codigo = d.exa_codigo and d.ese_default = true ");
        }
        buf.append("where b.fil_codigo IN (");
        for (i = 0; i < filial.length; ++i) {
            buf.append(filial[i]);
            if (i >= filial.length - 1) continue;
            buf.append(", ");
        }
        buf.append(") ");
        if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
            buf.append(" and b.req_data >= '");
            buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial")));
            buf.append("'");
        }
        if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
            buf.append(" and b.req_data <= '");
            buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal")));
            buf.append("'");
        }
        if (!Funcoes.textoVazio(convenio)) {
            buf.append(" and b.con_codigo = ");
            buf.append(convenio);
        }
        if (!Funcoes.textoVazio(coleta)) {
            buf.append(" and b.col_codigo = '");
            buf.append(StringUtil.textoDB(coleta)).append("' ");
        }
        if (destinos != null) {
            buf.append(" and b.des_codigo in (");
            for (i = 0; i < destinos.length; ++i) {
                buf.append("'");
                buf.append(destinos[i]);
                buf.append("'");
                if (i >= destinos.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (setores != null) {
            buf.append(" and d.set_codigo in (");
            for (i = 0; i < setores.length; ++i) {
                buf.append(setores[i]);
                if (i >= setores.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        buf.append(" and b.req_excluida = false ");
        ResultSet rs = Conexao.executeQuery(st2, buf.toString());
        int retorno = 0;
        if (rs.next()) {
            retorno = rs.getInt("quantidadePacientes");
        }
        return retorno;
    }

    private HashMap<String, Double> quantidadeRequisicoes(Statement st, String filtro, String[] convenios, String coleta, String[] destinos, String[] setores, String[] filial) throws Exception {
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append(" select distinct ");
        buf.append(" b.req_codigo as quantidadeRequisicoes, ");
        buf.append(" b.req_vlrdesconto as valorDescontoRequisicao, ");
        buf.append(" b.req_vlracrescimo as valorAcrescimoRequisicao ");
        buf.append("from requisicao b ");
        buf.append("join examerequisicao c on b.fil_codigo = c.fil_codigo and b.req_codigo = c.req_codigo and c.exr_excluido = false ");
        if (setores != null) {
            buf.append("join examesetor d on c.fil_codigo = d.fil_codigo and c.exa_codigo = d.exa_codigo and d.ese_default = true ");
        }
        if (filial.length > 1) {
            buf.append("where b.fil_codigo IN (");
            for (i = 0; i < filial.length; ++i) {
                buf.append(filial[i]);
                if (i >= filial.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
        } else if (filial.length == 1) {
            buf.append("where b.fil_codigo = ").append(filial[0]);
        }
        if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
            buf.append(" and b.req_data >= '");
            buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial")));
            buf.append("'");
        }
        if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
            buf.append(" and b.req_data <= '");
            buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataFinal")));
            buf.append("'");
        }
        if (!Funcoes.textoVazio(coleta)) {
            buf.append(" and b.col_codigo = '");
            buf.append(StringUtil.textoDB(coleta)).append("' ");
        }
        if (convenios != null) {
            buf.append(" and b.con_codigo in (");
            for (i = 0; i < convenios.length; ++i) {
                buf.append(convenios[i]);
                if (i >= convenios.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (destinos != null) {
            buf.append(" and b.des_codigo in (");
            for (i = 0; i < destinos.length; ++i) {
                buf.append("'");
                buf.append(destinos[i]);
                buf.append("'");
                if (i >= destinos.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (setores != null) {
            buf.append(" and d.set_codigo in (");
            for (i = 0; i < setores.length; ++i) {
                buf.append(setores[i]);
                if (i >= setores.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        buf.append(" and b.req_excluida = false ");
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        int retorno = 0;
        BigDecimal percentualDesconto = BigDecimal.ZERO;
        BigDecimal valorDesconto = BigDecimal.ZERO;
        BigDecimal valorAcrescimo = BigDecimal.ZERO;
        BigDecimal percentualAcrescimo = BigDecimal.ZERO;
        HashMap<String, Double> campos = new HashMap<String, Double>();
        while (rs.next()) {
            ++retorno;
            valorDesconto = valorDesconto.add(rs.getBigDecimal("valorDescontoRequisicao"));
            valorAcrescimo = valorAcrescimo.add(rs.getBigDecimal("valorAcrescimoRequisicao"));
        }
        if (percentualDesconto.compareTo(BigDecimal.ZERO) > 0) {
            percentualDesconto = percentualDesconto.divide(new BigDecimal(retorno), ParametrosGerais.getArredondamentoPrecoExame()).setScale(percentualDesconto.scale());
        }
        if (percentualAcrescimo.compareTo(BigDecimal.ZERO) > 0) {
            percentualAcrescimo = percentualAcrescimo.divide(new BigDecimal(retorno), ParametrosGerais.getArredondamentoPrecoExame()).setScale(percentualAcrescimo.scale());
        }
        campos.put("quantidadeRequisicoes", new Double(retorno));
        campos.put("valorAcrescimoRequisicao", valorAcrescimo.doubleValue());
        campos.put("valorDescontoRequisicao", valorDesconto.doubleValue());
        rs.close();
        return campos;
    }

    public static long getModuloAcesso(int tipoRelatorio) {
        if (tipoRelatorio == 1) {
            return Long.parseLong("0880400200");
        }
        if (tipoRelatorio == 3) {
            return Long.parseLong("0880400302");
        }
        if (tipoRelatorio == 4) {
            return Long.parseLong("0880400303");
        }
        return Long.parseLong("0880400300");
    }

    private long getModuloConfigurar(int tipoRelatorio) {
        if (tipoRelatorio == 1) {
            return Long.parseLong("0880400201");
        }
        if (tipoRelatorio == 3) {
            return Long.parseLong("0880400302");
        }
        if (tipoRelatorio == 4) {
            return Long.parseLong("0880400303");
        }
        return Long.parseLong("0880400301");
    }

    private void alternaComissaoSelecionada(int tipo) {
        if (tipo == 3 && this.getFiltroCheck("filtroComissaoColeta")) {
            this.setFiltroCheck("filtroComissaoDestino", false);
            this.setModuloConfigurar(RelatorioAnaliticoColetas.getModuloAcesso(3));
            this.setModuloAcesso(RelatorioAnaliticoColetas.getModuloAcesso(3));
        } else if (this.getFiltroCheck("filtroComissaoDestino")) {
            this.setFiltroCheck("filtroComissaoColeta", false);
            this.setModuloConfigurar(RelatorioAnaliticoColetas.getModuloAcesso(4));
            this.setModuloAcesso(RelatorioAnaliticoColetas.getModuloAcesso(4));
        } else if (!this.getFiltroCheck("filtroComissaoColeta") && !this.getFiltroCheck("filtroComissaoDestino")) {
            this.setModuloConfigurar(RelatorioAnaliticoColetas.getModuloAcesso(2));
            this.setModuloAcesso(RelatorioAnaliticoColetas.getModuloAcesso(2));
        }
    }

    private class ArrayQuantidades {
        private final ArrayList<QuantidadesFilial> arrayQuantidades = new ArrayList();

        private ArrayQuantidades() {
        }

        public int size() {
            return this.arrayQuantidades.size();
        }

        public QuantidadesFilial get(int i) {
            if (i < this.arrayQuantidades.size()) {
                return this.arrayQuantidades.get(i);
            }
            return null;
        }

        public QuantidadesFilial buscaFilial(Integer filial) {
            for (int i = 0; i < this.arrayQuantidades.size(); ++i) {
                if (this.arrayQuantidades.get(i).getFilial().intValue() != filial.intValue()) continue;
                return this.arrayQuantidades.get(i);
            }
            return null;
        }

        public void somaQuantidadeRequisicoes(Integer filial, Integer qtde) {
            QuantidadesFilial aux = this.buscaFilial(filial);
            if (aux == null) {
                this.arrayQuantidades.add(new QuantidadesFilial(filial, qtde, 0));
            } else {
                aux.somaRequisicoes(qtde);
            }
        }

        public void somaQuantidadeExames(Integer filial, Integer qtde) {
            QuantidadesFilial aux = this.buscaFilial(filial);
            if (aux == null) {
                this.arrayQuantidades.add(new QuantidadesFilial(filial, 0, qtde));
            } else {
                aux.somaExames(qtde);
            }
        }
    }

    private class QuantidadesFilial {
        private final Integer filial;
        private Integer quantidadeRequisicoes = 0;
        private Integer quantidadeExames = 0;

        public QuantidadesFilial(Integer filial, Integer quantidadeRequisicoes, Integer quantidadeExames) {
            this.filial = filial;
            this.quantidadeExames = quantidadeExames;
            this.quantidadeRequisicoes = quantidadeRequisicoes;
        }

        public void somaRequisicoes(Integer qtde) {
            QuantidadesFilial quantidadesFilial = this;
            quantidadesFilial.quantidadeRequisicoes = quantidadesFilial.quantidadeRequisicoes + qtde;
        }

        public void somaExames(Integer qtde) {
            QuantidadesFilial quantidadesFilial = this;
            quantidadesFilial.quantidadeExames = quantidadesFilial.quantidadeExames + qtde;
        }

        public Integer getFilial() {
            return this.filial;
        }

        public Integer getQuantidadeExames() {
            return this.quantidadeExames;
        }

        public Integer getQuantidadeRequisicoes() {
            return this.quantidadeRequisicoes;
        }
    }
}

