/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.gerencial;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioAcumuladoUsuario
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private static final String FILTRO_FILIAL = "filtroFilial";
    private static final String FILTRO_CONVENIO = "filtroConvenio";
    private static final String FILTRO_USUARIO = "filtroUsuario";
    private static final String FILTRO_COLETA = "filtroColeta";
    private static final String FILTRO_DESTINO = "filtroDestino";
    private static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private static final String FILTRO_HORA_INICIAL = "filtroHoraInicial";
    private static final String FILTRO_HORA_FINAL = "filtroHoraFinal";
    private static final String FILTRO_INTERVALO_HORA = "intervaloHora";
    private static final String FILTRO_USUARIO_ABERTURA = "usuarioAbertura";
    public static final int TIPO_DATA_REQUISICAO = 0;
    public static final int TIPO_DATA_ENTREGA = 1;
    private static int tipoRelatorio = 0;
    private static String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoUsuario", "nomeUsuario", "data", "quantidadeRequisicoes", "quantidadeExames", "diaSemana", "horaPrimeira", "horaUltima"});

    public RelatorioAcumuladoUsuario(int tipoRelatorio) {
        RelatorioAcumuladoUsuario.tipoRelatorio = tipoRelatorio;
        if (tipoRelatorio == 0) {
            this.montaBarraDescricao("Relat\u00f3rio acumulado por usu\u00e1rio", "Produtividade acumulada de requisi\u00e7\u00f5es e exames por usu\u00e1rio", "relatorios/rel_ger_acumulados_acumulado_usuario.jpg");
        } else {
            this.montaBarraDescricao("Relat\u00f3rio acumulado por usu\u00e1rio de entrega", "Produtividade acumulada de requisi\u00e7\u00f5es e exames por usu\u00e1rio de entrega", "relatorios/rel_ger_acumulados_acumulado_usuarioentrega.jpg");
        }
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro(FILTRO_FILIAL, "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_CONVENIO, "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_razao", "con_fantasia"}, new String[]{"C\u00f3digo", "Raz\u00e3o Social", "Fantasia"}, new int[]{70, 0, 0});
        this.adicionaItemFiltro(FILTRO_USUARIO, "Usu\u00e1rio", "usuario", "fil_codigo = " + Variaveis.filialPadrao + " and usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_COLETA, "Coleta", "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_DESTINO, "Destino", "destino", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Data inicial:");
        this.adicionaFiltroData(FILTRO_DATA_FINAL, "Data final:");
        this.adicionaFiltroHora(FILTRO_HORA_INICIAL, "Hora inicial:");
        this.adicionaFiltroHora(FILTRO_HORA_FINAL, "Hora final:");
        this.adicionaFiltroCheck(FILTRO_INTERVALO_HORA, "Intervalo de Hora", false);
        this.adicionaFiltroCheck(FILTRO_USUARIO_ABERTURA, "Usu\u00e1rio de altera\u00e7\u00e3o", false);
        this.setModuloAcesso(RelatorioAcumuladoUsuario.getModuloAcesso(tipoRelatorio));
        this.setCamposConfigurador(campos);
    }

    @Override
    public void imprimirPressionado() {
        if (this.getFiltroCheck(FILTRO_INTERVALO_HORA)) {
            if (!this.getFiltroData(FILTRO_DATA_INICIAL).isEmpty() && this.getFiltroHora(FILTRO_HORA_INICIAL).isEmpty()) {
                Funcoes.mensagem(this, "O filtro de HORA INICIAL deve ser preenchido.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            if (this.getFiltroData(FILTRO_DATA_INICIAL).isEmpty() && !this.getFiltroHora(FILTRO_HORA_INICIAL).isEmpty()) {
                Funcoes.mensagem(this, "O filtro de DATA INICIAL deve ser preenchido.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            if (!this.getFiltroData(FILTRO_DATA_FINAL).isEmpty() && this.getFiltroHora(FILTRO_HORA_FINAL).isEmpty()) {
                Funcoes.mensagem(this, "O filtro de HORA FINAL deve ser preenchido.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            if (this.getFiltroData(FILTRO_DATA_FINAL).isEmpty() && !this.getFiltroHora(FILTRO_HORA_FINAL).isEmpty()) {
                Funcoes.mensagem(this, "O filtro de DATA FINAL deve ser preenchido.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        Statement st = Conexao.getStatement();
        try {
            String[] destino;
            String[] usuario;
            String[] convenio;
            StringBuilder buf = new StringBuilder();
            String campoUsuario = " a.usr_codabertura ";
            if (this.getFiltroCheck(FILTRO_USUARIO_ABERTURA)) {
                campoUsuario = " a.usr_codigo ";
            }
            buf.append(" select count(distinct a.req_codigo) as quantidadeRequisicoes, ");
            buf.append("        count(b.exa_codigo) as quantidadeExames, ");
            if (tipoRelatorio == 0) {
                buf.append("        a.req_data as data, ");
                buf.append("        extract(DOW from a.req_data) as diaSemana, ");
                buf.append("        MIN(a.req_hora) as horaPrimeira, ");
                buf.append("        MAX(a.req_hora) as horaUltima,   ");
                buf.append(campoUsuario).append("       as codigoUsuario,  ");
            } else {
                buf.append("        date_trunc('day', b.exr_dataentreguerst) as data, ");
                buf.append("        extract(DOW from b.exr_dataentreguerst) as diaSemana, ");
                buf.append("        MIN(CAST(b.exr_dataentreguerst as TIME)) as horaPrimeira, ");
                buf.append("        MAX(CAST(b.exr_dataentreguerst as TIME)) as horaUltima, ");
                buf.append("        b.usr_codentrega as codigoUsuario, ");
            }
            buf.append("        usr.usr_nome as nomeUsuario, ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append("   from requisicao a ");
            buf.append("   left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            buf.append("   left join coletas col on a.fil_codigo = col.fil_codigo and a.col_codigo = col.col_codigo ");
            buf.append("   left join convenios con on a.fil_codigo = con.fil_codigo and a.con_codigo = con.con_codigo ");
            if (tipoRelatorio == 0) {
                buf.append("   left join usuario usr on a.fil_codigo = usr.fil_codigo and ").append(campoUsuario).append("  = usr.usr_codigo ");
            } else {
                buf.append("   left join usuario usr on a.fil_codigo = usr.fil_codigo and b.usr_codentrega = usr.usr_codigo ");
            }
            buf.append("   left join destino des on a.fil_codigo = des.fil_codigo and a.des_codigo = des.des_codigo ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            String[] filiais = this.getSelecionadosFiltro(FILTRO_FILIAL, 0);
            if (filiais == null) {
                filiais = new String[]{Variaveis.filialPadrao};
            }
            buf.append(" where a.fil_codigo in (");
            for (int i = 0; i < filiais.length; ++i) {
                buf.append(filiais[i]);
                if (i >= filiais.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
            String[] coleta = this.getSelecionadosFiltro(FILTRO_COLETA, 0);
            if (coleta != null) {
                buf.append(" and a.col_codigo in (");
                for (int i = 0; i < coleta.length; ++i) {
                    buf.append("'");
                    buf.append(coleta[i]);
                    buf.append("'");
                    if (i >= coleta.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            }
            if ((convenio = this.getSelecionadosFiltro(FILTRO_CONVENIO, 0)) != null) {
                buf.append(" and a.con_codigo in (");
                for (int i = 0; i < convenio.length; ++i) {
                    buf.append(convenio[i]);
                    if (i >= convenio.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            }
            if ((usuario = this.getSelecionadosFiltro(FILTRO_USUARIO, 0)) != null) {
                if (tipoRelatorio == 0) {
                    buf.append(" and  ").append(campoUsuario).append(" in ( ");
                } else {
                    buf.append(" and b.usr_codentrega in (");
                }
                for (int i = 0; i < usuario.length; ++i) {
                    buf.append("'");
                    buf.append(usuario[i]);
                    buf.append("'");
                    if (i >= usuario.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            }
            if ((destino = this.getSelecionadosFiltro(FILTRO_DESTINO, 0)) != null) {
                buf.append(" and a.des_codigo in (");
                for (int i = 0; i < destino.length; ++i) {
                    buf.append("'");
                    buf.append(destino[i]);
                    buf.append("'");
                    if (i >= destino.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") ");
            }
            buf.append(" and a.req_excluida = false ");
            buf.append(" and b.exr_excluido = false ");
            if (tipoRelatorio == 0) {
                if (this.getFiltroCheck(FILTRO_INTERVALO_HORA)) {
                    if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_INICIAL)) && Funcoes.verificaHora(this.getFiltroHora(FILTRO_HORA_INICIAL))) {
                        buf.append(" and date_trunc('minute', a.req_data + a.req_hora) >= '");
                        buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_INICIAL))).append(" ").append(this.getFiltroHora(FILTRO_HORA_INICIAL));
                        buf.append("'");
                    }
                    if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_FINAL)) && Funcoes.verificaHora(this.getFiltroHora(FILTRO_HORA_FINAL))) {
                        buf.append(" and date_trunc('minute', a.req_data + a.req_hora) <= '");
                        buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_FINAL))).append(" ").append(this.getFiltroHora(FILTRO_HORA_FINAL));
                        buf.append("'");
                    }
                } else {
                    if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_INICIAL))) {
                        buf.append(" and a.req_data >= '");
                        buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData(FILTRO_DATA_INICIAL)));
                        buf.append("'");
                    }
                    if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_FINAL))) {
                        buf.append(" and a.req_data <= '");
                        buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData(FILTRO_DATA_FINAL)));
                        buf.append("'");
                    }
                    if (Funcoes.verificaHora(this.getFiltroHora(FILTRO_HORA_INICIAL))) {
                        buf.append(" and a.req_hora >= '");
                        buf.append(this.getFiltroHora(FILTRO_HORA_INICIAL));
                        buf.append("'");
                    }
                    if (Funcoes.verificaHora(this.getFiltroHora(FILTRO_HORA_FINAL))) {
                        buf.append(" and a.req_hora <= '");
                        buf.append(this.getFiltroHora(FILTRO_HORA_FINAL));
                        buf.append("'");
                    }
                }
            } else if (this.getFiltroCheck(FILTRO_INTERVALO_HORA)) {
                if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_INICIAL)) && Funcoes.verificaHora(this.getFiltroHora(FILTRO_HORA_INICIAL))) {
                    buf.append(" and date_trunc('minute', b.exr_dataentreguerst) >= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_INICIAL))).append(" ").append(this.getFiltroHora(FILTRO_HORA_INICIAL));
                    buf.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_FINAL)) && Funcoes.verificaHora(this.getFiltroHora(FILTRO_HORA_FINAL))) {
                    buf.append(" and date_trunc('minute', b.exr_dataentreguerst) <= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_FINAL))).append(" ").append(this.getFiltroHora(FILTRO_HORA_FINAL));
                    buf.append("'");
                }
            } else {
                if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_INICIAL))) {
                    buf.append(" and cast(b.exr_dataentreguerst as date) >= '");
                    buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData(FILTRO_DATA_INICIAL)));
                    buf.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_FINAL))) {
                    buf.append(" and cast(b.exr_dataentreguerst as date) <= '");
                    buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData(FILTRO_DATA_FINAL)));
                    buf.append("'");
                }
                if (Funcoes.verificaHora(this.getFiltroHora(FILTRO_HORA_INICIAL))) {
                    buf.append(" and cast(b.exr_dataentreguerst as time) >= '");
                    buf.append(this.getFiltroHora(FILTRO_HORA_INICIAL));
                    buf.append("'");
                }
                if (Funcoes.verificaHora(this.getFiltroHora(FILTRO_HORA_FINAL))) {
                    buf.append(" and cast(b.exr_dataentreguerst as time) <= '");
                    buf.append(this.getFiltroHora(FILTRO_HORA_FINAL));
                    buf.append("'");
                }
            }
            if (tipoRelatorio == 0) {
                buf.append("  group by  ").append(campoUsuario).append(", ");
                buf.append("           usr.usr_nome, ");
                buf.append("           a.req_data ");
            } else {
                buf.append("  group by b.usr_codentrega, ");
                buf.append("           usr.usr_nome, ");
                buf.append("           usr.usr_nome, date_trunc ('day', b.exr_dataentreguerst), ");
                buf.append("           extract(DOW from b.exr_dataentreguerst) ");
            }
            for (String s : Constantes.CAMPOS_FILIAL) {
                buf.append(", ").append(s);
            }
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(campos);
                do {
                    Object[] o = new Object[campos.length];
                    for (int i = 0; i < campos.length; ++i) {
                        if (campos[i].equalsIgnoreCase("diaSemana")) {
                            try {
                                int dia = rs.getInt("diaSemana");
                                switch (dia) {
                                    case 0: {
                                        o[i] = "Domingo";
                                        break;
                                    }
                                    case 1: {
                                        o[i] = "Segunda-feira";
                                        break;
                                    }
                                    case 2: {
                                        o[i] = "Ter\u00e7a-feira";
                                        break;
                                    }
                                    case 3: {
                                        o[i] = "Quarta-feira";
                                        break;
                                    }
                                    case 4: {
                                        o[i] = "Quinta-feira";
                                        break;
                                    }
                                    case 5: {
                                        o[i] = "Sexta-feira";
                                        break;
                                    }
                                    case 6: {
                                        o[i] = "S\u00e1bado";
                                        break;
                                    }
                                    default: {
                                        o[i] = "Dia incorreto";
                                        break;
                                    }
                                }
                            }
                            catch (Exception e) {
                                o[i] = "Dia incorreto";
                            }
                            continue;
                        }
                        o[i] = rs.getObject(campos[i]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioAcumuladoUsuario.getModuloAcesso(tipoRelatorio));
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    int i;
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioAcumuladoUsuario.this.panelCentro.removeAll();
                            RelatorioAcumuladoUsuario.this.panelCentro.repaint();
                            RelatorioAcumuladoUsuario.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put(FILTRO_DATA_INICIAL, this.getFiltroData(FILTRO_DATA_INICIAL));
                    var.put(FILTRO_DATA_FINAL, this.getFiltroData(FILTRO_DATA_FINAL));
                    var.put(FILTRO_HORA_INICIAL, this.getFiltroHora(FILTRO_HORA_INICIAL));
                    var.put(FILTRO_HORA_FINAL, this.getFiltroHora(FILTRO_HORA_FINAL));
                    var.put(FILTRO_INTERVALO_HORA, this.getFiltroCheck(FILTRO_INTERVALO_HORA) ? "Sim" : "N\u00e3o");
                    buf.delete(0, buf.length());
                    if (convenio != null) {
                        for (i = 0; i < convenio.length; ++i) {
                            buf.append(convenio[i]);
                            if (i >= convenio.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_CONVENIO, buf.toString());
                    buf.delete(0, buf.length());
                    if (filiais != null) {
                        for (i = 0; i < filiais.length; ++i) {
                            buf.append(filiais[i]);
                            if (i >= filiais.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_FILIAL, buf.toString());
                    buf.delete(0, buf.length());
                    if (usuario != null) {
                        for (i = 0; i < usuario.length; ++i) {
                            buf.append(usuario[i]);
                            if (i >= usuario.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_USUARIO, buf.toString());
                    buf.delete(0, buf.length());
                    if (coleta != null) {
                        for (i = 0; i < coleta.length; ++i) {
                            buf.append(coleta[i]);
                            if (i >= coleta.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_COLETA, buf.toString());
                    buf.delete(0, buf.length());
                    if (destino != null) {
                        for (i = 0; i < destino.length; ++i) {
                            buf.append(destino[i]);
                            if (i >= destino.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_DESTINO, buf.toString());
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        Conexao.fecharStatement(st);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso(int tipoRelatorio) {
        if (tipoRelatorio == 0) {
            return Long.parseLong("0880300700");
        }
        return Long.parseLong("0880300800");
    }

    public static long getModuloConfigurar(int tipoRelatorio) {
        if (tipoRelatorio == 0) {
            return Long.parseLong("0880300701");
        }
        return Long.parseLong("0880300801");
    }
}

