/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.gerencial;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.laboratorio.relatorios.util.RelatorioUtil;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioAcumuladoPorPaciente
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String[] ordem = new String[]{"C\u00f3digo", "Nome", "Data Ult. Requisi\u00e7\u00e3o", "Qtde requisi\u00e7\u00f5es", "Qtde exames", "Valor exames", "Qtde requisi\u00e7\u00f5es decrescente", "Valor exames decrescente"};
    private final String[] camposOrdem = new String[]{"p.pac_codigo", "lower(p.pac_nome)", "ultimaDataRequisicaoPaciente", "quantidadeRequisicoesPaciente", "quantidadeExamesPaciente", "valorTotalExamePaciente", "quantidadeRequisicoesPaciente desc", "quantidadeExamesPaciente desc"};
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_PACIENTE = "filtroPaciente";
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_MEDICO = "filtroMedico";
    private final String FILTRO_COLETA = "filtroColeta";
    private final String FILTRO_DESTINO = "filtroDestino";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    protected static String[] campos;

    public RelatorioAcumuladoPorPaciente() {
        campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio", "valorExame", "valorMaterial", "valorCH", "quantidadeRequisicoesPaciente", "quantidadeExamesPaciente", "ultimaDataRequisicaoPaciente", "valorCHOriginal", "valorCustoSimplesExameHistorico", "valorCustoSimplesExameAtual", "codigoPaciente", "nomePaciente", "nomeSocialPaciente", "dataNascimentoPaciente", "cpfPaciente", "sexoPaciente", "rgPaciente", "grupoSanguineoPaciente", "fatorRhPaciente", "emailPaciente", "foneContatoPaciente", "fonePaciente", "idadePaciente", "matriculaConvenioPaciente", "valorTotalExamePaciente"});
        this.montaBarraDescricao("Relat\u00f3rio de acumulado por paciente", "Listagem de quantidade de exames e requisi\u00e7\u00f5es no per\u00edodo agrupado por paciente", "relatorios/acumulado_paciente.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A") || Variaveis.tipoFilialPadrao.equalsIgnoreCase("V")) {
            this.adicionaItemFiltroAvancado("filtroPaciente", "Paciente", "paciente", "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"pac_codigo", "pac_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0}, false, new int[]{70, 0});
        } else {
            this.adicionaItemFiltroAvancado("filtroPaciente", "Paciente", "paciente", "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"pac_codigo", "pac_nome", "pac_nomesocial"}, new String[]{"C\u00f3digo", "Nome", "Nome Social"}, new int[]{70, 0, 0}, false, new int[]{70, 0, 0});
        }
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroColeta", "Coleta", "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroDestino", "Destino", "destino", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltroAvancado("filtroMedico", "M\u00e9dico", "medico", "fil_codigo = " + Variaveis.filialPadrao, 4, new String[]{"med_conselho", "med_crm", "med_uf", "med_nome"}, new String[]{"Conselho", "N\u00famero", "UF", "Nome"}, new int[]{30, 70, 20, 0}, false, new int[]{0, 1, 2});
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroComboPopupWidth("ordemRelatorio", "Ordem:", this.ordem, 0, 50);
        this.setModuloConfigurar(RelatorioAcumuladoPorPaciente.getModuloConfigurar());
        this.setModuloAcesso(RelatorioAcumuladoPorPaciente.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    @Override
    public void imprimirPressionado() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        try {
            String[] destinos;
            String[] coletas;
            String[] paciente;
            StringBuilder buf = new StringBuilder();
            buf.append("select count(a.exa_codigo) as quantidadeExamesPaciente, ");
            buf.append("max(b.req_data) as ultimaDataRequisicaoPaciente, ");
            buf.append("count(distinct b.req_codigo) as quantidadeRequisicoesPaciente, ");
            buf.append("sum(calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo, true, false, false, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, d.con_precosdiferenciados, d.con_reajuste, d.con_cobrmaterial, d.con_percpgtomaterial, d.con_percpgto, d.con_tpcalcfatu, d.con_tpcalcch, d.con_perguntarpercbalcao, d.con_acrescimo, d.con_bonus, d.tpe_codigo, d.con_acrescimoporte, d.con_acrescimouco, d.con_descontoporte, d.con_descontouco, d.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", a.met_codigo").append(")) as valorExame, ");
            buf.append("sum(calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo, true, false, true, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, d.con_precosdiferenciados, d.con_reajuste, d.con_cobrmaterial, d.con_percpgtomaterial, d.con_percpgto, d.con_tpcalcfatu, d.con_tpcalcch, d.con_perguntarpercbalcao, d.con_acrescimo, d.con_bonus, d.tpe_codigo, d.con_acrescimoporte, d.con_acrescimouco, d.con_descontoporte, d.con_descontouco, d.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", a.met_codigo").append(")) as valorTotalExamePaciente, ");
            buf.append("sum(a.exr_vlrmaterial) as valorMaterial, ");
            buf.append("sum(a.exr_vlrchexame) as valorCHOriginal, ");
            buf.append("sum(calculachexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo)) as valorCH, ");
            buf.append("sum(a.exr_custosimples) AS valorCustoSimplesExameHistorico, ");
            buf.append("sum(examatcol.emc_custosimples) AS valorCustoSimplesExameAtual, ");
            buf.append("p.pac_codigo as codigoPaciente, ");
            buf.append("p.pac_nome as nomePaciente, ");
            buf.append("p.pac_nomesocial as nomeSocialPaciente, ");
            buf.append("p.pac_datanasc as dataNascimentoPaciente, ");
            buf.append("p.pac_cpf as cpfPaciente, ");
            buf.append("p.pac_sexo as sexoPaciente, ");
            buf.append("p.pac_rg as rgPaciente, ");
            buf.append("p.pac_grpsangue as grupoSanguineoPaciente, ");
            buf.append("p.pac_fatorrh as fatorRhPaciente, ");
            buf.append("p.pac_email as emailPaciente, ");
            buf.append("p.pac_fonecontato as foneContatoPaciente, ");
            buf.append("p.pac_fone as fonePaciente, ");
            buf.append("p.pac_idade as idadePaciente, ");
            buf.append("p.pac_matricconv as matriculaConvenioPaciente ");
            if (this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
                buf.append(",").append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            }
            buf.append("from examerequisicao a ");
            buf.append("join requisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            buf.append("join paciente p on a.fil_codigo = p.fil_codigo and b.pac_codigo = p.pac_codigo ");
            buf.append("left join exames c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo ");
            buf.append("left join examematcoleta examatcol on c.fil_codigo = examatcol.fil_codigo and c.exa_codigo = examatcol.exa_codigo and a.mco_codigo = examatcol.mco_codigo ");
            buf.append("left join convenios d on a.fil_codigo = d.fil_codigo and b.con_codigo = d.con_codigo ");
            buf.append("left join examesetor e on a.fil_codigo = e.fil_codigo and a.exa_codigo = e.exa_codigo and e.ese_default = true ");
            buf.append("left join examematgrupo g on a.fil_codigo = g.fil_codigo and a.exa_codigo = g.exa_codigo and a.mco_codigo = g.mco_codigo ");
            buf.append("left join setores f on e.fil_codigo = f.fil_codigo and e.set_codigo = f.set_codigo ");
            if (this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            }
            StringBuilder bufWhere = new StringBuilder();
            String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
            if (filiais == null) {
                filiais = new String[]{Variaveis.filialPadrao};
            }
            bufWhere.append(" where a.fil_codigo in (");
            for (int i = 0; i < filiais.length; ++i) {
                bufWhere.append(filiais[i]);
                if (i >= filiais.length - 1) continue;
                bufWhere.append(", ");
            }
            bufWhere.append(") ");
            String[] convenio = this.getSelecionadosFiltro("filtroConvenio", 0);
            if (convenio != null) {
                bufWhere.append(" and b.con_codigo in (");
                for (int i = 0; i < convenio.length; ++i) {
                    bufWhere.append(convenio[i]);
                    if (i >= convenio.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((paciente = this.getSelecionadosFiltroAvancado("filtroPaciente", 0)) != null) {
                bufWhere.append(" and p.pac_codigo in (");
                for (int i = 0; i < paciente.length; ++i) {
                    bufWhere.append(paciente[i]);
                    if (i >= paciente.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            String[] conselho = this.getSelecionadosFiltroAvancado("filtroMedico", 0);
            String[] medico = this.getSelecionadosFiltroAvancado("filtroMedico", 1);
            String[] medicoUf = this.getSelecionadosFiltroAvancado("filtroMedico", 2);
            if (medico != null && medico.length <= ParametrosGerais.getQuantidadeMaximoFiltroAvancado()) {
                bufWhere.append(" and (");
                for (int i = 0; i < medico.length; ++i) {
                    bufWhere.append("(b.med_conselho = '");
                    bufWhere.append(conselho[i]);
                    bufWhere.append("' and b.med_crm = '");
                    bufWhere.append(medico[i]);
                    bufWhere.append("' and b.med_uf = '");
                    bufWhere.append(medicoUf[i]);
                    bufWhere.append("') ");
                    if (i >= medico.length - 1) continue;
                    bufWhere.append(" or ");
                }
                bufWhere.append(") ");
            }
            if ((coletas = this.getSelecionadosFiltro("filtroColeta", 0)) != null) {
                bufWhere.append(" and b.col_codigo in (");
                for (int i = 0; i < coletas.length; ++i) {
                    bufWhere.append(StringUtil.textoDBEscape(coletas[i]));
                    if (i >= coletas.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((destinos = this.getSelecionadosFiltro("filtroDestino", 0)) != null) {
                bufWhere.append(" and b.des_codigo in (");
                for (int i = 0; i < destinos.length; ++i) {
                    bufWhere.append(StringUtil.textoDBEscape(destinos[i]));
                    if (i >= destinos.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                bufWhere.append(" and b.req_data >= '");
                bufWhere.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial")));
                bufWhere.append("'");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                bufWhere.append(" and b.req_data <= '");
                bufWhere.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal")));
                bufWhere.append("'");
            }
            bufWhere.append(" and b.req_excluida = false and a.exr_excluido = false ");
            buf.append(bufWhere.toString());
            buf.append(" group by ");
            if (this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
                buf.append("filial.fil_codigo, ");
                buf.append("filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, ");
                buf.append("filial.fil_complemento, filial.fil_cep, filial.fil_fone, ");
                buf.append("filial.fil_fax, filial.fil_razaosocial, cidadefilial.cid_codigo, ");
                buf.append("cidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo, ");
                buf.append("bairrofilial.bai_descricao, filial.fil_cnes, ");
            }
            buf.append("p.pac_codigo, ");
            buf.append("p.pac_nome, ");
            buf.append("p.pac_nomesocial, ");
            buf.append("p.pac_datanasc, ");
            buf.append("p.pac_cpf, ");
            buf.append("p.pac_sexo, ");
            buf.append("p.pac_rg, ");
            buf.append("p.pac_grpsangue, ");
            buf.append("p.pac_fatorrh, ");
            buf.append("p.pac_email, ");
            buf.append("p.pac_fonecontato, ");
            buf.append("p.pac_fone, ");
            buf.append("p.pac_idade, ");
            buf.append("p.pac_matricconv ");
            buf.append(" order by ");
            buf.append(this.camposOrdem[this.getFiltroComboIndice("ordemRelatorio")]);
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(campos);
                do {
                    Object[] o = new Object[campos.length];
                    for (int i = 0; i < campos.length; ++i) {
                        if (RelatorioUtil.possuiColuna(rs, campos[i]) < 0) continue;
                        o[i] = rs.getObject(campos[i]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                String codigoFilial = Variaveis.filialPadrao;
                if (this.getSelecionadosFiltro("filtroFilial", 0) != null && this.getSelecionadosFiltro("filtroFilial", 0).length == 1) {
                    codigoFilial = this.getSelecionadosFiltro("filtroFilial", 0)[0];
                }
                Registro regFilial = RelatorioUtil.pegaDadosFilial(st, codigoFilial);
                RelatorioUtil.preencheDadosFilial(regFilial, modelo);
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioAcumuladoPorPaciente.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    int i;
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioAcumuladoPorPaciente.this.panelCentro.removeAll();
                            RelatorioAcumuladoPorPaciente.this.panelCentro.repaint();
                            RelatorioAcumuladoPorPaciente.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                    var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                    var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                    buf.delete(0, buf.length());
                    if (filiais != null) {
                        for (i = 0; i < filiais.length; ++i) {
                            buf.append(filiais[i]);
                            if (i >= filiais.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroFilial", buf.toString());
                    buf.delete(0, buf.length());
                    if (convenio != null) {
                        for (i = 0; i < convenio.length; ++i) {
                            buf.append(convenio[i]);
                            if (i >= convenio.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroConvenio", buf.toString());
                    buf.delete(0, buf.length());
                    if (medico != null) {
                        for (i = 0; i < medico.length; ++i) {
                            buf.append(conselho[i]);
                            buf.append(": ");
                            buf.append(medico[i]);
                            buf.append(" (");
                            buf.append(medicoUf[i]);
                            buf.append(")");
                            if (i >= medico.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroMedico", buf.toString());
                    buf.delete(0, buf.length());
                    if (coletas != null) {
                        for (i = 0; i < coletas.length; ++i) {
                            buf.append(coletas[i]);
                            if (i >= coletas.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroColeta", buf.toString());
                    buf.delete(0, buf.length());
                    if (destinos != null) {
                        for (i = 0; i < destinos.length; ++i) {
                            buf.append(destinos[i]);
                            if (i >= destinos.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroDestino", buf.toString());
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RelatorioAcumuladoPacientes");
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0880301400");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0880301401");
    }
}

