/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.gerencial;

import jalis.comum.Conexao;
import jalis.comum.ConstantesGerais;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.laboratorio.relatorios.util.RelatorioUtil;
import jalis.relatorio.Gerador;
import jalis.relatorio.gerador.Relatorio;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.TableModel;

public class RelatorioAcumuladoMedicos
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String PARAMETRO_FILIAL = "filial";
    private final String PARAMETRO_MEDICO = "medico";
    private final String PARAMETRO_MEDICOS = "medicos";
    private final String PARAMETRO_ESPECIALIDADE = "especialidade";
    private final String PARAMETRO_COLETA = "coleta";
    private final String PARAMETRO_DESTINO = "destino";
    private final String PARAMETRO_GRUPO = "grupo";
    private final String PARAMETRO_SETOR = "setor";
    private final String PARAMETRO_EXAME = "exame";
    private final String PARAMETRO_CONVENIO = "convenio";
    private final String PARAMETRO_DATA_INICIAL = "dataInicial";
    private final String PARAMETRO_DATA_FINAL = "dataFinal";
    private final String PARAMETRO_UF_MEDICO = "ufMedico";
    private final String PARAMETRO_ORDEM = "ordemRelatorio";
    private final int TIPO_ACUMULADO_MEDICO = 0;
    private final String[] ordem = new String[]{"CRM", "Nome", "Qtde crescente", "Qtde descrescente", "Endere\u00e7o"};
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_MEDICO = "filtroMedico";
    private final String FILTRO_ESPECIALIDADE = "filtroEspecialidade";
    private final String FILTRO_COLETA = "filtroColeta";
    private final String FILTRO_DESTINO = "filtroDestino";
    private final String FILTRO_GRUPO = "filtroGrupo";
    private final String FILTRO_SETOR = "filtroSetor";
    private final String FILTRO_EXAME = "filtroExame";
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_UF_MEDICO = "ordemUfMedico";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private static Map<Integer, String> listaUltimoFiltro = new HashMap<Integer, String>();
    private static HashMap<String, String> camposUtilizados = new HashMap();
    protected static String[] campos;
    private String SELECT_FILIAL = "filial.fil_codigo as codigoFilial, filial.fil_descricao as filialDescricao, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ";

    public RelatorioAcumuladoMedicos() {
        this.listaParametros();
        campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"filialDescricao", "conselhoMedico", "crmMedico", "ufMedico", "nomeMedico", "valorExame", "valorMaterial", "valorCH", "valorTotalExame", "quantidadeExames", "quantidadeRequisicoes", "valorCHOriginal", "enderecoMedico", "valorCustoSimplesExameHistorico", "valorCustoSimplesExameAtual"});
        this.montaBarraDescricao("Relat\u00f3rio acumulado por m\u00e9dico", "Listagem de quantidade de exames e requisi\u00e7\u00f5es no per\u00edodo agrupado por m\u00e9dico", "relatorios/acumulado_medico.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltroAvancado("filtroMedico", "M\u00e9dico", "medico", "fil_codigo = " + Variaveis.filialPadrao, 4, new String[]{"med_conselho", "med_crm", "med_uf", "med_nome"}, new String[]{"Conselho", "N\u00famero", "UF", "Nome"}, new int[]{30, 70, 30, 0}, false, new int[]{0, 1, 2});
        this.adicionaItemFiltro("filtroEspecialidade", "Especialidade", "especialidades", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"esp_codigo", "esp_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroColeta", "Coleta", "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroDestino", "Destino", "destino", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroGrupo", "Grupo", "grupo", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"grp_codigo", "grp_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroSetor", "Setor", "setores", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroExame", "Exame", "exames", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroCombo("ordemUfMedico", "UF M\u00e9dico:", ArraysUtil.concatenar(new String[]{"      "}, ConstantesGerais.ESTADOS), 0);
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.setModuloConfigurar(this.getModuloConfigurar());
        this.setModuloAcesso(RelatorioAcumuladoMedicos.getModuloAcesso());
        this.setCamposConfigurador(campos);
        String parametros = ParametrosUsuarios.getValor(listaUltimoFiltro.get(0));
        if (!Funcoes.textoVazio(parametros)) {
            this.carregarFiltros(parametros);
        }
    }

    private void listaParametros() {
        listaUltimoFiltro.put(0, "RelatorioAcumuladoMedicos.ultimoFiltro");
    }

    private void carregarFiltros(String parametros) {
        this.setSelecionados(parametros, "filial", "filtroFilial");
        this.setSelecionadosFiltroAvancado(parametros, "medicos", "medico", "filtroMedico", 4);
        this.setSelecionados(parametros, "especialidade", "filtroEspecialidade");
        this.setSelecionados(parametros, "coleta", "filtroColeta");
        this.setSelecionados(parametros, "destino", "filtroDestino");
        this.setSelecionados(parametros, "grupo", "filtroGrupo");
        this.setSelecionados(parametros, "setor", "filtroSetor");
        this.setSelecionados(parametros, "exame", "filtroExame");
        this.setSelecionados(parametros, "convenio", "filtroConvenio");
        this.setSelecionadosFiltroData(parametros, "dataInicial", "filtroDataInicial");
        this.setSelecionadosFiltroData(parametros, "dataFinal", "filtroDataFinal");
        this.setSelecionadosFiltroCombo(parametros, "ufMedico", "ordemUfMedico");
        this.setSelecionadosFiltroCombo(parametros, "ordemRelatorio", "ordemRelatorio");
    }

    private void setSelecionados(String parametros, String filtro, String tipoFiltro) {
        String tmp = StringUtil.getValor(parametros, filtro);
        if (!Funcoes.textoVazio(tmp)) {
            this.setSelecionadosFiltro(tipoFiltro, 0, tmp.split(","));
        }
    }

    private void setSelecionadosFiltroData(String parametros, String filtro, String tipoFiltro) {
        String tmp = StringUtil.getValor(parametros, filtro);
        if (!Funcoes.textoVazio(tmp)) {
            this.setFiltroData(tipoFiltro, tmp);
        }
    }

    private void setSelecionadosFiltroCombo(String parametros, String filtro, String tipoFiltro) {
        String tmp = StringUtil.getValor(parametros, filtro);
        if (!Funcoes.textoVazio(tmp)) {
            this.setFiltroCombo(tipoFiltro, tmp);
        }
    }

    private void setSelecionadosFiltroAvancado(String parametros, String filtro, String filhoFiltro, String tipoFiltro, Integer colunas) {
        String tmp = StringUtil.getValor(parametros, filtro);
        if (!Funcoes.textoVazio(tmp)) {
            String[] lista = StringUtil.getValores(tmp, filhoFiltro);
            Object[] objFiltro = new Object[lista.length];
            for (int i = 0; i < lista.length; ++i) {
                String valor;
                String valores = lista[i];
                Object[] aux = new Object[colunas.intValue()];
                int j = 0;
                while (!Funcoes.textoVazio(valor = StringUtil.getValor(valores, String.valueOf(j)))) {
                    aux[j++] = valor;
                }
                objFiltro[i] = aux;
            }
            this.setSelecionadosFiltroAvancado(tipoFiltro, objFiltro);
        }
    }

    @Override
    public void imprimirPressionado() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            String[] exames;
            String[] setor;
            String[] grupos;
            String[] convenios;
            String[] destinos;
            String[] coletas;
            String layout = this.getLayoutRelatorio();
            for (int i = 0; i < campos.length; ++i) {
                camposUtilizados.put(campos[i], campos[i]);
            }
            HashMap<String, String> camposRelatorio = Relatorio.getCamposBancoLayout(layout, camposUtilizados, this.getCamposObrigatorios());
            Statement st = Conexao.getStatement();
            Statement st2 = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            buf.append("select count(a.exa_codigo) as quantidadeExames, ");
            buf.append("sum(calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo, true, false, false, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", a.met_codigo").append(")) as valorExame, ");
            buf.append("sum(calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo, true, false, true, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", a.met_codigo").append(")) as valorTotalExame, ");
            buf.append("sum(a.exr_vlrmaterial) as valorMaterial, ");
            buf.append("sum(calculachexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo)) as valorCH, ");
            buf.append("sum(a.exr_vlrchexame) as valorCHOriginal, ");
            buf.append("sum(a.exr_custosimples) AS valorCustoSimplesExameHistorico, ");
            buf.append("sum(examatcol.emc_custosimples) AS valorCustoSimplesExameAtual, ");
            buf.append("d.med_nome as nomeMedico, ");
            buf.append("d.med_conselho as conselhoMedico, ");
            buf.append("d.med_crm as crmMedico, ");
            buf.append("d.med_uf as ufMedico, ");
            if (this.campoEnderecoUtilizado(camposRelatorio)) {
                buf.append("d.med_endereco as enderecoMedico, ");
            }
            buf.append("count(distinct b.req_codigo) as quantidadeRequisicoes, ");
            buf.append(StringUtil.textoDBEscape(Variaveis.descricaoFilialPadrao)).append(" as descricaoFilial ");
            if (this.camposFiliaisUtilizados(camposRelatorio)) {
                buf.append(",").append(this.SELECT_FILIAL);
            }
            buf.append("from examerequisicao a ");
            buf.append("join requisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            buf.append("left join exames c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo ");
            buf.append("left join examematcoleta examatcol on c.fil_codigo = examatcol.fil_codigo and c.exa_codigo = examatcol.exa_codigo and a.mco_codigo = examatcol.mco_codigo ");
            buf.append("left join medico d on a.fil_codigo = d.fil_codigo and b.med_conselho = d.med_conselho and b.med_crm = d.med_crm and b.med_uf = d.med_uf ");
            buf.append("left join convenios con on b.fil_codigo = con.fil_codigo and b.con_codigo = con.con_codigo ");
            buf.append("left join examesetor e on a.fil_codigo = e.fil_codigo and a.exa_codigo = e.exa_codigo and e.ese_default = true ");
            buf.append("left join examematgrupo g on a.fil_codigo = g.fil_codigo and a.exa_codigo = g.exa_codigo and a.mco_codigo = g.mco_codigo ");
            buf.append("left join setores f on e.fil_codigo = f.fil_codigo and e.set_codigo = f.set_codigo ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            StringBuilder bufWhere = new StringBuilder();
            String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
            if (filiais == null) {
                filiais = new String[]{Variaveis.filialPadrao};
            }
            bufWhere.append(" where a.fil_codigo in (");
            for (int i = 0; i < filiais.length; ++i) {
                bufWhere.append(filiais[i]);
                if (i >= filiais.length - 1) continue;
                bufWhere.append(", ");
            }
            bufWhere.append(") ");
            String[] conselho = this.getSelecionadosFiltroAvancado("filtroMedico", 0);
            String[] medico = this.getSelecionadosFiltroAvancado("filtroMedico", 1);
            String[] medicoUf = this.getSelecionadosFiltroAvancado("filtroMedico", 2);
            if (medico != null && medico.length <= ParametrosGerais.getQuantidadeMaximoFiltroAvancado()) {
                bufWhere.append(" and (");
                for (int i = 0; i < medico.length; ++i) {
                    bufWhere.append("(d.med_conselho = '");
                    bufWhere.append(conselho[i]);
                    bufWhere.append("' and d.med_crm = '");
                    bufWhere.append(medico[i]);
                    bufWhere.append("' and d.med_uf = '");
                    bufWhere.append(medicoUf[i]);
                    bufWhere.append("') ");
                    if (i >= medico.length - 1) continue;
                    bufWhere.append(" or ");
                }
                bufWhere.append(") ");
            }
            if ((coletas = this.getSelecionadosFiltro("filtroColeta", 0)) != null) {
                bufWhere.append(" and b.col_codigo in (");
                for (int i = 0; i < coletas.length; ++i) {
                    bufWhere.append("'");
                    bufWhere.append(coletas[i]);
                    bufWhere.append("'");
                    if (i >= coletas.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((destinos = this.getSelecionadosFiltro("filtroDestino", 0)) != null) {
                bufWhere.append(" and b.des_codigo in (");
                for (int i = 0; i < destinos.length; ++i) {
                    bufWhere.append("'");
                    bufWhere.append(destinos[i]);
                    bufWhere.append("'");
                    if (i >= destinos.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((convenios = this.getSelecionadosFiltro("filtroConvenio", 0)) != null) {
                bufWhere.append(" and b.con_codigo in (");
                for (int i = 0; i < convenios.length; ++i) {
                    bufWhere.append(convenios[i]);
                    if (i >= convenios.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((grupos = this.getSelecionadosFiltro("filtroGrupo", 0)) != null) {
                bufWhere.append(" and g.grp_codigo in (");
                for (int i = 0; i < grupos.length; ++i) {
                    bufWhere.append("'");
                    bufWhere.append(grupos[i]);
                    bufWhere.append("'");
                    if (i >= grupos.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((setor = this.getSelecionadosFiltro("filtroSetor", 0)) != null) {
                bufWhere.append(" and e.set_codigo in (");
                for (int i = 0; i < setor.length; ++i) {
                    bufWhere.append(setor[i]);
                    if (i >= setor.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((exames = this.getSelecionadosFiltro("filtroExame", 0)) != null) {
                bufWhere.append(" and a.exa_codigo in (");
                for (int i = 0; i < exames.length; ++i) {
                    bufWhere.append("'");
                    bufWhere.append(exames[i]);
                    bufWhere.append("'");
                    if (i >= exames.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                bufWhere.append(" and b.req_data >= '");
                bufWhere.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial")));
                bufWhere.append("'");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                bufWhere.append(" and b.req_data <= '");
                bufWhere.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal")));
                bufWhere.append("'");
            }
            if (!Funcoes.textoVazio(this.getFiltroCombo("ordemUfMedico").toString())) {
                bufWhere.append(" and d.med_uf  = '").append(this.getFiltroCombo("ordemUfMedico")).append("'");
            }
            bufWhere.append(" and b.req_excluida = false and a.exr_excluido = false ");
            String[] medEspecialidades = this.getSelecionadosFiltro("filtroEspecialidade", 0);
            if (medEspecialidades != null && medEspecialidades.length > 0) {
                bufWhere.append(" and (b.fil_codigo, b.med_crm, b.med_conselho, b.med_uf) in  (select fil_codigo, med_crm, med_conselho, med_uf from medicoespecialidades where b.fil_codigo = fil_codigo and b.med_conselho = med_conselho and b.med_crm = med_crm and b.med_uf = med_uf");
                bufWhere.append(" and esp_codigo in (");
                for (int i = 0; i < medEspecialidades.length; ++i) {
                    bufWhere.append("'");
                    bufWhere.append(medEspecialidades[i]);
                    bufWhere.append("'");
                    if (i >= medEspecialidades.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")) ");
            }
            buf.append(bufWhere.toString());
            buf.append(" group by a.fil_codigo,");
            if (this.camposFiliaisUtilizados(camposRelatorio)) {
                buf.append("filial.fil_codigo, ");
                buf.append("filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, ");
                buf.append("filial.fil_complemento, filial.fil_cep, filial.fil_fone, ");
                buf.append("filial.fil_fax, filial.fil_razaosocial, cidadefilial.cid_codigo, ");
                buf.append("cidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo, ");
                buf.append("bairrofilial.bai_descricao, filial.fil_cnes, ");
            }
            buf.append("d.med_conselho, d.med_crm, d.med_uf, d.med_nome ");
            if (this.campoEnderecoUtilizado(camposRelatorio)) {
                buf.append(", d.med_endereco");
            }
            buf.append(" order by a.fil_codigo,");
            if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[1])) {
                buf.append("d.med_nome");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[2])) {
                buf.append("quantidadeExames asc ");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[3])) {
                buf.append("quantidadeExames desc ");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[4])) {
                buf.append("d.med_endereco, d.med_conselho, d.med_crm ");
            } else {
                buf.append("d.med_conselho, d.med_crm ");
            }
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                int i;
                ModeloGridTable modelo = new ModeloGridTable(campos);
                do {
                    Object[] o = new Object[campos.length];
                    for (int i2 = 0; i2 < campos.length; ++i2) {
                        if (RelatorioUtil.possuiColuna(rs, campos[i2]) <= -1) continue;
                        o[i2] = rs.getObject(campos[i2]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                if (this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
                    String codigoFilial = Variaveis.filialPadrao;
                    if (this.getSelecionadosFiltro("filtroFilial", 0) != null && this.getSelecionadosFiltro("filtroFilial", 0).length == 1) {
                        codigoFilial = this.getSelecionadosFiltro("filtroFilial", 0)[0];
                    }
                    Registro regFilial = RelatorioUtil.pegaDadosFilial(st, codigoFilial);
                    RelatorioUtil.preencheDadosFilial(regFilial, modelo);
                }
                Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                gerador.setPai(this.panelCentro);
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                gerador.setAcaoFechar(new Runnable(){

                    @Override
                    public void run() {
                        RelatorioAcumuladoMedicos.this.panelCentro.removeAll();
                        RelatorioAcumuladoMedicos.this.panelCentro.repaint();
                        RelatorioAcumuladoMedicos.this.habilitaBotaoImprimir(true);
                    }
                });
                HashMap<String, Object> var = new HashMap<String, Object>();
                StringBuilder p = new StringBuilder();
                var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                var.put("ordemUfMedico", this.getFiltroCombo("ordemUfMedico"));
                p.append(RelatorioAcumuladoMedicos.gravaParametro(this.getFiltroData("filtroDataInicial"), "dataInicial"));
                p.append(RelatorioAcumuladoMedicos.gravaParametro(this.getFiltroData("filtroDataFinal"), "dataFinal"));
                p.append(RelatorioAcumuladoMedicos.gravaParametro((String)this.getFiltroCombo("ordemRelatorio"), "ordemRelatorio"));
                p.append(RelatorioAcumuladoMedicos.gravaParametro((String)this.getFiltroCombo("ordemUfMedico"), "ufMedico"));
                buf.delete(0, buf.length());
                if (filiais != null) {
                    for (i = 0; i < filiais.length; ++i) {
                        buf.append(filiais[i]);
                        if (i >= filiais.length - 1) continue;
                        buf.append(",");
                    }
                    p.append(RelatorioAcumuladoMedicos.gravaParametro(buf.toString(), "filial"));
                }
                var.put("filtroFilial", buf.toString());
                buf.delete(0, buf.length());
                if (conselho != null && medicoUf != null) {
                    Object[] valores = this.getSelecionadosFiltroAvancado("filtroMedico");
                    StringBuilder med = new StringBuilder();
                    for (int i3 = 0; i3 < valores.length; ++i3) {
                        med.append("<").append("medico").append(">");
                        Object[] valor = (Object[])valores[i3];
                        for (int j = 0; j < valor.length; ++j) {
                            med.append("<").append(j).append(">");
                            med.append(valor[j]);
                            med.append("</").append(j).append(">");
                        }
                        med.append("</").append("medico").append(">");
                        buf.append(valor[0]).append(":").append(valor[1]).append("(").append(valor[2]).append(")");
                    }
                    p.append(RelatorioAcumuladoMedicos.gravaParametro(med.toString(), "medicos"));
                }
                var.put("filtroMedico", buf.toString());
                buf.delete(0, buf.length());
                if (medEspecialidades != null) {
                    for (i = 0; i < medEspecialidades.length; ++i) {
                        buf.append(medEspecialidades[i]);
                        if (i >= medEspecialidades.length - 1) continue;
                        buf.append(",");
                    }
                    p.append(RelatorioAcumuladoMedicos.gravaParametro(buf.toString(), "especialidade"));
                }
                var.put("filtroEspecialidade", buf.toString());
                buf.delete(0, buf.length());
                if (convenios != null) {
                    for (i = 0; i < convenios.length; ++i) {
                        buf.append(convenios[i]);
                        if (i >= convenios.length - 1) continue;
                        buf.append(",");
                    }
                    p.append(RelatorioAcumuladoMedicos.gravaParametro(buf.toString(), "convenio"));
                }
                var.put("filtroConvenio", buf.toString());
                buf.delete(0, buf.length());
                if (coletas != null) {
                    for (i = 0; i < coletas.length; ++i) {
                        buf.append(coletas[i]);
                        if (i >= coletas.length - 1) continue;
                        buf.append(",");
                    }
                    p.append(RelatorioAcumuladoMedicos.gravaParametro(buf.toString(), "coleta"));
                }
                var.put("filtroColeta", buf.toString());
                buf.delete(0, buf.length());
                if (destinos != null) {
                    for (i = 0; i < destinos.length; ++i) {
                        buf.append(destinos[i]);
                        if (i >= destinos.length - 1) continue;
                        buf.append(",");
                    }
                    p.append(RelatorioAcumuladoMedicos.gravaParametro(buf.toString(), "destino"));
                }
                var.put("filtroDestino", buf.toString());
                buf.delete(0, buf.length());
                if (exames != null) {
                    for (i = 0; i < exames.length; ++i) {
                        buf.append(exames[i]);
                        if (i >= exames.length - 1) continue;
                        buf.append(",");
                    }
                    p.append(RelatorioAcumuladoMedicos.gravaParametro(buf.toString(), "exame"));
                }
                var.put("filtroExame", buf.toString());
                buf.delete(0, buf.length());
                if (grupos != null) {
                    for (i = 0; i < grupos.length; ++i) {
                        buf.append(grupos[i]);
                        if (i >= grupos.length - 1) continue;
                        buf.append(",");
                    }
                    p.append(RelatorioAcumuladoMedicos.gravaParametro(buf.toString(), "grupo"));
                }
                var.put("filtroGrupo", buf.toString());
                buf.delete(0, buf.length());
                if (setor != null) {
                    for (i = 0; i < setor.length; ++i) {
                        buf.append(setor[i]);
                        if (i >= setor.length - 1) continue;
                        buf.append(",");
                    }
                    p.append(RelatorioAcumuladoMedicos.gravaParametro(buf.toString(), "setor"));
                }
                var.put("filtroSetor", buf.toString());
                ParametrosUsuarios.setValor(listaUltimoFiltro.get(0), p.toString());
                ParametrosUsuarios.salvarParametros(true);
                gerador.executar(layout, (TableModel)modelo, var);
                this.panelCentro.revalidate();
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            Conexao.fecharStatement(st);
            Conexao.fecharStatement(st2);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RelatorioAcumuladoMedicos");
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private boolean campoEnderecoUtilizado(HashMap<String, String> camposRelatorio) {
        return camposRelatorio.containsKey("enderecomedico");
    }

    private HashMap<String, String> getCamposObrigatorios() {
        HashMap<String, String> camposObrigatorios = new HashMap<String, String>();
        camposObrigatorios.put("quantidadeExames", "quantidadeExames");
        camposObrigatorios.put("valorExame", "valorExame");
        camposObrigatorios.put("valorTotalExame", "valorTotalExame");
        camposObrigatorios.put("valorMaterial", "valorMaterial");
        camposObrigatorios.put("valorCH", "valorCH");
        camposObrigatorios.put("valorCHOriginal", "valorCHOriginal");
        camposObrigatorios.put("valorCustoSimplesExameHistorico", "valorCustoSimplesExameHistorico");
        camposObrigatorios.put("valorCustoSimplesExameAtual", "valorCustoSimplesExameAtual");
        camposObrigatorios.put("nomeMedico", "nomeMedico");
        camposObrigatorios.put("conselhoMedico", "conselhoMedico");
        camposObrigatorios.put("crmMedico", "crmMedico");
        camposObrigatorios.put("ufMedico", "ufMedico");
        camposObrigatorios.put("enderecoMedico", "enderecoMedico");
        camposObrigatorios.put("quantidadeRequisicoes", "quantidadeRequisicoes");
        camposObrigatorios.put("descricaoFilial", "descricaoFilial");
        return camposObrigatorios;
    }

    private boolean camposFiliaisUtilizados(HashMap<String, String> camposRelatorio) {
        return camposRelatorio.containsKey("codigofilial") || camposRelatorio.containsKey("filialdescricao") || camposRelatorio.containsKey("cnpjfilial") || camposRelatorio.containsKey("enderecofilial") || camposRelatorio.containsKey("complementofilial") || camposRelatorio.containsKey("cepfilial") || camposRelatorio.containsKey("fonefilial") || camposRelatorio.containsKey("faxfilial") || camposRelatorio.containsKey("razaoSocialfilial") || camposRelatorio.containsKey("cnesfilial") || camposRelatorio.containsKey("codigocidadefilial") || camposRelatorio.containsKey("descricaocidadefilial") || camposRelatorio.containsKey("estadocidadefilial") || camposRelatorio.containsKey("codigobairrofilial") || camposRelatorio.containsKey("descricaobairrofilial");
    }

    private String getLayoutRelatorio() throws SQLException {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
        buf.append(RelatorioAcumuladoMedicos.getModuloAcesso());
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            return rs.getString("rel_xml");
        }
        return null;
    }

    private static String gravaParametro(String valor, String parametro) {
        return String.format("<%s>%s</%s>", parametro, valor, parametro);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0880300200");
    }

    private long getModuloConfigurar() {
        return Long.parseLong("0880300201");
    }
}

