/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.gerencial;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.laboratorio.relatorios.util.RelatorioUtil;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioAcumuladoGrupos
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String[] ordem = new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Quantidade"};
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_COLETA = "filtroColeta";
    private final String FILTRO_DESTINO = "filtroDestino";
    private final String FILTRO_SETOR = "filtroSetor";
    private final String FILTRO_GRUPO = "filtroGrupo";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    protected static String[] campos;

    public RelatorioAcumuladoGrupos() {
        campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoGrupo", "descricaoGrupo", "valorExame", "valorMaterial", "valorCH", "valorTotalExame", "quantidadeExames", "quantidadeRequisicoes", "valorCustoSimplesExameHistorico", "valorCustoSimplesExameAtual"});
        this.montaBarraDescricao("Relat\u00f3rio acumulado por grupo", "Listagem de exames e requisi\u00e7\u00f5es no per\u00edodo por grupo", "relatorios/rel_gerencial_acumulados_acumulado_grupo.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroGrupo", "Grupo", "grupo", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"grp_codigo", "grp_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroColeta", "Coleta", "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroDestino", Variaveis.tipoFilialPadrao.equals("A") ? "Modalidade" : "Destino", "destino", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroSetor", "Setor", "setores", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.setModuloConfigurar(this.getModuloConfigurar());
        this.setModuloAcesso(RelatorioAcumuladoGrupos.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    @Override
    public void imprimirPressionado() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        try {
            String[] setor;
            String[] destinos;
            String[] coletas;
            String[] grupos;
            StringBuilder buf = new StringBuilder();
            buf.append("select count(distinct(cast(a.fil_codigo as text)||a.req_codigo||a.exa_codigo||a.mco_codigo)) as quantidadeExames, ");
            buf.append("sum(calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo, true, false, false, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, d.con_precosdiferenciados, d.con_reajuste, d.con_cobrmaterial, d.con_percpgtomaterial, d.con_percpgto, d.con_tpcalcfatu, d.con_tpcalcch, d.con_perguntarpercbalcao, d.con_acrescimo, d.con_bonus, d.tpe_codigo, d.con_acrescimoporte, d.con_acrescimouco, d.con_descontoporte, d.con_descontouco, d.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", a.met_codigo").append(")) as valorExame, ");
            buf.append("sum(calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo, true, false, true, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, d.con_precosdiferenciados, d.con_reajuste, d.con_cobrmaterial, d.con_percpgtomaterial, d.con_percpgto, d.con_tpcalcfatu, d.con_tpcalcch, d.con_perguntarpercbalcao, d.con_acrescimo, d.con_bonus, d.tpe_codigo, d.con_acrescimoporte, d.con_acrescimouco, d.con_descontoporte, d.con_descontouco, d.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", a.met_codigo").append(")) as valorTotalExame, ");
            buf.append("sum(a.exr_vlrmaterial) as valorMaterial, ");
            buf.append("sum(a.exr_vlrchexame) as valorCHOriginal, ");
            buf.append("sum(calculachexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo)) as valorCH, ");
            buf.append("sum(a.exr_custosimples) AS valorCustoSimplesExameHistorico, ");
            buf.append("sum(examatcol.emc_custosimples) AS valorCustoSimplesExameAtual,\t ");
            buf.append("h.grp_codigo as codigoGrupo, ");
            buf.append("h.grp_descricao as descricaoGrupo, ");
            buf.append("count(distinct(cast(a.fil_codigo as text)||a.req_codigo)) as quantidadeRequisicoes ");
            if (this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
                buf.append(", ").append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            }
            buf.append("from examerequisicao a ");
            buf.append("join requisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            buf.append("left join exames c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo ");
            buf.append("left join examematcoleta examatcol on a.fil_codigo = examatcol.fil_codigo and a.exa_codigo = examatcol.exa_codigo and a.mco_codigo = examatcol.mco_codigo ");
            buf.append("left join convenios d on a.fil_codigo = d.fil_codigo and b.con_codigo = d.con_codigo ");
            buf.append("left join examesetor e on a.fil_codigo = e.fil_codigo and a.exa_codigo = e.exa_codigo and e.ese_default = true ");
            buf.append("left join examematgrupo g on a.fil_codigo = g.fil_codigo and a.exa_codigo = g.exa_codigo and a.mco_codigo = g.mco_codigo ");
            buf.append("left join setores f on e.fil_codigo = f.fil_codigo and e.set_codigo = f.set_codigo ");
            buf.append("left join grupo h on g.fil_codigo = h.fil_codigo and g.grp_codigo = h.grp_codigo ");
            if (this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            }
            StringBuilder bufWhere = new StringBuilder();
            String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
            if (filiais == null) {
                filiais = new String[]{Variaveis.filialPadrao};
            }
            bufWhere.append(" where a.fil_codigo in (");
            for (int i = 0; i < filiais.length; ++i) {
                bufWhere.append(filiais[i]);
                if (i >= filiais.length - 1) continue;
                bufWhere.append(", ");
            }
            bufWhere.append(") and h.grp_codigo is not null");
            String[] convenio = this.getSelecionadosFiltro("filtroConvenio", 0);
            if (convenio != null) {
                bufWhere.append(" and b.con_codigo in (");
                for (int i = 0; i < convenio.length; ++i) {
                    bufWhere.append(convenio[i]);
                    if (i >= convenio.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((grupos = this.getSelecionadosFiltro("filtroGrupo", 0)) != null) {
                bufWhere.append(" and g.grp_codigo in (");
                for (int i = 0; i < grupos.length; ++i) {
                    bufWhere.append("'");
                    bufWhere.append(grupos[i]);
                    bufWhere.append("'");
                    if (i >= grupos.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((coletas = this.getSelecionadosFiltro("filtroColeta", 0)) != null) {
                bufWhere.append(" and b.col_codigo in (");
                for (int i = 0; i < coletas.length; ++i) {
                    bufWhere.append("'");
                    bufWhere.append(coletas[i]);
                    bufWhere.append("'");
                    if (i >= coletas.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((destinos = this.getSelecionadosFiltro("filtroDestino", 0)) != null) {
                bufWhere.append(" and b.des_codigo in (");
                for (int i = 0; i < destinos.length; ++i) {
                    bufWhere.append("'");
                    bufWhere.append(destinos[i]);
                    bufWhere.append("'");
                    if (i >= destinos.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((setor = this.getSelecionadosFiltro("filtroSetor", 0)) != null) {
                bufWhere.append(" and e.set_codigo in (");
                for (int i = 0; i < setor.length; ++i) {
                    bufWhere.append(setor[i]);
                    if (i >= setor.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                bufWhere.append(" and b.req_data >= '");
                bufWhere.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial")));
                bufWhere.append("'");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                bufWhere.append(" and b.req_data <= '");
                bufWhere.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal")));
                bufWhere.append("'");
            }
            bufWhere.append(" and b.req_excluida = false and a.exr_excluido = false ");
            buf.append(bufWhere.toString());
            buf.append(" group by ");
            if (this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
                buf.append("filial.fil_codigo, ");
                buf.append("filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, ");
                buf.append("filial.fil_complemento, filial.fil_cep, filial.fil_fone, ");
                buf.append("filial.fil_fax, filial.fil_razaosocial, cidadefilial.cid_codigo, ");
                buf.append("cidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo, ");
                buf.append("bairrofilial.bai_descricao, filial.fil_cnes, ");
            }
            buf.append("h.grp_codigo, h.grp_descricao ");
            buf.append(" order by ");
            if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[1])) {
                buf.append("h.grp_descricao");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[2])) {
                buf.append("1");
            } else {
                buf.append("h.grp_codigo ");
            }
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(campos);
                do {
                    Object[] o = new Object[campos.length];
                    for (int i = 0; i < campos.length; ++i) {
                        if (RelatorioUtil.possuiColuna(rs, campos[i]) < 0) continue;
                        o[i] = rs.getObject(campos[i]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                String codigoFilial = Variaveis.filialPadrao;
                if (this.getSelecionadosFiltro("filtroFilial", 0) != null && this.getSelecionadosFiltro("filtroFilial", 0).length == 1) {
                    codigoFilial = this.getSelecionadosFiltro("filtroFilial", 0)[0];
                }
                Registro regFilial = RelatorioUtil.pegaDadosFilial(st, codigoFilial);
                RelatorioUtil.preencheDadosFilial(regFilial, modelo);
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioAcumuladoGrupos.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    int i;
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioAcumuladoGrupos.this.panelCentro.removeAll();
                            RelatorioAcumuladoGrupos.this.panelCentro.repaint();
                            RelatorioAcumuladoGrupos.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                    var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                    var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                    buf.delete(0, buf.length());
                    if (filiais != null) {
                        for (i = 0; i < filiais.length; ++i) {
                            buf.append(filiais[i]);
                            if (i >= filiais.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroFilial", buf.toString());
                    buf.delete(0, buf.length());
                    if (convenio != null) {
                        for (i = 0; i < convenio.length; ++i) {
                            buf.append(convenio[i]);
                            if (i >= convenio.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroConvenio", buf.toString());
                    buf.delete(0, buf.length());
                    if (grupos != null) {
                        for (i = 0; i < grupos.length; ++i) {
                            buf.append(grupos[i]);
                            if (i >= grupos.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroGrupo", buf.toString());
                    buf.delete(0, buf.length());
                    if (setor != null) {
                        for (i = 0; i < setor.length; ++i) {
                            buf.append(setor[i]);
                            if (i >= setor.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroSetor", buf.toString());
                    buf.delete(0, buf.length());
                    if (coletas != null) {
                        for (i = 0; i < coletas.length; ++i) {
                            buf.append(coletas[i]);
                            if (i >= coletas.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroColeta", buf.toString());
                    buf.delete(0, buf.length());
                    if (destinos != null) {
                        for (i = 0; i < destinos.length; ++i) {
                            buf.append(destinos[i]);
                            if (i >= destinos.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroDestino", buf.toString());
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RelatorioAcumuladoGrupos (290)");
        }
        Conexao.fecharStatement(st, st2);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0880300500");
    }

    private long getModuloConfigurar() {
        return Long.parseLong("0880300501");
    }
}

