/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.gerencial;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.laboratorio.relatorios.util.RelatorioUtil;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableModel;

public class RelatorioAcumuladoDigitador
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private static final String[] ordem = new String[]{"C\u00f3digo", "Nome"};
    private static final String FILTRO_FILIAL = "filtroFilial";
    private static final String FILTRO_CONVENIO = "filtroConvenio";
    private static final String FILTRO_COLETA = "filtroColeta";
    private static final String FILTRO_DIGITADOR = "filtroDigitador";
    private static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private static final String FILTRO_SITUACAO = "filtroSituacao";
    private static final String FILTRO_ORDEM = "ordemRelatorio";
    private static final String FILTRO_HORA_INICIAL = "filtroHoraInicial";
    private static final String FILTRO_HORA_FINAL = "filtroHoraFinal";
    private static final String FILTRO_INTERVALO_HORA = "filtroIntervaloHora";
    private static final String FILTRO_DETALHAR_DATA = "filtroDetalharData";
    private static String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio", "valorExame", "valorMaterial", "valorCH", "valorTotalExame", "quantidadeExames", "quantidadeRequisicoes", "codigoDigitador", "nomeDigitador", "data", "horaPrimeira", "horaUltima", "diaSemana", "valorCHOriginal", "valorCustoSimplesExameHistorico", "valorCustoSimplesExameAtual"});
    public static final int TIPO_NAO_DETALHAR = 0;
    public static final int TIPO_DETALHAR = 1;
    private int tipoRelatorio = 1;

    public RelatorioAcumuladoDigitador(int tipoRelatorio) {
        this.tipoRelatorio = tipoRelatorio;
        this.montaBarraDescricao("Relat\u00f3rio acumulado por digitador", "Listagem de quantidade de exames e requisi\u00e7\u00f5es no per\u00edodo por digitador", "relatorios/rel_ger_acumulados_acumulado_usuariodigitador.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro(FILTRO_FILIAL, "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_CONVENIO, "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_COLETA, "Coleta", "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_DIGITADOR, "Digitador", "usuario", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_SITUACAO, "Situa\u00e7\u00e3o", "situacao", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"sit_codigo", "sit_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Data inicial:");
        this.adicionaFiltroData(FILTRO_DATA_FINAL, "Data final:");
        this.adicionaFiltroHora(FILTRO_HORA_INICIAL, "Hora inicial:");
        this.adicionaFiltroHora(FILTRO_HORA_FINAL, "Hora final:");
        this.adicionaFiltroCheck(FILTRO_INTERVALO_HORA, "Intervalo de Data", false);
        JCheckBox checkDetalhar = null;
        if (Acesso.getAcesso(RelatorioAcumuladoDigitador.getModuloAcesso(1))) {
            checkDetalhar = this.adicionaRetornaFiltroCheck(FILTRO_DETALHAR_DATA, "Detalhar por Data", false);
        }
        if (checkDetalhar != null) {
            checkDetalhar.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (((JCheckBox)e.getSource()).isSelected()) {
                        RelatorioAcumuladoDigitador.this.setModuloConfigurar(RelatorioAcumuladoDigitador.getModuloConfigurar(1));
                        RelatorioAcumuladoDigitador.this.setModuloAcesso(RelatorioAcumuladoDigitador.getModuloAcesso(1));
                    } else {
                        RelatorioAcumuladoDigitador.this.setModuloConfigurar(RelatorioAcumuladoDigitador.getModuloConfigurar(0));
                        RelatorioAcumuladoDigitador.this.setModuloAcesso(RelatorioAcumuladoDigitador.getModuloAcesso(0));
                    }
                }
            });
        }
        this.adicionaFiltroCombo(FILTRO_ORDEM, "Ordem:", ordem, 0);
        this.setModuloConfigurar(RelatorioAcumuladoDigitador.getModuloConfigurar(0));
        this.setModuloAcesso(RelatorioAcumuladoDigitador.getModuloAcesso(0));
        this.setCamposConfigurador(campos);
    }

    @Override
    public void imprimirPressionado() {
        if (this.getFiltroCheck(FILTRO_INTERVALO_HORA)) {
            if (!this.getFiltroData(FILTRO_DATA_INICIAL).isEmpty() && this.getFiltroHora(FILTRO_HORA_INICIAL).isEmpty()) {
                Funcoes.mensagem(this, "O filtro de HORA INICIAL deve ser preenchido.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            if (this.getFiltroData(FILTRO_DATA_INICIAL).isEmpty() && !this.getFiltroHora(FILTRO_HORA_INICIAL).isEmpty()) {
                Funcoes.mensagem(this, "O filtro de DATA INICIAL deve ser preenchido.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            if (!this.getFiltroData(FILTRO_DATA_FINAL).isEmpty() && this.getFiltroHora(FILTRO_HORA_FINAL).isEmpty()) {
                Funcoes.mensagem(this, "O filtro de HORA FINAL deve ser preenchido.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            if (this.getFiltroData(FILTRO_DATA_FINAL).isEmpty() && !this.getFiltroHora(FILTRO_HORA_FINAL).isEmpty()) {
                Funcoes.mensagem(this, "O filtro de DATA FINAL deve ser preenchido.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
        }
        if (this.getFiltroCheck(FILTRO_DETALHAR_DATA)) {
            this.setModuloConfigurar(RelatorioAcumuladoDigitador.getModuloConfigurar(1));
            this.setModuloAcesso(RelatorioAcumuladoDigitador.getModuloAcesso(1));
        } else {
            this.setModuloConfigurar(RelatorioAcumuladoDigitador.getModuloConfigurar(0));
            this.setModuloAcesso(RelatorioAcumuladoDigitador.getModuloAcesso(0));
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        try {
            ResultSet rs;
            String[] situacao;
            String[] coletas;
            String[] digitador;
            StringBuilder buf = new StringBuilder();
            buf.append("select count(a.exa_codigo) as quantidadeExames, ");
            buf.append("       sum(calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo, true, false, false, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, d.con_precosdiferenciados, d.con_reajuste, d.con_cobrmaterial, d.con_percpgtomaterial, d.con_percpgto, d.con_tpcalcfatu, d.con_tpcalcch, d.con_perguntarpercbalcao, d.con_acrescimo, d.con_bonus, d.tpe_codigo, d.con_acrescimoporte, d.con_acrescimouco, d.con_descontoporte, d.con_descontouco, d.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", a.met_codigo").append(")) as valorExame, ");
            buf.append("       sum(calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo, true, false, true, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, d.con_precosdiferenciados, d.con_reajuste, d.con_cobrmaterial, d.con_percpgtomaterial, d.con_percpgto, d.con_tpcalcfatu, d.con_tpcalcch, d.con_perguntarpercbalcao, d.con_acrescimo, d.con_bonus, d.tpe_codigo, d.con_acrescimoporte, d.con_acrescimouco, d.con_descontoporte, d.con_descontouco, d.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", a.met_codigo").append(")) as valorTotalExame, ");
            buf.append("       sum(a.exr_vlrmaterial) as valorMaterial, ");
            buf.append("       sum(calculachexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo)) as valorCH, ");
            buf.append("       sum(a.exr_vlrchexame) as valorCHOriginal, ");
            buf.append("\t\t\t sum(a.exr_custosimples) AS valorCustoSimplesExameHistorico, ");
            buf.append("\t\t\t sum(examatcol.emc_custosimples) AS valorCustoSimplesExameAtual,\t ");
            if (this.getFiltroCheck(FILTRO_DETALHAR_DATA)) {
                buf.append("       min(cast(a.exr_datadigita as time)) as horaPrimeira, ");
                buf.append("       max(cast(a.exr_datadigita as time)) as horaUltima, ");
                buf.append("       extract(DOW from a.exr_datadigita) as diaSemana, ");
                buf.append("       date_trunc('day', a.exr_datadigita) as data, ");
                buf.append("       0 as quantidadeRequisicoes, ");
            } else {
                buf.append("       count(distinct b.req_codigo) as quantidadeRequisicoes, ");
            }
            buf.append("       a.usr_coddigitador as codigodigitador, ");
            buf.append("       usr.usr_nome as nomeDigitador ");
            if (this.getSelecionadosFiltro(FILTRO_FILIAL, 0) == null || this.getSelecionadosFiltro(FILTRO_FILIAL, 0).length <= 1) {
                buf.append(",").append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            }
            buf.append("  from examerequisicao a ");
            buf.append("  join requisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            buf.append("\tleft join examematcoleta examatcol on a.fil_codigo = examatcol.fil_codigo and a.exa_codigo = examatcol.exa_codigo and a.mco_codigo = examatcol.mco_codigo ");
            buf.append("  left join exames c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo ");
            buf.append("  left join convenios d on a.fil_codigo = d.fil_codigo and b.con_codigo = d.con_codigo ");
            buf.append("  left join situacao sit on b.fil_codigo = sit.fil_codigo and b.sit_codigo = sit.sit_codigo ");
            buf.append("  join usuario usr on a.usr_coddigitador = usr.usr_codigo ");
            if (this.getSelecionadosFiltro(FILTRO_FILIAL, 0) == null || this.getSelecionadosFiltro(FILTRO_FILIAL, 0).length <= 1) {
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            }
            StringBuilder bufWhere = new StringBuilder();
            String[] filiais = this.getSelecionadosFiltro(FILTRO_FILIAL, 0);
            if (filiais == null) {
                filiais = new String[]{Variaveis.filialPadrao};
            }
            bufWhere.append(" where a.fil_codigo in (");
            for (int i = 0; i < filiais.length; ++i) {
                bufWhere.append(filiais[i]);
                if (i >= filiais.length - 1) continue;
                bufWhere.append(", ");
            }
            bufWhere.append(") ");
            String[] convenio = this.getSelecionadosFiltro(FILTRO_CONVENIO, 0);
            if (convenio != null) {
                bufWhere.append(" and b.con_codigo in (");
                for (int i = 0; i < convenio.length; ++i) {
                    bufWhere.append(convenio[i]);
                    if (i >= convenio.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((digitador = this.getSelecionadosFiltro(FILTRO_DIGITADOR, 0)) != null) {
                bufWhere.append(" and a.usr_coddigitador in (");
                for (int i = 0; i < digitador.length; ++i) {
                    bufWhere.append("'").append(digitador[i]).append("'");
                    if (i >= digitador.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((coletas = this.getSelecionadosFiltro(FILTRO_COLETA, 0)) != null) {
                bufWhere.append(" and b.col_codigo in (");
                for (int i = 0; i < coletas.length; ++i) {
                    bufWhere.append("'");
                    bufWhere.append(coletas[i]);
                    bufWhere.append("'");
                    if (i >= coletas.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((situacao = this.getSelecionadosFiltro(FILTRO_SITUACAO, 0)) != null) {
                bufWhere.append(" and sit.sit_codigo in (");
                for (int i = 0; i < situacao.length; ++i) {
                    bufWhere.append(situacao[i]);
                    if (i >= situacao.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if (this.getFiltroCheck(FILTRO_INTERVALO_HORA)) {
                if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_INICIAL)) && Funcoes.verificaHora(this.getFiltroHora(FILTRO_HORA_INICIAL))) {
                    bufWhere.append(" and date_trunc('minute', a.exr_datadigita) >= '");
                    bufWhere.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_INICIAL))).append(" ").append(this.getFiltroHora(FILTRO_HORA_INICIAL));
                    bufWhere.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_FINAL)) && Funcoes.verificaHora(this.getFiltroHora(FILTRO_HORA_FINAL))) {
                    bufWhere.append(" and date_trunc('minute', a.exr_datadigita) <= '");
                    bufWhere.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_FINAL))).append(" ").append(this.getFiltroHora(FILTRO_HORA_FINAL));
                    bufWhere.append("'");
                }
            } else {
                if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_INICIAL))) {
                    bufWhere.append(" and cast(a.exr_datadigita as date) >= '");
                    bufWhere.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData(FILTRO_DATA_INICIAL)));
                    bufWhere.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_FINAL))) {
                    bufWhere.append(" and cast(a.exr_datadigita as date) <= '");
                    bufWhere.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData(FILTRO_DATA_FINAL)));
                    bufWhere.append("'");
                }
                if (Funcoes.verificaHora(this.getFiltroHora(FILTRO_HORA_INICIAL))) {
                    bufWhere.append(" and cast(a.exr_datadigita as time) >= '");
                    bufWhere.append(this.getFiltroHora(FILTRO_HORA_INICIAL));
                    bufWhere.append("'");
                }
                if (Funcoes.verificaHora(this.getFiltroHora(FILTRO_HORA_FINAL))) {
                    bufWhere.append(" and cast(a.exr_datadigita as time) <= '");
                    bufWhere.append(this.getFiltroHora(FILTRO_HORA_FINAL));
                    bufWhere.append("'");
                }
            }
            bufWhere.append(" and b.req_excluida = false and a.exr_excluido = false ");
            bufWhere.append(" and a.usr_coddigitador IS NOT NULL ");
            buf.append(bufWhere.toString());
            buf.append(" group by ");
            if (this.getSelecionadosFiltro(FILTRO_FILIAL, 0) == null || this.getSelecionadosFiltro(FILTRO_FILIAL, 0).length <= 1) {
                buf.append(" filial.fil_codigo, ");
                buf.append(" filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, ");
                buf.append(" filial.fil_complemento, filial.fil_cep, filial.fil_fone, ");
                buf.append(" filial.fil_fax, filial.fil_razaosocial, cidadefilial.cid_codigo, ");
                buf.append(" cidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo, ");
                buf.append(" bairrofilial.bai_descricao, filial.fil_cnes, ");
            }
            buf.append("a.usr_coddigitador, usr.usr_nome ");
            if (this.getFiltroCheck(FILTRO_DETALHAR_DATA)) {
                buf.append(" , date_trunc('day', a.exr_datadigita), extract(DOW from a.exr_datadigita) ");
            }
            buf.append(" order by ");
            if (this.getFiltroCombo(FILTRO_ORDEM).equals(ordem[0])) {
                buf.append(" a.usr_coddigitador ");
            } else {
                buf.append(" usr.usr_nome ");
            }
            if (this.getFiltroCheck(FILTRO_DETALHAR_DATA)) {
                buf.append(" , date_trunc('day', a.exr_datadigita) ");
            }
            if ((rs = Conexao.executeQuery(st, buf.toString())).next()) {
                ModeloGridTable modelo = new ModeloGridTable(campos);
                String codigoDigitador = "";
                int qtdeAux = 0;
                do {
                    Object[] o = new Object[campos.length];
                    for (int i = 0; i < campos.length; ++i) {
                        if (RelatorioUtil.possuiColuna(rs, campos[i]) <= -1) continue;
                        if (campos[i].equals("quantidadeRequisicoes") && this.getFiltroCheck(FILTRO_DETALHAR_DATA)) {
                            if (codigoDigitador.equalsIgnoreCase(rs.getString("codigoDigitador"))) {
                                o[i] = qtdeAux;
                                continue;
                            }
                            try {
                                qtdeAux = this.quantidadeRequisicoes(st2, filiais, rs.getString("codigoDigitador"), convenio, coletas, situacao, this.getFiltroData(FILTRO_DATA_INICIAL), this.getFiltroData(FILTRO_DATA_FINAL), this.getFiltroHora(FILTRO_HORA_INICIAL), this.getFiltroHora(FILTRO_HORA_FINAL));
                            }
                            catch (Exception e) {
                                qtdeAux = 0;
                            }
                            o[i] = qtdeAux;
                            codigoDigitador = rs.getString("codigoDigitador");
                            continue;
                        }
                        if (campos[i].equalsIgnoreCase("diaSemana")) {
                            try {
                                int dia = rs.getInt("diaSemana");
                                switch (dia) {
                                    case 0: {
                                        o[i] = "Domingo";
                                        break;
                                    }
                                    case 1: {
                                        o[i] = "Segunda-feira";
                                        break;
                                    }
                                    case 2: {
                                        o[i] = "Ter\u00e7a-feira";
                                        break;
                                    }
                                    case 3: {
                                        o[i] = "Quarta-feira";
                                        break;
                                    }
                                    case 4: {
                                        o[i] = "Quinta-feira";
                                        break;
                                    }
                                    case 5: {
                                        o[i] = "Sexta-feira";
                                        break;
                                    }
                                    case 6: {
                                        o[i] = "S\u00e1bado";
                                        break;
                                    }
                                    default: {
                                        o[i] = "Dia incorreto";
                                        break;
                                    }
                                }
                            }
                            catch (Exception e) {
                                o[i] = "Dia incorreto";
                            }
                            continue;
                        }
                        o[i] = rs.getObject(campos[i]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                String codigoFilial = Variaveis.filialPadrao;
                if (this.getSelecionadosFiltro(FILTRO_FILIAL, 0) != null && this.getSelecionadosFiltro(FILTRO_FILIAL, 0).length == 1) {
                    codigoFilial = this.getSelecionadosFiltro(FILTRO_FILIAL, 0)[0];
                }
                Registro regFilial = RelatorioUtil.pegaDadosFilial(st, codigoFilial);
                RelatorioUtil.preencheDadosFilial(regFilial, modelo);
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                if (this.getFiltroCheck(FILTRO_DETALHAR_DATA)) {
                    buf.append(RelatorioAcumuladoDigitador.getModuloAcesso(1));
                } else {
                    buf.append(RelatorioAcumuladoDigitador.getModuloAcesso(0));
                }
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    int i;
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioAcumuladoDigitador.this.panelCentro.removeAll();
                            RelatorioAcumuladoDigitador.this.panelCentro.repaint();
                            RelatorioAcumuladoDigitador.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put(FILTRO_ORDEM, this.getFiltroCombo(FILTRO_ORDEM));
                    var.put(FILTRO_DATA_INICIAL, this.getFiltroData(FILTRO_DATA_INICIAL));
                    var.put(FILTRO_DATA_FINAL, this.getFiltroData(FILTRO_DATA_FINAL));
                    var.put(FILTRO_HORA_INICIAL, this.getFiltroHora(FILTRO_HORA_INICIAL));
                    var.put(FILTRO_HORA_FINAL, this.getFiltroHora(FILTRO_HORA_FINAL));
                    var.put(FILTRO_INTERVALO_HORA, this.getFiltroCheck(FILTRO_INTERVALO_HORA) ? "Sim" : "N\u00e3o");
                    buf.delete(0, buf.length());
                    if (filiais != null) {
                        for (i = 0; i < filiais.length; ++i) {
                            buf.append(filiais[i]);
                            if (i >= filiais.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_FILIAL, buf.toString());
                    buf.delete(0, buf.length());
                    if (situacao != null) {
                        for (i = 0; i < situacao.length; ++i) {
                            buf.append(situacao[i]);
                            if (i >= situacao.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_SITUACAO, buf.toString());
                    buf.delete(0, buf.length());
                    if (digitador != null) {
                        for (i = 0; i < digitador.length; ++i) {
                            buf.append(digitador[i]);
                            if (i >= digitador.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_DIGITADOR, buf.toString());
                    buf.delete(0, buf.length());
                    if (convenio != null) {
                        for (i = 0; i < convenio.length; ++i) {
                            buf.append(convenio[i]);
                            if (i >= convenio.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_CONVENIO, buf.toString());
                    buf.delete(0, buf.length());
                    if (coletas != null) {
                        for (i = 0; i < coletas.length; ++i) {
                            buf.append(coletas[i]);
                            if (i >= coletas.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put(FILTRO_COLETA, buf.toString());
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RelatorioAcumuladoDigitador");
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private int quantidadeRequisicoes(Statement st, String[] filial, String digitador, String[] convenios, String[] coletas, String[] situacao, String dataInicial, String dataFinal, String horaInicial, String horaFinal) throws Exception {
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append("select count(distinct b.req_codigo) as quantidadeRequisicoes ");
        buf.append("  from requisicao b ");
        buf.append("  join examerequisicao exr on b.fil_codigo = exr.fil_codigo and b.req_codigo = exr.req_codigo ");
        buf.append("  left join situacao sit on b.fil_codigo = sit.fil_codigo and b.sit_codigo = sit.sit_codigo ");
        buf.append("  join exames c on exr.fil_codigo = c.fil_codigo and exr.exa_codigo = c.exa_codigo ");
        buf.append("  join convenios d on exr.fil_codigo = d.fil_codigo and b.con_codigo = d.con_codigo ");
        buf.append("  join usuario usr on exr.usr_coddigitador = usr.usr_codigo ");
        if (filial == null) {
            filial = new String[]{Variaveis.filialPadrao};
        }
        buf.append(" where b.fil_codigo in (");
        for (i = 0; i < filial.length; ++i) {
            buf.append(filial[i]);
            if (i >= filial.length - 1) continue;
            buf.append(", ");
        }
        buf.append(") ");
        if (convenios != null) {
            buf.append(" and b.con_codigo in (");
            for (i = 0; i < convenios.length; ++i) {
                buf.append(convenios[i]);
                if (i >= convenios.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (situacao != null) {
            buf.append(" and sit.sit_codigo in (");
            for (i = 0; i < situacao.length; ++i) {
                buf.append(situacao[i]);
                if (i >= situacao.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (this.getFiltroCheck(FILTRO_INTERVALO_HORA)) {
            if (dataInicial != null && !dataInicial.isEmpty() && !horaInicial.isEmpty()) {
                buf.append(" and date_trunc('minute', exr.exr_datadigita) >= '");
                buf.append(Funcoes.formataData("yyyy-MM-dd", dataInicial)).append(" ").append(horaInicial);
                buf.append("'");
            }
            if (dataFinal != null && !dataFinal.isEmpty() && !horaFinal.isEmpty()) {
                buf.append(" and date_trunc('minute', exr.exr_datadigita) <= '");
                buf.append(Funcoes.formataData("yyyy-MM-dd", dataFinal)).append(" ").append(horaFinal);
                buf.append("'");
            }
        } else {
            if (dataInicial != null && !dataInicial.isEmpty()) {
                buf.append(" and cast(exr.exr_datadigita as date) >= '");
                buf.append(Funcoes.formataData("yyyy-MM-dd", dataInicial));
                buf.append("'");
            }
            if (dataFinal != null && !dataFinal.isEmpty()) {
                buf.append(" and cast(exr.exr_datadigita as date) <= '");
                buf.append(Funcoes.formataData("yyyy-MM-dd", dataFinal));
                buf.append("'");
            }
            if (!horaInicial.isEmpty()) {
                buf.append(" and cast(exr.exr_datadigita as time) >= '");
                buf.append(horaInicial);
                buf.append("'");
            }
            if (!horaFinal.isEmpty()) {
                buf.append(" and cast(exr.exr_datadigita as time) <= '");
                buf.append(horaFinal);
                buf.append("'");
            }
        }
        if (!Funcoes.textoVazio(digitador)) {
            buf.append(" and exr.usr_coddigitador = '");
            buf.append(digitador);
            buf.append("' ");
        }
        if (coletas != null) {
            buf.append(" and b.col_codigo in (");
            for (i = 0; i < coletas.length; ++i) {
                buf.append("'");
                buf.append(coletas[i]);
                buf.append("'");
                if (i >= coletas.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        buf.append(" and b.req_excluida = false and exr.exr_excluido = false ");
        buf.append(" and exr.usr_coddigitador IS NOT NULL ");
        ResultSet rs = Conexao.executeQuery(st, buf.toString());
        int retorno = 0;
        if (rs.next()) {
            retorno = rs.getInt("quantidadeRequisicoes");
        }
        return retorno;
    }

    public static long getModuloAcesso(int tipoRelatorio) {
        if (tipoRelatorio == 0) {
            return Long.parseLong("0880300900");
        }
        return Long.parseLong("0880300902");
    }

    public static long getModuloConfigurar(int tipoRelatorio) {
        if (tipoRelatorio == 0) {
            return Long.parseLong("0880300901");
        }
        return Long.parseLong("0880300902");
    }
}

