/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.gerencial;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.laboratorio.relatorios.util.RelatorioUtil;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioAcumuladoDestino
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_DESTINO = "filtroDestino";
    private final String FILTRO_MEDICO = "filtroMedico";
    private final String FILTRO_EXAME = "filtroExame";
    private final String FILTRO_SETOR = "filtroSetor";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_HORA_INICIAL = "filtroHoraInicial";
    private final String FILTRO_HORA_FINAL = "filtroHoraFinal";
    private final String FILTRO_INTERVALO_HORA = "intervaloHora";
    public static final String PARAMETROS_RELATORIOACUMULADODESTINO = "RelatorioAcumuladoDestino.ultimoFiltro";
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"qtdeRequisicoes", "qtdeExames", "codigoDestino", "descricaoDestino", "ano", "mes", "mesano"});

    public RelatorioAcumuladoDestino() {
        this.montaBarraDescricao("Relat\u00f3rio acumulado por destino", "Listagem dos exames acumulados por destino", "relatorios/rel_ger_acumulado_destino_exame.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroDestino", "Destino", "destino", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltroAvancado("filtroMedico", "M\u00e9dico", "medico", "fil_codigo = " + Variaveis.filialPadrao, 4, new String[]{"med_conselho", "med_crm", "med_uf", "med_nome"}, new String[]{"Conselho", "N\u00famero", "UF", "Nome"}, new int[]{70, 70, 40, 0}, false, new int[]{0, 1, 2});
        this.adicionaItemFiltro("filtroExame", "Exame", "exames", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroSetor", "Setor", "setores", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroHora("filtroHoraInicial", "Hora inicial:");
        this.adicionaFiltroHora("filtroHoraFinal", "Hora final:");
        this.adicionaFiltroCheck("intervaloHora", "Intervalo de hora", false);
        this.setModuloAcesso(RelatorioAcumuladoDestino.getModuloAcesso());
        this.setCamposConfigurador(campos);
        String parametros = ParametrosUsuarios.getValor(PARAMETROS_RELATORIOACUMULADODESTINO);
        if (!Funcoes.textoVazio(parametros)) {
            String tmp = StringUtil.getValor(parametros, "filial");
            if (!Funcoes.textoVazio(tmp)) {
                this.setSelecionadosFiltro("filtroFilial", 0, tmp.split(","));
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "destino"))) {
                this.setSelecionadosFiltro("filtroDestino", 0, tmp.split(","));
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "setor"))) {
                this.setSelecionadosFiltro("filtroSetor", 0, tmp.split(","));
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "medicos"))) {
                String[] medicos = StringUtil.getValores(tmp, "medico");
                Object[] filtro = new Object[medicos.length];
                for (int i = 0; i < medicos.length; ++i) {
                    String valor;
                    String valores = medicos[i];
                    Object[] aux = new Object[4];
                    int j = 0;
                    while (!Funcoes.textoVazio(valor = StringUtil.getValor(valores, String.valueOf(j)))) {
                        aux[j++] = valor;
                    }
                    filtro[i] = aux;
                }
                this.setSelecionadosFiltroAvancado("filtroMedico", filtro);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "exame"))) {
                this.setSelecionadosFiltro("filtroExame", 0, tmp.split(","));
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "datainicial"))) {
                this.setFiltroData("filtroDataInicial", tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "datafinal"))) {
                this.setFiltroData("filtroDataFinal", tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "horainicial"))) {
                this.setFiltroTexto("filtroHoraInicial", tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "horafinal"))) {
                this.setFiltroData("filtroHoraFinal", tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "intervalohora"))) {
                this.setFiltroCheck("intervaloHora", tmp.equalsIgnoreCase("true"));
            }
        }
    }

    @Override
    public void imprimirPressionado() {
        boolean horaInicial = Funcoes.textoVazio(this.getFiltroHora("filtroHoraInicial"));
        boolean intervaloHora = this.getFiltroCheck("intervaloHora");
        if (intervaloHora && horaInicial) {
            Funcoes.mensagem(this, "O campo Hora deve ser preenchido.", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        Statement st = Conexao.getStatement();
        Statement stTemp = Conexao.getStatement();
        try {
            String[] setor;
            String[] exame;
            String[] filiais;
            StringBuilder buf = new StringBuilder();
            buf.append("select ");
            buf.append("\tcount(distinct a.req_codigo)   as qtdeRequisicoes, ");
            buf.append("\tcount(b.exa_codigo) \t\t\t\t   as qtdeExames, ");
            buf.append("\ta.fil_codigo, a.des_codigo     as codigoDestino, ");
            buf.append("\tc.des_descricao \t\t\t\t\t\t   as descricaoDestino, ");
            buf.append("\textract(year from a.req_data)  as ano, ");
            buf.append("\textract(month from a.req_data) as mes, ");
            buf.append("  '' as mesano ");
            if (this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
                buf.append(", ").append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            }
            buf.append(" from ");
            buf.append(" requisicao a ");
            buf.append(" left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            buf.append(" left join examesetor d on b.fil_codigo = d.fil_codigo and b.exa_codigo = d.exa_codigo and d.ese_default = true ");
            buf.append(" left join destino c on a.fil_codigo = c.fil_codigo and a.des_codigo = c.des_codigo ");
            if (this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            }
            if ((filiais = this.getSelecionadosFiltro("filtroFilial", 0)) == null) {
                filiais = new String[]{Variaveis.filialPadrao};
            }
            buf.append("where a.fil_codigo in (");
            for (int i = 0; i < filiais.length; ++i) {
                buf.append(filiais[i]);
                if (i >= filiais.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
            String[] destino = this.getSelecionadosFiltro("filtroDestino", 0);
            if (destino != null) {
                buf.append(" and a.des_codigo in (");
                for (int i = 0; i < destino.length; ++i) {
                    buf.append("'");
                    buf.append(destino[i]);
                    buf.append("'");
                    if (i >= destino.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            String[] conselho = this.getSelecionadosFiltroAvancado("filtroMedico", 0);
            String[] crm = this.getSelecionadosFiltroAvancado("filtroMedico", 1);
            String[] uf = this.getSelecionadosFiltroAvancado("filtroMedico", 2);
            if (conselho != null && crm != null && uf != null && crm.length <= ParametrosGerais.getQuantidadeMaximoFiltroAvancado()) {
                buf.append(" and (");
                for (int i = 0; i < crm.length; ++i) {
                    buf.append("(a.med_conselho = '");
                    buf.append(conselho[i]);
                    buf.append("' and a.med_crm = '");
                    buf.append(crm[i]);
                    buf.append("' and a.med_uf = '");
                    buf.append(uf[i]);
                    buf.append("')");
                    if (i >= crm.length - 1) continue;
                    buf.append(" or ");
                }
                buf.append(")");
            }
            if ((exame = this.getSelecionadosFiltro("filtroExame", 0)) != null) {
                buf.append(" and b.exa_codigo in (");
                for (int i = 0; i < exame.length; ++i) {
                    buf.append("'");
                    buf.append(exame[i]);
                    buf.append("'");
                    if (i >= exame.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((setor = this.getSelecionadosFiltro("filtroSetor", 0)) != null) {
                buf.append(" and d.set_codigo in (");
                for (int i = 0; i < setor.length; ++i) {
                    buf.append(setor[i]);
                    if (i >= setor.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if (this.getFiltroCheck("intervaloHora")) {
                if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial")) && Funcoes.verificaHora(this.getFiltroHora("filtroHoraInicial"))) {
                    buf.append(" and date_trunc('minute', a.req_data + a.req_hora) >= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial"))).append(" ").append(this.getFiltroHora("filtroHoraInicial"));
                    buf.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal")) && Funcoes.verificaHora(this.getFiltroHora("filtroHoraFinal"))) {
                    buf.append(" and date_trunc('minute', a.req_data + a.req_hora) <= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataFinal"))).append(" ").append(this.getFiltroHora("filtroHoraFinal"));
                    buf.append("'");
                }
            } else {
                if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                    buf.append(" and a.req_data >= '");
                    buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial")));
                    buf.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                    buf.append(" and a.req_data <= '");
                    buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal")));
                    buf.append("'");
                }
                if (Funcoes.verificaHora(this.getFiltroHora("filtroHoraInicial"))) {
                    buf.append(" and a.req_hora >= '");
                    buf.append(this.getFiltroHora("filtroHoraInicial"));
                    buf.append("'");
                }
                if (Funcoes.verificaHora(this.getFiltroHora("filtroHoraFinal"))) {
                    buf.append(" and a.req_hora <= '");
                    buf.append(this.getFiltroHora("filtroHoraFinal"));
                    buf.append("'");
                }
            }
            buf.append(" and a.req_excluida = false and b.exr_excluido = false ");
            buf.append(" group by ");
            buf.append(" a.des_codigo, c.des_descricao, ano, mes ");
            buf.append(", a.fil_codigo ");
            if (this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
                for (String s : Constantes.CAMPOS_FILIAL) {
                    buf.append(", ").append(s);
                }
            }
            buf.append(" order by a.fil_codigo, a.des_codigo, ano, mes ");
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(campos);
                rs.first();
                do {
                    Object[] o = new Object[campos.length];
                    for (int i = 0; i < campos.length; ++i) {
                        if (RelatorioUtil.possuiColuna(rs, campos[i]) <= -1) continue;
                        int pos = modelo.findColumn(campos[i]);
                        o[pos] = campos[i].equalsIgnoreCase("mesano") ? Funcoes.preencheZero(rs.getInt("mes"), 2) + "/" + rs.getString("ano") : rs.getObject(campos[i]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                String codigoFilial = Variaveis.filialPadrao;
                if (this.getSelecionadosFiltro("filtroFilial", 0) != null && this.getSelecionadosFiltro("filtroFilial", 0).length == 1) {
                    codigoFilial = this.getSelecionadosFiltro("filtroFilial", 0)[0];
                }
                Registro regFilial = RelatorioUtil.pegaDadosFilial(st, codigoFilial);
                RelatorioUtil.preencheDadosFilial(regFilial, modelo);
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioAcumuladoDestino.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next() && modelo.getRowCount() > 0) {
                    int i;
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioAcumuladoDestino.this.panelCentro.removeAll();
                            RelatorioAcumuladoDestino.this.panelCentro.repaint();
                            RelatorioAcumuladoDestino.this.habilitaBotaoImprimir(true);
                        }
                    });
                    StringBuilder p = new StringBuilder();
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                    var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                    var.put("filtroHoraInicial", this.getFiltroHora("filtroHoraInicial"));
                    var.put("filtroHoraFinal", this.getFiltroHora("filtroHoraFinal"));
                    p.append("<datainicial>").append(this.getFiltroData("filtroDataInicial")).append("</datainicial>");
                    p.append("<datafinal>").append(this.getFiltroData("filtroDataFinal")).append("</datafinal>");
                    p.append("<horainicial>").append(this.getFiltroHora("filtroHoraInicial")).append("</horainicial>");
                    p.append("<horafinal>").append(this.getFiltroHora("filtroHoraFinal")).append("</horafinal>");
                    p.append("<intervalohora>").append(this.getFiltroCheck("intervaloHora")).append("</intervalohora>");
                    buf.delete(0, buf.length());
                    if (filiais != null) {
                        p.append("<filial>");
                        for (i = 0; i < filiais.length; ++i) {
                            buf.append(filiais[i]);
                            if (i >= filiais.length - 1) continue;
                            buf.append(",");
                        }
                        p.append(buf.toString());
                        p.append("</filial>");
                    }
                    var.put("filtroFilial", buf.toString());
                    buf.delete(0, buf.length());
                    if (destino != null) {
                        p.append("<destino>");
                        for (i = 0; i < destino.length; ++i) {
                            buf.append(destino[i]);
                            if (i >= destino.length - 1) continue;
                            buf.append(",");
                        }
                        p.append(buf.toString());
                        p.append("</destino>");
                    }
                    var.put("filtroDestino", buf.toString());
                    buf.delete(0, buf.length());
                    if (crm != null) {
                        p.append("<medicos>");
                        Object[] valores = this.getSelecionadosFiltroAvancado("filtroMedico");
                        for (int i2 = 0; i2 < valores.length; ++i2) {
                            p.append("<medico>");
                            Object[] valor = (Object[])valores[i2];
                            for (int j = 0; j < valor.length; ++j) {
                                p.append("<").append(j).append(">");
                                p.append(valor[j]);
                                p.append("</").append(j).append(">");
                            }
                            p.append("</medico>");
                            buf.append(valor[1]);
                        }
                        p.append("</medicos>");
                    }
                    var.put("filtroMedico", buf.toString());
                    buf.delete(0, buf.length());
                    if (exame != null) {
                        p.append("<exame>");
                        for (int i3 = 0; i3 < exame.length; ++i3) {
                            buf.append(exame[i3]);
                            if (i3 >= exame.length - 1) continue;
                            buf.append(",");
                        }
                        p.append(buf.toString());
                        p.append("</exame>");
                    }
                    var.put("filtroExame", buf.toString());
                    buf.delete(0, buf.length());
                    if (setor != null) {
                        p.append("<setor>");
                        for (int i4 = 0; i4 < setor.length; ++i4) {
                            buf.append(setor[i4]);
                            if (i4 >= setor.length - 1) continue;
                            buf.append(",");
                        }
                        p.append(buf.toString());
                        p.append("</setor>");
                    }
                    var.put("filtroSetor", buf.toString());
                    ParametrosUsuarios.setValor(PARAMETROS_RELATORIOACUMULADODESTINO, p.toString());
                    ParametrosUsuarios.salvarParametros(true);
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                } else if (modelo.getRowCount() == 0) {
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
            Conexao.fecharStatement(st);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0880301200");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0880301201");
    }
}

