/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.gerencial;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.integracaohospitais.sistemas.sigh.IntegracaoHospitalSigh;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.laboratorio.relatorios.util.RelatorioUtil;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioAcumuladoConveniosSigh
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private static final int ANO_MES_CONCATENADO = 6;
    private final String[] ordem = new String[]{"C\u00f3digo", "Raz\u00e3o Social", "Fantasia", "Quantidade", "Qtde. decr.", "Valor exame", "Vlr. exame decr."};
    private final String[] tipo = new String[]{"Sigh -> Jalis", "Jalis -> Sigh"};
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_COLETA = "filtroColeta";
    private final String FILTRO_DESTINO = "filtroDestino";
    private final String FILTRO_SETOR = "filtroSetor";
    private final String FILTRO_GRUPO = "filtroGrupo";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_SISTEMA_GERACAO = "filtroTipo";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String FILTRO_SOMENTE_RESULTADO = "filtroSomenteResultado";
    private final String FILTRO_SOMENTE_INTERNACAO = "filtroSomenteInternacao";
    private final String FILTRO_INTERVALO_HORA = "filtroIntervaloHora";
    private final String FILTRO_HORA_INICIAL = "filtroHoraInicial";
    private final String FILTRO_HORA_FINAL = "filtroHoraFinal";
    protected static String[] campos;

    public RelatorioAcumuladoConveniosSigh() {
        campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio", "valorExame", "valorMaterial", "valorCH", "valorTotalExame", "quantidadeExames", "quantidadeRequisicoes", "valorCHOriginal", "valorCustoSimplesExameHistorico", "valorCustoSimplesExameAtual"});
        this.montaBarraDescricao("Relat\u00f3rio acumulado integra\u00e7\u00e3o SIGH por conv\u00eanio", "Acumulado da quantidade de exames e requisi\u00e7\u00f5es por conv\u00eanio - SIGH", "relatorios/rel_ger_acumulado_sigh.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroColeta", "Coleta", "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroDestino", "Destino", "destino", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroGrupo", "Grupo", "grupo", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"grp_codigo", "grp_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroSetor", "Setor", "setores", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroHora("filtroHoraInicial", "Hora inicial:");
        this.adicionaFiltroHora("filtroHoraFinal", "Hora final:");
        this.adicionaFiltroCombo("filtroTipo", "Sist. gera\u00e7\u00e3o:", this.tipo, 0);
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.adicionaFiltroCheck("filtroSomenteResultado", "Somente com resultado", false);
        this.adicionaFiltroCheck("filtroSomenteInternacao", "Somente interna\u00e7\u00e3o", false);
        this.adicionaFiltroCheck("filtroIntervaloHora", "Intervalo de Hora", false);
        this.setModuloConfigurar(RelatorioAcumuladoConveniosSigh.getModuloConfigurar());
        this.setModuloAcesso(RelatorioAcumuladoConveniosSigh.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        boolean intervaloHora = this.getFiltroCheck("filtroIntervaloHora");
        if (intervaloHora) {
            if (!this.getFiltroData("filtroDataInicial").isEmpty() && this.getFiltroHora("filtroHoraInicial").isEmpty()) {
                Funcoes.mensagem(this, "O filtro de hora inicial deve ser preenchido.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            if (this.getFiltroData("filtroDataInicial").isEmpty() && !this.getFiltroHora("filtroHoraInicial").isEmpty()) {
                Funcoes.mensagem(this, "O filtro de data inicial deve ser preenchido.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            if (!this.getFiltroData("filtroDataFinal").isEmpty() && this.getFiltroHora("filtroHoraFinal").isEmpty()) {
                Funcoes.mensagem(this, "O filtro de hora final deve ser preenchido.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            if (this.getFiltroData("filtroDataFinal").isEmpty() && !this.getFiltroHora("filtroHoraFinal").isEmpty()) {
                Funcoes.mensagem(this, "O filtro de data final deve ser preenchido.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" select count(a.exa_codigo) as quantidadeExames ");
            buf.append("       ,count(distinct b.req_codigo) as quantidadeRequisicoes ");
            buf.append("       ,sum(calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo, true, false, false, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, d.con_precosdiferenciados, d.con_reajuste, d.con_cobrmaterial, d.con_percpgtomaterial, d.con_percpgto, d.con_tpcalcfatu, d.con_tpcalcch, d.con_perguntarpercbalcao, d.con_acrescimo, d.con_bonus, d.tpe_codigo, d.con_acrescimoporte, d.con_acrescimouco, d.con_descontoporte, d.con_descontouco, d.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", a.met_codigo").append(")) as valorExame ");
            buf.append("       ,sum(calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo, true, false, true, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, d.con_precosdiferenciados, d.con_reajuste, d.con_cobrmaterial, d.con_percpgtomaterial, d.con_percpgto, d.con_tpcalcfatu, d.con_tpcalcch, d.con_perguntarpercbalcao, d.con_acrescimo, d.con_bonus, d.tpe_codigo, d.con_acrescimoporte, d.con_acrescimouco, d.con_descontoporte, d.con_descontouco, d.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", a.met_codigo").append(")) as valorTotalExame ");
            buf.append("       ,sum(a.exr_vlrmaterial) as valorMaterial ");
            buf.append("       ,sum(calculachexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo)) as valorCH ");
            buf.append("       ,sum(a.exr_vlrchexame) as valorCHOriginal ");
            buf.append("\t\t\t ,sum(a.exr_custosimples) AS valorCustoSimplesExameHistorico ");
            buf.append("\t\t\t ,sum(examatcol.emc_custosimples) AS valorCustoSimplesExameAtual ");
            buf.append("       ,d.con_fantasia as fantasiaConvenio ");
            buf.append("       ,d.con_codigo as codigoConvenio ");
            buf.append("       ,d.con_razao as razaoSocialConvenio ");
            buf.append("       ,0 as quantidadeRequisicoes ");
            buf.append(" ,").append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append(" from examerequisicao a ");
            buf.append(" join requisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            buf.append(" left join exames c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo ");
            buf.append(" left join examematcoleta examatcol on a.fil_codigo = examatcol.fil_codigo and a.exa_codigo = examatcol.exa_codigo and a.mco_codigo = examatcol.mco_codigo ");
            buf.append(" left join convenios d on a.fil_codigo = d.fil_codigo and b.con_codigo = d.con_codigo ");
            buf.append(" left join examesetor e on a.fil_codigo = e.fil_codigo and a.exa_codigo = e.exa_codigo and e.ese_default = true ");
            buf.append(" left join examematgrupo g on a.fil_codigo = g.fil_codigo and a.exa_codigo = g.exa_codigo and a.mco_codigo = g.mco_codigo ");
            buf.append(" left join setores f on e.fil_codigo = f.fil_codigo and e.set_codigo = f.set_codigo ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            StringBuilder bufWhere = new StringBuilder();
            String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
            if (filiais == null) {
                filiais = new String[]{Variaveis.filialPadrao};
            }
            String aux = "";
            aux = " a.fil_codigo in (";
            for (int i = 0; i < filiais.length; ++i) {
                aux = aux + filiais[i];
                if (i >= filiais.length - 1) continue;
                aux = aux + ", ";
            }
            aux = aux + ") ";
            this.addClausula(aux, bufWhere);
            aux = "";
            String[] grupos = this.getSelecionadosFiltro("filtroGrupo", 0);
            if (grupos != null) {
                aux = aux + " g.grp_codigo in (";
                for (int i = 0; i < grupos.length; ++i) {
                    aux = aux + "'" + grupos[i] + "'";
                    if (i >= grupos.length - 1) continue;
                    aux = aux + ", ";
                }
                aux = aux + ")";
            }
            this.addClausula(aux, bufWhere);
            aux = "";
            String[] coletas = this.getSelecionadosFiltro("filtroColeta", 0);
            if (coletas != null) {
                aux = aux + " b.col_codigo in (";
                for (int i = 0; i < coletas.length; ++i) {
                    aux = aux + "'" + coletas[i] + "'";
                    if (i >= coletas.length - 1) continue;
                    aux = aux + ", ";
                }
                aux = aux + ")";
            }
            this.addClausula(aux, bufWhere);
            aux = "";
            String[] destinos = this.getSelecionadosFiltro("filtroDestino", 0);
            if (destinos != null) {
                aux = aux + " b.des_codigo in (";
                for (int i = 0; i < destinos.length; ++i) {
                    aux = aux + "'" + destinos[i] + "'";
                    if (i >= destinos.length - 1) continue;
                    aux = aux + ", ";
                }
                aux = aux + ")";
            }
            this.addClausula(aux, bufWhere);
            aux = "";
            String[] setor = this.getSelecionadosFiltro("filtroSetor", 0);
            if (setor != null) {
                aux = aux + " e.set_codigo in (";
                for (int i = 0; i < setor.length; ++i) {
                    aux = aux + setor[i];
                    if (i >= setor.length - 1) continue;
                    aux = aux + ", ";
                }
                aux = aux + ")";
            }
            this.addClausula(aux, bufWhere);
            if (intervaloHora) {
                if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial")) && Funcoes.verificaHora(this.getFiltroHora("filtroHoraInicial"))) {
                    this.addClausula(" cast(b.req_data + b.req_hora as timestamp) >= '" + Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial")) + " " + this.getFiltroHora("filtroHoraInicial") + "' ", bufWhere);
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal")) && Funcoes.verificaHora(this.getFiltroHora("filtroHoraFinal"))) {
                    this.addClausula(" cast(b.req_data + b.req_hora as timestamp) <= '" + Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataFinal")) + " " + this.getFiltroHora("filtroHoraFinal") + "' ", bufWhere);
                }
            } else if (this.getFiltroCombo("filtroTipo").equals(this.tipo[0])) {
                if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                    this.addClausula(" b.req_data >= '" + Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial")) + "' ", bufWhere);
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                    this.addClausula(" b.req_data <= '" + Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataFinal")) + "' ", bufWhere);
                }
                if (Funcoes.verificaHora(this.getFiltroHora("filtroHoraInicial"))) {
                    this.addClausula(" b.req_hora >= '" + this.getFiltroHora("filtroHoraInicial") + "' ", bufWhere);
                }
                if (Funcoes.verificaHora(this.getFiltroHora("filtroHoraFinal"))) {
                    this.addClausula(" b.req_hora <= '" + this.getFiltroHora("filtroHoraFinal") + "' ", bufWhere);
                }
            } else if (this.getFiltroCombo("filtroTipo").equals(this.tipo[1])) {
                String campoData = "";
                if (ParametrosGerais.getEventoGeradorIntegracaoHospital().equalsIgnoreCase("M")) {
                    campoData = "a.exr_datamaterial";
                } else if (ParametrosGerais.getEventoGeradorIntegracaoHospital().equalsIgnoreCase("R")) {
                    campoData = "a.exr_dataassina";
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial")) && Funcoes.verificaHora(this.getFiltroHora("filtroHoraInicial"))) {
                    this.addClausula(campoData + " <= '" + Funcoes.formataData("yyyy-MM-dd HH:mm", this.getFiltroData("filtroDataInicial") + " " + this.getFiltroHora("filtroHoraInicial")) + "' ", bufWhere);
                } else if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                    this.addClausula(" date_trunc('day', " + campoData + ") >= '" + Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial")) + "' ", bufWhere);
                } else if (Funcoes.verificaHora(this.getFiltroHora("filtroHoraInicial"))) {
                    this.addClausula(" extract('hour' from " + campoData + ") >= " + this.getFiltroHora("filtroHoraInicial").substring(0, 2), bufWhere);
                    this.addClausula(" extract('minute' from " + campoData + ") >= " + this.getFiltroHora("filtroHoraInicial").substring(3, 5), bufWhere);
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal")) && Funcoes.verificaHora(this.getFiltroHora("filtroHoraFinal"))) {
                    this.addClausula(campoData + " <= '" + Funcoes.formataData("yyyy-MM-dd HH:mm", this.getFiltroData("filtroDataFinal") + " " + this.getFiltroHora("filtroHoraFinal")) + "' ", bufWhere);
                } else if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                    this.addClausula(" date_trunc('day', " + campoData + ") <= '" + Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataFinal")) + "' ", bufWhere);
                } else if (Funcoes.verificaHora(this.getFiltroHora("filtroHoraFinal"))) {
                    this.addClausula(" extract('hour' from " + campoData + ") <= " + this.getFiltroHora("filtroHoraFinal").substring(0, 2), bufWhere);
                    this.addClausula(" extract('minute' from " + campoData + ") <= " + this.getFiltroHora("filtroHoraFinal").substring(3, 5), bufWhere);
                }
            }
            this.addClausula(" b.req_excluida = false and a.exr_excluido = false ", bufWhere);
            if (this.getFiltroCombo("filtroTipo").equals(this.tipo[0])) {
                this.addClausula(" b.req_integracaohospital ilike '%<protocolo>" + IntegracaoHospitalSigh.getNomeIntegracaoHospital() + "</" + "protocolo" + ">%' ", bufWhere);
                this.addClausula(" not a.exr_integracaohospital ilike '%<id>%' ", bufWhere);
                this.addClausula(" not a.exr_integracaohospital ilike '%<idX>%' ", bufWhere);
                this.addClausula("\ta.exr_integracaohospital ilike '%<xmlexareqhosp>%' ", bufWhere);
            } else if (this.getFiltroCombo("filtroTipo").equals(this.tipo[1])) {
                this.addClausula(" a.exr_integracaohospital ilike '%<id>%' ", bufWhere);
                this.addClausula(" not a.exr_integracaohospital ilike '%<idX>%' ", bufWhere);
            }
            if (this.getFiltroCheck("filtroSomenteInternacao")) {
                this.addClausula("  b.req_integracaohospital ilike '%<tipo>INT</tipo>%' ", bufWhere);
            }
            if (!Funcoes.textoVazio(bufWhere.toString())) {
                buf.append(" where ");
            }
            buf.append(bufWhere.toString());
            String[] convenio = this.getSelecionadosFiltro("filtroConvenio", 0);
            if (convenio != null) {
                if (!Funcoes.textoVazio(bufWhere.toString())) {
                    buf.append(" and ");
                } else {
                    buf.append(" where ");
                }
                buf.append(" b.con_codigo in (");
                for (int i = 0; i < convenio.length; ++i) {
                    buf.append(convenio[i]);
                    if (i >= convenio.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            buf.append(" group by ");
            buf.append("filial.fil_codigo, filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, filial.fil_complemento, filial.fil_cep, filial.fil_fone, filial.fil_fax, filial.fil_razaosocial, filial.fil_cnes, cidadefilial.cid_codigo, cidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo, bairrofilial.bai_descricao ").append(" , ");
            buf.append(" d.con_fantasia, d.con_codigo, d.con_razao ");
            buf.append(" order by filial.fil_codigo, ");
            if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[1])) {
                buf.append(" d.con_razao");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[2])) {
                buf.append(" d.con_fantasia ");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[3])) {
                buf.append(" 1 ");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[4])) {
                buf.append(" 1 desc ");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[5])) {
                buf.append(" 3 ");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[6])) {
                buf.append(" 3 desc ");
            } else {
                buf.append(" d.con_codigo ");
            }
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(campos);
                do {
                    Object[] o = new Object[campos.length];
                    for (int i = 0; i < campos.length; ++i) {
                        if (RelatorioUtil.possuiColuna(rs, campos[i]) <= -1) continue;
                        o[i] = rs.getObject(campos[i]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ").append(RelatorioAcumuladoConveniosSigh.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    int i;
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioAcumuladoConveniosSigh.this.panelCentro.removeAll();
                            RelatorioAcumuladoConveniosSigh.this.panelCentro.repaint();
                            RelatorioAcumuladoConveniosSigh.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                    var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                    var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                    var.put("filtroSomenteResultado", this.getFiltroCheck("filtroSomenteResultado") ? "Sim" : "N\u00e3o");
                    var.put("filtroSomenteInternacao", this.getFiltroCheck("filtroSomenteInternacao") ? "Sim" : "N\u00e3o");
                    var.put("filtroIntervaloHora", this.getFiltroCheck("filtroIntervaloHora") ? "Sim" : "N\u00e3o");
                    var.put("filtroTipo", this.getFiltroCombo("filtroTipo").toString());
                    buf.delete(0, buf.length());
                    if (filiais != null) {
                        for (i = 0; i < filiais.length; ++i) {
                            buf.append(filiais[i]);
                            if (i >= filiais.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroFilial", buf.toString());
                    buf.delete(0, buf.length());
                    if (convenio != null) {
                        for (i = 0; i < convenio.length; ++i) {
                            buf.append(convenio[i]);
                            if (i >= convenio.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroConvenio", buf.toString());
                    buf.delete(0, buf.length());
                    if (grupos != null) {
                        for (i = 0; i < grupos.length; ++i) {
                            buf.append(grupos[i]);
                            if (i >= grupos.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroGrupo", buf.toString());
                    buf.delete(0, buf.length());
                    if (setor != null) {
                        for (i = 0; i < setor.length; ++i) {
                            buf.append(setor[i]);
                            if (i >= setor.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroSetor", buf.toString());
                    buf.delete(0, buf.length());
                    if (coletas != null) {
                        for (i = 0; i < coletas.length; ++i) {
                            buf.append(coletas[i]);
                            if (i >= coletas.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroColeta", buf.toString());
                    buf.delete(0, buf.length());
                    if (destinos != null) {
                        for (i = 0; i < destinos.length; ++i) {
                            buf.append(destinos[i]);
                            if (i >= destinos.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroDestino", buf.toString());
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st, st2);
                throw throwable;
            }
            Conexao.fecharStatement(st, st2);
        }
        Conexao.fecharStatement(st, st2);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void addClausula(String clausula, StringBuilder where) {
        if (where != null && !Funcoes.textoVazio(clausula)) {
            if (!Funcoes.textoVazio(where.toString())) {
                where.append(" and ");
            }
            where.append(clausula);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int quantidadeRequisicoes(String where, String codigoConvenio) throws Exception {
        Statement st;
        block3: {
            int n;
            StringBuilder buf = new StringBuilder();
            buf.append(" select count(distinct b.req_codigo) as quantidadeRequisicoes ");
            buf.append("   from examerequisicao a ");
            buf.append("   join requisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            buf.append("   left join exames c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo ");
            buf.append("   left join convenios d on a.fil_codigo = d.fil_codigo and b.con_codigo = d.con_codigo ");
            buf.append("   left join examesetor e on a.fil_codigo = e.fil_codigo and a.exa_codigo = e.exa_codigo and e.ese_default = true ");
            buf.append("   left join examematgrupo g on a.fil_codigo = g.fil_codigo and a.exa_codigo = g.exa_codigo and a.mco_codigo = g.mco_codigo ");
            buf.append("   left join setores f on e.fil_codigo = f.fil_codigo and e.set_codigo = f.set_codigo ");
            buf.append("  where b.con_codigo = ").append(codigoConvenio);
            if (!Funcoes.textoVazio(where)) {
                buf.append(" and ").append(where);
            }
            st = Conexao.getStatement();
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (!rs.next()) break block3;
                n = rs.getInt("quantidadeRequisicoes");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return n;
        }
        Conexao.fecharStatement(st);
        return 0;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0880301300");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0880301301");
    }
}

