/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.gerencial;

import jalis.comum.Conexao;
import jalis.comum.ConstantesGerais;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.laboratorio.relatorios.util.RelatorioUtil;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioAcumuladoConvenios
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private static final int ANO_MES_CONCATENADO = 6;
    private final String[] ordem = new String[]{"C\u00f3digo", "Raz\u00e3o Social", "Fantasia", "Quantidade", "Qtde decrescente", "Valor exame", "Valor exame decrescente"};
    private static final String FILTRO_FILIAL = "filtroFilial";
    private static final String FILTRO_CONVENIO = "filtroConvenio";
    private static final String FILTRO_COLETA = "filtroColeta";
    private static final String FILTRO_DESTINO = "filtroDestino";
    private static final String FILTRO_SETOR = "filtroSetor";
    private static final String FILTRO_GRUPO = "filtroGrupo";
    private static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private static final String FILTRO_ORDEM = "ordemRelatorio";
    private static final String FILTRO_FORCAR_QUEBRA_MENSAL = "quebraMensal";
    private static final String FILTRO_EXAME = "filtroExame";
    protected static String[] campos;

    public RelatorioAcumuladoConvenios() {
        campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio", "valorExame", "valorMaterial", "valorCH", "valorTotalExame", "valorLiquidoTotalExame", "valorLiquidoExame", "quantidadeExames", "quantidadeRequisicoes", "valorCHOriginal", "anoMes", "mesExtenso", "valorCustoSimplesExameHistorico", "valorCustoSimplesExameAtual", "cobrarExameBalcaoConvenio", "percentualBalcaoConvenio", "valorDescontoRequisicao", "valorAcrescimoRequisicao"});
        this.montaBarraDescricao("Relat\u00f3rio acumulado por conv\u00eanio", "Listagem de quantidade de exames e requisi\u00e7\u00e3o no per\u00edodo por conv\u00eanio", "relatorios/acumulado_convenio.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro(FILTRO_FILIAL, "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_CONVENIO, "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_COLETA, "Coleta", "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_DESTINO, "Destino", "destino", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_GRUPO, "Grupo", "grupo", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"grp_codigo", "grp_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_SETOR, "Setor", "setores", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_EXAME, "Exame", "exames", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Data inicial:");
        this.adicionaFiltroData(FILTRO_DATA_FINAL, "Data final:");
        this.adicionaFiltroCombo(FILTRO_ORDEM, "Ordem:", this.ordem, 0);
        this.adicionaFiltroCheck(FILTRO_FORCAR_QUEBRA_MENSAL, "For\u00e7ar quebra mensal", false);
        this.setModuloConfigurar(this.getModuloConfigurar());
        this.setModuloAcesso(RelatorioAcumuladoConvenios.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        try {
            String[] setor;
            String[] destinos;
            String[] coletas;
            String[] grupos;
            StringBuilder buf = new StringBuilder();
            buf.append("select count(a.exa_codigo) as quantidadeExames, ");
            buf.append("sum(calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo, true, false, false, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, d.con_precosdiferenciados, d.con_reajuste, d.con_cobrmaterial, d.con_percpgtomaterial, d.con_percpgto, d.con_tpcalcfatu, d.con_tpcalcch, d.con_perguntarpercbalcao, d.con_acrescimo, d.con_bonus, d.tpe_codigo, d.con_acrescimoporte, d.con_acrescimouco, d.con_descontoporte, d.con_descontouco, d.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", a.met_codigo").append(")) as valorExame, ");
            buf.append("sum(round((calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo, true, false, false, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, d.con_precosdiferenciados, d.con_reajuste, d.con_cobrmaterial, d.con_percpgtomaterial, d.con_percpgto, d.con_tpcalcfatu, d.con_tpcalcch, d.con_perguntarpercbalcao, d.con_acrescimo, d.con_bonus, d.tpe_codigo, d.con_acrescimoporte, d.con_acrescimouco, d.con_descontoporte, d.con_descontouco, d.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", a.met_codigo) + a.exr_vlrmaterial) - a.exr_vlrmaterial, ").append(ParametrosGerais.getCasasPrecoExame()).append(")) as valorLiquidoExame, ");
            buf.append("sum(calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo, true, false, true, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, d.con_precosdiferenciados, d.con_reajuste, d.con_cobrmaterial, d.con_percpgtomaterial, d.con_percpgto, d.con_tpcalcfatu, d.con_tpcalcch, d.con_perguntarpercbalcao, d.con_acrescimo, d.con_bonus, d.tpe_codigo, d.con_acrescimoporte, d.con_acrescimouco, d.con_descontoporte, d.con_descontouco, d.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", a.met_codigo").append(")) as valorTotalExame, ");
            buf.append("sum(round(calculaprecototalexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo, true, false, true, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, d.con_precosdiferenciados, d.con_reajuste, d.con_cobrmaterial, d.con_percpgtomaterial, d.con_percpgto, d.con_tpcalcfatu, d.con_tpcalcch, d.con_perguntarpercbalcao, d.con_acrescimo, d.con_bonus, d.tpe_codigo, d.con_acrescimoporte, d.con_acrescimouco, d.con_descontoporte, d.con_descontouco, d.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", a.met_codigo").append(") * ((100 - (b.req_desconto - b.req_acrescimo))/100), 2)) as valorLiquidoTotalExame, ");
            buf.append("sum(a.exr_vlrmaterial) as valorMaterial, ");
            buf.append("sum(calculachexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo)) as valorCH, ");
            buf.append("sum(a.exr_vlrchexame) as valorCHOriginal, ");
            buf.append("sum(a.exr_custosimples) AS valorCustoSimplesExameHistorico, ");
            buf.append("sum(examatcol.emc_custosimples) AS valorCustoSimplesExameAtual, ");
            buf.append("d.con_fantasia as fantasiaConvenio, ");
            buf.append("d.con_codigo as codigoConvenio, ");
            buf.append("d.con_razao as razaoSocialConvenio, ");
            buf.append("0 as quantidadeRequisicoes ");
            buf.append(" , ' ' as mesExtenso");
            buf.append(" , ' ' as valorDescontoRequisicao");
            buf.append(" , ' ' as valorAcrescimoRequisicao");
            if ((Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_INICIAL)) || Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_FINAL)) && this.getFiltroCheck(FILTRO_FORCAR_QUEBRA_MENSAL)) && this.getFiltroCheck(FILTRO_FORCAR_QUEBRA_MENSAL)) {
                buf.append(", cast(extract(year from b.req_data ) as text) || case when extract(month from b.req_data) < 10 then 0 ||  cast(extract(month from b.req_data ) as text) else cast(extract(month from b.req_data ) as text) end as anoMes ");
            }
            if (this.getSelecionadosFiltro(FILTRO_FILIAL, 0) == null || this.getSelecionadosFiltro(FILTRO_FILIAL, 0).length <= 1) {
                buf.append(",").append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            }
            buf.append(", d.con_cobrexame as cobrarExameBalcaoConvenio, d.con_percpgto as percentualBalcaoConvenio");
            buf.append(" from examerequisicao a ");
            buf.append("join requisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            buf.append("left join exames c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo ");
            buf.append("left join examematcoleta examatcol on c.fil_codigo = examatcol.fil_codigo and c.exa_codigo = examatcol.exa_codigo and a.mco_codigo = examatcol.mco_codigo ");
            buf.append("left join convenios d on a.fil_codigo = d.fil_codigo and b.con_codigo = d.con_codigo ");
            buf.append("left join examesetor e on a.fil_codigo = e.fil_codigo and a.exa_codigo = e.exa_codigo and e.ese_default = true ");
            buf.append("left join examematgrupo g on a.fil_codigo = g.fil_codigo and a.exa_codigo = g.exa_codigo and a.mco_codigo = g.mco_codigo ");
            buf.append("left join setores f on e.fil_codigo = f.fil_codigo and e.set_codigo = f.set_codigo ");
            if (this.getSelecionadosFiltro(FILTRO_FILIAL, 0) == null || this.getSelecionadosFiltro(FILTRO_FILIAL, 0).length <= 1) {
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            }
            StringBuilder bufWhere = new StringBuilder();
            String[] filiais = this.getSelecionadosFiltro(FILTRO_FILIAL, 0);
            if (filiais == null) {
                filiais = new String[]{Variaveis.filialPadrao};
            }
            bufWhere.append(" where a.fil_codigo in (");
            for (int i = 0; i < filiais.length; ++i) {
                bufWhere.append(filiais[i]);
                if (i >= filiais.length - 1) continue;
                bufWhere.append(", ");
            }
            bufWhere.append(") ");
            String[] convenio = this.getSelecionadosFiltro(FILTRO_CONVENIO, 0);
            if (convenio != null) {
                bufWhere.append(" and b.con_codigo in (");
                for (int i = 0; i < convenio.length; ++i) {
                    bufWhere.append(convenio[i]);
                    if (i >= convenio.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((grupos = this.getSelecionadosFiltro(FILTRO_GRUPO, 0)) != null) {
                bufWhere.append(" and g.grp_codigo in (");
                for (int i = 0; i < grupos.length; ++i) {
                    bufWhere.append("");
                    bufWhere.append(StringUtil.textoDBEscape(grupos[i]));
                    bufWhere.append("");
                    if (i >= grupos.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((coletas = this.getSelecionadosFiltro(FILTRO_COLETA, 0)) != null) {
                bufWhere.append(" and b.col_codigo in (");
                for (int i = 0; i < coletas.length; ++i) {
                    bufWhere.append("");
                    bufWhere.append(StringUtil.textoDBEscape(coletas[i]));
                    bufWhere.append("");
                    if (i >= coletas.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((destinos = this.getSelecionadosFiltro(FILTRO_DESTINO, 0)) != null) {
                bufWhere.append(" and b.des_codigo in (");
                for (int i = 0; i < destinos.length; ++i) {
                    bufWhere.append("");
                    bufWhere.append(StringUtil.textoDBEscape(destinos[i]));
                    bufWhere.append("");
                    if (i >= destinos.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((setor = this.getSelecionadosFiltro(FILTRO_SETOR, 0)) != null) {
                bufWhere.append(" and e.set_codigo in (");
                for (int i = 0; i < setor.length; ++i) {
                    bufWhere.append(setor[i]);
                    if (i >= setor.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            this.getSelecionadosFiltroValoresConcat(FILTRO_EXAME, 0, bufWhere, " and c.exa_codigo in ", false, true);
            if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_INICIAL))) {
                bufWhere.append(" and b.req_data >= '");
                bufWhere.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_INICIAL)));
                bufWhere.append("'");
            }
            if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_FINAL))) {
                bufWhere.append(" and b.req_data <= '");
                bufWhere.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_FINAL)));
                bufWhere.append("'");
            }
            bufWhere.append(" and b.req_excluida = false and a.exr_excluido = false ");
            buf.append(bufWhere.toString());
            buf.append(" group by ");
            if (this.getSelecionadosFiltro(FILTRO_FILIAL, 0) == null || this.getSelecionadosFiltro(FILTRO_FILIAL, 0).length <= 1) {
                buf.append("filial.fil_codigo, ");
                buf.append("filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, ");
                buf.append("filial.fil_complemento, filial.fil_cep, filial.fil_fone, ");
                buf.append("filial.fil_fax, filial.fil_razaosocial, cidadefilial.cid_codigo, ");
                buf.append("cidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo, ");
                buf.append("bairrofilial.bai_descricao, filial.fil_cnes,  ");
            }
            buf.append("d.con_fantasia, d.con_codigo, d.con_razao ");
            if (this.getFiltroCheck(FILTRO_FORCAR_QUEBRA_MENSAL)) {
                buf.append(", anoMes");
            }
            buf.append(", cobrarExameBalcaoConvenio, percentualBalcaoConvenio");
            buf.append(" order by ");
            if (this.getFiltroCheck(FILTRO_FORCAR_QUEBRA_MENSAL)) {
                buf.append("anoMes");
            } else if (this.getFiltroCombo(FILTRO_ORDEM).equals(this.ordem[1])) {
                buf.append("d.con_razao");
            } else if (this.getFiltroCombo(FILTRO_ORDEM).equals(this.ordem[2])) {
                buf.append("d.con_fantasia");
            } else if (this.getFiltroCombo(FILTRO_ORDEM).equals(this.ordem[3])) {
                buf.append("1");
            } else if (this.getFiltroCombo(FILTRO_ORDEM).equals(this.ordem[4])) {
                buf.append("1 desc");
            } else if (this.getFiltroCombo(FILTRO_ORDEM).equals(this.ordem[5])) {
                buf.append("3");
            } else if (this.getFiltroCombo(FILTRO_ORDEM).equals(this.ordem[6])) {
                buf.append("3 desc");
            } else {
                buf.append("d.con_codigo ");
            }
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(campos);
                do {
                    Object[] o = new Object[campos.length];
                    HashMap<String, Double> totalizador = this.quantidadeRequisicoes(st2, filiais, rs, coletas, destinos, setor, grupos);
                    for (int i = 0; i < campos.length; ++i) {
                        if (RelatorioUtil.possuiColuna(rs, campos[i]) <= -1) continue;
                        if (campos[i].equalsIgnoreCase("quantidadeRequisicoes")) {
                            o[i] = (int)totalizador.get("quantidadeRequisicoes").doubleValue();
                            continue;
                        }
                        if (campos[i].equalsIgnoreCase("valorDescontoRequisicao")) {
                            double valor = 0.0;
                            if (rs.getBigDecimal("valorExame").compareTo(BigDecimal.ZERO) > 0) {
                                valor = totalizador.get("valorDescontoRequisicao");
                            }
                            o[i] = valor;
                            continue;
                        }
                        if (campos[i].equalsIgnoreCase("valorAcrescimoRequisicao")) {
                            double valor = 0.0;
                            if (rs.getBigDecimal("valorExame").compareTo(BigDecimal.ZERO) > 0) {
                                valor = totalizador.get("valorAcrescimoRequisicao");
                            }
                            o[i] = valor;
                            continue;
                        }
                        if (this.getFiltroCheck(FILTRO_FORCAR_QUEBRA_MENSAL) && campos[i].equalsIgnoreCase("anoMes")) {
                            o[i] = rs.getObject("anoMes");
                            continue;
                        }
                        if (this.getFiltroCheck(FILTRO_FORCAR_QUEBRA_MENSAL) && campos[i].equalsIgnoreCase("mesExtenso")) {
                            o[i] = this.mesExtenso(rs);
                            continue;
                        }
                        if (campos[i].equalsIgnoreCase("valorliquidoexame")) {
                            Double valorLiquido = rs.getDouble("valorliquidoexame") - rs.getDouble("valorliquidoexame") * 100.0 / rs.getDouble("valorliquidoexame") * totalizador.get("valorDescontoRequisicao") / 100.0;
                            valorLiquido = valorLiquido + rs.getDouble("valorliquidoexame") * 100.0 / rs.getDouble("valorliquidoexame") * totalizador.get("valorAcrescimoRequisicao") / 100.0;
                            o[i] = valorLiquido;
                            continue;
                        }
                        o[i] = rs.getObject(campos[i]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                String codigoFilial = Variaveis.filialPadrao;
                if (this.getSelecionadosFiltro(FILTRO_FILIAL, 0) != null && this.getSelecionadosFiltro(FILTRO_FILIAL, 0).length == 1) {
                    codigoFilial = this.getSelecionadosFiltro(FILTRO_FILIAL, 0)[0];
                }
                Registro regFilial = RelatorioUtil.pegaDadosFilial(st, codigoFilial);
                RelatorioUtil.preencheDadosFilial(regFilial, modelo);
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioAcumuladoConvenios.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    int i;
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(() -> {
                        this.panelCentro.removeAll();
                        this.panelCentro.repaint();
                        this.habilitaBotaoImprimir(true);
                    });
                    HashMap<String, Object> variavies = new HashMap<String, Object>();
                    variavies.put(FILTRO_ORDEM, this.getFiltroCombo(FILTRO_ORDEM));
                    variavies.put(FILTRO_DATA_INICIAL, this.getFiltroData(FILTRO_DATA_INICIAL));
                    variavies.put(FILTRO_DATA_FINAL, this.getFiltroData(FILTRO_DATA_FINAL));
                    variavies.put(FILTRO_EXAME, this.getSelecionadosFiltroValores(FILTRO_EXAME, 0, false, false));
                    buf.delete(0, buf.length());
                    if (filiais != null) {
                        for (i = 0; i < filiais.length; ++i) {
                            buf.append(filiais[i]);
                            if (i >= filiais.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    variavies.put(FILTRO_FILIAL, buf.toString());
                    buf.delete(0, buf.length());
                    if (convenio != null) {
                        for (i = 0; i < convenio.length; ++i) {
                            buf.append(convenio[i]);
                            if (i >= convenio.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    variavies.put(FILTRO_CONVENIO, buf.toString());
                    buf.delete(0, buf.length());
                    if (grupos != null) {
                        for (i = 0; i < grupos.length; ++i) {
                            buf.append(StringUtil.textoDBEscape(grupos[i]));
                            if (i >= grupos.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    variavies.put(FILTRO_GRUPO, buf.toString());
                    buf.delete(0, buf.length());
                    if (setor != null) {
                        for (i = 0; i < setor.length; ++i) {
                            buf.append(setor[i]);
                            if (i >= setor.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    variavies.put(FILTRO_SETOR, buf.toString());
                    buf.delete(0, buf.length());
                    if (coletas != null) {
                        for (i = 0; i < coletas.length; ++i) {
                            buf.append(coletas[i]);
                            if (i >= coletas.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    variavies.put(FILTRO_COLETA, buf.toString());
                    buf.delete(0, buf.length());
                    if (destinos != null) {
                        for (i = 0; i < destinos.length; ++i) {
                            buf.append(destinos[i]);
                            if (i >= destinos.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    variavies.put(FILTRO_DESTINO, buf.toString());
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, variavies);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
        }
        catch (Exception ex) {
            try {
                ex.printStackTrace();
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RelatorioAcumuladoConvenios");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st, st2);
                throw throwable;
            }
            Conexao.fecharStatement(st, st2);
        }
        Conexao.fecharStatement(st, st2);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private Object mesExtenso(ResultSet rs) throws SQLException {
        String mes = rs.getObject("anoMes").toString().substring(4, 6);
        int mesInt = Integer.parseInt(mes);
        return ConstantesGerais.MESES_ANO[mesInt - 1] + " de " + rs.getObject("anoMes").toString().substring(0, 4);
    }

    private HashMap<String, Double> quantidadeRequisicoes(Statement st, String[] filiais, ResultSet rs, String[] coletas, String[] destinos, String[] setores, String[] grupos) throws Exception {
        int i;
        StringBuilder buf = new StringBuilder();
        String convenio = rs.getString("codigoConvenio");
        buf.append("select ");
        buf.append("distinct ");
        buf.append(" b.req_codigo as quantidadeRequisicoes, ");
        buf.append(" b.req_vlrdesconto as valorDescontoRequisicao, ");
        buf.append(" b.req_vlracrescimo as valorAcrescimoRequisicao, ");
        buf.append(" b.req_total as valorTotal ");
        buf.append("from requisicao b ");
        buf.append("join examerequisicao c on b.fil_codigo = c.fil_codigo and b.req_codigo = c.req_codigo and c.exr_excluido = false ");
        if (setores != null) {
            buf.append("join examesetor d on c.fil_codigo = d.fil_codigo and c.exa_codigo = d.exa_codigo and d.ese_default = true ");
        }
        if (grupos != null) {
            buf.append("join examematgrupo g on c.fil_codigo = g.fil_codigo and c.exa_codigo = g.exa_codigo and c.mco_codigo = g.mco_codigo ");
        }
        buf.append("where b.fil_codigo IN (");
        for (i = 0; i < filiais.length; ++i) {
            buf.append(filiais[i]);
            if (i >= filiais.length - 1) continue;
            buf.append(", ");
        }
        buf.append(") ");
        if (!this.getFiltroCheck(FILTRO_FORCAR_QUEBRA_MENSAL)) {
            if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_INICIAL))) {
                buf.append(" and b.req_data >= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData(FILTRO_DATA_INICIAL)));
                buf.append("'");
            }
            if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_FINAL))) {
                buf.append(" and b.req_data <= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData(FILTRO_DATA_FINAL)));
                buf.append("'");
            }
        } else {
            buf.append(" and extract(year from b.req_data) = ").append(this.obterAno(rs));
            buf.append(" and extract(month from  b.req_data) = ").append(this.obterMes(rs));
        }
        if (!Funcoes.textoVazio(convenio)) {
            buf.append(" and b.con_codigo = ");
            buf.append(convenio);
        }
        if (coletas != null) {
            buf.append(" and b.col_codigo in (");
            for (i = 0; i < coletas.length; ++i) {
                buf.append("");
                buf.append(StringUtil.textoDBEscape(coletas[i]));
                buf.append("");
                if (i >= coletas.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (grupos != null) {
            buf.append(" and g.grp_codigo in (");
            for (i = 0; i < grupos.length; ++i) {
                buf.append("");
                buf.append(StringUtil.textoDBEscape(grupos[i]));
                buf.append("");
                if (i >= grupos.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        if (destinos != null) {
            buf.append(" and b.des_codigo in (");
            for (i = 0; i < destinos.length; ++i) {
                buf.append("");
                buf.append(StringUtil.textoDBEscape(destinos[i]));
                buf.append("");
                if (i >= destinos.length - 1) continue;
                buf.append(",");
            }
            buf.append(")");
        }
        if (setores != null) {
            buf.append(" and d.set_codigo in (");
            for (i = 0; i < setores.length; ++i) {
                buf.append(setores[i]);
                if (i >= setores.length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
        }
        buf.append(" and b.req_excluida = false and c.exr_excluido = false ");
        this.getSelecionadosFiltroValoresConcat(FILTRO_EXAME, 0, buf, " and c.exa_codigo in ", false, true);
        ResultSet rs2 = Conexao.executeQuery(st, buf.toString());
        int retorno = 0;
        BigDecimal valorDesconto = BigDecimal.ZERO;
        BigDecimal valorTotal = BigDecimal.ZERO;
        BigDecimal valorAcrescimo = BigDecimal.ZERO;
        HashMap<String, Double> totalizadores = new HashMap<String, Double>();
        while (rs2.next()) {
            ++retorno;
            valorDesconto = valorDesconto.add(rs2.getBigDecimal("valorDescontoRequisicao"));
            valorAcrescimo = valorAcrescimo.add(rs2.getBigDecimal("valorAcrescimoRequisicao"));
            valorTotal = valorTotal.add(rs2.getBigDecimal("valorTotal"));
        }
        totalizadores.put("quantidadeRequisicoes", Double.valueOf(retorno));
        totalizadores.put("valorAcrescimoRequisicao", valorAcrescimo.doubleValue());
        totalizadores.put("valorDescontoRequisicao", valorDesconto.doubleValue());
        totalizadores.put("valorTotal", valorTotal.doubleValue());
        rs2.close();
        return totalizadores;
    }

    private String obterMes(ResultSet rs) throws SQLException {
        StringBuilder mes = new StringBuilder();
        String resultado = rs.getString("anoMes");
        if (!Funcoes.textoVazio(resultado) && resultado.trim().length() == 6) {
            mes.append(resultado.substring(4, 6));
        }
        return mes.toString();
    }

    private String obterAno(ResultSet rs) throws SQLException {
        StringBuilder ano = new StringBuilder();
        String resultado = rs.getString("anoMes");
        if (!Funcoes.textoVazio(resultado) && resultado.trim().length() == 6) {
            ano.append(resultado.substring(0, 4));
        }
        return ano.toString();
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0880300100");
    }

    private long getModuloConfigurar() {
        return Long.parseLong("0880300101");
    }
}

