/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.gerencial;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.laboratorio.relatorios.util.RelatorioUtil;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioAcumuladoComparativoFaturamento
extends FrmRelPadrao {
    private final String[] ordem = new String[]{"C\u00f3digo", "Raz\u00e3o Social", "Fantasia", "Valor"};
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_COLETA = "filtroColeta";
    private final String FILTRO_DESTINO = "filtroDestino";
    private final String FILTRO_SETOR = "filtroSetor";
    private final String FILTRO_GRUPO = "filtroGrupo";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_DATA_INICIAL2 = "filtroDataInicial2";
    private final String FILTRO_DATA_FINAL2 = "filtroDataFinal2";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    protected static String[] campos;

    public static long getModuloAcesso() {
        return Long.parseLong("0880400500");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0880400501");
    }

    public RelatorioAcumuladoComparativoFaturamento() {
        campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio", "valorExames1", "valorExames2", "valorMaterial1", "valorMaterial2", "valorCH1", "valorCH2", "valorTotalExames1", "valorTotalExames2", "quantidadeExames1", "quantidadeExames2", "quantidadeRequisicoes1", "quantidadeRequisicoes2", "valorCH1Original", "valorCH2Original", "valorTotalCrescimento", "valorCustoSimplesExameHistorico1", "valorCustoSimplesExameAtual1", "valorCustoSimplesExameHistorico2", "valorCustoSimplesExameAtual2"});
        this.montaBarraDescricao("Relat\u00f3rio comparativo de evolu\u00e7\u00e3o de faturamento", "Listagem de quantidade de exames e requisi\u00e7\u00f5es faturados, comparando dois per\u00edodos", "relatorios/rel_ger_analitico_comparativo_evolucao_fatura.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroColeta", "Coleta", "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroDestino", "Destino", "destino", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroGrupo", "Grupo", "grupo", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"grp_codigo", "grp_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroSetor", "Setor", "setores", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "1\u00aa data Inicial:");
        this.adicionaFiltroData("filtroDataFinal", "1\u00aa data final:");
        this.adicionaFiltroData("filtroDataInicial2", "2\u00aa data inicial:");
        this.adicionaFiltroData("filtroDataFinal2", "2\u00aa data final:");
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.setModuloConfigurar(RelatorioAcumuladoComparativoFaturamento.getModuloConfigurar());
        this.setModuloAcesso(RelatorioAcumuladoComparativoFaturamento.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    @Override
    public void imprimirPressionado() {
        if (!Funcoes.verificaData(this.getFiltroData("filtroDataInicial")) || !Funcoes.verificaData(this.getFiltroData("filtroDataFinal")) || Funcoes.comparaData(this.getFiltroData("filtroDataInicial"), this.getFiltroData("filtroDataFinal")) > 0) {
            Funcoes.mensagem(this, "Data do primeiro per\u00edodo inv\u00e1lida para consulta", 1);
            this.habilitaBotaoImprimir(true);
            return;
        }
        if (Funcoes.comparaData(this.getFiltroData("filtroDataFinal"), this.getFiltroData("filtroDataInicial2")) >= 0) {
            Funcoes.mensagem(this, "Data inical do segundo per\u00edodo n\u00e3o pode ser menor ou igual a data final do primeiro per\u00eddo!", 1);
            this.habilitaBotaoImprimir(true);
            return;
        }
        if (!Funcoes.verificaData(this.getFiltroData("filtroDataInicial2")) || !Funcoes.verificaData(this.getFiltroData("filtroDataFinal2")) || Funcoes.comparaData(this.getFiltroData("filtroDataInicial2"), this.getFiltroData("filtroDataFinal2")) > 0) {
            Funcoes.mensagem(this, "Data do segundo per\u00edodo inv\u00e1lida para consulta", 1);
            this.habilitaBotaoImprimir(true);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        Statement st = Conexao.getStatement();
        try {
            String[] setor;
            String[] destinos;
            String[] coletas;
            String[] grupos;
            StringBuilder bufPeriodo1 = this.geraCondicaoPeriodo("filtroDataInicial", "filtroDataFinal", "fat");
            StringBuilder bufPeriodo2 = this.geraCondicaoPeriodo("filtroDataInicial2", "filtroDataFinal2", "fat2");
            String bufValorExame1 = this.geraFuncaoCalculoExame("fat", "calculaprecototalexamerequisicao");
            String bufValorExame2 = this.geraFuncaoCalculoExame("fat2", "calculaprecototalexamerequisicao");
            StringBuilder buf = new StringBuilder("select ");
            buf.append("count(case when ").append((CharSequence)bufPeriodo1).append(" then 1 else null end  ) as quantidadeExames1, ");
            buf.append("count(case when ").append((CharSequence)bufPeriodo2).append(" then 1 else null end  ) as quantidadeExames2, ");
            buf.append("sum(case when ").append((CharSequence)bufPeriodo1).append(" then ").append(bufValorExame1).append(" else 0 end  ) as valorExames1, ");
            buf.append("sum(case when ").append((CharSequence)bufPeriodo2).append(" then ").append(bufValorExame2).append(" else 0 end  ) as valorExames2, ");
            buf.append("sum(case when ").append((CharSequence)bufPeriodo1).append(" then a.fer_total else 0 end  ) as valorTotalExames1, ");
            buf.append("sum(case when ").append((CharSequence)bufPeriodo2).append(" then a.fer_total else 0 end  ) as valorTotalExames2, ");
            buf.append("sum(case when ").append((CharSequence)bufPeriodo1).append(" then a.fer_totalmateriais else 0 end  ) as valorMaterial1, ");
            buf.append("sum(case when ").append((CharSequence)bufPeriodo2).append(" then a.fer_totalmateriais else 0 end  ) as valorMaterial2, ");
            buf.append("sum(case when ").append((CharSequence)bufPeriodo1).append(" then a.fer_totalch else 0 end  ) as valorCH1Original, ");
            buf.append("sum(case when ").append((CharSequence)bufPeriodo2).append(" then a.fer_totalch else 0 end  ) as valorCH2Original, ");
            buf.append("sum(case when ").append((CharSequence)bufPeriodo1).append(" then calculachexamerequisicao(fat.fil_codigo, fat.con_codigo, a.req_codigo, a.exa_codigo, a.mco_codigo) else 0 end  ) as valorCH1, ");
            buf.append("sum(case when ").append((CharSequence)bufPeriodo2).append(" then calculachexamerequisicao(fat.fil_codigo, fat.con_codigo, a.req_codigo, a.exa_codigo, a.mco_codigo) else 0 end  ) as valorCH2, ");
            buf.append("count(distinct case when ").append((CharSequence)bufPeriodo1).append(" then a.req_codigo else null end  ) as quantidadeRequisicoes1, ");
            buf.append("count(distinct case when ").append((CharSequence)bufPeriodo2).append(" then a.req_codigo else null end  ) as quantidadeRequisicoes2, ");
            buf.append("sum(case when ").append((CharSequence)bufPeriodo2).append(" then a.fer_total else 0 end  ) - ");
            buf.append("sum(case when ").append((CharSequence)bufPeriodo1).append(" then a.fer_total else 0 end  ) as valorTotalCrescimento,  ");
            buf.append("sum(case when ").append((CharSequence)bufPeriodo1).append(" then exr.exr_custosimples else 0 end  ) as valorCustoSimplesExameHistorico1, ");
            buf.append("sum(case when ").append((CharSequence)bufPeriodo2).append(" then exr.exr_custosimples else 0 end  ) as valorCustoSimplesExameHistorico2, ");
            buf.append("sum(case when ").append((CharSequence)bufPeriodo1).append(" then emc.emc_custosimples else 0 end  ) as valorCustoSimplesExameAtual1, ");
            buf.append("sum(case when ").append((CharSequence)bufPeriodo2).append(" then emc.emc_custosimples else 0 end  ) as valorCustoSimplesExameAtual2, ");
            buf.append("con.con_fantasia as fantasiaConvenio, ");
            buf.append("con.con_codigo as codigoConvenio, ");
            buf.append("con.con_razao as razaoSocialConvenio ");
            if (this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
                buf.append(",").append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            }
            buf.append("FROM faturaexamerequisicao a ");
            buf.append("LEFT JOIN fatura fat ON a.fil_codigo = fat.fil_codigo AND a.fat_codigo = fat.fat_codigo AND fat.fat_datacancelamento is null ");
            buf.append("LEFT JOIN fatura fat2 ON a.fil_codigo = fat2.fil_codigo AND a.fat_codigo = fat2.fat_codigo AND fat2.fat_datacancelamento is null ");
            buf.append("LEFT JOIN requisicao req ON a.fil_kodigo = req.fil_codigo AND a.req_codigo = req.req_codigo AND req.req_excluida = false ");
            buf.append("LEFT JOIN examerequisicao exr ON a.fil_kodigo = exr.fil_codigo AND a.req_codigo = exr.req_codigo AND a.exa_codigo = exr.exa_codigo and a.mco_codigo = exr.mco_codigo ");
            buf.append("LEFT JOIN faturarequisicao fre ON a.fil_kodigo = fre.fil_kodigo AND req.req_codigo = fre.req_codigo AND ");
            buf.append("          a.req_codigo = fre.req_codigo AND a.fat_codigo = fre.fat_codigo ");
            buf.append("LEFT JOIN examesetor exs ON a.fil_codigo = exs.fil_codigo AND a.exa_codigo = exs.exa_codigo AND exs.ese_default = true ");
            buf.append("LEFT JOIN convenios con ON ( a.fil_kodigo = con.fil_codigo AND fat.con_codigo = con.con_codigo ) OR ( a.fil_kodigo = con.fil_codigo ");
            buf.append("          AND fat2.con_codigo = con.con_codigo ) AND req.con_codigo = con.con_codigo ");
            buf.append("LEFT JOIN examematgrupo emg ON a.fil_codigo = emg.fil_codigo AND a.exa_codigo = emg.exa_codigo AND a.mco_codigo = emg.mco_codigo ");
            buf.append("LEFT JOIN exames exa ON a.fil_codigo = exa.fil_codigo AND a.exa_codfilho = exa.exa_codigo AND exs.exa_codigo = exa.exa_codigo ");
            buf.append("LEFT JOIN materialcoleta mco ON a.fil_codigo = mco.fil_codigo AND a.mco_codfilho = mco.mco_codigo AND emg.mco_codigo = mco.mco_codigo ");
            buf.append("LEFT JOIN setores setor ON a.fil_codigo = setor.fil_codigo AND exs.set_codigo = setor.set_codigo ");
            buf.append("LEFT JOIN destino des ON a.fil_codigo = des.fil_codigo AND req.des_codigo = des.des_codigo ");
            buf.append("LEFT JOIN coletas col ON a.fil_codigo = col.fil_codigo AND req.col_codigo = col.col_codigo ");
            buf.append("LEFT JOIN usuario cancel ON a.fil_codigo = cancel.fil_codigo AND fat.usr_codcancelamento = cancel.usr_codigo AND ");
            buf.append("          fat2.usr_codcancelamento = cancel.usr_codigo ");
            buf.append("LEFT JOIN usuario usr ON a.fil_codigo = usr.fil_codigo AND fat.usr_codigo = usr.usr_codigo AND fat2.usr_codigo = usr.usr_codigo ");
            buf.append("LEFT JOIN usuario comissao ON a.fil_codigo = comissao.fil_codigo AND fat.usr_codcomissao = comissao.usr_codigo AND ");
            buf.append("          fat2.usr_codcomissao = comissao.usr_codigo ");
            buf.append("LEFT JOIN examematcoleta emc on a.fil_codigo = emc.fil_codigo and a.exa_codigo = emc.exa_codigo and a.mco_codigo = emc.mco_codigo ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            StringBuilder bufWhere = new StringBuilder();
            String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
            if (filiais == null) {
                filiais = new String[]{Variaveis.filialPadrao};
            }
            bufWhere.append(" where a.fil_kodigo in (");
            for (int i = 0; i < filiais.length; ++i) {
                bufWhere.append(filiais[i]);
                if (i >= filiais.length - 1) continue;
                bufWhere.append(", ");
            }
            bufWhere.append(") ");
            String[] convenio = this.getSelecionadosFiltro("filtroConvenio", 0);
            if (convenio != null) {
                bufWhere.append(" and fre.con_codigo in (");
                for (int i = 0; i < convenio.length; ++i) {
                    bufWhere.append(convenio[i]);
                    if (i >= convenio.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((grupos = this.getSelecionadosFiltro("filtroGrupo", 0)) != null) {
                bufWhere.append(" and emg.grp_codigo in (");
                for (int i = 0; i < grupos.length; ++i) {
                    bufWhere.append("'");
                    bufWhere.append(grupos[i]);
                    bufWhere.append("'");
                    if (i >= grupos.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((coletas = this.getSelecionadosFiltro("filtroColeta", 0)) != null) {
                bufWhere.append(" and req.col_codigo in (");
                for (int i = 0; i < coletas.length; ++i) {
                    bufWhere.append("'");
                    bufWhere.append(coletas[i]);
                    bufWhere.append("'");
                    if (i >= coletas.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((destinos = this.getSelecionadosFiltro("filtroDestino", 0)) != null) {
                bufWhere.append(" and req.des_codigo in (");
                for (int i = 0; i < destinos.length; ++i) {
                    bufWhere.append("'");
                    bufWhere.append(destinos[i]);
                    bufWhere.append("'");
                    if (i >= destinos.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((setor = this.getSelecionadosFiltro("filtroSetor", 0)) != null) {
                bufWhere.append(" and setor.set_codigo in (");
                for (int i = 0; i < setor.length; ++i) {
                    bufWhere.append(setor[i]);
                    if (i >= setor.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            bufWhere.append(" and ( ").append((CharSequence)bufPeriodo1).append(" or ").append((CharSequence)bufPeriodo2).append(" )");
            buf.append(bufWhere.toString());
            buf.append(" group by ");
            if (this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
                buf.append("filial.fil_codigo, ");
                buf.append("filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, ");
                buf.append("filial.fil_complemento, filial.fil_cep, filial.fil_fone, ");
                buf.append("filial.fil_fax, filial.fil_razaosocial, cidadefilial.cid_codigo, ");
                buf.append("cidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo, ");
                buf.append("bairrofilial.bai_descricao, filial.fil_cnes, ");
            }
            buf.append("con.con_fantasia, con.con_codigo, con.con_razao ");
            buf.append(" order by ");
            if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[1])) {
                buf.append("con.con_razao");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[2])) {
                buf.append("con.con_fantasia");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[3])) {
                buf.append("13");
            } else {
                buf.append("con.con_codigo ");
            }
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(campos);
                do {
                    if (rs.getInt("quantidadeExames1") <= 0) continue;
                    Object[] o = new Object[campos.length];
                    for (int i = 0; i < campos.length; ++i) {
                        if (campos[i].equals("valorExames1")) {
                            o[i] = this.getValorExame(rs.getBigDecimal("valorExames1"));
                            continue;
                        }
                        if (campos[i].equals("valorExameRealizados2")) {
                            o[i] = this.getValorExame(rs.getBigDecimal("valorExames2"));
                            continue;
                        }
                        if (RelatorioUtil.possuiColuna(rs, campos[i]) <= -1) continue;
                        o[i] = rs.getObject(campos[i]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                if (modelo.getRowCount() > 0) {
                    String codigoFilial = Variaveis.filialPadrao;
                    if (this.getSelecionadosFiltro("filtroFilial", 0) != null && this.getSelecionadosFiltro("filtroFilial", 0).length == 1) {
                        codigoFilial = this.getSelecionadosFiltro("filtroFilial", 0)[0];
                    }
                    Registro regFilial = RelatorioUtil.pegaDadosFilial(st, codigoFilial);
                    RelatorioUtil.preencheDadosFilial(regFilial, modelo);
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(RelatorioAcumuladoComparativoFaturamento.getModuloAcesso());
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        int i;
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(0.5f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioAcumuladoComparativoFaturamento.this.panelCentro.removeAll();
                                RelatorioAcumuladoComparativoFaturamento.this.panelCentro.repaint();
                                RelatorioAcumuladoComparativoFaturamento.this.habilitaBotaoImprimir(true);
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                        var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                        var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                        var.put("filtroDataInicial2", this.getFiltroData("filtroDataInicial2"));
                        var.put("filtroDataFinal2", this.getFiltroData("filtroDataFinal2"));
                        buf.delete(0, buf.length());
                        if (filiais != null) {
                            for (i = 0; i < filiais.length; ++i) {
                                buf.append(filiais[i]);
                                if (i >= filiais.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroFilial", buf.toString());
                        buf.delete(0, buf.length());
                        if (convenio != null) {
                            for (i = 0; i < convenio.length; ++i) {
                                buf.append(convenio[i]);
                                if (i >= convenio.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroConvenio", buf.toString());
                        buf.delete(0, buf.length());
                        if (grupos != null) {
                            for (i = 0; i < grupos.length; ++i) {
                                buf.append(grupos[i]);
                                if (i >= grupos.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroGrupo", buf.toString());
                        buf.delete(0, buf.length());
                        if (setor != null) {
                            for (i = 0; i < setor.length; ++i) {
                                buf.append(setor[i]);
                                if (i >= setor.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroSetor", buf.toString());
                        buf.delete(0, buf.length());
                        if (coletas != null) {
                            for (i = 0; i < coletas.length; ++i) {
                                buf.append(coletas[i]);
                                if (i >= coletas.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroColeta", buf.toString());
                        buf.delete(0, buf.length());
                        if (destinos != null) {
                            for (i = 0; i < destinos.length; ++i) {
                                buf.append(destinos[i]);
                                if (i >= destinos.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroDestino", buf.toString());
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelCentro.revalidate();
                    }
                } else {
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                    this.habilitaBotaoImprimir(true);
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RelatorioAcumuladoComparativoFaturamento");
        }
        Conexao.fecharStatement(st);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private StringBuilder geraCondicaoPeriodo(String filtroDataInicial, String filtroDataFinal, String tabelaRelacionada) {
        StringBuilder bufPeriodo = new StringBuilder();
        if (Funcoes.verificaData(this.getFiltroData(filtroDataInicial))) {
            bufPeriodo.append(" (").append(tabelaRelacionada).append(".fat_dtemis >= '");
            bufPeriodo.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData(filtroDataInicial)));
            bufPeriodo.append("'");
        }
        if (Funcoes.verificaData(this.getFiltroData(filtroDataFinal))) {
            bufPeriodo.append(" and ").append(tabelaRelacionada).append(".fat_dtemis <= '");
            bufPeriodo.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData(filtroDataFinal)));
            bufPeriodo.append("' )");
        }
        return bufPeriodo;
    }

    private String geraFuncaoCalculoExame(String tabelaRelacionada, String funcao) {
        return new String(funcao.concat("(").concat(tabelaRelacionada).concat(".fil_codigo, ").concat(tabelaRelacionada).concat(".con_codigo, ").concat("a.req_codigo, a.exa_codigo, a.mco_codigo, false, true, true, exr.exr_vlrchexame, exr.exr_vlrch, exr.exr_valorporte, exr.exr_valorcusto, exr.exr_valoruco, exr.exr_vlrbalcaoconvenio, exr.exr_datafatura IS NOT NULL OR exr.usr_codfatura IS NOT NULL, exr.exr_vlrmaterial, exr.exr_vlrbalcaoconvenio, con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ").concat(ParametrosGerais.getCasasPrecoExame() + "").concat(", ").concat(ParametrosGerais.getArredondamentoPrecoExame().ordinal() + "").concat(", ").concat(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").concat(", exr.met_codigo").concat(")"));
    }

    private String geraFuncaoCalculoTotalExame(String tabelaRelacionada, String funcao) {
        return new String(funcao.concat("(").concat(tabelaRelacionada).concat(".fil_codigo, ").concat(tabelaRelacionada).concat(".con_codigo, ").concat("a.req_codigo, a.exa_codigo, a.mco_codigo, false, true, true, exr.exr_vlrchexame, exr.exr_vlrch, exr.exr_valorporte, exr.exr_valorcusto, exr.exr_valoruco, exr.exr_vlrbalcaoconvenio, exr.exr_datafatura IS NOT NULL OR exr.usr_codfatura IS NOT NULL, exr.exr_vlrmaterial, exr.exr_vlrbalcaoconvenio, con.con_precosdiferenciados, con.con_reajuste, con.con_cobrmaterial, con.con_percpgtomaterial, con.con_percpgto, con.con_tpcalcfatu, con.con_tpcalcch, con.con_perguntarpercbalcao, con.con_acrescimo, con.con_bonus, con.tpe_codigo, con.con_acrescimoporte, con.con_acrescimouco, con.con_descontoporte, con.con_descontouco, con.con_valorch, ").concat(ParametrosGerais.getCasasPrecoExame() + "").concat(", ").concat(ParametrosGerais.getArredondamentoPrecoExame().ordinal() + "").concat(", ").concat(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").concat(", exr.met_codigo").concat(")"));
    }

    private BigDecimal getValorExame(BigDecimal valor) {
        BigDecimal valorExame = new BigDecimal(0);
        return valorExame.add(valor).setScale(2, RoundingMode.HALF_UP);
    }
}

