/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.gerencial;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.laboratorio.relatorios.util.RelatorioUtil;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioAcumuladoComparativoConvenio
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String[] ordem = new String[]{"C\u00f3digo", "Raz\u00e3o Social", "Fantasia", "Valor"};
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_COLETA = "filtroColeta";
    private final String FILTRO_DESTINO = "filtroDestino";
    private final String FILTRO_SETOR = "filtroSetor";
    private final String FILTRO_GRUPO = "filtroGrupo";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_DATA_INICIAL2 = "filtroDataInicial2";
    private final String FILTRO_DATA_FINAL2 = "filtroDataFinal2";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    protected static String[] campos;

    public RelatorioAcumuladoComparativoConvenio() {
        campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoConvenio", "razaoSocialConvenio", "fantasiaConvenio", "valorExame1", "valorMaterial1", "valorCH1", "valorTotalExame1", "quantidadeExames1", "quantidadeRequisicoes1", "valorExame2", "valorExameRealizados1", "valorTotalExameRealizados1", "valorMaterialRealizados1", "quantidadeExamesRealizados1", "valorExameRealizados2", "valorTotalExameRealizados2", "valorMaterialRealizados2", "quantidadeExamesRealizados2", "valorMaterial2", "valorCH2", "valorTotalExame2", "quantidadeExames2", "quantidadeRequisicoes2", "valorTotalCrescimento", "valorCH1Original", "valorCH2Original", "valorCustoSimplesExameHistorico1", "valorCustoSimplesExameAtual1", "valorCustoSimplesExameHistorico2", "valorCustoSimplesExameAtual2"});
        this.montaBarraDescricao("Relat\u00f3rio comparativo de evolu\u00e7\u00e3o", "Listagem de quantidade de exames e requisi\u00e7\u00f5es solicitados, comparando dois per\u00edodos", "relatorios/rel_ger_analitico_comparativo_evolucao.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroColeta", "Coleta", "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroDestino", "Destino", "destino", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"des_codigo", "des_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroGrupo", "Grupo", "grupo", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"grp_codigo", "grp_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroSetor", "Setor", "setores", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "1\u00aa data Inicial:");
        this.adicionaFiltroData("filtroDataFinal", "1\u00aa data final:");
        this.adicionaFiltroData("filtroDataInicial2", "2\u00aa data inicial:");
        this.adicionaFiltroData("filtroDataFinal2", "2\u00aa data final:");
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.setModuloConfigurar(RelatorioAcumuladoComparativoConvenio.getModuloConfigurar());
        this.setModuloAcesso(RelatorioAcumuladoComparativoConvenio.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    public static long getModuloConfigurar() {
        return 880400401L;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0880400400");
    }

    @Override
    public void imprimirPressionado() {
        if (!Funcoes.verificaData(this.getFiltroData("filtroDataInicial")) || !Funcoes.verificaData(this.getFiltroData("filtroDataFinal")) || Funcoes.comparaData(this.getFiltroData("filtroDataInicial"), this.getFiltroData("filtroDataFinal")) > 0) {
            Funcoes.mensagem(this, "A data inicial e final do primeiro per\u00edodo deve ser preenchida.", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        if (Funcoes.comparaData(this.getFiltroData("filtroDataFinal"), this.getFiltroData("filtroDataInicial2")) >= 0) {
            Funcoes.mensagem(this, "A data inicial do segundo per\u00edodo deve ser maior que a data final do primeiro per\u00edodo.", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        if (!Funcoes.verificaData(this.getFiltroData("filtroDataInicial2")) || !Funcoes.verificaData(this.getFiltroData("filtroDataFinal2")) || Funcoes.comparaData(this.getFiltroData("filtroDataInicial2"), this.getFiltroData("filtroDataFinal2")) > 0) {
            Funcoes.mensagem(this, "A data inicial e final do segundo per\u00edodo deve ser preenchida.", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        Statement st = Conexao.getStatement();
        try {
            String[] setor;
            String[] destinos;
            String[] coletas;
            String[] grupos;
            StringBuilder bufPeriodo1 = this.geraCondicaoPeriodo("filtroDataInicial", "filtroDataFinal", "b");
            StringBuilder bufPeriodo2 = this.geraCondicaoPeriodo("filtroDataInicial2", "filtroDataFinal2", "b2");
            String bufValorExame1 = this.geraFuncaoCalculoExame("b", "calculaprecototalexamerequisicao");
            String bufValorExame2 = this.geraFuncaoCalculoExame("b2", "calculaprecototalexamerequisicao");
            String valorTotalExame1 = this.geraFuncaoCalculoTotalExame("b", "calculaprecototalexamerequisicao");
            String valorTotalExame2 = this.geraFuncaoCalculoTotalExame("b2", "calculaprecototalexamerequisicao");
            StringBuilder situacoesExamesRealizados = new StringBuilder();
            situacoesExamesRealizados.append(" and a.exr_situacao IN ('");
            situacoesExamesRealizados.append("P").append("', '");
            situacoesExamesRealizados.append("L").append("', '");
            situacoesExamesRealizados.append("C").append("', '");
            situacoesExamesRealizados.append("I").append("', '");
            situacoesExamesRealizados.append("E");
            situacoesExamesRealizados.append("') ");
            StringBuilder buf = new StringBuilder("select ");
            buf.append("count(case when ").append((CharSequence)bufPeriodo1).append(" then 1 else null end  ) as quantidadeExames1, ");
            buf.append("count(case when ").append((CharSequence)bufPeriodo2).append(" then 1 else null end  ) as quantidadeExames2, ");
            buf.append("sum(case when ").append((CharSequence)bufPeriodo1).append(" then ").append(bufValorExame1).append(" else 0 end  ) as valorExame1, ");
            buf.append("sum(case when ").append((CharSequence)bufPeriodo2).append(" then ").append(bufValorExame2).append(" else 0 end  ) as valorExame2, ");
            buf.append("sum(case when ").append((CharSequence)bufPeriodo1).append(" then ").append(valorTotalExame1).append(" else 0 end  ) as valorTotalExame1, ");
            buf.append("sum(case when ").append((CharSequence)bufPeriodo2).append(" then ").append(valorTotalExame2).append(" else 0 end  ) as valorTotalExame2, ");
            buf.append("sum(case when ").append((CharSequence)bufPeriodo1).append(" then a.exr_vlrmaterial else 0 end  ) as valorMaterial1, ");
            buf.append("sum(case when ").append((CharSequence)bufPeriodo2).append(" then a.exr_vlrmaterial else 0 end  ) as valorMaterial2, ");
            buf.append("count(case when ").append((CharSequence)bufPeriodo1).append((CharSequence)situacoesExamesRealizados).append(" then 1 else null end  ) as quantidadeExamesRealizados1, ");
            buf.append("count(case when ").append((CharSequence)bufPeriodo2).append((CharSequence)situacoesExamesRealizados).append(" then 1 else null end  ) as quantidadeExamesRealizados2, ");
            buf.append("sum(case when ").append((CharSequence)bufPeriodo1).append((CharSequence)situacoesExamesRealizados).append(" then ").append(bufValorExame1).append(" else 0 end  ) as valorExameRealizados1, ");
            buf.append("sum(case when ").append((CharSequence)bufPeriodo2).append((CharSequence)situacoesExamesRealizados).append(" then ").append(bufValorExame2).append(" else 0 end  ) as valorExameRealizados2, ");
            buf.append("sum(case when ").append((CharSequence)bufPeriodo1).append((CharSequence)situacoesExamesRealizados).append(" then ").append(valorTotalExame1).append(" else 0 end  ) as valorTotalExameRealizados1, ");
            buf.append("sum(case when ").append((CharSequence)bufPeriodo2).append((CharSequence)situacoesExamesRealizados).append(" then ").append(valorTotalExame2).append(" else 0 end  ) as valorTotalExameRealizados2, ");
            buf.append("sum(case when ").append((CharSequence)bufPeriodo1).append((CharSequence)situacoesExamesRealizados).append(" then a.exr_vlrmaterial else 0 end  ) as valorMaterialRealizados1, ");
            buf.append("sum(case when ").append((CharSequence)bufPeriodo2).append((CharSequence)situacoesExamesRealizados).append(" then a.exr_vlrmaterial else 0 end  ) as valorMaterialRealizados2, ");
            buf.append("sum(case when ").append((CharSequence)bufPeriodo1).append(" then a.exr_vlrchexame else 0 end  ) as valorCH1Original, ");
            buf.append("sum(case when ").append((CharSequence)bufPeriodo2).append(" then a.exr_vlrchexame else 0 end  ) as valorCH2Original, ");
            buf.append("sum(case when ").append((CharSequence)bufPeriodo1).append(" then calculachexamerequisicao(b.fil_codigo, b.con_codigo, b.req_codigo, a.exa_codigo, a.mco_codigo) else 0 end  ) as valorCH1, ");
            buf.append("sum(case when ").append((CharSequence)bufPeriodo2).append(" then calculachexamerequisicao(b2.fil_codigo, b2.con_codigo, b2.req_codigo, a.exa_codigo, a.mco_codigo) else 0 end  ) as valorCH2, ");
            buf.append("count(distinct case when ").append((CharSequence)bufPeriodo1).append(" then a.req_codigo else null end  ) as quantidadeRequisicoes1, ");
            buf.append("count(distinct case when ").append((CharSequence)bufPeriodo2).append(" then a.req_codigo else null end  ) as quantidadeRequisicoes2, ");
            buf.append("sum(case when ").append((CharSequence)bufPeriodo2).append(" then ").append(valorTotalExame2).append(" else 0 end  ) - ");
            buf.append("sum(case when ").append((CharSequence)bufPeriodo1).append(" then ").append(valorTotalExame1).append(" else 0 end  ) as valorTotalCrescimento,  ");
            buf.append("sum(case when ").append((CharSequence)bufPeriodo1).append(" then a.exr_custosimples else 0 end  ) as valorCustoSimplesExameHistorico1, ");
            buf.append("sum(case when ").append((CharSequence)bufPeriodo2).append(" then a.exr_custosimples else 0 end  ) as valorCustoSimplesExameHistorico2, ");
            buf.append("sum(case when ").append((CharSequence)bufPeriodo1).append(" then h.emc_custosimples else 0 end  ) as valorCustoSimplesExameAtual1, ");
            buf.append("sum(case when ").append((CharSequence)bufPeriodo2).append(" then h.emc_custosimples else 0 end  ) as valorCustoSimplesExameAtual2, ");
            buf.append("d.con_fantasia as fantasiaConvenio, ");
            buf.append("d.con_codigo as codigoConvenio, ");
            buf.append("d.con_razao as razaoSocialConvenio ");
            if (this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
                buf.append(",").append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            }
            buf.append("from examerequisicao a ");
            buf.append("join requisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            buf.append("join requisicao b2 on a.fil_codigo = b2.fil_codigo and a.req_codigo = b2.req_codigo ");
            buf.append("left join exames c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo ");
            buf.append("left join convenios d on (a.fil_codigo = d.fil_codigo and b.con_codigo = d.con_codigo) or (a.fil_codigo = d.fil_codigo and b2.con_codigo = d.con_codigo) ");
            buf.append("left join examesetor e on a.fil_codigo = e.fil_codigo and a.exa_codigo = e.exa_codigo and e.ese_default = true ");
            buf.append("left join examematgrupo g on a.fil_codigo = g.fil_codigo and a.exa_codigo = g.exa_codigo and a.mco_codigo = g.mco_codigo ");
            buf.append("left join setores f on e.fil_codigo = f.fil_codigo and e.set_codigo = f.set_codigo ");
            buf.append("left join examematcoleta h on a.fil_codigo = h.fil_codigo and a.exa_codigo = h.exa_codigo and a.mco_codigo = h.mco_codigo ");
            if (this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            }
            StringBuilder bufWhere = new StringBuilder();
            String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
            if (filiais == null) {
                filiais = new String[]{Variaveis.filialPadrao};
            }
            bufWhere.append(" where a.fil_codigo in (");
            for (int i = 0; i < filiais.length; ++i) {
                bufWhere.append(filiais[i]);
                if (i >= filiais.length - 1) continue;
                bufWhere.append(", ");
            }
            bufWhere.append(") ");
            String[] convenio = this.getSelecionadosFiltro("filtroConvenio", 0);
            if (convenio != null) {
                int i;
                bufWhere.append(" and (b.con_codigo in (");
                for (i = 0; i < convenio.length; ++i) {
                    bufWhere.append(convenio[i]);
                    if (i >= convenio.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(") or b2.con_codigo in (");
                for (i = 0; i < convenio.length; ++i) {
                    bufWhere.append(convenio[i]);
                    if (i >= convenio.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append("))");
            }
            if ((grupos = this.getSelecionadosFiltro("filtroGrupo", 0)) != null) {
                bufWhere.append(" and g.grp_codigo in (");
                for (int i = 0; i < grupos.length; ++i) {
                    bufWhere.append("'");
                    bufWhere.append(grupos[i]);
                    bufWhere.append("'");
                    if (i >= grupos.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            if ((coletas = this.getSelecionadosFiltro("filtroColeta", 0)) != null) {
                int i;
                bufWhere.append(" and (b.col_codigo in (");
                for (i = 0; i < coletas.length; ++i) {
                    bufWhere.append("'");
                    bufWhere.append(coletas[i]);
                    bufWhere.append("'");
                    if (i >= coletas.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(") or b2.col_codigo in (");
                for (i = 0; i < coletas.length; ++i) {
                    bufWhere.append("'");
                    bufWhere.append(coletas[i]);
                    bufWhere.append("'");
                    if (i >= coletas.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append("))");
            }
            if ((destinos = this.getSelecionadosFiltro("filtroDestino", 0)) != null) {
                int i;
                bufWhere.append(" and (b.des_codigo in (");
                for (i = 0; i < destinos.length; ++i) {
                    bufWhere.append("'");
                    bufWhere.append(destinos[i]);
                    bufWhere.append("'");
                    if (i >= destinos.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(") or b2.des_codigo in (");
                for (i = 0; i < destinos.length; ++i) {
                    bufWhere.append("'");
                    bufWhere.append(destinos[i]);
                    bufWhere.append("'");
                    if (i >= destinos.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append("))");
            }
            if ((setor = this.getSelecionadosFiltro("filtroSetor", 0)) != null) {
                bufWhere.append(" and e.set_codigo in (");
                for (int i = 0; i < setor.length; ++i) {
                    bufWhere.append(setor[i]);
                    if (i >= setor.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            bufWhere.append(" and ( ").append((CharSequence)bufPeriodo1).append(" or ").append((CharSequence)bufPeriodo2).append(" )");
            bufWhere.append(" and b.req_excluida = false and a.exr_excluido = false ");
            buf.append(bufWhere.toString());
            buf.append(" group by ");
            if (this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
                buf.append("filial.fil_codigo, ");
                buf.append("filial.fil_descricao, filial.fil_cnpj, filial.fil_endereco, ");
                buf.append("filial.fil_complemento, filial.fil_cep, filial.fil_fone, ");
                buf.append("filial.fil_fax, filial.fil_razaosocial, cidadefilial.cid_codigo, ");
                buf.append("cidadefilial.cid_nome, cidadefilial.cid_uf, bairrofilial.bai_codigo, ");
                buf.append("bairrofilial.bai_descricao, filial.fil_cnes, ");
            }
            buf.append("d.con_fantasia, d.con_codigo, d.con_razao ");
            buf.append(" order by ");
            if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[1])) {
                buf.append("d.con_razao");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[2])) {
                buf.append("d.con_fantasia");
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[3])) {
                buf.append("13");
            } else {
                buf.append("d.con_codigo ");
            }
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(campos);
                do {
                    if (rs.getInt("quantidadeExames1") <= 0 && rs.getInt("quantidadeExames2") <= 0) continue;
                    Object[] o = new Object[campos.length];
                    for (int i = 0; i < campos.length; ++i) {
                        if (campos[i].equals("valorExameRealizados1")) {
                            o[i] = this.getValorExameRealizado(rs.getBigDecimal("valorExameRealizados1"));
                            continue;
                        }
                        if (campos[i].equals("valorExameRealizados2")) {
                            o[i] = this.getValorExameRealizado(rs.getBigDecimal("valorExameRealizados2"));
                            continue;
                        }
                        if (campos[i].equals("valorExame1")) {
                            o[i] = this.getValorExameRealizado(rs.getBigDecimal("valorExame1"));
                            continue;
                        }
                        if (campos[i].equals("valorExame2")) {
                            o[i] = this.getValorExameRealizado(rs.getBigDecimal("valorExame2"));
                            continue;
                        }
                        if (RelatorioUtil.possuiColuna(rs, campos[i]) <= -1) continue;
                        o[i] = rs.getObject(campos[i]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                if (modelo.getRowCount() > 0) {
                    String codigoFilial = Variaveis.filialPadrao;
                    if (this.getSelecionadosFiltro("filtroFilial", 0) != null && this.getSelecionadosFiltro("filtroFilial", 0).length == 1) {
                        codigoFilial = this.getSelecionadosFiltro("filtroFilial", 0)[0];
                    }
                    Registro regFilial = RelatorioUtil.pegaDadosFilial(st, codigoFilial);
                    RelatorioUtil.preencheDadosFilial(regFilial, modelo);
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(RelatorioAcumuladoComparativoConvenio.getModuloAcesso());
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        int i;
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(0.5f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioAcumuladoComparativoConvenio.this.panelCentro.removeAll();
                                RelatorioAcumuladoComparativoConvenio.this.panelCentro.repaint();
                                RelatorioAcumuladoComparativoConvenio.this.habilitaBotaoImprimir(true);
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                        var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                        var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                        var.put("filtroDataInicial2", this.getFiltroData("filtroDataInicial2"));
                        var.put("filtroDataFinal2", this.getFiltroData("filtroDataFinal2"));
                        buf.delete(0, buf.length());
                        if (filiais != null) {
                            for (i = 0; i < filiais.length; ++i) {
                                buf.append(filiais[i]);
                                if (i >= filiais.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroFilial", buf.toString());
                        buf.delete(0, buf.length());
                        if (convenio != null) {
                            for (i = 0; i < convenio.length; ++i) {
                                buf.append(convenio[i]);
                                if (i >= convenio.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroConvenio", buf.toString());
                        buf.delete(0, buf.length());
                        if (grupos != null) {
                            for (i = 0; i < grupos.length; ++i) {
                                buf.append(grupos[i]);
                                if (i >= grupos.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroGrupo", buf.toString());
                        buf.delete(0, buf.length());
                        if (setor != null) {
                            for (i = 0; i < setor.length; ++i) {
                                buf.append(setor[i]);
                                if (i >= setor.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroSetor", buf.toString());
                        buf.delete(0, buf.length());
                        if (coletas != null) {
                            for (i = 0; i < coletas.length; ++i) {
                                buf.append(coletas[i]);
                                if (i >= coletas.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroColeta", buf.toString());
                        buf.delete(0, buf.length());
                        if (destinos != null) {
                            for (i = 0; i < destinos.length; ++i) {
                                buf.append(destinos[i]);
                                if (i >= destinos.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroDestino", buf.toString());
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelCentro.revalidate();
                    }
                } else {
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                    this.habilitaBotaoImprimir(true);
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RelatorioAcumuladoComparativoConvenio");
        }
        Conexao.fecharStatement(st);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private StringBuilder geraCondicaoPeriodo(String filtroDataInicial, String filtroDataFinal, String tabelaRelacionada) {
        StringBuilder bufPeriodo = new StringBuilder();
        if (Funcoes.verificaData(this.getFiltroData(filtroDataInicial))) {
            bufPeriodo.append(" (").append(tabelaRelacionada).append(".req_data >= '");
            bufPeriodo.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData(filtroDataInicial)));
            bufPeriodo.append("'");
        }
        if (Funcoes.verificaData(this.getFiltroData(filtroDataFinal))) {
            bufPeriodo.append(" and ").append(tabelaRelacionada).append(".req_data <= '");
            bufPeriodo.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData(filtroDataFinal)));
            bufPeriodo.append("' )");
        }
        return bufPeriodo;
    }

    private String geraFuncaoCalculoExame(String tabelaRelacionada, String funcao) {
        return new String(funcao.concat("(").concat(tabelaRelacionada).concat(".fil_codigo, ").concat(tabelaRelacionada).concat(".con_codigo, ").concat(tabelaRelacionada).concat(".req_codigo, a.exa_codigo, a.mco_codigo, true, false, false, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, d.con_precosdiferenciados, d.con_reajuste, d.con_cobrmaterial, d.con_percpgtomaterial, d.con_percpgto, d.con_tpcalcfatu, d.con_tpcalcch, d.con_perguntarpercbalcao, d.con_acrescimo, d.con_bonus, d.tpe_codigo, d.con_acrescimoporte, d.con_acrescimouco, d.con_descontoporte, d.con_descontouco, d.con_valorch, ").concat(ParametrosGerais.getCasasPrecoExame() + "").concat(", ").concat(ParametrosGerais.getArredondamentoPrecoExame().ordinal() + "").concat(", ").concat(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").concat(", a.met_codigo").concat(")"));
    }

    private String geraFuncaoCalculoTotalExame(String tabelaRelacionada, String funcao) {
        return new String(funcao.concat("(").concat(tabelaRelacionada).concat(".fil_codigo, ").concat(tabelaRelacionada).concat(".con_codigo, ").concat(tabelaRelacionada).concat(".req_codigo, a.exa_codigo, a.mco_codigo, true, false, true, a.exr_vlrchexame, a.exr_vlrch, a.exr_valorporte, a.exr_valorcusto, a.exr_valoruco, a.exr_vlrbalcaoconvenio, a.exr_datafatura IS NOT NULL OR a.usr_codfatura IS NOT NULL, a.exr_vlrmaterial, a.exr_vlrbalcaoconvenio, d.con_precosdiferenciados, d.con_reajuste, d.con_cobrmaterial, d.con_percpgtomaterial, d.con_percpgto, d.con_tpcalcfatu, d.con_tpcalcch, d.con_perguntarpercbalcao, d.con_acrescimo, d.con_bonus, d.tpe_codigo, d.con_acrescimoporte, d.con_acrescimouco, d.con_descontoporte, d.con_descontouco, d.con_valorch, ").concat(ParametrosGerais.getCasasPrecoExame() + "").concat(", ").concat(ParametrosGerais.getArredondamentoPrecoExame().ordinal() + "").concat(", ").concat(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").concat(", a.met_codigo").concat(")"));
    }

    private BigDecimal getValorExameRealizado(BigDecimal valor) {
        BigDecimal valorExameRealizados = new BigDecimal(0);
        return valorExameRealizados.add(valor).setScale(2, RoundingMode.HALF_UP);
    }
}

