/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.gerencial;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.laboratorio.relatorios.util.RelatorioUtil;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioAcumuladoColetaExame
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_COLETA = "filtroColeta";
    private final String FILTRO_MEDICO = "filtroMedico";
    private final String FILTRO_EXAME = "filtroExame";
    private final String FILTRO_SETOR = "filtroSetor";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_HORA_INICIAL = "filtroHoraInicial";
    private final String FILTRO_HORA_FINAL = "filtroHoraFinal";
    private final String FILTRO_INTERVALO_HORA = "intervaloHora";
    public static final String PARAMETROS_RELATORIOACUMULADODESTINOEXAME = "RelatorioAcumuladoDestinoExame.ultimoFiltro";
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"qtdeRequisicoes", "qtdeExames", "codigoColeta", "descricaoColeta", "ano", "mes", "valorExame", "valorCustoSimplesExameHistorico", "valorCustoSimplesExameAtual", "mesano"});

    public RelatorioAcumuladoColetaExame() {
        this.montaBarraDescricao("Relat\u00f3rio acumulado por coleta", "Listagem dos exames acumulados por coleta", "relatorios/rel_ger_acumulado_coleta_exame.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroColeta", "Coleta", "coletas", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"col_codigo", "col_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltroAvancado("filtroMedico", "M\u00e9dico", "medico", "fil_codigo = " + Variaveis.filialPadrao, 4, new String[]{"med_conselho", "med_crm", "med_uf", "med_nome"}, new String[]{"Conselho", "N\u00famero", "UF", "Nome"}, new int[]{70, 70, 40, 0}, false, new int[]{0, 1, 2});
        this.adicionaItemFiltro("filtroExame", "Exame", "exames", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"exa_codigo", "exa_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroSetor", "Setor", "setores", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"set_codigo", "set_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroHora("filtroHoraInicial", "Hora inicial:");
        this.adicionaFiltroHora("filtroHoraFinal", "Hora final:");
        this.adicionaFiltroCheck("intervaloHora", "Intervalo de Hora", false);
        this.setModuloAcesso(RelatorioAcumuladoColetaExame.getModuloAcesso());
        this.setCamposConfigurador(campos);
        String parametros = ParametrosUsuarios.getValor(PARAMETROS_RELATORIOACUMULADODESTINOEXAME);
        if (!Funcoes.textoVazio(parametros)) {
            String tmp = StringUtil.getValor(parametros, "filial");
            if (!Funcoes.textoVazio(tmp)) {
                this.setSelecionadosFiltro("filtroFilial", 0, tmp.split(","));
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "coleta"))) {
                this.setSelecionadosFiltro("filtroColeta", 0, tmp.split(","));
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "setores"))) {
                this.setSelecionadosFiltro("filtroSetor", 0, tmp.split(","));
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "medicos"))) {
                String[] medicos = StringUtil.getValores(tmp, "medico");
                Object[] filtro = new Object[medicos.length];
                for (int i = 0; i < medicos.length; ++i) {
                    String valor;
                    String valores = medicos[i];
                    Object[] aux = new Object[4];
                    int j = 0;
                    while (!Funcoes.textoVazio(valor = StringUtil.getValor(valores, String.valueOf(j)))) {
                        aux[j++] = valor;
                    }
                    filtro[i] = aux;
                }
                this.setSelecionadosFiltroAvancado("filtroMedico", filtro);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "exame"))) {
                this.setSelecionadosFiltro("filtroExame", 0, tmp.split(","));
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "datainicial"))) {
                this.setFiltroData("filtroDataInicial", tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "datafinal"))) {
                this.setFiltroData("filtroDataFinal", tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "horainicial"))) {
                this.setFiltroData("filtroHoraInicial", tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "horafinal"))) {
                this.setFiltroData("filtroHoraFinal", tmp);
            }
            if (!Funcoes.textoVazio(tmp = StringUtil.getValor(parametros, "intervaloHora"))) {
                this.setFiltroCheck("intervaloHora", tmp.equalsIgnoreCase("true"));
            }
        }
    }

    @Override
    public void imprimirPressionado() {
        boolean horaInicial = Funcoes.textoVazio(this.getFiltroHora("filtroHoraInicial"));
        boolean intervaloHora = this.getFiltroCheck("intervaloHora");
        if (intervaloHora && horaInicial) {
            Funcoes.mensagem(this, "O campo Hora deve ser preenchido.", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        Statement st = Conexao.getStatement();
        Statement stTemp = Conexao.getStatement();
        try {
            String[] setor;
            String[] exame;
            String[] filiais;
            StringBuilder buf = new StringBuilder();
            buf.append(" select ");
            buf.append(" count(distinct a.req_codigo) as qtdeRequisicoes, count(b.exa_codigo) as qtdeExames, ");
            buf.append("a.fil_codigo, a.col_codigo as codigoColeta, c.col_descricao as descricaoColeta, ");
            buf.append(" extract(year from a.req_data) as ano, extract(month from a.req_data) as mes, '' as mesano, ");
            buf.append("sum(calculaprecototalexamerequisicao(a.fil_codigo, a.con_codigo, a.req_codigo, b.exa_codigo, b.mco_codigo, true, false, false, b.exr_vlrchexame, b.exr_vlrch, b.exr_valorporte, b.exr_valorcusto, b.exr_valoruco, b.exr_vlrbalcaoconvenio, b.exr_datafatura IS NOT NULL OR b.usr_codfatura IS NOT NULL, b.exr_vlrmaterial, b.exr_vlrbalcaoconvenio, e.con_precosdiferenciados, e.con_reajuste, e.con_cobrmaterial, e.con_percpgtomaterial, e.con_percpgto, e.con_tpcalcfatu, e.con_tpcalcch, e.con_perguntarpercbalcao, e.con_acrescimo, e.con_bonus, e.tpe_codigo, e.con_acrescimoporte, e.con_acrescimouco, e.con_descontoporte, e.con_descontouco, e.con_valorch, ").append(ParametrosGerais.getCasasPrecoExame()).append(", ").append(ParametrosGerais.getArredondamentoPrecoExame().ordinal()).append(", ").append(ParametrosGerais.getPrecoMetodologia() ? "true" : "false").append(", b.met_codigo").append(")) as valorExame ");
            buf.append(" ,sum(b.exr_custosimples) AS valorCustoSimplesExameHistorico, ");
            buf.append(" sum(examatcol.emc_custosimples) AS valorCustoSimplesExameAtual\t ");
            if (this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
                buf.append(", ").append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            }
            buf.append(" from ");
            buf.append(" requisicao a ");
            buf.append(" left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            buf.append(" left join examematcoleta examatcol on b.fil_codigo = examatcol.fil_codigo and b.exa_codigo = examatcol.exa_codigo and b.mco_codigo = examatcol.mco_codigo ");
            buf.append(" left join examesetor d on b.fil_codigo = d.fil_codigo and b.exa_codigo = d.exa_codigo and d.ese_default = true ");
            buf.append(" left join coletas c on a.fil_codigo = c.fil_codigo and a.col_codigo = c.col_codigo ");
            buf.append(" left join convenios e on b.fil_codigo = e.fil_codigo and a.con_codigo = e.con_codigo ");
            if (this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            }
            if ((filiais = this.getSelecionadosFiltro("filtroFilial", 0)) == null) {
                filiais = new String[]{Variaveis.filialPadrao};
            }
            buf.append("where a.fil_codigo in (");
            for (int i = 0; i < filiais.length; ++i) {
                buf.append(filiais[i]);
                if (i >= filiais.length - 1) continue;
                buf.append(", ");
            }
            buf.append(") ");
            String[] coleta = this.getSelecionadosFiltro("filtroColeta", 0);
            if (coleta != null) {
                buf.append(" and a.col_codigo in (");
                for (int i = 0; i < coleta.length; ++i) {
                    buf.append("'");
                    buf.append(coleta[i]);
                    buf.append("'");
                    if (i >= coleta.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            String[] conselho = this.getSelecionadosFiltroAvancado("filtroMedico", 0);
            String[] crm = this.getSelecionadosFiltroAvancado("filtroMedico", 1);
            String[] uf = this.getSelecionadosFiltroAvancado("filtroMedico", 2);
            if (conselho != null && crm != null && uf != null && crm.length <= ParametrosGerais.getQuantidadeMaximoFiltroAvancado()) {
                buf.append(" and (");
                for (int i = 0; i < crm.length; ++i) {
                    buf.append("(a.med_conselho = '");
                    buf.append(conselho[i]);
                    buf.append("' and a.med_crm = '");
                    buf.append(crm[i]);
                    buf.append("' and a.med_uf = '");
                    buf.append(uf[i]);
                    buf.append("')");
                    if (i >= crm.length - 1) continue;
                    buf.append(" or ");
                }
                buf.append(")");
            }
            if ((exame = this.getSelecionadosFiltro("filtroExame", 0)) != null) {
                buf.append(" and b.exa_codigo in (");
                for (int i = 0; i < exame.length; ++i) {
                    buf.append("'");
                    buf.append(exame[i]);
                    buf.append("'");
                    if (i >= exame.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((setor = this.getSelecionadosFiltro("filtroSetor", 0)) != null) {
                buf.append(" and d.set_codigo in (");
                for (int i = 0; i < setor.length; ++i) {
                    buf.append(setor[i]);
                    if (i >= setor.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if (this.getFiltroCheck("intervaloHora")) {
                if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial")) && Funcoes.verificaHora(this.getFiltroHora("filtroHoraInicial"))) {
                    buf.append(" and date_trunc('minute', a.req_data + a.req_hora) >= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial"))).append(" ").append(this.getFiltroHora("filtroHoraInicial"));
                    buf.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal")) && Funcoes.verificaHora(this.getFiltroHora("filtroHoraFinal"))) {
                    buf.append(" and date_trunc('minute', a.req_data + a.req_hora) <= '");
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataFinal"))).append(" ").append(this.getFiltroHora("filtroHoraFinal"));
                    buf.append("'");
                }
            } else {
                if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                    buf.append(" and a.req_data >= '");
                    buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial")));
                    buf.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                    buf.append(" and a.req_data <= '");
                    buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal")));
                    buf.append("'");
                }
                if (Funcoes.verificaHora(this.getFiltroHora("filtroHoraInicial"))) {
                    buf.append(" and a.req_hora >= '");
                    buf.append(this.getFiltroHora("filtroHoraInicial"));
                    buf.append("'");
                }
                if (Funcoes.verificaHora(this.getFiltroHora("filtroHoraFinal"))) {
                    buf.append(" and a.req_hora <= '");
                    buf.append(this.getFiltroHora("filtroHoraFinal"));
                    buf.append("'");
                }
            }
            buf.append(" and a.req_excluida = false and b.exr_excluido = false ");
            buf.append(" group by ");
            buf.append(" a.col_codigo, c.col_descricao, ano, mes ");
            buf.append(", a.fil_codigo ");
            if (this.getSelecionadosFiltro("filtroFilial", 0) == null || this.getSelecionadosFiltro("filtroFilial", 0).length <= 1) {
                for (String s : Constantes.CAMPOS_FILIAL) {
                    buf.append(", ").append(s);
                }
            }
            buf.append(" order by a.fil_codigo, a.col_codigo, ano, mes");
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                ModeloGridTable modelo = new ModeloGridTable(campos);
                do {
                    Object[] o = new Object[campos.length];
                    for (int i = 0; i < campos.length; ++i) {
                        if (RelatorioUtil.possuiColuna(rs, campos[i]) <= -1) continue;
                        o[i] = campos[i].equalsIgnoreCase("mesano") ? Funcoes.preencheZero(rs.getInt("mes"), 2) + "/" + rs.getString("ano") : rs.getObject(campos[i]);
                    }
                    modelo.addLine(o);
                } while (rs.next());
                String codigoFilial = Variaveis.filialPadrao;
                if (this.getSelecionadosFiltro("filtroFilial", 0) != null && this.getSelecionadosFiltro("filtroFilial", 0).length == 1) {
                    codigoFilial = this.getSelecionadosFiltro("filtroFilial", 0)[0];
                }
                Registro regFilial = RelatorioUtil.pegaDadosFilial(st, codigoFilial);
                RelatorioUtil.preencheDadosFilial(regFilial, modelo);
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioAcumuladoColetaExame.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next() && modelo.getRowCount() > 0) {
                    int i;
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioAcumuladoColetaExame.this.panelCentro.removeAll();
                            RelatorioAcumuladoColetaExame.this.panelCentro.repaint();
                            RelatorioAcumuladoColetaExame.this.habilitaBotaoImprimir(true);
                        }
                    });
                    StringBuilder p = new StringBuilder();
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                    var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                    var.put("filtroHoraInicial", this.getFiltroHora("filtroHoraInicial"));
                    var.put("filtroHoraFinal", this.getFiltroHora("filtroHoraFinal"));
                    p.append("<datainicial>").append(this.getFiltroData("filtroDataInicial")).append("</datainicial>");
                    p.append("<datafinal>").append(this.getFiltroData("filtroDataFinal")).append("</datafinal>");
                    p.append("<horainicial>").append(this.getFiltroHora("filtroHoraInicial")).append("</horainicial>");
                    p.append("<horafinal>").append(this.getFiltroHora("filtroHoraFinal")).append("</horafinal>");
                    buf.delete(0, buf.length());
                    if (filiais != null) {
                        p.append("<filial>");
                        for (i = 0; i < filiais.length; ++i) {
                            buf.append(filiais[i]);
                            if (i >= filiais.length - 1) continue;
                            buf.append(",");
                        }
                        p.append(buf.toString());
                        p.append("</filial>");
                    }
                    var.put("filtroFilial", buf.toString());
                    buf.delete(0, buf.length());
                    if (coleta != null) {
                        p.append("<coleta>");
                        for (i = 0; i < coleta.length; ++i) {
                            buf.append(coleta[i]);
                            if (i >= coleta.length - 1) continue;
                            buf.append(",");
                        }
                        p.append(buf.toString());
                        p.append("</coleta>");
                    }
                    var.put("filtroColeta", buf.toString());
                    buf.delete(0, buf.length());
                    if (crm != null) {
                        p.append("<medicos>");
                        Object[] valores = this.getSelecionadosFiltroAvancado("filtroMedico");
                        for (int i2 = 0; i2 < valores.length; ++i2) {
                            p.append("<medico>");
                            Object[] valor = (Object[])valores[i2];
                            for (int j = 0; j < valor.length; ++j) {
                                p.append("<").append(j).append(">");
                                p.append(valor[j]);
                                p.append("</").append(j).append(">");
                            }
                            p.append("</medico>");
                            buf.append(valor[1]);
                        }
                        p.append("</medicos>");
                    }
                    var.put("filtroMedico", crm);
                    buf.delete(0, buf.length());
                    if (exame != null) {
                        p.append("<exame>");
                        for (int i3 = 0; i3 < exame.length; ++i3) {
                            buf.append(exame[i3]);
                            if (i3 >= exame.length - 1) continue;
                            buf.append(",");
                        }
                        p.append(buf.toString());
                        p.append("</exame>");
                    }
                    var.put("filtroExame", buf.toString());
                    buf.delete(0, buf.length());
                    if (setor != null) {
                        p.append("<setor>");
                        for (int i4 = 0; i4 < setor.length; ++i4) {
                            buf.append(setor[i4]);
                            if (i4 >= setor.length - 1) continue;
                            buf.append(",");
                        }
                        p.append(buf.toString());
                        p.append("</setor>");
                    }
                    var.put("filtroSetor", buf.toString());
                    ParametrosUsuarios.setValor(PARAMETROS_RELATORIOACUMULADODESTINOEXAME, p.toString());
                    ParametrosUsuarios.salvarParametros(true);
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                } else if (modelo.getRowCount() == 0) {
                    Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
            Conexao.fecharStatement(st);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0880300400");
    }

    private long getModuloConfigurar() {
        return Long.parseLong("0880300401");
    }
}

