/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.movimento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioSaldoReceberPagar
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String[] ordem = new String[]{"C\u00f3digo", "Data + Hora", "Usu\u00e1rio", "Vencimento", "Docto"};
    private final String[] situacao = new String[]{"Todas", Tipos.tipoSituacaoReceberPagar("A"), Tipos.tipoSituacaoReceberPagar("Q"), Tipos.tipoSituacaoReceberPagar("A") + " e " + Tipos.tipoSituacaoReceberPagar("Q"), Tipos.tipoSituacaoReceberPagar("V"), Tipos.tipoSituacaoReceberPagar("T"), Tipos.tipoSituacaoReceberPagar("S")};
    private final String[] tipo = new String[]{"Todos", Tipos.tipoReceberPagar("P"), Tipos.tipoReceberPagar("R")};
    private final String[] tipoCadastro = new String[]{"Todos", Tipos.tipoCadastro("U"), Tipos.tipoCadastro("F"), Tipos.tipoCadastro("C"), Tipos.tipoCadastro("R"), Tipos.tipoCadastro("P"), Tipos.tipoCadastro("O")};
    private final String[] tipoDocumento = new String[]{"Todos", Tipos.tipoDocumento("B"), Tipos.tipoDocumento("D"), Tipos.tipoDocumento("C"), Tipos.tipoDocumento("A")};
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_USUARIO = "filtroUsuario";
    private final String FILTRO_SERIE = "filtroSerie";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_CAMPO_DATA = "filtroCampoData";
    private final String FILTRO_SITUACAO = "filtroSituacao";
    private final String FILTRO_TIPO_CADASTRO = "filtroTipoCadastro";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String FILTRO_TIPO = "filtroTipo";
    private final String FILTRO_TIPO_DOCUMENTO = "filtroTipoDocumento";
    private final String FILTRO_NUMERO_DOCUMENTO = "filtroNumeroDocumento";
    private final String FILTRO_VALOR_INICIAL = "filtroValorInicial";
    private final String FILTRO_VALOR_FINAL = "filtroValorFinal";
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_ENTIDADE = "filtroEntidade";
    private final String FILTRO_PACIENTE = "filtroPaciente";
    private final String[] CAMPOS_DATA = new String[]{"Compet\u00eancia", "Vencimento", "Cadastro"};
    private static final String[] camposCadastros = new String[]{"codigoCadastro", "fantasiaCadastro", "nomeSocialPaciente", "razaoSocialCadastro", "foneCadastro", "enderecoCadastro", "numeroEnderecoCadastro", "tipoLogradouroCadastro", "faxCadastro", "complementoCadastro", "cepCadastro", "codigoCidadeCadastro", "nomeCidadeCadastro"};
    private static final String[] camposRelatorio = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoReceberPagar", "dataHoraReceberPagar", "dataVencimentoReceberPagar", "valorReceberPagar", "tipoJurosReceberPagar", "tipoReceberPagar", "tipoDocumentoReceberPagar", "numeroDocumentoReceberPagar", "taxaReceberPagar", "numeroParcelaReceberPagar", "codigoDocumentoReceberPagar", "dataDocumentoReceberPagar", "dataProcessamentoReceberPagar", "observacaoReceberPagar", "tipoCadastroReceberPagar", "codigoUsuarioReceberPagar", "nomeUsuarioReceberPagar", "codigoUsuarioCancelamentoReceberPagar", "nomeUsuarioCancelamentoReceberPagar", "dataCancelamentoReceberPagar", "situacaoReceberPagar", "valorJuroReceberPagar", "valorMultaReceberPagar", "valorComTaxaReceberPagar", "valorAcrescimoReceberPagar", "valorDescontoReceberPagar", "percentualMultaReceberPagar", "percentualJuroReceberPagar", "percentualAcrescimoReceberPagar", "percentualAcrescimoReceberPagar", "codigoSerie", "descricaoSerie", "valorIrrfReceberPagar", "percentualIrrfReceberPagar", "valorIssReceberPagar", "percentualIssReceberPagar", "valorPisReceberPagar", "percentualPisReceberPagar", "valorCsllReceberPagar", "percentualCsllReceberPagar", "valorCofinsReceberPagar", "percentualCofinsReceberPagar", "valorInssReceberPagar", "percentualInssReceberPagar", "totalReceber", "saldoCredor", "totalPagar", "saldoDevedor", "auxSaldoCredor", "auxSaldoDevedor", "valorImpostos", "dataCompetenciaReceberPagar", "auxImpostosTaxasReceber", "auxImpostosTaxasPagar", "auxValorReceber", "auxValorPagar", "auxDescontoReceber", "auxDescontoPagar", "auxTotalReceber", "auxTotalPagar", "auxImpostosTaxas", "auxValor", "auxDesconto", "auxTotal", "valorTotalReceberPagar"});
    protected static final String[] campos = ArraysUtil.concatenar(camposRelatorio, camposCadastros);

    public RelatorioSaldoReceberPagar() {
        this.montaBarraDescricao("Relat\u00f3rio de Saldo Receber/Pagar", "Listagem da movimenta\u00e7\u00e3o de contas a receber/pagar de clientes", "relatorios/saldo_rec_pag.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroUsuario", "Usu\u00e1rio", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Nome Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroEntidade", "Entidade", "entidade", "fil_codigo = " + Variaveis.filialPadrao + " and ent_inativo = false", 1, new String[]{"ent_codigo", "ent_razaosocial"}, new String[]{"C\u00f3digo", "Raz\u00e3o Social"}, new int[]{70, 0});
        if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A") || Variaveis.tipoFilialPadrao.equalsIgnoreCase("V")) {
            this.adicionaItemFiltroAvancado("filtroPaciente", "Paciente", "paciente", "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"pac_codigo", "pac_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0}, false, new int[]{70, 0});
        } else {
            this.adicionaItemFiltroAvancado("filtroPaciente", "Paciente", "paciente", "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"pac_codigo", "pac_nome", "pac_nomesocial"}, new String[]{"C\u00f3digo", "Nome", "Nome Social"}, new int[]{70, 0, 0}, false, new int[]{70, 0, 0});
        }
        this.adicionaItemFiltro("filtroSerie", "S\u00e9rie", "series", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"ser_codigo", "ser_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroCombo("filtroCampoData", "Campo Data", this.CAMPOS_DATA, 0);
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroTexto("filtroNumeroDocumento", "N\u00famero Doc:", 0);
        this.adicionaFiltroDecimal("filtroValorInicial", "Valor Inicial:", 0);
        this.adicionaFiltroDecimal("filtroValorFinal", "Valor Final:", 0);
        this.adicionaFiltroCombo("filtroTipoCadastro", "Cadastro:", this.tipoCadastro, 0);
        this.adicionaFiltroCombo("filtroTipo", "Tipo:", this.tipo, 0);
        this.adicionaFiltroCombo("filtroSituacao", "Situa\u00e7\u00e3o:", this.situacao, 0);
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.adicionaFiltroCombo("filtroTipoDocumento", "Tipo Doc:", this.tipoDocumento, 0);
        this.setModuloConfigurar(Long.parseLong("0851000101"));
        this.setModuloAcesso(RelatorioSaldoReceberPagar.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement st2;
        Statement st;
        block123: {
            String[] filiais;
            Float auxImpostosTaxasReceber;
            Float auxImpostosTaxasPagar;
            Float auxValorReceber;
            Float auxValorPagar;
            Float auxDescontoReceber;
            Float auxDescontoPagar;
            Float auxTotalReceber;
            Float auxTotalPagar;
            block122: {
                block121: {
                    st = Conexao.getStatement();
                    st2 = Conexao.getStatement();
                    auxTotalReceber = auxTotalPagar = Float.valueOf(0.0f);
                    auxDescontoPagar = auxTotalPagar;
                    auxDescontoReceber = auxTotalPagar;
                    auxValorPagar = auxTotalPagar;
                    auxValorReceber = auxTotalPagar;
                    auxImpostosTaxasPagar = auxTotalPagar;
                    auxImpostosTaxasReceber = auxTotalPagar;
                    String[] cliente = this.getSelecionadosFiltro("filtroConvenio", 0);
                    if (cliente == null) {
                        cliente = this.getSelecionadosFiltro("filtroEntidade", 0);
                    } else if (this.getSelecionadosFiltro("filtroEntidade", 0) != null) {
                        cliente = ArraysUtil.concatenar(cliente, this.getSelecionadosFiltro("filtroEntidade", 0));
                    }
                    if (cliente == null) {
                        cliente = this.getSelecionadosFiltroAvancado("filtroPaciente", 0);
                    } else if (this.getSelecionadosFiltroAvancado("filtroPaciente", 0) != null) {
                        cliente = ArraysUtil.concatenar(cliente, this.getSelecionadosFiltroAvancado("filtroPaciente", 0));
                    }
                    filiais = this.getSelecionadosFiltro("filtroFilial", 0);
                    if (cliente != null) break block121;
                    Funcoes.mensagem(this, "Selecione um(a) paciente/convenio/entidade.", 2);
                    this.habilitaBotaoImprimir(true);
                    Conexao.fecharStatement(st, st2);
                    return;
                }
                if (filiais == null || filiais.length <= 1) break block122;
                Funcoes.mensagem(this, "Apenas uma filial deve ser selecionada para o relat\u00f3rio", 2);
                this.habilitaBotaoImprimir(true);
                Conexao.fecharStatement(st, st2);
                return;
            }
            try {
                ResultSet rs;
                String[] paciente;
                String[] entidade;
                this.setCursor(Cursor.getPredefinedCursor(3));
                StringBuilder buf = new StringBuilder();
                StringBuilder selectSaldoAnt = new StringBuilder();
                selectSaldoAnt.append(" select SUM(case when a.rpg_tipo = 'R' then ");
                selectSaldoAnt.append("                 a.rpg_valortotal ");
                selectSaldoAnt.append("            end) as totalReceber ");
                selectSaldoAnt.append("       ,SUM(case when a.rpg_situacao = 'A' then ");
                selectSaldoAnt.append("                 case when a.rpg_tipo = 'R' then ");
                selectSaldoAnt.append("                      a.rpg_valortotal ");
                selectSaldoAnt.append("                 end ");
                selectSaldoAnt.append("            end) as saldoDevedor ");
                selectSaldoAnt.append("       ,SUM(case when a.rpg_tipo = 'P' then ");
                selectSaldoAnt.append("                 a.rpg_valortotal ");
                selectSaldoAnt.append("            end) as totalPagar ");
                selectSaldoAnt.append("       ,SUM(case when a.rpg_situacao = 'A' then ");
                selectSaldoAnt.append("                 case when a.rpg_tipo = 'P' then ");
                selectSaldoAnt.append("                      a.rpg_valortotal ");
                selectSaldoAnt.append("                 end ");
                selectSaldoAnt.append("            end) as saldoCredor ");
                selectSaldoAnt.append("  from receberpagar a ");
                selectSaldoAnt.append(" where a.rpg_situacao IN ('").append("A").append("', '");
                selectSaldoAnt.append("Q").append("', '");
                selectSaldoAnt.append("V").append("', '");
                selectSaldoAnt.append("T").append("', '");
                selectSaldoAnt.append("S").append("') ");
                StringBuilder auxSelect = new StringBuilder();
                float auxSaldoDevedor = 0.0f;
                float auxSaldoCredor = 0.0f;
                float saldoCredor = 0.0f;
                float totalPagar = 0.0f;
                float saldoDevedor = 0.0f;
                float totalReceber = 0.0f;
                buf.append("select ");
                buf.append("a.rpg_codigo as codigoReceberPagar, a.rpg_datahora as dataHoraReceberPagar, a.rpg_vencimento as dataVencimentoReceberPagar, a.rpg_competencia as dataCompetenciaReceberPagar, ");
                buf.append("a.rpg_valor as valorReceberPagar, a.rpg_tipojuros as tipoJurosReceberPagar, a.rpg_tipo as tipoReceberPagar, ");
                buf.append("a.rpg_tipodocumento as tipoDocumentoReceberPagar, a.rpg_numerodocumento as numeroDocumentoReceberPagar, a.rpg_taxa as taxaReceberPagar, ");
                buf.append("a.rpg_parcela as numeroParcelaReceberPagar, a.rpg_codigodocumento as codigoDocumentoReceberPagar, a.rpg_datadocumento as dataDocumentoReceberPagar, ");
                buf.append("a.rpg_dataprocessamento as dataProcessamentoReceberPagar, a.rpg_obs as observacaoReceberPagar, a.rpg_tipocadastro as tipoCadastroReceberPagar, ");
                buf.append("usrrecpag.usr_codigo as codigoUsuarioReceberPagar, usrrecpag.usr_nome as nomeUsuarioReceberPagar, ");
                buf.append("usuariocancela.usr_codigo as codigoUsuarioCancelamentoReceberPagar, usuariocancela.usr_nome as nomeUsuarioCancelamentoReceberPagar, ");
                buf.append("a.rpg_datacancelado as dataCancelamentoReceberPagar, a.rpg_situacao as situacaoReceberPagar, ");
                buf.append("a.rpg_valor + a.rpg_taxa as valorComTaxaReceberPagar, ");
                buf.append("a.rpg_valorjuro as valorJuroReceberPagar, a.rpg_valormulta as valorMultaReceberPagar, ");
                buf.append("a.rpg_valoracrescimo as valorAcrescimoReceberPagar, a.rpg_valordesconto as valorDescontoReceberPagar, ");
                buf.append("a.rpg_percentualmulta as percentualMultaReceberPagar, a.rpg_percentualjuro as percentualJuroReceberPagar, ");
                buf.append("a.rpg_percentualacrescimo as percentualAcrescimoReceberPagar, a.rpg_percentualdesconto as percentualDescontoReceberPagar, ");
                buf.append("a.rpg_irrfvalor as valorIrrfReceberPagar, a.rpg_irrfpercentual as percentualIrrfReceberPagar, ");
                buf.append("a.rpg_issvalor as valorIssReceberPagar, a.rpg_isspercentual as percentualIssReceberPagar, ");
                buf.append("a.rpg_pisvalor as valorPisReceberPagar, a.rpg_pispercentual as percentualPisReceberPagar, ");
                buf.append("a.rpg_csllvalor as valorCsllReceberPagar, a.rpg_csllpercentual as percentualCsllReceberPagar, ");
                buf.append("a.rpg_cofinsvalor as valorCofinsReceberPagar, a.rpg_cofinspercentual as percentualCofinsReceberPagar, ");
                buf.append("a.rpg_inssvalor as valorInssReceberPagar, a.rpg_insspercentual as percentualInssReceberPagar, ");
                buf.append("a.rpg_valortotal as valorTotalReceberPagar, ");
                buf.append("a.ser_codigo as codigoSerie, s.ser_descricao as descricaoSerie, ");
                buf.append("case when nfi.valorImpostos is null then 0 else nfi.valorImpostos end as valorImpostos, ");
                auxSelect.append("case ");
                auxSelect.append("  when a.rpg_tipocadastro = 'O' then a.con_codigo ");
                auxSelect.append("  when a.rpg_tipocadastro = 'P' then a.pac_codigo ");
                auxSelect.append("  when a.rpg_tipocadastro = 'U' then a.ent_codigo ");
                auxSelect.append("  when a.rpg_tipocadastro = 'F' then a.ent_codigo ");
                auxSelect.append("  when a.rpg_tipocadastro = 'C' then a.ent_codigo ");
                auxSelect.append("  when a.rpg_tipocadastro = 'R' then a.ent_codigo ");
                auxSelect.append("  else a.ent_codigo ");
                auxSelect.append("end as codigoCadastro ");
                buf.append((CharSequence)auxSelect);
                buf.append(", filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                buf.append("from receberpagar a ");
                buf.append("left join usuario usuariocancela on a.usr_codcancelado = usuariocancela.usr_codigo ");
                buf.append("left join usuario usrrecpag on a.usr_codigo = usrrecpag.usr_codigo ");
                buf.append("left join series s on a.fil_codigo = s.fil_codigo and a.ser_codigo = s.ser_codigo ");
                buf.append("left outer join (select SUM(nfi.nfi_irrfvalor + nfi.nfi_issvalor    + nfi.nfi_pisvalor + ");
                buf.append("                            nfi.nfi_csllvalor + nfi.nfi_cofinsvalor + nfi.nfi_inssvalor) as valorimpostos ");
                buf.append("                       ,nfi.nfi_codigo ");
                buf.append("                       ,nfi.fil_codigo ");
                buf.append("                   from notafiscal nfi ");
                buf.append("                  group by nfi.nfi_codigo ");
                buf.append("                          ,nfi.fil_codigo) nfi on (a.nfi_codigo = nfi.nfi_codigo and a.fil_codigo = nfi.fil_codigo) ");
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                buf.append("where a.fil_codigo ");
                selectSaldoAnt.append(" and a.fil_codigo ");
                auxSelect.delete(0, auxSelect.length());
                if (filiais == null || filiais.length == 0) {
                    auxSelect.append(" = " + Variaveis.filialPadrao);
                } else {
                    auxSelect.append(" in (");
                    for (int i = 0; i < filiais.length; ++i) {
                        auxSelect.append(filiais[i]);
                        if (i >= filiais.length - 1) continue;
                        auxSelect.append(", ");
                    }
                    auxSelect.append(")");
                }
                buf.append((CharSequence)auxSelect);
                selectSaldoAnt.append((CharSequence)auxSelect);
                String[] usuario = this.getSelecionadosFiltro("filtroUsuario", 0);
                auxSelect.delete(0, auxSelect.length());
                if (usuario != null) {
                    auxSelect.append(" and a.usr_codigo in (");
                    for (int i = 0; i < usuario.length; ++i) {
                        auxSelect.append("'");
                        auxSelect.append(usuario[i]);
                        auxSelect.append("'");
                        if (i >= usuario.length - 1) continue;
                        auxSelect.append(", ");
                    }
                    auxSelect.append(")");
                }
                buf.append((CharSequence)auxSelect);
                String[] convenio = this.getSelecionadosFiltro("filtroConvenio", 0);
                auxSelect.delete(0, auxSelect.length());
                if (convenio != null) {
                    auxSelect.append(" a.con_codigo in (");
                    for (int i = 0; i < convenio.length; ++i) {
                        auxSelect.append("'");
                        auxSelect.append(convenio[i]);
                        auxSelect.append("'");
                        if (i >= convenio.length - 1) continue;
                        auxSelect.append(", ");
                    }
                    auxSelect.append(")");
                }
                if ((entidade = this.getSelecionadosFiltro("filtroEntidade", 0)) != null) {
                    if (convenio != null) {
                        auxSelect.append(" or ");
                    }
                    auxSelect.append(" a.ent_codigo in (");
                    for (int i = 0; i < entidade.length; ++i) {
                        auxSelect.append("'");
                        auxSelect.append(entidade[i]);
                        auxSelect.append("'");
                        if (i >= entidade.length - 1) continue;
                        auxSelect.append(", ");
                    }
                    auxSelect.append(")");
                }
                if ((paciente = this.getSelecionadosFiltroAvancado("filtroPaciente", 0)) != null) {
                    if (convenio != null || entidade != null) {
                        auxSelect.append(" or ");
                    }
                    auxSelect.append(" a.pac_codigo in (");
                    for (int i = 0; i < paciente.length; ++i) {
                        auxSelect.append(paciente[i]);
                        if (i >= paciente.length - 1) continue;
                        auxSelect.append(", ");
                    }
                    auxSelect.append(")");
                }
                auxSelect.insert(0, " and (");
                auxSelect.append(")");
                selectSaldoAnt.append((CharSequence)auxSelect);
                buf.append((CharSequence)auxSelect);
                String[] serie = this.getSelecionadosFiltro("filtroSerie", 0);
                auxSelect.delete(0, auxSelect.length());
                if (serie != null) {
                    auxSelect.append(" and a.ser_codigo in (");
                    for (int i = 0; i < serie.length; ++i) {
                        auxSelect.append("'");
                        auxSelect.append(serie[i]);
                        auxSelect.append("'");
                        if (i >= serie.length - 1) continue;
                        auxSelect.append(", ");
                    }
                    auxSelect.append(")");
                }
                buf.append((CharSequence)auxSelect);
                auxSelect.delete(0, auxSelect.length());
                if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                    if (this.getFiltroCombo("filtroCampoData") == "Compet\u00eancia") {
                        auxSelect.append(" and cast(a.rpg_competencia as date) >= '");
                    } else if (this.getFiltroCombo("filtroCampoData") == "Vencimento") {
                        auxSelect.append(" and cast(a.rpg_vencimento as date) >= '");
                    } else {
                        auxSelect.append(" and cast(a.rpg_datahora as date) >= '");
                    }
                    auxSelect.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial")));
                    auxSelect.append("'");
                }
                buf.append((CharSequence)auxSelect);
                if (auxSelect.length() != 0) {
                    selectSaldoAnt.append((CharSequence)auxSelect.replace(auxSelect.indexOf(">="), auxSelect.indexOf(">=") + 3, "<"));
                } else {
                    selectSaldoAnt.append(" and 1=-1 ");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                    if (this.getFiltroCombo("filtroCampoData") == "Compet\u00eancia") {
                        buf.append(" and cast(a.rpg_competencia as date) <= '");
                    } else if (this.getFiltroCombo("filtroCampoData") == "Vencimento") {
                        buf.append(" and cast(a.rpg_vencimento as date) <= '");
                    } else {
                        buf.append(" and cast(a.rpg_datahora as date) <= '");
                    }
                    buf.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataFinal")));
                    buf.append("'");
                }
                auxSelect.delete(0, auxSelect.length());
                if (!this.getFiltroCombo("filtroTipo").equals(this.tipo[0])) {
                    if (this.getFiltroCombo("filtroTipo").equals(this.tipo[1])) {
                        auxSelect.append(" and a.rpg_tipo = 'P' ");
                    } else {
                        auxSelect.append(" and a.rpg_tipo = 'R' ");
                    }
                }
                buf.append((CharSequence)auxSelect);
                auxSelect.delete(0, auxSelect.length());
                if (this.getFiltroCombo("filtroSituacao").equals(this.situacao[0])) {
                    auxSelect.append(" and a.rpg_situacao IN ('").append("A").append("', '");
                    auxSelect.append("Q").append("', '");
                    auxSelect.append("V").append("', '");
                    auxSelect.append("T").append("', '");
                    auxSelect.append("S").append("') ");
                } else if (this.getFiltroCombo("filtroSituacao").equals(this.situacao[1])) {
                    auxSelect.append(" and a.rpg_situacao = '").append("A").append("' ");
                } else if (this.getFiltroCombo("filtroSituacao").equals(this.situacao[2])) {
                    auxSelect.append(" and a.rpg_situacao = '").append("Q").append("' ");
                } else if (this.getFiltroCombo("filtroSituacao").equals(this.situacao[3])) {
                    auxSelect.append(" and a.rpg_situacao IN ('").append("A").append("', '");
                    auxSelect.append("Q").append("') ");
                } else if (this.getFiltroCombo("filtroSituacao").equals(this.situacao[4])) {
                    auxSelect.append(" and a.rpg_situacao = '").append("V").append("' ");
                } else if (this.getFiltroCombo("filtroSituacao").equals(this.situacao[5])) {
                    auxSelect.append(" and a.rpg_situacao = '").append("T").append("' ");
                } else if (this.getFiltroCombo("filtroSituacao").equals(this.situacao[6])) {
                    auxSelect.append(" and a.rpg_situacao = '").append("S").append("' ");
                }
                buf.append((CharSequence)auxSelect);
                auxSelect.delete(0, auxSelect.length());
                if (this.getFiltroCombo("filtroTipoCadastro").equals(this.tipoCadastro[1])) {
                    auxSelect.append(" and a.rpg_tipocadastro = 'U' ");
                } else if (this.getFiltroCombo("filtroTipoCadastro").equals(this.tipoCadastro[2])) {
                    auxSelect.append(" and a.rpg_tipocadastro = 'F' ");
                } else if (this.getFiltroCombo("filtroTipoCadastro").equals(this.tipoCadastro[3])) {
                    auxSelect.append(" and a.rpg_tipocadastro = 'C' ");
                } else if (this.getFiltroCombo("filtroTipoCadastro").equals(this.tipoCadastro[4])) {
                    auxSelect.append(" and a.rpg_tipocadastro = 'R' ");
                } else if (this.getFiltroCombo("filtroTipoCadastro").equals(this.tipoCadastro[5])) {
                    auxSelect.append(" and a.rpg_tipocadastro = 'P' ");
                } else if (this.getFiltroCombo("filtroTipoCadastro").equals(this.tipoCadastro[6])) {
                    auxSelect.append(" and a.rpg_tipocadastro = 'O' ");
                }
                buf.append((CharSequence)auxSelect);
                auxSelect.delete(0, auxSelect.length());
                if (!this.getFiltroCombo("filtroTipoDocumento").equals(this.tipoDocumento[0])) {
                    if (this.getFiltroCombo("filtroTipoDocumento").equals(this.tipoDocumento[1])) {
                        auxSelect.append(" and a.rpg_tipodocumento = 'B' ");
                    } else if (this.getFiltroCombo("filtroTipoDocumento").equals(this.tipoDocumento[2])) {
                        auxSelect.append(" and a.rpg_tipodocumento = 'D' ");
                    } else if (this.getFiltroCombo("filtroTipoDocumento").equals(this.tipoDocumento[4])) {
                        auxSelect.append(" and a.rpg_tipodocumento = 'A' ");
                    } else {
                        auxSelect.append(" and a.rpg_tipodocumento = 'C' ");
                    }
                }
                buf.append((CharSequence)auxSelect);
                auxSelect.delete(0, auxSelect.length());
                if (!this.getFiltroTexto("filtroNumeroDocumento").isEmpty()) {
                    auxSelect.append(" and a.rpg_numerodocumento ILIKE '%" + this.getFiltroTexto("filtroNumeroDocumento") + "%' ");
                    buf.append((CharSequence)auxSelect);
                    selectSaldoAnt.append((CharSequence)auxSelect);
                }
                auxSelect.delete(0, auxSelect.length());
                if (!Funcoes.textoVazio(this.getFiltroDecimal("filtroValorInicial"))) {
                    auxSelect.append(" and a.rpg_valor >= " + this.getFiltroTexto("filtroValorInicial") + " ");
                    buf.append((CharSequence)auxSelect);
                }
                auxSelect.delete(0, auxSelect.length());
                if (!Funcoes.textoVazio(this.getFiltroDecimal("filtroValorFinal"))) {
                    auxSelect.append(" and a.rpg_valor <= " + this.getFiltroTexto("filtroValorFinal") + " ");
                    buf.append((CharSequence)auxSelect);
                }
                buf.append(" order by a.fil_codigo, a.rpg_tipo, ");
                if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[1])) {
                    buf.append("a.rpg_datahora");
                } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[2])) {
                    buf.append("a.usr_codigo");
                } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[3])) {
                    buf.append("a.rpg_vencimento");
                } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[4])) {
                    buf.append("a.rpg_numerodocumento");
                } else {
                    buf.append("a.rpg_codigo ");
                }
                ResultSet rsSaldo = Conexao.executeQuery(st, selectSaldoAnt);
                if (rsSaldo.next()) {
                    totalReceber = rsSaldo.getFloat("totalReceber");
                    saldoDevedor = rsSaldo.getFloat("saldoDevedor");
                    totalPagar = rsSaldo.getFloat("totalPagar");
                    saldoCredor = rsSaldo.getFloat("saldoCredor");
                }
                if ((rs = Conexao.executeQuery(st, buf.toString())).next()) {
                    ModeloGridTable modelo = new ModeloGridTable(campos);
                    do {
                        Object[] o = new Object[camposRelatorio.length + camposCadastros.length];
                        for (int i = 0; i < camposRelatorio.length; ++i) {
                            if (camposRelatorio[i].equals("tipoReceberPagar")) {
                                o[modelo.findColumn((String)RelatorioSaldoReceberPagar.camposRelatorio[i])] = Tipos.tipoReceberPagar(rs.getString(camposRelatorio[i])).toUpperCase();
                                continue;
                            }
                            if (camposRelatorio[i].equals("valorTotalReceberPagar")) {
                                o[modelo.findColumn((String)RelatorioSaldoReceberPagar.camposRelatorio[i])] = rs.getDouble(camposRelatorio[i]);
                                if (rs.getString("situacaoReceberPagar").equals("A") || rs.getString("situacaoReceberPagar").equals("V") || rs.getString("situacaoReceberPagar").equals("T") || rs.getString("situacaoReceberPagar").equals("S")) {
                                    if (rs.getString("tipoReceberPagar").equals("R")) {
                                        auxSaldoDevedor += rs.getFloat(camposRelatorio[i]);
                                    } else {
                                        auxSaldoCredor += rs.getFloat(camposRelatorio[i]);
                                    }
                                }
                                if (rs.getString("tipoReceberPagar").equals("R")) {
                                    auxTotalReceber = Float.valueOf(auxTotalReceber.floatValue() + rs.getFloat(camposRelatorio[i]));
                                    continue;
                                }
                                auxTotalPagar = Float.valueOf(auxTotalPagar.floatValue() + rs.getFloat(camposRelatorio[i]));
                                continue;
                            }
                            if (camposRelatorio[i].equals("valorReceberPagar")) {
                                o[modelo.findColumn((String)RelatorioSaldoReceberPagar.camposRelatorio[i])] = Float.valueOf(rs.getFloat(camposRelatorio[i]));
                                if (rs.getString("tipoReceberPagar").equals("R")) {
                                    auxValorReceber = Float.valueOf(auxValorReceber.floatValue() + rs.getFloat(camposRelatorio[i]));
                                    continue;
                                }
                                auxValorPagar = Float.valueOf(auxValorPagar.floatValue() + rs.getFloat(camposRelatorio[i]));
                                continue;
                            }
                            if (camposRelatorio[i].equals("valorAcrescimoReceberPagar") || camposRelatorio[i].equals("valorCofinsReceberPagar") || camposRelatorio[i].equals("valorCsllReceberPagar") || camposRelatorio[i].equals("valorImpostos") || camposRelatorio[i].equals("valorInssReceberPagar") || camposRelatorio[i].equals("valorJuroReceberPagar") || camposRelatorio[i].equals("valorMultaReceberPagar") || camposRelatorio[i].equals("valorPisReceberPagar")) {
                                o[modelo.findColumn((String)RelatorioSaldoReceberPagar.camposRelatorio[i])] = rs.getDouble(camposRelatorio[i]);
                                if (rs.getString("tipoReceberPagar").equals("R")) {
                                    auxImpostosTaxasReceber = Float.valueOf(auxImpostosTaxasReceber.floatValue() + rs.getFloat(camposRelatorio[i]));
                                    continue;
                                }
                                auxImpostosTaxasPagar = Float.valueOf(auxImpostosTaxasPagar.floatValue() + rs.getFloat(camposRelatorio[i]));
                                continue;
                            }
                            if (camposRelatorio[i].equals("valorDescontoReceberPagar")) {
                                o[modelo.findColumn((String)RelatorioSaldoReceberPagar.camposRelatorio[i])] = rs.getDouble(camposRelatorio[i]);
                                if (rs.getString("tipoReceberPagar").equals("R")) {
                                    auxDescontoReceber = Float.valueOf(auxDescontoReceber.floatValue() + rs.getFloat(camposRelatorio[i]));
                                    continue;
                                }
                                auxDescontoPagar = Float.valueOf(auxDescontoPagar.floatValue() + rs.getFloat(camposRelatorio[i]));
                                continue;
                            }
                            if (camposRelatorio[i].equals("valorComTaxaReceberPagar")) {
                                o[modelo.findColumn((String)RelatorioSaldoReceberPagar.camposRelatorio[i])] = rs.getDouble(camposRelatorio[i]);
                                continue;
                            }
                            if (camposRelatorio[i].equals("tipoDocumentoReceberPagar")) {
                                o[modelo.findColumn((String)RelatorioSaldoReceberPagar.camposRelatorio[i])] = Tipos.tipoDocumento(rs.getString(camposRelatorio[i]));
                                continue;
                            }
                            if (camposRelatorio[i].equals("situacaoReceberPagar")) {
                                o[modelo.findColumn((String)RelatorioSaldoReceberPagar.camposRelatorio[i])] = Tipos.tipoSituacaoReceberPagar(rs.getString(camposRelatorio[i])).substring(0, 3);
                                continue;
                            }
                            if (camposRelatorio[i].equals("tipoCadastroReceberPagar")) {
                                o[modelo.findColumn((String)RelatorioSaldoReceberPagar.camposRelatorio[i])] = Tipos.tipoCadastro(rs.getString(camposRelatorio[i]));
                                continue;
                            }
                            if (camposRelatorio[i].equals("totalReceber")) {
                                o[modelo.findColumn((String)RelatorioSaldoReceberPagar.camposRelatorio[i])] = Float.valueOf(totalReceber);
                                continue;
                            }
                            if (camposRelatorio[i].equals("saldoDevedor")) {
                                o[modelo.findColumn((String)RelatorioSaldoReceberPagar.camposRelatorio[i])] = Float.valueOf(saldoDevedor);
                                continue;
                            }
                            if (camposRelatorio[i].equals("totalPagar")) {
                                o[modelo.findColumn((String)RelatorioSaldoReceberPagar.camposRelatorio[i])] = Float.valueOf(totalPagar);
                                continue;
                            }
                            if (camposRelatorio[i].equals("saldoCredor")) {
                                o[modelo.findColumn((String)RelatorioSaldoReceberPagar.camposRelatorio[i])] = Float.valueOf(saldoCredor);
                                continue;
                            }
                            if (camposRelatorio[i].equals("auxSaldoCredor") || camposRelatorio[i].equals("auxSaldoDevedor") || camposRelatorio[i].equals("auxImpostosTaxasReceber") || camposRelatorio[i].equals("auxImpostosTaxasPagar") || camposRelatorio[i].equals("auxValorReceber") || camposRelatorio[i].equals("auxValorPagar") || camposRelatorio[i].equals("auxDescontoReceber") || camposRelatorio[i].equals("auxDescontoPagar") || camposRelatorio[i].equals("auxTotalReceber") || camposRelatorio[i].equals("auxTotalPagar") || camposRelatorio[i].equals("auxImpostosTaxas") || camposRelatorio[i].equals("auxValor") || camposRelatorio[i].equals("auxDesconto") || camposRelatorio[i].equals("auxTotal")) continue;
                            o[modelo.findColumn((String)RelatorioSaldoReceberPagar.camposRelatorio[i])] = rs.getObject(camposRelatorio[i]);
                        }
                        this.setDadosCadastro(st2, o, modelo, rs.getString("tipoCadastroReceberPagar"), rs.getInt("codigoFilial"), rs.getInt("codigoCadastro"));
                        modelo.addLine(o);
                    } while (rs.next());
                    this.setValoresModelo(modelo, auxSaldoCredor, "auxSaldoCredor");
                    this.setValoresModelo(modelo, auxSaldoDevedor, "auxSaldoDevedor");
                    this.setValoresModelo(modelo, auxImpostosTaxasReceber.floatValue(), "auxImpostosTaxasReceber");
                    this.setValoresModelo(modelo, auxImpostosTaxasPagar.floatValue(), "auxImpostosTaxasPagar");
                    this.setValoresModelo(modelo, auxValorReceber.floatValue(), "auxValorReceber");
                    this.setValoresModelo(modelo, auxValorPagar.floatValue(), "auxValorPagar");
                    this.setValoresModelo(modelo, auxDescontoReceber.floatValue(), "auxDescontoReceber");
                    this.setValoresModelo(modelo, auxDescontoPagar.floatValue(), "auxDescontoPagar");
                    this.setValoresModelo(modelo, auxTotalReceber.floatValue(), "auxTotalReceber");
                    this.setValoresModelo(modelo, auxTotalPagar.floatValue(), "auxTotalPagar");
                    this.setValoresModelo(modelo, auxImpostosTaxasReceber.floatValue() - auxImpostosTaxasPagar.floatValue(), "auxImpostosTaxas");
                    this.setValoresModelo(modelo, auxValorReceber.floatValue() - auxValorPagar.floatValue(), "auxValor");
                    this.setValoresModelo(modelo, auxDescontoReceber.floatValue() - auxDescontoPagar.floatValue(), "auxDesconto");
                    this.setValoresModelo(modelo, auxTotalReceber.floatValue() - auxTotalPagar.floatValue(), "auxTotal");
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(RelatorioSaldoReceberPagar.getModuloAcesso());
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        int i;
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(0.5f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioSaldoReceberPagar.this.panelCentro.removeAll();
                                RelatorioSaldoReceberPagar.this.panelCentro.repaint();
                                RelatorioSaldoReceberPagar.this.habilitaBotaoImprimir(true);
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                        var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                        var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                        var.put("filtroNumeroDocumento", this.getFiltroTexto("filtroNumeroDocumento"));
                        var.put("filtroValorInicial", this.getFiltroDecimal("filtroValorInicial"));
                        var.put("filtroValorFinal", this.getFiltroDecimal("filtroValorFinal"));
                        var.put("filtroTipo", this.getFiltroCombo("filtroTipo"));
                        var.put("filtroTipoDocumento", this.getFiltroCombo("filtroTipoDocumento"));
                        var.put("filtroTipoCadastro", this.getFiltroCombo("filtroTipoCadastro"));
                        var.put("filtroSituacao", this.getFiltroCombo("filtroSituacao"));
                        buf.delete(0, buf.length());
                        if (convenio != null) {
                            for (i = 0; i < convenio.length; ++i) {
                                buf.append(convenio[i]);
                                if (i >= convenio.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroConvenio", buf.toString());
                        buf.delete(0, buf.length());
                        if (paciente != null) {
                            for (i = 0; i < paciente.length; ++i) {
                                buf.append(paciente[i]);
                                if (i >= paciente.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroPaciente", buf.toString());
                        buf.delete(0, buf.length());
                        if (entidade != null) {
                            for (i = 0; i < entidade.length; ++i) {
                                buf.append(entidade[i]);
                                if (i >= entidade.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroEntidade", buf.toString());
                        buf.delete(0, buf.length());
                        if (serie != null) {
                            for (i = 0; i < serie.length; ++i) {
                                buf.append(serie[i]);
                                if (i >= serie.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroSerie", buf.toString());
                        buf.delete(0, buf.length());
                        if (filiais != null) {
                            for (i = 0; i < filiais.length; ++i) {
                                buf.append(filiais[i]);
                                if (i >= filiais.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        buf.append(Variaveis.filialPadrao);
                        var.put("filtroFilial", buf.toString());
                        buf.delete(0, buf.length());
                        if (usuario != null) {
                            for (i = 0; i < usuario.length; ++i) {
                                buf.append(usuario[i]);
                                if (i >= usuario.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroUsuario", buf.toString());
                        String campoData = this.CAMPOS_DATA[this.getFiltroComboIndice("filtroCampoData")];
                        var.put("filtroCampoData", campoData != null ? campoData : "");
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelCentro.revalidate();
                    }
                    break block123;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st, st2);
                    throw throwable;
                }
                Conexao.fecharStatement(st, st2);
            }
        }
        Conexao.fecharStatement(st, st2);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void setDadosCadastro(Statement st, Object[] array, ModeloGridTable modelo, String tipo, int filial, int codigo) throws SQLException {
        if (tipo == null) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        if (tipo.equalsIgnoreCase("P")) {
            buf.append("select ");
            buf.append("\tpac.pac_codigo as codigoCadastro, pac.pac_nome as fantasiaCadastro,pac.pac_nomesocial as nomeSocialPaciente, pac.pac_nome as razaoSocialCadastro, pac.pac_fone as foneCadastro, ");
            buf.append("\tpac.pac_endereco as enderecoCadastro, pac.pac_numeroendereco as numeroEnderecoCadastro, pac.pac_tipologradouroendereco as tipoLogradouroCadastro, ");
            buf.append("\tpac.pac_fax as faxCadastro, pac.pac_complemento as complementoCadastro, pac.pac_cep as cepCadastro, ");
            buf.append("\tpac.cid_codigo as codigoCidadeCadastro, cidpac.cid_nome as nomeCidadeCadastro ");
            buf.append("from paciente pac ");
            buf.append("\tleft join cidades cidpac on pac.fil_codigo = cidpac.fil_codigo and pac.cid_codigo = cidpac.cid_codigo ");
            buf.append("where pac.fil_codigo = ").append(filial);
            buf.append(" and pac.pac_codigo = ").append(codigo);
        } else if (tipo.equalsIgnoreCase("O")) {
            buf.append("select ");
            buf.append("\tcon.con_codigo as codigoCadastro, con.con_fantasia as fantasiaCadastro,'' as nomeSocialPaciente, con.con_razao as razaoSocialCadastro, con.con_fone as foneCadastro, ");
            buf.append("\tcon.con_endereco as enderecoCadastro, con.con_numeroendereco as numeroEnderecoCadastro, con.con_tipologradouroendereco as tipoLogradouroCadastro, ");
            buf.append("\tcon.con_fax as faxCadastro, con.con_complemento as complementoCadastro, con.con_cep as cepCadastro, ");
            buf.append("\tcon.cid_codigo as codigoCidadeCadastro, cidcon.cid_nome as nomeCidadeCadastro ");
            buf.append("from convenios con ");
            buf.append("\tleft join cidades cidcon on con.fil_codigo = cidcon.fil_codigo and con.cid_codigo = cidcon.cid_codigo ");
            buf.append("where con.fil_codigo = ").append(filial);
            buf.append(" and con.con_codigo = ").append(codigo);
        } else {
            buf.append("select ");
            buf.append("\tent.ent_codigo as codigoCadastro, ent.ent_fantasia as fantasiaCadastro, '' as nomeSocialPaciente, ent.ent_razaosocial as razaoSocialCadastro, ent.ent_fone as foneCadastro, ");
            buf.append("\tent.ent_endereco as enderecoCadastro, ent.ent_numeroendereco as numeroEnderecoCadastro, ent.ent_tipologradouroendereco as tipoLogradouroCadastro, ");
            buf.append("\tent.ent_fax as faxCadastro, ent.ent_complemento as complementoCadastro, ent.ent_cep as cepCadastro, ");
            buf.append("\tent.cid_codigo as codigoCidadeCadastro, cident.cid_nome as nomeCidadeCadastro ");
            buf.append("from entidade ent ");
            buf.append("\tleft join cidades cident on ent.fil_codigo = cident.fil_codigo and ent.cid_codigo = cident.cid_codigo ");
            buf.append("where ent.fil_codigo = ").append(filial);
            buf.append(" and ent.ent_codigo = ").append(codigo);
        }
        ResultSet rs = Conexao.executeQuery(st, buf);
        if (rs.next()) {
            int pos = -1;
            for (String s : camposCadastros) {
                if (rs.findColumn(s) <= 0 || modelo.findColumn(s) <= -1) continue;
                pos = modelo.findColumn(s);
                array[pos] = modelo.getColumnName(pos).equalsIgnoreCase("tipoLogradouroCadastro") ? Tipos.tipoLogradouroDescricao(rs.getString(s)) : rs.getObject(s);
            }
        }
    }

    private void setValoresModelo(ModeloGridTable modelo, float valor, String campo) {
        for (int i = 0; i < modelo.getRowCount(); ++i) {
            modelo.setValueAt(Float.valueOf(valor), i, modelo.findColumn(campo));
        }
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0851000100");
    }
}

