/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.movimento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;

public class RelatorioSaldoContas
extends FrmRelPadrao {
    private final long ACESSO_CONFIGURAR = 850200101L;
    private final String FILTRO_DATAINICIAL = "filtroDataInicial";
    private final String FILTRO_DATAFINAL = "filtroDataFinal";
    private final String FILTRO_CONTA = "filtroConta";
    private final int POS_DATA = 0;
    private final int POS_CONTA = 1;
    private final int POS_VALOR = 2;
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoAgencia", "descricaoAgencia", "codigoBanco", "descricaoBanco", "codigoConta", "numeroConta", "titularConta", "tipoConta", "codigoHistoricoPadrao", "descricaoHistoricoPadrao", "inativaConta", "saldoInicialConta", "dataSaldoInicialConta", "dataSaldo", "valorSaldo", "totalSaldoFinal"});

    public RelatorioSaldoContas() {
        this.montaBarraDescricao("Relat\u00f3rio de saldo de conta", "Listagem di\u00e1ria de saldo de conta", "relatorios/rel_saldo_conta.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroConta", "Conta", "contacorrente", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"cco_reduzido", "cco_conta", "bac_codigo", "age_codigo", "cco_inativa"}, new String[]{"C\u00f3digo", "Conta", "Banco", "Ag\u00eancia", "Inativa"}, new int[]{60, 0, 50, 60, 55});
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.setModuloConfigurar(850200101L);
        this.setModuloAcesso(RelatorioSaldoContas.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement st2;
        Statement st;
        block38: {
            BigDecimal totalSaldoFinal = BigDecimal.ZERO;
            String[] contas = this.getSelecionadosFiltro("filtroConta", 0);
            if (contas == null || contas.length == 0) {
                Funcoes.mensagem(this, "Pelo menos uma conta deve ser selecionada para o relat\u00f3rio", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            if (!Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                Funcoes.mensagem(this, "Data inicial inv\u00e1lida", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            if (!Funcoes.textoVazio(this.getFiltroData("filtroDataFinal")) && !Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                Funcoes.mensagem(this, "Data final inv\u00e1lida", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            st = Conexao.getStatement();
            st2 = Conexao.getStatement();
            ResultSet rs = null;
            Object[][] arrayDados = null;
            String dataFinal = Funcoes.textoVazio(this.getFiltroData("filtroDataFinal")) ? Funcoes.formataData("dd/MM/yyyy", new java.util.Date()) : this.getFiltroData("filtroDataFinal");
            String dataInicial = this.getFiltroData("filtroDataInicial");
            try {
                StringBuilder aux = new StringBuilder();
                aux.append(" select cast('").append(Funcoes.formataData("yyyy-MM-dd", dataFinal)).append("' as date) ");
                aux.append(" - cast('").append(Funcoes.formataData("yyyy-MM-dd", dataInicial)).append("' as date) as qtde ");
                rs = Conexao.executeQuery(st, aux.toString());
                rs.next();
                int qtde = rs.getInt("qtde") + 1;
                arrayDados = new Object[qtde * contas.length][3];
                for (int k = 0; k < contas.length; ++k) {
                    for (int i = 0; i < qtde; ++i) {
                        arrayDados[qtde * k + i][0] = Funcoes.somaDias(Funcoes.getData("dd/MM/yyyy", dataInicial), i);
                        arrayDados[qtde * k + i][1] = contas[k];
                        arrayDados[qtde * k + i][2] = null;
                    }
                }
            }
            catch (Exception aux) {
                // empty catch block
            }
            ModeloGridTable modelo = null;
            try {
                for (int k = 0; k < contas.length; ++k) {
                    String conta = contas[k];
                    StringBuilder bufSaldos = new StringBuilder();
                    StringBuilder buf = new StringBuilder();
                    StringBuilder bufConta = new StringBuilder();
                    bufConta.setLength(0);
                    bufConta.append(" select a.cco_reduzido as codigoConta ");
                    bufConta.append("       ,a.cco_conta as numeroConta ");
                    bufConta.append("       ,a.cco_titular as titularConta ");
                    bufConta.append("       ,a.cco_sldinicial as saldoInicialConta ");
                    bufConta.append("       ,a.cco_dtsldinicial as dataSaldoInicialConta ");
                    bufConta.append("       ,a.cco_tipo as tipoConta ");
                    bufConta.append("       ,a.cco_inativa as inativaConta ");
                    bufConta.append("       ,b.bac_codigo as codigoBanco ");
                    bufConta.append("       ,b.bac_descricao as descricaoBanco ");
                    bufConta.append("       ,c.age_codigo as codigoAgencia ");
                    bufConta.append("       ,c.age_descricao as descricaoAgencia ");
                    bufConta.append("       ,d.hpa_codigo as codigoHistoricoPadrao ");
                    bufConta.append("       ,d.hpa_descricao as descricaoHistoricoPadrao ");
                    bufConta.append(" , ");
                    bufConta.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                    bufConta.append("  from contacorrente a ");
                    bufConta.append("  left join banco b on a.fil_codigo = b.fil_codigo and a.bac_codigo = b.bac_codigo ");
                    bufConta.append("  left join agencia c on a.fil_codigo = c.fil_codigo and a.age_codigo = c.age_codigo and a.bac_codigo = c.bac_codigo ");
                    bufConta.append("  left join historicopadrao d on a.fil_codigo = d.fil_codigo and a.hpa_codigo = d.hpa_codigo ");
                    bufConta.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                    bufConta.append(" where a.fil_codigo = ").append(Variaveis.filialPadrao);
                    bufConta.append(" and a.cco_reduzido = ").append(conta);
                    ResultSet rsConta = Conexao.executeQuery(Conexao.getStatement(), bufConta.toString());
                    rsConta.next();
                    BigDecimal valorSaldoInicial = rsConta.getBigDecimal("saldoInicialConta");
                    Date dataSaldoInicial = rsConta.getDate("dataSaldoInicialConta");
                    Date dataPrimeiroSaldo = null;
                    bufSaldos.setLength(0);
                    bufSaldos.append(" select sld_saldo as saldo ");
                    bufSaldos.append("       ,MIN(sld_data) as data ");
                    bufSaldos.append("   from saldocontas ");
                    bufSaldos.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
                    bufSaldos.append("    and sld_data = (select MIN(sld_data) ");
                    bufSaldos.append("                      from saldocontas ");
                    bufSaldos.append("                     where fil_codigo = ").append(Variaveis.filialPadrao);
                    bufSaldos.append("                       and cco_reduzido = ").append(conta).append(") ");
                    bufSaldos.append("    and cco_reduzido = ").append(conta);
                    bufSaldos.append("  group by sld_saldo ");
                    ResultSet rsSaldos = Conexao.executeQuery(Conexao.getStatement(), bufSaldos.toString());
                    if (rsSaldos.next()) {
                        dataPrimeiroSaldo = rsSaldos.getDate("data");
                    }
                    BigDecimal valorUltimoSaldo = BigDecimal.ZERO;
                    Date dataUltimoSaldo = null;
                    bufSaldos.setLength(0);
                    bufSaldos.append(" select sld_saldo as saldo ");
                    bufSaldos.append("       ,MAX(sld_data) as data ");
                    bufSaldos.append("   from saldocontas ");
                    bufSaldos.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
                    bufSaldos.append("    and sld_data = (select MAX(sld_data) ");
                    bufSaldos.append("                      from saldocontas ");
                    bufSaldos.append("                     where fil_codigo = ").append(Variaveis.filialPadrao);
                    bufSaldos.append("                       and cco_reduzido = ").append(conta).append(") ");
                    bufSaldos.append("    and cco_reduzido = ").append(conta);
                    bufSaldos.append("  group by sld_saldo ");
                    rsSaldos = Conexao.executeQuery(Conexao.getStatement(), bufSaldos.toString());
                    if (rsSaldos.next()) {
                        valorUltimoSaldo = rsSaldos.getBigDecimal("saldo");
                        dataUltimoSaldo = rsSaldos.getDate("data");
                    }
                    BigDecimal valorAnteriorSaldo = BigDecimal.ZERO;
                    bufSaldos.setLength(0);
                    bufSaldos.append(" select sld_saldo as saldo ");
                    bufSaldos.append("       ,MAX(sld_data) as data ");
                    bufSaldos.append("   from saldocontas ");
                    bufSaldos.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
                    bufSaldos.append("    and sld_data = (select MAX(sld_data) ");
                    bufSaldos.append("                      from saldocontas ");
                    bufSaldos.append("                     where fil_codigo = ").append(Variaveis.filialPadrao);
                    bufSaldos.append("                       and cco_reduzido = ").append(conta);
                    if (Funcoes.verificaData(dataInicial)) {
                        bufSaldos.append("                           and sld_data < '").append(Funcoes.formataData("yyyy-MM-dd", dataInicial)).append("') ");
                    }
                    bufSaldos.append("    and cco_reduzido = ").append(conta);
                    if (Funcoes.verificaData(dataInicial)) {
                        buf.append("        and sld_data < '").append(Funcoes.formataData("yyyy-MM-dd", dataInicial)).append("'");
                    }
                    bufSaldos.append("  group by sld_saldo ");
                    rsSaldos = Conexao.executeQuery(Conexao.getStatement(), bufSaldos.toString());
                    valorAnteriorSaldo = rsSaldos.next() ? rsSaldos.getBigDecimal("saldo") : BigDecimal.ZERO;
                    buf.setLength(0);
                    buf.append(" select saldo.sld_data as dataSaldo ");
                    buf.append("       ,saldo.sld_saldo as valorSaldo ");
                    buf.append("  from saldocontas saldo ");
                    buf.append(" where saldo.fil_codigo = ").append(Variaveis.filialPadrao);
                    buf.append("   and saldo.cco_reduzido = ").append(conta);
                    if (Funcoes.verificaData(dataInicial)) {
                        buf.append(" and saldo.sld_data >= '").append(Funcoes.formataData("yyyy-MM-dd", dataInicial)).append("'");
                    }
                    if (Funcoes.verificaData(dataFinal)) {
                        buf.append(" and saldo.sld_data <= '").append(Funcoes.formataData("yyyy-MM-dd", dataFinal)).append("'");
                    }
                    buf.append(" order by saldo.sld_data");
                    rs = Conexao.executeQuery(st, buf.toString());
                    block11: while (rs.next()) {
                        Date dataAux = rs.getDate("dataSaldo");
                        if (arrayDados == null) continue;
                        for (int i = 0; i < arrayDados.length; ++i) {
                            if (!dataAux.equals(arrayDados[i][0]) || !conta.equals(arrayDados[i][1])) continue;
                            arrayDados[i][2] = rs.getBigDecimal("valorSaldo");
                            continue block11;
                        }
                    }
                    if (arrayDados != null) {
                        for (int i = 0; i < arrayDados.length; ++i) {
                            if (((java.util.Date)arrayDados[i][0]).compareTo(dataSaldoInicial) < 0 && conta.equals(arrayDados[i][1])) {
                                arrayDados[i][2] = BigDecimal.ZERO;
                                continue;
                            }
                            if (((java.util.Date)arrayDados[i][0]).compareTo(dataSaldoInicial) >= 0 && dataPrimeiroSaldo != null && ((java.util.Date)arrayDados[i][0]).compareTo(dataPrimeiroSaldo) < 0 && conta.equals(arrayDados[i][1])) {
                                arrayDados[i][2] = valorSaldoInicial;
                                continue;
                            }
                            if (dataUltimoSaldo != null && ((java.util.Date)arrayDados[i][0]).compareTo(dataUltimoSaldo) > 0 && conta.equals(arrayDados[i][1])) {
                                arrayDados[i][2] = valorUltimoSaldo;
                                continue;
                            }
                            if (dataPrimeiroSaldo != null || !conta.equals(arrayDados[i][1])) continue;
                            arrayDados[i][2] = valorSaldoInicial;
                        }
                    }
                    if (arrayDados != null) {
                        for (int i = 0; i < arrayDados.length; ++i) {
                            if (!conta.equals(arrayDados[i][1])) continue;
                            if (arrayDados[i][2] != null) break;
                            arrayDados[i][2] = valorAnteriorSaldo;
                        }
                    }
                    if (arrayDados != null) {
                        this.preencheArray(arrayDados, conta);
                    }
                    if (k == contas.length - 1) {
                        for (int aux = 0; aux < arrayDados.length; ++aux) {
                            if (!Funcoes.formataData("dd/MM/yyyy", (java.util.Date)arrayDados[aux][0]).equals(dataFinal) || arrayDados[aux][2] == null) continue;
                            totalSaldoFinal = totalSaldoFinal.add((BigDecimal)arrayDados[aux][2]);
                        }
                    }
                    rsConta.beforeFirst();
                    if (!rsConta.next()) continue;
                    if (modelo == null) {
                        modelo = new ModeloGridTable(campos);
                    }
                    if (arrayDados == null) continue;
                    for (int i = 0; i < arrayDados.length; ++i) {
                        Object[] o = new Object[campos.length];
                        if (!arrayDados[i][1].equals(conta)) continue;
                        for (int j = 0; j < campos.length; ++j) {
                            o[modelo.findColumn((String)RelatorioSaldoContas.campos[j])] = campos[j].equals("dataSaldo") ? arrayDados[i][0] : (campos[j].equals("valorSaldo") ? arrayDados[i][2] : (campos[j].equals("totalSaldoFinal") ? totalSaldoFinal : rsConta.getObject(campos[j])));
                        }
                        modelo.addLine(o);
                    }
                }
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RelatorioSaldoContas");
            }
            try {
                StringBuilder buf = new StringBuilder();
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioSaldoContas.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next() && modelo != null) {
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioSaldoContas.this.panelCentro.removeAll();
                            RelatorioSaldoContas.this.panelCentro.repaint();
                            RelatorioSaldoContas.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("filtroDataInicial", dataInicial);
                    var.put("filtroDataFinal", dataFinal);
                    buf.delete(0, buf.length());
                    if (contas != null) {
                        for (int i = 0; i < contas.length; ++i) {
                            buf.append(contas[i]);
                            if (i >= contas.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroConta", buf.toString());
                    gerador.executar(rs.getString("rel_xml"), modelo, var);
                    this.panelCentro.revalidate();
                    break block38;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RelatorioSaldoContas");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st, st2);
                    throw throwable;
                }
                Conexao.fecharStatement(st, st2);
            }
        }
        Conexao.fecharStatement(st, st2);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private Object[][] preencheArray(Object[][] array, String conta) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i][1] == null) continue;
            if (i - 1 >= 0) {
                this.preencheAnteriores(array, i - 1, conta, (BigDecimal)array[i][2]);
            }
            if (i + 1 >= array.length) continue;
            this.preencheProximos(array, i + 1, conta, (BigDecimal)array[i][2]);
        }
        return array;
    }

    private void preencheAnteriores(Object[][] array, int pos, String conta, BigDecimal valor) {
        for (int i = pos; i >= 0; --i) {
            if (!array[i][1].equals(conta)) continue;
            if (array[i][2] != null) break;
            array[i][2] = valor;
        }
    }

    private void preencheProximos(Object[][] array, int pos, String conta, BigDecimal valor) {
        for (int i = pos; i < array.length; ++i) {
            if (!array[i][1].equals(conta)) continue;
            if (array[i][2] != null) break;
            array[i][2] = valor;
        }
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0850200100");
    }
}

