/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.movimento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.relatorio.gerador.Relatorio;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.table.TableModel;

public class RelatorioReceberPagarOrigem
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private static final String[] ordem = new String[]{"C\u00f3digo", "N\u00fam. Doc.", "Dt. Cadastro", "Dt. Vencimento", "Valor Plano"};
    private static final String[] camposOrdemRecPag = new String[]{"rpg.rpg_codigo", "rpg.rpg_numerodocumento", "rpg.rpg_datahora", "rpg.rpg_vencimento", "valorReceberPagarPlanoComSinal"};
    private static final String[] situacaoRecPag = new String[]{"Todos", Tipos.tipoSituacaoReceberPagar("A"), Tipos.tipoSituacaoReceberPagar("Q"), Tipos.tipoSituacaoReceberPagar("V"), Tipos.tipoSituacaoReceberPagar("T"), Tipos.tipoSituacaoReceberPagar("S")};
    private static final String[] tipoRecPag = new String[]{"Todos", Tipos.tipoReceberPagar("R"), Tipos.tipoReceberPagar("P")};
    private static final String FILTRO_PLANO_CONTA = "filtroPlanoConta";
    private static final String FILTRO_FILIAL_PLANO_CONTA = "filtroFilialPlanoConta";
    private static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private static final String FILTRO_VALOR_INICIAL = "filtroValorInicial";
    private static final String FILTRO_VALOR_FINAL = "filtroValorFinal";
    private static final String FILTRO_TIPO_PLANO = "filtroTipoPlanoConta";
    private static final String FILTRO_USUARIO = "filtroUsuario";
    private static final String FILTRO_ORIGEM = "filtroOrigem";
    private static final String FILTRO_CAMPO_DATA = "filtroData";
    private static final String FILTRO_ORDEM = "filtroOrdem";
    private static final String FILTRO_SITUACAO = "filtroSituacao";
    private static final String FILTRO_TIPO = "filtroTipo";
    private static final String FILTRO_CONVENIO = "filtroConvenio";
    private static final String FILTRO_ENTIDADE = "filtroEntidade";
    private static final String FILTRO_PACIENTE = "filtroPaciente";
    private static final String[] CAMPOSDATARECPAG = new String[]{"Vencimento", "Documento", "Cadastro", "Processamento", "Compet\u00eancia"};
    private static final String[] CAMPOSDATABANCORECPAG = new String[]{"rpg_vencimento", "rpg_datadocumento", "rpg_datahora", "rpg_dataprocessamento", "rpg_competencia"};
    public static final int TIPO_RECEBERPAGAR = 0;
    public static final int TIPO_LANCAMENTO = 1;
    private String[] camposRelatorio = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"reduzidoPlanoConta", "descricaoPlanoConta", "contaPlanoConta", "tipoPlanoConta", "apropriarPlanoConta", "filialPlanoConta", "nivelPlanoConta", "paiPlanoConta", "totalPlanoConta", "valorSomatorio", "totalPlanoContaComSinal", "valorSomatorioComSinal", "operacaoPlanoConta"});
    private static final String[] camposRecPag = new String[]{"codigoReceberPagar", "dataVencimentoReceberPagar", "tipoReceberPagar", "tipoDocumentoReceberPagar", "numeroDocumentoReceberPagar", "parcelaReceberPagar", "dataDocumentoReceberPagar", "dataProcessamentoReceberPagar", "codigoSerieReceberPagar", "situacaoReceberPagar", "valorReceberPagar", "valorTotalReceberPagar", "valorReceberPagarPlanoComSinal", "valorReceberPagarPlano", "dataHoraReceberPagar", "codigoOrigemReceberPagar", "competenciaReceberPagar", "dataVencimentoLancamentoBaixa", "dataCompetenciaLancamentoBaixa", "dataConciliacaoLancamentoBaixa", "codigoBaixa", "situacaoLancamentoBaixa", "descricaoOrigemReceberPagar"};
    private static final String[] camposCadastros = new String[]{"codigoCadastro", "fantasiaCadastro", "nomeSocialPaciente", "razaoSocialCadastro", "foneCadastro", "enderecoCadastro", "faxCadastro", "complementoCadastro", "cepCadastro", "numeroEnderecoCadastro", "codigoCidadeCadastro", "nomeCidadeCadastro", "tipoLogradouroCadastro"};

    public RelatorioReceberPagarOrigem() {
        this.montaBarraDescricao("Relat\u00f3rio de Receber/Pagar por Origem", "Movimenta\u00e7\u00e3o de T\u00edtulos por origem financeira", "relatorios/rel_rec_pag_por_origem.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro(FILTRO_FILIAL_PLANO_CONTA, "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_USUARIO, "Usu\u00e1rio", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_ORIGEM, "Origem", "origemplanocusto", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"opc_codigo", "opc_descricao", "opc_padrao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Padr\u00e3o"}, new int[]{70, 0, 50});
        this.adicionaItemFiltro(FILTRO_CONVENIO, "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Nome Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_ENTIDADE, "Entidade", "entidade", "fil_codigo = " + Variaveis.filialPadrao + " and ent_inativo = false", 1, new String[]{"ent_codigo", "ent_razaosocial"}, new String[]{"C\u00f3digo", "Raz\u00e3o Social"}, new int[]{70, 0});
        if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A") || Variaveis.tipoFilialPadrao.equalsIgnoreCase("V")) {
            this.adicionaItemFiltroAvancado(FILTRO_PACIENTE, "Paciente", "paciente", "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"pac_codigo", "pac_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0}, false, new int[]{70, 0});
        } else {
            this.adicionaItemFiltroAvancado(FILTRO_PACIENTE, "Paciente", "paciente", "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"pac_codigo", "pac_nome", "pac_nomesocial"}, new String[]{"C\u00f3digo", "Nome", "Nome Social"}, new int[]{70, 0, 0}, false, new int[]{70, 0, 0});
        }
        this.adicionaFiltroCombo(FILTRO_CAMPO_DATA, "Campo Data:", CAMPOSDATARECPAG, 0);
        this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Data inicial:");
        this.adicionaFiltroData(FILTRO_DATA_FINAL, "Data final:");
        this.adicionaFiltroDecimal(FILTRO_VALOR_INICIAL, "Valor Inicial:", 0);
        this.adicionaFiltroDecimal(FILTRO_VALOR_FINAL, "Valor Final:", 0);
        this.adicionaFiltroCombo(FILTRO_SITUACAO, "Situa\u00e7\u00e3o:", situacaoRecPag, 0);
        this.adicionaRetornaFiltroCombo(FILTRO_TIPO, "Tipo:", tipoRecPag, 0);
        this.adicionaFiltroCombo(FILTRO_ORDEM, "Ordem:", ordem, 0);
        this.setModuloConfigurar(this.getConfigurarAcesso());
        this.setModuloAcesso(RelatorioReceberPagarOrigem.getModuloAcesso());
        this.setCamposConfigurador(ArraysUtil.concatenar(ArraysUtil.concatenar(this.camposRelatorio, camposRecPag), camposCadastros));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        ModeloGridTable modeloDados;
        String[] paciente;
        String[] entidade;
        String[] convenio;
        String[] origem;
        String[] usuario;
        String[] filiais;
        String layout;
        StringBuilder buf;
        Statement st2;
        Statement st;
        block60: {
            String comboSituacao;
            ResultSet rs;
            block59: {
                block58: {
                    st = Conexao.getStatement();
                    st2 = Conexao.getStatement();
                    buf = new StringBuilder();
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ").append(RelatorioReceberPagarOrigem.getModuloAcesso());
                    rs = Conexao.executeQuery(st, buf.toString());
                    layout = null;
                    if (rs.next()) {
                        layout = rs.getString("rel_xml");
                        break block58;
                    }
                    Funcoes.mensagem(this, "Modelo n\u00e3o localizado ou n\u00e3o definido.", 2);
                    this.habilitaBotaoImprimir(true);
                    Conexao.fecharStatement(st, st2);
                    return;
                }
                filiais = this.getSelecionadosFiltro(FILTRO_FILIAL_PLANO_CONTA, 0);
                if (filiais == null || filiais.length <= 1) break block59;
                Funcoes.mensagem(this, "Apenas uma filial deve ser selecionada para o relat\u00f3rio.", 2);
                this.habilitaBotaoImprimir(true);
                Conexao.fecharStatement(st, st2);
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            String where = "";
            if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_INICIAL))) {
                where = where + " and cast(rpg." + CAMPOSDATABANCORECPAG[this.getFiltroComboIndice(FILTRO_CAMPO_DATA)] + " as date) >= '" + Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_INICIAL)) + "' ";
            }
            if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_FINAL))) {
                where = where + " and cast(rpg." + CAMPOSDATABANCORECPAG[this.getFiltroComboIndice(FILTRO_CAMPO_DATA)] + " as date) <= '" + Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_FINAL)) + "' ";
            }
            if (!Funcoes.textoVazio(this.getFiltroDecimal(FILTRO_VALOR_INICIAL))) {
                where = where + " and rpg.rpg_valortotal >= " + this.getFiltroTexto(FILTRO_VALOR_INICIAL);
            }
            if (!Funcoes.textoVazio(this.getFiltroDecimal(FILTRO_VALOR_FINAL))) {
                where = where + " and rpg.rpg_valortotal <= " + this.getFiltroTexto(FILTRO_VALOR_FINAL);
            }
            if ((usuario = this.getSelecionadosFiltro(FILTRO_USUARIO, 0)) != null) {
                where = where + " and (rpg.usr_codigo in (";
                for (int i = 0; i < usuario.length; ++i) {
                    where = where + "'" + usuario[i] + "'";
                    if (i >= usuario.length - 1) continue;
                    where = where + ", ";
                }
                where = where + ") OR rpg.usr_codigo IS NULL) ";
            }
            if ((comboSituacao = this.getFiltroCombo(FILTRO_SITUACAO).toString()).equals(situacaoRecPag[0])) {
                where = where + " and rpg.rpg_situacao IN('A', 'Q', 'V', 'T', 'S') ";
            } else {
                where = where + " and rpg.rpg_situacao = '";
                if (comboSituacao.equals(situacaoRecPag[1])) {
                    where = where + "A";
                } else if (comboSituacao.equals(situacaoRecPag[2])) {
                    where = where + "Q";
                } else if (comboSituacao.equals(situacaoRecPag[3])) {
                    where = where + "V";
                } else if (comboSituacao.equals(situacaoRecPag[4])) {
                    where = where + "T";
                } else if (comboSituacao.equals(situacaoRecPag[5])) {
                    where = where + "S";
                }
                where = where + "' ";
            }
            String comboTipo = this.getFiltroCombo(FILTRO_TIPO).toString();
            if (comboTipo.equals(tipoRecPag[0])) {
                where = where + " and rpg.rpg_tipo IN('R', 'P') ";
            } else {
                where = where + " and rpg.rpg_tipo = '";
                where = comboTipo.equals(tipoRecPag[1]) ? where + "R" : where + "P";
                where = where + "' ";
            }
            origem = this.getSelecionadosFiltro(FILTRO_ORIGEM, 0);
            if (origem != null) {
                where = where + " and a.opc_codigo in (";
                for (int i = 0; i < origem.length; ++i) {
                    where = where + "'" + origem[i] + "'";
                    if (i >= origem.length - 1) continue;
                    where = where + ", ";
                }
                where = where + ")";
            }
            StringBuilder bufCadastros = new StringBuilder();
            convenio = this.getSelecionadosFiltro(FILTRO_CONVENIO, 0);
            if (convenio != null) {
                bufCadastros.append(" rpg.con_codigo in (");
                for (int j = 0; j < convenio.length; ++j) {
                    bufCadastros.append(convenio[j]);
                    if (j >= convenio.length - 1) continue;
                    bufCadastros.append(", ");
                }
                bufCadastros.append(")");
            }
            if ((entidade = this.getSelecionadosFiltro(FILTRO_ENTIDADE, 0)) != null) {
                if (bufCadastros.length() > 0) {
                    bufCadastros.append(" or ");
                }
                bufCadastros.append(" rpg.ent_codigo in (");
                for (int j = 0; j < entidade.length; ++j) {
                    bufCadastros.append("'");
                    bufCadastros.append(entidade[j]);
                    bufCadastros.append("'");
                    if (j >= entidade.length - 1) continue;
                    bufCadastros.append(", ");
                }
                bufCadastros.append(")");
            }
            if ((paciente = this.getSelecionadosFiltroAvancado(FILTRO_PACIENTE, 0)) != null) {
                if (bufCadastros.length() > 0) {
                    bufCadastros.append(" or ");
                }
                bufCadastros.append(" rpg.pac_codigo in (");
                for (int j = 0; j < paciente.length; ++j) {
                    bufCadastros.append(paciente[j]);
                    if (j >= paciente.length - 1) continue;
                    bufCadastros.append(", ");
                }
                bufCadastros.append(")");
            }
            if (bufCadastros.length() > 0) {
                where = where + " and (" + bufCadastros.toString() + ") ";
            }
            HashMap<String, String> camposDisponiveis = new HashMap<String, String>();
            camposDisponiveis.put("reduzidoPlanoConta", "a.plc_reduzido");
            camposDisponiveis.put("descricaoPlanoConta", "a.plc_descricao");
            camposDisponiveis.put("contaPlanoConta", "plc.plc_conta");
            camposDisponiveis.put("tipoPlanoConta", "plc.plc_tipo");
            camposDisponiveis.put("apropriarPlanoConta", "plc.plc_apropriar");
            camposDisponiveis.put("filialPlanoConta", "a.fil_codigo");
            camposDisponiveis.put("nivelPlanoConta", "plc.plc_nivel");
            camposDisponiveis.put("paiPlanoConta", "plc.plc_pai");
            camposDisponiveis.put("operacaoPlanoConta", "plc.plc_operacao");
            camposDisponiveis.put("dataHoraReceberPagar", "rpg.rpg_datahora");
            camposDisponiveis.put("competenciaReceberPagar", "rpg.rpg_competencia");
            camposDisponiveis.put("dataVencimentoReceberPagar", "rpg.rpg_vencimento");
            camposDisponiveis.put("codigoReceberPagar", "rpg.rpg_codigo");
            camposDisponiveis.put("tipoReceberPagar", "rpg.rpg_tipo");
            camposDisponiveis.put("tipoDocumentoReceberPagar", "rpg.rpg_tipodocumento");
            camposDisponiveis.put("numeroDocumentoReceberPagar", "rpg.rpg_numerodocumento");
            camposDisponiveis.put("parcelaReceberPagar", "rpg.rpg_parcela");
            camposDisponiveis.put("dataDocumentoReceberPagar", "rpg.rpg_datadocumento");
            camposDisponiveis.put("dataProcessamentoReceberPagar", "rpg.rpg_dataprocessamento");
            camposDisponiveis.put("codigoSerieReceberPagar", "rpg.ser_codigo");
            camposDisponiveis.put("situacaoReceberPagar", "rpg.rpg_situacao");
            camposDisponiveis.put("codigoOrigemReceberPagar", "opc.opc_codigo");
            camposDisponiveis.put("descricaoOrigemReceberPagar", "opc.opc_descricao");
            camposDisponiveis.put("valorReceberPagar", "rpg.rpg_valor");
            camposDisponiveis.put("valorTotalReceberPagar", "rpg.rpg_valortotal");
            camposDisponiveis.put("valorReceberPagarPlano", "a.rpl_valor");
            camposDisponiveis.put("valorReceberPagarPlanoComSinal", "CASE WHEN plc.plc_operacao = 'A' THEN a.rpl_valor ELSE a.rpl_valor * (-1) END");
            camposDisponiveis.put("tipoCadastro", "rpg.rpg_tipocadastro");
            String campoAux = "CASE WHEN rpg.rpg_tipocadastro = 'P' THEN rpg.pac_codigo WHEN rpg.rpg_tipocadastro = 'O' THEN rpg.con_codigo ELSE rpg.ent_codigo END";
            camposDisponiveis.put("codigoCadastro", campoAux);
            camposDisponiveis.put("dataVencimentoLancamentoBaixa", "lcx.lcx_vencimento");
            camposDisponiveis.put("dataCompetenciaLancamentoBaixa", "lcx.lcx_competencia");
            camposDisponiveis.put("dataConciliacaoLancamentoBaixa", "lcx.lcx_conciliacao");
            camposDisponiveis.put("situacaoLancamentoBaixa", "lcx.lcx_situacao");
            camposDisponiveis.put("codigoBaixa", "bxa.bxa_codigo");
            camposDisponiveis.put("codigoCadastro", "COALESCE(pac.pac_codigo, con.con_codigo, ent.ent_codigo)");
            camposDisponiveis.put("nomeSocialPaciente", "pac.pac_nomesocial");
            camposDisponiveis.put("fantasiaCadastro", "COALESCE(pac.pac_nome, con.con_fantasia, ent.ent_fantasia)");
            camposDisponiveis.put("razaoSocialCadastro", "COALESCE(pac.pac_nome, con.con_razao, ent.ent_razaosocial)");
            camposDisponiveis.put("foneCadastro", "COALESCE(pac.pac_fone, con.con_fone, ent.ent_fone)");
            camposDisponiveis.put("enderecoCadastro", "COALESCE(pac.pac_endereco, con.con_endereco, ent.ent_endereco)");
            camposDisponiveis.put("numeroEnderecoCadastro", "COALESCE(pac.pac_numeroendereco, con.con_numeroendereco, ent.ent_numeroendereco)");
            camposDisponiveis.put("tipologradouroendereco", "COALESCE(pac.pac_tipologradouroendereco, con.con_tipologradouroendereco, ent.ent_tipologradouroendereco)");
            camposDisponiveis.put("faxCadastro", "COALESCE(pac.pac_fax, con.con_fax, ent.ent_fax)");
            camposDisponiveis.put("complementoCadastro", "COALESCE(pac.pac_complemento, con.con_complemento, ent.ent_complemento)");
            camposDisponiveis.put("cepCadastro", "COALESCE(pac.pac_cep, con.con_cep, ent.ent_cep)");
            camposDisponiveis.put("codigoCidadeCadastro", "COALESCE(pac.cid_codigo, con.cid_codigo, ent.cid_codigo)");
            camposDisponiveis.put("nomeCidadeCadastro", "COALESCE(cidpac.cid_nome, cidcon.cid_nome, cident.cid_nome)");
            camposDisponiveis.putAll(Constantes.MAPA_SELECT_FILIAL);
            HashMap<String, String> camposUtilizados = Relatorio.getCamposBancoLayout(layout, camposDisponiveis, null);
            buf.setLength(0);
            buf.append(" select ");
            buf.append(Relatorio.getFieldsSelect(camposUtilizados));
            buf.append("  from receberpagarplanoconta a ");
            buf.append("  join planoconta plc on a.fil_codigo = plc.fil_codigo and a.plc_reduzido = plc.plc_reduzido ");
            buf.append("  join origemplanocusto opc on a.fil_codigo = opc.fil_codigo and a.opc_codigo = opc.opc_codigo ");
            buf.append("  join receberpagar rpg on a.fil_codigo = rpg.fil_codigo and a.rpg_codigo = rpg.rpg_codigo ");
            buf.append("  left join baixareceberpagar brp on rpg.fil_codigo = brp.fil_codigo and rpg.rpg_codigo = brp.rpg_codigo ");
            buf.append(" \tleft join baixa bxa on brp.fil_codigo = bxa.fil_codigo and brp.bxa_codigo = bxa.bxa_codigo and bxa.bxa_situacao <> '").append("E").append("' ");
            buf.append(" \tleft join baixalanctocaixa blc on bxa.fil_codigo = blc.fil_codigo and bxa.bxa_codigo = blc.bxa_codigo ");
            buf.append(" \tleft join lanctocaixa lcx on blc.fil_codigo = lcx.fil_codigo and blc.lcx_codigo = lcx.lcx_codigo and blc.est_codigo = lcx.est_codigo ");
            buf.append("  left join paciente pac on rpg.fil_codigo = pac.fil_codigo and rpg.pac_codigo = pac.pac_codigo ");
            buf.append("  left join cidades cidpac on pac.fil_codigo = cidpac.fil_codigo and pac.cid_codigo = cidpac.cid_codigo ");
            buf.append("  left join convenios con on rpg.fil_codigo = con.fil_codigo and rpg.con_codigo = con.con_codigo ");
            buf.append("  left join cidades cidcon on con.fil_codigo = cidcon.fil_codigo and con.cid_codigo = cidcon.cid_codigo ");
            buf.append("  left join entidade ent on rpg.fil_codigo = ent.fil_codigo and rpg.ent_codigo = ent.ent_codigo ");
            buf.append("  left join cidades cident on ent.fil_codigo = cident.fil_codigo and ent.cid_codigo = cident.cid_codigo ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            buf.append("where a.fil_codigo ");
            if (filiais == null || filiais.length == 0) {
                buf.append(" = ").append(Variaveis.filialPadrao);
            } else {
                buf.append(" in (");
                for (int i = 0; i < filiais.length; ++i) {
                    buf.append(filiais[i]);
                    if (i >= filiais.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            buf.append(where);
            buf.append(" order by opc.opc_codigo, ");
            int indice = this.getFiltroComboIndice(FILTRO_ORDEM);
            buf.append(camposOrdemRecPag[indice]).append(", rpg.rpg_codigo ");
            String[] listaCamposUtilizados = new String[camposUtilizados.size()];
            Iterator<String> it = camposUtilizados.keySet().iterator();
            int i = 0;
            while (it.hasNext()) {
                listaCamposUtilizados[i] = it.next().toString();
                ++i;
            }
            modeloDados = new ModeloGridTable(listaCamposUtilizados);
            rs = Conexao.executeQuery(st2, buf.toString());
            if (rs.next()) {
                do {
                    Object[] o = new Object[listaCamposUtilizados.length];
                    for (int i2 = 0; i2 < listaCamposUtilizados.length; ++i2) {
                        String nomeCampo = listaCamposUtilizados[i2];
                        o[i2] = nomeCampo.equalsIgnoreCase("situacaoLancamentoBaixa") ? Tipos.tipoSituacaoLancamento(rs.getString("situacaoLancamentoBaixa")) : (nomeCampo.equalsIgnoreCase("tipoDocumentoReceberPagar") ? Tipos.tipoDocumento(rs.getString("tipoDocumentoReceberPagar")) : (nomeCampo.equalsIgnoreCase("tipoReceberPagar") ? Tipos.tipoReceberPagar(rs.getString("tipoReceberPagar")) : (nomeCampo.equalsIgnoreCase("tipoPlanoConta") ? Tipos.tipoPlanoContas(rs.getString("tipoPlanoConta")) : (nomeCampo.equalsIgnoreCase("situacaoReceberPagar") ? Tipos.tipoSituacaoReceberPagar(rs.getString("situacaoReceberPagar")) : rs.getObject(listaCamposUtilizados[i2])))));
                    }
                    modeloDados.addLine(o);
                } while (rs.next());
                break block60;
            }
            Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
            this.habilitaBotaoImprimir(true);
            this.setCursor(Cursor.getDefaultCursor());
            Conexao.fecharStatement(st, st2);
            return;
        }
        try {
            Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
            gerador.setPai(this.panelCentro);
            gerador.setPreVisualizar(true);
            gerador.setZoomPreVisualizar(1.0f);
            gerador.setAcaoFechar(new Runnable(){

                @Override
                public void run() {
                    RelatorioReceberPagarOrigem.this.panelCentro.removeAll();
                    RelatorioReceberPagarOrigem.this.panelCentro.repaint();
                    RelatorioReceberPagarOrigem.this.habilitaBotaoImprimir(true);
                }
            });
            HashMap<String, Object> var = new HashMap<String, Object>();
            var.put(FILTRO_DATA_INICIAL, this.getFiltroData(FILTRO_DATA_INICIAL));
            var.put(FILTRO_DATA_FINAL, this.getFiltroData(FILTRO_DATA_FINAL));
            var.put(FILTRO_VALOR_INICIAL, this.getFiltroDecimal(FILTRO_VALOR_INICIAL));
            var.put(FILTRO_VALOR_FINAL, this.getFiltroDecimal(FILTRO_VALOR_FINAL));
            var.put(FILTRO_TIPO_PLANO, this.getFiltroCombo(FILTRO_TIPO_PLANO));
            var.put(FILTRO_CAMPO_DATA, this.getFiltroCombo(FILTRO_CAMPO_DATA));
            var.put(FILTRO_SITUACAO, this.getFiltroCombo(FILTRO_SITUACAO) == null ? "Todos" : this.getFiltroCombo(FILTRO_SITUACAO));
            var.put(FILTRO_TIPO, this.getFiltroCombo(FILTRO_TIPO) == null ? "Todos" : this.getFiltroCombo(FILTRO_TIPO));
            var.put(FILTRO_ORDEM, this.getFiltroCombo(FILTRO_ORDEM));
            buf.delete(0, buf.length());
            if (entidade != null) {
                for (int i = 0; i < entidade.length; ++i) {
                    buf.append(entidade[i]);
                    if (i >= entidade.length - 1) continue;
                    buf.append(", ");
                }
            }
            var.put(FILTRO_ENTIDADE, buf.toString());
            buf.delete(0, buf.length());
            if (paciente != null) {
                for (int i = 0; i < paciente.length; ++i) {
                    buf.append(paciente[i]);
                    if (i >= paciente.length - 1) continue;
                    buf.append(", ");
                }
            }
            var.put(FILTRO_PACIENTE, buf.toString());
            buf.delete(0, buf.length());
            if (convenio != null) {
                for (int i = 0; i < convenio.length; ++i) {
                    buf.append(convenio[i]);
                    if (i >= convenio.length - 1) continue;
                    buf.append(", ");
                }
            }
            var.put(FILTRO_CONVENIO, buf.toString());
            buf.delete(0, buf.length());
            if (filiais != null) {
                for (int i = 0; i < filiais.length; ++i) {
                    buf.append(filiais[i]);
                    if (i >= filiais.length - 1) continue;
                    buf.append(", ");
                }
            } else {
                buf.append(Variaveis.filialPadrao);
            }
            var.put(FILTRO_FILIAL_PLANO_CONTA, buf.toString());
            buf.delete(0, buf.length());
            if (usuario != null) {
                for (int i = 0; i < usuario.length; ++i) {
                    buf.append(usuario[i]);
                    if (i >= usuario.length - 1) continue;
                    buf.append(", ");
                }
            }
            var.put(FILTRO_USUARIO, buf.toString());
            buf.delete(0, buf.length());
            if (origem != null) {
                for (int i = 0; i < origem.length; ++i) {
                    buf.append(origem[i]);
                    if (i >= origem.length - 1) continue;
                    buf.append(", ");
                }
            }
            var.put(FILTRO_ORIGEM, buf.toString());
            gerador.executar(layout, (TableModel)modeloDados, var);
            this.panelCentro.revalidate();
        }
        catch (Exception ex) {
            try {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st, st2);
                throw throwable;
            }
            Conexao.fecharStatement(st, st2);
        }
        Conexao.fecharStatement(st, st2);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0851800300");
    }

    public long getConfigurarAcesso() {
        return Long.parseLong("0851800301");
    }
}

