/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.movimento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioReceberPagarBaixaAcumulado
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final int CASAS = ParametrosGerais.getCasasPrecoExame();
    private RoundingMode ROUND = ParametrosGerais.getArredondamentoPrecoExame();
    private static final String[] CAMPOSBANCO_ORDEM = new String[]{"a.bxa_codigo", "a.bxa_valortotal", "a.bxa_quantidadetitulos", "a.bxa_situacao"};
    private static final String[] SITUACAO = new String[]{"Todas", "Exceto Estornada", Tipos.tipoSituacaoBaixa("Q"), Tipos.tipoSituacaoBaixa("A"), Tipos.tipoSituacaoBaixa("E")};
    private static final String[] TIPOBAIXA = new String[]{"Todas", Tipos.tipoBaixa("C"), Tipos.tipoBaixa("D")};
    private static final String[] CAMPOSBAIXA = new String[]{"codigoFilialBaixa", "codigoBaixa", "dataBaixa", "qtdeTitulosBaixa", "valorTotalBaixa", "valorJurosBaixa", "valorMultaBaixa", "valorAcrescimoBaixa", "valorDescontoBaixa", "valorTaxaBaixa", "codigoUsuarioBaixa", "codigoUsuarioCancelamentoBaixa", "situacaoBaixa", "dataCancelamentoBaixa", "valorIrrfBaixa", "valorIssBaixa", "valorPisBaixa", "valorCsllBaixa", "valorCofinsBaixa", "valorInssBaixa", "tipoBaixa", "valorTotalBaixaComSinal", "valorJurosBaixaComSinal", "valorMultaBaixaComSinal", "valorAcrescimoBaixaComSinal", "valorDescontoBaixaComSinal", "valorTaxaBaixaComSinal", "valorIrrfBaixaComSinal", "valorIssBaixaComSinal", "valorPisBaixaComSinal", "valorCsllBaixaComSinal", "valorCofinsBaixaComSinal", "valorInssBaixaComSinal", "dataHoraBaixa", "usuarioBaixa", "codigoMotivoCancelamentoBaixa", "descricaoMotivoCancelamentoBaixa", "descricaoCancelamentoBaixa", "valorSomatorioBaixaComSinal"};
    private static final String[] CAMPOSRECEBERPAGAR = new String[]{"codigoReceberPagar", "dataVencimentoReceberPagar", "valorReceberPagar", "tipoJurosReceberPagar", "tipoReceberPagar", "tipoDocumentoReceberPagar", "numeroDocumentoReceberPagar", "valorTaxaReceberPagar", "numeroParcelaReceberPagar", "codigoDocumentoReceberPagar", "dataDocumentoReceberPagar", "dataProcessamentoReceberPagar", "observacaoReceberPagar", "tipoCadastroReceberPagar", "codigoUsuarioReceberPagar", "nomeUsuarioReceberPagar", "codigoUsuarioCancelamentoReceberPagar", "nomeUsuarioCancelamentoReceberPagar", "dataCancelamentoReceberPagar", "situacaoReceberPagar", "valorJuroReceberPagar", "valorMultaReceberPagar", "valorComTaxaReceberPagar", "valorAcrescimoReceberPagar", "valorDescontoReceberPagar", "percentualMultaReceberPagar", "percentualJuroReceberPagar", "percentualAcrescimoReceberPagar", "percentualAcrescimoReceberPagar", "codigoSerie", "descricaoSerie", "valorIrrfReceberPagar", "percentualIrrfReceberPagar", "valorIssReceberPagar", "percentualIssReceberPagar", "valorPisReceberPagar", "percentualPisReceberPagar", "valorCsllReceberPagar", "percentualCsllReceberPagar", "valorCofinsReceberPagar", "percentualCofinsReceberPagar", "valorInssReceberPagar", "percentualInssReceberPagar", "dataCompetenciaReceberPagar", "valorImpostosReceberPagar", "valorTaxaTotalReceberPagar", "valorTotalReceberPagar", "valorReceberPagarComSinal", "valorTotalReceberPagarComSinal", "valorImpostosReceberPagarComSinal", "valorReceberPagarComImpostoComSinal"};
    private static final String[] CAMPOSCADASTRO = new String[]{"tipoLogradouroCadastro", "codigoCadastro", "fantasiaCadastro", "nomeSocialPaciente", "razaoSocialCadastro", "foneCadastro", "enderecoCadastro", "numeroEnderecoCadastro", "faxCadastro", "complementoCadastro", "cepCadastro", "codigoCidadeCadastro", "nomeCidadeCadastro"};
    private static final String FILTRO_FILIAL = "filtroFilial";
    private static final String FILTRO_USUARIO = "filtroUsuario";
    private static final String FILTRO_CONVENIO = "filtroConvenio";
    private static final String FILTRO_ENTIDADE = "filtroEntidade";
    private static final String FILTRO_PACIENTE = "filtroPaciente";
    private static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private static final String FILTRO_QTDE_TITULOS = "filtroQtdeTitulos";
    private static final String FILTRO_SITUACAO = "filtroSituacao";
    private static final String FILTRO_TIPO_BAIXA = "filtroTipoBaixa";
    private String[] campos;

    public RelatorioReceberPagarBaixaAcumulado() {
        this.montaBarraDescricao("Relat\u00f3rio de receber/pagar por baixa acumulado", "Listagem das contas a Receber e Pagar baixa acumulado no per\u00edodo", "relatorios/rel_financeiro_movimento-rec_pag_baixa_acumulado.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro(FILTRO_FILIAL, "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_USUARIO, "Usu\u00e1rio", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_CONVENIO, "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Nome Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_ENTIDADE, "Entidade", "entidade", "fil_codigo = " + Variaveis.filialPadrao + " and ent_inativo = false ", 1, new String[]{"ent_codigo", "ent_razaosocial"}, new String[]{"C\u00f3digo", "Raz\u00e3o Social"}, new int[]{70, 0});
        if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A") || Variaveis.tipoFilialPadrao.equalsIgnoreCase("V")) {
            this.adicionaItemFiltroAvancado(FILTRO_PACIENTE, "Paciente", "paciente", "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"pac_codigo", "pac_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0}, false, new int[]{70, 0});
        } else {
            this.adicionaItemFiltroAvancado(FILTRO_PACIENTE, "Paciente", "paciente", "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"pac_codigo", "pac_nome", "pac_nomesocial"}, new String[]{"C\u00f3digo", "Nome", "Nome Social"}, new int[]{70, 0, 0}, false, new int[]{70, 0, 0});
        }
        this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Data inicial:");
        this.adicionaFiltroData(FILTRO_DATA_FINAL, "Data final:");
        this.adicionaFiltroNumero(FILTRO_QTDE_TITULOS, "Qtde. T\u00edtulos:", 3);
        this.adicionaFiltroCombo(FILTRO_SITUACAO, "Situa\u00e7\u00e3o:", SITUACAO, 0);
        this.adicionaFiltroCombo(FILTRO_TIPO_BAIXA, "Tipo Baixa:", TIPOBAIXA, 0);
        this.setModuloConfigurar(RelatorioReceberPagarBaixaAcumulado.getModuloConfigurar());
        this.setModuloAcesso(RelatorioReceberPagarBaixaAcumulado.getModuloAcesso());
        this.campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, CAMPOSBAIXA);
        this.campos = ArraysUtil.concatenar(this.campos, CAMPOSCADASTRO);
        this.campos = ArraysUtil.concatenar(this.campos, CAMPOSRECEBERPAGAR);
        this.setCamposConfigurador(this.campos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        try {
            StringBuilder buf = new StringBuilder();
            buf.append(" select a.fil_codigo as codigoFilialBaixa, ");
            buf.append("        array_to_string(array_agg(distinct(filial.fil_codigo)), '') AS codigoFilial,                   ");
            buf.append("        array_to_string(array_agg(distinct(filial.fil_descricao)), '') AS descricaoFilial,             ");
            buf.append("        array_to_string(array_agg(distinct(filial.fil_cnpj)), '') AS cnpjFilial,                       ");
            buf.append("        array_to_string(array_agg(distinct(filial.fil_endereco)), '') AS enderecoFilial,               ");
            buf.append("        array_to_string(array_agg(distinct(filial.fil_complemento)), '') AS complementoFilial,         ");
            buf.append("        array_to_string(array_agg(distinct(filial.fil_cep)), '') AS cepFilial,                         ");
            buf.append("        array_to_string(array_agg(distinct(filial.fil_fone)), '') AS foneFilial,                       ");
            buf.append("        array_to_string(array_agg(distinct(filial.fil_fax)), '') AS faxFilial,                         ");
            buf.append("        array_to_string(array_agg(distinct(filial.fil_razaosocial)), '') AS razaoSocialFilial,         ");
            buf.append("        array_to_string(array_agg(distinct(filial.fil_cnes)), '') AS CNESFilial,                       ");
            buf.append("        array_to_string(array_agg(distinct(cidadefilial.cid_codigo)), '') AS codigoCidadeFilial,       ");
            buf.append("        array_to_string(array_agg(distinct(cidadefilial.cid_nome)), '') AS descricaoCidadeFilial,      ");
            buf.append("        array_to_string(array_agg(distinct(cidadefilial.cid_uf)), '') AS estadoCidadeFilial,           ");
            buf.append("        array_to_string(array_agg(distinct(bairrofilial.bai_codigo)), '') AS codigoBairroFilial,       ");
            buf.append("        array_to_string(array_agg(distinct(bairrofilial.bai_descricao)), '') AS descricaoBairroFilial ,");
            buf.append("        array_to_string(array_agg(distinct(a.bxa_codigo)), '') as codigoBaixa, ");
            buf.append("        array_to_string(array_agg(distinct(date_trunc('day', a.bxa_datahora))), '') as dataBaixa, ");
            buf.append("        sum(COALESCE(a.bxa_quantidadetitulos, 0)) as qtdeTitulosBaixa, ");
            buf.append("        sum(COALESCE(a.bxa_valortotal, 0)) as valorTotalBaixa, ");
            buf.append("        sum(COALESCE(a.bxa_valorjuros, 0)) as valorJurosBaixa, ");
            buf.append("        sum(COALESCE(a.bxa_valormultas, 0)) as valorMultaBaixa, ");
            buf.append("        sum(COALESCE(a.bxa_valoracrescimo, 0)) as valorAcrescimoBaixa, ");
            buf.append("        sum(COALESCE(a.bxa_valordescontos, 0)) as valorDescontoBaixa, ");
            buf.append("        sum(COALESCE(a.bxa_valortaxas, 0)) as valorTaxaBaixa, ");
            buf.append("        array_to_string(array_agg(distinct(a.usr_codigo)), '') as codigoUsuarioBaixa, ");
            buf.append("        array_to_string(array_agg(distinct(a.usr_codcancelado)), '') as codigoUsuariocancelamentoBaixa, ");
            buf.append("        array_to_string(array_agg(distinct(a.bxa_situacao)), '') as situacaoBaixa, ");
            buf.append("        array_to_string(array_agg(distinct(a.bxa_datacancelado)), '') as dataCancelamentoBaixa, ");
            buf.append("        sum(COALESCE(a.bxa_irrfvalor, 0)) as valorIrrfBaixa, ");
            buf.append("        sum(COALESCE(a.bxa_issvalor, 0)) as valorIssBaixa, ");
            buf.append("        sum(COALESCE(a.bxa_pisvalor, 0)) as valorPisBaixa, ");
            buf.append("        sum(COALESCE(a.bxa_csllvalor, 0)) as valorCsllBaixa, ");
            buf.append("        sum(COALESCE(a.bxa_cofinsvalor, 0)) as valorCofinsBaixa, ");
            buf.append("        sum(COALESCE(a.bxa_inssvalor, 0)) as valorInssBaixa, ");
            buf.append("        a.bxa_tipo as tipoBaixa, ");
            buf.append("        array_to_string(array_agg(distinct(a.bxa_datahora)), '') as dataHoraBaixa, ");
            buf.append("        array_to_string(array_agg(distinct(a.usr_codigo)), '') as usuarioBaixa, ");
            buf.append(" \t\t\t\tarray_to_string(array_agg(distinct(motCancBaixa.mov_codigo)), '') as codigoMotivoCancelamentoBaixa, ");
            buf.append(" \t\t\t\tarray_to_string(array_agg(distinct(motCancBaixa.mov_descricao)), '') as descricaoMotivoCancelamentoBaixa, ");
            buf.append(" \t\t\t\tarray_to_string(array_agg(distinct(a.bxa_descricaocancelamento)), '') as descricaoCancelamentoBaixa, ");
            buf.append("        sum(CASE WHEN a.bxa_tipo = 'C' THEN a.bxa_valortotal ELSE a.bxa_valortotal * (-1) END) as valorTotalBaixaComSinal, ");
            buf.append("        sum(CASE WHEN a.bxa_tipo = 'C' THEN a.bxa_valorjuros ELSE a.bxa_valorjuros * (-1) END) as valorJurosBaixaComSinal, ");
            buf.append("        sum(CASE WHEN a.bxa_tipo = 'C' THEN a.bxa_valormultas ELSE a.bxa_valormultas * (-1) END) as valorMultaBaixaComSinal, ");
            buf.append("        sum(CASE WHEN a.bxa_tipo = 'C' THEN a.bxa_valoracrescimo ELSE a.bxa_valoracrescimo * (-1) END) as valorAcrescimoBaixaComSinal, ");
            buf.append("        sum(CASE WHEN a.bxa_tipo = 'C' THEN a.bxa_valordescontos * (-1) ELSE a.bxa_valordescontos END) as valorDescontoBaixaComSinal, ");
            buf.append("        sum(CASE WHEN a.bxa_tipo = 'C' THEN a.bxa_valortaxas ELSE a.bxa_valortaxas * (-1) END) as valorTaxaBaixaComSinal, ");
            buf.append("        sum(CASE WHEN a.bxa_tipo = 'C' THEN a.bxa_irrfvalor * (-1) ELSE a.bxa_irrfvalor * (-1) END) as valorIrrfBaixaComSinal, ");
            buf.append("        sum(CASE WHEN a.bxa_tipo = 'C' THEN a.bxa_issvalor * (-1) ELSE a.bxa_issvalor * (-1) END) as valorIssBaixaComSinal, ");
            buf.append("        sum(CASE WHEN a.bxa_tipo = 'C' THEN a.bxa_pisvalor * (-1) ELSE a.bxa_pisvalor * (-1) END) as valorPisBaixaComSinal, ");
            buf.append("        sum(CASE WHEN a.bxa_tipo = 'C' THEN a.bxa_csllvalor * (-1) ELSE a.bxa_csllvalor * (-1) END) as valorCsllBaixaComSinal, ");
            buf.append("        sum(CASE WHEN a.bxa_tipo = 'C' THEN a.bxa_cofinsvalor * (-1) ELSE a.bxa_cofinsvalor * (-1) END) as valorCofinsBaixaComSinal, ");
            buf.append("        sum(CASE WHEN a.bxa_tipo = 'C' THEN a.bxa_inssvalor * (-1) ELSE a.bxa_inssvalor * (-1) END) as valorInssBaixaComSinal, ");
            buf.append("        sum(CASE WHEN rpg.rpg_tipo = 'R' THEN rpg.rpg_valortotal ELSE rpg.rpg_valortotal * (-1) END) as valorTotalReceberPagarComSinal, ");
            buf.append("        sum(CASE WHEN rpg.rpg_tipo = 'R' THEN rpg.rpg_valor ELSE rpg.rpg_valor * (-1) END) as valorReceberPagarComSinal, ");
            buf.append("        sum(COALESCE(rpg.rpg_valortotal, 0)) as valorTotalReceberPagar, ");
            buf.append("        sum(COALESCE(rpg.rpg_valor, 0)) as valorReceberPagar, ");
            buf.append("        sum(COALESCE(rpg.rpg_taxa, 0)) as valorTaxaReceberPagar, ");
            buf.append("        sum(COALESCE(rpg.rpg_valoracrescimo, 0)) as valorAcrescimoReceberPagar, ");
            buf.append("        sum(COALESCE(rpg.rpg_valordesconto, 0)) as valorDescontoReceberPagar, ");
            buf.append("        array_to_string(array_agg(distinct(rpg.rpg_codigo)), '') as codigoReceberPagar, ");
            buf.append("        array_to_string(array_agg(distinct(rpg.rpg_vencimento)), '') as dataVencimentoReceberPagar, ");
            buf.append("        array_to_string(array_agg(distinct(rpg.rpg_competencia)), '') as dataCompetenciaReceberPagar, ");
            buf.append("        array_to_string(array_agg(distinct(rpg.rpg_tipojuros)), '') as tipoJurosReceberPagar, ");
            buf.append("        array_to_string(array_agg(distinct(rpg.rpg_tipo)), '') as tipoReceberPagar, ");
            buf.append("        array_to_string(array_agg(distinct(rpg.rpg_tipodocumento)), '') as tipoDocumentoReceberPagar, ");
            buf.append("        array_to_string(array_agg(distinct(rpg.rpg_numerodocumento)), '') as numeroDocumentoReceberPagar, ");
            buf.append("        array_to_string(array_agg(distinct(rpg.rpg_parcela)), '') as numeroParcelaReceberPagar, ");
            buf.append("        array_to_string(array_agg(distinct(rpg.rpg_codigodocumento)), '') as codigoDocumentoReceberPagar, ");
            buf.append("        array_to_string(array_agg(distinct(rpg.rpg_datadocumento)), '') as dataDocumentoReceberPagar, ");
            buf.append("        array_to_string(array_agg(distinct(rpg.rpg_dataprocessamento)), '') as dataProcessamentoReceberPagar, ");
            buf.append("        array_to_string(array_agg(distinct(rpg.rpg_obs)), '') as observacaoReceberPagar, ");
            buf.append("        array_to_string(array_agg(distinct(rpg.rpg_tipocadastro)), '') as tipoCadastroReceberPagar, ");
            buf.append("        array_to_string(array_agg(distinct(usrrecpag.usr_codigo)), '') as codigoUsuarioReceberPagar, ");
            buf.append("        array_to_string(array_agg(distinct(usrrecpag.usr_nome)), '') as nomeUsuarioReceberPagar, ");
            buf.append("        array_to_string(array_agg(distinct(usuariocancela.usr_codigo)), '') as codigoUsuarioCancelamentoReceberPagar, ");
            buf.append("        array_to_string(array_agg(distinct(usuariocancela.usr_nome)), '') as nomeUsuarioCancelamentoReceberPagar, ");
            buf.append("        array_to_string(array_agg(distinct(rpg.rpg_datacancelado)), '') as dataCancelamentoReceberPagar, ");
            buf.append("        array_to_string(array_agg(distinct(rpg.rpg_situacao)), '') as situacaoReceberPagar, ");
            buf.append("        sum(COALESCE(rpg.rpg_valor, 0) + COALESCE(rpg.rpg_taxa, 0)) as valorComTaxaReceberPagar, ");
            buf.append("        sum(COALESCE(rpg.rpg_valorjuro, 0)) as valorJuroReceberPagar, ");
            buf.append("        sum(COALESCE(rpg.rpg_valormulta, 0)) as valorMultaReceberPagar, ");
            buf.append("        sum(COALESCE(rpg.rpg_percentualmulta, 0)) as percentualMultaReceberPagar, ");
            buf.append("        sum(COALESCE(rpg.rpg_percentualjuro, 0)) as percentualJuroReceberPagar, ");
            buf.append("        sum(COALESCE(rpg.rpg_percentualacrescimo, 0)) as percentualAcrescimoReceberPagar, ");
            buf.append("        sum(COALESCE(rpg.rpg_percentualdesconto, 0)) as percentualDescontoReceberPagar, ");
            buf.append("        sum(COALESCE(rpg.rpg_irrfvalor, 0)) as valorIrrfReceberPagar, ");
            buf.append("        sum(COALESCE(rpg.rpg_irrfpercentual, 0)) as percentualIrrfReceberPagar, ");
            buf.append("        sum(COALESCE(rpg.rpg_issvalor, 0)) as valorIssReceberPagar, ");
            buf.append("        sum(COALESCE(rpg.rpg_isspercentual, 0)) as percentualIssReceberPagar, ");
            buf.append("        sum(COALESCE(rpg.rpg_pisvalor, 0)) as valorPisReceberPagar, ");
            buf.append("        sum(COALESCE(rpg.rpg_pispercentual, 0)) as percentualPisReceberPagar, ");
            buf.append("        sum(COALESCE(rpg.rpg_csllvalor, 0)) as valorCsllReceberPagar, ");
            buf.append("        sum(COALESCE(rpg.rpg_csllpercentual, 0)) as percentualCsllReceberPagar, ");
            buf.append("        sum(COALESCE(rpg.rpg_cofinsvalor, 0)) as valorCofinsReceberPagar, ");
            buf.append("        sum(COALESCE(rpg.rpg_cofinspercentual, 0)) as percentualCofinsReceberPagar, ");
            buf.append("        sum(COALESCE(rpg.rpg_inssvalor, 0)) as valorInssReceberPagar, ");
            buf.append("        sum(COALESCE(rpg.rpg_insspercentual, 0)) as percentualInssReceberPagar, ");
            buf.append("        sum(COALESCE( ");
            buf.append("           (case when rpg.nfi_codigo is null then ");
            buf.append("                 COALESCE(rpg.rpg_irrfvalor, 0) + COALESCE(rpg.rpg_issvalor, 0) + COALESCE(rpg.rpg_pisvalor, 0) + COALESCE(rpg.rpg_csllvalor, 0) + COALESCE(rpg.rpg_cofinsvalor, 0) + COALESCE(rpg.rpg_inssvalor, 0) + COALESCE(rpg.rpg_icmsvalor,0) + COALESCE(rpg.rpg_ipivalor,0) ");
            buf.append("            else ");
            buf.append("                 COALESCE(nfi.nfi_irrfvalor, 0) + COALESCE(nfi.nfi_issvalor, 0) + COALESCE(nfi.nfi_pisvalor, 0) + COALESCE(nfi.nfi_csllvalor, 0) + COALESCE(nfi.nfi_cofinsvalor, 0) + COALESCE(nfi.nfi_inssvalor, 0) + COALESCE(nfi.nfi_icmsvalor,0) + COALESCE(nfi.nfi_ipivalor,0) ");
            buf.append("           end), 0)) as valorImpostosReceberPagar, ");
            buf.append("        sum(COALESCE( ");
            buf.append("           (case when rpg.nfi_codigo is null then ");
            buf.append("                 COALESCE(rpg.rpg_irrfvalor, 0) + COALESCE(rpg.rpg_issvalor, 0) + COALESCE(rpg.rpg_pisvalor, 0) + COALESCE(rpg.rpg_csllvalor, 0) + COALESCE(rpg.rpg_cofinsvalor, 0) + COALESCE(rpg.rpg_inssvalor, 0) + COALESCE(rpg.rpg_icmsvalor,0) + COALESCE(rpg.rpg_ipivalor,0) ");
            buf.append("            else ");
            buf.append("                 COALESCE(nfi.nfi_irrfvalor, 0) + COALESCE(nfi.nfi_issvalor, 0) + COALESCE(nfi.nfi_pisvalor, 0) + COALESCE(nfi.nfi_csllvalor, 0) + COALESCE(nfi.nfi_cofinsvalor, 0) + COALESCE(nfi.nfi_inssvalor, 0) + COALESCE(nfi.nfi_icmsvalor,0) + COALESCE(nfi.nfi_ipivalor,0) ");
            buf.append("           end), 0))  as valorImpostosReceberPagarComSinal, ");
            buf.append("        sum(COALESCE(rpg.rpg_valormulta, 0) + COALESCE(rpg.rpg_valoracrescimo, 0) + COALESCE(rpg.rpg_valorjuro, 0) + COALESCE(rpg.rpg_taxa, 0)) as valorTaxaTotalReceberPagar, ");
            buf.append("        array_to_string(array_agg(distinct(rpg.ser_codigo)), '') as codigoSerie,");
            buf.append("\t\t    array_to_string(array_agg(distinct(ser.ser_descricao)), '') as descricaoSerie, ");
            buf.append("        array_to_string(array_agg(distinct(case ");
            buf.append("          when rpg.rpg_tipocadastro = '").append("O").append("' then rpg.con_codigo ");
            buf.append("          when rpg.rpg_tipocadastro = '").append("P").append("' then rpg.pac_codigo ");
            buf.append("          when rpg.rpg_tipocadastro = '").append("U").append("' then rpg.ent_codigo ");
            buf.append("          when rpg.rpg_tipocadastro = '").append("F").append("' then rpg.ent_codigo ");
            buf.append("          when rpg.rpg_tipocadastro = '").append("C").append("' then rpg.ent_codigo ");
            buf.append("          when rpg.rpg_tipocadastro = '").append("R").append("' then rpg.ent_codigo ");
            buf.append("          else rpg.ent_codigo ");
            buf.append("        end)), '') as codigoCadastro, ");
            buf.append("        array_to_string(array_agg(distinct(case ");
            buf.append("          when rpg.pac_codigo is not null then pac.pac_nome ");
            buf.append("          when rpg.ent_codigo is not null then ent.ent_fantasia ");
            buf.append("          else con.con_fantasia ");
            buf.append("        end)), '') as fantasiaCadastro, ");
            buf.append("        array_to_string(array_agg(distinct(case ");
            buf.append("          when rpg.pac_codigo is not null then pac.pac_nomesocial ");
            buf.append("          else '' ");
            buf.append("        end)), '') as nomeSocialPaciente, ");
            buf.append("        array_to_string(array_agg(distinct(case ");
            buf.append("          when rpg.pac_codigo is not null then pac.pac_nome ");
            buf.append("          when rpg.ent_codigo is not null then ent.ent_razaosocial ");
            buf.append("          else con.con_razao ");
            buf.append("        end)), '') as razaoSocialCadastro, ");
            buf.append("        array_to_string(array_agg(distinct(case ");
            buf.append("          when rpg.pac_codigo is not null then pac.pac_fone ");
            buf.append("          when rpg.ent_codigo is not null then ent.ent_fone ");
            buf.append("          else con.con_fone ");
            buf.append("        end)), '') as foneCadastro, ");
            buf.append("        array_to_string(array_agg(distinct(case ");
            buf.append("          when rpg.pac_codigo is not null then pac.pac_numeroendereco ");
            buf.append("          when rpg.ent_codigo is not null then ent.ent_numeroendereco ");
            buf.append("          else con.con_numeroendereco ");
            buf.append("        end)), '') as numeroEnderecoCadastro, ");
            buf.append("        array_to_string(array_agg(distinct(case ");
            buf.append("          when rpg.pac_codigo is not null then pac.pac_endereco ");
            buf.append("          when rpg.ent_codigo is not null then ent.ent_endereco ");
            buf.append("          else con.con_endereco ");
            buf.append("        end)), '') as enderecoCadastro, ");
            buf.append("        array_to_string(array_agg(distinct(case ");
            buf.append("          when rpg.pac_codigo is not null then pac.pac_tipologradouroendereco ");
            buf.append("          when rpg.ent_codigo is not null then ent.ent_tipologradouroendereco ");
            buf.append("          else con.con_tipologradouroendereco ");
            buf.append("        end)), '') as tipoLogradouroCadastro, ");
            buf.append("        array_to_string(array_agg(distinct(case ");
            buf.append("          when rpg.pac_codigo is not null then pac.pac_fax ");
            buf.append("          when rpg.ent_codigo is not null then ent.ent_fax ");
            buf.append("          else con.con_fax ");
            buf.append("        end)), '') as faxCadastro, ");
            buf.append("        array_to_string(array_agg(distinct(case ");
            buf.append("          when rpg.pac_codigo is not null then pac.pac_complemento ");
            buf.append("          when rpg.ent_codigo is not null then ent.ent_complemento ");
            buf.append("          else con.con_complemento ");
            buf.append("        end)), '') as complementoCadastro, ");
            buf.append("        array_to_string(array_agg(distinct(case ");
            buf.append("          when rpg.pac_codigo is not null then pac.pac_cep ");
            buf.append("          when rpg.ent_codigo is not null then ent.ent_cep ");
            buf.append("          else con.con_cep ");
            buf.append("        end)), '') as cepCadastro ");
            buf.append("        from baixa a ");
            buf.append("            left join motivoscancelamentos motCancBaixa on (a.fil_codigo = motCancBaixa.fil_codigo and a.mov_codigo = motCancBaixa.mov_codigo) ");
            buf.append("            left join baixareceberpagar brp on (a.fil_codigo = brp.fil_codigo and a.bxa_codigo = brp.bxa_codigo) ");
            buf.append("        \t  join receberpagar rpg on (brp.fil_codigo = rpg.fil_codigo and brp.rpg_codigo = rpg.rpg_codigo and rpg.rpg_situacao = '").append("Q").append("') ");
            buf.append("            left join usuario usuariocancela on rpg.usr_codcancelado = usuariocancela.usr_codigo ");
            buf.append("            left join usuario usrrecpag on rpg.usr_codigo = usrrecpag.usr_codigo ");
            buf.append("            left join series ser on (rpg.fil_codigo = ser.fil_codigo and rpg.ser_codigo = ser.ser_codigo) ");
            buf.append("            left join entidade ent on (rpg.fil_codigo = ent.fil_codigo and rpg.ent_codigo = ent.ent_codigo) ");
            buf.append("            left join convenios con on (rpg.fil_codigo = con.fil_codigo and rpg.con_codigo = con.con_codigo) ");
            buf.append("            left join paciente pac on (rpg.fil_codigo = pac.fil_codigo and rpg.pac_codigo = pac.pac_codigo) ");
            buf.append("            left join notafiscal nfi on (rpg.fil_codigo = nfi.fil_codigo and rpg.nfi_codigo = nfi.nfi_codigo) ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            buf.append(" where a.fil_codigo ");
            String filiais = this.getSelecionadosFiltroValores(FILTRO_FILIAL, 0, false, false);
            if (filiais == null) {
                buf.append(" = ").append(Variaveis.filialPadrao);
            } else {
                buf.append(" in (");
                buf.append(filiais);
                buf.append(")");
            }
            this.getSelecionadosFiltroValoresConcat(FILTRO_USUARIO, 0, buf, "and a.usr_codigo in", false, true);
            this.getSelecionadosFiltroValoresConcat(FILTRO_CONVENIO, 0, buf, "and rpg.con_codigo in", false, false);
            this.getSelecionadosFiltroValoresConcat(FILTRO_ENTIDADE, 0, buf, "and rpg.ent_codigo in", false, false);
            this.getSelecionadosFiltroValoresConcat(FILTRO_PACIENTE, 0, buf, "and rpg.pac_codigo in", true, false);
            if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_INICIAL))) {
                buf.append(" and cast(a.bxa_datahora as date) >= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData(FILTRO_DATA_INICIAL)));
                buf.append("'");
            }
            if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_FINAL))) {
                buf.append(" and cast(a.bxa_datahora as date) <= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData(FILTRO_DATA_FINAL)));
                buf.append("'");
            }
            if (!Funcoes.textoVazio(this.getFiltroNumero(FILTRO_QTDE_TITULOS))) {
                buf.append(" and a.bxa_quantidadetitulos = ").append(this.getFiltroNumero(FILTRO_QTDE_TITULOS)).append(" ");
            }
            if (this.getFiltroCombo(FILTRO_SITUACAO).equals(SITUACAO[1])) {
                buf.append(" and a.bxa_situacao IN ('").append("Q").append("', '").append("A").append("') ");
            }
            if (this.getFiltroCombo(FILTRO_SITUACAO).equals(SITUACAO[2])) {
                buf.append(" and a.bxa_situacao = '").append("Q").append("' ");
            } else if (this.getFiltroCombo(FILTRO_SITUACAO).equals(SITUACAO[3])) {
                buf.append(" and a.bxa_situacao = '").append("A").append("' ");
            } else if (this.getFiltroCombo(FILTRO_SITUACAO).equals(SITUACAO[4])) {
                buf.append(" and a.bxa_situacao = '").append("E").append("' ");
            }
            if (this.getFiltroCombo(FILTRO_TIPO_BAIXA).equals(TIPOBAIXA[1])) {
                buf.append(" and a.bxa_tipo = '").append("C").append("' ");
            } else if (this.getFiltroCombo(FILTRO_TIPO_BAIXA).equals(TIPOBAIXA[2])) {
                buf.append(" and a.bxa_tipo = '").append("D").append("' ");
            }
            buf.append(this.getAgrupamento());
            buf.append(" order by a.fil_codigo, a.bxa_tipo, (case ");
            buf.append("      when rpg.rpg_tipocadastro = '").append("O").append("' then rpg.con_codigo ");
            buf.append("      when rpg.rpg_tipocadastro = '").append("P").append("' then rpg.pac_codigo ");
            buf.append("      when rpg.rpg_tipocadastro = '").append("U").append("' then rpg.ent_codigo ");
            buf.append("      when rpg.rpg_tipocadastro = '").append("F").append("' then rpg.ent_codigo ");
            buf.append("      when rpg.rpg_tipocadastro = '").append("C").append("' then rpg.ent_codigo ");
            buf.append("      when rpg.rpg_tipocadastro = '").append("R").append("' then rpg.ent_codigo ");
            buf.append("          else rpg.ent_codigo end) ");
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                HashMap<String, Object> var;
                Gerador gerador;
                ModeloGridTable modelo = new ModeloGridTable(this.campos);
                do {
                    Object[] o = new Object[this.campos.length];
                    for (int i = 0; i < this.campos.length; ++i) {
                        if (this.campos[i].equalsIgnoreCase("tipoLogradouroCadastro")) {
                            o[i] = Tipos.tipoLogradouroDescricao(rs.getString(this.campos[i]));
                            continue;
                        }
                        if (this.campos[i].equals("situacaoBaixa")) {
                            o[i] = Tipos.tipoSituacaoBaixa(rs.getString(this.campos[i]));
                            continue;
                        }
                        if (this.campos[i].equals("tipoReceberPagar")) {
                            o[i] = Tipos.tipoReceberPagar(rs.getString(this.campos[i]));
                            continue;
                        }
                        if (this.campos[i].equals("tipoDocumentoReceberPagar")) {
                            o[i] = Tipos.tipoDocumento(rs.getString(this.campos[i]));
                            continue;
                        }
                        if (this.campos[i].equals("situacaoReceberPagar")) {
                            o[i] = Tipos.tipoSituacaoReceberPagar(rs.getString(this.campos[i]));
                            continue;
                        }
                        if (this.campos[i].equals("tipoCadastroReceberPagar")) {
                            o[i] = Tipos.tipoCadastro(rs.getString(this.campos[i]));
                            continue;
                        }
                        if (this.campos[i].equals("tipoLancamento")) {
                            o[i] = Tipos.tipoLancamentoCaixa(rs.getString(this.campos[i]));
                            continue;
                        }
                        if (this.campos[i].equals("tipoDocumentoLancamento")) {
                            o[i] = Tipos.tipoDocumento(rs.getString(this.campos[i]));
                            continue;
                        }
                        if (this.campos[i].equals("tipoUltimoPagamentoRequisicao") || this.campos[i].equals("tipoPagamentoLancamento")) {
                            o[i] = Tipos.tipoPagamento(rs.getString(this.campos[i]));
                            continue;
                        }
                        if (this.campos[i].equals("situacaoLancamento")) {
                            o[i] = Tipos.tipoSituacaoLancamento(rs.getString(this.campos[i]));
                            continue;
                        }
                        if (this.campos[i].equals("tipoBaixa")) {
                            o[i] = Tipos.tipoBaixa(rs.getString(this.campos[i]));
                            continue;
                        }
                        if (this.campos[i].equals("valorSomatorioBaixaComSinal")) {
                            o[i] = rs.getBigDecimal("valorTotalBaixa").divide(rs.getBigDecimal("qtdeTitulosBaixa") == null ? BigDecimal.ONE : rs.getBigDecimal("qtdeTitulosBaixa"), this.ROUND);
                            if (!rs.getString("tipoBaixa").equalsIgnoreCase("D")) continue;
                            o[i] = ((BigDecimal)o[i]).multiply(new BigDecimal(-1));
                            continue;
                        }
                        if (this.campos[i].equals("valorImpostosReceberPagarComSinal")) {
                            o[i] = rs.getBigDecimal("valorImpostosReceberPagarComSinal");
                            if (!rs.getString("tipoBaixa").equalsIgnoreCase("D")) continue;
                            o[i] = ((BigDecimal)o[i]).multiply(new BigDecimal(-1));
                            continue;
                        }
                        if (this.campos[i].equals("valorImpostosReceberPagar")) {
                            o[i] = rs.getBigDecimal("valorImpostosReceberPagar");
                            if (!rs.getString("tipoBaixa").equalsIgnoreCase("D")) continue;
                            o[i] = ((BigDecimal)o[i]).multiply(new BigDecimal(-1));
                            continue;
                        }
                        if (this.campos[i].equals("valorReceberPagarComImpostoComSinal")) {
                            o[i] = rs.getBigDecimal("valorReceberPagarComSinal");
                            if (!rs.getString("tipoBaixa").equalsIgnoreCase("D")) continue;
                            o[i] = ((BigDecimal)o[i]).add(rs.getBigDecimal("valorImpostosReceberPagarComSinal").multiply(new BigDecimal(-1)));
                            continue;
                        }
                        boolean campoCadastro = false;
                        for (int j = 0; j < CAMPOSCADASTRO.length; ++j) {
                            if (!this.campos[i].equals(CAMPOSCADASTRO[j])) continue;
                            campoCadastro = true;
                            break;
                        }
                        if (campoCadastro) continue;
                        o[i] = rs.getObject(this.campos[i]);
                    }
                    this.pegaDadosCadastro(st2, o, modelo, rs.getString("tipoCadastroReceberPagar"), rs.getInt("codigoFilial"), rs.getInt("codigoCadastro"));
                    modelo.addLine(o);
                } while (rs.next());
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = " + this.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioReceberPagarBaixaAcumulado.this.panelCentro.removeAll();
                            RelatorioReceberPagarBaixaAcumulado.this.panelCentro.repaint();
                            RelatorioReceberPagarBaixaAcumulado.this.habilitaBotaoImprimir(true);
                        }
                    });
                    var = new HashMap<String, Object>();
                    var.put(FILTRO_DATA_INICIAL, this.getFiltroData(FILTRO_DATA_INICIAL));
                    var.put(FILTRO_DATA_FINAL, this.getFiltroData(FILTRO_DATA_FINAL));
                    var.put(FILTRO_QTDE_TITULOS, this.getFiltroData(FILTRO_QTDE_TITULOS));
                    var.put(FILTRO_SITUACAO, this.getFiltroCombo(FILTRO_SITUACAO));
                    var.put(FILTRO_TIPO_BAIXA, this.getFiltroCombo(FILTRO_TIPO_BAIXA));
                    if (filiais != null) {
                        var.put(FILTRO_FILIAL, this.getSelecionadosFiltroValores(FILTRO_FILIAL, 0, false, false));
                    } else {
                        var.put(FILTRO_FILIAL, Variaveis.filialPadrao);
                    }
                } else {
                    Funcoes.mensagem(this, "O relat\u00f3rio n\u00e3o possui layout.", 2);
                    this.habilitaBotaoImprimir(true);
                    return;
                }
                var.put(FILTRO_USUARIO, this.getSelecionadosFiltroValores(FILTRO_USUARIO, 0, false, false));
                var.put(FILTRO_ENTIDADE, this.getSelecionadosFiltroValores(FILTRO_ENTIDADE, 0, false, false));
                var.put(FILTRO_PACIENTE, this.getSelecionadosFiltroValores(FILTRO_PACIENTE, 0, true, false));
                var.put(FILTRO_CONVENIO, this.getSelecionadosFiltroValores(FILTRO_CONVENIO, 0, false, false));
                var.put(FILTRO_USUARIO, this.getSelecionadosFiltroValores(FILTRO_USUARIO, 0, false, false));
                gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                this.panelCentro.revalidate();
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
            Conexao.fecharStatement(st);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void pegaDadosCadastro(Statement st, Object[] array, ModeloGridTable modelo, String tipo, int filial, int codigo) throws SQLException {
        StringBuilder buf = new StringBuilder();
        if (tipo == null) {
            return;
        }
        if (tipo.equalsIgnoreCase("P")) {
            buf.append("select ");
            buf.append("\tpac.pac_codigo as codigoCadastro, pac.pac_nome as fantasiaCadastro,pac.pac_nomesocial as nomeSocialPaciente, pac.pac_nome as razaoSocialCadastro, pac.pac_fone as foneCadastro, ");
            buf.append("\tpac.pac_endereco as enderecoCadastro, pac.pac_numeroendereco as numeroEnderecoCadastro, pac.pac_tipologradouroendereco as tipoLogradouroCadastro, ");
            buf.append("\tpac.pac_fax as faxCadastro, pac.pac_complemento as complementoCadastro, pac.pac_cep as cepCadastro, ");
            buf.append("\tpac.cid_codigo as codigoCidadeCadastro, cidpac.cid_nome as nomeCidadeCadastro ");
            buf.append("from paciente pac ");
            buf.append("\tleft join cidades cidpac on pac.fil_codigo = cidpac.fil_codigo and pac.cid_codigo = cidpac.cid_codigo ");
            buf.append("where pac.fil_codigo = ").append(filial);
            buf.append(" and pac.pac_codigo = ").append(codigo);
        } else if (tipo.equalsIgnoreCase("O")) {
            buf.append("select ");
            buf.append("\tcon.con_codigo as codigoCadastro, con.con_fantasia as fantasiaCadastro, '' as nomeSocialPaciente, con.con_razao as razaoSocialCadastro, con.con_fone as foneCadastro, ");
            buf.append("\tcon.con_endereco as enderecoCadastro, con.con_numeroendereco as numeroEnderecoCadastro, con.con_tipologradouroendereco as tipoLogradouroCadastro, ");
            buf.append("\tcon.con_fax as faxCadastro, con.con_complemento as complementoCadastro, con.con_cep as cepCadastro, ");
            buf.append("\tcon.cid_codigo as codigoCidadeCadastro, cidcon.cid_nome as nomeCidadeCadastro ");
            buf.append("from convenios con ");
            buf.append("\tleft join cidades cidcon on con.fil_codigo = cidcon.fil_codigo and con.cid_codigo = cidcon.cid_codigo ");
            buf.append("where con.fil_codigo = ").append(filial);
            buf.append(" and con.con_codigo = ").append(codigo);
        } else {
            buf.append("select ");
            buf.append("\tent.ent_codigo as codigoCadastro, ent.ent_fantasia as fantasiaCadastro, '' as nomeSocialPaciente, ent.ent_razaosocial as razaoSocialCadastro, ent.ent_fone as foneCadastro, ");
            buf.append("\tent.ent_endereco as enderecoCadastro, ent.ent_numeroendereco as numeroEnderecoCadastro, ent.ent_tipologradouroendereco as tipoLogradouroCadastro, ");
            buf.append("\tent.ent_fax as faxCadastro, ent.ent_complemento as complementoCadastro, ent.ent_cep as cepCadastro, ");
            buf.append("\tent.cid_codigo as codigoCidadeCadastro, cident.cid_nome as nomeCidadeCadastro ");
            buf.append("from entidade ent ");
            buf.append("\tleft join cidades cident on ent.fil_codigo = cident.fil_codigo and ent.cid_codigo = cident.cid_codigo ");
            buf.append("where ent.fil_codigo = ").append(filial);
            buf.append(" and ent.ent_codigo = ").append(codigo);
        }
        ResultSet rs = Conexao.executeQuery(st, buf);
        if (rs.next()) {
            int pos = -1;
            for (String s : CAMPOSCADASTRO) {
                if (rs.findColumn(s) <= 0 || modelo.findColumn(s) <= -1) continue;
                pos = modelo.findColumn(s);
                array[modelo.findColumn((String)s)] = modelo.getColumnName(pos).equalsIgnoreCase("tipoLogradouroCadastro") ? Tipos.tipoLogradouroDescricao(rs.getString(modelo.getColumnName(pos))) : rs.getObject(s);
            }
        }
    }

    public String getAgrupamento() {
        StringBuilder buf = new StringBuilder();
        buf.append(" group by a.fil_codigo, a.bxa_tipo, (case ");
        buf.append("      when rpg.rpg_tipocadastro = '").append("O").append("' then rpg.con_codigo ");
        buf.append("      when rpg.rpg_tipocadastro = '").append("P").append("' then rpg.pac_codigo ");
        buf.append("      when rpg.rpg_tipocadastro = '").append("U").append("' then rpg.ent_codigo ");
        buf.append("      when rpg.rpg_tipocadastro = '").append("F").append("' then rpg.ent_codigo ");
        buf.append("      when rpg.rpg_tipocadastro = '").append("C").append("' then rpg.ent_codigo ");
        buf.append("      when rpg.rpg_tipocadastro = '").append("R").append("' then rpg.ent_codigo ");
        buf.append("          else rpg.ent_codigo end) ");
        return buf.toString();
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0852400100");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0852400101");
    }
}

