/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.movimento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioReceberPagarApoio
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String[] ordem = new String[]{"Documento", "C\u00f3digo", "Data + Hora", "Usu\u00e1rio", "Vencimento", "Cadastro"};
    private final String[] CAMPOSBANCOORDEM = new String[]{"rpg_numerodocumento", "rpg_codigo", "rpg_dataHora", "usr_codigo", "rpg_vencimento"};
    private final String[] ordemAgrupamento = new String[]{"Nome/Fantasia", "C\u00f3digo"};
    private final String[] tipo = new String[]{"Todos", Tipos.tipoReceberPagar("P"), Tipos.tipoReceberPagar("R")};
    private final String[] tipoCadastro = new String[]{"Todos", Tipos.tipoCadastro("U"), Tipos.tipoCadastro("F"), Tipos.tipoCadastro("C"), Tipos.tipoCadastro("R"), Tipos.tipoCadastro("P"), Tipos.tipoCadastro("O")};
    private final String[] tipoDocumento = new String[]{"Todos", Tipos.tipoDocumento("B"), Tipos.tipoDocumento("D"), Tipos.tipoDocumento("C"), Tipos.tipoDocumento("A")};
    private final String[] CAMPOSDATA = new String[]{"Vencimento", "Compet\u00eancia", "Cadastro"};
    private final String[] CAMPOSDATABANCO = new String[]{"rpg_vencimento", "rpg_competencia", "rpg_datahora"};
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_USUARIO = "filtroUsuario";
    private final String FILTRO_DATA_INI = "filtroDataInicial";
    private final String FILTRO_DATA_FIM = "filtroDataFinal";
    private final String FILTRO_ORDEM = "filtroOrdemRelatorio";
    private final String FILTRO_TIPO = "filtroTipo";
    private final String FILTRO_TIPO_DOCUMENTO = "filtroTipoDocumento";
    private final String FILTRO_NUMERO_DOCUMENTO = "filtroNumeroDocumento";
    private final String FILTRO_VALOR_INICIAL = "filtroValorInicial";
    private final String FILTRO_VALOR_FINAL = "filtroValorFinal";
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_PACIENTE = "filtroPaciente";
    private final String FILTRO_ORDEM_AGRUPAMENTO = "filtroOrdemAgrupamento";
    private final String FILTRO_CAMPO_DATA = "filtroCampoData";
    private static final String[] camposCadastros = new String[]{"codigoCadastro", "fantasiaCadastro", "razaoSocialCadastro", "foneCadastro", "enderecoCadastro", "numeroEnderecoCadastro", "faxCadastro", "complementoCadastro", "cepCadastro", "codigoCidadeCadastro", "nomeCidadeCadastro"};
    private static final String[] camposRelatorio = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoReceberPagar", "dataHoraReceberPagar", "dataVencimentoReceberPagar", "valorReceberPagar", "tipoJurosReceberPagar", "tipoReceberPagar", "tipoDocumentoReceberPagar", "numeroDocumentoReceberPagar", "valorTaxaReceberPagar", "numeroParcelaReceberPagar", "codigoDocumentoReceberPagar", "dataDocumentoReceberPagar", "dataProcessamentoReceberPagar", "observacaoReceberPagar", "tipoCadastroReceberPagar", "codigoUsuarioReceberPagar", "nomeUsuarioReceberPagar", "codigoUsuarioCancelamentoReceberPagar", "nomeUsuarioCancelamentoReceberPagar", "dataCancelamentoReceberPagar", "situacaoReceberPagar", "valorJuroReceberPagar", "valorMultaReceberPagar", "valorComTaxaReceberPagar", "valorAcrescimoReceberPagar", "valorDescontoReceberPagar", "percentualMultaReceberPagar", "percentualJuroReceberPagar", "percentualAcrescimoReceberPagar", "percentualAcrescimoReceberPagar", "codigoSerie", "descricaoSerie", "valorIrrfReceberPagar", "percentualIrrfReceberPagar", "valorIssReceberPagar", "percentualIssReceberPagar", "valorPisReceberPagar", "percentualPisReceberPagar", "valorCsllReceberPagar", "percentualCsllReceberPagar", "valorCofinsReceberPagar", "percentualCofinsReceberPagar", "valorInssReceberPagar", "percentualInssReceberPagar", "dataCompetenciaReceberPagar", "valorImpostosReceberPagar", "valorTaxaTotalReceberPagar", "valorTotalReceberPagarComSinal", "valorReceberPagarComSinal", "valorImpostosReceberPagarComSinal", "valorTaxaTotalReceberPagarComSinal", "valorDescontoReceberPagarComSinal", "numeroNotaFiscal", "situacaoNotaFiscal", "serieNotaFiscal", "descricaoFormaPgto", "valorTotalReceberPagar", "valorIpiReceberPagar", "valorIcmsReceberPagar", "percentualIpiReceberPagar", "percentualIcmsReceberPagar", "qtdeTitulosBaixa", "valorSomatorioBaixaComSinal", "valorTotalBaixa", "valorTotalBaixaComSinal", "jurosSomatorioPagamento", "codigoFilialBaixa", "codigoBaixa", "dataPagamento", "descontoSomatorioPagamento", "valorSomatorioPagamentoComSinal", "detalheTodosPagamentos", "jurosPagamento", "valorPagamentoComSinal", "valorPagamento", "descontoPagamento", "tipoBaixa", "tipoLogradouroCadastro"});
    private static final String[] campos = ArraysUtil.concatenar(camposRelatorio, camposCadastros);

    public RelatorioReceberPagarApoio() {
        this.montaBarraDescricao("Relat\u00f3rio de Receber/Pagar Baixados por Apoio", "Listagem das contas a Pagar e Receber Baixados por Apoio", "relatorios/rel_financeiro_movimento_recpag_apoio.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroUsuario", "Usu\u00e1rio", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao + " and con_apoiado = true ", 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Nome Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltroAvancado("filtroPaciente", "Paciente", "paciente", "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"pac_codigo", "pac_nome", "pac_nomesocial"}, new String[]{"C\u00f3digo", "Nome", "Nome Social"}, new int[]{70, 0, 0}, false, new int[]{70, 0, 0});
        this.adicionaFiltroCombo("filtroCampoData", "Campo Data:", this.CAMPOSDATA, 0);
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroTexto("filtroNumeroDocumento", "N\u00famero Doc:", 0);
        this.adicionaFiltroDecimal("filtroValorInicial", "Valor Inicial:", 0);
        this.adicionaFiltroDecimal("filtroValorFinal", "Valor Final:", 0);
        this.adicionaFiltroCombo("filtroTipo", "Tipo:", this.tipo, 0);
        this.adicionaFiltroCombo("filtroTipoDocumento", "Tipo Doc:", this.tipoDocumento, 0);
        this.adicionaFiltroCombo("filtroOrdemRelatorio", "Ordem:", this.ordem, 0);
        this.adicionaFiltroCombo("filtroOrdemAgrupamento", "Ordem Agrup.:", this.ordemAgrupamento, 0);
        this.setModuloConfigurar(RelatorioReceberPagarApoio.getModuloConfigurar());
        this.setModuloAcesso(RelatorioReceberPagarApoio.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement st2;
        Statement st;
        block67: {
            this.setCursor(Cursor.getPredefinedCursor(3));
            st = Conexao.getStatement();
            st2 = Conexao.getStatement();
            try {
                ResultSet rs;
                String[] paciente;
                StringBuilder buf = new StringBuilder();
                buf.append("select a.rpg_valor as valorReceberPagar, ");
                buf.append("       a.rpg_taxa as valorTaxaReceberPagar, ");
                buf.append("       a.rpg_valortotal as valorTotalReceberPagar, ");
                buf.append("\t\t\t a.rpg_valoracrescimo as valorAcrescimoReceberPagar, ");
                buf.append("       COALESCE(a.rpg_valordesconto, 0) as valorDescontoReceberPagar, ");
                buf.append("       a.rpg_codigo as codigoReceberPagar, ");
                buf.append("       a.rpg_datahora as dataHoraReceberPagar,  a.rpg_competencia as dataCompetenciaReceberPagar, ");
                buf.append("       a.rpg_vencimento as dataVencimentoReceberPagar,");
                buf.append("       a.rpg_tipojuros as tipoJurosReceberPagar, ");
                buf.append("       a.rpg_tipo as tipoReceberPagar,  ");
                buf.append("       a.rpg_tipodocumento as tipoDocumentoReceberPagar, ");
                buf.append("       a.rpg_numerodocumento as numeroDocumentoReceberPagar, ");
                buf.append("       a.rpg_parcela as numeroParcelaReceberPagar, ");
                buf.append("       a.rpg_codigodocumento as codigoDocumentoReceberPagar, ");
                buf.append("       a.rpg_datadocumento as dataDocumentoReceberPagar, ");
                buf.append("       a.rpg_dataprocessamento as dataProcessamentoReceberPagar, ");
                buf.append("       a.rpg_obs as observacaoReceberPagar, ");
                buf.append("       a.rpg_tipocadastro as tipoCadastroReceberPagar, ");
                buf.append("       usrrecpag.usr_codigo as codigoUsuarioReceberPagar, ");
                buf.append("       usrrecpag.usr_nome as nomeUsuarioReceberPagar, ");
                buf.append("       usuariocancela.usr_codigo as codigoUsuarioCancelamentoReceberPagar, ");
                buf.append("       usuariocancela.usr_nome as nomeUsuarioCancelamentoReceberPagar, ");
                buf.append("       a.rpg_datacancelado as dataCancelamentoReceberPagar, ");
                buf.append("       a.rpg_situacao as situacaoReceberPagar, ");
                buf.append("       a.rpg_valor + a.rpg_taxa as valorComTaxaReceberPagar, ");
                buf.append("       a.rpg_valorjuro as valorJuroReceberPagar, ");
                buf.append("       a.rpg_valormulta as valorMultaReceberPagar, ");
                buf.append("       a.rpg_percentualmulta as percentualMultaReceberPagar, ");
                buf.append("       a.rpg_percentualjuro as percentualJuroReceberPagar, ");
                buf.append("       a.rpg_percentualacrescimo as percentualAcrescimoReceberPagar, ");
                buf.append("       a.rpg_percentualdesconto as percentualDescontoReceberPagar, ");
                buf.append("       a.rpg_ipivalor as valorIpiReceberPagar, ");
                buf.append("       a.rpg_ipipercentual as percentualIpiReceberPagar, ");
                buf.append("       a.rpg_icmsvalor as valorIcmsReceberPagar, ");
                buf.append("       a.rpg_icmspercentual as percentualIcmsReceberPagar, ");
                buf.append("       a.rpg_irrfvalor as valorIrrfReceberPagar, ");
                buf.append("       a.rpg_irrfpercentual as percentualIrrfReceberPagar, ");
                buf.append("       a.rpg_issvalor as valorIssReceberPagar, ");
                buf.append("       a.rpg_isspercentual as percentualIssReceberPagar, ");
                buf.append("       a.rpg_pisvalor as valorPisReceberPagar, ");
                buf.append("       a.rpg_pispercentual as percentualPisReceberPagar, ");
                buf.append("       a.rpg_csllvalor as valorCsllReceberPagar, ");
                buf.append("       a.rpg_csllpercentual as percentualCsllReceberPagar, ");
                buf.append("       a.rpg_cofinsvalor as valorCofinsReceberPagar, ");
                buf.append("       a.rpg_cofinspercentual as percentualCofinsReceberPagar, ");
                buf.append("       a.rpg_inssvalor as valorInssReceberPagar, ");
                buf.append("       a.rpg_insspercentual as percentualInssReceberPagar, ");
                buf.append("       bxa.bxa_quantidadetitulos as qtdeTitulosBaixa, ");
                buf.append("       bxa.bxa_valortotal as valorTotalBaixa, ");
                buf.append("       bxa.fil_codigo as codigoFilialBaixa, ");
                buf.append("       bxa.bxa_codigo as codigoBaixa, ");
                buf.append("       bxa.bxa_tipo as tipoBaixa, ");
                buf.append("       CASE WHEN bxa.bxa_tipo = 'C' THEN bxa.bxa_valortotal ELSE bxa.bxa_valortotal * (-1) END as valorTotalBaixaComSinal, ");
                buf.append("       COALESCE(a.rpg_valormulta + a.rpg_valoracrescimo + a.rpg_valorjuro, 0) as valorTaxaTotalReceberPagar, ");
                buf.append("       a.ser_codigo as codigoSerie, ser.ser_descricao as descricaoSerie, ");
                buf.append("        CASE WHEN a.rpg_tipo = 'R' THEN a.rpg_valortotal ELSE a.rpg_valortotal * (-1) END as valorTotalReceberPagarComSinal, ");
                buf.append("        CASE WHEN a.rpg_tipo = 'R' THEN a.rpg_valor ELSE a.rpg_valor * (-1) END as valorReceberPagarComSinal, ");
                buf.append("        COALESCE( ");
                buf.append("           (case when a.nfi_codigo is null then ");
                buf.append("                 a.rpg_irrfvalor + a.rpg_issvalor + a.rpg_pisvalor + a.rpg_csllvalor + a.rpg_cofinsvalor + a.rpg_inssvalor ");
                buf.append("            else ");
                buf.append("                 nfi.nfi_irrfvalor + nfi.nfi_issvalor + nfi.nfi_pisvalor + nfi.nfi_csllvalor + nfi.nfi_cofinsvalor + nfi.nfi_inssvalor ");
                buf.append("           end), 0) as valorImpostosReceberPagar, ");
                buf.append("        COALESCE( ");
                buf.append("           (case when a.nfi_codigo is null then ");
                buf.append("                 a.rpg_irrfvalor + a.rpg_issvalor + a.rpg_pisvalor + a.rpg_csllvalor + a.rpg_cofinsvalor + a.rpg_inssvalor ");
                buf.append("            else ");
                buf.append("                 nfi.nfi_irrfvalor + nfi.nfi_issvalor + nfi.nfi_pisvalor + nfi.nfi_csllvalor + nfi.nfi_cofinsvalor + nfi.nfi_inssvalor ");
                buf.append("           end), 0) * (-1) as valorImpostosReceberPagarComSinal, ");
                buf.append("        COALESCE(a.rpg_valormulta + a.rpg_valoracrescimo + a.rpg_valorjuro, 0) as valorTaxaTotalReceberPagar, ");
                buf.append("        case ");
                buf.append("          when a.rpg_tipocadastro = '").append("O").append("' then a.con_codigo ");
                buf.append("          when a.rpg_tipocadastro = '").append("P").append("' then a.pac_codigo ");
                buf.append("          when a.rpg_tipocadastro = '").append("U").append("' then a.ent_codigo ");
                buf.append("          when a.rpg_tipocadastro = '").append("F").append("' then a.ent_codigo ");
                buf.append("          when a.rpg_tipocadastro = '").append("C").append("' then a.ent_codigo ");
                buf.append("          when a.rpg_tipocadastro = '").append("R").append("' then a.ent_codigo ");
                buf.append("          else a.ent_codigo ");
                buf.append("        end as codigoCadastro, ");
                buf.append("        case ");
                buf.append("          when a.pac_codigo is not null then pac.pac_nome ");
                buf.append("          else con.con_fantasia ");
                buf.append("        end as fantasiaCadastro, ");
                buf.append("        case ");
                buf.append("          when a.pac_codigo is not null then pac.pac_nomesocial ");
                buf.append("          else con.con_razao ");
                buf.append("        end as razaoSocialCadastro, ");
                buf.append("        case ");
                buf.append("          when a.pac_codigo is not null then pac.pac_fone ");
                buf.append("          else con.con_fone ");
                buf.append("        end as foneCadastro, ");
                buf.append("        case ");
                buf.append("          when a.pac_codigo is not null then pac.pac_endereco ");
                buf.append("          else con.con_endereco ");
                buf.append("        end as enderecoCadastro, ");
                buf.append("        case ");
                buf.append("          when a.pac_codigo is not null then pac.pac_numeroendereco ");
                buf.append("          else con.con_numeroendereco ");
                buf.append("        end as numeroEnderecoCadastro, ");
                buf.append("        case ");
                buf.append("          when a.pac_codigo is not null then pac.pac_tipologradouroendereco ");
                buf.append("          else con.con_tipologradouroendereco ");
                buf.append("        end as tipoLogradouroCadastro, ");
                buf.append("        case ");
                buf.append("          when a.pac_codigo is not null then pac.pac_fax ");
                buf.append("          else con.con_fax ");
                buf.append("        end as faxCadastro, ");
                buf.append("        case ");
                buf.append("          when a.pac_codigo is not null then pac.pac_complemento ");
                buf.append("          else con.con_complemento ");
                buf.append("        end as complementoCadastro, ");
                buf.append("        case ");
                buf.append("          when a.pac_codigo is not null then pac.pac_cep ");
                buf.append("          else con.con_cep ");
                buf.append("        end as cepCadastro, ");
                buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                buf.append("from receberpagar a ");
                buf.append("left join usuario usuariocancela on a.usr_codcancelado = usuariocancela.usr_codigo ");
                buf.append("left join usuario usrrecpag on a.usr_codigo = usrrecpag.usr_codigo ");
                buf.append("left join series ser on a.fil_codigo = ser.fil_codigo and a.ser_codigo = ser.ser_codigo ");
                buf.append("left join convenios con on a.fil_codigo = con.fil_codigo and a.con_codigo = con.con_codigo ");
                buf.append("left join paciente pac on a.fil_codigo = pac.fil_codigo and a.pac_codigo = pac.pac_codigo ");
                buf.append("left join notafiscal nfi on (a.fil_codigo = nfi.fil_codigo and a.nfi_codigo = nfi.nfi_codigo) ");
                buf.append("join baixareceberpagar brp on (a.fil_codigo = brp.fil_codigo and a.rpg_codigo = brp.rpg_codigo) ");
                buf.append("join baixa bxa on (brp.fil_codigo = bxa.fil_codigo and brp.bxa_codigo = bxa.bxa_codigo) ");
                buf.append("left join motivoscancelamentos motCancBaixa on (bxa.fil_codigo = motCancBaixa.fil_codigo and bxa.mov_codigo = motCancBaixa.mov_codigo) ");
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                buf.append("where a.fil_codigo ");
                String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
                if (filiais == null || filiais.length == 0) {
                    buf.append(" = ").append(Variaveis.filialPadrao);
                } else {
                    buf.append(" in (");
                    for (int i = 0; i < filiais.length; ++i) {
                        buf.append(filiais[i]);
                        if (i >= filiais.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                buf.append(" and a.rpg_situacao = '").append("Q").append("' ");
                String[] usuario = this.getSelecionadosFiltro("filtroUsuario", 0);
                if (usuario != null) {
                    buf.append(" and a.usr_codigo in (");
                    for (int i = 0; i < usuario.length; ++i) {
                        buf.append("'");
                        buf.append(usuario[i]);
                        buf.append("'");
                        if (i >= usuario.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                buf.append(" and con.con_apoiado = true ");
                StringBuilder bufUsuario = new StringBuilder();
                String[] convenio = this.getSelecionadosFiltro("filtroConvenio", 0);
                if (convenio != null) {
                    bufUsuario.append(" a.con_codigo in (");
                    for (int i = 0; i < convenio.length; ++i) {
                        bufUsuario.append(convenio[i]);
                        if (i >= convenio.length - 1) continue;
                        bufUsuario.append(", ");
                    }
                    bufUsuario.append(")");
                }
                if ((paciente = this.getSelecionadosFiltroAvancado("filtroPaciente", 0)) != null) {
                    if (bufUsuario.length() > 0) {
                        bufUsuario.append(" or ");
                    }
                    bufUsuario.append(" a.pac_codigo in (");
                    for (int i = 0; i < paciente.length; ++i) {
                        bufUsuario.append(paciente[i]);
                        if (i >= paciente.length - 1) continue;
                        bufUsuario.append(", ");
                    }
                    bufUsuario.append(")");
                }
                if (bufUsuario.length() > 0) {
                    buf.append(" and (").append(bufUsuario.toString()).append(") ");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                    buf.append(" and cast(a." + this.CAMPOSDATABANCO[this.getFiltroComboIndice("filtroCampoData")] + " as date) >= '");
                    buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial")));
                    buf.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                    buf.append(" and cast(a." + this.CAMPOSDATABANCO[this.getFiltroComboIndice("filtroCampoData")] + " as date) <= '");
                    buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal")));
                    buf.append("'");
                }
                if (!this.getFiltroCombo("filtroTipo").equals(this.tipo[0])) {
                    if (this.getFiltroCombo("filtroTipo").equals(this.tipo[1])) {
                        buf.append(" and a.rpg_tipo = '").append("P").append("' ");
                    } else {
                        buf.append(" and a.rpg_tipo = '").append("R").append("' ");
                    }
                }
                if (!this.getFiltroCombo("filtroTipoDocumento").equals(this.tipoDocumento[0])) {
                    if (this.getFiltroCombo("filtroTipoDocumento").equals(this.tipoDocumento[1])) {
                        buf.append(" and a.rpg_tipodocumento = '").append("B").append("' ");
                    } else if (this.getFiltroCombo("filtroTipoDocumento").equals(this.tipoDocumento[2])) {
                        buf.append(" and a.rpg_tipodocumento = '").append("D").append("' ");
                    } else if (this.getFiltroCombo("filtroTipoDocumento").equals(this.tipoDocumento[4])) {
                        buf.append(" and a.rpg_tipodocumento = '").append("A").append("' ");
                    } else {
                        buf.append(" and a.rpg_tipodocumento = '").append("C").append("' ");
                    }
                }
                if (!this.getFiltroTexto("filtroNumeroDocumento").isEmpty()) {
                    buf.append(" and a.rpg_numerodocumento ILIKE '%").append(this.getFiltroTexto("filtroNumeroDocumento")).append("%' ");
                }
                if (!Funcoes.textoVazio(this.getFiltroDecimal("filtroValorInicial"))) {
                    buf.append(" and a.rpg_valor >= ").append(this.getFiltroTexto("filtroValorInicial")).append(" ");
                }
                if (!Funcoes.textoVazio(this.getFiltroDecimal("filtroValorFinal"))) {
                    buf.append(" and a.rpg_valor <= ").append(this.getFiltroTexto("filtroValorFinal")).append(" ");
                }
                buf.append(" order by a.fil_codigo, bxa.bxa_tipo, bxa.bxa_codigo ");
                if (this.getFiltroCombo("filtroOrdemAgrupamento").equals(this.ordemAgrupamento[0])) {
                    buf.append(",fantasiaCadastro, ");
                } else {
                    buf.append(",codigoCadastro, ");
                }
                buf.append("a.rpg_tipo, a.rpg_vencimento ");
                String indiceOrdem = (String)this.getFiltroCombo("filtroOrdemRelatorio");
                if (!indiceOrdem.equals("Cadastro")) {
                    buf.append(", a.").append(this.CAMPOSBANCOORDEM[this.getFiltroComboIndice("filtroOrdemRelatorio")]);
                }
                if ((rs = Conexao.executeQuery(st, buf.toString())).next()) {
                    ModeloGridTable modelo = new ModeloGridTable(campos){

                        @Override
                        public String getColumnName(int column) {
                            return this.colunas[column];
                        }
                    };
                    do {
                        Object[] o = new Object[campos.length];
                        int pos = -1;
                        for (int i = 0; i < campos.length; ++i) {
                            pos = modelo.findColumn(campos[i]);
                            if (campos[i].equalsIgnoreCase("tipoLogradouroCadastro")) {
                                o[pos] = Tipos.tipoLogradouroDescricao(rs.getString(campos[i]));
                                continue;
                            }
                            if (campos[i].equals("tipoReceberPagar")) {
                                o[pos] = Tipos.tipoReceberPagar(rs.getString(campos[i]));
                                continue;
                            }
                            if (campos[i].equals("valorTotalReceberPagar") || campos[i].equals("valorReceberPagar") || campos[i].equals("valorTaxaTotalReceberPagar")) {
                                o[pos] = Float.valueOf(rs.getFloat(campos[i]));
                                if (rs.getString("tipoReceberPagar").equals("R")) {
                                    o[modelo.findColumn((String)new StringBuilder().append((String)RelatorioReceberPagarApoio.campos[i]).append((String)"ComSinal").toString())] = rs.getDouble(campos[i]);
                                    continue;
                                }
                                double aux = rs.getDouble(campos[i]);
                                o[modelo.findColumn((String)new StringBuilder().append((String)RelatorioReceberPagarApoio.campos[i]).append((String)"ComSinal").toString())] = aux == 0.0 ? 0.0 : aux * -1.0;
                                continue;
                            }
                            if (campos[i].equals("valorDescontoReceberPagar")) {
                                o[pos] = Float.valueOf(rs.getFloat(campos[i]));
                                if (rs.getString("tipoReceberPagar").equals("R")) {
                                    double aux = rs.getDouble(campos[i]);
                                    o[modelo.findColumn((String)new StringBuilder().append((String)RelatorioReceberPagarApoio.campos[i]).append((String)"ComSinal").toString())] = aux == 0.0 ? 0.0 : aux * -1.0;
                                    continue;
                                }
                                o[modelo.findColumn((String)new StringBuilder().append((String)RelatorioReceberPagarApoio.campos[i]).append((String)"ComSinal").toString())] = rs.getDouble(campos[i]);
                                continue;
                            }
                            if (campos[i].equals("valorImpostosReceberPagar")) {
                                o[pos] = Float.valueOf(rs.getFloat(campos[i]));
                                double aux = rs.getDouble(campos[i]);
                                o[modelo.findColumn((String)new StringBuilder().append((String)RelatorioReceberPagarApoio.campos[i]).append((String)"ComSinal").toString())] = aux == 0.0 ? 0.0 : aux * -1.0;
                                continue;
                            }
                            if (campos[i].equals("tipoDocumentoReceberPagar")) {
                                o[pos] = Tipos.tipoDocumento(rs.getString(campos[i]));
                                continue;
                            }
                            if (campos[i].equals("situacaoReceberPagar")) {
                                o[pos] = Tipos.tipoSituacaoReceberPagar(rs.getString(campos[i]));
                                continue;
                            }
                            if (campos[i].equals("tipoCadastroReceberPagar")) {
                                o[pos] = Tipos.tipoCadastro(rs.getString(campos[i]));
                                continue;
                            }
                            if (campos[i].equals("tipoBaixa")) {
                                o[pos] = Tipos.tipoBaixa(rs.getString(campos[i]));
                                continue;
                            }
                            if (campos[i].equals("valorSomatorioBaixaComSinal")) {
                                o[i] = rs.getBigDecimal("valorTotalBaixa").divide(rs.getBigDecimal("qtdeTitulosBaixa") == null ? BigDecimal.ONE : rs.getBigDecimal("qtdeTitulosBaixa"), RoundingMode.HALF_UP);
                                if (!rs.getString("tipoBaixa").equalsIgnoreCase("D")) continue;
                                o[i] = ((BigDecimal)o[i]).multiply(new BigDecimal(-1));
                                continue;
                            }
                            if (campos[i].equals("situacaoNotaFiscal") || campos[i].equals("dataPagamento") || campos[i].equals("jurosPagamento") || campos[i].equals("descontoPagamento") || campos[i].equals("valorPagamento") || campos[i].equals("jurosSomatorioPagamento") || campos[i].equals("descontoSomatorioPagamento") || campos[i].equals("valorSomatorioPagamentoComSinal") || campos[i].equals("valorPagamentoComSinal") || campos[i].equals("detalheTodosPagamentos")) continue;
                            try {
                                o[pos] = rs.getObject(campos[i]);
                                continue;
                            }
                            catch (Exception aux) {
                                // empty catch block
                            }
                        }
                        modelo.addLine(o);
                    } while (rs.next());
                    if (indiceOrdem.equals("Cadastro")) {
                        modelo.ordenarColuna(modelo.findColumn("fantasiaCadastro"), 1);
                    }
                    for (int i = 0; i < modelo.getRowCount(); ++i) {
                        buf.delete(0, buf.length());
                        buf.append(" select lcx.lcx_vencimento as dataPagamento ");
                        buf.append("       ,lcx.lcx_tipopagamento as tipoPagamento ");
                        buf.append("       ,CASE WHEN lcx.lcx_valorjuro IS NULL THEN 0 ELSE lcx.lcx_valorjuro END as jurosPagamento ");
                        buf.append("       ,CASE WHEN lcx.lcx_valordesconto IS NULL THEN 0 ELSE lcx.lcx_valordesconto END as descontoPagamento ");
                        buf.append("       ,CASE WHEN lcx.lcx_valortotal IS NULL THEN 0 ELSE lcx.lcx_valortotal END as valorPagamento ");
                        buf.append("       ,CASE WHEN lcx.lcx_tipo = '").append("C").append("' THEN");
                        buf.append("             CASE WHEN lcx.lcx_valortotal IS NULL THEN 0 ELSE lcx.lcx_valortotal END ");
                        buf.append("        ELSE ");
                        buf.append("             CASE WHEN lcx.lcx_valortotal IS NULL THEN 0 ELSE lcx.lcx_valortotal END * (-1) ");
                        buf.append("         END as valorPagamentoComSinal ");
                        buf.append("   from lanctocaixa lcx ");
                        buf.append("   join baixalanctocaixa blc on blc.fil_codigo = lcx.fil_codigo ");
                        buf.append("                            and blc.lcx_codigo = lcx.lcx_codigo ");
                        buf.append("                            and blc.est_codigo = lcx.est_codigo ");
                        buf.append("  where blc.fil_codigo = ").append(modelo.getValueAt(i, modelo.findColumn("codigoFilialBaixa")));
                        buf.append("    and blc.bxa_codigo = ").append(modelo.getValueAt(i, modelo.findColumn("codigoBaixa")));
                        try {
                            rs = st.executeQuery(buf.toString());
                            StringBuilder dataPagamento = new StringBuilder();
                            BigDecimal jurosPagamento = new BigDecimal(0).setScale(2, RoundingMode.HALF_UP);
                            BigDecimal descontoPagamento = new BigDecimal(0).setScale(2, RoundingMode.HALF_UP);
                            BigDecimal valorPagamento = new BigDecimal(0).setScale(2, RoundingMode.HALF_UP);
                            BigDecimal valorPagamentoComSinal = new BigDecimal(0).setScale(2, RoundingMode.HALF_UP);
                            StringBuilder detalheTodosPagamentos = new StringBuilder();
                            detalheTodosPagamentos.delete(0, detalheTodosPagamentos.length());
                            while (rs.next()) {
                                dataPagamento.append(dataPagamento.length() > 0 ? " " : "").append(Funcoes.formataData("dd/MM/yyyy", rs.getDate("dataPagamento")));
                                jurosPagamento = jurosPagamento.add(rs.getBigDecimal("jurosPagamento")).setScale(2, RoundingMode.HALF_UP);
                                descontoPagamento = descontoPagamento.add(rs.getBigDecimal("descontoPagamento")).setScale(2, RoundingMode.HALF_UP);
                                valorPagamento = valorPagamento.add(rs.getBigDecimal("valorPagamento")).setScale(2, RoundingMode.HALF_UP);
                                valorPagamentoComSinal = valorPagamentoComSinal.add(rs.getBigDecimal("valorPagamentoComSinal")).setScale(2, RoundingMode.HALF_UP);
                                if (detalheTodosPagamentos.length() > 0) {
                                    detalheTodosPagamentos.append(" , ");
                                }
                                detalheTodosPagamentos.append("[");
                                detalheTodosPagamentos.append(Funcoes.formataData("dd/MM/yy", rs.getDate("dataPagamento"))).append(" - ");
                                detalheTodosPagamentos.append(Funcoes.formataDecimal(rs.getBigDecimal("valorPagamento").setScale(2, RoundingMode.HALF_UP).doubleValue())).append(" (");
                                detalheTodosPagamentos.append(Tipos.tipoPagamento(rs.getString("tipoPagamento"))).append(")");
                                detalheTodosPagamentos.append("]");
                            }
                            modelo.setValueAt(dataPagamento, i, modelo.findColumn("dataPagamento"));
                            modelo.setValueAt(jurosPagamento, i, modelo.findColumn("jurosPagamento"));
                            modelo.setValueAt(jurosPagamento.divide(modelo.getValueAt(i, modelo.findColumn("qtdeTitulosBaixa")) == null ? BigDecimal.ONE : new BigDecimal((Integer)modelo.getValueAt(i, modelo.findColumn("qtdeTitulosBaixa"))), RoundingMode.HALF_UP), i, modelo.findColumn("jurosSomatorioPagamento"));
                            modelo.setValueAt(descontoPagamento, i, modelo.findColumn("descontoPagamento"));
                            modelo.setValueAt(descontoPagamento.divide(modelo.getValueAt(i, modelo.findColumn("qtdeTitulosBaixa")) == null ? BigDecimal.ONE : new BigDecimal((Integer)modelo.getValueAt(i, modelo.findColumn("qtdeTitulosBaixa"))), RoundingMode.HALF_UP), i, modelo.findColumn("descontoSomatorioPagamento"));
                            modelo.setValueAt(valorPagamento, i, modelo.findColumn("valorPagamento"));
                            modelo.setValueAt(valorPagamentoComSinal, i, modelo.findColumn("valorPagamentoComSinal"));
                            modelo.setValueAt(valorPagamentoComSinal.divide(modelo.getValueAt(i, modelo.findColumn("qtdeTitulosBaixa")) == null ? BigDecimal.ONE : new BigDecimal((Integer)modelo.getValueAt(i, modelo.findColumn("qtdeTitulosBaixa"))), RoundingMode.HALF_UP), i, modelo.findColumn("valorSomatorioPagamentoComSinal"));
                            modelo.setValueAt(detalheTodosPagamentos, i, modelo.findColumn("detalheTodosPagamentos"));
                            continue;
                        }
                        finally {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                    }
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(RelatorioReceberPagarApoio.getModuloAcesso());
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        int i;
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(0.5f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioReceberPagarApoio.this.panelCentro.removeAll();
                                RelatorioReceberPagarApoio.this.panelCentro.repaint();
                                RelatorioReceberPagarApoio.this.habilitaBotaoImprimir(true);
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put("filtroOrdemRelatorio", this.getFiltroCombo("filtroOrdemRelatorio"));
                        var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                        var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                        var.put("filtroNumeroDocumento", this.getFiltroTexto("filtroNumeroDocumento"));
                        var.put("filtroValorInicial", this.getFiltroDecimal("filtroValorInicial"));
                        var.put("filtroValorFinal", this.getFiltroDecimal("filtroValorFinal"));
                        var.put("filtroTipo", this.getFiltroCombo("filtroTipo"));
                        var.put("filtroTipoDocumento", this.getFiltroCombo("filtroTipoDocumento"));
                        var.put("filtroOrdemAgrupamento", this.getFiltroCombo("filtroOrdemAgrupamento"));
                        buf.delete(0, buf.length());
                        if (convenio != null) {
                            for (i = 0; i < convenio.length; ++i) {
                                buf.append(convenio[i]);
                                if (i >= convenio.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroConvenio", buf.toString());
                        buf.delete(0, buf.length());
                        if (paciente != null) {
                            for (i = 0; i < paciente.length; ++i) {
                                buf.append(paciente[i]);
                                if (i >= paciente.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroPaciente", buf.toString());
                        buf.delete(0, buf.length());
                        if (filiais != null) {
                            for (i = 0; i < filiais.length; ++i) {
                                buf.append(filiais[i]);
                                if (i >= filiais.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroFilial", buf.toString());
                        buf.delete(0, buf.length());
                        if (usuario != null) {
                            for (i = 0; i < usuario.length; ++i) {
                                buf.append(usuario[i]);
                                if (i >= usuario.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroUsuario", buf.toString());
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelCentro.revalidate();
                    }
                    break block67;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st, st2);
                    throw throwable;
                }
                Conexao.fecharStatement(st, st2);
            }
        }
        Conexao.fecharStatement(st, st2);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0852300100");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0852300101");
    }
}

