/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.movimento;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioReceberPagar
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String[] ordem = new String[]{"Documento", "C\u00f3digo", "Data + Hora", "Usu\u00e1rio", "Vencimento", "Cadastro", "C\u00f3d (sem tipo)", "Doc (sem tipo)", "Venc (sem tipo)"};
    private final String[] CAMPOSBANCOORDEM = new String[]{"rpg_numerodocumento", "rpg_codigo", "rpg_dataHora", "usr_codigo", "rpg_vencimento", "", "rpg_codigo", "rpg_numerodocumento", "rpg_vencimento"};
    private final String[] ordemAgrupamento = new String[]{"Nome/Fantasia", "C\u00f3digo"};
    private final String[] situacao = new String[]{Tipos.tipoSituacaoReceberPagar("A") + " e " + Tipos.tipoSituacaoReceberPagar("Q"), "Todas", Tipos.tipoSituacaoReceberPagar("A"), Tipos.tipoSituacaoReceberPagar("Q"), Tipos.tipoSituacaoReceberPagar("L"), Tipos.tipoSituacaoReceberPagar("G"), Tipos.tipoSituacaoReceberPagar("E"), Tipos.tipoSituacaoReceberPagar("R"), Tipos.tipoSituacaoReceberPagar("V"), Tipos.tipoSituacaoReceberPagar("T"), Tipos.tipoSituacaoReceberPagar("S"), Tipos.tipoSituacaoReceberPagar("N"), Tipos.tipoSituacaoReceberPagar("P"), Tipos.tipoSituacaoReceberPagar("F")};
    private final String[] tipo = new String[]{"Todos", Tipos.tipoReceberPagar("P"), Tipos.tipoReceberPagar("R")};
    private final String[] tipoCadastro = new String[]{"Todos", Tipos.tipoCadastro("U"), Tipos.tipoCadastro("F"), Tipos.tipoCadastro("C"), Tipos.tipoCadastro("R"), Tipos.tipoCadastro("P"), Tipos.tipoCadastro("O")};
    private final String[] tipoDocumento = new String[]{"Todos", Tipos.tipoDocumento("B"), Tipos.tipoDocumento("D"), Tipos.tipoDocumento("C"), Tipos.tipoDocumento("A")};
    private final String[] CAMPOSDATA = new String[]{"Vencimento", "Compet\u00eancia", "Cadastro"};
    private final String[] CAMPOSDATABANCO = new String[]{"rpg_vencimento", "rpg_competencia", "rpg_datahora"};
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_USUARIO = "filtroUsuario";
    private final String FILTRO_SERIE = "filtroSerie";
    private final String FILTRO_DATA_INI = "filtroDataInicial";
    private final String FILTRO_DATA_FIM = "filtroDataFinal";
    private final String FILTRO_SITUACAO = "filtroSituacao";
    private final String FILTRO_TIPO_CADASTRO = "filtroTipoCadastro";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String FILTRO_TIPO = "filtroTipo";
    private final String FILTRO_TIPO_DOCUMENTO = "filtroTipoDocumento";
    private final String FILTRO_NUMERO_DOCUMENTO = "filtroNumeroDocumento";
    private final String FILTRO_VALOR_INICIAL = "filtroValorInicial";
    private final String FILTRO_VALOR_FINAL = "filtroValorFinal";
    private final String FILTRO_CONVENIO = "filtroConvenio";
    private final String FILTRO_ENTIDADE = "filtroEntidade";
    private final String FILTRO_PACIENTE = "filtroPaciente";
    private final String FILTRO_ORDEM_AGRUPAMENTO = "filtroOrdemAgrupamento";
    private final String FILTRO_PREVIA_ABERTO = "filtroConsiderarPreviaAberto";
    private final String TOTAL_RECEBER = "totalGeralReceber";
    private final String TOTAL_PAGAR = "totalGeralPagar";
    private final String FILTRO_CAMPO_DATA = "filtroCampoData";
    public static final int TIPO_RECPAG = 0;
    public static final int TIPO_NOTAFISCAL = 1;
    public static final int TIPO_CLIENTE = 2;
    public static final int TIPO_VENCIMENTO = 3;
    private int tipoRelatorio = 0;
    private BigDecimal totalPagar;
    private BigDecimal totalReceber;
    private static final String[] camposCadastros = new String[]{"codigoCadastro", "fantasiaCadastro", "razaoSocialCadastro", "foneCadastro", "enderecoCadastro", "numeroEnderecoCadastro", "faxCadastro", "complementoCadastro", "cepCadastro", "codigoCidadeCadastro", "nomeCidadeCadastro", "cpfCnpjCadastro"};
    private static final String[] camposRelatorio = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoReceberPagar", "dataHoraReceberPagar", "dataVencimentoReceberPagar", "valorReceberPagar", "tipoJurosReceberPagar", "tipoReceberPagar", "tipoDocumentoReceberPagar", "numeroDocumentoReceberPagar", "valorTaxaReceberPagar", "numeroParcelaReceberPagar", "codigoDocumentoReceberPagar", "dataDocumentoReceberPagar", "dataProcessamentoReceberPagar", "observacaoReceberPagar", "tipoCadastroReceberPagar", "codigoUsuarioReceberPagar", "nomeUsuarioReceberPagar", "codigoUsuarioCancelamentoReceberPagar", "nomeUsuarioCancelamentoReceberPagar", "dataCancelamentoReceberPagar", "situacaoReceberPagar", "valorJuroReceberPagar", "valorMultaReceberPagar", "valorComTaxaReceberPagar", "valorAcrescimoReceberPagar", "valorDescontoReceberPagar", "percentualMultaReceberPagar", "percentualJuroReceberPagar", "percentualAcrescimoReceberPagar", "percentualAcrescimoReceberPagar", "codigoSerie", "descricaoSerie", "valorIrrfReceberPagar", "percentualIrrfReceberPagar", "valorIssReceberPagar", "percentualIssReceberPagar", "valorPisReceberPagar", "percentualPisReceberPagar", "valorCsllReceberPagar", "percentualCsllReceberPagar", "valorCofinsReceberPagar", "percentualCofinsReceberPagar", "valorInssReceberPagar", "percentualInssReceberPagar", "dataCompetenciaReceberPagar", "valorImpostosReceberPagar", "valorTaxaTotalReceberPagar", "valorTotalReceberPagarComSinal", "valorReceberPagarComSinal", "valorImpostosReceberPagarComSinal", "valorTaxaTotalReceberPagarComSinal", "valorDescontoReceberPagarComSinal", "numeroNotaFiscal", "situacaoNotaFiscal", "serieNotaFiscal", "descricaoFormaPgto", "valorTotalReceberPagar", "valorIpiReceberPagar", "valorIcmsReceberPagar", "percentualIpiReceberPagar", "percentualIcmsReceberPagar", "valorReceber", "valorPagar", "tipoLogradouroCadastro"});
    private static final String[] campos = ArraysUtil.concatenar(camposRelatorio, camposCadastros);

    public RelatorioReceberPagar(int tipoRelatorio) {
        this.tipoRelatorio = tipoRelatorio;
        if (tipoRelatorio == 0) {
            this.montaBarraDescricao("Relat\u00f3rio de receber/pagar", "Listagem da movimenta\u00e7\u00e3o de contas a pagar e receber", "relatorios/rel_rec_pag.jpg");
        } else if (tipoRelatorio == 1) {
            this.montaBarraDescricao("Relat\u00f3rio de receber/pagar por nota fiscal", "Listagem das contas a Pagar e Receber pelas Notas Fiscais de origem", "relatorios/receber_pagar_por_nf.jpg");
        } else if (tipoRelatorio == 2) {
            this.montaBarraDescricao("Relat\u00f3rio de receber/pagar por cadastro", "Listagem das contas a Pagar e Receber por Cadastro", "relatorios/rel_financeiro_movimento_rec-pag_cadastro.jpg");
        } else {
            this.montaBarraDescricao("Relat\u00f3rio de receber/pagar por vencimento", "Listagem das contas a Pagar e Receber por data de vencimento", "relatorios/rel_financeiro_movimento_rec-pag_vencimento.jpg");
        }
        this.adicionaRelatorioListener(this);
        if (!this.naoPermiteFiltrarFilial()) {
            this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        }
        this.adicionaItemFiltro("filtroUsuario", "Usu\u00e1rio", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConvenio", "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Nome Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroEntidade", "Entidade", "entidade", "fil_codigo = " + Variaveis.filialPadrao + " and ent_inativo = false", 1, new String[]{"ent_codigo", "ent_razaosocial"}, new String[]{"C\u00f3digo", "Raz\u00e3o Social"}, new int[]{70, 0});
        this.adicionaItemFiltroAvancado("filtroPaciente", "Paciente", "paciente", "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"pac_codigo", "pac_nome", "pac_nomesocial"}, new String[]{"C\u00f3digo", "Nome", "Nome Social"}, new int[]{70, 0, 0}, false, new int[]{70, 0, 0});
        this.adicionaItemFiltro("filtroSerie", "S\u00e9rie", "series", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"ser_codigo", "ser_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaFiltroCombo("filtroCampoData", "Campo Data:", this.CAMPOSDATA, 0);
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroTexto("filtroNumeroDocumento", "N\u00famero Doc:", 0);
        this.adicionaFiltroDecimal("filtroValorInicial", "Valor Inicial:", 0);
        this.adicionaFiltroDecimal("filtroValorFinal", "Valor Final:", 0);
        this.adicionaFiltroCombo("filtroTipoCadastro", "Cadastro:", this.tipoCadastro, 0);
        this.adicionaFiltroCombo("filtroTipo", "Tipo:", this.tipo, 0);
        this.adicionaFiltroCombo("filtroSituacao", "Situa\u00e7\u00e3o:", this.situacao, 0);
        this.adicionaFiltroCombo("filtroTipoDocumento", "Tipo Doc:", this.tipoDocumento, 0);
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.adicionaNomeVariavel("totalGeralPagar");
        this.adicionaNomeVariavel("totalGeralReceber");
        if (tipoRelatorio == 2) {
            this.adicionaFiltroCombo("filtroOrdemAgrupamento", "Ordem Agrup.:", this.ordemAgrupamento, 0);
        }
        this.adicionaFiltroCheck("filtroConsiderarPreviaAberto", "<html>Considerar " + Tipos.tipoSituacaoReceberPagar("F").toLowerCase() + "<br>como " + Tipos.tipoSituacaoReceberPagar("A").toLowerCase() + "</html>", false);
        this.setModuloConfigurar(RelatorioReceberPagar.getModuloConfigurar(tipoRelatorio));
        this.setModuloAcesso(RelatorioReceberPagar.getModuloAcesso(tipoRelatorio));
        this.setCamposConfigurador(campos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement st2;
        Statement st;
        block126: {
            this.setCursor(Cursor.getPredefinedCursor(3));
            st = Conexao.getStatement();
            st2 = Conexao.getStatement();
            try {
                String[] serie;
                String[] paciente;
                String[] entidade;
                StringBuilder buf = new StringBuilder();
                buf.append("select ");
                buf.append("a.rpg_valor as valorReceberPagar, a.rpg_taxa as valorTaxaReceberPagar, a.rpg_valortotal as valorTotalReceberPagar, ");
                buf.append("a.rpg_valoracrescimo as valorAcrescimoReceberPagar, COALESCE(a.rpg_valordesconto, 0) as valorDescontoReceberPagar, ");
                buf.append("a.rpg_codigo as codigoReceberPagar, a.rpg_datahora as dataHoraReceberPagar, a.rpg_vencimento as dataVencimentoReceberPagar, a.rpg_competencia as dataCompetenciaReceberPagar, ");
                buf.append("a.rpg_tipojuros as tipoJurosReceberPagar, a.rpg_tipo as tipoReceberPagar, ");
                buf.append("a.rpg_tipodocumento as tipoDocumentoReceberPagar, a.rpg_numerodocumento as numeroDocumentoReceberPagar,  ");
                buf.append("a.rpg_parcela as numeroParcelaReceberPagar, a.rpg_codigodocumento as codigoDocumentoReceberPagar, a.rpg_datadocumento as dataDocumentoReceberPagar, ");
                buf.append("a.rpg_dataprocessamento as dataProcessamentoReceberPagar, a.rpg_obs as observacaoReceberPagar, a.rpg_tipocadastro as tipoCadastroReceberPagar, ");
                buf.append("usrrecpag.usr_codigo as codigoUsuarioReceberPagar, usrrecpag.usr_nome as nomeUsuarioReceberPagar, ");
                buf.append("usuariocancela.usr_codigo as codigoUsuarioCancelamentoReceberPagar, usuariocancela.usr_nome as nomeUsuarioCancelamentoReceberPagar, ");
                buf.append("a.rpg_datacancelado as dataCancelamentoReceberPagar, a.rpg_situacao as situacaoReceberPagar, ");
                buf.append("a.rpg_valor + a.rpg_taxa as valorComTaxaReceberPagar, ");
                buf.append("a.rpg_valorjuro as valorJuroReceberPagar, a.rpg_valormulta as valorMultaReceberPagar, ");
                buf.append("a.rpg_valoracrescimo as valorAcrescimoReceberPagar, ");
                buf.append("a.rpg_percentualmulta as percentualMultaReceberPagar, a.rpg_percentualjuro as percentualJuroReceberPagar, ");
                buf.append("a.rpg_percentualacrescimo as percentualAcrescimoReceberPagar, a.rpg_percentualdesconto as percentualDescontoReceberPagar, ");
                buf.append(" CASE WHEN a.rpg_tipo = '").append("R").append("' THEN a.rpg_valortotal ELSE 0 END as valorReceber, ");
                buf.append(" CASE WHEN a.rpg_tipo = '").append("P").append("' THEN a.rpg_valortotal ELSE 0 END as valorPagar, ");
                buf.append(this.montaCaseImpostos("nfi_ipivalor", null, "rpg_ipivalor")).append(" as valorIpiReceberPagar,  ");
                buf.append(this.montaCaseImpostos("nfi_icmsvalor", null, "rpg_icmsvalor")).append(" as valorIcmsReceberPagar,  ");
                buf.append(this.montaCaseImpostos("nfi_irrfvalor", "nfi_irrfretidovalor", "rpg_irrfvalor")).append(" as valorIrrfReceberPagar,  ");
                buf.append(this.montaCaseImpostos("nfi_issvalor", "nfi_issretidovalor", "rpg_issvalor")).append(" as valorIssReceberPagar,  ");
                buf.append(this.montaCaseImpostos("nfi_pisvalor", "nfi_pisretidovalor", "rpg_pisvalor")).append(" as valorPisReceberPagar,  ");
                buf.append(this.montaCaseImpostos("nfi_csllvalor", "nfi_csllretidovalor", "rpg_csllvalor")).append(" as valorCsllReceberPagar,  ");
                buf.append(this.montaCaseImpostos("nfi_cofinsvalor", "nfi_cofinsretidovalor", "rpg_cofinsvalor")).append(" as valorCofinsReceberPagar,  ");
                buf.append(this.montaCaseImpostos("nfi_inssvalor", "nfi_inssretidovalor", "rpg_inssvalor")).append(" as valorInssReceberPagar,  ");
                buf.append(this.montaCaseImpostos("nfi_ipipercentual", null, "rpg_ipipercentual")).append(" as percentualIpiReceberPagar,  ");
                buf.append(this.montaCaseImpostos("nfi_icmspercentual", null, "rpg_icmspercentual")).append(" as percentualIcmsReceberPagar,  ");
                buf.append(this.montaCaseImpostos("nfi_irrfpercentual", "nfi_irrfretidopercentual", "rpg_irrfpercentual")).append(" as percentualIrrfReceberPagar,  ");
                buf.append(this.montaCaseImpostos("nfi_isspercentual", "nfi_issretidopercentual", "rpg_isspercentual")).append(" as percentualIssReceberPagar,  ");
                buf.append(this.montaCaseImpostos("nfi_pispercentual", "nfi_pisretidopercentual", "rpg_pispercentual")).append(" as percentualPisReceberPagar,  ");
                buf.append(this.montaCaseImpostos("nfi_csllpercentual", "nfi_csllretidopercentual", "rpg_csllpercentual")).append(" as percentualCsllReceberPagar,  ");
                buf.append(this.montaCaseImpostos("nfi_cofinspercentual", "nfi_cofinsretidopercentual", "rpg_cofinspercentual")).append(" as percentualCofinsReceberPagar,  ");
                buf.append(this.montaCaseImpostos("nfi_insspercentual", "nfi_inssretidopercentual", "rpg_insspercentual")).append("as percentualInssReceberPagar,  ");
                buf.append("COALESCE( ");
                buf.append(" (CASE WHEN a.nfi_codigo IS NOT NULL AND ").append(this.montaSomaImpostos(false));
                buf.append("   THEN ").append("  COALESCE(COALESCE(nfi.nfi_irrfvalor,0) ");
                buf.append("    + COALESCE(nfi.nfi_issvalor,0) ");
                buf.append("    + COALESCE(nfi.nfi_pisvalor,0) ");
                buf.append("    + COALESCE(nfi.nfi_csllvalor,0) ");
                buf.append("    + COALESCE(nfi.nfi_cofinsvalor,0) ");
                buf.append("    + COALESCE(nfi.nfi_inssvalor,0) ");
                buf.append("    + COALESCE(nfi.nfi_ipivalor,0) ");
                buf.append("    + COALESCE(nfi.nfi_icmsvalor,0),0) ");
                buf.append("   WHEN a.nfi_codigo IS NOT NULL AND ").append(this.montaSomaImpostosRetido(false));
                buf.append("    THEN ").append(" COALESCE(a.rpg_irrfretidovalor,0) ");
                buf.append("    + COALESCE(nfi.nfi_issretidovalor,0)");
                buf.append("    + COALESCE(nfi.nfi_pisretidovalor,0) ");
                buf.append("    + COALESCE(nfi.nfi_csllretidovalor,0) ");
                buf.append("    + COALESCE(nfi.nfi_cofinsretidovalor,0) ");
                buf.append("    + COALESCE(nfi.nfi_inssretidovalor,0) ");
                buf.append("    ELSE ");
                buf.append("    COALESCE(a.rpg_irrfvalor,0) ");
                buf.append("    + COALESCE(a.rpg_issvalor,0)");
                buf.append("    + COALESCE(a.rpg_pisvalor,0) ");
                buf.append("    + COALESCE(a.rpg_csllvalor,0) ");
                buf.append("    + COALESCE(a.rpg_cofinsvalor,0) ");
                buf.append("    + COALESCE(a.rpg_inssvalor,0) ");
                buf.append("    + COALESCE(a.rpg_ipivalor,0) ");
                buf.append("    + COALESCE(a.rpg_icmsvalor,0) END), 0) AS valorImpostosReceberPagar, ");
                buf.append("COALESCE(a.rpg_valormulta + a.rpg_valoracrescimo + a.rpg_valorjuro, 0) as valorTaxaTotalReceberPagar, ");
                buf.append("a.ser_codigo as codigoSerie, s.ser_descricao as descricaoSerie, ");
                buf.append("case ");
                buf.append("  when a.rpg_tipocadastro = '").append("O").append("' then a.con_codigo ");
                buf.append("  when a.rpg_tipocadastro = '").append("P").append("' then a.pac_codigo ");
                buf.append("  when a.rpg_tipocadastro = '").append("U").append("' then a.ent_codigo ");
                buf.append("  when a.rpg_tipocadastro = '").append("F").append("' then a.ent_codigo ");
                buf.append("  when a.rpg_tipocadastro = '").append("C").append("' then a.ent_codigo ");
                buf.append("  when a.rpg_tipocadastro = '").append("R").append("' then a.ent_codigo ");
                buf.append("  else a.ent_codigo ");
                buf.append("end as codigoCadastro ");
                buf.append("      ,case ");
                buf.append("            when a.pac_codigo is not null then pac.pac_nome ");
                buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_fantasia ");
                buf.append("  \t\t\t\t\telse con.con_fantasia ");
                buf.append("\t\t\t end as fantasiaCadastro ");
                buf.append("      ,case ");
                buf.append("            when a.pac_codigo is not null then pac.pac_nomesocial ");
                buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_razaosocial ");
                buf.append("  \t\t\t\t\telse con.con_razao ");
                buf.append("\t\t\t end as razaoSocialCadastro ");
                buf.append("      ,case ");
                buf.append("            when a.pac_codigo is not null then pac.pac_fone ");
                buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_fone ");
                buf.append("  \t\t\t\t\telse con.con_fone ");
                buf.append("\t\t\t end as foneCadastro ");
                buf.append("      ,case ");
                buf.append("            when a.pac_codigo is not null then pac.pac_endereco ");
                buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_endereco ");
                buf.append("  \t\t\t\t\telse con.con_endereco ");
                buf.append("\t\t\t end as enderecoCadastro ");
                buf.append("      ,case ");
                buf.append("            when a.pac_codigo is not null then pac.pac_numeroendereco ");
                buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_numeroendereco ");
                buf.append("  \t\t\t\t\telse con.con_numeroendereco ");
                buf.append("\t\t\t end as numeroEnderecoCadastro ");
                buf.append("      ,case ");
                buf.append("            when a.pac_codigo is not null then pac.pac_tipologradouroendereco ");
                buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_tipologradouroendereco ");
                buf.append("  \t\t\t\t\telse con.con_tipologradouroendereco ");
                buf.append("\t\t\t end as tipoLogradouroCadastro ");
                buf.append("      ,case ");
                buf.append("            when a.pac_codigo is not null then pac.pac_fax ");
                buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_fax ");
                buf.append("  \t\t\t\t\telse con.con_fax ");
                buf.append("\t\t\t end as faxCadastro ");
                buf.append("      ,case ");
                buf.append("            when a.pac_codigo is not null then pac.pac_complemento ");
                buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_complemento ");
                buf.append("  \t\t\t\t\telse con.con_complemento ");
                buf.append("\t\t\t end as complementoCadastro ");
                buf.append("      ,case ");
                buf.append("            when a.pac_codigo is not null then pac.pac_cpf ");
                buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_cpfcnpj ");
                buf.append("  \t\t\t\t\telse con.con_cnpjcpf ");
                buf.append("\t\t\t end as cpfCnpjCadastro ");
                buf.append("      ,case ");
                buf.append("            when a.pac_codigo is not null then pac.pac_cep ");
                buf.append("  \t\t\t\t\twhen a.ent_codigo is not null then ent.ent_cep ");
                buf.append("  \t\t\t\t\telse con.con_cep ");
                buf.append("\t\t\t end as cepCadastro, ");
                buf.append("nfi.nfi_numero as numeroNotaFiscal, ");
                buf.append("nfi.ser_codigo as serieNotaFiscal, ");
                buf.append("nfi.nfi_situacao as situacaoNotaFiscal, ");
                if (this.tipoRelatorio == 1) {
                    buf.append("fpg.fpg_descricao as descricaoFormaPgto, ");
                    buf.append("nfi.nfi_numerorps IS NOT NULL as isEletronica, ");
                }
                buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                buf.append("from receberpagar a ");
                buf.append("left join usuario usuariocancela on a.usr_codcancelado = usuariocancela.usr_codigo ");
                buf.append("left join usuario usrrecpag on a.usr_codigo = usrrecpag.usr_codigo ");
                buf.append("left join series s on a.fil_codigo = s.fil_codigo and a.ser_codigo = s.ser_codigo ");
                buf.append("left join entidade ent on a.fil_codigo = ent.fil_codigo and a.ent_codigo = ent.ent_codigo ");
                buf.append("left join convenios con on a.fil_codigo = con.fil_codigo and a.con_codigo = con.con_codigo ");
                buf.append("left join paciente pac on a.fil_codigo = pac.fil_codigo and a.pac_codigo = pac.pac_codigo ");
                if (this.tipoRelatorio == 0 || this.tipoRelatorio == 2 || this.tipoRelatorio == 3) {
                    buf.append("left join notafiscal nfi on (a.fil_codigo = nfi.fil_codigo and a.nfi_codigo = nfi.nfi_codigo) ");
                } else {
                    buf.append("join notafiscal nfi on (a.fil_codigo = nfi.fil_codigo and a.nfi_codigo = nfi.nfi_codigo) ");
                    buf.append("left join formapagto fpg on (nfi.fil_codigo = fpg.fil_codigo and nfi.fpg_codigo = fpg.fpg_codigo) ");
                }
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                buf.append("where a.fil_codigo ");
                String[] filiais = null;
                if (this.naoPermiteFiltrarFilial()) {
                    buf.append(" = ").append(Variaveis.filialPadrao);
                } else {
                    filiais = this.getSelecionadosFiltro("filtroFilial", 0);
                    if (filiais == null || filiais.length == 0) {
                        buf.append(" = ").append(Variaveis.filialPadrao);
                    } else {
                        buf.append(" in (");
                        for (int i = 0; i < filiais.length; ++i) {
                            buf.append(filiais[i]);
                            if (i >= filiais.length - 1) continue;
                            buf.append(", ");
                        }
                        buf.append(")");
                    }
                }
                String[] usuario = this.getSelecionadosFiltro("filtroUsuario", 0);
                if (usuario != null) {
                    buf.append(" and a.usr_codigo in (");
                    for (int i = 0; i < usuario.length; ++i) {
                        buf.append("'");
                        buf.append(usuario[i]);
                        buf.append("'");
                        if (i >= usuario.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                StringBuilder bufUsuario = new StringBuilder();
                String[] convenio = this.getSelecionadosFiltro("filtroConvenio", 0);
                if (convenio != null) {
                    bufUsuario.append(" a.con_codigo in (");
                    for (int i = 0; i < convenio.length; ++i) {
                        bufUsuario.append(convenio[i]);
                        if (i >= convenio.length - 1) continue;
                        bufUsuario.append(", ");
                    }
                    bufUsuario.append(")");
                }
                if ((entidade = this.getSelecionadosFiltro("filtroEntidade", 0)) != null) {
                    if (bufUsuario.length() > 0) {
                        bufUsuario.append(" or ");
                    }
                    bufUsuario.append(" a.ent_codigo in (");
                    for (int i = 0; i < entidade.length; ++i) {
                        bufUsuario.append("'");
                        bufUsuario.append(entidade[i]);
                        bufUsuario.append("'");
                        if (i >= entidade.length - 1) continue;
                        bufUsuario.append(", ");
                    }
                    bufUsuario.append(")");
                }
                if ((paciente = this.getSelecionadosFiltroAvancado("filtroPaciente", 0)) != null) {
                    if (bufUsuario.length() > 0) {
                        bufUsuario.append(" or ");
                    }
                    bufUsuario.append(" a.pac_codigo in (");
                    for (int i = 0; i < paciente.length; ++i) {
                        bufUsuario.append(paciente[i]);
                        if (i >= paciente.length - 1) continue;
                        bufUsuario.append(", ");
                    }
                    bufUsuario.append(")");
                }
                if (bufUsuario.length() > 0) {
                    buf.append(" and (").append(bufUsuario.toString()).append(") ");
                }
                if ((serie = this.getSelecionadosFiltro("filtroSerie", 0)) != null) {
                    buf.append(" and a.ser_codigo in (");
                    for (int i = 0; i < serie.length; ++i) {
                        buf.append("'");
                        buf.append(serie[i]);
                        buf.append("'");
                        if (i >= serie.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                    buf.append(" and cast(a." + this.CAMPOSDATABANCO[this.getFiltroComboIndice("filtroCampoData")] + " as date) >= '");
                    buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial")));
                    buf.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                    buf.append(" and cast(a." + this.CAMPOSDATABANCO[this.getFiltroComboIndice("filtroCampoData")] + " as date) <= '");
                    buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal")));
                    buf.append("'");
                }
                if (!this.getFiltroCombo("filtroTipo").equals(this.tipo[0])) {
                    if (this.getFiltroCombo("filtroTipo").equals(this.tipo[1])) {
                        buf.append(" and a.rpg_tipo = '").append("P").append("' ");
                    } else {
                        buf.append(" and a.rpg_tipo = '").append("R").append("' ");
                    }
                }
                if (this.getFiltroCombo("filtroSituacao").equals(this.situacao[0])) {
                    buf.append(" and a.rpg_situacao IN ('").append("A").append("', '");
                    buf.append("Q").append("'");
                    if (this.getFiltroCheck("filtroConsiderarPreviaAberto")) {
                        buf.append(", '").append("F").append("'");
                    }
                    buf.append(") ");
                } else if (this.getFiltroCombo("filtroSituacao").equals(this.situacao[1])) {
                    buf.append(" and a.rpg_situacao IN ('").append("A").append("', '");
                    buf.append("Q").append("', '");
                    buf.append("L").append("', '");
                    buf.append("G").append("', '");
                    buf.append("E").append("', '");
                    buf.append("R").append("', '");
                    buf.append("V").append("', '");
                    buf.append("T").append("', '");
                    buf.append("N").append("', '");
                    buf.append("P").append("', '");
                    buf.append("F").append("', '");
                    buf.append("S").append("') ");
                } else if (this.getFiltroCombo("filtroSituacao").equals(this.situacao[2])) {
                    buf.append(" and a.rpg_situacao IN ('").append("A").append("'");
                    if (this.getFiltroCheck("filtroConsiderarPreviaAberto")) {
                        buf.append(", '").append("F").append("'");
                    }
                    buf.append(") ");
                } else if (this.getFiltroCombo("filtroSituacao").equals(this.situacao[3])) {
                    buf.append(" and a.rpg_situacao = '").append("Q").append("' ");
                } else if (this.getFiltroCombo("filtroSituacao").equals(this.situacao[4])) {
                    buf.append(" and a.rpg_situacao = '").append("L").append("' ");
                } else if (this.getFiltroCombo("filtroSituacao").equals(this.situacao[5])) {
                    buf.append(" and a.rpg_situacao = '").append("G").append("' ");
                } else if (this.getFiltroCombo("filtroSituacao").equals(this.situacao[6])) {
                    buf.append(" and a.rpg_situacao = '").append("E").append("' ");
                } else if (this.getFiltroCombo("filtroSituacao").equals(this.situacao[7])) {
                    buf.append(" and a.rpg_situacao = '").append("R").append("' ");
                } else if (this.getFiltroCombo("filtroSituacao").equals(this.situacao[8])) {
                    buf.append(" and a.rpg_situacao = '").append("V").append("' ");
                } else if (this.getFiltroCombo("filtroSituacao").equals(this.situacao[9])) {
                    buf.append(" and a.rpg_situacao = '").append("T").append("' ");
                } else if (this.getFiltroCombo("filtroSituacao").equals(this.situacao[10])) {
                    buf.append(" and a.rpg_situacao = '").append("S").append("' ");
                } else if (this.getFiltroCombo("filtroSituacao").equals(this.situacao[11])) {
                    buf.append(" and a.rpg_situacao = '").append("N").append("' ");
                } else if (this.getFiltroCombo("filtroSituacao").equals(this.situacao[12])) {
                    buf.append(" and a.rpg_situacao = '").append("P").append("' ");
                } else if (this.getFiltroCombo("filtroSituacao").equals(this.situacao[13])) {
                    buf.append(" and a.rpg_situacao = '").append("F").append("' ");
                }
                if (this.getFiltroCombo("filtroTipoCadastro").equals(this.tipoCadastro[1])) {
                    buf.append(" and a.rpg_tipocadastro = '").append("U").append("' ");
                } else if (this.getFiltroCombo("filtroTipoCadastro").equals(this.tipoCadastro[2])) {
                    buf.append(" and a.rpg_tipocadastro = '").append("F").append("' ");
                } else if (this.getFiltroCombo("filtroTipoCadastro").equals(this.tipoCadastro[3])) {
                    buf.append(" and a.rpg_tipocadastro = '").append("C").append("' ");
                } else if (this.getFiltroCombo("filtroTipoCadastro").equals(this.tipoCadastro[4])) {
                    buf.append(" and a.rpg_tipocadastro = '").append("R").append("' ");
                } else if (this.getFiltroCombo("filtroTipoCadastro").equals(this.tipoCadastro[5])) {
                    buf.append(" and a.rpg_tipocadastro = '").append("P").append("' ");
                } else if (this.getFiltroCombo("filtroTipoCadastro").equals(this.tipoCadastro[6])) {
                    buf.append(" and a.rpg_tipocadastro = '").append("O").append("' ");
                }
                if (!this.getFiltroCombo("filtroTipoDocumento").equals(this.tipoDocumento[0])) {
                    if (this.getFiltroCombo("filtroTipoDocumento").equals(this.tipoDocumento[1])) {
                        buf.append(" and a.rpg_tipodocumento = '").append("B").append("' ");
                    } else if (this.getFiltroCombo("filtroTipoDocumento").equals(this.tipoDocumento[2])) {
                        buf.append(" and a.rpg_tipodocumento = '").append("D").append("' ");
                    } else if (this.getFiltroCombo("filtroTipoDocumento").equals(this.tipoDocumento[4])) {
                        buf.append(" and a.rpg_tipodocumento = '").append("A").append("' ");
                    } else {
                        buf.append(" and a.rpg_tipodocumento = '").append("C").append("' ");
                    }
                }
                if (!this.getFiltroTexto("filtroNumeroDocumento").isEmpty()) {
                    buf.append(" and a.rpg_numerodocumento ILIKE '%").append(StringUtil.textoDB(this.getFiltroTexto("filtroNumeroDocumento"))).append("%' ");
                }
                if (!Funcoes.textoVazio(this.getFiltroDecimal("filtroValorInicial"))) {
                    buf.append(" and a.rpg_valor >= ").append(this.getFiltroTexto("filtroValorInicial")).append(" ");
                }
                if (!Funcoes.textoVazio(this.getFiltroDecimal("filtroValorFinal"))) {
                    buf.append(" and a.rpg_valor <= ").append(this.getFiltroTexto("filtroValorFinal")).append(" ");
                }
                String indiceOrdem = (String)this.getFiltroCombo("ordemRelatorio");
                if (this.tipoRelatorio == 0) {
                    buf.append(" order by a.fil_codigo ");
                    if (!(indiceOrdem.equals("C\u00f3d (sem tipo)") || indiceOrdem.equals("Doc (sem tipo)") || indiceOrdem.equals("Venc (sem tipo)"))) {
                        buf.append(", a.rpg_tipo ");
                    }
                } else if (this.tipoRelatorio == 1) {
                    buf.append(" order by nfi.fil_codigo, nfi.nfi_numero, numeroParcelaReceberPagar ");
                } else if (this.tipoRelatorio == 2) {
                    buf.append(" order by a.fil_codigo ");
                    if (this.getFiltroCombo("filtroOrdemAgrupamento").equals(this.ordemAgrupamento[0])) {
                        buf.append(",fantasiaCadastro, ");
                    } else {
                        buf.append(",codigoCadastro, ");
                    }
                    buf.append("a.rpg_tipo, a.rpg_vencimento ");
                } else {
                    buf.append(" order by a.fil_codigo, a.rpg_vencimento ");
                    if (!(indiceOrdem.equals("C\u00f3d (sem tipo)") || indiceOrdem.equals("Doc (sem tipo)") || indiceOrdem.equals("Venc (sem tipo)"))) {
                        buf.append(", a.rpg_tipo ");
                    }
                }
                if (!indiceOrdem.equals("Cadastro")) {
                    buf.append(", a.").append(this.CAMPOSBANCOORDEM[this.getFiltroComboIndice("ordemRelatorio")]);
                }
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                this.totalReceber = new BigDecimal("0");
                this.totalPagar = new BigDecimal("0");
                if (rs.next()) {
                    int i;
                    ModeloGridTable modelo = new ModeloGridTable(campos){

                        @Override
                        public String getColumnName(int column) {
                            return this.colunas[column];
                        }
                    };
                    do {
                        Object[] o = new Object[campos.length];
                        if (rs.getString("tipoReceberPagar").equals("P")) {
                            this.totalPagar = this.totalPagar.add(rs.getBigDecimal("valorTotalReceberPagar"));
                        } else {
                            this.totalReceber = this.totalReceber.add(rs.getBigDecimal("valorTotalReceberPagar"));
                        }
                        int pos = -1;
                        for (i = 0; i < campos.length; ++i) {
                            pos = modelo.findColumn(campos[i]);
                            if (campos[i].equalsIgnoreCase("tipoLogradouroCadastro")) {
                                o[pos] = Tipos.tipoLogradouroDescricao(rs.getString(campos[i]));
                                continue;
                            }
                            if (campos[i].equals("tipoReceberPagar")) {
                                o[pos] = Tipos.tipoReceberPagar(rs.getString(campos[i]));
                                continue;
                            }
                            if (campos[i].equals("valorTotalReceberPagar") || campos[i].equals("valorReceberPagar") || campos[i].equals("valorTaxaTotalReceberPagar")) {
                                o[pos] = Float.valueOf(rs.getFloat(campos[i]));
                                if (rs.getString("tipoReceberPagar").equals("R")) {
                                    o[modelo.findColumn((String)new StringBuilder().append((String)RelatorioReceberPagar.campos[i]).append((String)"ComSinal").toString())] = rs.getDouble(campos[i]);
                                    continue;
                                }
                                double aux = rs.getDouble(campos[i]);
                                o[modelo.findColumn((String)new StringBuilder().append((String)RelatorioReceberPagar.campos[i]).append((String)"ComSinal").toString())] = aux == 0.0 ? 0.0 : aux * -1.0;
                                continue;
                            }
                            if (campos[i].equals("valorDescontoReceberPagar")) {
                                o[pos] = Float.valueOf(rs.getFloat(campos[i]));
                                if (rs.getString("tipoReceberPagar").equals("R")) {
                                    double aux = rs.getDouble(campos[i]);
                                    o[modelo.findColumn((String)new StringBuilder().append((String)RelatorioReceberPagar.campos[i]).append((String)"ComSinal").toString())] = aux == 0.0 ? 0.0 : aux * -1.0;
                                    continue;
                                }
                                o[modelo.findColumn((String)new StringBuilder().append((String)RelatorioReceberPagar.campos[i]).append((String)"ComSinal").toString())] = rs.getDouble(campos[i]);
                                continue;
                            }
                            if (campos[i].equals("valorImpostosReceberPagar")) {
                                o[pos] = Float.valueOf(rs.getFloat(campos[i]));
                                double aux = rs.getDouble(campos[i]);
                                o[modelo.findColumn((String)new StringBuilder().append((String)RelatorioReceberPagar.campos[i]).append((String)"ComSinal").toString())] = aux == 0.0 ? 0.0 : aux * -1.0;
                                continue;
                            }
                            if (campos[i].equals("tipoDocumentoReceberPagar")) {
                                o[pos] = Tipos.tipoDocumento(rs.getString(campos[i]));
                                continue;
                            }
                            if (campos[i].equals("situacaoReceberPagar")) {
                                o[pos] = Tipos.tipoSituacaoReceberPagar(rs.getString(campos[i]));
                                continue;
                            }
                            if (campos[i].equals("tipoCadastroReceberPagar")) {
                                o[pos] = Tipos.tipoCadastro(rs.getString(campos[i]));
                                continue;
                            }
                            if (campos[i].equals("situacaoNotaFiscal")) {
                                if (this.tipoRelatorio != 1) continue;
                                o[pos] = Tipos.tipoSituacaoNotaFiscal(rs.getString(campos[i]), rs.getBoolean("isEletronica"));
                                continue;
                            }
                            try {
                                o[pos] = rs.getObject(campos[i]);
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        modelo.addLine(o);
                    } while (rs.next());
                    if (indiceOrdem.equals("Cadastro")) {
                        modelo.ordenarColuna(modelo.findColumn("fantasiaCadastro"), 1);
                    }
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(RelatorioReceberPagar.getModuloAcesso(this.tipoRelatorio));
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(0.5f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioReceberPagar.this.panelCentro.removeAll();
                                RelatorioReceberPagar.this.panelCentro.repaint();
                                RelatorioReceberPagar.this.habilitaBotaoImprimir(true);
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                        var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                        var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                        var.put("filtroNumeroDocumento", this.getFiltroTexto("filtroNumeroDocumento"));
                        var.put("filtroValorInicial", this.getFiltroDecimal("filtroValorInicial"));
                        var.put("filtroValorFinal", this.getFiltroDecimal("filtroValorFinal"));
                        var.put("filtroTipo", this.getFiltroCombo("filtroTipo"));
                        var.put("filtroTipoDocumento", this.getFiltroCombo("filtroTipoDocumento"));
                        var.put("filtroTipoCadastro", this.getFiltroCombo("filtroTipoCadastro"));
                        var.put("filtroSituacao", this.getFiltroCombo("filtroSituacao"));
                        var.put("filtroCampoData", this.getFiltroCombo("filtroCampoData"));
                        if (this.tipoRelatorio == 2) {
                            var.put("filtroOrdemAgrupamento", this.getFiltroCombo("filtroOrdemAgrupamento"));
                        }
                        var.put("totalGeralPagar", this.totalPagar);
                        var.put("totalGeralReceber", this.totalReceber);
                        buf.delete(0, buf.length());
                        if (serie != null) {
                            for (i = 0; i < serie.length; ++i) {
                                buf.append(serie[i]);
                                if (i >= serie.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroSerie", buf.toString());
                        buf.delete(0, buf.length());
                        if (convenio != null) {
                            for (i = 0; i < convenio.length; ++i) {
                                buf.append(convenio[i]);
                                if (i >= convenio.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroConvenio", buf.toString());
                        buf.delete(0, buf.length());
                        if (entidade != null) {
                            for (i = 0; i < entidade.length; ++i) {
                                buf.append(entidade[i]);
                                if (i >= entidade.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroEntidade", buf.toString());
                        buf.delete(0, buf.length());
                        if (paciente != null) {
                            for (i = 0; i < paciente.length; ++i) {
                                buf.append(paciente[i]);
                                if (i >= paciente.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroPaciente", buf.toString());
                        buf.delete(0, buf.length());
                        if (filiais != null) {
                            for (i = 0; i < filiais.length; ++i) {
                                buf.append(filiais[i]);
                                if (i >= filiais.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        if (this.naoPermiteFiltrarFilial()) {
                            var.put("filtroFilial", Variaveis.filialPadrao);
                        } else {
                            var.put("filtroFilial", buf.toString());
                        }
                        buf.delete(0, buf.length());
                        if (usuario != null) {
                            for (i = 0; i < usuario.length; ++i) {
                                buf.append(usuario[i]);
                                if (i >= usuario.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put("filtroUsuario", buf.toString());
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelCentro.revalidate();
                    }
                    break block126;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st, st2);
                    throw throwable;
                }
                Conexao.fecharStatement(st, st2);
            }
        }
        Conexao.fecharStatement(st, st2);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private String montaCaseImpostos(String impostoNotaFiscal, String impostoNotaFiscalRetido, String impostoReceberPagar) {
        StringBuilder buf = new StringBuilder();
        buf.append(" CASE WHEN a.nfi_codigo IS NOT NULL AND ").append(this.montaSomaImpostos(impostoReceberPagar.contains("percentual"))).append("  THEN nfi.").append(impostoNotaFiscal);
        if (!Funcoes.textoVazio(impostoNotaFiscalRetido)) {
            buf.append("    WHEN a.nfi_codigo IS NOT NULL AND ").append(this.montaSomaImpostosRetido(impostoReceberPagar.contains("percentual"))).append("  THEN nfi.").append(impostoNotaFiscalRetido);
        }
        buf.append(" ELSE ").append(" a.").append(impostoReceberPagar).append(" END ");
        return buf.toString();
    }

    private String montaSomaImpostosRetido(boolean isPercentual) {
        StringBuilder buf = new StringBuilder();
        if (!isPercentual) {
            buf.append("     (COALESCE(COALESCE(nfi.nfi_irrfretidovalor,0) ");
            buf.append("    + COALESCE(nfi.nfi_issretidovalor,0) ");
            buf.append("    + COALESCE(nfi.nfi_pisretidovalor,0) ");
            buf.append("    + COALESCE(nfi.nfi_csllretidovalor,0) ");
            buf.append("    + COALESCE(nfi.nfi_cofinsretidovalor,0) ");
            buf.append("    + COALESCE(nfi.nfi_inssretidovalor,0),0) > 0) ");
        } else {
            buf.append("     (COALESCE(COALESCE(nfi.nfi_irrfretidopercentual,0) ");
            buf.append("    + COALESCE(nfi.nfi_issretidopercentual,0) ");
            buf.append("    + COALESCE(nfi.nfi_pisretidopercentual,0) ");
            buf.append("    + COALESCE(nfi.nfi_csllretidopercentual,0) ");
            buf.append("    + COALESCE(nfi.nfi_cofinsretidopercentual,0) ");
            buf.append("    + COALESCE(nfi.nfi_inssretidopercentual,0),0) > 0) ");
        }
        return buf.toString();
    }

    private String montaSomaImpostos(boolean isPercentual) {
        StringBuilder buf = new StringBuilder();
        if (!isPercentual) {
            buf.append("    (COALESCE(COALESCE(nfi.nfi_irrfvalor,0) ");
            buf.append("    + COALESCE(nfi.nfi_issvalor,0) ");
            buf.append("    + COALESCE(nfi.nfi_pisvalor,0) ");
            buf.append("    + COALESCE(nfi.nfi_csllvalor,0) ");
            buf.append("    + COALESCE(nfi.nfi_cofinsvalor,0) ");
            buf.append("    + COALESCE(nfi.nfi_inssvalor,0) ");
            buf.append("    + COALESCE(nfi.nfi_ipivalor,0) ");
            buf.append("    + COALESCE(nfi.nfi_icmsvalor,0),0) > 0) ");
        } else {
            buf.append("    (COALESCE(COALESCE(nfi.nfi_irrfpercentual,0) ");
            buf.append("    + COALESCE(nfi.nfi_isspercentual,0) ");
            buf.append("    + COALESCE(nfi.nfi_pispercentual,0) ");
            buf.append("    + COALESCE(nfi.nfi_csllpercentual,0) ");
            buf.append("    + COALESCE(nfi.nfi_cofinspercentual,0) ");
            buf.append("    + COALESCE(nfi.nfi_insspercentual,0) ");
            buf.append("    + COALESCE(nfi.nfi_ipipercentual,0) ");
            buf.append("    + COALESCE(nfi.nfi_icmspercentual,0),0) > 0) ");
        }
        return buf.toString();
    }

    public static long getModuloAcesso(int tipoRelatorio) {
        if (tipoRelatorio == 0) {
            return Long.parseLong("0850500100");
        }
        if (tipoRelatorio == 1) {
            return Long.parseLong("0851100100");
        }
        if (tipoRelatorio == 2) {
            return Long.parseLong("0851200100");
        }
        return Long.parseLong("0851900100");
    }

    public static long getModuloConfigurar(int tipoRelatorio) {
        if (tipoRelatorio == 0) {
            return Long.parseLong("0850500101");
        }
        if (tipoRelatorio == 1) {
            return Long.parseLong("0851100101");
        }
        if (tipoRelatorio == 2) {
            return Long.parseLong("0851200101");
        }
        return Long.parseLong("0851900101");
    }

    public static long getModuloAcessoNaoPermiteFiltrarFilial() {
        return Long.parseLong("0850500102");
    }

    public boolean naoPermiteFiltrarFilial() {
        return Acesso.getAcesso(RelatorioReceberPagar.getModuloAcessoNaoPermiteFiltrarFilial());
    }
}

