/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.movimento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioRecPagLanctoPlano
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private static final String[] tipoPlanoConta = new String[]{"Todos", Tipos.tipoPlanoContas("R"), Tipos.tipoPlanoContas("D")};
    private static final String[] ordem = new String[]{"C\u00f3digo", "N\u00fam. Doc.", "Dt. Cadastro", "Dt. Vencimento", "Valor Plano"};
    private static final String[] camposOrdemRecPag = new String[]{"rpg.rpg_codigo", "rpg.rpg_numerodocumento", "rpg.rpg_datahora", "rpg.rpg_vencimento", "valorReceberPagarPlanoComSinal"};
    private static final String[] camposOrdemLancto = new String[]{"lcx.lcx_codigo", "lcx.lcx_documento", "lcx.lcx_datahora", "lcx.lcx_vencimento", "valorLancamentoPlanoComSinal"};
    private static final String[] situacaoRecPag = new String[]{"Todos", Tipos.tipoSituacaoReceberPagar("A"), Tipos.tipoSituacaoReceberPagar("Q"), Tipos.tipoSituacaoReceberPagar("V"), Tipos.tipoSituacaoReceberPagar("T"), Tipos.tipoSituacaoReceberPagar("S")};
    private static final String[] situacaoLancto = new String[]{"Todos", Tipos.tipoSituacaoLancamento("A"), Tipos.tipoSituacaoLancamento("O")};
    private static final String[] tipoRecPag = new String[]{"Todos", Tipos.tipoReceberPagar("R"), Tipos.tipoReceberPagar("P")};
    private static final String[] tipoLancto = new String[]{"Todos", Tipos.tipoLancamentoCaixa("C"), Tipos.tipoLancamentoCaixa("D")};
    private static final String FILTRO_PLANO_CONTA = "filtroPlanoConta";
    private static final String FILTRO_FILIAL_PLANO_CONTA = "filtroFilialPlanoConta";
    private static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private static final String FILTRO_VALOR_INICIAL = "filtroValorInicial";
    private static final String FILTRO_VALOR_FINAL = "filtroValorFinal";
    private static final String FILTRO_TIPO_PLANO = "filtroTipoPlanoConta";
    private static final String FILTRO_USUARIO = "filtroUsuario";
    private static final String FILTRO_ORIGEM = "filtroOrigem";
    private static final String FILTRO_CAMPO_DATA = "filtroData";
    private static final String FILTRO_ORDEM = "filtroOrdem";
    private static final String FILTRO_SITUACAO = "filtroSituacao";
    private static final String FILTRO_TIPO = "filtroTipo";
    private static final String FILTRO_CONVENIO = "filtroConvenio";
    private static final String FILTRO_ENTIDADE = "filtroEntidade";
    private static final String FILTRO_PACIENTE = "filtroPaciente";
    private static final String FILTRO_CONTA = "filtroConta";
    private static final String[] CAMPOSDATALANCTO = new String[]{"Vencimento", "Compet\u00eancia", "Cadastro", "Concilia\u00e7\u00e3o"};
    private static final String[] CAMPOSDATABANCOLANCTO = new String[]{"lcx_vencimento", "lcx_competencia", "lcx_datahora", "lcx_conciliacao"};
    private static final String[] CAMPOSDATARECPAG = new String[]{"Vencimento", "Documento", "Cadastro", "Processamento", "Compet\u00eancia"};
    private static final String[] CAMPOSDATABANCORECPAG = new String[]{"rpg_vencimento", "rpg_datadocumento", "rpg_datahora", "rpg_dataprocessamento", "rpg_competencia"};
    public static final int TIPO_RECEBERPAGAR = 0;
    public static final int TIPO_LANCAMENTO = 1;
    private int tipoRelatorio = 0;
    private String[] camposRelatorio = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"reduzidoPlanoConta", "descricaoPlanoConta", "contaPlanoConta", "tipoPlanoConta", "apropriarPlanoConta", "filialPlanoConta", "nivelPlanoConta", "paiPlanoConta", "totalPlanoConta", "valorSomatorio", "totalPlanoContaComSinal", "valorSomatorioComSinal", "operacaoPlanoConta"});
    private static final String[] camposLancamento = new String[]{"codigoLancamento", "tipoPagamentoLancamento", "contaLancamento", "documentoLancamento", "valorLancamento", "valorTotalLancamento", "vencimentoLancamento", "tipoLancamento", "valorLancamentoPlano", "codigoOrigemLancamentoPlano", "competenciaLancamento", "conciliacaoLancamento", "emissaoLancamento", "valorLancamentoPlanoComSinal", "situacaoLancamento", "contaCorrente", "codigoContaCorrente", "contaCorrente", "titularContaCorrente", "tipoContaCorrente", "agenciaContaCorrente", "bancoContaCorrente", "contaCorrenteInativa", "somatorioValorLancamentosNaoApropriados", "saldoAnteriorContas", "valorFinalPeriodoContas"};
    private static final String[] camposRecPag = new String[]{"codigoReceberPagar", "vencimentoReceberPagar", "tipoReceberPagar", "tipoDocumentoReceberPagar", "numeroDocumentoReceberPagar", "parcelaReceberPagar", "dataDocumentoReceberPagar", "dataProcessamentoReceberPagar", "codigoSerieReceberPagar", "situacaoReceberPagar", "valorReceberPagar", "valorTotalReceberPagar", "valorReceberPagarPlanoComSinal", "valorReceberPagarPlano", "dataHoraReceberPagar", "codigoOrigemReceberPagar", "competenciaReceberPagar", "dataVencimentoLancamentoBaixa", "dataCompetenciaLancamentoBaixa", "dataConciliacaoLancamentoBaixa", "codigoBaixa", "situacaoLancamentoBaixa"};
    private static final String[] camposCadastros = new String[]{"codigoCadastro", "fantasiaCadastro", "nomeSocialPaciente", "razaoSocialCadastro", "foneCadastro", "enderecoCadastro", "faxCadastro", "complementoCadastro", "cepCadastro", "numeroEnderecoCadastro", "codigoCidadeCadastro", "nomeCidadeCadastro", "tipoLogradouroCadastro"};

    public RelatorioRecPagLanctoPlano(int tipoRelatorio) {
        this.tipoRelatorio = tipoRelatorio;
        if (this.tipoRelatorio == 0) {
            this.montaBarraDescricao("Relat\u00f3rio de Receber/Pagar por Plano de Contas", "Movimenta\u00e7\u00e3o de T\u00edtulos nos planos de contas", "relatorios/rel_rec_pag_por_plano_de_contas.jpg");
        } else if (this.tipoRelatorio == 1) {
            this.montaBarraDescricao("Relat\u00f3rio de Lan\u00e7amentos por Plano de Contas", "Movimenta\u00e7\u00e3o nos planos de contas", "relatorios/rel_lancamento_por_plano_de_contas.jpg");
        } else {
            Funcoes.mensagem(this, "Tipo de relat\u00f3rio incorreto.", 1);
            return;
        }
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro(FILTRO_FILIAL_PLANO_CONTA, "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_USUARIO, "Usu\u00e1rio", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_PLANO_CONTA, "Plano Contas", "planoconta", "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"plc_reduzido", "plc_conta", "plc_descricao"}, new String[]{"C\u00f3digo", "Conta", "Descri\u00e7\u00e3o"}, new int[]{70, 120, 0});
        this.adicionaItemFiltro(FILTRO_ORIGEM, "Origem", "origemplanocusto", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"opc_codigo", "opc_descricao", "opc_padrao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Padr\u00e3o"}, new int[]{70, 0, 50});
        if (tipoRelatorio == 1) {
            this.adicionaItemFiltro(FILTRO_CONTA, "Conta", "contacorrente", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"cco_reduzido", "cco_conta", "bac_codigo", "age_codigo", "cco_inativa"}, new String[]{"C\u00f3digo", "Conta", "Banco", "Ag\u00eancia", "Inativa"}, new int[]{60, 0, 50, 60, 55});
            this.adicionaFiltroCombo(FILTRO_CAMPO_DATA, "Campo Data:", CAMPOSDATALANCTO, 0);
        } else {
            this.adicionaItemFiltro(FILTRO_CONVENIO, "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Nome Fantasia"}, new int[]{70, 0});
            this.adicionaItemFiltro(FILTRO_ENTIDADE, "Entidade", "entidade", "fil_codigo = " + Variaveis.filialPadrao + " and ent_inativo = false", 1, new String[]{"ent_codigo", "ent_razaosocial"}, new String[]{"C\u00f3digo", "Raz\u00e3o Social"}, new int[]{70, 0});
            if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A") || Variaveis.tipoFilialPadrao.equalsIgnoreCase("V")) {
                this.adicionaItemFiltroAvancado(FILTRO_PACIENTE, "Paciente", "paciente", "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"pac_codigo", "pac_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0}, false, new int[]{70, 0});
            } else {
                this.adicionaItemFiltroAvancado(FILTRO_PACIENTE, "Paciente", "paciente", "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"pac_codigo", "pac_nome", "pac_nomesocial"}, new String[]{"C\u00f3digo", "Nome", "Nome Social"}, new int[]{70, 0, 0}, false, new int[]{70, 0, 0});
            }
            this.adicionaFiltroCombo(FILTRO_CAMPO_DATA, "Campo Data:", CAMPOSDATARECPAG, 0);
        }
        this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Data inicial:");
        this.adicionaFiltroData(FILTRO_DATA_FINAL, "Data final:");
        this.adicionaFiltroDecimal(FILTRO_VALOR_INICIAL, "Valor Inicial:", 0);
        this.adicionaFiltroDecimal(FILTRO_VALOR_FINAL, "Valor Final:", 0);
        this.adicionaFiltroCombo(FILTRO_TIPO_PLANO, "Tipo Plano:", tipoPlanoConta, 0);
        if (tipoRelatorio == 0) {
            this.adicionaFiltroCombo(FILTRO_SITUACAO, "Situa\u00e7\u00e3o:", situacaoRecPag, 0);
        } else {
            this.adicionaFiltroCombo(FILTRO_SITUACAO, "Situa\u00e7\u00e3o:", situacaoLancto, 0);
        }
        if (tipoRelatorio == 0) {
            this.adicionaRetornaFiltroCombo(FILTRO_TIPO, "Tipo:", tipoRecPag, 0);
        } else {
            this.adicionaRetornaFiltroCombo(FILTRO_TIPO, "Tipo:", tipoLancto, 0);
        }
        this.adicionaFiltroCombo(FILTRO_ORDEM, "Ordem:", ordem, 0);
        this.setModuloConfigurar(this.getConfigurarAcesso(this.tipoRelatorio));
        this.setModuloAcesso(RelatorioRecPagLanctoPlano.getModuloAcesso(this.tipoRelatorio));
        if (tipoRelatorio == 1) {
            this.setCamposConfigurador(ArraysUtil.concatenar(this.camposRelatorio, camposLancamento));
        } else {
            this.setCamposConfigurador(ArraysUtil.concatenar(ArraysUtil.concatenar(this.camposRelatorio, camposRecPag), camposCadastros));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement st2;
        Statement st;
        block167: {
            String[] paciente;
            String[] entidade;
            String combo;
            String[] usuario;
            st = Conexao.getStatement();
            st2 = Conexao.getStatement();
            String[] filiais = this.getSelecionadosFiltro(FILTRO_FILIAL_PLANO_CONTA, 0);
            if (filiais != null && filiais.length > 1) {
                Funcoes.mensagem(this, "Apenas uma filial deve ser selecionada para o relat\u00f3rio.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            if (!Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_INICIAL))) {
                Funcoes.mensagem(this, "A data inicial deve ser informada.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            StringBuilder whereRpg = new StringBuilder();
            StringBuilder whereRpl = new StringBuilder();
            whereRpg.append(" and lcx.fil_codigo = ").append(filiais == null ? Variaveis.filialPadrao : filiais[0]);
            if (this.tipoRelatorio == 1) {
                if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_INICIAL))) {
                    whereRpg.append(" and cast(lcx." + CAMPOSDATABANCOLANCTO[this.getFiltroComboIndice(FILTRO_CAMPO_DATA)] + " as date) >= '");
                    whereRpg.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_INICIAL)));
                    whereRpg.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_FINAL))) {
                    whereRpg.append(" and cast(lcx." + CAMPOSDATABANCOLANCTO[this.getFiltroComboIndice(FILTRO_CAMPO_DATA)] + " as date) <= '");
                    whereRpg.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_FINAL)));
                    whereRpg.append("'");
                }
            } else {
                if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_INICIAL))) {
                    whereRpg.append(" and cast(lcx." + CAMPOSDATABANCORECPAG[this.getFiltroComboIndice(FILTRO_CAMPO_DATA)] + " as date) >= '");
                    whereRpg.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_INICIAL)));
                    whereRpg.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_FINAL))) {
                    whereRpg.append(" and cast(lcx." + CAMPOSDATABANCORECPAG[this.getFiltroComboIndice(FILTRO_CAMPO_DATA)] + " as date) <= '");
                    whereRpg.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_FINAL)));
                    whereRpg.append("'");
                }
            }
            if (!Funcoes.textoVazio(this.getFiltroDecimal(FILTRO_VALOR_INICIAL))) {
                whereRpl.append(" and lcx.lcx_valortotal >= ");
                whereRpl.append(this.getFiltroTexto(FILTRO_VALOR_INICIAL));
                whereRpl.append(" ");
            }
            if (!Funcoes.textoVazio(this.getFiltroDecimal(FILTRO_VALOR_FINAL))) {
                whereRpl.append(" and lcx.lcx_valortotal <= ");
                whereRpl.append(this.getFiltroTexto(FILTRO_VALOR_FINAL));
                whereRpl.append(" ");
            }
            if ((usuario = this.getSelecionadosFiltro(FILTRO_USUARIO, 0)) != null) {
                whereRpg.append(" and (lcx.usr_codigo in (");
                for (int i = 0; i < usuario.length; ++i) {
                    whereRpg.append("'");
                    whereRpg.append(usuario[i]);
                    whereRpg.append("'");
                    if (i >= usuario.length - 1) continue;
                    whereRpg.append(", ");
                }
                whereRpg.append(") OR lcx.usr_codigo IS NULL)");
            }
            if (this.tipoRelatorio == 0) {
                combo = this.getFiltroCombo(FILTRO_SITUACAO).toString();
                if (combo.equals(situacaoRecPag[0])) {
                    whereRpg.append(" and rpg.rpg_situacao IN('");
                    whereRpg.append("A").append("', '").append("Q").append("', '");
                    whereRpg.append("V").append("', '").append("T").append("', '");
                    whereRpg.append("S").append("') ");
                } else {
                    whereRpg.append(" and rpg.rpg_situacao = '");
                    if (combo.equals(situacaoRecPag[1])) {
                        whereRpg.append("A");
                    } else if (combo.equals(situacaoRecPag[2])) {
                        whereRpg.append("Q");
                    } else if (combo.equals(situacaoRecPag[3])) {
                        whereRpg.append("V");
                    } else if (combo.equals(situacaoRecPag[4])) {
                        whereRpg.append("T");
                    } else if (combo.equals(situacaoRecPag[5])) {
                        whereRpg.append("S");
                    }
                    whereRpg.append("' ");
                }
            } else {
                combo = this.getFiltroCombo(FILTRO_SITUACAO).toString();
                if (combo.equals(situacaoLancto[0])) {
                    whereRpg.append(" and lcx.lcx_situacao IN('");
                    whereRpg.append("A").append("', '").append("O");
                    whereRpg.append("') ");
                } else {
                    whereRpg.append(" and lcx.lcx_situacao = '");
                    if (combo.equals(situacaoLancto[1])) {
                        whereRpg.append("A");
                    } else {
                        whereRpg.append("O");
                    }
                    whereRpg.append("' ");
                }
            }
            if (this.tipoRelatorio == 0) {
                combo = this.getFiltroCombo(FILTRO_TIPO).toString();
                if (combo.equals(tipoRecPag[0])) {
                    whereRpg.append(" and rpg.rpg_tipo IN('");
                    whereRpg.append("R").append("', '").append("P");
                    whereRpg.append("') ");
                } else {
                    whereRpg.append(" and rpg.rpg_tipo = '");
                    if (combo.equals(tipoRecPag[1])) {
                        whereRpg.append("R");
                    } else {
                        whereRpg.append("P");
                    }
                    whereRpg.append("' ");
                }
            } else {
                combo = this.getFiltroCombo(FILTRO_TIPO).toString();
                if (combo.equals(tipoLancto[0])) {
                    whereRpg.append(" and lcx.lcx_tipo IN('");
                    whereRpg.append("C").append("', '").append("D");
                    whereRpg.append("') ");
                } else {
                    whereRpg.append(" and lcx.lcx_tipo = '");
                    if (combo.equals(tipoLancto[1])) {
                        whereRpg.append("C");
                    } else {
                        whereRpg.append("D");
                    }
                    whereRpg.append("' ");
                }
            }
            String[] origem = this.getSelecionadosFiltro(FILTRO_ORIGEM, 0);
            if (origem != null) {
                whereRpl.append(" and lpc.opc_codigo in (");
                for (int i = 0; i < origem.length; ++i) {
                    whereRpl.append("'");
                    whereRpl.append(origem[i]);
                    whereRpl.append("'");
                    if (i >= origem.length - 1) continue;
                    whereRpl.append(", ");
                }
                whereRpl.append(")");
            }
            StringBuilder bufCadastros = new StringBuilder();
            String[] convenio = this.getSelecionadosFiltro(FILTRO_CONVENIO, 0);
            if (convenio != null) {
                bufCadastros.append(" rpg.con_codigo in (");
                for (int j = 0; j < convenio.length; ++j) {
                    bufCadastros.append(convenio[j]);
                    if (j >= convenio.length - 1) continue;
                    bufCadastros.append(", ");
                }
                bufCadastros.append(")");
            }
            if ((entidade = this.getSelecionadosFiltro(FILTRO_ENTIDADE, 0)) != null) {
                if (bufCadastros.length() > 0) {
                    bufCadastros.append(" or ");
                }
                bufCadastros.append(" rpg.ent_codigo in (");
                for (int j = 0; j < entidade.length; ++j) {
                    bufCadastros.append("'");
                    bufCadastros.append(entidade[j]);
                    bufCadastros.append("'");
                    if (j >= entidade.length - 1) continue;
                    bufCadastros.append(", ");
                }
                bufCadastros.append(")");
            }
            if ((paciente = this.getSelecionadosFiltroAvancado(FILTRO_PACIENTE, 0)) != null) {
                if (bufCadastros.length() > 0) {
                    bufCadastros.append(" or ");
                }
                bufCadastros.append(" rpg.pac_codigo in (");
                for (int j = 0; j < paciente.length; ++j) {
                    bufCadastros.append(paciente[j]);
                    if (j >= paciente.length - 1) continue;
                    bufCadastros.append(", ");
                }
                bufCadastros.append(")");
            }
            if (this.tipoRelatorio == 1) {
                StringBuilder bufCadastroConta = new StringBuilder();
                String[] contas = this.getSelecionadosFiltro(FILTRO_CONTA, 0);
                if (contas != null) {
                    bufCadastroConta.append(" and cco.cco_reduzido in (");
                    for (int j = 0; j < contas.length; ++j) {
                        bufCadastroConta.append(contas[j]);
                        if (j >= contas.length - 1) continue;
                        bufCadastroConta.append(", ");
                    }
                    bufCadastroConta.append(") ");
                    whereRpl.append(bufCadastroConta.toString());
                }
            }
            if (bufCadastros.length() > 0) {
                whereRpl.append(" and (").append(bufCadastros.toString()).append(") ");
            }
            try {
                int i;
                StringBuilder buf = new StringBuilder();
                buf.append("select ");
                buf.append("a.plc_reduzido as reduzidoPlanoConta, a.plc_descricao as descricaoPlanoConta, a.plc_conta as contaPlanoConta, ");
                buf.append("a.plc_tipo as tipoPlanoConta, a.plc_apropriar as apropriarPlanoConta, a.fil_codigo as filialPlanoConta, ");
                buf.append("a.plc_nivel as nivelPlanoConta, a.plc_pai as paiPlanoConta, a.plc_operacao as operacaoPlanoConta, ");
                if (this.tipoRelatorio == 1) {
                    buf.append("lcx.lcx_codigo as codigoLancamento, ");
                    buf.append("lcx.lcx_tipopagamento as tipoPagamentoLancamento, ");
                    buf.append("lcx.lcx_conta as contaLancamento, ");
                    buf.append("lcx.lcx_documento as documentoLancamento, ");
                    buf.append("lcx.lcx_vencimento as vencimentoLancamento, ");
                    buf.append("lcx.lcx_datahora as emissaoLancamento, ");
                    buf.append("lcx.lcx_conciliacao as conciliacaoLancamento, ");
                    buf.append("lcx.lcx_competencia as competenciaLancamento, ");
                    buf.append("lcx.lcx_tipo as tipoLancamento, ");
                    buf.append("lcx.opc_codigo as codigoOrigemLancamentoPlano, ");
                    buf.append("lcx.lcx_valor as valorLancamento, ");
                    buf.append("lcx.lcx_valortotal as valorTotalLancamento, ");
                    buf.append("lcx.lpl_valor as valorLancamentoPlano, ");
                    buf.append("lcx.lcx_situacao as situacaoLancamento, ");
                    buf.append("CASE WHEN a.plc_tipo = 'R' THEN ");
                    buf.append("     (CASE WHEN lcx.lcx_tipo = 'C' THEN ");
                    buf.append("          lcx.lpl_valor ");
                    buf.append("     ELSE lcx.lpl_valor * (-1) ");
                    buf.append("     END) ");
                    buf.append("ELSE lcx.lpl_valor * (-1) ");
                    buf.append("END as valorLancamentoPlanoComSinal, ");
                    buf.append("cco.cco_reduzido as codigoContaCorrente,  ");
                    buf.append("cco.cco_conta as contaCorrente,  ");
                    buf.append("cco.cco_titular as titularContaCorrente,  ");
                    buf.append("cco.cco_tipo as tipoContaCorrente,  ");
                    buf.append("cco.age_codigo as agenciaContaCorrente,  ");
                    buf.append("cco.bac_codigo as bancoContaCorrente,  ");
                    buf.append("cco.cco_inativa as contaCorrenteInativa, ");
                    buf.append("'' as somatorioValorLancamentosNaoApropriados, ");
                    buf.append("'' as saldoAnteriorContas, ");
                    buf.append("'' as valorFinalPeriodoContas, ");
                } else {
                    buf.append("rpg.rpg_datahora as dataHoraReceberPagar, ");
                    buf.append("rpg.rpg_competencia as competenciaReceberPagar, ");
                    buf.append("rpg.rpg_vencimento as vencimentoReceberPagar, ");
                    buf.append("rpg.rpg_codigo as codigoReceberPagar, ");
                    buf.append("rpg.rpg_tipo as tipoReceberPagar, ");
                    buf.append("rpg.rpg_tipodocumento as tipoDocumentoReceberPagar, ");
                    buf.append("rpg.rpg_numerodocumento as numeroDocumentoReceberPagar, ");
                    buf.append("rpg.rpg_parcela as parcelaReceberPagar, ");
                    buf.append("rpg.rpg_datadocumento as dataDocumentoReceberPagar, ");
                    buf.append("rpg.rpg_dataprocessamento as dataProcessamentoReceberPagar, ");
                    buf.append("rpg.ser_codigo as codigoSerieReceberPagar, ");
                    buf.append("rpg.rpg_situacao as situacaoReceberPagar, ");
                    buf.append("rpg.opc_codigo as codigoOrigemReceberPagar, ");
                    buf.append("rpg.rpg_valor as valorReceberPagar, ");
                    buf.append("rpg.rpg_valortotal as valorTotalReceberPagar, ");
                    buf.append("rpg.rpl_valor as valorReceberPagarPlano, ");
                    buf.append("CASE WHEN a.plc_operacao = 'A' THEN rpg.rpl_valor ELSE rpg.rpl_valor * (-1) END as valorReceberPagarPlanoComSinal, ");
                    buf.append(" rpg.rpg_tipocadastro as tipoCadastro, ");
                    buf.append(" CASE WHEN rpg.rpg_tipocadastro = '").append("P").append("' THEN rpg.pac_codigo ");
                    buf.append("      WHEN rpg.rpg_tipocadastro = '").append("O").append("' THEN rpg.con_codigo ");
                    buf.append("      ELSE rpg.ent_codigo END as codigoCadastro, ");
                }
                buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                buf.append("from planoconta a ");
                if (this.tipoRelatorio == 1) {
                    buf.append("left join (select lpc.*, lcx.lcx_tipo, lcx.lcx_tipopagamento, lcx.lcx_conta, lcx.lcx_documento, lcx.lcx_situacao, ");
                    buf.append(" lcx.lcx_valor, lcx.lcx_valortotal, lcx.lcx_vencimento, lcx.lcx_competencia, lcx.lcx_datahora, lcx.cco_reduzido, lcx.lcx_conciliacao ");
                    buf.append(" from lanctocaixaplanoconta lpc ");
                    buf.append(" join lanctocaixa lcx on lpc.fil_codigo = lcx.fil_codigo and lpc.lcx_codigo = lcx.lcx_codigo and lpc.est_codigo = lcx.est_codigo ");
                    buf.append(" join contacorrente cco on lcx.fil_codigo = cco.fil_codigo and lcx.cco_reduzido = cco.cco_reduzido ");
                    buf.append("and lcx.fil_codigo = lpc.fil_codigo ");
                    buf.append("and lcx.lcx_situacao <> '").append("C").append("' ");
                    buf.append(whereRpg.toString() + whereRpl.toString());
                    buf.append(") as lcx on (a.plc_reduzido = lcx.plc_reduzido and a.fil_codigo = lcx.fil_codigo) ");
                    buf.append(" left join (select cco.cco_reduzido, ");
                    buf.append(" \t\tcco.cco_conta, ");
                    buf.append(" \t\tcco.cco_titular, ");
                    buf.append(" \t\tcco.cco_tipo, ");
                    buf.append(" \t\tcco.age_codigo, ");
                    buf.append(" \t\tcco.bac_codigo, ");
                    buf.append(" \t\tcco.cco_inativa, ");
                    buf.append(" \t\tcco.fil_codigo ");
                    buf.append(" from contacorrente as cco ) as cco ");
                    buf.append(" \t on (cco.fil_codigo = lcx.fil_codigo  ");
                    buf.append(" \tand cco.cco_reduzido = lcx.cco_reduzido) ");
                } else {
                    buf.append("left join (select rpl.plc_reduzido, rpl.rpl_valor, rpl.opc_codigo, rpg.* from receberpagarplanoconta rpl, receberpagar rpg where rpl.rpg_codigo = rpg.rpg_codigo ");
                    buf.append("and rpl.fil_codigo = rpg.fil_codigo and rpg.rpg_situacao IN ('").append("A").append("', '").append("Q").append("', '");
                    buf.append("V").append("', '").append("T").append("', '").append("S").append("') ");
                    buf.append(whereRpg.toString().replaceAll("lcx", "rpg").replaceAll("lpl", "rpl"));
                    buf.append(") as rpg on (a.plc_reduzido = rpg.plc_reduzido and a.fil_codigo = rpg.fil_codigo ");
                    buf.append(whereRpl.toString().replaceAll("lcx_valor ", "rpl_valor").replaceAll("lcx", "rpg").replaceAll("lpl", "rpl").replaceAll("lpc", "rpg"));
                    buf.append(") ");
                    buf.append(" left join notafiscal nfi on (rpg.nfi_codigo = nfi.nfi_codigo and rpg.fil_codigo = nfi.fil_codigo) ");
                }
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                buf.append("where a.fil_codigo ");
                if (filiais == null || filiais.length == 0) {
                    buf.append(" = ").append(Variaveis.filialPadrao);
                } else {
                    buf.append(" in (");
                    for (int i2 = 0; i2 < filiais.length; ++i2) {
                        buf.append(filiais[i2]);
                        if (i2 >= filiais.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                int maiorNivel = 0;
                ResultSet rs = null;
                try {
                    rs = Conexao.executeQuery(st, "select MAX(a.plc_nivel) as maiorNivel from planoconta a");
                    rs.next();
                    maiorNivel = rs.getInt("maiorNivel");
                }
                catch (Exception ex) {
                    maiorNivel = 0;
                }
                String[] planoconta = this.getSelecionadosFiltro(FILTRO_PLANO_CONTA, 0);
                if (planoconta != null) {
                    int i3;
                    buf.append(" and a.plc_reduzido in (");
                    ArrayList<Integer> arrayAux = new ArrayList<Integer>();
                    for (int i4 = 0; i4 < planoconta.length; ++i4) {
                        arrayAux.add(new Integer(planoconta[i4]));
                    }
                    ArrayList<Integer> arrayAcima = this.getPlanosAcima((ArrayList)arrayAux.clone());
                    ArrayList<Integer> arrayAbaixo = this.getPlanosAbaixo((ArrayList)arrayAux.clone());
                    if (arrayAcima != null) {
                        for (i3 = 0; i3 < arrayAcima.size(); ++i3) {
                            if (arrayAux.contains(arrayAcima.get(i3))) continue;
                            arrayAux.add(arrayAcima.get(i3));
                        }
                    }
                    if (arrayAbaixo != null) {
                        for (i3 = 0; i3 < arrayAbaixo.size(); ++i3) {
                            if (arrayAux.contains(arrayAbaixo.get(i3))) continue;
                            arrayAux.add(arrayAbaixo.get(i3));
                        }
                    }
                    for (i3 = 0; i3 < arrayAux.size(); ++i3) {
                        buf.append(arrayAux.get(i3));
                        if (i3 >= arrayAux.size() - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                if (!this.getFiltroCombo(FILTRO_TIPO_PLANO).toString().equals(tipoPlanoConta[0])) {
                    String combo2 = this.getFiltroCombo(FILTRO_TIPO_PLANO).toString();
                    buf.append(" and a.plc_tipo = '");
                    if (combo2.equals(tipoPlanoConta[1])) {
                        buf.append("R");
                    } else if (combo2.equals(tipoPlanoConta[2])) {
                        buf.append("D");
                    } else {
                        buf.append("C");
                    }
                    buf.append("'");
                }
                buf.append(" order by a.plc_conta, ");
                int indice = this.getFiltroComboIndice(FILTRO_ORDEM);
                if (this.tipoRelatorio == 0) {
                    buf.append(camposOrdemRecPag[indice]).append(", rpg.rpg_codigo ");
                } else {
                    buf.append(camposOrdemLancto[indice]).append(", lcx.lcx_codigo ");
                }
                rs = Conexao.executeQuery(st, buf.toString());
                BigDecimal somatorioAux = new BigDecimal(0).setScale(2, RoundingMode.HALF_UP);
                BigDecimal somatorioComSinalAux = new BigDecimal(0).setScale(2, RoundingMode.HALF_UP);
                arrayValoresPlanoConta arrayContas = null;
                if (rs.next()) {
                    maiorNivel = 0;
                    rs.last();
                    int qtdeLinhas = rs.getRow();
                    arrayContas = new arrayValoresPlanoConta(qtdeLinhas);
                    rs.first();
                    do {
                        if (rs.getInt("nivelPlanoConta") <= maiorNivel) continue;
                        maiorNivel = rs.getInt("nivelPlanoConta");
                    } while (rs.next());
                    for (i = maiorNivel; i > 0; --i) {
                        rs.first();
                        do {
                            if (rs.getInt("nivelPlanoConta") != i) continue;
                            if (this.tipoRelatorio == 1) {
                                arrayContas.somaValorConta(rs.getInt("reduzidoPlanoConta"), rs.getBigDecimal("valorLancamentoPlano"), rs.getBigDecimal("valorLancamentoPlanoComSinal"));
                            } else {
                                arrayContas.somaValorConta(rs.getInt("reduzidoPlanoConta"), rs.getBigDecimal("valorReceberPagarPlano"), rs.getBigDecimal("valorReceberPagarPlanoComSinal"));
                            }
                            try {
                                if (this.tipoRelatorio == 1) {
                                    somatorioAux = somatorioAux.add(rs.getBigDecimal("valorLancamentoPlano"));
                                    somatorioComSinalAux = somatorioComSinalAux.add(rs.getBigDecimal("valorLancamentoPlanoComSinal"));
                                } else {
                                    somatorioAux = somatorioAux.add(rs.getBigDecimal("valorReceberPagarPlano"));
                                    somatorioComSinalAux = somatorioComSinalAux.add(rs.getBigDecimal("valorReceberPagarPlanoComSinal"));
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (rs.getInt("paiPlanoConta") == 0) continue;
                            if (i == maiorNivel) {
                                if (this.tipoRelatorio == 1) {
                                    arrayContas.somaValorConta(rs.getInt("paiPlanoConta"), rs.getBigDecimal("valorLancamentoPlano"), rs.getBigDecimal("valorLancamentoPlanoComSinal"));
                                    continue;
                                }
                                arrayContas.somaValorConta(rs.getInt("paiPlanoConta"), rs.getBigDecimal("valorReceberPagarPlano"), rs.getBigDecimal("valorReceberPagarPlanoComSinal"));
                                continue;
                            }
                            arrayContas.somaValorConta(rs.getInt("paiPlanoConta"), rs.getInt("reduzidoPlanoConta"));
                        } while (rs.next());
                    }
                }
                rs.first();
                int posCampoReduzidoRelatorio = 0;
                for (i = 0; i < this.camposRelatorio.length; ++i) {
                    if (!this.camposRelatorio[i].equals("reduzidoPlanoConta")) continue;
                    posCampoReduzidoRelatorio = i;
                    break;
                }
                rs.beforeFirst();
                int reduzidoPlanoConta = -1;
                boolean imprimeLancto = false;
                if (rs.next()) {
                    int i5;
                    ModeloGridTable modelo = null;
                    modelo = this.tipoRelatorio == 1 ? new ModeloGridTable(ArraysUtil.concatenar(this.camposRelatorio, camposLancamento)) : new ModeloGridTable(ArraysUtil.concatenar(ArraysUtil.concatenar(this.camposRelatorio, camposRecPag), camposCadastros));
                    do {
                        int i6;
                        Object[] o = null;
                        o = this.tipoRelatorio == 1 ? new Object[this.camposRelatorio.length + camposLancamento.length] : new Object[this.camposRelatorio.length + camposRecPag.length + camposCadastros.length];
                        if (rs.getInt("nivelPlanoConta") == maiorNivel) {
                            imprimeLancto = reduzidoPlanoConta == -1 ? false : reduzidoPlanoConta == rs.getInt("reduzidoPlanoConta");
                            reduzidoPlanoConta = rs.getInt("reduzidoPlanoConta");
                            if (imprimeLancto) {
                                if (this.tipoRelatorio == 1) {
                                    for (i6 = 0; i6 < camposLancamento.length; ++i6) {
                                        if (camposLancamento[i6].equals("tipoPagamentoLancamento")) {
                                            o[modelo.findColumn((String)RelatorioRecPagLanctoPlano.camposLancamento[i6])] = Tipos.tipoPagamento(rs.getString(camposLancamento[i6]));
                                            continue;
                                        }
                                        if (camposLancamento[i6].equals("tipoLancamento")) {
                                            if (rs.getString(camposLancamento[i6]) != null) {
                                                o[modelo.findColumn((String)RelatorioRecPagLanctoPlano.camposLancamento[i6])] = Tipos.tipoLancamentoCaixa(rs.getString(camposLancamento[i6]));
                                                continue;
                                            }
                                            o[modelo.findColumn((String)RelatorioRecPagLanctoPlano.camposLancamento[i6])] = "";
                                            continue;
                                        }
                                        if (this.camposRelatorio[i6].equalsIgnoreCase("situacaoLancamento")) {
                                            if (rs.getString(this.camposRelatorio[i6]) != null) {
                                                o[modelo.findColumn((String)this.camposRelatorio[i6])] = Tipos.tipoSituacaoLancamento(rs.getString(this.camposRelatorio[i6]));
                                                continue;
                                            }
                                            o[modelo.findColumn((String)this.camposRelatorio[i6])] = null;
                                            continue;
                                        }
                                        o[modelo.findColumn((String)RelatorioRecPagLanctoPlano.camposLancamento[i6])] = rs.getObject(camposLancamento[i6]);
                                    }
                                } else {
                                    for (i6 = 0; i6 < camposRecPag.length; ++i6) {
                                        if (camposRecPag[i6].equals("tipoDocumentoReceberPagar")) {
                                            o[modelo.findColumn((String)RelatorioRecPagLanctoPlano.camposRecPag[i6])] = Tipos.tipoDocumento(rs.getString(camposRecPag[i6]));
                                        } else if (camposRecPag[i6].equals("tipoReceberPagar")) {
                                            o[modelo.findColumn((String)RelatorioRecPagLanctoPlano.camposRecPag[i6])] = rs.getString(camposRecPag[i6]) != null ? Tipos.tipoReceberPagar(rs.getString(camposRecPag[i6])) : "";
                                        } else if (!(camposRecPag[i6].equalsIgnoreCase("dataVencimentoLancamentoBaixa") || camposRecPag[i6].equalsIgnoreCase("dataCompetenciaLancamentoBaixa") || camposRecPag[i6].equalsIgnoreCase("dataConciliacaoLancamentoBaixa") || camposRecPag[i6].equalsIgnoreCase("codigoBaixa") || camposRecPag[i6].equalsIgnoreCase("situacaoLancamentoBaixa"))) {
                                            o[modelo.findColumn((String)RelatorioRecPagLanctoPlano.camposRecPag[i6])] = rs.getObject(camposRecPag[i6]);
                                        }
                                        if (rs.getString("tipoCadastro") == null) continue;
                                        this.pegaDadosCadastro(st2, o, modelo, rs.getString("tipoCadastro"), rs.getInt("codigoFilial"), rs.getInt("codigoCadastro"));
                                    }
                                }
                            } else {
                                for (i6 = 0; i6 < this.camposRelatorio.length; ++i6) {
                                    if (this.camposRelatorio[i6].equals("tipoPlanoConta")) {
                                        o[modelo.findColumn((String)this.camposRelatorio[i6])] = Tipos.tipoPlanoContas(rs.getString(this.camposRelatorio[i6]));
                                        continue;
                                    }
                                    if (this.camposRelatorio[i6].equals("totalPlanoConta")) {
                                        if (arrayContas == null) continue;
                                        o[modelo.findColumn((String)this.camposRelatorio[i6])] = arrayContas.getValorConta(rs.getInt(this.camposRelatorio[posCampoReduzidoRelatorio]));
                                        continue;
                                    }
                                    if (this.camposRelatorio[i6].equals("totalPlanoContaComSinal")) {
                                        if (arrayContas == null) continue;
                                        o[modelo.findColumn((String)this.camposRelatorio[i6])] = arrayContas.getValorContaComSinal(rs.getInt(this.camposRelatorio[posCampoReduzidoRelatorio]));
                                        continue;
                                    }
                                    if (this.camposRelatorio[i6].equals("valorSomatorio") || this.camposRelatorio[i6].equals("valorSomatorioComSinal")) continue;
                                    if (this.camposRelatorio[i6].equals("tipoLancamento")) {
                                        if (rs.getString(this.camposRelatorio[i6]) != null) {
                                            o[modelo.findColumn((String)this.camposRelatorio[i6])] = Tipos.tipoLancamentoCaixa(rs.getString(this.camposRelatorio[i6]));
                                            continue;
                                        }
                                        o[modelo.findColumn((String)this.camposRelatorio[i6])] = null;
                                        continue;
                                    }
                                    if (this.camposRelatorio[i6].equalsIgnoreCase("situacaoLancamento")) {
                                        if (rs.getString(this.camposRelatorio[i6]) != null) {
                                            o[modelo.findColumn((String)this.camposRelatorio[i6])] = Tipos.tipoSituacaoLancamento(rs.getString(this.camposRelatorio[i6]));
                                            continue;
                                        }
                                        o[modelo.findColumn((String)this.camposRelatorio[i6])] = null;
                                        continue;
                                    }
                                    o[modelo.findColumn((String)this.camposRelatorio[i6])] = rs.getObject(this.camposRelatorio[i6]);
                                }
                                if (this.tipoRelatorio == 1) {
                                    if (rs.getString("codigoLancamento") != null && !Funcoes.textoVazio(rs.getString("codigoLancamento"))) {
                                        rs.previous();
                                    } else if (rs.next()) {
                                        if (reduzidoPlanoConta == rs.getInt("reduzidoPlanoConta")) {
                                            rs.previous();
                                        }
                                        rs.previous();
                                    }
                                } else if (rs.getString("codigoReceberPagar") != null && !Funcoes.textoVazio(rs.getString("codigoReceberPagar"))) {
                                    rs.previous();
                                } else if (rs.next()) {
                                    if (reduzidoPlanoConta == rs.getInt("reduzidoPlanoConta")) {
                                        rs.previous();
                                    }
                                    rs.previous();
                                }
                            }
                        } else {
                            for (i6 = 0; i6 < this.camposRelatorio.length; ++i6) {
                                if (this.camposRelatorio[i6].equals("tipoPlanoConta")) {
                                    o[modelo.findColumn((String)this.camposRelatorio[i6])] = Tipos.tipoPlanoContas(rs.getString(this.camposRelatorio[i6]));
                                    continue;
                                }
                                if (this.camposRelatorio[i6].equals("totalPlanoConta")) {
                                    if (arrayContas == null) continue;
                                    o[modelo.findColumn((String)this.camposRelatorio[i6])] = arrayContas.getValorConta(rs.getInt(this.camposRelatorio[posCampoReduzidoRelatorio]));
                                    continue;
                                }
                                if (this.camposRelatorio[i6].equals("totalPlanoContaComSinal")) {
                                    if (arrayContas == null) continue;
                                    o[modelo.findColumn((String)this.camposRelatorio[i6])] = arrayContas.getValorContaComSinal(rs.getInt(this.camposRelatorio[posCampoReduzidoRelatorio]));
                                    continue;
                                }
                                if (this.camposRelatorio[i6].equals("valorSomatorio") || this.camposRelatorio[i6].equals("valorSomatorioComSinal") || this.camposRelatorio[i6].equalsIgnoreCase("dataVencimentoLancamentoBaixa") || this.camposRelatorio[i6].equalsIgnoreCase("dataCompetenciaLancamentoBaixa") || this.camposRelatorio[i6].equalsIgnoreCase("dataConciliacaoLancamentoBaixa") || this.camposRelatorio[i6].equalsIgnoreCase("codigoBaixa") || this.camposRelatorio[i6].equalsIgnoreCase("situacaoLancamentoBaixa")) continue;
                                if (this.camposRelatorio[i6].equalsIgnoreCase("tipoLancamento")) {
                                    if (rs.getString(this.camposRelatorio[i6]) != null) {
                                        o[modelo.findColumn((String)this.camposRelatorio[i6])] = Tipos.tipoLancamentoCaixa(rs.getString(this.camposRelatorio[i6]));
                                        continue;
                                    }
                                    o[modelo.findColumn((String)this.camposRelatorio[i6])] = null;
                                    continue;
                                }
                                if (this.camposRelatorio[i6].equalsIgnoreCase("tipoReceberPagar")) {
                                    if (rs.getString(this.camposRelatorio[i6]) != null) {
                                        o[modelo.findColumn((String)this.camposRelatorio[i6])] = Tipos.tipoReceberPagar(rs.getString(this.camposRelatorio[i6]));
                                        continue;
                                    }
                                    o[modelo.findColumn((String)this.camposRelatorio[i6])] = null;
                                    continue;
                                }
                                if (this.camposRelatorio[i6].equalsIgnoreCase("situacaoLancamento")) {
                                    if (rs.getString(this.camposRelatorio[i6]) != null) {
                                        o[modelo.findColumn((String)this.camposRelatorio[i6])] = Tipos.tipoSituacaoLancamento(rs.getString(this.camposRelatorio[i6]));
                                        continue;
                                    }
                                    o[modelo.findColumn((String)this.camposRelatorio[i6])] = null;
                                    continue;
                                }
                                if (this.camposRelatorio[i6].equalsIgnoreCase("situacaoReceberPagar")) {
                                    if (rs.getString(this.camposRelatorio[i6]) != null) {
                                        o[modelo.findColumn((String)this.camposRelatorio[i6])] = Tipos.tipoSituacaoReceberPagar(rs.getString(this.camposRelatorio[i6]));
                                        continue;
                                    }
                                    o[modelo.findColumn((String)this.camposRelatorio[i6])] = null;
                                    continue;
                                }
                                o[modelo.findColumn((String)this.camposRelatorio[i6])] = rs.getObject(this.camposRelatorio[i6]);
                            }
                            imprimeLancto = false;
                            reduzidoPlanoConta = -1;
                        }
                        modelo.addLine(o);
                    } while (rs.next());
                    if (this.tipoRelatorio == 1) {
                        BigDecimal somatorioValorLancamentosNaoApropriados = this.getSomaLanctoNaoApropriado();
                        BigDecimal saldoAnteriorContas = this.getSaldoAnteriorContas();
                        BigDecimal valorFinalPeriodoContas = saldoAnteriorContas.add(somatorioComSinalAux);
                        for (int i7 = 0; i7 < modelo.getRowCount(); ++i7) {
                            modelo.setValueAt(somatorioValorLancamentosNaoApropriados, i7, modelo.findColumn("somatorioValorLancamentosNaoApropriados"));
                            modelo.setValueAt(saldoAnteriorContas, i7, modelo.findColumn("saldoAnteriorContas"));
                            modelo.setValueAt(valorFinalPeriodoContas, i7, modelo.findColumn("valorFinalPeriodoContas"));
                        }
                    }
                    for (i5 = 0; i5 < modelo.getRowCount(); ++i5) {
                        modelo.setValueAt(somatorioAux, i5, modelo.findColumn("valorSomatorio"));
                    }
                    for (i5 = 0; i5 < modelo.getRowCount(); ++i5) {
                        modelo.setValueAt(somatorioComSinalAux, i5, modelo.findColumn("valorSomatorioComSinal"));
                    }
                    if (this.tipoRelatorio == 0) {
                        for (i5 = 0; i5 < modelo.getRowCount(); ++i5) {
                            buf.delete(0, buf.length());
                            buf.append(" select lcx.fil_codigo as fil_codigo, ");
                            buf.append("   \t\t  rpg.rpg_codigo as rpg_codigo, ");
                            buf.append("       \tlcx.lcx_vencimento as lcx_vencimento, ");
                            buf.append("       \tlcx.lcx_competencia as lcx_competencia, ");
                            buf.append("      \tlcx.lcx_conciliacao as lcx_conciliacao, ");
                            buf.append("      \tlcx.lcx_situacao as lcx_situacao, ");
                            buf.append("      \tbxa.bxa_codigo as bxa_codigo ");
                            buf.append(" \t from receberpagar rpg ");
                            buf.append(" \t join baixareceberpagar brp on rpg.fil_codigo = brp.fil_codigo and rpg.rpg_codigo = brp.rpg_codigo ");
                            buf.append(" \t join baixa bxa on brp.fil_codigo = bxa.fil_codigo and brp.bxa_codigo = bxa.bxa_codigo and bxa.bxa_situacao <> '").append("E").append("' ");
                            buf.append(" \t join baixalanctocaixa blc on bxa.fil_codigo = blc.fil_codigo and bxa.bxa_codigo = blc.bxa_codigo ");
                            buf.append(" \t join lanctocaixa lcx on blc.fil_codigo = lcx.fil_codigo and blc.lcx_codigo = lcx.lcx_codigo and blc.est_codigo = lcx.est_codigo ");
                            buf.append("  where rpg.fil_codigo = ").append(filiais == null ? Variaveis.filialPadrao : filiais[0]);
                            buf.append("    and rpg.rpg_codigo = ").append(modelo.getValueAt(i5, modelo.findColumn("codigoReceberPagar")));
                            buf.append("   order by lcx.lcx_vencimento ");
                            buf.append("\tlimit 1 ");
                            rs = st.executeQuery(buf.toString());
                            if (!rs.next()) continue;
                            modelo.setValueAt(rs.getDate("lcx_vencimento"), i5, modelo.findColumn("dataVencimentoLancamentoBaixa"));
                            modelo.setValueAt(rs.getDate("lcx_competencia"), i5, modelo.findColumn("dataCompetenciaLancamentoBaixa"));
                            modelo.setValueAt(rs.getDate("lcx_conciliacao"), i5, modelo.findColumn("dataConciliacaoLancamentoBaixa"));
                            modelo.setValueAt(rs.getInt("bxa_codigo"), i5, modelo.findColumn("codigoBaixa"));
                            modelo.setValueAt(rs.getString("lcx_situacao"), i5, modelo.findColumn("situacaoLancamentoBaixa"));
                        }
                    }
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    if (this.tipoRelatorio == 1) {
                        buf.append(RelatorioRecPagLanctoPlano.getModuloAcesso(1));
                    } else {
                        buf.append(RelatorioRecPagLanctoPlano.getModuloAcesso(0));
                    }
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(1.0f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioRecPagLanctoPlano.this.panelCentro.removeAll();
                                RelatorioRecPagLanctoPlano.this.panelCentro.repaint();
                                RelatorioRecPagLanctoPlano.this.habilitaBotaoImprimir(true);
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put(FILTRO_DATA_INICIAL, this.getFiltroData(FILTRO_DATA_INICIAL));
                        var.put(FILTRO_DATA_FINAL, this.getFiltroData(FILTRO_DATA_FINAL));
                        var.put(FILTRO_VALOR_INICIAL, this.getFiltroDecimal(FILTRO_VALOR_INICIAL));
                        var.put(FILTRO_VALOR_FINAL, this.getFiltroDecimal(FILTRO_VALOR_FINAL));
                        var.put(FILTRO_TIPO_PLANO, this.getFiltroCombo(FILTRO_TIPO_PLANO));
                        var.put(FILTRO_CAMPO_DATA, this.getFiltroCombo(FILTRO_CAMPO_DATA));
                        var.put(FILTRO_SITUACAO, this.getFiltroCombo(FILTRO_SITUACAO) == null ? "Todos" : this.getFiltroCombo(FILTRO_SITUACAO));
                        var.put(FILTRO_TIPO, this.getFiltroCombo(FILTRO_TIPO) == null ? "Todos" : this.getFiltroCombo(FILTRO_TIPO));
                        var.put(FILTRO_ORDEM, this.getFiltroCombo(FILTRO_ORDEM));
                        var.put(FILTRO_CONTA, this.getSelecionadosFiltroValores(FILTRO_CONTA, 0, false, false));
                        buf.delete(0, buf.length());
                        if (entidade != null) {
                            for (int i8 = 0; i8 < entidade.length; ++i8) {
                                buf.append(entidade[i8]);
                                if (i8 >= entidade.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put(FILTRO_ENTIDADE, buf.toString());
                        buf.delete(0, buf.length());
                        if (paciente != null) {
                            for (int i9 = 0; i9 < paciente.length; ++i9) {
                                buf.append(paciente[i9]);
                                if (i9 >= paciente.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put(FILTRO_PACIENTE, buf.toString());
                        buf.delete(0, buf.length());
                        if (convenio != null) {
                            for (int i10 = 0; i10 < convenio.length; ++i10) {
                                buf.append(convenio[i10]);
                                if (i10 >= convenio.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put(FILTRO_CONVENIO, buf.toString());
                        buf.delete(0, buf.length());
                        if (filiais != null) {
                            for (int i11 = 0; i11 < filiais.length; ++i11) {
                                buf.append(filiais[i11]);
                                if (i11 >= filiais.length - 1) continue;
                                buf.append(", ");
                            }
                        } else {
                            buf.append(Variaveis.filialPadrao);
                        }
                        var.put(FILTRO_FILIAL_PLANO_CONTA, buf.toString());
                        buf.delete(0, buf.length());
                        if (usuario != null) {
                            for (int i12 = 0; i12 < usuario.length; ++i12) {
                                buf.append(usuario[i12]);
                                if (i12 >= usuario.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put(FILTRO_USUARIO, buf.toString());
                        buf.delete(0, buf.length());
                        if (planoconta != null) {
                            for (int i13 = 0; i13 < planoconta.length; ++i13) {
                                buf.append(planoconta[i13]);
                                if (i13 >= planoconta.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put(FILTRO_PLANO_CONTA, buf.toString());
                        buf.delete(0, buf.length());
                        if (origem != null) {
                            for (int i14 = 0; i14 < origem.length; ++i14) {
                                buf.append(origem[i14]);
                                if (i14 >= origem.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put(FILTRO_ORIGEM, buf.toString());
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelCentro.revalidate();
                    }
                    break block167;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st, st2);
                    throw throwable;
                }
                Conexao.fecharStatement(st, st2);
            }
        }
        Conexao.fecharStatement(st, st2);
        this.setCursor(Cursor.getDefaultCursor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal getSaldoAnteriorContas() throws SQLException {
        BigDecimal soma;
        String[] contasArray;
        block13: {
            contasArray = this.getSelecionadosFiltro(FILTRO_CONTA, 0);
            soma = BigDecimal.ZERO;
            if (contasArray != null) break block13;
            StringBuilder sqlContas = new StringBuilder();
            sqlContas.append(" select cco_reduzido as codigoContaCorrente ");
            sqlContas.append("   from contacorrente ");
            sqlContas.append("  where fil_codigo = ").append(this.getFilial());
            Statement statementConta = Conexao.getStatement();
            ResultSet resultSetContas = Conexao.executeQuery(statementConta, sqlContas);
            ArrayList<String> contasList = new ArrayList<String>();
            try {
                while (resultSetContas.next()) {
                    contasList.add(resultSetContas.getString("codigoContaCorrente"));
                }
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(statementConta);
                throw throwable;
            }
            Conexao.fecharStatement(statementConta);
            contasArray = new String[contasList.toArray().length];
            Object[] contasFilial = contasList.toArray();
            for (int pos = 0; pos < contasFilial.length; ++pos) {
                contasArray[pos] = contasFilial[pos].toString();
            }
        }
        String dataInicialInformada = Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_INICIAL));
        if (contasArray != null) {
            for (String conta : contasArray) {
                Statement stSaldoConta;
                block11: {
                    StringBuilder sql = new StringBuilder();
                    sql.append(" select sld_saldo as saldo ");
                    sql.append("   from saldocontas ");
                    sql.append("  where sld_data < '").append(dataInicialInformada).append("' ");
                    sql.append("    and fil_codigo = ").append(this.getFilial());
                    sql.append("    and cco_reduzido = ").append(conta);
                    sql.append("  order by sld_data desc ");
                    sql.append("  limit 1 ");
                    stSaldoConta = Conexao.getStatement();
                    ResultSet rsSaldoConta = Conexao.executeQuery(stSaldoConta, sql.toString());
                    try {
                        Statement stSaldoInicial;
                        block12: {
                            if (rsSaldoConta.next()) {
                                soma = soma.add(rsSaldoConta.getBigDecimal("saldo"));
                                break block11;
                            }
                            StringBuilder bufSaldoIni = new StringBuilder();
                            bufSaldoIni.append(" select cco_dtsldinicial as dataInicial ");
                            bufSaldoIni.append("       ,cco_sldinicial as saldoInicial ");
                            bufSaldoIni.append("   from contacorrente ");
                            bufSaldoIni.append("  where fil_codigo = ").append(this.getFilial());
                            bufSaldoIni.append("    and cco_reduzido = ").append(conta);
                            stSaldoInicial = Conexao.getStatement();
                            ResultSet rsSaldoInicial = Conexao.executeQuery(stSaldoInicial, bufSaldoIni.toString());
                            try {
                                if (!rsSaldoInicial.next() || new Date(rsSaldoInicial.getDate("dataInicial").getTime()).compareTo(Funcoes.getData("yyyy-MM-dd", dataInicialInformada)) >= 0) break block12;
                                soma = soma.add(rsSaldoInicial.getBigDecimal("saldoInicial"));
                            }
                            catch (Throwable throwable) {
                                Conexao.fecharStatement(stSaldoInicial);
                                throw throwable;
                            }
                        }
                        Conexao.fecharStatement(stSaldoInicial);
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(stSaldoConta);
                        throw throwable;
                    }
                }
                Conexao.fecharStatement(stSaldoConta);
            }
        }
        return soma;
    }

    private BigDecimal getSomaLanctoNaoApropriado() throws SQLException {
        StringBuilder where = new StringBuilder();
        StringBuilder query = new StringBuilder();
        StringBuilder situacao = new StringBuilder();
        String[] usuario = this.getSelecionadosFiltro(FILTRO_USUARIO, 0);
        String comboSituacao = this.getFiltroCombo(FILTRO_SITUACAO).toString();
        String comboTipo = this.getFiltroCombo(FILTRO_TIPO).toString();
        String[] contas = this.getSelecionadosFiltro(FILTRO_CONTA, 0);
        if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_INICIAL))) {
            where.append(" and cast(lcx." + CAMPOSDATABANCOLANCTO[this.getFiltroComboIndice(FILTRO_CAMPO_DATA)] + " as date) >= '");
            where.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_INICIAL)));
            where.append("'");
        }
        if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_FINAL))) {
            where.append(" and cast(lcx." + CAMPOSDATABANCOLANCTO[this.getFiltroComboIndice(FILTRO_CAMPO_DATA)] + " as date) <= '");
            where.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_FINAL)));
            where.append("'");
        }
        if (usuario != null) {
            where.append(" and (lcx.usr_codigo in (");
            where.append(this.getSelecionadosFiltroValores(FILTRO_USUARIO, 0, false, true));
            where.append(") OR lcx.usr_codigo IS NULL)");
        }
        if (comboSituacao.equals(situacaoLancto[0])) {
            situacao.append(" and lcx.lcx_situacao IN('");
            situacao.append("A");
            situacao.append("', '").append("O");
            situacao.append("') ");
        } else {
            situacao.append(" and lcx.lcx_situacao = '");
            if (comboSituacao.equals(situacaoLancto[1])) {
                situacao.append("A");
            } else {
                situacao.append("O");
            }
            situacao.append("' ");
        }
        if (comboTipo.equals(tipoLancto[0])) {
            where.append(" and lcx.lcx_tipo IN('");
            where.append("C").append("', '").append("D");
            where.append("') ");
        } else {
            where.append(" and lcx.lcx_tipo = '");
            if (comboTipo.equals(tipoLancto[1])) {
                where.append("C");
            } else {
                where.append("D");
            }
            where.append("' ");
        }
        if (!Funcoes.textoVazio(this.getFiltroDecimal(FILTRO_VALOR_INICIAL))) {
            where.append(" and lcx.lcx_valortotal >= ");
            where.append(this.getFiltroTexto(FILTRO_VALOR_INICIAL));
            where.append(" ");
        }
        if (!Funcoes.textoVazio(this.getFiltroDecimal(FILTRO_VALOR_FINAL))) {
            where.append(" and lcx.lcx_valortotal <= ");
            where.append(this.getFiltroTexto(FILTRO_VALOR_FINAL));
            where.append(" ");
        }
        if (contas != null) {
            where.append(" and cco.cco_reduzido in (");
            where.append(this.getSelecionadosFiltroValores(FILTRO_CONTA, 0, false, false));
            where.append(") ");
        }
        query.append(" SELECT  COALESCE(SUM(case when lcx.lcx_tipo = 'D' then ((-1) * lcx.lcx_valortotal) else lcx.lcx_valortotal end), 0.0000) as soma ");
        query.append(" FROM lanctocaixa lcx join contacorrente cco on lcx.fil_codigo = cco.fil_codigo and lcx.cco_reduzido = cco.cco_reduzido ");
        query.append(" WHERE lcx.fil_codigo in (").append(this.getFilial()).append(") ");
        query.append(situacao.toString());
        query.append((CharSequence)where);
        query.append(" AND (lcx.fil_codigo, lcx.lcx_codigo, lcx.est_codigo) not in (select fil_codigo, lcx_codigo, est_codigo from lanctocaixaplanoconta where fil_codigo = lcx.fil_codigo ); ");
        ResultSet rs = Conexao.executeQuery(this.getStatement(), query.toString());
        if (rs.next()) {
            return rs.getBigDecimal("soma");
        }
        return BigDecimal.ZERO;
    }

    private String getFilial() {
        return this.getSelecionadosFiltro(FILTRO_FILIAL_PLANO_CONTA, 0) != null ? this.getSelecionadosFiltroValores(FILTRO_FILIAL_PLANO_CONTA, 0, false, false) : Variaveis.filialPadrao;
    }

    public static long getModuloAcesso(int tipoRelatorio) {
        if (tipoRelatorio == 1) {
            return Long.parseLong("0850802100");
        }
        if (tipoRelatorio == 0) {
            return Long.parseLong("0850801100");
        }
        return Long.parseLong("0850802100");
    }

    public long getConfigurarAcesso(int tipoRelatorio) {
        if (tipoRelatorio == 1) {
            return Long.parseLong("0850802101");
        }
        if (tipoRelatorio == 0) {
            return Long.parseLong("0850801101");
        }
        return Long.parseLong("0850802101");
    }

    private ArrayList<Integer> getPlanosAcima(ArrayList<Integer> planos) {
        Statement st = Conexao.getStatement();
        ArrayList<Integer> resultado = new ArrayList<Integer>();
        StringBuilder planosSql = null;
        StringBuilder buf = null;
        while (planos != null) {
            planosSql = new StringBuilder();
            for (int i = 0; i < planos.size() && planos != null; ++i) {
                planosSql.append(planos.get(i));
                if (i >= planos.size() - 1) continue;
                planosSql.append(", ");
            }
            buf = new StringBuilder();
            buf.append(" select plc_pai ");
            buf.append("   from planoconta ");
            buf.append("  where plc_reduzido IN (").append((CharSequence)planosSql).append(") ");
            buf.append("    and fil_codigo = ").append(Variaveis.filialPadrao);
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (planos != null) {
                    planos.clear();
                }
                if (rs.next()) {
                    do {
                        if (rs.getString("plc_pai") == null || resultado.contains(rs.getInt("plc_pai"))) continue;
                        resultado.add(rs.getInt("plc_pai"));
                        if (planos == null) continue;
                        planos.add(rs.getInt("plc_pai"));
                    } while (rs.next());
                } else {
                    planos = null;
                }
            }
            catch (SQLException e) {
                break;
            }
            if (planos == null || planos.size() != 0) continue;
            planos = null;
        }
        Conexao.fecharStatement(st);
        if (resultado.size() == 0) {
            return null;
        }
        return resultado;
    }

    private ArrayList<Integer> getPlanosAbaixo(ArrayList<Integer> planos) {
        Statement st = Conexao.getStatement();
        ArrayList<Integer> resultado = new ArrayList<Integer>();
        StringBuilder planosSql = null;
        StringBuilder buf = null;
        while (planos != null) {
            planosSql = new StringBuilder();
            for (int i = 0; i < planos.size() && planos != null; ++i) {
                planosSql.append(planos.get(i));
                if (i >= planos.size() - 1) continue;
                planosSql.append(", ");
            }
            buf = new StringBuilder();
            buf.append(" select plc_reduzido ");
            buf.append("   from planoconta ");
            buf.append("  where plc_pai IN (").append((CharSequence)planosSql).append(") ");
            buf.append("    and fil_codigo = ").append(Variaveis.filialPadrao);
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (planos != null) {
                    planos.clear();
                }
                if (rs.next()) {
                    do {
                        if (rs.getString("plc_reduzido") == null || resultado.contains(rs.getInt("plc_reduzido"))) continue;
                        resultado.add(rs.getInt("plc_reduzido"));
                        if (planos == null) continue;
                        planos.add(rs.getInt("plc_reduzido"));
                    } while (rs.next());
                } else {
                    planos = null;
                }
            }
            catch (SQLException e) {
                break;
            }
            if (planos == null || planos.size() != 0) continue;
            planos = null;
        }
        Conexao.fecharStatement(st);
        if (resultado.size() == 0) {
            return null;
        }
        return resultado;
    }

    private void pegaDadosCadastro(Statement st, Object[] array, ModeloGridTable modelo, String tipo, int filial, int codigo) throws SQLException {
        StringBuilder buf = new StringBuilder();
        if (tipo.equalsIgnoreCase("P")) {
            buf.append("select ");
            buf.append("pac.pac_codigo as codigoCadastro, pac.pac_nome as fantasiaCadastro,pac.pac_nomesocial as nomeSocialPaciente, pac.pac_nome as razaoSocialCadastro, pac.pac_fone as foneCadastro, ");
            buf.append("pac.pac_endereco as enderecoCadastro, pac.pac_numeroendereco as numeroEnderecoCadastro, pac.pac_tipologradouroendereco as tipoLogradouroCadastro, ");
            buf.append("pac.pac_fax as faxCadastro, pac.pac_complemento as complementoCadastro, pac.pac_cep as cepCadastro, ");
            buf.append("pac.cid_codigo as codigoCidadeCadastro, cidpac.cid_nome as nomeCidadeCadastro ");
            buf.append("from paciente pac ");
            buf.append("left join cidades cidpac on pac.fil_codigo = cidpac.fil_codigo and pac.cid_codigo = cidpac.cid_codigo ");
            buf.append("where pac.fil_codigo = ").append(filial);
            buf.append(" and pac.pac_codigo = ").append(codigo);
        } else if (tipo.equalsIgnoreCase("O")) {
            buf.append("select ");
            buf.append("con.con_codigo as codigoCadastro, con.con_fantasia as fantasiaCadastro,'' as nomeSocialPaciente, con.con_razao as razaoSocialCadastro, con.con_fone as foneCadastro, ");
            buf.append("con.con_endereco as enderecoCadastro, con.con_numeroendereco as numeroEnderecoCadastro, con.con_tipologradouroendereco as tipoLogradouroCadastro, ");
            buf.append("con.con_fax as faxCadastro, con.con_complemento as complementoCadastro, con.con_cep as cepCadastro, ");
            buf.append("con.cid_codigo as codigoCidadeCadastro, cidcon.cid_nome as nomeCidadeCadastro ");
            buf.append("from convenios con ");
            buf.append("left join cidades cidcon on con.fil_codigo = cidcon.fil_codigo and con.cid_codigo = cidcon.cid_codigo ");
            buf.append("where con.fil_codigo = ").append(filial);
            buf.append(" and con.con_codigo = ").append(codigo);
        } else {
            buf.append("select ");
            buf.append("ent.ent_codigo as codigoCadastro, ent.ent_fantasia as fantasiaCadastro,'' as nomeSocialPaciente, ent.ent_razaosocial as razaoSocialCadastro, ent.ent_fone as foneCadastro, ");
            buf.append("ent.ent_endereco as enderecoCadastro, ent.ent_numeroendereco as numeroEnderecoCadastro, ent.ent_tipologradouroendereco as tipoLogradouroCadastro, ");
            buf.append("ent.ent_fax as faxCadastro, ent.ent_complemento as complementoCadastro, ent.ent_cep as cepCadastro, ");
            buf.append("ent.cid_codigo as codigoCidadeCadastro, cident.cid_nome as nomeCidadeCadastro ");
            buf.append("from entidade ent ");
            buf.append("left join cidades cident on ent.fil_codigo = cident.fil_codigo and ent.cid_codigo = cident.cid_codigo ");
            buf.append("where ent.fil_codigo = ").append(filial);
            buf.append(" and ent.ent_codigo = ").append(codigo);
        }
        ResultSet rs = Conexao.executeQuery(st, buf);
        if (rs.next()) {
            int pos = -1;
            for (String s : camposCadastros) {
                if (rs.findColumn(s) <= 0 || modelo.findColumn(s) <= -1) continue;
                pos = modelo.findColumn(s);
                array[pos] = modelo.getColumnName(pos).equalsIgnoreCase("tipoLogradouroCadastro") ? Tipos.tipoLogradouroDescricao(rs.getString(s)) : rs.getObject(s);
            }
        }
    }

    public class arrayValoresPlanoConta {
        private Integer[] reduzidoPlanoConta = null;
        private BigDecimal[] valorPlanoConta = null;
        private BigDecimal[] valorPlanoContaComSinal = null;

        public arrayValoresPlanoConta(Integer tamanho) {
            this.reduzidoPlanoConta = new Integer[tamanho.intValue()];
            this.valorPlanoConta = new BigDecimal[tamanho.intValue()];
            this.valorPlanoContaComSinal = new BigDecimal[tamanho.intValue()];
        }

        public void setContaValorPosicao(int posicao, int reduzidoPlanoConta, BigDecimal valorPlanoConta, BigDecimal valorPlanoContaComSinal) {
            this.reduzidoPlanoConta[posicao] = reduzidoPlanoConta;
            this.valorPlanoConta[posicao] = valorPlanoConta;
            this.valorPlanoContaComSinal[posicao] = valorPlanoContaComSinal;
        }

        public void setValorConta(int reduzidoPlanoConta, BigDecimal valorPlanoConta, BigDecimal valorPlanoContaComSinal) {
            int i;
            for (i = 0; i < this.reduzidoPlanoConta.length; ++i) {
                if (this.reduzidoPlanoConta[i] == null || !this.reduzidoPlanoConta[i].equals(reduzidoPlanoConta)) continue;
                this.valorPlanoConta[i] = valorPlanoConta;
                this.valorPlanoContaComSinal[i] = valorPlanoContaComSinal;
                return;
            }
            for (i = 0; i < this.reduzidoPlanoConta.length; ++i) {
                if (this.reduzidoPlanoConta[i] != null) continue;
                this.setContaValorPosicao(i, reduzidoPlanoConta, valorPlanoConta, valorPlanoContaComSinal);
                return;
            }
        }

        public BigDecimal getValorConta(int reduzidoPlanoConta) {
            for (int i = 0; i < this.reduzidoPlanoConta.length; ++i) {
                if (this.reduzidoPlanoConta[i] == null || this.reduzidoPlanoConta[i] != reduzidoPlanoConta) continue;
                return this.valorPlanoConta[i];
            }
            return BigDecimal.ZERO;
        }

        public BigDecimal getValorContaComSinal(int reduzidoPlanoConta) {
            for (int i = 0; i < this.reduzidoPlanoConta.length; ++i) {
                if (this.reduzidoPlanoConta[i] == null || this.reduzidoPlanoConta[i] != reduzidoPlanoConta) continue;
                return this.valorPlanoContaComSinal[i];
            }
            return BigDecimal.ZERO;
        }

        public void somaValorConta(int reduzidoPlanoConta, int reduzidoFilho) {
            this.setValorConta(reduzidoPlanoConta, this.getValorConta(reduzidoPlanoConta).add(this.getValorConta(reduzidoFilho)), this.getValorContaComSinal(reduzidoPlanoConta).add(this.getValorContaComSinal(reduzidoFilho)));
        }

        public void somaValorConta(int reduzidoPlanoConta, BigDecimal valorAdicionar, BigDecimal valorAdicionarComSinal) {
            if (valorAdicionar == null) {
                valorAdicionar = BigDecimal.ZERO;
            }
            if (valorAdicionarComSinal == null) {
                valorAdicionarComSinal = BigDecimal.ZERO;
            }
            this.setValorConta(reduzidoPlanoConta, this.getValorConta(reduzidoPlanoConta).add(valorAdicionar), this.getValorContaComSinal(reduzidoPlanoConta).add(valorAdicionarComSinal));
        }

        public Integer getContaPosicao(int posicao) {
            return this.reduzidoPlanoConta[posicao];
        }

        public BigDecimal getValorPosicao(int posicao) {
            return this.valorPlanoConta[posicao];
        }

        public BigDecimal getValorComSinalPosicao(int posicao) {
            return this.valorPlanoContaComSinal[posicao];
        }
    }
}

