/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.movimento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioRecPagLanctoCentro
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private static final String FILTRO_CENTRO_CUSTO = "filtroCentroCusto";
    private static final String FILTRO_FILIAL_CENTRO_CUSTO = "filtroFilialCentroCusto";
    private static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private static final String FILTRO_VALOR_INICIAL = "filtroValorInicial";
    private static final String FILTRO_VALOR_FINAL = "filtroValorFinal";
    private static final String FILTRO_USUARIO = "filtroUsuario";
    private static final String FILTRO_ORIGEM = "filtroOrigem";
    private static final String FILTRO_CAMPO_DATA = "filtroData";
    private static final String FILTRO_ORDEM = "filtroOrdem";
    private static final String FILTRO_SITUACAO = "filtroSituacao";
    private static final String FILTRO_TIPO = "filtroTipo";
    private static final String FILTRO_CONVENIO = "filtroConvenio";
    private static final String FILTRO_ENTIDADE = "filtroEntidade";
    private static final String FILTRO_PACIENTE = "filtroPaciente";
    private static final String[] ordem = new String[]{"C\u00f3digo", "N\u00fam. Doc.", "Dt. Cadastro", "Dt. Vencimento", "Valor Plano"};
    private static final String[] camposOrdemRecPag = new String[]{"rpg.rpg_codigo", "rpg.rpg_numerodocumento", "rpg.rpg_datahora", "rpg.rpg_vencimento", "valorReceberPagarCentroComSinal"};
    private static final String[] camposOrdemLancto = new String[]{"lcx.lcx_codigo", "lcx.lcx_documento", "lcx.lcx_datahora", "lcx.lcx_vencimento", "valorLancamentoCentroComSinal"};
    private static final String[] CAMPOSDATALANCTO = new String[]{"Vencimento", "Compet\u00eancia", "Cadastro", "Concilia\u00e7\u00e3o"};
    private final String[] CAMPOSDATABANCOLANCTO = new String[]{"lcx_vencimento", "lcx_competencia", "lcx_datahora", "lcx_conciliacao"};
    private static final String[] CAMPOSDATARECPAG = new String[]{"Vencimento", "Documento", "Cadastro", "Processamento", "Compet\u00eancia"};
    private static final String[] CAMPOSDATABANCORECPAG = new String[]{"rpg_vencimento", "rpg_datadocumento", "rpg_datahora", "rpg_dataprocessamento", "rpg_competencia"};
    private static final String[] situacaoRecPag = new String[]{"Todos", Tipos.tipoSituacaoReceberPagar("A"), Tipos.tipoSituacaoReceberPagar("Q"), Tipos.tipoSituacaoReceberPagar("V"), Tipos.tipoSituacaoReceberPagar("T"), Tipos.tipoSituacaoReceberPagar("S")};
    private static final String[] situacaoLancto = new String[]{"Todos", Tipos.tipoSituacaoLancamento("A"), Tipos.tipoSituacaoLancamento("O")};
    private static final String[] tipoRecPag = new String[]{"Todos", Tipos.tipoReceberPagar("R"), Tipos.tipoReceberPagar("P")};
    private static final String[] tipoLancto = new String[]{"Todos", Tipos.tipoLancamentoCaixa("C"), Tipos.tipoLancamentoCaixa("D")};
    public static final int TIPO_RECEBERPAGAR = 0;
    public static final int TIPO_LANCAMENTO = 1;
    private int tipoRelatorio = 0;
    private final String[] camposRelatorio = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"reduzidoCentroCusto", "descricaoCentroCusto", "contaCentroCusto", "filialCentroCusto", "nivelCentroCusto", "paiCentroCusto", "totalCentroCusto", "valorSomatorio", "totalCentroCustoComSinal", "valorSomatorioComSinal", "operacaoCentroCusto"});
    private static final String[] camposLancamento = new String[]{"codigoLancamento", "tipoPagamentoLancamento", "contaLancamento", "documentoLancamento", "valorLancamento", "valorTotalLancamento", "vencimentoLancamento", "tipoLancamento", "valorLancamentoCentro", "codigoOrigemLancamentoCentro", "competenciaLancamento", "conciliacaoLancamento", "emissaoLancamento", "valorLancamentoCentroComSinal", "situacaoLancamento"};
    private static final String[] camposRecPag = new String[]{"codigoReceberPagar", "vencimentoReceberPagar", "tipoReceberPagar", "tipoDocumentoReceberPagar", "numeroDocumentoReceberPagar", "parcelaReceberPagar", "dataDocumentoReceberPagar", "dataProcessamentoReceberPagar", "codigoSerieReceberPagar", "situacaoReceberPagar", "valorReceberPagar", "valorTotalReceberPagar", "valorReceberPagarCentroComSinal", "valorReceberPagarCentro", "dataHoraReceberPagar", "codigoOrigemReceberPagar", "competenciaReceberPagar", "dataVencimentoLancamentoBaixa", "dataCompetenciaLancamentoBaixa", "dataConciliacaoLancamentoBaixa", "codigoBaixa", "situacaoLancamentoBaixa"};
    private static final String[] camposCadastros = new String[]{"codigoCadastro", "fantasiaCadastro", "nomeSocialPaciente", "razaoSocialCadastro", "foneCadastro", "enderecoCadastro", "numeroEnderecoCadastro", "tipoLogradouroCadastro", "faxCadastro", "complementoCadastro", "cepCadastro", "codigoCidadeCadastro", "nomeCidadeCadastro"};

    public RelatorioRecPagLanctoCentro(int tipoRelatorio) {
        this.tipoRelatorio = tipoRelatorio;
        if (this.tipoRelatorio == 0) {
            this.montaBarraDescricao("Relat\u00f3rio de Receber/Pagar por Centro de Custo", "Movimenta\u00e7\u00e3o de T\u00edtulos nos centros de custo", "relatorios/rel_receber_pagar_centro-de-custo.jpg");
        } else if (this.tipoRelatorio == 1) {
            this.montaBarraDescricao("Relat\u00f3rio de Lan\u00e7amentos por Centro de Custo", "Movimenta\u00e7\u00e3o nos centros de custo", "relatorios/rel_lancamentos_centro-de-custo.jpg");
        } else {
            Funcoes.mensagem(this, "Tipo de relat\u00f3rio incorreto.", 1);
            return;
        }
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro(FILTRO_FILIAL_CENTRO_CUSTO, "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_USUARIO, "Usu\u00e1rio", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_CENTRO_CUSTO, "Centro Custo", "centrocusto", "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"ccu_reduzido", "ccu_conta", "ccu_descricao"}, new String[]{"C\u00f3digo", "Conta", "Descri\u00e7\u00e3o"}, new int[]{70, 120, 0});
        this.adicionaItemFiltro(FILTRO_ORIGEM, "Origem", "origemplanocusto", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"opc_codigo", "opc_descricao", "opc_padrao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Padr\u00e3o"}, new int[]{70, 0, 50});
        if (tipoRelatorio == 1) {
            this.adicionaFiltroCombo(FILTRO_CAMPO_DATA, "Campo Data:", CAMPOSDATALANCTO, 0);
        } else {
            this.adicionaItemFiltro(FILTRO_CONVENIO, "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Nome Fantasia"}, new int[]{70, 0});
            this.adicionaItemFiltro(FILTRO_ENTIDADE, "Entidade", "entidade", "fil_codigo = " + Variaveis.filialPadrao + " and ent_inativo = false", 1, new String[]{"ent_codigo", "ent_razaosocial"}, new String[]{"C\u00f3digo", "Raz\u00e3o Social"}, new int[]{70, 0});
            if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A") || Variaveis.tipoFilialPadrao.equalsIgnoreCase("V")) {
                this.adicionaItemFiltroAvancado(FILTRO_PACIENTE, "Paciente", "paciente", "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"pac_codigo", "pac_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0}, false, new int[]{70, 0});
            } else {
                this.adicionaItemFiltroAvancado(FILTRO_PACIENTE, "Paciente", "paciente", "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"pac_codigo", "pac_nome", "pac_nomesocial"}, new String[]{"C\u00f3digo", "Nome", "Nome Social"}, new int[]{70, 0, 0}, false, new int[]{70, 0, 0});
            }
            this.adicionaFiltroCombo(FILTRO_CAMPO_DATA, "Campo Data:", CAMPOSDATARECPAG, 0);
        }
        this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Data inicial:");
        this.adicionaFiltroData(FILTRO_DATA_FINAL, "Data final:");
        this.adicionaFiltroDecimal(FILTRO_VALOR_INICIAL, "Valor Inicial:", 0);
        this.adicionaFiltroDecimal(FILTRO_VALOR_FINAL, "Valor Final:", 0);
        if (tipoRelatorio == 0) {
            this.adicionaFiltroCombo(FILTRO_SITUACAO, "Situa\u00e7\u00e3o:", situacaoRecPag, 0);
        } else {
            this.adicionaFiltroCombo(FILTRO_SITUACAO, "Situa\u00e7\u00e3o:", situacaoLancto, 0);
        }
        if (tipoRelatorio == 0) {
            this.adicionaRetornaFiltroCombo(FILTRO_TIPO, "Tipo:", tipoRecPag, 0);
        } else {
            this.adicionaRetornaFiltroCombo(FILTRO_TIPO, "Tipo:", tipoLancto, 0);
        }
        this.adicionaFiltroCombo(FILTRO_ORDEM, "Ordem:", ordem, 0);
        this.setModuloConfigurar(this.getConfigurarAcesso(this.tipoRelatorio));
        this.setModuloAcesso(RelatorioRecPagLanctoCentro.getModuloAcesso(this.tipoRelatorio));
        if (tipoRelatorio == 1) {
            this.setCamposConfigurador(ArraysUtil.concatenar(this.camposRelatorio, camposLancamento));
        } else {
            this.setCamposConfigurador(ArraysUtil.concatenar(ArraysUtil.concatenar(this.camposRelatorio, camposRecPag), camposCadastros));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement st;
        block152: {
            String[] paciente;
            String[] entidade;
            String combo;
            String[] usuario;
            st = Conexao.getStatement();
            Statement st2 = Conexao.getStatement();
            String[] filiais = this.getSelecionadosFiltro(FILTRO_FILIAL_CENTRO_CUSTO, 0);
            if (filiais != null && filiais.length > 1) {
                Funcoes.mensagem(this, "Apenas uma filial deve ser selecionada para o relat\u00f3rio", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            StringBuilder whereRpg = new StringBuilder();
            StringBuilder whereRcc = new StringBuilder();
            StringBuilder whereOrigem = new StringBuilder();
            if (this.tipoRelatorio == 1) {
                if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_INICIAL))) {
                    whereRpg.append(" and cast(lcx." + this.CAMPOSDATABANCOLANCTO[this.getFiltroComboIndice(FILTRO_CAMPO_DATA)] + " as date) >= '");
                    whereRpg.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_INICIAL)));
                    whereRpg.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_FINAL))) {
                    whereRpg.append(" and cast(lcx." + this.CAMPOSDATABANCOLANCTO[this.getFiltroComboIndice(FILTRO_CAMPO_DATA)] + " as date) <= '");
                    whereRpg.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_FINAL)));
                    whereRpg.append("'");
                }
            } else {
                if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_INICIAL))) {
                    whereRpg.append(" and cast(lcx." + CAMPOSDATABANCORECPAG[this.getFiltroComboIndice(FILTRO_CAMPO_DATA)] + " as date) >= '");
                    whereRpg.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_INICIAL)));
                    whereRpg.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_FINAL))) {
                    whereRpg.append(" and cast(lcx." + CAMPOSDATABANCORECPAG[this.getFiltroComboIndice(FILTRO_CAMPO_DATA)] + " as date) <= '");
                    whereRpg.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_FINAL)));
                    whereRpg.append("'");
                }
            }
            if (!Funcoes.textoVazio(this.getFiltroDecimal(FILTRO_VALOR_INICIAL))) {
                whereRcc.append(" and lcx.lcx_valortotal >= ");
                whereRcc.append(this.getFiltroTexto(FILTRO_VALOR_INICIAL));
                whereRcc.append(" ");
            }
            if (!Funcoes.textoVazio(this.getFiltroDecimal(FILTRO_VALOR_FINAL))) {
                whereRcc.append(" and lcx.lcx_valortotal <= ");
                whereRcc.append(this.getFiltroTexto(FILTRO_VALOR_FINAL));
                whereRcc.append(" ");
            }
            if ((usuario = this.getSelecionadosFiltro(FILTRO_USUARIO, 0)) != null) {
                whereRpg.append(" and (lcx.usr_codigo in (");
                for (int i = 0; i < usuario.length; ++i) {
                    whereRpg.append("'");
                    whereRpg.append(usuario[i]);
                    whereRpg.append("'");
                    if (i >= usuario.length - 1) continue;
                    whereRpg.append(", ");
                }
                whereRpg.append(") OR lcx.usr_codigo IS NULL)");
            }
            if (this.tipoRelatorio == 0) {
                combo = this.getFiltroCombo(FILTRO_SITUACAO).toString();
                if (combo.equals(situacaoRecPag[0])) {
                    whereRpg.append(" and rpg.rpg_situacao IN('");
                    whereRpg.append("A").append("', '").append("Q").append("', '");
                    whereRpg.append("V").append("', '").append("T").append("', '");
                    whereRpg.append("S").append("') ");
                } else {
                    whereRpg.append(" and rpg.rpg_situacao = '");
                    if (combo.equals(situacaoRecPag[1])) {
                        whereRpg.append("A");
                    } else if (combo.equals(situacaoRecPag[2])) {
                        whereRpg.append("Q");
                    } else if (combo.equals(situacaoRecPag[3])) {
                        whereRpg.append("V");
                    } else if (combo.equals(situacaoRecPag[4])) {
                        whereRpg.append("T");
                    } else if (combo.equals(situacaoRecPag[5])) {
                        whereRpg.append("S");
                    }
                    whereRpg.append("' ");
                }
            } else {
                combo = this.getFiltroCombo(FILTRO_SITUACAO).toString();
                if (combo.equals(situacaoLancto[0])) {
                    whereRpg.append(" and lcx.lcx_situacao IN('");
                    whereRpg.append("A").append("', '").append("O");
                    whereRpg.append("') ");
                } else {
                    whereRpg.append(" and lcx.lcx_situacao = '");
                    if (combo.equals(situacaoLancto[1])) {
                        whereRpg.append("A");
                    } else {
                        whereRpg.append("O");
                    }
                    whereRpg.append("' ");
                }
            }
            if (this.tipoRelatorio == 0) {
                combo = this.getFiltroCombo(FILTRO_TIPO).toString();
                if (combo.equals(tipoRecPag[0])) {
                    whereRpg.append(" and rpg.rpg_tipo IN('");
                    whereRpg.append("R").append("', '").append("P");
                    whereRpg.append("') ");
                } else {
                    whereRpg.append(" and rpg.rpg_tipo = '");
                    if (combo.equals(tipoRecPag[1])) {
                        whereRpg.append("R");
                    } else {
                        whereRpg.append("P");
                    }
                    whereRpg.append("' ");
                }
            } else {
                combo = this.getFiltroCombo(FILTRO_TIPO).toString();
                if (combo.equals(tipoLancto[0])) {
                    whereRpg.append(" and lcx.lcx_tipo IN('");
                    whereRpg.append("C").append("', '").append("D");
                    whereRpg.append("') ");
                } else {
                    whereRpg.append(" and lcx.lcx_tipo = '");
                    if (combo.equals(tipoLancto[1])) {
                        whereRpg.append("C");
                    } else {
                        whereRpg.append("D");
                    }
                    whereRpg.append("' ");
                }
            }
            String[] origem = this.getSelecionadosFiltro(FILTRO_ORIGEM, 0);
            if (origem != null) {
                whereOrigem.append(" and lcc.opc_codigo in (");
                for (int i = 0; i < origem.length; ++i) {
                    whereOrigem.append("'");
                    whereOrigem.append(origem[i]);
                    whereOrigem.append("'");
                    if (i >= origem.length - 1) continue;
                    whereOrigem.append(", ");
                }
                whereOrigem.append(")");
            }
            StringBuilder bufCadastros = new StringBuilder();
            String[] convenio = this.getSelecionadosFiltro(FILTRO_CONVENIO, 0);
            if (convenio != null) {
                bufCadastros.append(" rpg.con_codigo in (");
                for (int j = 0; j < convenio.length; ++j) {
                    bufCadastros.append("'");
                    bufCadastros.append(convenio[j]);
                    bufCadastros.append("'");
                    if (j >= convenio.length - 1) continue;
                    bufCadastros.append(", ");
                }
                bufCadastros.append(")");
            }
            if ((entidade = this.getSelecionadosFiltro(FILTRO_ENTIDADE, 0)) != null) {
                if (bufCadastros.length() > 0) {
                    bufCadastros.append(" or ");
                }
                bufCadastros.append(" rpg.ent_codigo in (");
                for (int j = 0; j < entidade.length; ++j) {
                    bufCadastros.append("'");
                    bufCadastros.append(entidade[j]);
                    bufCadastros.append("'");
                    if (j >= entidade.length - 1) continue;
                    bufCadastros.append(", ");
                }
                bufCadastros.append(")");
            }
            if ((paciente = this.getSelecionadosFiltroAvancado(FILTRO_PACIENTE, 0)) != null) {
                if (bufCadastros.length() > 0) {
                    bufCadastros.append(" or ");
                }
                bufCadastros.append(" rpg.pac_codigo in (");
                for (int j = 0; j < paciente.length; ++j) {
                    bufCadastros.append("'");
                    bufCadastros.append(paciente[j]);
                    bufCadastros.append("'");
                    if (j >= paciente.length - 1) continue;
                    bufCadastros.append(", ");
                }
                bufCadastros.append(")");
            }
            if (bufCadastros.length() > 0) {
                whereRpg.append(" and (").append(bufCadastros.toString()).append(") ");
            }
            try {
                int i;
                StringBuilder buf = new StringBuilder();
                buf.append("select ");
                buf.append("a.ccu_reduzido as reduzidoCentroCusto, a.ccu_descricao as descricaoCentroCusto, a.ccu_conta as contaCentroCusto, ");
                buf.append("a.fil_codigo as filialCentroCusto, a.ccu_nivel as nivelCentroCusto, a.ccu_pai as paiCentroCusto, a.ccu_operacao as operacaoCentroCusto, ");
                if (this.tipoRelatorio == 1) {
                    buf.append("lcx.lcx_codigo as codigoLancamento, ");
                    buf.append("lcx.lcx_tipopagamento as tipoPagamentoLancamento, ");
                    buf.append("lcx.lcx_conta as contaLancamento, ");
                    buf.append("lcx.lcx_documento as documentoLancamento, ");
                    buf.append("lcx.lcx_vencimento as vencimentoLancamento, ");
                    buf.append("lcx.lcx_datahora as emissaoLancamento, ");
                    buf.append("lcx.lcx_conciliacao as conciliacaoLancamento, ");
                    buf.append("lcx.lcx_competencia as competenciaLancamento, ");
                    buf.append("lcx.lcx_tipo as tipoLancamento, ");
                    buf.append("lcx.opc_codigo as codigoOrigemLancamentoCentro, ");
                    buf.append("lcx.lcx_valor as valorLancamento, ");
                    buf.append("lcx.lcx_valortotal as valorTotalLancamento, ");
                    buf.append("lcx.lcc_valor as valorLancamentoCentro, ");
                    buf.append("lcx.lcx_situacao as situacaoLancamento, ");
                    buf.append("CASE WHEN a.ccu_operacao = 'A' THEN lcx.lcc_valor ELSE lcx.lcc_valor * (-1) END as valorLancamentoCentroComSinal, ");
                } else {
                    buf.append("rpg.rpg_datahora as dataHoraReceberPagar, ");
                    buf.append("rpg.rpg_vencimento as vencimentoReceberPagar, ");
                    buf.append("rpg.rpg_competencia as competenciaReceberPagar, ");
                    buf.append("rpg.rpg_codigo as codigoReceberPagar, ");
                    buf.append("rpg.rpg_tipo as tipoReceberPagar, ");
                    buf.append("rpg.rpg_tipodocumento as tipoDocumentoReceberPagar, ");
                    buf.append("rpg.rpg_numerodocumento as numeroDocumentoReceberPagar, ");
                    buf.append("rpg.rpg_parcela as parcelaReceberPagar, ");
                    buf.append("rpg.rpg_datadocumento as dataDocumentoReceberPagar, ");
                    buf.append("rpg.rpg_dataprocessamento as dataProcessamentoReceberPagar, ");
                    buf.append("rpg.ser_codigo as codigoSerieReceberPagar, ");
                    buf.append("rpg.rpg_situacao as situacaoReceberPagar, ");
                    buf.append("rpg.opc_codigo as codigoOrigemReceberPagar, ");
                    buf.append("rpg.rpg_valor as valorReceberPagar, ");
                    buf.append("rpg.rpg_valortotal as valorTotalReceberPagar, ");
                    buf.append("rpg.rcc_valor as valorReceberPagarCentro, ");
                    buf.append("CASE WHEN a.ccu_operacao = 'A' THEN rpg.rcc_valor ELSE rpg.rcc_valor * (-1) END as valorReceberPagarCentroComSinal, ");
                    buf.append(" rpg.rpg_tipocadastro as tipoCadastro, ");
                    buf.append(" CASE WHEN rpg.rpg_tipocadastro = '").append("P").append("' THEN rpg.pac_codigo ");
                    buf.append("      WHEN rpg.rpg_tipocadastro = '").append("O").append("' THEN rpg.con_codigo ");
                    buf.append("      ELSE rpg.ent_codigo END as codigoCadastro, ");
                }
                buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                buf.append("from centrocusto a ");
                if (this.tipoRelatorio == 1) {
                    buf.append("left join (select lcc.*, lcx.lcx_tipo, lcx.lcx_tipopagamento, lcx.lcx_conta, lcx.lcx_documento, lcx.lcx_situacao, ");
                    buf.append(" lcx.lcx_valor, lcx.lcx_valortotal, lcx.lcx_vencimento, lcx.lcx_competencia, lcx.lcx_datahora, lcx.lcx_conciliacao ");
                    buf.append(" from lanctocaixacentrocusto lcc, lanctocaixa lcx where lcx.lcx_codigo = lcc.lcx_codigo ");
                    buf.append("and lcx.fil_codigo = lcc.fil_codigo ");
                    buf.append("and lcx.lcx_situacao <> '").append("C").append("' ");
                    buf.append(whereRpg.toString() + whereRcc.toString() + whereOrigem.toString());
                    buf.append(") as lcx on (a.ccu_reduzido = lcx.ccu_reduzido and a.fil_codigo = lcx.fil_codigo) ");
                } else {
                    buf.append("left join (select rcc.ccu_reduzido, rcc.rcc_valor, rcc.opc_codigo, rpg.* from receberpagarcentrocusto rcc, receberpagar rpg where rcc.rpg_codigo = rpg.rpg_codigo ");
                    buf.append("and rcc.fil_codigo = rpg.fil_codigo and rpg.rpg_situacao IN ('").append("A").append("', '").append("Q").append("', '");
                    buf.append("V").append("', '").append("T").append("', '").append("S").append("') ");
                    buf.append(whereRpg.toString().replaceAll("lcx", "rpg").replaceAll("lcc", "rcc"));
                    buf.append(") as rpg on (a.ccu_reduzido = rpg.ccu_reduzido and a.fil_codigo = rpg.fil_codigo ");
                    buf.append(whereRcc.toString().replaceAll("lcx_valor ", "rcc_valor").replaceAll("lcx", "rpg").replaceAll("lcc", "rcc"));
                    buf.append(whereOrigem.toString().replaceAll("lcc", "rpg"));
                    buf.append(") ");
                }
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                buf.append("where a.fil_codigo ");
                if (filiais == null || filiais.length == 0) {
                    buf.append(" = ").append(Variaveis.filialPadrao);
                } else {
                    buf.append(" in (");
                    for (int i2 = 0; i2 < filiais.length; ++i2) {
                        buf.append(filiais[i2]);
                        if (i2 >= filiais.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                int maiorNivel = 0;
                ResultSet rs = null;
                try {
                    rs = Conexao.executeQuery(st, "select MAX(a.ccu_nivel) as maiorNivel from centrocusto a");
                    rs.next();
                    maiorNivel = rs.getInt("maiorNivel");
                }
                catch (Exception ex) {
                    maiorNivel = 0;
                }
                String[] centrocusto = this.getSelecionadosFiltro(FILTRO_CENTRO_CUSTO, 0);
                if (centrocusto != null) {
                    int i3;
                    buf.append(" and a.ccu_reduzido in (");
                    ArrayList<Integer> arrayAux = new ArrayList<Integer>();
                    for (int i4 = 0; i4 < centrocusto.length; ++i4) {
                        arrayAux.add(new Integer(centrocusto[i4]));
                    }
                    ArrayList<Integer> arrayAcima = this.getCentrosAcima((ArrayList)arrayAux.clone());
                    ArrayList<Integer> arrayAbaixo = this.getCentrosAbaixo((ArrayList)arrayAux.clone());
                    if (arrayAcima != null) {
                        for (i3 = 0; i3 < arrayAcima.size(); ++i3) {
                            if (arrayAux.contains(arrayAcima.get(i3))) continue;
                            arrayAux.add(arrayAcima.get(i3));
                        }
                    }
                    if (arrayAbaixo != null) {
                        for (i3 = 0; i3 < arrayAbaixo.size(); ++i3) {
                            if (arrayAux.contains(arrayAbaixo.get(i3))) continue;
                            arrayAux.add(arrayAbaixo.get(i3));
                        }
                    }
                    for (i3 = 0; i3 < arrayAux.size(); ++i3) {
                        buf.append(arrayAux.get(i3));
                        if (i3 >= arrayAux.size() - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                buf.append(" order by a.ccu_conta, ");
                int indice = this.getFiltroComboIndice(FILTRO_ORDEM);
                if (this.tipoRelatorio == 0) {
                    buf.append(camposOrdemRecPag[indice]).append(", rpg.rpg_codigo ");
                } else {
                    buf.append(camposOrdemLancto[indice]).append(", lcx.lcx_codigo ");
                }
                rs = Conexao.executeQuery(st, buf.toString());
                BigDecimal somatorioAux = new BigDecimal(0).setScale(2, RoundingMode.HALF_UP);
                BigDecimal somatorioComSinalAux = new BigDecimal(0).setScale(2, RoundingMode.HALF_UP);
                arrayValoresCentroCusto arrayCentros = null;
                if (rs.next()) {
                    maiorNivel = 0;
                    rs.last();
                    int qtdeLinhas = rs.getRow();
                    arrayCentros = new arrayValoresCentroCusto(qtdeLinhas);
                    rs.first();
                    do {
                        if (rs.getInt("nivelCentroCusto") <= maiorNivel) continue;
                        maiorNivel = rs.getInt("nivelCentroCusto");
                    } while (rs.next());
                    for (i = maiorNivel; i > 0; --i) {
                        rs.first();
                        do {
                            if (rs.getInt("nivelCentroCusto") != i) continue;
                            if (this.tipoRelatorio == 1) {
                                arrayCentros.somaValorConta(rs.getInt("reduzidoCentroCusto"), rs.getBigDecimal("valorLancamentoCentro"), rs.getBigDecimal("valorLancamentoCentroComSinal"));
                            } else {
                                arrayCentros.somaValorConta(rs.getInt("reduzidoCentroCusto"), rs.getBigDecimal("valorReceberPagarCentro"), rs.getBigDecimal("valorReceberPagarCentroComSinal"));
                            }
                            try {
                                if (this.tipoRelatorio == 1) {
                                    somatorioAux = somatorioAux.add(rs.getBigDecimal("valorLancamentoCentro"));
                                    somatorioComSinalAux = somatorioComSinalAux.add(rs.getBigDecimal("valorLancamentoCentroComSinal"));
                                } else {
                                    somatorioAux = somatorioAux.add(rs.getBigDecimal("valorReceberPagarCentro"));
                                    somatorioComSinalAux = somatorioComSinalAux.add(rs.getBigDecimal("valorReceberPagarCentroComSinal"));
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (rs.getInt("paiCentroCusto") == 0) continue;
                            if (i == maiorNivel) {
                                if (this.tipoRelatorio == 1) {
                                    arrayCentros.somaValorConta(rs.getInt("paiCentroCusto"), rs.getBigDecimal("valorLancamentoCentro"), rs.getBigDecimal("valorLancamentoCentroComSinal"));
                                    continue;
                                }
                                arrayCentros.somaValorConta(rs.getInt("paiCentroCusto"), rs.getBigDecimal("valorReceberPagarCentro"), rs.getBigDecimal("valorReceberPagarCentroComSinal"));
                                continue;
                            }
                            arrayCentros.somaValorConta(rs.getInt("paiCentroCusto"), rs.getInt("reduzidoCentroCusto"));
                        } while (rs.next());
                    }
                }
                rs.first();
                int posCampoReduzidoRelatorio = 0;
                for (i = 0; i < this.camposRelatorio.length; ++i) {
                    if (!this.camposRelatorio[i].equals("reduzidoCentroCusto")) continue;
                    posCampoReduzidoRelatorio = i;
                    break;
                }
                rs.beforeFirst();
                int reduzidoCentroCusto = -1;
                boolean imprimeLancto = false;
                if (rs.next()) {
                    int i5;
                    ModeloGridTable modelo = null;
                    modelo = this.tipoRelatorio == 1 ? new ModeloGridTable(ArraysUtil.concatenar(this.camposRelatorio, camposLancamento)) : new ModeloGridTable(ArraysUtil.concatenar(ArraysUtil.concatenar(this.camposRelatorio, camposRecPag), camposCadastros));
                    do {
                        int i6;
                        Object[] o = null;
                        o = this.tipoRelatorio == 1 ? new Object[this.camposRelatorio.length + camposLancamento.length] : new Object[this.camposRelatorio.length + camposRecPag.length + camposCadastros.length];
                        if (rs.getInt("nivelCentroCusto") == maiorNivel) {
                            imprimeLancto = reduzidoCentroCusto == -1 ? false : reduzidoCentroCusto == rs.getInt("reduzidoCentroCusto");
                            reduzidoCentroCusto = rs.getInt("reduzidoCentroCusto");
                            if (imprimeLancto) {
                                if (this.tipoRelatorio == 1) {
                                    for (i6 = 0; i6 < camposLancamento.length; ++i6) {
                                        if (camposLancamento[i6].equals("tipoPagamentoLancamento")) {
                                            o[modelo.findColumn((String)RelatorioRecPagLanctoCentro.camposLancamento[i6])] = Tipos.tipoPagamento(rs.getString(camposLancamento[i6]));
                                            continue;
                                        }
                                        if (camposLancamento[i6].equals("tipoLancamento")) {
                                            if (rs.getString(camposLancamento[i6]) != null) {
                                                o[modelo.findColumn((String)RelatorioRecPagLanctoCentro.camposLancamento[i6])] = Tipos.tipoLancamentoCaixa(rs.getString(camposLancamento[i6]));
                                                continue;
                                            }
                                            o[modelo.findColumn((String)RelatorioRecPagLanctoCentro.camposLancamento[i6])] = "";
                                            continue;
                                        }
                                        o[modelo.findColumn((String)RelatorioRecPagLanctoCentro.camposLancamento[i6])] = rs.getObject(camposLancamento[i6]);
                                    }
                                } else {
                                    for (i6 = 0; i6 < camposRecPag.length; ++i6) {
                                        if (camposRecPag[i6].equals("tipoDocumentoReceberPagar")) {
                                            o[modelo.findColumn((String)RelatorioRecPagLanctoCentro.camposRecPag[i6])] = Tipos.tipoDocumento(rs.getString(camposRecPag[i6]));
                                        } else if (camposRecPag[i6].equals("tipoReceberPagar")) {
                                            o[modelo.findColumn((String)RelatorioRecPagLanctoCentro.camposRecPag[i6])] = rs.getString(camposRecPag[i6]) != null ? Tipos.tipoReceberPagar(rs.getString(camposRecPag[i6])) : "";
                                        } else if (!(camposRecPag[i6].equalsIgnoreCase("dataVencimentoLancamentoBaixa") || camposRecPag[i6].equalsIgnoreCase("dataCompetenciaLancamentoBaixa") || camposRecPag[i6].equalsIgnoreCase("dataConciliacaoLancamentoBaixa") || camposRecPag[i6].equalsIgnoreCase("codigoBaixa") || camposRecPag[i6].equalsIgnoreCase("situacaoLancamentoBaixa"))) {
                                            o[modelo.findColumn((String)RelatorioRecPagLanctoCentro.camposRecPag[i6])] = rs.getObject(camposRecPag[i6]);
                                        }
                                        if (rs.getString("tipoCadastro") == null) continue;
                                        this.pegaDadosCadastro(st2, o, modelo, rs.getString("tipoCadastro"), rs.getInt("codigoFilial"), rs.getInt("codigoCadastro"));
                                    }
                                }
                            } else {
                                for (i6 = 0; i6 < this.camposRelatorio.length; ++i6) {
                                    if (this.camposRelatorio[i6].equals("totalCentroCusto")) {
                                        if (arrayCentros == null) continue;
                                        o[modelo.findColumn((String)this.camposRelatorio[i6])] = arrayCentros.getValorConta(rs.getInt(this.camposRelatorio[posCampoReduzidoRelatorio]));
                                        continue;
                                    }
                                    if (this.camposRelatorio[i6].equals("totalCentroCustoComSinal")) {
                                        if (arrayCentros == null) continue;
                                        o[modelo.findColumn((String)this.camposRelatorio[i6])] = arrayCentros.getValorContaComSinal(rs.getInt(this.camposRelatorio[posCampoReduzidoRelatorio]));
                                        continue;
                                    }
                                    if (this.camposRelatorio[i6].equals("valorSomatorio") || this.camposRelatorio[i6].equals("valorSomatorioComSinal") || this.camposRelatorio[i6].equalsIgnoreCase("dataVencimentoLancamentoBaixa") || this.camposRelatorio[i6].equalsIgnoreCase("dataCompetenciaLancamentoBaixa") || this.camposRelatorio[i6].equalsIgnoreCase("dataConciliacaoLancamentoBaixa") || this.camposRelatorio[i6].equalsIgnoreCase("codigoBaixa") || this.camposRelatorio[i6].equalsIgnoreCase("situacaoLancamentoBaixa")) continue;
                                    if (this.camposRelatorio[i6].equals("tipoLancamento")) {
                                        if (rs.getString(this.camposRelatorio[i6]) != null) {
                                            o[modelo.findColumn((String)this.camposRelatorio[i6])] = Tipos.tipoLancamentoCaixa(rs.getString(this.camposRelatorio[i6]));
                                            continue;
                                        }
                                        o[modelo.findColumn((String)this.camposRelatorio[i6])] = null;
                                        continue;
                                    }
                                    o[modelo.findColumn((String)this.camposRelatorio[i6])] = rs.getObject(this.camposRelatorio[i6]);
                                }
                                if (this.tipoRelatorio == 1) {
                                    if (rs.getString("codigoLancamento") != null && !Funcoes.textoVazio(rs.getString("codigoLancamento"))) {
                                        rs.previous();
                                    } else if (rs.next()) {
                                        if (reduzidoCentroCusto == rs.getInt("reduzidoCentroCusto")) {
                                            rs.previous();
                                        }
                                        rs.previous();
                                    }
                                } else if (rs.getString("codigoReceberPagar") != null && !Funcoes.textoVazio(rs.getString("codigoReceberPagar"))) {
                                    rs.previous();
                                } else if (rs.next()) {
                                    if (reduzidoCentroCusto == rs.getInt("reduzidoCentroCusto")) {
                                        rs.previous();
                                    }
                                    rs.previous();
                                }
                            }
                        } else {
                            for (i6 = 0; i6 < this.camposRelatorio.length; ++i6) {
                                if (this.camposRelatorio[i6].equals("totalCentroCusto")) {
                                    if (arrayCentros != null) {
                                        o[modelo.findColumn((String)this.camposRelatorio[i6])] = arrayCentros.getValorConta(rs.getInt(this.camposRelatorio[posCampoReduzidoRelatorio]));
                                    }
                                } else if (this.camposRelatorio[i6].equals("totalCentroCustoComSinal")) {
                                    if (arrayCentros != null) {
                                        o[modelo.findColumn((String)this.camposRelatorio[i6])] = arrayCentros.getValorContaComSinal(rs.getInt(this.camposRelatorio[posCampoReduzidoRelatorio]));
                                    }
                                } else if (!this.camposRelatorio[i6].equals("valorSomatorio") && !this.camposRelatorio[i6].equals("valorSomatorioComSinal")) {
                                    o[modelo.findColumn((String)this.camposRelatorio[i6])] = this.camposRelatorio[i6].equals("tipoLancamento") ? (rs.getString(this.camposRelatorio[i6]) != null ? Tipos.tipoLancamentoCaixa(rs.getString(this.camposRelatorio[i6])) : null) : rs.getObject(this.camposRelatorio[i6]);
                                }
                                try {
                                    if (rs.getString("tipoCadastro") == null) continue;
                                    this.pegaDadosCadastro(st2, o, modelo, rs.getString("tipoCadastro"), rs.getInt("codigoFilial"), rs.getInt("codigoCadastro"));
                                    continue;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            imprimeLancto = false;
                            reduzidoCentroCusto = -1;
                        }
                        modelo.addLine(o);
                    } while (rs.next());
                    for (i5 = 0; i5 < modelo.getRowCount(); ++i5) {
                        modelo.setValueAt(somatorioAux, i5, modelo.findColumn("valorSomatorio"));
                    }
                    for (i5 = 0; i5 < modelo.getRowCount(); ++i5) {
                        modelo.setValueAt(somatorioComSinalAux, i5, modelo.findColumn("valorSomatorioComSinal"));
                    }
                    if (this.tipoRelatorio == 0) {
                        for (i5 = 0; i5 < modelo.getRowCount(); ++i5) {
                            buf.delete(0, buf.length());
                            buf.append(" select lcx.fil_codigo as fil_codigo, ");
                            buf.append("   \t\t  rpg.rpg_codigo as rpg_codigo, ");
                            buf.append("       \tlcx.lcx_vencimento as lcx_vencimento, ");
                            buf.append("       \tlcx.lcx_competencia as lcx_competencia, ");
                            buf.append("      \tlcx.lcx_conciliacao as lcx_conciliacao, ");
                            buf.append("      \tlcx.lcx_situacao as lcx_situacao, ");
                            buf.append("      \tbxa.bxa_codigo as bxa_codigo ");
                            buf.append(" \t from receberpagar rpg ");
                            buf.append(" \t join baixareceberpagar brp on rpg.fil_codigo = brp.fil_codigo and rpg.rpg_codigo = brp.rpg_codigo ");
                            buf.append(" \t join baixa bxa on brp.fil_codigo = bxa.fil_codigo and brp.bxa_codigo = bxa.bxa_codigo and bxa.bxa_situacao <> '").append("E").append("' ");
                            buf.append(" \t join baixalanctocaixa blc on bxa.fil_codigo = blc.fil_codigo and bxa.bxa_codigo = blc.bxa_codigo ");
                            buf.append(" \t join lanctocaixa lcx on blc.fil_codigo = lcx.fil_codigo and blc.lcx_codigo = lcx.lcx_codigo and blc.est_codigo = lcx.est_codigo ");
                            buf.append("  where rpg.fil_codigo = ").append(filiais == null ? Variaveis.filialPadrao : filiais[0]);
                            buf.append("    and rpg.rpg_codigo = ").append(modelo.getValueAt(i5, modelo.findColumn("codigoReceberPagar")));
                            buf.append("   order by lcx.lcx_vencimento ");
                            buf.append("\tlimit 1 ");
                            try {
                                rs = st.executeQuery(buf.toString());
                                if (!rs.next()) continue;
                                modelo.setValueAt(rs.getDate("lcx_vencimento"), i5, modelo.findColumn("dataVencimentoLancamentoBaixa"));
                                modelo.setValueAt(rs.getDate("lcx_competencia"), i5, modelo.findColumn("dataCompetenciaLancamentoBaixa"));
                                modelo.setValueAt(rs.getDate("lcx_conciliacao"), i5, modelo.findColumn("dataConciliacaoLancamentoBaixa"));
                                modelo.setValueAt(rs.getInt("bxa_codigo"), i5, modelo.findColumn("codigoBaixa"));
                                modelo.setValueAt(rs.getString("lcx_situacao"), i5, modelo.findColumn("situacaoLancamentoBaixa"));
                                continue;
                            }
                            finally {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                        }
                    }
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    if (this.tipoRelatorio == 1) {
                        buf.append(RelatorioRecPagLanctoCentro.getModuloAcesso(1));
                    } else {
                        buf.append(RelatorioRecPagLanctoCentro.getModuloAcesso(0));
                    }
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(1.0f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioRecPagLanctoCentro.this.panelCentro.removeAll();
                                RelatorioRecPagLanctoCentro.this.panelCentro.repaint();
                                RelatorioRecPagLanctoCentro.this.habilitaBotaoImprimir(true);
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put(FILTRO_DATA_INICIAL, this.getFiltroData(FILTRO_DATA_INICIAL));
                        var.put(FILTRO_DATA_FINAL, this.getFiltroData(FILTRO_DATA_FINAL));
                        var.put(FILTRO_VALOR_INICIAL, this.getFiltroDecimal(FILTRO_VALOR_INICIAL));
                        var.put(FILTRO_VALOR_FINAL, this.getFiltroDecimal(FILTRO_VALOR_FINAL));
                        var.put(FILTRO_CAMPO_DATA, this.getFiltroCombo(FILTRO_CAMPO_DATA));
                        var.put(FILTRO_ORDEM, this.getFiltroCombo(FILTRO_ORDEM));
                        var.put(FILTRO_TIPO, this.getFiltroCombo(FILTRO_TIPO) == null ? "Todos" : this.getFiltroCombo(FILTRO_TIPO));
                        var.put(FILTRO_SITUACAO, this.getFiltroCombo(FILTRO_SITUACAO) == null ? "Todos" : this.getFiltroCombo(FILTRO_SITUACAO));
                        buf.delete(0, buf.length());
                        if (entidade != null) {
                            for (int i7 = 0; i7 < entidade.length; ++i7) {
                                buf.append(entidade[i7]);
                                if (i7 >= entidade.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put(FILTRO_ENTIDADE, buf.toString());
                        buf.delete(0, buf.length());
                        if (paciente != null) {
                            for (int i8 = 0; i8 < paciente.length; ++i8) {
                                buf.append(paciente[i8]);
                                if (i8 >= paciente.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put(FILTRO_PACIENTE, buf.toString());
                        buf.delete(0, buf.length());
                        if (convenio != null) {
                            for (int i9 = 0; i9 < convenio.length; ++i9) {
                                buf.append(convenio[i9]);
                                if (i9 >= convenio.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put(FILTRO_CONVENIO, buf.toString());
                        buf.delete(0, buf.length());
                        if (filiais != null) {
                            for (int i10 = 0; i10 < filiais.length; ++i10) {
                                buf.append(filiais[i10]);
                                if (i10 >= filiais.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put(FILTRO_FILIAL_CENTRO_CUSTO, buf.toString());
                        buf.delete(0, buf.length());
                        if (usuario != null) {
                            for (int i11 = 0; i11 < usuario.length; ++i11) {
                                buf.append(usuario[i11]);
                                if (i11 >= usuario.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put(FILTRO_USUARIO, buf.toString());
                        centrocusto = this.getSelecionadosFiltro(FILTRO_CENTRO_CUSTO, 0);
                        buf.delete(0, buf.length());
                        if (centrocusto != null) {
                            for (int i12 = 0; i12 < centrocusto.length; ++i12) {
                                buf.append(centrocusto[i12]);
                                if (i12 >= centrocusto.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put(FILTRO_CENTRO_CUSTO, buf.toString());
                        buf.delete(0, buf.length());
                        if (origem != null) {
                            for (int i13 = 0; i13 < origem.length; ++i13) {
                                buf.append(origem[i13]);
                                if (i13 >= origem.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put(FILTRO_ORIGEM, buf.toString());
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelCentro.revalidate();
                    }
                    break block152;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso(int tipoRelatorio) {
        if (tipoRelatorio == 1) {
            return Long.parseLong("0850902100");
        }
        if (tipoRelatorio == 0) {
            return Long.parseLong("0850901100");
        }
        return Long.parseLong("0850902100");
    }

    public long getConfigurarAcesso(int tipoRelatorio) {
        if (tipoRelatorio == 1) {
            return Long.parseLong("0850902101");
        }
        if (tipoRelatorio == 0) {
            return Long.parseLong("0850901100");
        }
        return Long.parseLong("0850902101");
    }

    private ArrayList<Integer> getCentrosAcima(ArrayList<Integer> planos) {
        Statement st = Conexao.getStatement();
        ArrayList<Integer> resultado = new ArrayList<Integer>();
        StringBuilder planosSql = null;
        StringBuilder buf = null;
        while (planos != null) {
            planosSql = new StringBuilder();
            for (int i = 0; i < planos.size() && planos != null; ++i) {
                planosSql.append(planos.get(i));
                if (i >= planos.size() - 1) continue;
                planosSql.append(", ");
            }
            buf = new StringBuilder();
            buf.append(" select ccu_pai ");
            buf.append("   from centrocusto ");
            buf.append("  where ccu_reduzido IN (").append((CharSequence)planosSql).append(") ");
            buf.append("    and fil_codigo = ").append(Variaveis.filialPadrao);
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (planos != null) {
                    planos.clear();
                }
                if (rs.next()) {
                    do {
                        if (rs.getString("ccu_pai") == null || resultado.contains(rs.getInt("ccu_pai"))) continue;
                        resultado.add(rs.getInt("ccu_pai"));
                        if (planos == null) continue;
                        planos.add(rs.getInt("ccu_pai"));
                    } while (rs.next());
                } else {
                    planos = null;
                }
            }
            catch (SQLException e) {
                break;
            }
            if (planos == null || planos.size() != 0) continue;
            planos = null;
        }
        Conexao.fecharStatement(st);
        if (resultado.size() == 0) {
            return null;
        }
        return resultado;
    }

    private ArrayList<Integer> getCentrosAbaixo(ArrayList<Integer> planos) {
        Statement st = Conexao.getStatement();
        ArrayList<Integer> resultado = new ArrayList<Integer>();
        StringBuilder planosSql = null;
        StringBuilder buf = null;
        while (planos != null) {
            planosSql = new StringBuilder();
            for (int i = 0; i < planos.size() && planos != null; ++i) {
                planosSql.append(planos.get(i));
                if (i >= planos.size() - 1) continue;
                planosSql.append(", ");
            }
            buf = new StringBuilder();
            buf.append(" select ccu_reduzido ");
            buf.append("   from centrocusto ");
            buf.append("  where ccu_pai IN (").append((CharSequence)planosSql).append(") ");
            buf.append("    and fil_codigo = ").append(Variaveis.filialPadrao);
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (planos != null) {
                    planos.clear();
                }
                if (rs.next()) {
                    do {
                        if (rs.getString("ccu_reduzido") == null || resultado.contains(rs.getInt("ccu_reduzido"))) continue;
                        resultado.add(rs.getInt("ccu_reduzido"));
                        if (planos == null) continue;
                        planos.add(rs.getInt("ccu_reduzido"));
                    } while (rs.next());
                } else {
                    planos = null;
                }
            }
            catch (SQLException e) {
                break;
            }
            if (planos == null || planos.size() != 0) continue;
            planos = null;
        }
        Conexao.fecharStatement(st);
        if (resultado.size() == 0) {
            return null;
        }
        return resultado;
    }

    private void pegaDadosCadastro(Statement st, Object[] array, ModeloGridTable modelo, String tipo, int filial, int codigo) throws SQLException {
        StringBuilder buf = new StringBuilder();
        if (tipo.equalsIgnoreCase("P")) {
            buf.append("select ");
            buf.append("\tpac.pac_codigo as codigoCadastro, pac.pac_nome as fantasiaCadastro,pac.pac_nomesocial as nomeSocialPaciente, pac.pac_nome as razaoSocialCadastro, pac.pac_fone as foneCadastro, ");
            buf.append("\tpac.pac_endereco as enderecoCadastro, pac.pac_numeroendereco as numeroEnderecoCadastro, pac.pac_tipologradouroendereco as tipoLogradouroCadastro, ");
            buf.append("\tpac.pac_fax as faxCadastro, pac.pac_complemento as complementoCadastro, pac.pac_cep as cepCadastro, ");
            buf.append("\tpac.cid_codigo as codigoCidadeCadastro, cidpac.cid_nome as nomeCidadeCadastro ");
            buf.append("from paciente pac ");
            buf.append("\tleft join cidades cidpac on pac.fil_codigo = cidpac.fil_codigo and pac.cid_codigo = cidpac.cid_codigo ");
            buf.append("where pac.fil_codigo = ").append(filial);
            buf.append(" and pac.pac_codigo = ").append(codigo);
        } else if (tipo.equalsIgnoreCase("O")) {
            buf.append("select ");
            buf.append("\tcon.con_codigo as codigoCadastro, con.con_fantasia as fantasiaCadastro, '' as nomeSocialPaciente, con.con_razao as razaoSocialCadastro, con.con_fone as foneCadastro, ");
            buf.append("\tcon.con_endereco as enderecoCadastro, con.con_numeroendereco as numeroEnderecoCadastro, con.con_tipologradouroendereco as tipoLogradouroCadastro, ");
            buf.append("\tcon.con_fax as faxCadastro, con.con_complemento as complementoCadastro, con.con_cep as cepCadastro, ");
            buf.append("\tcon.cid_codigo as codigoCidadeCadastro, cidcon.cid_nome as nomeCidadeCadastro ");
            buf.append("from convenios con ");
            buf.append("\tleft join cidades cidcon on con.fil_codigo = cidcon.fil_codigo and con.cid_codigo = cidcon.cid_codigo ");
            buf.append("where con.fil_codigo = ").append(filial);
            buf.append(" and con.con_codigo = ").append(codigo);
        } else {
            buf.append("select ");
            buf.append("\tent.ent_codigo as codigoCadastro, ent.ent_fantasia as fantasiaCadastro,'' as nomeSocialPaciente, ent.ent_razaosocial as razaoSocialCadastro, ent.ent_fone as foneCadastro, ");
            buf.append("\tent.ent_endereco as enderecoCadastro, ent.ent_numeroendereco as numeroEnderecoCadastro, ent.ent_tipologradouroendereco as tipoLogradouroCadastro, ");
            buf.append("\tent.ent_fax as faxCadastro, ent.ent_complemento as complementoCadastro, ent.ent_cep as cepCadastro, ");
            buf.append("\tent.cid_codigo as codigoCidadeCadastro, cident.cid_nome as nomeCidadeCadastro ");
            buf.append("from entidade ent ");
            buf.append("\tleft join cidades cident on ent.fil_codigo = cident.fil_codigo and ent.cid_codigo = cident.cid_codigo ");
            buf.append("where ent.fil_codigo = ").append(filial);
            buf.append(" and ent.ent_codigo = ").append(codigo);
        }
        ResultSet rs = Conexao.executeQuery(st, buf);
        if (rs.next()) {
            int pos = -1;
            for (String s : camposCadastros) {
                if (rs.findColumn(s) <= 0 || modelo.findColumn(s) <= -1) continue;
                pos = modelo.findColumn(s);
                array[pos] = modelo.getColumnName(pos).equalsIgnoreCase("tipoLogradouroCadastro") ? Tipos.tipoLogradouroDescricao(rs.getString(s)) : rs.getObject(s);
            }
        }
    }

    public class arrayValoresCentroCusto {
        private Integer[] reduzidoCentroCusto = null;
        private BigDecimal[] valorCentroCusto = null;
        private BigDecimal[] valorCentroCustoComSinal = null;

        public arrayValoresCentroCusto(Integer tamanho) {
            this.reduzidoCentroCusto = new Integer[tamanho.intValue()];
            this.valorCentroCusto = new BigDecimal[tamanho.intValue()];
            this.valorCentroCustoComSinal = new BigDecimal[tamanho.intValue()];
        }

        public void setContaValorPosicao(int posicao, int reduzidoCentroCusto, BigDecimal valorCentroCusto, BigDecimal valorCentroCustoComSinal) {
            this.reduzidoCentroCusto[posicao] = reduzidoCentroCusto;
            this.valorCentroCusto[posicao] = valorCentroCusto;
            this.valorCentroCustoComSinal[posicao] = valorCentroCustoComSinal;
        }

        public void setValorConta(int reduzidoCentroCusto, BigDecimal valorCentroCusto, BigDecimal valorCentroCustoComSinal) {
            int i;
            for (i = 0; i < this.reduzidoCentroCusto.length; ++i) {
                if (this.reduzidoCentroCusto[i] == null || !this.reduzidoCentroCusto[i].equals(reduzidoCentroCusto)) continue;
                this.valorCentroCusto[i] = valorCentroCusto;
                this.valorCentroCustoComSinal[i] = valorCentroCustoComSinal;
                return;
            }
            for (i = 0; i < this.reduzidoCentroCusto.length; ++i) {
                if (this.reduzidoCentroCusto[i] != null) continue;
                this.setContaValorPosicao(i, reduzidoCentroCusto, valorCentroCusto, valorCentroCustoComSinal);
                return;
            }
        }

        public BigDecimal getValorConta(int reduzidoCentroCusto) {
            for (int i = 0; i < this.reduzidoCentroCusto.length; ++i) {
                if (this.reduzidoCentroCusto[i] == null || this.reduzidoCentroCusto[i] != reduzidoCentroCusto) continue;
                return this.valorCentroCusto[i];
            }
            return BigDecimal.ZERO;
        }

        public BigDecimal getValorContaComSinal(int reduzidoCentroCusto) {
            for (int i = 0; i < this.reduzidoCentroCusto.length; ++i) {
                if (this.reduzidoCentroCusto[i] == null || this.reduzidoCentroCusto[i] != reduzidoCentroCusto) continue;
                return this.valorCentroCustoComSinal[i];
            }
            return BigDecimal.ZERO;
        }

        public void somaValorConta(int reduzidoCentroCusto, int reduzidoFilho) {
            this.setValorConta(reduzidoCentroCusto, this.getValorConta(reduzidoCentroCusto).add(this.getValorConta(reduzidoFilho)), this.getValorContaComSinal(reduzidoCentroCusto).add(this.getValorContaComSinal(reduzidoFilho)));
        }

        public void somaValorConta(int reduzidoCentroCusto, BigDecimal valorAdicionar, BigDecimal valorAdicionarComSinal) {
            if (valorAdicionar == null) {
                valorAdicionar = BigDecimal.ZERO;
            }
            if (valorAdicionarComSinal == null) {
                valorAdicionarComSinal = BigDecimal.ZERO;
            }
            this.setValorConta(reduzidoCentroCusto, this.getValorConta(reduzidoCentroCusto).add(valorAdicionar), this.getValorContaComSinal(reduzidoCentroCusto).add(valorAdicionarComSinal));
        }

        public Integer getContaPosicao(int posicao) {
            return this.reduzidoCentroCusto[posicao];
        }

        public BigDecimal getValorPosicao(int posicao) {
            return this.valorCentroCusto[posicao];
        }

        public BigDecimal getValorComSinalPosicao(int posicao) {
            return this.valorCentroCustoComSinal[posicao];
        }
    }
}

