/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.movimento;

import jalis.comum.Conexao;
import jalis.comum.ConstantesGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioPrevistoRealizadoPlanoConta
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String[] tipoPlanoConta = new String[]{"Todos", Tipos.tipoPlanoContas("R"), Tipos.tipoPlanoContas("D")};
    private final String[] camposAcumulados = new String[]{"saldoAnteriorRealizado", "saldoRealizadoTotal"};
    private final String FILTRO_PLANO_CONTA = "filtroPlanoConta";
    private final String FILTRO_FILIAL_PLANO_CONTA = "filtroFilialPlanoConta";
    private final String FILTRO_TIPO_PLANO = "filtroTipoPlanoConta";
    private final String FILTRO_USUARIO = "filtroUsuario";
    private final String FILTRO_ORIGEM = "filtroOrigem";
    private final String FILTRO_CAMPO_DATA = "filtroCampoData";
    private final String FILTRO_MES = "filtroMes";
    private final String FILTRO_ANO = "filtroAno";
    private final String FILTRO_DATA = "filtroData";
    private final String FILTRO_NIVEL = "filtroNivel";
    private final String[] MESES = ConstantesGerais.MESES_ANO;
    private final String[] CAMPOSDATA = new String[]{"Vencimento", "Cadastro", "Compet\u00eancia"};
    private final String[] CAMPOSDATABANCO = new String[]{"rpg.rpg_vencimento", "rpg.rpg_datahora", "rpg.rpg_competencia"};
    public static final int TIPO_DIARIO = 0;
    public static final int TIPO_MENSAL = 1;
    private int tipoRelatorio = 0;
    private static String[] camposRelatorio = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"reduzidoPlanoConta", "descricaoPlanoConta", "contaPlanoConta", "tipoPlanoConta", "nivelPlanoConta", "paiPlanoConta", "valorPrevisto", "valorRealizado", "valorDiferenca", "percDiferenca", "valorPrevistoComSinal", "valorRealizadoComSinal", "valorDiferencaComSinal", "totalValorPrevistoComSinal", "totalValorRealizadoComSinal", "totalValorDiferencaComSinal"});

    public RelatorioPrevistoRealizadoPlanoConta(int tipoRelatorio) {
        this.tipoRelatorio = tipoRelatorio;
        if (this.tipoRelatorio == 0) {
            this.montaBarraDescricao("<html>Relat\u00f3rio de Previsto x Realizado fluxo de caixa di\u00e1rio por plano de contas</html>", "Previsto x Realizado di\u00e1rio por planos de contas", "relatorios/rel_fluxo_caixa_diario.jpg");
        } else if (this.tipoRelatorio == 1) {
            this.montaBarraDescricao("<html>Relat\u00f3rio de Previsto x Realizado fluxo de caixa mensal por plano de contas</html>", "Previsto x Realizado mensal por planos de contas", "relatorios/rel_fluxo_caixa_mensal.jpg");
        } else {
            Funcoes.mensagem(this, "Tipo de relat\u00f3rio incorreto.", 1);
            return;
        }
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilialPlanoConta", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroUsuario", "Usu\u00e1rio", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroPlanoConta", "Plano Contas", "planoconta", "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"plc_reduzido", "plc_conta", "plc_descricao"}, new String[]{"C\u00f3digo", "Conta", "Descri\u00e7\u00e3o"}, new int[]{70, 120, 0});
        this.adicionaItemFiltro("filtroOrigem", "Origem", "origemplanocusto", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"opc_codigo", "opc_descricao", "opc_padrao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Padr\u00e3o"}, new int[]{70, 0, 50});
        try {
            String selectNivel = "";
            selectNivel = "select max(plc_nivel) as qtde from planoconta ";
            ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), selectNivel);
            if (rs.next()) {
                Object[] arrayNiveis = new Integer[rs.getInt("qtde")];
                for (int i = 1; i <= rs.getInt("qtde"); ++i) {
                    arrayNiveis[i - 1] = i;
                }
                this.adicionaFiltroCombo("filtroNivel", "N\u00edvel Plano", arrayNiveis, rs.getInt("qtde") - 1);
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel identificar os n\u00edveis. " + ex.getMessage(), ex.getStackTrace());
        }
        this.adicionaFiltroCombo("filtroCampoData", "Campo Data:", this.CAMPOSDATA, 0);
        if (tipoRelatorio == 0) {
            this.adicionaFiltroData("filtroData", "Data:");
        } else {
            this.adicionaFiltroCombo("filtroMes", "M\u00eas:", this.MESES, Calendar.getInstance().get(2));
            this.adicionaFiltroNumero("filtroAno", "Ano:", 4);
        }
        this.adicionaFiltroCombo("filtroTipoPlanoConta", "Tipo Plano:", this.tipoPlanoConta, 0);
        this.setModuloConfigurar(this.getConfigurarAcesso(this.tipoRelatorio));
        this.setModuloAcesso(RelatorioPrevistoRealizadoPlanoConta.getModuloAcesso(this.tipoRelatorio));
        camposRelatorio = ArraysUtil.concatenar(camposRelatorio, this.camposAcumulados);
        this.setCamposConfigurador(camposRelatorio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void imprimirPressionado() {
        block90: {
            st = Conexao.getStatement();
            filiais = this.getSelecionadosFiltro("filtroFilialPlanoConta", 0);
            if (filiais != null && filiais.length > 1) {
                Funcoes.mensagem(this, "Apenas uma filial deve ser selecionada para o relat\u00f3rio", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            if (this.tipoRelatorio == 0) {
                if (!Funcoes.verificaData(this.getFiltroData("filtroData"))) {
                    Funcoes.mensagem(this, "Insira uma data para o relat\u00f3rio", 2);
                    this.habilitaBotaoImprimir(true);
                    return;
                }
            } else {
                if (this.getFiltroNumero("filtroAno").equals("")) {
                    Funcoes.mensagem(this, "Insira um ano para o relat\u00f3rio", 2);
                    this.habilitaBotaoImprimir(true);
                    return;
                }
                if (this.getFiltroCombo("filtroNivel") == null) {
                    Funcoes.mensagem(this, "Selecione o n\u00edvel do plano de contas", 2);
                    this.habilitaBotaoImprimir(true);
                    return;
                }
            }
            whereLcx = new StringBuilder();
            whereRpg = new StringBuilder();
            aux = new StringBuilder();
            if (this.tipoRelatorio != 0) ** GOTO lbl41
            if (Funcoes.verificaData(this.getFiltroData("filtroData"))) {
                aux.append(" cast(" + this.CAMPOSDATABANCO[this.getFiltroComboIndice("filtroCampoData")] + " as date) = '");
                aux.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroData")));
                aux.append("' ");
            } else {
                Funcoes.mensagem(this, "Insira um data v\u00e1lida para o relat\u00f3rio", 2);
                this.habilitaBotaoImprimir(true);
                return;
lbl41:
                // 1 sources

                if (!this.getFiltroCombo("filtroMes").equals("")) {
                    auxData = this.getFiltroComboIndice("filtroMes") + 1 + "/01/" + this.getFiltroNumero("filtroAno").toString();
                    aux.append(" cast(" + this.CAMPOSDATABANCO[this.getFiltroComboIndice("filtroCampoData")] + " as date) between '");
                    aux.append(auxData);
                    aux.append("' and ");
                    aux.append("date_trunc('month', to_timestamp('" + auxData + "', 'MM/dd/yyyy')) + interval '1 month' - interval '1 day' ");
                } else {
                    Funcoes.mensagem(this, "Escolha um m\u00eas para o relat\u00f3rio", 2);
                    this.habilitaBotaoImprimir(true);
                    return;
                }
            }
            whereRpg.append(aux.toString());
            this.setCursor(Cursor.getPredefinedCursor(3));
            aux.delete(0, aux.length());
            usuario = this.getSelecionadosFiltro("filtroUsuario", 0);
            if (usuario != null) {
                aux.append(" and (rpg.usr_codigo in (");
                for (i = 0; i < usuario.length; ++i) {
                    aux.append("'");
                    aux.append(usuario[i]);
                    aux.append("'");
                    if (i >= usuario.length - 1) continue;
                    aux.append(", ");
                }
                aux.append(") OR rpg.usr_codigo IS NULL)");
            }
            whereLcx.append(aux.toString());
            whereRpg.append(aux.toString());
            aux.delete(0, aux.length());
            origem = this.getSelecionadosFiltro("filtroOrigem", 0);
            if (origem != null) {
                aux.append(" and rpl.opc_codigo in (");
                for (i = 0; i < origem.length; ++i) {
                    aux.append("'");
                    aux.append(origem[i]);
                    aux.append("'");
                    if (i >= origem.length - 1) continue;
                    aux.append(", ");
                }
                aux.append(")");
            }
            whereLcx.append(aux.toString());
            whereRpg.append(aux.toString());
            try {
                bufRpg = new StringBuilder();
                bufLcx = new StringBuilder();
                bufWhere = new StringBuilder();
                bufRpg.append(" select ");
                bufRpg.append(" \t\t\t a.fil_codigo      ");
                bufRpg.append(" \t\t\t,a.plc_reduzido    ");
                bufRpg.append("       ,a.plc_conta\t\t\t ");
                bufRpg.append("       ,a.plc_descricao   ");
                bufRpg.append("       ,a.plc_tipo        ");
                bufRpg.append("       ,a.plc_nivel\t\t   ");
                bufRpg.append("       ,a.plc_pai\t\t\t   ");
                bufRpg.append("       ,a.plc_operacao\t\t ");
                bufRpg.append("       ,COALESCE(SUM(CASE WHEN rpg.rpl_valor IS NULL THEN 0 ELSE rpg.rpl_valor END), 0) as valorPrevisto ");
                bufRpg.append("       ,0 as valorRealizado ");
                bufRpg.append("   from planoconta a ");
                bufRpg.append("   left join (select rpg.rpg_codigo ");
                bufRpg.append("                    ,rpg.fil_codigo ");
                bufRpg.append("                    ,rpl.plc_reduzido ");
                bufRpg.append("                    ,rpl.rpl_valor ");
                bufRpg.append("   from receberpagar rpg ");
                bufRpg.append("   join (select rpl.plc_reduzido ");
                bufRpg.append("               ,rpl.fil_codigo ");
                bufRpg.append("               ,rpl.rpl_valor ");
                bufRpg.append("               ,rpl.rpg_codigo ");
                bufRpg.append("               ,rpl.opc_codigo ");
                bufRpg.append("           from receberpagarplanoconta rpl) rpl on (rpg.rpg_codigo = rpl.rpg_codigo and rpg.fil_codigo = rpl.fil_codigo) ");
                bufRpg.append("  where ");
                bufRpg.append((CharSequence)whereRpg);
                bufRpg.append("    and rpg.rpg_situacao IN ('").append("A").append("', '").append("Q").append("', '");
                bufRpg.append("V").append("', '").append("T").append("', '").append("S").append("') ");
                bufRpg.append("             ) rpg ");
                bufRpg.append("     on (a.plc_reduzido = rpg.plc_reduzido and a.fil_codigo = rpg.fil_codigo) ");
                bufLcx.append(" select ");
                bufLcx.append(" \t\t\t a.fil_codigo     \t");
                bufLcx.append(" \t\t\t,a.plc_reduzido   \t");
                bufLcx.append("       ,a.plc_conta\t\t\t\t");
                bufLcx.append("       ,a.plc_descricao  \t");
                bufLcx.append("       ,a.plc_tipo       \t");
                bufLcx.append("       ,a.plc_nivel\t\t  \t");
                bufLcx.append("       ,a.plc_pai\t\t\t  \t");
                bufLcx.append("       ,a.plc_operacao\t\t\t");
                bufLcx.append("       ,0 as valorPrevisto ");
                bufLcx.append("       ,SUM(CASE WHEN lcx.lpl_valor IS NULL THEN 0 ELSE lcx.lpl_valor END) as valorRealizado ");
                bufLcx.append("   from planoconta a ");
                bufLcx.append("   left join (select lcx.lcx_codigo ");
                bufLcx.append("                    ,lcx.fil_codigo ");
                bufLcx.append("                    ,lpl.plc_reduzido ");
                bufLcx.append("                    ,lpl.lpl_valor ");
                bufLcx.append("   from lanctocaixa lcx ");
                bufLcx.append("   join (select lpl.plc_reduzido ");
                bufLcx.append("               ,lpl.fil_codigo ");
                bufLcx.append("               ,lpl.lpl_valor ");
                bufLcx.append("               ,lpl.lcx_codigo ");
                bufLcx.append("               ,lpl.est_codigo ");
                bufLcx.append("               ,lpl.opc_codigo ");
                bufLcx.append("           from lanctocaixaplanoconta lpl) lpl on (lcx.lcx_codigo = lpl.lcx_codigo and lcx.fil_codigo = lpl.fil_codigo and lcx.est_codigo = lpl.est_codigo) ");
                bufLcx.append("  where ");
                bufLcx.append(whereRpg.toString().replaceAll("rpg", "lcx").replaceAll("rpl", "lpl"));
                bufLcx.append("    and lcx.lcx_situacao <> '").append("C").append("' ");
                bufLcx.append("             ) lcx ");
                bufLcx.append("     on (a.plc_reduzido = lcx.plc_reduzido and a.fil_codigo = lcx.fil_codigo) ");
                bufWhere.append("where a.fil_codigo ");
                if (filiais == null || filiais.length == 0) {
                    bufWhere.append(" = ").append(Variaveis.filialPadrao);
                } else {
                    bufWhere.append(" in (");
                    for (i = 0; i < filiais.length; ++i) {
                        bufWhere.append(filiais[i]);
                        if (i >= filiais.length - 1) continue;
                        bufWhere.append(", ");
                    }
                    bufWhere.append(")");
                }
                maiorNivel = 0;
                rs = null;
                try {
                    rs = Conexao.executeQuery(st, "select MAX(a.plc_nivel) as maiorNivel from planoconta a");
                    rs.next();
                    maiorNivel = rs.getInt("maiorNivel");
                }
                catch (Exception ex) {
                    maiorNivel = 0;
                }
                planoconta = this.getSelecionadosFiltro("filtroPlanoConta", 0);
                if (planoconta != null) {
                    bufWhere.append(" and a.plc_reduzido in (");
                    arrayAux = new ArrayList<Integer>();
                    for (i = 0; i < planoconta.length; ++i) {
                        arrayAux.add(new Integer(planoconta[i]));
                    }
                    arrayAcima = this.getPlanosAcima((ArrayList)arrayAux.clone());
                    arrayAbaixo = this.getPlanosAbaixo((ArrayList)arrayAux.clone());
                    if (arrayAcima != null) {
                        for (i = 0; i < arrayAcima.size(); ++i) {
                            if (arrayAux.contains(arrayAcima.get(i))) continue;
                            arrayAux.add(arrayAcima.get(i));
                        }
                    }
                    if (arrayAbaixo != null) {
                        for (i = 0; i < arrayAbaixo.size(); ++i) {
                            if (arrayAux.contains(arrayAbaixo.get(i))) continue;
                            arrayAux.add(arrayAbaixo.get(i));
                        }
                    }
                    for (i = 0; i < arrayAux.size(); ++i) {
                        bufWhere.append(arrayAux.get(i));
                        if (i >= arrayAux.size() - 1) continue;
                        bufWhere.append(", ");
                    }
                    bufWhere.append(")");
                }
                if (!this.getFiltroCombo("filtroTipoPlanoConta").toString().equals(this.tipoPlanoConta[0])) {
                    combo = this.getFiltroCombo("filtroTipoPlanoConta").toString();
                    bufWhere.append(" and a.plc_tipo = '");
                    if (combo.equals(this.tipoPlanoConta[1])) {
                        bufWhere.append("R");
                    } else if (combo.equals(this.tipoPlanoConta[2])) {
                        bufWhere.append("D");
                    } else {
                        bufWhere.append("C");
                    }
                    bufWhere.append("'");
                }
                bufOrder = new StringBuilder();
                bufOrder.append("  group by a.plc_reduzido  ");
                bufOrder.append("          ,a.plc_conta     ");
                bufOrder.append("          ,a.plc_descricao ");
                bufOrder.append("\t\t       ,a.plc_tipo      ");
                bufOrder.append("\t\t\t\t\t ,a.plc_nivel     ");
                bufOrder.append("\t\t\t\t\t ,a.plc_pai       ");
                bufOrder.append("\t\t\t\t\t ,a.plc_operacao  ");
                bufOrder.append("\t\t\t\t\t ,a.fil_codigo    ");
                bufOrder.append("\t\t\t\t\t , ");
                for (i = 0; i < Constantes.CAMPOS_FILIAL.length; ++i) {
                    if (i > 0) {
                        bufOrder.append(", ");
                    }
                    bufOrder.append(Constantes.CAMPOS_FILIAL[i]);
                }
                bufOrder.append("  order by a.plc_conta");
                bufSql = new StringBuilder();
                bufSql.append(" SELECT a.plc_reduzido  \t\t as reduzidoPlanoConta ");
                bufSql.append("       ,a.plc_conta\t\t \t\t as contaPlanoConta ");
                bufSql.append("       ,a.plc_descricao \t\t as descricaoPlanoConta ");
                bufSql.append("       ,a.plc_tipo      \t\t as tipoPlanoConta ");
                bufSql.append(" \t\t\t,a.plc_nivel\t\t \t\t as nivelPlanoConta ");
                bufSql.append(" \t\t\t,a.plc_pai\t\t\t \t\t as paiPlanoConta ");
                bufSql.append(" \t\t\t,a.plc_operacao\t \t\t as operacaoPlanoConta ");
                bufSql.append("       ,SUM(CASE WHEN a.plc_operacao = '").append("A").append("' THEN valorPrevisto ELSE valorPrevisto * (-1) END)  as valorPrevisto ");
                bufSql.append("       ,SUM(CASE WHEN a.plc_operacao = '").append("A").append("' THEN valorRealizado ELSE valorRealizado * (-1) END)  as valorRealizado ");
                bufSql.append("       ,");
                bufSql.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                bufSql.append("  FROM ( ");
                bufSql.append(" ( ");
                bufSql.append((CharSequence)bufRpg);
                bufSql.append((CharSequence)bufWhere);
                bufSql.append("  group by a.plc_reduzido  ");
                bufSql.append("          ,a.plc_conta     ");
                bufSql.append("          ,a.plc_descricao ");
                bufSql.append("          ,a.plc_tipo \t\t\t");
                bufSql.append("          ,a.plc_nivel \t\t");
                bufSql.append("          ,a.plc_pai \t\t\t");
                bufSql.append("          ,a.plc_operacao  ");
                bufSql.append("          ,a.fil_codigo    ");
                bufSql.append(" ) ");
                bufSql.append(" UNION ");
                bufSql.append(" ( ");
                bufSql.append((CharSequence)bufLcx);
                bufSql.append((CharSequence)bufWhere);
                bufSql.append("  group by a.plc_reduzido  ");
                bufSql.append("          ,a.plc_conta     ");
                bufSql.append("          ,a.plc_descricao ");
                bufSql.append("          ,a.plc_tipo \t\t\t");
                bufSql.append("          ,a.plc_nivel \t\t");
                bufSql.append("          ,a.plc_pai \t\t\t");
                bufSql.append("          ,a.plc_operacao  ");
                bufSql.append("          ,a.fil_codigo    ");
                bufSql.append(" ) ");
                bufSql.append(" ) as a ");
                bufSql.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                bufSql.append((CharSequence)bufOrder);
                rs = Conexao.executeQuery(st, bufSql.toString());
                arrayContas = null;
                if (rs.next()) {
                    maiorNivel = 0;
                    rs.last();
                    qtdeLinhas = rs.getRow();
                    arrayContas = new arrayValoresPlanoConta(qtdeLinhas);
                    rs.first();
                    do {
                        if (rs.getInt("nivelPlanoConta") <= maiorNivel) continue;
                        maiorNivel = rs.getInt("nivelPlanoConta");
                    } while (rs.next());
                    for (i = maiorNivel; i > Integer.parseInt(this.getFiltroCombo("filtroNivel").toString()); --i) {
                        rs.first();
                        do {
                            arrayContas.somaValorConta(rs.getInt("reduzidoPlanoConta"), rs.getFloat("valorPrevisto"), rs.getFloat("valorRealizado"));
                            if (rs.getInt("paiPlanoConta") < 0 || i < Integer.parseInt(this.getFiltroCombo("filtroNivel").toString())) continue;
                            arrayContas.somaValorConta(rs.getInt("paiPlanoConta"), rs.getInt("reduzidoPlanoConta"));
                        } while (rs.next());
                    }
                    for (i = nivel = Integer.parseInt(this.getFiltroCombo("filtroNivel").toString()); i > 0; --i) {
                        rs.first();
                        do {
                            if (rs.getInt("nivelPlanoConta") > i) continue;
                            arrayContas.somaValorConta(rs.getInt("reduzidoPlanoConta"), rs.getFloat("valorPrevisto"), rs.getFloat("valorRealizado"));
                            if (rs.getInt("paiPlanoConta") < 0 || i > Integer.parseInt(this.getFiltroCombo("filtroNivel").toString())) continue;
                            arrayContas.somaValorConta(rs.getInt("paiPlanoConta"), rs.getInt("reduzidoPlanoConta"));
                        } while (rs.next());
                    }
                }
                rs.first();
                posCampoReduzidoRelatorio = 0;
                for (i = 0; i < RelatorioPrevistoRealizadoPlanoConta.camposRelatorio.length; ++i) {
                    if (!RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[i].equals("reduzidoPlanoConta")) continue;
                    posCampoReduzidoRelatorio = i;
                    break;
                }
                acumuladoRealizado = BigDecimal.ZERO;
                rs.beforeFirst();
                modelo = new ModeloGridTable(RelatorioPrevistoRealizadoPlanoConta.camposRelatorio);
                while (rs.next()) {
                    if (rs.getInt("nivelPlanoConta") > Integer.parseInt(this.getFiltroCombo("filtroNivel").toString())) continue;
                    o = new Object[RelatorioPrevistoRealizadoPlanoConta.camposRelatorio.length];
                    for (i = 0; i < RelatorioPrevistoRealizadoPlanoConta.camposRelatorio.length; ++i) {
                        if (ArraysUtil.contem(this.camposAcumulados, RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[i])) continue;
                        if (RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[i].equals("tipoPlanoConta")) {
                            o[modelo.findColumn((String)RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[i])] = Tipos.tipoPlanoContas(rs.getString(RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[i]));
                            continue;
                        }
                        if (RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[i].equals("valorPrevisto")) {
                            if (arrayContas == null) continue;
                            o[modelo.findColumn((String)RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[i])] = arrayContas.getValorPrevistoConta(rs.getInt(RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[posCampoReduzidoRelatorio]));
                            continue;
                        }
                        if (RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[i].equals("valorRealizado")) {
                            if (arrayContas == null) continue;
                            o[modelo.findColumn((String)RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[i])] = arrayContas.getValorRealizadoConta(rs.getInt(RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[posCampoReduzidoRelatorio]));
                            continue;
                        }
                        if (RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[i].equals("valorDiferenca")) {
                            if (arrayContas == null) continue;
                            o[modelo.findColumn((String)RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[i])] = arrayContas.getValorDiferencaConta(rs.getInt(RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[posCampoReduzidoRelatorio]));
                            continue;
                        }
                        if (RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[i].equals("valorPrevistoComSinal")) {
                            previsto = new Float(0.0f);
                            if (arrayContas != null) {
                                previsto = arrayContas.getValorPrevistoConta(rs.getInt(RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[posCampoReduzidoRelatorio]));
                            }
                            o[modelo.findColumn((String)RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[i])] = previsto;
                            continue;
                        }
                        if (RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[i].equals("totalValorPrevistoComSinal")) {
                            if (rs.getInt("nivelPlanoConta") != 1) continue;
                            previsto = new Float(0.0f);
                            if (arrayContas != null) {
                                previsto = arrayContas.getValorPrevistoConta(rs.getInt(RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[posCampoReduzidoRelatorio]));
                            }
                            o[modelo.findColumn((String)RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[i])] = previsto;
                            continue;
                        }
                        if (RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[i].equals("valorRealizadoComSinal")) {
                            realizado = new Float(0.0f);
                            if (arrayContas != null) {
                                realizado = arrayContas.getValorRealizadoConta(rs.getInt(RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[posCampoReduzidoRelatorio]));
                            }
                            o[modelo.findColumn((String)RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[i])] = realizado;
                            acumuladoRealizado = acumuladoRealizado.add(new BigDecimal(realizado.floatValue()).setScale(2, RoundingMode.HALF_UP));
                            continue;
                        }
                        if (RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[i].equals("totalValorRealizadoComSinal")) {
                            if (rs.getInt("nivelPlanoConta") != 1) continue;
                            realizado = new Float(0.0f);
                            if (arrayContas != null) {
                                realizado = arrayContas.getValorRealizadoConta(rs.getInt(RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[posCampoReduzidoRelatorio]));
                            }
                            o[modelo.findColumn((String)RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[i])] = realizado;
                            acumuladoRealizado = acumuladoRealizado.add(new BigDecimal(realizado.floatValue()).setScale(2, RoundingMode.HALF_UP));
                            continue;
                        }
                        if (RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[i].equals("valorDiferencaComSinal") && arrayContas != null) {
                            valorPrevisto = new BigDecimal(arrayContas.getValorPrevistoConta(rs.getInt(RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[posCampoReduzidoRelatorio])).floatValue());
                            valorRealizado = new BigDecimal(arrayContas.getValorRealizadoConta(rs.getInt(RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[posCampoReduzidoRelatorio])).floatValue());
                            diferenca = valorPrevisto.subtract(valorRealizado);
                            diferenca = diferenca.setScale(2, RoundingMode.HALF_UP);
                            if (arrayContas != null) {
                                arrayContas.getValorDiferencaConta(rs.getInt(RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[posCampoReduzidoRelatorio]));
                            }
                            o[modelo.findColumn((String)RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[i])] = diferenca.doubleValue();
                            continue;
                        }
                        if (RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[i].equals("totalValorDiferencaComSinal")) {
                            if (rs.getInt("nivelPlanoConta") != 1) continue;
                            valorPrevisto = new BigDecimal(arrayContas.getValorPrevistoConta(rs.getInt(RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[posCampoReduzidoRelatorio])).floatValue());
                            valorRealizado = new BigDecimal(arrayContas.getValorRealizadoConta(rs.getInt(RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[posCampoReduzidoRelatorio])).floatValue());
                            diferenca = valorPrevisto.subtract(valorRealizado);
                            diferenca = diferenca.setScale(2, RoundingMode.HALF_UP);
                            if (arrayContas != null) {
                                arrayContas.getValorDiferencaConta(rs.getInt(RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[posCampoReduzidoRelatorio]));
                            }
                            o[modelo.findColumn((String)RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[i])] = diferenca.doubleValue();
                            continue;
                        }
                        if (RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[i].equals("percDiferenca")) {
                            if (arrayContas == null) continue;
                            o[modelo.findColumn((String)RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[i])] = arrayContas.getPercDiferencaConta(rs.getInt(RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[posCampoReduzidoRelatorio]));
                            continue;
                        }
                        if (RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[i].equals("tipoLancamento")) {
                            if (rs.getString(RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[i]) != null) {
                                o[modelo.findColumn((String)RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[i])] = Tipos.tipoLancamentoCaixa(rs.getString(RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[i]));
                                continue;
                            }
                            o[modelo.findColumn((String)RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[i])] = null;
                            continue;
                        }
                        o[modelo.findColumn((String)RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[i])] = rs.getObject(RelatorioPrevistoRealizadoPlanoConta.camposRelatorio[i]);
                    }
                    modelo.addLine(o);
                }
                if (modelo.getRowCount() > 0) {
                    bufSql.delete(0, bufSql.length());
                    bufSql.append(" select SUM(case when plc.plc_operacao = '").append("A").append("' then lpl.lpl_valor ");
                    bufSql.append("            else (lpl.lpl_valor * (-1) ) ");
                    bufSql.append("            end) as saldoAnteriorRealizado ");
                    bufSql.append("   from lanctocaixaplanoconta lpl ");
                    bufSql.append("   join lanctocaixa lcx on lpl.fil_codigo = lcx.fil_codigo and lpl.lcx_codigo = lcx.lcx_codigo and lpl.est_codigo = lcx.est_codigo ");
                    bufSql.append("   join planoconta plc on lpl.fil_codigo = plc.fil_codigo and lpl.plc_reduzido = plc.plc_reduzido ");
                    bufSql.append("  where lpl.fil_codigo = ").append(filiais == null ? Variaveis.filialPadrao : filiais[0]);
                    bufSql.append("    and lcx.lcx_situacao IN ('").append("A").append("', '").append("O").append("') ");
                    bufSql.append(whereLcx.toString().replaceAll("rpl", "lpl").replaceAll("rpg", "lcx"));
                    bufData = new StringBuilder();
                    if (this.tipoRelatorio == 0) {
                        bufData.append("    and ").append(this.CAMPOSDATABANCO[this.getFiltroComboIndice("filtroCampoData")]);
                        bufData.append(" < '").append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroData"))).append("' ");
                    } else {
                        bufData.append("    and ").append(this.CAMPOSDATABANCO[this.getFiltroComboIndice("filtroCampoData")]);
                        bufData.append(" < '").append(this.getFiltroComboIndice("filtroMes") + 1 + "/01/" + this.getFiltroNumero("filtroAno")).append("' ");
                    }
                    bufSql.append(bufData.toString().replaceAll(" rpg.", " lcx.").replaceAll("rpg_", "lcx_"));
                    try {
                        rs = st.executeQuery(bufSql.toString());
                        if (rs.next()) {
                            acumulado = rs.getBigDecimal("saldoAnteriorRealizado") == null ? new BigDecimal(0) : rs.getBigDecimal("saldoAnteriorRealizado").setScale(2, RoundingMode.HALF_UP);
                            acumuladoTotal = acumulado.add(acumuladoRealizado).setScale(2, RoundingMode.HALF_UP);
                            for (i = 0; i < modelo.getRowCount(); ++i) {
                                modelo.setValueAt(acumulado.doubleValue(), i, modelo.findColumn("saldoAnteriorRealizado"));
                                modelo.setValueAt(acumuladoTotal.doubleValue(), i, modelo.findColumn("saldoRealizadoTotal"));
                            }
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    buf = new StringBuilder();
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    if (this.tipoRelatorio == 0) {
                        buf.append(RelatorioPrevistoRealizadoPlanoConta.getModuloAcesso(0));
                    } else {
                        buf.append(RelatorioPrevistoRealizadoPlanoConta.getModuloAcesso(1));
                    }
                    try {
                        rs = Conexao.executeQuery(st, buf.toString());
                        if (rs.next()) {
                            gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                            gerador.setPai(this.panelCentro);
                            gerador.setPreVisualizar(true);
                            gerador.setZoomPreVisualizar(1.0f);
                            gerador.setAcaoFechar(new Runnable(){

                                @Override
                                public void run() {
                                    RelatorioPrevistoRealizadoPlanoConta.this.panelCentro.removeAll();
                                    RelatorioPrevistoRealizadoPlanoConta.this.panelCentro.repaint();
                                    RelatorioPrevistoRealizadoPlanoConta.this.habilitaBotaoImprimir(true);
                                }
                            });
                            var = new HashMap<String, Object>();
                            var.put("filtroData", this.getFiltroData("filtroData"));
                            var.put("filtroMes", this.getFiltroCombo("filtroMes"));
                            var.put("filtroAno", this.getFiltroData("filtroAno"));
                            var.put("filtroTipoPlanoConta", this.getFiltroCombo("filtroTipoPlanoConta"));
                            var.put("filtroCampoData", this.getFiltroCombo("filtroCampoData"));
                            var.put("filtroNivel", this.getFiltroCombo("filtroNivel"));
                            buf.delete(0, buf.length());
                            if (filiais != null) {
                                for (i = 0; i < filiais.length; ++i) {
                                    buf.append(filiais[i]);
                                    if (i >= filiais.length - 1) continue;
                                    buf.append(", ");
                                }
                            }
                            var.put("filtroFilialPlanoConta", Funcoes.textoVazio(buf.toString()) != false ? Variaveis.filialPadrao : buf.toString());
                            buf.delete(0, buf.length());
                            if (usuario != null) {
                                for (i = 0; i < usuario.length; ++i) {
                                    buf.append(usuario[i]);
                                    if (i >= usuario.length - 1) continue;
                                    buf.append(", ");
                                }
                            }
                            var.put("filtroUsuario", buf.toString());
                            buf.delete(0, buf.length());
                            if (planoconta != null) {
                                for (i = 0; i < planoconta.length; ++i) {
                                    buf.append(planoconta[i]);
                                    if (i >= planoconta.length - 1) continue;
                                    buf.append(", ");
                                }
                            }
                            var.put("filtroPlanoConta", buf.toString());
                            buf.delete(0, buf.length());
                            if (origem != null) {
                                for (i = 0; i < origem.length; ++i) {
                                    buf.append(origem[i]);
                                    if (i >= origem.length - 1) continue;
                                    buf.append(", ");
                                }
                            }
                            var.put("filtroOrigem", buf.toString());
                            gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                            this.panelCentro.revalidate();
                        }
                        break block90;
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable var27_47) {
                    Conexao.fecharStatement(new Statement[]{st});
                    throw var27_47;
                }
                Conexao.fecharStatement(new Statement[]{st});
            }
        }
        Conexao.fecharStatement(new Statement[]{st});
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso(int tipoRelatorio) {
        if (tipoRelatorio == 0) {
            return Long.parseLong("0850820100");
        }
        if (tipoRelatorio == 1) {
            return Long.parseLong("0850820200");
        }
        return Long.parseLong("0850820100");
    }

    public long getConfigurarAcesso(int tipoRelatorio) {
        if (tipoRelatorio == 0) {
            return Long.parseLong("0850820101");
        }
        if (tipoRelatorio == 1) {
            return Long.parseLong("0850820201");
        }
        return Long.parseLong("0850820101");
    }

    private ArrayList<Integer> getPlanosAcima(ArrayList<Integer> planos) {
        Statement st = Conexao.getStatement();
        ArrayList<Integer> resultado = new ArrayList<Integer>();
        StringBuilder planosSql = null;
        StringBuilder buf = null;
        while (planos != null) {
            planosSql = new StringBuilder();
            for (int i = 0; i < planos.size() && planos != null; ++i) {
                planosSql.append(planos.get(i));
                if (i >= planos.size() - 1) continue;
                planosSql.append(", ");
            }
            buf = new StringBuilder();
            buf.append(" select plc_pai ");
            buf.append("   from planoconta ");
            buf.append("  where plc_reduzido IN (").append((CharSequence)planosSql).append(") ");
            buf.append("    and fil_codigo = ").append(Variaveis.filialPadrao);
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (planos != null) {
                    planos.clear();
                }
                if (rs.next()) {
                    do {
                        if (rs.getString("plc_pai") == null || resultado.contains(rs.getInt("plc_pai"))) continue;
                        resultado.add(rs.getInt("plc_pai"));
                        if (planos == null) continue;
                        planos.add(rs.getInt("plc_pai"));
                    } while (rs.next());
                } else {
                    planos = null;
                }
            }
            catch (SQLException e) {
                break;
            }
            if (planos == null || planos.size() != 0) continue;
            planos = null;
        }
        Conexao.fecharStatement(st);
        if (resultado.size() == 0) {
            return null;
        }
        return resultado;
    }

    private ArrayList<Integer> getPlanosAbaixo(ArrayList<Integer> planos) {
        Statement st = Conexao.getStatement();
        ArrayList<Integer> resultado = new ArrayList<Integer>();
        StringBuilder planosSql = null;
        StringBuilder buf = null;
        while (planos != null) {
            planosSql = new StringBuilder();
            for (int i = 0; i < planos.size() && planos != null; ++i) {
                planosSql.append(planos.get(i));
                if (i >= planos.size() - 1) continue;
                planosSql.append(", ");
            }
            buf = new StringBuilder();
            buf.append(" select plc_reduzido ");
            buf.append("   from planoconta ");
            buf.append("  where plc_pai IN (").append((CharSequence)planosSql).append(") ");
            buf.append("    and fil_codigo = ").append(Variaveis.filialPadrao);
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (planos != null) {
                    planos.clear();
                }
                if (rs.next()) {
                    do {
                        if (rs.getString("plc_reduzido") == null || resultado.contains(rs.getInt("plc_reduzido"))) continue;
                        resultado.add(rs.getInt("plc_reduzido"));
                        if (planos == null) continue;
                        planos.add(rs.getInt("plc_reduzido"));
                    } while (rs.next());
                } else {
                    planos = null;
                }
            }
            catch (SQLException e) {
                break;
            }
            if (planos == null || planos.size() != 0) continue;
            planos = null;
        }
        Conexao.fecharStatement(st);
        if (resultado.size() == 0) {
            return null;
        }
        return resultado;
    }

    public class arrayValoresPlanoConta {
        private Integer[] reduzidoPlanoConta = null;
        private Float[] valorPrevistoConta = null;
        private Float[] valorRealizadoConta = null;
        private Float[] valorDiferencaConta = null;
        private Float[] percDiferencaConta = null;

        public arrayValoresPlanoConta(Integer tamanho) {
            this.reduzidoPlanoConta = new Integer[tamanho.intValue()];
            this.valorPrevistoConta = new Float[tamanho.intValue()];
            this.valorRealizadoConta = new Float[tamanho.intValue()];
            this.valorDiferencaConta = new Float[tamanho.intValue()];
            this.percDiferencaConta = new Float[tamanho.intValue()];
        }

        public void setContaValoresPosicao(int posicao, int reduzidoPlanoConta, float valorPrevistoConta, float valorRealizadoConta) {
            this.reduzidoPlanoConta[posicao] = reduzidoPlanoConta;
            this.valorPrevistoConta[posicao] = Float.valueOf(valorPrevistoConta);
            this.valorRealizadoConta[posicao] = Float.valueOf(valorRealizadoConta);
            this.valorDiferencaConta[posicao] = Float.valueOf(valorPrevistoConta - valorRealizadoConta);
            this.percDiferencaConta[posicao] = valorPrevistoConta != 0.0f ? new Float(Funcoes.arredondar(this.valorRealizadoConta[posicao].floatValue() / this.valorPrevistoConta[posicao].floatValue() * 100.0f, 2)) : Float.valueOf(0.0f);
        }

        public void setValorConta(int reduzidoPlanoConta, float valorPrevistoConta, float valorRealizadoConta) {
            int i;
            for (i = 0; i < this.reduzidoPlanoConta.length; ++i) {
                if (this.reduzidoPlanoConta[i] == null || !this.reduzidoPlanoConta[i].equals(reduzidoPlanoConta)) continue;
                this.valorPrevistoConta[i] = Float.valueOf(valorPrevistoConta);
                this.valorRealizadoConta[i] = Float.valueOf(valorRealizadoConta);
                this.valorDiferencaConta[i] = Float.valueOf(valorPrevistoConta - valorRealizadoConta);
                this.percDiferencaConta[i] = valorPrevistoConta != 0.0f ? new Float(Funcoes.arredondar(this.valorRealizadoConta[i].floatValue() / this.valorPrevistoConta[i].floatValue() * 100.0f, 2)) : Float.valueOf(0.0f);
                return;
            }
            for (i = 0; i < this.reduzidoPlanoConta.length; ++i) {
                if (this.reduzidoPlanoConta[i] != null) continue;
                this.setContaValoresPosicao(i, reduzidoPlanoConta, valorPrevistoConta, valorRealizadoConta);
                return;
            }
        }

        public Float getValorPrevistoConta(int reduzidoPlanoConta) {
            for (int i = 0; i < this.reduzidoPlanoConta.length; ++i) {
                if (this.reduzidoPlanoConta[i] == null || this.reduzidoPlanoConta[i] != reduzidoPlanoConta) continue;
                return this.valorPrevistoConta[i];
            }
            return new Float(0.0f);
        }

        public Float getValorRealizadoConta(int reduzidoPlanoConta) {
            for (int i = 0; i < this.reduzidoPlanoConta.length; ++i) {
                if (this.reduzidoPlanoConta[i] == null || this.reduzidoPlanoConta[i] != reduzidoPlanoConta) continue;
                return this.valorRealizadoConta[i];
            }
            return new Float(0.0f);
        }

        public Float getValorDiferencaConta(int reduzidoPlanoConta) {
            for (int i = 0; i < this.reduzidoPlanoConta.length; ++i) {
                if (this.reduzidoPlanoConta[i] == null || this.reduzidoPlanoConta[i] != reduzidoPlanoConta) continue;
                return this.valorDiferencaConta[i];
            }
            return new Float(0.0f);
        }

        public Float getPercDiferencaConta(int reduzidoPlanoConta) {
            for (int i = 0; i < this.reduzidoPlanoConta.length; ++i) {
                if (this.reduzidoPlanoConta[i] == null || this.reduzidoPlanoConta[i] != reduzidoPlanoConta) continue;
                return this.percDiferencaConta[i];
            }
            return new Float(0.0f);
        }

        public void somaValorConta(int reduzidoPlanoConta, int reduzidoFilho) {
            this.setValorConta(reduzidoPlanoConta, this.getValorPrevistoConta(reduzidoPlanoConta).floatValue() + this.getValorPrevistoConta(reduzidoFilho).floatValue(), this.getValorRealizadoConta(reduzidoPlanoConta).floatValue() + this.getValorRealizadoConta(reduzidoFilho).floatValue());
        }

        public void somaValorConta(int reduzidoPlanoConta, float valorPrevistoAdicionar, float valorRealizadoAdicionar) {
            this.setValorConta(reduzidoPlanoConta, this.getValorPrevistoConta(reduzidoPlanoConta).floatValue() + valorPrevistoAdicionar, this.getValorRealizadoConta(reduzidoPlanoConta).floatValue() + valorRealizadoAdicionar);
        }

        public Integer getContaPosicao(int posicao) {
            return this.reduzidoPlanoConta[posicao];
        }

        public Float getValorPrevistoPosicao(int posicao) {
            return this.valorPrevistoConta[posicao];
        }

        public Float getValorRealizadoPosicao(int posicao) {
            return this.valorRealizadoConta[posicao];
        }

        public Float getValorDiferencaPosicao(int posicao) {
            return this.valorDiferencaConta[posicao];
        }

        public Float getPercDiferencaPosicao(int posicao) {
            return this.percDiferencaConta[posicao];
        }
    }
}

