/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.movimento;

import jalis.comum.Conexao;
import jalis.comum.ConstantesGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.laboratorio.util.FinanceiroUtil;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioPrevistoRealizadoCentroCusto
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String FILTRO_CENTRO_CUSTO = "filtroCentroCusto";
    private final String FILTRO_FILIAL_CENTRO_CUSTO = "filtroFilialCentroCusto";
    private final String FILTRO_USUARIO = "filtroUsuario";
    private final String FILTRO_ORIGEM = "filtroOrigem";
    private final String FILTRO_CAMPO_DATA = "filtroCampoData";
    private final String FILTRO_MES = "filtroMes";
    private final String FILTRO_ANO = "filtroAno";
    private final String FILTRO_DATA = "filtroData";
    private final String FILTRO_NIVEL = "filtroNivel";
    private final String[] MESES = ConstantesGerais.MESES_ANO;
    private final String[] CAMPOSDATA = new String[]{"Vencimento", "Cadastro", "Compet\u00eancia"};
    private final String[] CAMPOSDATABANCO = new String[]{"rpg.rpg_vencimento", "rpg.rpg_datahora", "rpg.rpg_competencia"};
    public static final int TIPO_DIARIO = 0;
    public static final int TIPO_MENSAL = 1;
    private int tipoRelatorio = 0;
    private static final String[] camposRelatorio = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"reduzidoCentroCusto", "descricaoCentroCusto", "contaCentroCusto", "nivelCentroCusto", "paiCentroCusto", "valorPrevisto", "valorRealizado", "valorDiferenca", "percDiferenca", "valorPrevistoComSinal", "valorRealizadoComSinal", "valorDiferencaComSinal", "totalPrevisto", "totalRealizado", "totalDiferenca"});

    public RelatorioPrevistoRealizadoCentroCusto(int tipoRelatorio) {
        this.tipoRelatorio = tipoRelatorio;
        if (this.tipoRelatorio == 0) {
            this.montaBarraDescricao("<html>Relat\u00f3rio previsto x realizado fluxo de caixa di\u00e1rio por <br>centro de custo</html>", "Previsto x Realizado di\u00e1rio por centro de custo", "relatorios/rel_financeiro_movimento_centro_custo_previstoXrealizado_caixa_diario_centro_custo.jpg");
        } else if (this.tipoRelatorio == 1) {
            this.montaBarraDescricao("<html>Relat\u00f3rio previsto x realizado fluxo de caixa mensal por <br>centro de custo</html>", "Previsto x Realizado mensal por centro de custo", "relatorios/rel_financeiro_movimento_centro_custo_previstoXrealizado_caixa_mensal_centro_custo.jpg");
        } else {
            Funcoes.mensagem(this, "Tipo de relat\u00f3rio incorreto.", 1);
            return;
        }
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilialCentroCusto", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroUsuario", "Usu\u00e1rio", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        int maxNivel = FinanceiroUtil.getQuantidadeNiveisCentroCusto();
        this.adicionaItemFiltro("filtroCentroCusto", "Centro Custo", "centrocusto", "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"ccu_reduzido", "ccu_conta", "ccu_descricao"}, new String[]{"C\u00f3digo", "Conta", "Descri\u00e7\u00e3o"}, new int[]{70, 120, 0});
        this.adicionaItemFiltro("filtroOrigem", "Origem", "origemplanocusto", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"opc_codigo", "opc_descricao", "opc_padrao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Padr\u00e3o"}, new int[]{70, 0, 50});
        Object[] arrayNiveis = new Integer[maxNivel];
        for (int i = 1; i <= maxNivel; ++i) {
            arrayNiveis[i - 1] = i;
        }
        this.adicionaFiltroCombo("filtroNivel", "N\u00edvel Centro", arrayNiveis, maxNivel - 1);
        this.adicionaFiltroCombo("filtroCampoData", "Campo Data:", this.CAMPOSDATA, 0);
        if (tipoRelatorio == 0) {
            this.adicionaFiltroData("filtroData", "Data:");
        } else {
            this.adicionaFiltroCombo("filtroMes", "M\u00eas:", this.MESES, Calendar.getInstance().get(2));
            this.adicionaFiltroNumero("filtroAno", "Ano:", 4);
        }
        this.setModuloConfigurar(this.getConfigurarAcesso(this.tipoRelatorio));
        this.setModuloAcesso(RelatorioPrevistoRealizadoCentroCusto.getModuloAcesso(this.tipoRelatorio));
        this.setCamposConfigurador(camposRelatorio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void imprimirPressionado() {
        String[] origem;
        Statement st = Conexao.getStatement();
        String[] filiais = this.getSelecionadosFiltro("filtroFilialCentroCusto", 0);
        if (filiais != null && filiais.length > 1) {
            Funcoes.mensagem(this, "Apenas uma filial deve ser selecionada para o relat\u00f3rio", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        if (this.tipoRelatorio == 0) {
            if (!Funcoes.verificaData(this.getFiltroData("filtroData"))) {
                Funcoes.mensagem(this, "Insira uma data para o relat\u00f3rio", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
        } else if (this.getFiltroNumero("filtroAno").equals("")) {
            Funcoes.mensagem(this, "Insira um ano para o relat\u00f3rio", 2);
            this.habilitaBotaoImprimir(true);
            return;
        }
        StringBuilder whereRpg = new StringBuilder();
        if (this.tipoRelatorio == 0) {
            if (!Funcoes.verificaData(this.getFiltroData("filtroData"))) {
                Funcoes.mensagem(this, "Insira um data v\u00e1lida para o relat\u00f3rio", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            whereRpg.append(" cast(" + this.CAMPOSDATABANCO[this.getFiltroComboIndice("filtroCampoData")] + " as date) = '");
            whereRpg.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroData")));
            whereRpg.append("' ");
        } else {
            if (this.getFiltroCombo("filtroMes").equals("")) {
                Funcoes.mensagem(this, "Escolha um m\u00eas para o relat\u00f3rio", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            String auxData = this.getFiltroComboIndice("filtroMes") + 1 + "/01/" + this.getFiltroNumero("filtroAno").toString();
            whereRpg.append(" cast(" + this.CAMPOSDATABANCO[this.getFiltroComboIndice("filtroCampoData")] + " as date) between '");
            whereRpg.append(auxData);
            whereRpg.append("' and ");
            whereRpg.append("date_trunc('month', to_timestamp('" + auxData + "', 'MM/dd/yyyy')) + interval '1 month' - interval '1 day' ");
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        String[] usuario = this.getSelecionadosFiltro("filtroUsuario", 0);
        if (usuario != null) {
            whereRpg.append(" and (rpg.usr_codigo in (");
            for (int i = 0; i < usuario.length; ++i) {
                whereRpg.append("'");
                whereRpg.append(usuario[i]);
                whereRpg.append("'");
                if (i >= usuario.length - 1) continue;
                whereRpg.append(", ");
            }
            whereRpg.append(") OR rpg.usr_codigo IS NULL)");
        }
        if ((origem = this.getSelecionadosFiltro("filtroOrigem", 0)) != null) {
            whereRpg.append(" and rcc.opc_codigo in (");
            for (int i = 0; i < origem.length; ++i) {
                whereRpg.append("'");
                whereRpg.append(origem[i]);
                whereRpg.append("'");
                if (i >= origem.length - 1) continue;
                whereRpg.append(", ");
            }
            whereRpg.append(")");
        }
        try {
            StringBuilder bufRpg = new StringBuilder();
            StringBuilder bufLcx = new StringBuilder();
            StringBuilder bufWhere = new StringBuilder();
            bufRpg.append(" select ");
            bufRpg.append(" \t\t\t a.fil_codigo      ");
            bufRpg.append(" \t\t\t,a.ccu_reduzido    ");
            bufRpg.append("       ,a.ccu_conta\t\t\t ");
            bufRpg.append("       ,a.ccu_descricao   ");
            bufRpg.append("       ,a.ccu_nivel\t\t   ");
            bufRpg.append("       ,a.ccu_pai\t\t\t   ");
            bufRpg.append("       ,a.ccu_operacao\t\t ");
            bufRpg.append("       ,COALESCE(SUM(CASE WHEN rpg.rcc_valor IS NULL THEN 0 ELSE rpg.rcc_valor END), 0) as valorPrevisto ");
            bufRpg.append("       ,0 as valorRealizado ");
            bufRpg.append("   from CentroCusto a ");
            bufRpg.append("   left join (select rpg.rpg_codigo ");
            bufRpg.append("                    ,rpg.fil_codigo ");
            bufRpg.append("                    ,rcc.ccu_reduzido ");
            bufRpg.append("                    ,rcc.rcc_valor ");
            bufRpg.append("   from receberpagar rpg ");
            bufRpg.append("   join (select rcc.ccu_reduzido ");
            bufRpg.append("               ,rcc.fil_codigo ");
            bufRpg.append("               ,rcc.rcc_valor ");
            bufRpg.append("               ,rcc.rpg_codigo ");
            bufRpg.append("               ,rcc.opc_codigo ");
            bufRpg.append("           from receberpagarCentroCusto rcc) rcc on (rpg.rpg_codigo = rcc.rpg_codigo and rpg.fil_codigo = rcc.fil_codigo) ");
            bufRpg.append("  where ");
            bufRpg.append((CharSequence)whereRpg);
            bufRpg.append("    and rpg.rpg_situacao IN ('").append("A").append("', '").append("Q").append("', '");
            bufRpg.append("V").append("', '").append("T").append("', '").append("S").append("') ");
            bufRpg.append("             ) rpg ");
            bufRpg.append("     on (a.ccu_reduzido = rpg.ccu_reduzido and a.fil_codigo = rpg.fil_codigo) ");
            bufLcx.append(" select ");
            bufLcx.append(" \t\t\t a.fil_codigo     \t");
            bufLcx.append(" \t\t\t,a.ccu_reduzido   \t");
            bufLcx.append("       ,a.ccu_conta\t\t\t\t");
            bufLcx.append("       ,a.ccu_descricao  \t");
            bufLcx.append("       ,a.ccu_nivel\t\t  \t");
            bufLcx.append("       ,a.ccu_pai\t\t\t  \t");
            bufLcx.append("       ,a.ccu_operacao\t\t\t");
            bufLcx.append("       ,0 as valorPrevisto ");
            bufLcx.append("       ,SUM(CASE WHEN lcx.lcc_valor IS NULL THEN 0 ELSE lcx.lcc_valor END) as valorRealizado ");
            bufLcx.append("   from CentroCusto a ");
            bufLcx.append("   left join (select lcx.lcx_codigo ");
            bufLcx.append("                    ,lcx.fil_codigo ");
            bufLcx.append("                    ,lcc.ccu_reduzido ");
            bufLcx.append("                    ,lcc.lcc_valor ");
            bufLcx.append("   from lanctocaixa lcx ");
            bufLcx.append("   join (select lcc.ccu_reduzido ");
            bufLcx.append("               ,lcc.fil_codigo ");
            bufLcx.append("               ,lcc.lcc_valor ");
            bufLcx.append("               ,lcc.lcx_codigo ");
            bufLcx.append("               ,lcc.est_codigo ");
            bufLcx.append("               ,lcc.opc_codigo ");
            bufLcx.append("           from lanctocaixaCentroCusto lcc) lcc on (lcx.lcx_codigo = lcc.lcx_codigo and lcx.fil_codigo = lcc.fil_codigo and lcx.est_codigo = lcc.est_codigo) ");
            bufLcx.append("  where ");
            bufLcx.append(whereRpg.toString().replaceAll("rpg", "lcx").replaceAll("rcc", "lcc"));
            bufLcx.append("    and lcx.lcx_situacao <> '").append("C").append("' ");
            bufLcx.append("             ) lcx ");
            bufLcx.append("     on (a.ccu_reduzido = lcx.ccu_reduzido and a.fil_codigo = lcx.fil_codigo) ");
            bufWhere.append("where a.fil_codigo ");
            if (filiais == null || filiais.length == 0) {
                bufWhere.append(" = ").append(Variaveis.filialPadrao);
            } else {
                bufWhere.append(" in (");
                for (int i = 0; i < filiais.length; ++i) {
                    bufWhere.append(filiais[i]);
                    if (i >= filiais.length - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            int maiorNivel = 0;
            ResultSet rs = null;
            try {
                rs = Conexao.executeQuery(st, "select MAX(a.ccu_nivel) as maiorNivel from CentroCusto a");
                rs.next();
                maiorNivel = rs.getInt("maiorNivel");
            }
            catch (Exception ex) {
                maiorNivel = 0;
            }
            String[] centrocusto = this.getSelecionadosFiltro("filtroCentroCusto", 0);
            if (centrocusto != null) {
                int i;
                bufWhere.append(" and a.ccu_reduzido in (");
                ArrayList<Integer> arrayAux = new ArrayList<Integer>();
                for (int i2 = 0; i2 < centrocusto.length; ++i2) {
                    arrayAux.add(new Integer(centrocusto[i2]));
                }
                ArrayList<Integer> arrayAcima = this.getCentrosAcima((ArrayList)arrayAux.clone());
                ArrayList<Integer> arrayAbaixo = this.getCentrosAbaixo((ArrayList)arrayAux.clone());
                if (arrayAcima != null) {
                    for (i = 0; i < arrayAcima.size(); ++i) {
                        if (arrayAux.contains(arrayAcima.get(i))) continue;
                        arrayAux.add(arrayAcima.get(i));
                    }
                }
                if (arrayAbaixo != null) {
                    for (i = 0; i < arrayAbaixo.size(); ++i) {
                        if (arrayAux.contains(arrayAbaixo.get(i))) continue;
                        arrayAux.add(arrayAbaixo.get(i));
                    }
                }
                for (i = 0; i < arrayAux.size(); ++i) {
                    bufWhere.append(arrayAux.get(i));
                    if (i >= arrayAux.size() - 1) continue;
                    bufWhere.append(", ");
                }
                bufWhere.append(")");
            }
            StringBuilder bufOrder = new StringBuilder();
            bufOrder.append("  group by a.ccu_reduzido  ");
            bufOrder.append("          ,a.ccu_conta     ");
            bufOrder.append("          ,a.ccu_descricao ");
            bufOrder.append("\t\t\t\t\t ,a.ccu_nivel     ");
            bufOrder.append("\t\t\t\t\t ,a.ccu_pai       ");
            bufOrder.append("\t\t\t\t\t ,a.ccu_operacao  ");
            bufOrder.append("\t\t\t\t\t ,a.fil_codigo    ");
            bufOrder.append("\t\t\t\t\t , ");
            for (int i = 0; i < Constantes.CAMPOS_FILIAL.length; ++i) {
                if (i > 0) {
                    bufOrder.append(", ");
                }
                bufOrder.append(Constantes.CAMPOS_FILIAL[i]);
            }
            bufOrder.append("  order by a.ccu_conta ");
            StringBuilder bufSql = new StringBuilder();
            bufSql.append(" SELECT a.ccu_reduzido  \t\t as reduzidoCentroCusto ");
            bufSql.append("       ,a.ccu_conta\t\t \t\t as contaCentroCusto ");
            bufSql.append("       ,a.ccu_descricao \t\t as descricaoCentroCusto ");
            bufSql.append(" \t\t\t,a.ccu_nivel\t\t \t\t as nivelCentroCusto ");
            bufSql.append(" \t\t\t,a.ccu_pai\t\t\t \t\t as paiCentroCusto ");
            bufSql.append(" \t\t\t,a.ccu_operacao\t \t\t as operacaoCentroCusto ");
            bufSql.append("       ,SUM(valorPrevisto)  as valorPrevisto ");
            bufSql.append("       ,SUM(valorRealizado) as valorRealizado ");
            bufSql.append("       ,");
            bufSql.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            bufSql.append("  FROM ( ");
            bufSql.append(" ( ");
            bufSql.append((CharSequence)bufRpg);
            bufSql.append((CharSequence)bufWhere);
            bufSql.append("  group by a.ccu_reduzido  ");
            bufSql.append("          ,a.ccu_conta     ");
            bufSql.append("          ,a.ccu_descricao ");
            bufSql.append("          ,a.ccu_nivel \t\t");
            bufSql.append("          ,a.ccu_pai \t\t\t");
            bufSql.append("          ,a.ccu_operacao  ");
            bufSql.append("          ,a.fil_codigo    ");
            bufSql.append(" ) ");
            bufSql.append(" UNION ");
            bufSql.append(" ( ");
            bufSql.append((CharSequence)bufLcx);
            bufSql.append((CharSequence)bufWhere);
            bufSql.append("  group by a.ccu_reduzido  ");
            bufSql.append("          ,a.ccu_conta     ");
            bufSql.append("          ,a.ccu_descricao ");
            bufSql.append("          ,a.ccu_nivel \t\t");
            bufSql.append("          ,a.ccu_pai \t\t\t");
            bufSql.append("          ,a.ccu_operacao  ");
            bufSql.append("          ,a.fil_codigo    ");
            bufSql.append(" ) ");
            bufSql.append(" ) as a ");
            bufSql.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            bufSql.append((CharSequence)bufOrder);
            rs = Conexao.executeQuery(st, bufSql.toString());
            arrayValoresCentroCusto arrayContas = null;
            if (rs.next()) {
                int nivel;
                int i;
                maiorNivel = 0;
                rs.last();
                int qtdeLinhas = rs.getRow();
                arrayContas = new arrayValoresCentroCusto(qtdeLinhas);
                rs.first();
                do {
                    if (rs.getInt("nivelCentroCusto") <= maiorNivel) continue;
                    maiorNivel = rs.getInt("nivelCentroCusto");
                } while (rs.next());
                for (i = nivel = Integer.parseInt(this.getFiltroCombo("filtroNivel").toString()); i > 0; --i) {
                    rs.first();
                    do {
                        if (rs.getInt("nivelCentroCusto") > i) continue;
                        arrayContas.somaValorConta(rs.getInt("reduzidoCentroCusto"), rs.getFloat("valorPrevisto"), rs.getFloat("valorRealizado"));
                        if (rs.getInt("paiCentroCusto") < 0 || i > Integer.parseInt(this.getFiltroCombo("filtroNivel").toString())) continue;
                        arrayContas.somaValorConta(rs.getInt("paiCentroCusto"), rs.getInt("reduzidoCentroCusto"));
                    } while (rs.next());
                }
                for (i = maiorNivel; i > Integer.parseInt(this.getFiltroCombo("filtroNivel").toString()); --i) {
                    rs.first();
                    do {
                        if (rs.getInt("nivelCentroCusto") < i) continue;
                        arrayContas.somaValorConta(rs.getInt("reduzidoCentroCusto"), rs.getFloat("valorPrevisto"), rs.getFloat("valorRealizado"));
                        if (rs.getInt("paiCentroCusto") < 0 || i < Integer.parseInt(this.getFiltroCombo("filtroNivel").toString())) continue;
                        arrayContas.somaValorConta(rs.getInt("paiCentroCusto"), rs.getInt("reduzidoCentroCusto"));
                    } while (rs.next());
                }
            }
            rs.first();
            int posCampoReduzidoRelatorio = 0;
            for (int i = 0; i < camposRelatorio.length; ++i) {
                if (!camposRelatorio[i].equals("reduzidoCentroCusto")) continue;
                posCampoReduzidoRelatorio = i;
                break;
            }
            rs.beforeFirst();
            ModeloGridTable modelo = new ModeloGridTable(camposRelatorio);
            while (true) {
                Object[] o;
                if (rs.next()) {
                    if (rs.getInt("nivelCentroCusto") > Integer.parseInt(this.getFiltroCombo("filtroNivel").toString())) continue;
                    o = new Object[camposRelatorio.length];
                } else {
                    if (modelo.getColumnCount() > 0) {
                        StringBuilder buf = new StringBuilder();
                        buf.delete(0, buf.length());
                        buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                        if (this.tipoRelatorio == 0) {
                            buf.append(RelatorioPrevistoRealizadoCentroCusto.getModuloAcesso(0));
                        } else {
                            buf.append(RelatorioPrevistoRealizadoCentroCusto.getModuloAcesso(1));
                        }
                        rs = Conexao.executeQuery(st, buf.toString());
                        if (rs.next()) {
                            int i;
                            Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                            gerador.setPai(this.panelCentro);
                            gerador.setPreVisualizar(true);
                            gerador.setZoomPreVisualizar(1.0f);
                            gerador.setAcaoFechar(new Runnable(){

                                @Override
                                public void run() {
                                    RelatorioPrevistoRealizadoCentroCusto.this.panelCentro.removeAll();
                                    RelatorioPrevistoRealizadoCentroCusto.this.panelCentro.repaint();
                                    RelatorioPrevistoRealizadoCentroCusto.this.habilitaBotaoImprimir(true);
                                }
                            });
                            HashMap<String, Object> var = new HashMap<String, Object>();
                            var.put("filtroData", this.getFiltroData("filtroData"));
                            var.put("filtroMes", this.getFiltroCombo("filtroMes"));
                            var.put("filtroAno", this.getFiltroData("filtroAno"));
                            var.put("filtroCampoData", this.getFiltroCombo("filtroCampoData"));
                            var.put("filtroNivel", this.getFiltroCombo("filtroNivel"));
                            buf.delete(0, buf.length());
                            if (filiais != null) {
                                for (i = 0; i < filiais.length; ++i) {
                                    buf.append(filiais[i]);
                                    if (i >= filiais.length - 1) continue;
                                    buf.append(", ");
                                }
                            }
                            var.put("filtroFilialCentroCusto", Funcoes.textoVazio(buf.toString()) ? Variaveis.filialPadrao : buf.toString());
                            buf.delete(0, buf.length());
                            if (usuario != null) {
                                for (i = 0; i < usuario.length; ++i) {
                                    buf.append(usuario[i]);
                                    if (i >= usuario.length - 1) continue;
                                    buf.append(", ");
                                }
                            }
                            var.put("filtroUsuario", buf.toString());
                            buf.delete(0, buf.length());
                            if (centrocusto != null) {
                                for (i = 0; i < centrocusto.length; ++i) {
                                    buf.append(centrocusto[i]);
                                    if (i >= centrocusto.length - 1) continue;
                                    buf.append(", ");
                                }
                            }
                            var.put("filtroCentroCusto", buf.toString());
                            buf.delete(0, buf.length());
                            if (origem != null) {
                                for (i = 0; i < origem.length; ++i) {
                                    buf.append(origem[i]);
                                    if (i >= origem.length - 1) continue;
                                    buf.append(", ");
                                }
                            }
                            var.put("filtroOrigem", buf.toString());
                            gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                            this.panelCentro.revalidate();
                        }
                    } else {
                        Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                        this.habilitaBotaoImprimir(true);
                    }
                    Conexao.fecharStatement(st);
                    break;
                }
                for (int i = 0; i < camposRelatorio.length; ++i) {
                    Float aux;
                    if (camposRelatorio[i].equals("valorPrevisto")) {
                        if (arrayContas == null) continue;
                        o[modelo.findColumn((String)RelatorioPrevistoRealizadoCentroCusto.camposRelatorio[i])] = arrayContas.getValorPrevistoConta(rs.getInt(camposRelatorio[posCampoReduzidoRelatorio]));
                        continue;
                    }
                    if (camposRelatorio[i].equals("valorRealizado")) {
                        if (arrayContas == null) continue;
                        o[modelo.findColumn((String)RelatorioPrevistoRealizadoCentroCusto.camposRelatorio[i])] = arrayContas.getValorRealizadoConta(rs.getInt(camposRelatorio[posCampoReduzidoRelatorio]));
                        continue;
                    }
                    if (camposRelatorio[i].equals("valorDiferenca")) {
                        if (arrayContas == null) continue;
                        o[modelo.findColumn((String)RelatorioPrevistoRealizadoCentroCusto.camposRelatorio[i])] = arrayContas.getValorDiferencaConta(rs.getInt(camposRelatorio[posCampoReduzidoRelatorio]));
                        continue;
                    }
                    if (camposRelatorio[i].equals("totalPrevisto")) {
                        if (arrayContas == null || rs.getInt("nivelCentroCusto") != 1) continue;
                        o[modelo.findColumn((String)RelatorioPrevistoRealizadoCentroCusto.camposRelatorio[i])] = arrayContas.getValorDiferencaConta(rs.getInt(camposRelatorio[posCampoReduzidoRelatorio]));
                        continue;
                    }
                    if (camposRelatorio[i].equals("totalRealizado")) {
                        if (arrayContas == null || rs.getInt("nivelCentroCusto") != 1) continue;
                        o[modelo.findColumn((String)RelatorioPrevistoRealizadoCentroCusto.camposRelatorio[i])] = arrayContas.getValorDiferencaConta(rs.getInt(camposRelatorio[posCampoReduzidoRelatorio]));
                        continue;
                    }
                    if (camposRelatorio[i].equals("totalDiferenca")) {
                        if (arrayContas == null || rs.getInt("nivelCentroCusto") != 1) continue;
                        o[modelo.findColumn((String)RelatorioPrevistoRealizadoCentroCusto.camposRelatorio[i])] = arrayContas.getValorDiferencaConta(rs.getInt(camposRelatorio[posCampoReduzidoRelatorio]));
                        continue;
                    }
                    if (camposRelatorio[i].equals("valorPrevistoComSinal")) {
                        aux = new Float(0.0f);
                        if (arrayContas != null) {
                            aux = arrayContas.getValorPrevistoConta(rs.getInt(camposRelatorio[posCampoReduzidoRelatorio]));
                        }
                        if (rs.getString("operacaoCentroCusto") != null && rs.getString("operacaoCentroCusto").equalsIgnoreCase("A")) {
                            o[modelo.findColumn((String)RelatorioPrevistoRealizadoCentroCusto.camposRelatorio[i])] = aux;
                            continue;
                        }
                        if (aux.floatValue() != 0.0f) {
                            o[modelo.findColumn((String)RelatorioPrevistoRealizadoCentroCusto.camposRelatorio[i])] = Float.valueOf(aux.floatValue() * -1.0f);
                            continue;
                        }
                        o[modelo.findColumn((String)RelatorioPrevistoRealizadoCentroCusto.camposRelatorio[i])] = aux;
                        continue;
                    }
                    if (camposRelatorio[i].equals("valorRealizadoComSinal")) {
                        aux = new Float(0.0f);
                        if (arrayContas != null) {
                            aux = arrayContas.getValorRealizadoConta(rs.getInt(camposRelatorio[posCampoReduzidoRelatorio]));
                        }
                        if (rs.getString("operacaoCentroCusto") != null && rs.getString("operacaoCentroCusto").equalsIgnoreCase("A")) {
                            o[modelo.findColumn((String)RelatorioPrevistoRealizadoCentroCusto.camposRelatorio[i])] = aux;
                            continue;
                        }
                        if (aux.floatValue() != 0.0f) {
                            o[modelo.findColumn((String)RelatorioPrevistoRealizadoCentroCusto.camposRelatorio[i])] = Float.valueOf(aux.floatValue() * -1.0f);
                            continue;
                        }
                        o[modelo.findColumn((String)RelatorioPrevistoRealizadoCentroCusto.camposRelatorio[i])] = aux;
                        continue;
                    }
                    if (camposRelatorio[i].equals("valorDiferencaComSinal")) {
                        aux = new Float(0.0f);
                        if (arrayContas != null) {
                            aux = arrayContas.getValorDiferencaConta(rs.getInt(camposRelatorio[posCampoReduzidoRelatorio]));
                        }
                        if (rs.getString("operacaoCentroCusto") != null && rs.getString("operacaoCentroCusto").equalsIgnoreCase("A")) {
                            o[modelo.findColumn((String)RelatorioPrevistoRealizadoCentroCusto.camposRelatorio[i])] = aux;
                            continue;
                        }
                        if (aux.floatValue() != 0.0f) {
                            o[modelo.findColumn((String)RelatorioPrevistoRealizadoCentroCusto.camposRelatorio[i])] = Float.valueOf(aux.floatValue() * -1.0f);
                            continue;
                        }
                        o[modelo.findColumn((String)RelatorioPrevistoRealizadoCentroCusto.camposRelatorio[i])] = aux;
                        continue;
                    }
                    if (camposRelatorio[i].equals("percDiferenca")) {
                        if (arrayContas == null) continue;
                        o[modelo.findColumn((String)RelatorioPrevistoRealizadoCentroCusto.camposRelatorio[i])] = arrayContas.getPercDiferencaConta(rs.getInt(camposRelatorio[posCampoReduzidoRelatorio]));
                        continue;
                    }
                    if (camposRelatorio[i].equals("tipoLancamento")) {
                        if (rs.getString(camposRelatorio[i]) != null) {
                            o[modelo.findColumn((String)RelatorioPrevistoRealizadoCentroCusto.camposRelatorio[i])] = Tipos.tipoLancamentoCaixa(rs.getString(camposRelatorio[i]));
                            continue;
                        }
                        o[modelo.findColumn((String)RelatorioPrevistoRealizadoCentroCusto.camposRelatorio[i])] = null;
                        continue;
                    }
                    o[modelo.findColumn((String)RelatorioPrevistoRealizadoCentroCusto.camposRelatorio[i])] = rs.getObject(camposRelatorio[i]);
                }
                modelo.addLine(o);
            }
        }
        catch (Exception ex) {
            try {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso(int tipoRelatorio) {
        if (tipoRelatorio == 0) {
            return Long.parseLong("0850920100");
        }
        if (tipoRelatorio == 1) {
            return Long.parseLong("0850920200");
        }
        return Long.parseLong("0850920100");
    }

    public long getConfigurarAcesso(int tipoRelatorio) {
        if (tipoRelatorio == 0) {
            return Long.parseLong("0850920101");
        }
        if (tipoRelatorio == 1) {
            return Long.parseLong("0850920201");
        }
        return Long.parseLong("0850920101");
    }

    private ArrayList<Integer> getCentrosAcima(ArrayList<Integer> planos) {
        Statement st = Conexao.getStatement();
        ArrayList<Integer> resultado = new ArrayList<Integer>();
        StringBuilder planosSql = null;
        StringBuilder buf = null;
        while (planos != null) {
            planosSql = new StringBuilder();
            for (int i = 0; i < planos.size() && planos != null; ++i) {
                planosSql.append(planos.get(i));
                if (i >= planos.size() - 1) continue;
                planosSql.append(", ");
            }
            buf = new StringBuilder();
            buf.append(" select ccu_pai ");
            buf.append("   from centrocusto ");
            buf.append("  where ccu_reduzido IN (").append((CharSequence)planosSql).append(") ");
            buf.append("    and fil_codigo = ").append(Variaveis.filialPadrao);
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (planos != null) {
                    planos.clear();
                }
                if (rs.next()) {
                    do {
                        if (rs.getString("ccu_pai") == null || resultado.contains(rs.getInt("ccu_pai"))) continue;
                        resultado.add(rs.getInt("ccu_pai"));
                        if (planos == null) continue;
                        planos.add(rs.getInt("ccu_pai"));
                    } while (rs.next());
                } else {
                    planos = null;
                }
            }
            catch (SQLException e) {
                break;
            }
            if (planos == null || planos.size() != 0) continue;
            planos = null;
        }
        Conexao.fecharStatement(st);
        if (resultado.size() == 0) {
            return null;
        }
        return resultado;
    }

    private ArrayList<Integer> getCentrosAbaixo(ArrayList<Integer> planos) {
        Statement st = Conexao.getStatement();
        ArrayList<Integer> resultado = new ArrayList<Integer>();
        StringBuilder planosSql = null;
        StringBuilder buf = null;
        while (planos != null) {
            planosSql = new StringBuilder();
            for (int i = 0; i < planos.size() && planos != null; ++i) {
                planosSql.append(planos.get(i));
                if (i >= planos.size() - 1) continue;
                planosSql.append(", ");
            }
            buf = new StringBuilder();
            buf.append(" select ccu_reduzido ");
            buf.append("   from centrocusto ");
            buf.append("  where ccu_pai IN (").append((CharSequence)planosSql).append(") ");
            buf.append("    and fil_codigo = ").append(Variaveis.filialPadrao);
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (planos != null) {
                    planos.clear();
                }
                if (rs.next()) {
                    do {
                        if (rs.getString("ccu_reduzido") == null || resultado.contains(rs.getInt("ccu_reduzido"))) continue;
                        resultado.add(rs.getInt("ccu_reduzido"));
                        if (planos == null) continue;
                        planos.add(rs.getInt("ccu_reduzido"));
                    } while (rs.next());
                } else {
                    planos = null;
                }
            }
            catch (SQLException e) {
                break;
            }
            if (planos == null || planos.size() != 0) continue;
            planos = null;
        }
        Conexao.fecharStatement(st);
        if (resultado.size() == 0) {
            return null;
        }
        return resultado;
    }

    public class arrayValoresCentroCusto {
        private Integer[] reduzidoCentroCusto = null;
        private Float[] valorPrevistoConta = null;
        private Float[] valorRealizadoConta = null;
        private Float[] valorDiferencaConta = null;
        private Float[] percDiferencaConta = null;

        public arrayValoresCentroCusto(Integer tamanho) {
            this.reduzidoCentroCusto = new Integer[tamanho.intValue()];
            this.valorPrevistoConta = new Float[tamanho.intValue()];
            this.valorRealizadoConta = new Float[tamanho.intValue()];
            this.valorDiferencaConta = new Float[tamanho.intValue()];
            this.percDiferencaConta = new Float[tamanho.intValue()];
        }

        public void setContaValoresPosicao(int posicao, int reduzidoCentroCusto, float valorPrevistoConta, float valorRealizadoConta) {
            this.reduzidoCentroCusto[posicao] = reduzidoCentroCusto;
            this.valorPrevistoConta[posicao] = Float.valueOf(valorPrevistoConta);
            this.valorRealizadoConta[posicao] = Float.valueOf(valorRealizadoConta);
            this.valorDiferencaConta[posicao] = Float.valueOf(valorPrevistoConta - valorRealizadoConta);
            this.percDiferencaConta[posicao] = valorPrevistoConta != 0.0f ? new Float(Funcoes.arredondar(this.valorDiferencaConta[posicao].floatValue() / this.valorPrevistoConta[posicao].floatValue() * 100.0f, 2)) : Float.valueOf(0.0f);
        }

        public void setValorConta(int reduzidoCentroCusto, float valorPrevistoConta, float valorRealizadoConta) {
            int i;
            for (i = 0; i < this.reduzidoCentroCusto.length; ++i) {
                if (this.reduzidoCentroCusto[i] == null || !this.reduzidoCentroCusto[i].equals(reduzidoCentroCusto)) continue;
                this.valorPrevistoConta[i] = Float.valueOf(valorPrevistoConta);
                this.valorRealizadoConta[i] = Float.valueOf(valorRealizadoConta);
                this.valorDiferencaConta[i] = Float.valueOf(valorPrevistoConta - valorRealizadoConta);
                this.percDiferencaConta[i] = valorPrevistoConta != 0.0f ? new Float(Funcoes.arredondar(this.valorDiferencaConta[i].floatValue() / this.valorPrevistoConta[i].floatValue() * 100.0f, 2)) : Float.valueOf(0.0f);
                return;
            }
            for (i = 0; i < this.reduzidoCentroCusto.length; ++i) {
                if (this.reduzidoCentroCusto[i] != null) continue;
                this.setContaValoresPosicao(i, reduzidoCentroCusto, valorPrevistoConta, valorRealizadoConta);
                return;
            }
        }

        public Float getValorPrevistoConta(int reduzidoCentroCusto) {
            for (int i = 0; i < this.reduzidoCentroCusto.length; ++i) {
                if (this.reduzidoCentroCusto[i] == null || this.reduzidoCentroCusto[i] != reduzidoCentroCusto) continue;
                return this.valorPrevistoConta[i];
            }
            return new Float(0.0f);
        }

        public Float getValorRealizadoConta(int reduzidoCentroCusto) {
            for (int i = 0; i < this.reduzidoCentroCusto.length; ++i) {
                if (this.reduzidoCentroCusto[i] == null || this.reduzidoCentroCusto[i] != reduzidoCentroCusto) continue;
                return this.valorRealizadoConta[i];
            }
            return new Float(0.0f);
        }

        public Float getValorDiferencaConta(int reduzidoCentroCusto) {
            for (int i = 0; i < this.reduzidoCentroCusto.length; ++i) {
                if (this.reduzidoCentroCusto[i] == null || this.reduzidoCentroCusto[i] != reduzidoCentroCusto) continue;
                return this.valorDiferencaConta[i];
            }
            return new Float(0.0f);
        }

        public Float getPercDiferencaConta(int reduzidoCentroCusto) {
            for (int i = 0; i < this.reduzidoCentroCusto.length; ++i) {
                if (this.reduzidoCentroCusto[i] == null || this.reduzidoCentroCusto[i] != reduzidoCentroCusto) continue;
                return this.percDiferencaConta[i];
            }
            return new Float(0.0f);
        }

        public void somaValorConta(int reduzidoCentroCusto, int reduzidoFilho) {
            this.setValorConta(reduzidoCentroCusto, this.getValorPrevistoConta(reduzidoCentroCusto).floatValue() + this.getValorPrevistoConta(reduzidoFilho).floatValue(), this.getValorRealizadoConta(reduzidoCentroCusto).floatValue() + this.getValorRealizadoConta(reduzidoFilho).floatValue());
        }

        public void somaValorConta(int reduzidoCentroCusto, float valorPrevistoAdicionar, float valorRealizadoAdicionar) {
            this.setValorConta(reduzidoCentroCusto, this.getValorPrevistoConta(reduzidoCentroCusto).floatValue() + valorPrevistoAdicionar, this.getValorRealizadoConta(reduzidoCentroCusto).floatValue() + valorRealizadoAdicionar);
        }

        public Integer getContaPosicao(int posicao) {
            return this.reduzidoCentroCusto[posicao];
        }

        public Float getValorPrevistoPosicao(int posicao) {
            return this.valorPrevistoConta[posicao];
        }

        public Float getValorRealizadoPosicao(int posicao) {
            return this.valorRealizadoConta[posicao];
        }

        public Float getValorDiferencaPosicao(int posicao) {
            return this.valorDiferencaConta[posicao];
        }

        public Float getPercDiferencaPosicao(int posicao) {
            return this.percDiferencaConta[posicao];
        }
    }
}

