/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.movimento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioPrevisaoSaldo
extends FrmRelPadrao {
    private final String FILTRO_CONTA = "filtroConta";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_RECEBER_PAGAR = "filtroReceberPagar";
    private final String[] tipo = new String[]{"Todos", Tipos.tipoReceberPagar("P"), Tipos.tipoReceberPagar("R")};
    private final String[] camposSaldo = new String[]{"dataSaldo", "codigoContaCorrente", "contaCorrente", "saldoConta", "totalSaldo", "titularContaCorrente", "tipoContaCorrente", "codigoBanco", "descricaoBanco", "codigoAgencia", "descricaoAgencia"};
    private final String[] camposRelatorio = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoCadastro", "fantasiaCadastro", "razaoSocialCadastro", "foneCadastro", "enderecoCadastro", "numeroEnderecoCadastro", "tipoLogradouroCadastro", "faxCadastro", "complementoCadastro", "cepCadastro", "codigoCidadeCadastro", "nomeCidadeCadastro", "saldoParcial", "codigoReceberPagar", "dataHoraReceberPagar", "dataVencimentoReceberPagar", "valorReceberPagar", "tipoJurosReceberPagar", "tipoReceberPagar", "tipoDocumentoReceberPagar", "numeroDocumentoReceberPagar", "valorTaxaReceberPagar", "numeroParcelaReceberPagar", "codigoDocumentoReceberPagar", "dataDocumentoReceberPagar", "dataProcessamentoReceberPagar", "observacaoReceberPagar", "tipoCadastroReceberPagar", "codigoUsuarioReceberPagar", "nomeUsuarioReceberPagar", "codigoUsuarioCancelamentoReceberPagar", "nomeUsuarioCancelamentoReceberPagar", "dataCancelamentoReceberPagar", "situacaoReceberPagar", "valorJuroReceberPagar", "valorMultaReceberPagar", "valorComTaxaReceberPagar", "valorAcrescimoReceberPagar", "valorDescontoReceberPagar", "percentualMultaReceberPagar", "percentualJuroReceberPagar", "percentualAcrescimoReceberPagar", "percentualAcrescimoReceberPagar", "codigoSerie", "descricaoSerie", "valorIrrfReceberPagar", "percentualIrrfReceberPagar", "valorIssReceberPagar", "percentualIssReceberPagar", "valorPisReceberPagar", "percentualPisReceberPagar", "valorCsllReceberPagar", "percentualCsllReceberPagar", "valorCofinsReceberPagar", "percentualCofinsReceberPagar", "valorInssReceberPagar", "percentualInssReceberPagar", "dataCompetenciaReceberPagar", "valorImpostosReceberPagar", "valorTaxaTotalReceberPagar", "valorImpostosReceberPagarComSinal", "valorTaxaTotalReceberPagarComSinal", "valorDescontoReceberPagarComSinal", "numeroNotaFiscal", "situacaoNotaFiscal", "serieNotaFiscal", "descricaoFormaPgto", "valorTotalReceber", "valorTotalPagar", "valorIpiReceberPagar", "valorIcmsReceberPagar", "percentualIpiReceberPagar", "percentualIcmsReceberPagar", "valorReceber", "valorPagar", "somatorioReceber", "somatorioPagar", "saldoContas"});
    private final String[] campos = ArraysUtil.concatenar(this.camposRelatorio, this.camposSaldo);

    public RelatorioPrevisaoSaldo() {
        this.montaBarraDescricao("Relat\u00f3rio Previs\u00e3o de Saldo", "Listagem da previs\u00e3o de saldo de conta no per\u00edodo", "relatorios/rel_previsao_saldo.jpg");
        this.adicionaItemFiltro("filtroConta", "Conta Corrente:", "contacorrente", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"cco_reduzido", "cco_conta", "cco_titular"}, new String[]{"Reduzido", "Conta", "Titular"}, new int[]{70, 130, 0}, new int[]{0, 1, 2}, 1);
        this.adicionaFiltroData("filtroDataInicial", "Data Inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data Final:");
        this.adicionaFiltroCombo("filtroReceberPagar", "Tipo:", this.tipo, 0);
        this.adicionaRelatorioListener(this);
        this.setCamposConfigurador(this.campos);
        this.setModuloAcesso(RelatorioPrevisaoSaldo.getModuloAcesso());
        this.setModuloConfigurar(RelatorioPrevisaoSaldo.getModuloConfigurar());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        block47: {
            String[] contas = this.getSelecionadosFiltro("filtroConta", 0);
            if (contas == null || contas.length == 0) {
                Funcoes.mensagem(this, "Pelo menos uma conta deve ser selecionada para o relat\u00f3rio", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            if (!Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                Funcoes.mensagem(this, "Data inicial inv\u00e1lida", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            if (!Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                Funcoes.mensagem(this, "Data final inv\u00e1lida", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            StringBuilder buf = new StringBuilder();
            Statement st = Conexao.getStatement();
            Statement st2 = Conexao.getStatement();
            ResultSet rs = null;
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                buf.append("SELECT a.rpg_valor AS valorReceberPagar, ");
                buf.append("a.rpg_taxa AS valorTaxaReceberPagar, ");
                buf.append("case when a.rpg_tipo = '").append("R").append("' then a.rpg_valortotal else 0 end AS valorTotalReceber, ");
                buf.append("case when a.rpg_tipo = '").append("P").append("' then a.rpg_valortotal else 0 end AS valorTotalPagar, ");
                buf.append("a.rpg_valoracrescimo AS valorAcrescimoReceberPagar, ");
                buf.append("Coalesce(a.rpg_valordesconto, 0) AS valorDescontoReceberPagar, ");
                buf.append("a.rpg_codigo AS codigoReceberPagar, ");
                buf.append("a.rpg_datahora AS dataHoraReceberPagar, ");
                buf.append("a.rpg_vencimento AS dataVencimentoReceberPagar, ");
                buf.append("a.rpg_competencia AS dataCompetenciaReceberPagar, ");
                buf.append("a.rpg_tipojuros AS tipoJurosReceberPagar,");
                buf.append("a.rpg_tipo AS tipoReceberPagar, ");
                buf.append("a.rpg_situacao AS situacaoReceberPagar, ");
                buf.append("a.rpg_tipodocumento AS tipoDocumentoReceberPagar, ");
                buf.append("a.rpg_numerodocumento AS numeroDocumentoReceberPagar, ");
                buf.append("a.rpg_parcela AS numeroParcelaReceberPagar, ");
                buf.append("a.rpg_codigodocumento AS codigoDocumentoReceberPagar, ");
                buf.append("a.rpg_datadocumento AS dataDocumentoReceberPagar,");
                buf.append("a.rpg_dataprocessamento AS dataProcessamentoReceberPagar,");
                buf.append("a.rpg_obs AS observacaoReceberPagar,");
                buf.append("a.rpg_tipocadastro AS tipoCadastroReceberPagar,");
                buf.append("usrrecpag.usr_codigo AS codigoUsuarioReceberPagar,");
                buf.append("usrrecpag.usr_nome AS nomeUsuarioReceberPagar,");
                buf.append("usuariocancela.usr_codigo AS codigoUsuarioCancelamentoReceberPagar,");
                buf.append("usuariocancela.usr_nome AS nomeUsuarioCancelamentoReceberPagar,");
                buf.append("a.rpg_datacancelado AS dataCancelamentoReceberPagar, ");
                buf.append("a.rpg_valor + a.rpg_taxa AS valorComTaxaReceberPagar,");
                buf.append("a.rpg_valorjuro AS valorJuroReceberPagar,");
                buf.append("a.rpg_valormulta AS valorMultaReceberPagar,");
                buf.append("a.rpg_percentualmulta AS percentualMultaReceberPagar,");
                buf.append("a.rpg_percentualjuro AS percentualJuroReceberPagar,");
                buf.append("a.rpg_percentualacrescimo AS percentualAcrescimoReceberPagar,");
                buf.append("a.rpg_percentualdesconto AS percentualDescontoReceberPagar,");
                buf.append(" CASE WHEN a.rpg_tipo = '").append("R").append("' THEN a.rpg_valortotal ELSE 0 END as valorReceber, ");
                buf.append(" CASE WHEN a.rpg_tipo = '").append("P").append("' THEN a.rpg_valortotal ELSE 0 END as valorPagar, ");
                buf.append("a.rpg_ipivalor AS valorIpiReceberPagar, ");
                buf.append("a.rpg_ipipercentual AS percentualIpiReceberPagar, ");
                buf.append("a.rpg_icmsvalor AS valorIcmsReceberPagar, ");
                buf.append("a.rpg_icmspercentual AS percentualIcmsReceberPagar, ");
                buf.append("a.rpg_irrfvalor AS valorIrrfReceberPagar, ");
                buf.append("a.rpg_irrfpercentual AS percentualIrrfReceberPagar, ");
                buf.append("a.rpg_issvalor AS valorIssReceberPagar, ");
                buf.append("a.rpg_isspercentual AS percentualIssReceberPagar, ");
                buf.append("a.rpg_pisvalor AS valorPisReceberPagar, ");
                buf.append("a.rpg_pispercentual AS percentualPisReceberPagar, ");
                buf.append("a.rpg_csllvalor AS valorCsllReceberPagar, ");
                buf.append("a.rpg_csllpercentual AS percentualCsllReceberPagar, ");
                buf.append("a.rpg_cofinsvalor AS valorCofinsReceberPagar,");
                buf.append("a.rpg_cofinspercentual AS percentualCofinsReceberPagar,");
                buf.append("a.rpg_inssvalor AS valorInssReceberPagar,");
                buf.append("a.rpg_insspercentual AS percentualInssReceberPagar,");
                buf.append("Coalesce((CASE WHEN a.nfi_codigo IS NULL THEN ");
                buf.append("a.rpg_irrfvalor + a.rpg_issvalor + a.rpg_pisvalor + a.rpg_csllvalor + a.rpg_cofinsvalor + a.rpg_inssvalor ");
                buf.append("+ a.rpg_ipivalor + a.rpg_icmsvalor ELSE nfi.nfi_irrfvalor + nfi.nfi_issvalor + nfi.nfi_pisvalor + ");
                buf.append("nfi.nfi_csllvalor + nfi.nfi_cofinsvalor + nfi.nfi_inssvalor + nfi.nfi_ipivalor + nfi.nfi_icmsvalor END ), 0) AS valorImpostosReceberPagar, ");
                buf.append("Coalesce(a.rpg_valormulta +  a.rpg_valoracrescimo + a.rpg_valorjuro, 0)  AS valorTaxaTotalReceberPagar, ");
                buf.append("a.ser_codigo AS codigoSerie, s.ser_descricao      AS descricaoSerie, ");
                buf.append("case when a.rpg_tipocadastro = '").append("O").append("' then a.con_codigo ");
                buf.append(" when a.rpg_tipocadastro = '").append("P").append("' then a.pac_codigo ");
                buf.append(" when a.rpg_tipocadastro = '").append("U").append("' then a.ent_codigo ");
                buf.append(" when a.rpg_tipocadastro = '").append("F").append("' then a.ent_codigo ");
                buf.append(" when a.rpg_tipocadastro = '").append("C").append("' then a.ent_codigo ");
                buf.append(" when a.rpg_tipocadastro = '").append("R").append("' then a.ent_codigo else a.ent_codigo ");
                buf.append("end as codigoCadastro, ");
                buf.append("case when a.pac_codigo is not null then pac.pac_nome ");
                buf.append(" when a.ent_codigo is not null then ent.ent_fantasia else con.con_fantasia end as fantasiaCadastro, ");
                buf.append("case when a.pac_codigo is not null then pac.pac_nomesocial ");
                buf.append(" when a.ent_codigo is not null then ent.ent_razaosocial else con.con_razao end as razaoSocialCadastro, ");
                buf.append("case when a.pac_codigo is not null then pac.pac_fone ");
                buf.append(" when a.ent_codigo is not null then ent.ent_fone else con.con_fone end as foneCadastro, ");
                buf.append("case when a.pac_codigo is not null then pac.pac_endereco ");
                buf.append(" when a.ent_codigo is not null then ent.ent_endereco else con.con_endereco end as enderecoCadastro, ");
                buf.append("case when a.pac_codigo is not null then pac.pac_numeroendereco ");
                buf.append(" when a.ent_codigo is not null then ent.ent_numeroendereco else con.con_numeroendereco end as numeroEnderecoCadastro, ");
                buf.append("case when a.pac_codigo is not null then pac.pac_tipologradouroendereco ");
                buf.append(" when a.ent_codigo is not null then ent.ent_tipologradouroendereco else con.con_tipologradouroendereco end as tipoLogradouroCadastro, ");
                buf.append("case when a.pac_codigo is not null then pac.pac_fax ");
                buf.append(" when a.ent_codigo is not null then ent.ent_fax else con.con_fax end as faxCadastro, ");
                buf.append("case when a.pac_codigo is not null then pac.pac_complemento ");
                buf.append(" when a.ent_codigo is not null then ent.ent_complemento else con.con_complemento end as complementoCadastro, ");
                buf.append("case when a.pac_codigo is not null then pac.pac_cep ");
                buf.append(" when a.ent_codigo is not null then ent.ent_cep else con.con_cep end as cepCadastro, ");
                buf.append("nfi.nfi_numero as numeroNotaFiscal, ");
                buf.append("nfi.ser_codigo as serieNotaFiscal, ");
                buf.append("nfi.nfi_situacao as situacaoNotaFiscal, ");
                buf.append("fpg.fpg_descricao as descricaoFormaPgto, ");
                buf.append("nfi.nfi_numerorps IS NOT NULL as isEletronica, ");
                buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                buf.append("from receberpagar a ");
                buf.append("left join usuario usuariocancela on a.usr_codcancelado = usuariocancela.usr_codigo ");
                buf.append("left join usuario usrrecpag on a.usr_codigo = usrrecpag.usr_codigo ");
                buf.append("left join series s on a.fil_codigo = s.fil_codigo and a.ser_codigo = s.ser_codigo ");
                buf.append("left join entidade ent on a.fil_codigo = ent.fil_codigo and a.ent_codigo = ent.ent_codigo ");
                buf.append("left join convenios con on a.fil_codigo = con.fil_codigo and a.con_codigo = con.con_codigo ");
                buf.append("left join paciente pac on a.fil_codigo = pac.fil_codigo and a.pac_codigo = pac.pac_codigo ");
                buf.append("left join notafiscal nfi on (a.fil_codigo = nfi.fil_codigo and a.nfi_codigo = nfi.nfi_codigo) ");
                buf.append("left join formapagto fpg on (nfi.fil_codigo = fpg.fil_codigo and nfi.fpg_codigo = fpg.fpg_codigo) ");
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                buf.append("where a.fil_codigo = ").append(Variaveis.filialPadrao);
                if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                    buf.append(" and cast(a.rpg_vencimento as date) >= '").append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial"))).append("' ");
                }
                if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                    buf.append(" and cast(a.rpg_vencimento as date) <= '").append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal"))).append("' ");
                }
                if (!this.getFiltroCombo("filtroReceberPagar").equals(this.tipo[0])) {
                    if (this.getFiltroCombo("filtroReceberPagar").equals(this.tipo[1])) {
                        buf.append(" and a.rpg_tipo = '").append("P").append("' ");
                    } else {
                        buf.append(" and a.rpg_tipo = '").append("R").append("' ");
                    }
                }
                buf.append(" and a.rpg_situacao = '").append("A").append("' ");
                buf.append("order by a.rpg_vencimento, a.rpg_codigo ");
                rs = Conexao.executeQuery(st, buf.toString());
                BigDecimal totalSaldo = BigDecimal.ZERO;
                BigDecimal saldoContas = BigDecimal.ZERO;
                BigDecimal somatorioReceber = BigDecimal.ZERO;
                BigDecimal somatorioPagar = BigDecimal.ZERO;
                if (rs.next()) {
                    block46: {
                        int k;
                        ModeloGridTable modelo = new ModeloGridTable(this.campos);
                        boolean contador = false;
                        String reduzido = "";
                        String[] conta = this.getSelecionadosFiltro("filtroConta", 0);
                        for (int i = 0; i < conta.length; ++i) {
                            reduzido = reduzido + conta[i];
                            if (i >= conta.length - 1) continue;
                            reduzido = reduzido + ", ";
                        }
                        StringBuilder saldos = new StringBuilder();
                        saldos.append("SELECT sld.sld_saldo AS saldoConta, ");
                        saldos.append("MAX(sld.sld_data) AS dataSaldo, ");
                        saldos.append("sld.cco_reduzido AS codigoContaCorrente, ");
                        saldos.append("'' as totalSaldo, ");
                        saldos.append("cco.cco_conta AS contaCorrente, ");
                        saldos.append("cco.cco_titular AS titularContaCorrente, ");
                        saldos.append("cco.cco_tipo AS tipoContaCorrente, ");
                        saldos.append("bac.bac_codigo AS codigoBanco, ");
                        saldos.append("bac.bac_descricao AS descricaoBanco, ");
                        saldos.append("age.age_codigo AS codigoAgencia, ");
                        saldos.append("age.age_descricao AS descricaoAgencia ");
                        saldos.append("FROM saldocontas sld ");
                        saldos.append("LEFT JOIN contacorrente cco ON sld.fil_codigo = cco.fil_codigo AND sld.cco_reduzido = cco.cco_reduzido ");
                        saldos.append("LEFT JOIN banco bac ON sld.fil_codigo = bac.fil_codigo AND cco.bac_codigo = bac.bac_codigo ");
                        saldos.append("LEFT JOIN agencia age ON sld.fil_codigo = age.fil_codigo AND bac.bac_codigo = age.bac_codigo ");
                        saldos.append("WHERE sld.fil_codigo = ").append(Variaveis.filialPadrao);
                        saldos.append(" AND sld.sld_data = (SELECT MAX(sld_data) FROM saldocontas ");
                        saldos.append("                     WHERE fil_codigo = ").append(Variaveis.filialPadrao);
                        saldos.append("                     AND sld_data < ").append("cast('").append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial"))).append("' as date) ");
                        saldos.append("                     AND cco_reduzido = sld.cco_reduzido ) ");
                        saldos.append("AND sld.sld_data < ").append("cast('").append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData("filtroDataInicial"))).append("' as date) ");
                        saldos.append("AND sld.cco_reduzido in (").append(reduzido).append(") ");
                        saldos.append("GROUP BY sld_saldo, sld.cco_reduzido, cco.cco_conta, cco.cco_titular, cco.cco_tipo, bac.bac_codigo, ");
                        saldos.append("bac.bac_descricao, age.age_codigo, age.age_descricao");
                        ResultSet rsConta = Conexao.executeQuery(st2, saldos.toString());
                        if (rsConta.next()) {
                            Date dataVencimentoContas = Funcoes.getData("dd/MM/yyyy", this.getFiltroData("filtroDataInicial"));
                            dataVencimentoContas = Funcoes.subtraiDias(dataVencimentoContas, 1);
                            do {
                                Object[] o = new Object[this.campos.length];
                                for (k = 0; k < this.campos.length; ++k) {
                                    if (this.campos[k].equalsIgnoreCase("dataSaldo")) {
                                        o[k] = rsConta.getDate("dataSaldo");
                                        continue;
                                    }
                                    if (this.campos[k].equalsIgnoreCase("codigoContaCorrente")) {
                                        o[k] = rsConta.getInt("codigoContaCorrente");
                                        continue;
                                    }
                                    if (this.campos[k].equalsIgnoreCase("saldoConta")) {
                                        o[k] = rsConta.getBigDecimal("saldoConta");
                                        continue;
                                    }
                                    if (this.campos[k].equalsIgnoreCase("contaCorrente")) {
                                        o[k] = rsConta.getString("contaCorrente");
                                        continue;
                                    }
                                    if (this.campos[k].equalsIgnoreCase("totalSaldo")) {
                                        totalSaldo = totalSaldo.add(rsConta.getBigDecimal("saldoConta"));
                                        continue;
                                    }
                                    try {
                                        o[k] = rsConta.getObject(this.campos[k]);
                                        continue;
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                o[modelo.findColumn((String)"dataVencimentoReceberPagar")] = dataVencimentoContas;
                                modelo.addLine(o);
                            } while (rsConta.next());
                        }
                        saldoContas = totalSaldo.add(BigDecimal.ZERO);
                        do {
                            Object[] o = new Object[this.campos.length];
                            int pos = -1;
                            for (k = 0; k < this.campos.length; ++k) {
                                pos = modelo.findColumn(this.campos[k]);
                                if (this.campos[k].equalsIgnoreCase("tipoLogradouroCadastro")) {
                                    o[pos] = Tipos.tipoLogradouroDescricao(rs.getString(this.campos[k]));
                                    continue;
                                }
                                if (this.campos[k].equals("tipoReceberPagar")) {
                                    o[pos] = Tipos.tipoReceberPagar(rs.getString(this.campos[k]));
                                    continue;
                                }
                                if (this.campos[k].equals("valorTotalReceber") || this.campos[k].equals("valorTotalPagar") || this.campos[k].equals("valorReceberPagar") || this.campos[k].equals("valorTaxaTotalReceberPagar")) {
                                    o[pos] = Float.valueOf(rs.getFloat(this.campos[k]));
                                    continue;
                                }
                                if (this.campos[k].equals("valorDescontoReceberPagar")) {
                                    o[pos] = Float.valueOf(rs.getFloat(this.campos[k]));
                                    if (rs.getString("tipoReceberPagar").equals("R")) {
                                        double aux = rs.getDouble(this.campos[k]);
                                        o[modelo.findColumn((String)new StringBuilder().append((String)this.campos[k]).append((String)"ComSinal").toString())] = aux == 0.0 ? 0.0 : aux * -1.0;
                                        continue;
                                    }
                                    o[modelo.findColumn((String)new StringBuilder().append((String)this.campos[k]).append((String)"ComSinal").toString())] = rs.getDouble(this.campos[k]);
                                    continue;
                                }
                                if (this.campos[k].equals("valorImpostosReceberPagar")) {
                                    o[pos] = Float.valueOf(rs.getFloat(this.campos[k]));
                                    double aux = rs.getDouble(this.campos[k]);
                                    o[modelo.findColumn((String)new StringBuilder().append((String)this.campos[k]).append((String)"ComSinal").toString())] = aux == 0.0 ? 0.0 : aux * -1.0;
                                    continue;
                                }
                                if (this.campos[k].equals("tipoDocumentoReceberPagar")) {
                                    o[pos] = Tipos.tipoDocumento(rs.getString(this.campos[k]));
                                    continue;
                                }
                                if (this.campos[k].equals("situacaoReceberPagar")) {
                                    o[pos] = Tipos.tipoSituacaoReceberPagar(rs.getString(this.campos[k]));
                                    continue;
                                }
                                if (this.campos[k].equals("tipoCadastroReceberPagar")) {
                                    o[pos] = Tipos.tipoCadastro(rs.getString(this.campos[k]));
                                    continue;
                                }
                                if (this.campos[k].equals("saldoParcial")) {
                                    if (rs.getString("tipoReceberPagar").equals("R")) {
                                        totalSaldo = totalSaldo.add(rs.getBigDecimal("valorTotalReceber"));
                                        somatorioReceber = somatorioReceber.add(rs.getBigDecimal("valorTotalReceber"));
                                        o[modelo.findColumn((String)this.campos[k])] = totalSaldo;
                                        continue;
                                    }
                                    totalSaldo = totalSaldo.subtract(rs.getBigDecimal("valorTotalPagar"));
                                    somatorioPagar = somatorioPagar.add(rs.getBigDecimal("valorTotalPagar"));
                                    o[pos] = totalSaldo;
                                    continue;
                                }
                                try {
                                    o[pos] = rs.getObject(this.campos[k]);
                                    continue;
                                }
                                catch (Exception aux) {
                                    // empty catch block
                                }
                            }
                            o[modelo.findColumn((String)"somatorioPagar")] = somatorioPagar;
                            o[modelo.findColumn((String)"somatorioReceber")] = somatorioReceber;
                            modelo.addLine(o);
                        } while (rs.next());
                        for (int i = 0; i < modelo.getRowCount(); ++i) {
                            modelo.setValueAt(saldoContas, i, modelo.findColumn("saldoContas"));
                        }
                        rs.previous();
                        for (int j = 0; j < modelo.getRowCount(); ++j) {
                            for (int i = 0; i < Constantes.CAMPOS_FILIAL.length; ++i) {
                                modelo.setValueAt(rs.getObject(Constantes.CAMPOS_FILIAL[i]), j, modelo.findColumn(Constantes.CAMPOS_FILIAL[i]));
                            }
                        }
                        try {
                            StringBuilder rel = new StringBuilder();
                            rel.append("select rel_xml from relatoriosistema where rel_codigo = ");
                            rel.append(RelatorioPrevisaoSaldo.getModuloAcesso());
                            rs = Conexao.executeQuery(st, rel.toString());
                            if (!rs.next()) break block46;
                            Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                            gerador.setPai(this.panelCentro);
                            gerador.setPreVisualizar(true);
                            gerador.setZoomPreVisualizar(0.5f);
                            gerador.setAcaoFechar(new Runnable(){

                                @Override
                                public void run() {
                                    RelatorioPrevisaoSaldo.this.panelCentro.removeAll();
                                    RelatorioPrevisaoSaldo.this.panelCentro.repaint();
                                    RelatorioPrevisaoSaldo.this.habilitaBotaoImprimir(true);
                                }
                            });
                            HashMap<String, Object> var = new HashMap<String, Object>();
                            var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                            var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                            rel.delete(0, rel.length());
                            if (contas != null) {
                                for (int i = 0; i < contas.length; ++i) {
                                    rel.append(contas[i]);
                                    if (i >= contas.length - 1) continue;
                                    rel.append(", ");
                                }
                            }
                            var.put("filtroConta", rel.toString());
                            gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                            this.panelCentro.revalidate();
                        }
                        catch (Exception ex) {
                            try {
                                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RelatorioPrevisaoSaldo");
                            }
                            catch (Throwable throwable) {
                                Conexao.fecharStatement(st, st2);
                                throw throwable;
                            }
                            Conexao.fecharStatement(st, st2);
                            break block47;
                        }
                    }
                    Conexao.fecharStatement(st, st2);
                    break block47;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "RelatorioPrevisaoSaldo");
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0851800200");
    }

    public static long getModuloConfigurar() {
        return Long.parseLong("0851800201");
    }
}

