/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.movimento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.JComboBox;
import javax.swing.table.TableModel;

public class RelatorioLancamentosSemPlanoContas
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String[] ordem = new String[]{"C\u00f3digo", "Data", "Usu\u00e1rio"};
    private final String[] situacao = new String[]{"Todas", Tipos.tipoSituacaoLancamento("A"), Tipos.tipoSituacaoLancamento("O"), Tipos.tipoSituacaoLancamento("C"), "Exceto Cancelados"};
    private final String[] tipo = new String[]{"Todos", Tipos.tipoLancamentoCaixa("C"), Tipos.tipoLancamentoCaixa("D")};
    private String[] itensPagamento = new String[]{"Todos", Tipos.tipoPagamento("H"), Tipos.tipoPagamento("P"), Tipos.tipoPagamento("A"), Tipos.tipoPagamento("D"), Tipos.tipoPagamento("T"), Tipos.tipoPagamento("B"), Tipos.tipoPagamento("E"), Tipos.tipoPagamento("Z"), Tipos.tipoPagamento("S"), Tipos.tipoPagamento("I"), Tipos.tipoPagamento("O"), Tipos.tipoPagamento("C"), Tipos.tipoPagamento("U"), Tipos.tipoPagamento("N"), Tipos.tipoPagamento("F")};
    private final String[] CAMPOSDATA = new String[]{"Vencimento", "Concilia\u00e7\u00e3o", "Emiss\u00e3o", "Compet\u00eancia"};
    private final String[] CAMPOSBANCODATA = new String[]{"lcx_vencimento", "lcx_conciliacao", "lcx_datahora", "lcx_competencia"};
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_ESTACAO = "filtroEstacao";
    private final String FILTRO_USUARIO = "filtroUsuario";
    private final String FILTRO_CONTA = "filtroConta";
    private final String FILTRO_HISTORICO_PADRAO = "filtroHistoricoPadrao";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_PAGAMENTO = "filtroPagamento";
    private final String FILTRO_SITUACAO = "filtroSituacao";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String FILTRO_CAMPO_DATA = "filtroCampoData";
    private final String FILTRO_TIPO = "filtroTipo";
    private final String FILTRO_NAO_TRAZER_TRANSF_CONTAS = "filtroNaoTransfContas";
    private final String FILTRO_NAO_TRAZER_TRANSF_FILIAIS = "filtroNaoTransfFiliais";
    private String layout = null;
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoLancamento", "dataHoraLancamento", "tipoLancamento", "valorLancamento", "bancoLancamento", "agenciaLancamento", "documentoLancamento", "observacaoLancamento", "tipoDocumentoLancamento", "tipoPagamentoLancamento", "numeroChequeLancamento", "validadeCartaoLancamento", "cartaoCreditoLancamento", "contaLancamento", "dataConciliacaoLancamento", "dataVencimentoLancamento", "dataCompetenciaLancamento", "valorTotalLancamento", "valorMultaLancamento", "percentualMultaLancamento", "valorJuroLancamento", "percentualJuroLancamento", "valorAcrescimoLancamento", "percentualAcrescimoLancamento", "valorDescontoLancamento", "percentualDescontoLancamento", "indiceTipoLancamento", "numeroCartaoLancamento", "canceladoLancamento", "situacaoLancamento", "conciliadoLancamento", "usuarioCancelamentoLancamento", "dataCancelamentoLancamento", "nomeUsuarioCancelamentoLancamento", "codigoMotivoCancelamento", "descricaoMotivoCancelamento", "descricaoCancelamentoLancamento", "codigoHistoricoPadrao", "descricaoHistoricoPadrao", "codigoEstacaoLancamento", "descricaoEstacaoLancamento", "codigoReduzidoConta", "contaConta", "titularConta", "codigoUsuarioLancamento", "nomeUsuarioLancamento", "descricaoHistoricoUsuario", "codigoFilialDestinoOrigem", "saldoAnteriorConta", "somatorioValorLancamentos", "valorFinalPeriodoContas", "nomeFuncionarioDescontoFolhaLancamento", "setorFuncionarioDescontoFolhaLancamento", "nomeFuncionarioAutorizacaoDescontoFolhaLancamento"});
    private JComboBox auxComboListener;

    public RelatorioLancamentosSemPlanoContas() {
        this.montaBarraDescricao("Lan\u00e7amentos sem Planos de Contas", "Movimenta\u00e7\u00e3o de lan\u00e7amentos n\u00e3o apropriados em planos de contas", "relatorios/rel_lancamento_sem_plc.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroEstacao", "Esta\u00e7\u00e3o", "estacoes", "", 1, new String[]{"est_codigo", "est_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroUsuario", "Usu\u00e1rio", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConta", "Conta", "contacorrente", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"cco_reduzido", "cco_conta", "bac_codigo", "age_codigo", "cco_inativa"}, new String[]{"C\u00f3digo", "Conta", "Banco", "Ag\u00eancia", "Inativa"}, new int[]{60, 0, 50, 60, 55});
        this.adicionaItemFiltro("filtroHistoricoPadrao", "Hist\u00f3rico padr\u00e3o", "historicopadrao", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"hpa_codigo", "hpa_descricao"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaFiltroComboPopupWidth("filtroPagamento", "Pagamento:", this.itensPagamento, 0, 150);
        this.adicionaFiltroCombo("filtroCampoData", "Campo Data:", this.CAMPOSDATA, 0);
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.adicionaFiltroCombo("filtroTipo", "Tipo:", this.tipo, 0);
        this.adicionaFiltroComboPopupWidth("filtroSituacao", "Situa\u00e7\u00e3o:", this.situacao, 0, 100);
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.adicionaFiltroCheck("filtroNaoTransfContas", "Ignorar transf. entre contas", false);
        this.adicionaFiltroCheck("filtroNaoTransfFiliais", "Ignorar transf. entre filiais", false);
        this.setModuloConfigurar(RelatorioLancamentosSemPlanoContas.getConfigurarAcesso());
        this.setModuloAcesso(RelatorioLancamentosSemPlanoContas.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    @Override
    public void imprimirPressionado() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (!this.validaLayoutRelatorio()) {
            Funcoes.mensagem(this, "Modelo n\u00e3o localizado ou n\u00e3o definido.", 2);
            this.setCursor(Cursor.getDefaultCursor());
            this.habilitaBotaoImprimir(true);
            return;
        }
        try {
            String[] historicoPadrao;
            String[] conta;
            String[] usuario;
            Statement st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            buf.append("select ");
            buf.append("a.lcx_codigo as codigoLancamento, a.lcx_datahora as dataHoraLancamento,");
            buf.append("a.lcx_tipo as tipoLancamento, a.lcx_valor as valorLancamento, ");
            buf.append("a.lcx_banco as bancoLancamento,a.lcx_agencia as agenciaLancamento, ");
            buf.append("a.lcx_documento as documentoLancamento, a.lcx_obs as observacaoLancamento,");
            buf.append("a.lcx_tipodocumento as tipoDocumentoLancamento, a.lcx_tipopagamento as tipoPagamentoLancamento, ");
            buf.append("a.lcx_nrcheque as numeroChequeLancamento, a.lcx_validadecartao as validadeCartaoLancamento, ");
            buf.append("a.lcx_nrcartao as numeroCartaoLancamento, ");
            buf.append("a.lcx_situacao = '").append("C").append("' as canceladoLancamento, ");
            buf.append("a.lcx_situacao = '").append("O").append("' as conciliadoLancamento, ");
            buf.append("a.lcx_situacao as situacaoLancamento, ");
            buf.append("a.lcx_cartaocredito as cartaoCreditoLancamento, a.lcx_conta as contaLancamento, ");
            buf.append("a.lcx_conciliacao as dataConciliacaoLancamento, a.lcx_vencimento as dataVencimentoLancamento, ");
            buf.append("a.lcx_competencia as dataCompetenciaLancamento, ");
            buf.append("a.lcx_nomedescfolha as nomeFuncionarioDescontoFolhaLancamento, ");
            buf.append("a.lcx_setordescfolha as setorFuncionarioDescontoFolhaLancamento, ");
            buf.append("a.lcx_autorizadodescfolha as nomeFuncionarioAutorizacaoDescontoFolhaLancamento, ");
            buf.append("a.usr_codigo as usuarioCancelamentoLancamento, a.lcx_datacancelado as dataCancelamentoLancamento, ");
            buf.append("usuariocancela.usr_nome as nomeUsuarioCancelamentoLancamento, ");
            buf.append("a.est_codigo as codigoEstacaoLancamento, estacoes.est_descricao as descricaoEstacaoLancamento, ");
            buf.append("conta.cco_reduzido as codigoReduzidoConta, conta.cco_conta as contaConta, conta.cco_titular as titularConta,");
            if (!Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                buf.append("coalesce(conta.cco_sldinicial,0) as saldoAnteriorConta, ");
            } else if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial")) && this.getFiltroComboIndice("filtroCampoData") == 0) {
                buf.append("coalesce((select slv.slv_saldo from saldocontasvencimento slv where slv.fil_codigo = a.fil_codigo and conta.cco_reduzido = slv.cco_reduzido and slv.slv_data < ");
                buf.append(" cast(a.").append(this.CAMPOSBANCODATA[this.getFiltroComboIndice("filtroCampoData")]).append(" as date) order by slv.slv_data desc limit 1), 0) as saldoAnteriorConta, ");
            } else if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial")) && this.getFiltroComboIndice("filtroCampoData") != 0) {
                buf.append("coalesce((select sld.sld_saldo from saldocontas sld where sld.fil_codigo = a.fil_codigo and conta.cco_reduzido = sld.cco_reduzido and sld.sld_data < ");
                buf.append(" cast(a.").append(this.CAMPOSBANCODATA[this.getFiltroComboIndice("filtroCampoData")]).append(" as date) order by sld.sld_data desc limit 1),0) as saldoAnteriorConta, ");
            } else {
                buf.append("0 as as saldoAnteriorConta, ");
            }
            buf.append("0 as somatorioValorLancamentos, 0 as valorFinalPeriodoContas, ");
            buf.append("usrlancto.usr_codigo as codigoUsuarioLancamento, usrlancto.usr_nome as nomeUsuarioLancamento, ");
            buf.append("motivo.mov_codigo as codigoMotivoCancelamento, motivo.mov_descricao as descricaoMotivoCancelamento, ");
            buf.append("a.lcx_descricaocancelado as descricaoCancelamentoLancamento, ");
            buf.append("historico.hpa_codigo as codigoHistoricoPadrao, historico.hpa_descricao as descricaoHistoricoPadrao, ");
            buf.append("a.lcx_descricaohistorico as descricaoHistoricoUsuario, ");
            buf.append("case when a.lcx_valortotal is null then 0 else a.lcx_valortotal end as valorTotalLancamento, ");
            buf.append("a.lcx_valormulta as valorMultaLancamento, ");
            buf.append("a.lcx_percentualmulta as percentualMultaLancamento, ");
            buf.append("a.lcx_valorjuro as valorJuroLancamento, ");
            buf.append("a.lcx_percentualjuro as percentualJuroLancamento, ");
            buf.append("a.lcx_valoracrescimo as valorAcrescimoLancamento, ");
            buf.append("a.lcx_percentualacrescimo as percentualAcrescimoLancamento, ");
            buf.append("a.lcx_valordesconto as valorDescontoLancamento, ");
            buf.append("a.lcx_percentualdesconto as percentualDescontoLancamento, ");
            buf.append("a.fil_codentrefilial as codigoFilialDestinoOrigem, ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append("from lanctocaixa a ");
            buf.append("left join usuario usuariocancela on a.usr_codcancelado = usuariocancela.usr_codigo ");
            buf.append("left join filiais_postocoleta filiais on filiais.fil_codigo = a.fil_codentrefilial ");
            buf.append("left join motivoscancelamentos motivo on a.fil_codigo = motivo.fil_codigo and a.mov_codigo = motivo.mov_codigo ");
            buf.append("left join historicopadrao historico on a.fil_codigo = historico.fil_codigo and a.hpa_codigo = historico.hpa_codigo ");
            buf.append("left join estacoes on a.est_codigo = estacoes.est_codigo ");
            buf.append("left join contacorrente conta on a.fil_codigo = conta.fil_codigo and a.cco_reduzido = conta.cco_reduzido ");
            buf.append("left join usuario usrlancto on a.usr_codigo = usrlancto.usr_codigo ");
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            buf.append("where a.fil_codigo ");
            String[] filiais = this.getSelecionadosFiltro("filtroFilial", 0);
            if (filiais == null || filiais.length == 0) {
                buf.append(" = ").append(Variaveis.filialPadrao);
            } else {
                buf.append(" in (");
                for (int i = 0; i < filiais.length; ++i) {
                    buf.append(filiais[i]);
                    if (i >= filiais.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            String[] estacao = this.getSelecionadosFiltro("filtroEstacao", 0);
            if (estacao != null) {
                buf.append(" and a.est_codigo in (");
                for (int i = 0; i < estacao.length; ++i) {
                    buf.append(estacao[i]);
                    if (i >= estacao.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((usuario = this.getSelecionadosFiltro("filtroUsuario", 0)) != null) {
                buf.append(" and a.usr_codigo in (");
                for (int i = 0; i < usuario.length; ++i) {
                    buf.append("'");
                    buf.append(usuario[i]);
                    buf.append("'");
                    if (i >= usuario.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((conta = this.getSelecionadosFiltro("filtroConta", 0)) != null) {
                buf.append(" and a.cco_reduzido in (");
                for (int i = 0; i < conta.length; ++i) {
                    buf.append(conta[i]);
                    if (i >= conta.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((historicoPadrao = this.getSelecionadosFiltro("filtroHistoricoPadrao", 0)) != null) {
                buf.append(" and a.hpa_codigo in (");
                for (int i = 0; i < historicoPadrao.length; ++i) {
                    buf.append(historicoPadrao[i]);
                    if (i >= historicoPadrao.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                buf.append(" and cast(a.").append(this.CAMPOSBANCODATA[this.getFiltroComboIndice("filtroCampoData")]).append(" as date) >= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial")));
                buf.append("'");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                buf.append(" and cast(a.").append(this.CAMPOSBANCODATA[this.getFiltroComboIndice("filtroCampoData")]).append(" as date) <= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal")));
                buf.append("'");
            }
            if (!this.getFiltroCombo("filtroPagamento").toString().equals(this.itensPagamento[0])) {
                String combo = this.getFiltroCombo("filtroPagamento").toString();
                buf.append(" and a.lcx_tipopagamento IN ('");
                if (combo.equals(this.itensPagamento[1])) {
                    buf.append("H");
                } else if (combo.equals(this.itensPagamento[2])) {
                    buf.append("P");
                } else if (combo.equals(this.itensPagamento[3])) {
                    buf.append("A");
                } else if (combo.equals(this.itensPagamento[4])) {
                    buf.append("D");
                } else if (combo.equals(this.itensPagamento[5])) {
                    buf.append("T");
                } else if (combo.equals(this.itensPagamento[6])) {
                    buf.append("B");
                } else if (combo.equals(this.itensPagamento[7])) {
                    buf.append("E");
                } else if (combo.equals(this.itensPagamento[8])) {
                    buf.append("Z");
                } else if (combo.equals(this.itensPagamento[9])) {
                    buf.append("S");
                } else if (combo.equals(this.itensPagamento[10])) {
                    buf.append("I");
                } else if (combo.equals(this.itensPagamento[11])) {
                    buf.append("O");
                } else if (combo.equals(this.itensPagamento[12])) {
                    buf.append("C");
                } else if (combo.equals(this.itensPagamento[13])) {
                    buf.append("U");
                } else if (combo.equals(this.itensPagamento[14])) {
                    buf.append("N");
                } else if (combo.equals(this.itensPagamento[15])) {
                    buf.append("F");
                }
                buf.append("') ");
            }
            if (this.getFiltroCombo("filtroSituacao").equals(this.situacao[1])) {
                buf.append(" and a.lcx_situacao = '").append("A").append("' ");
            } else if (this.getFiltroCombo("filtroSituacao").equals(this.situacao[2])) {
                buf.append(" and a.lcx_situacao = '").append("O").append("' ");
            } else if (this.getFiltroCombo("filtroSituacao").equals(this.situacao[3])) {
                buf.append(" and a.lcx_situacao = '").append("C").append("' ");
            } else if (this.getFiltroCombo("filtroSituacao").equals(this.situacao[4])) {
                buf.append(" and a.lcx_situacao <> '").append("C").append("' ");
            }
            if (this.getFiltroCombo("filtroTipo").equals(this.tipo[1])) {
                buf.append(" and a.lcx_tipo = '").append("C").append("' ");
            } else if (this.getFiltroCombo("filtroTipo").equals(this.tipo[2])) {
                buf.append(" and a.lcx_tipo = '").append("D").append("' ");
            }
            buf.append(" and coalesce((select 1 from lanctocaixaplanoconta lanctoplano where a.fil_codigo = lanctoplano.fil_codigo and a.lcx_codigo = lanctoplano.lcx_codigo and a.est_codigo = lanctoplano.est_codigo limit 1), 0) = 0 ");
            if (this.getFiltroCheck("filtroNaoTransfContas")) {
                buf.append(" and a.lcx_tipoorigem <> '").append("E").append("' ");
            }
            if (this.getFiltroCheck("filtroNaoTransfFiliais")) {
                buf.append(" and a.lcx_tipoorigem <> '").append("F").append("' ");
            }
            buf.append(" order by a.fil_codigo, a.cco_reduzido, ");
            if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[1])) {
                buf.append("a.").append(this.CAMPOSBANCODATA[this.getFiltroComboIndice("filtroCampoData")]);
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[2])) {
                buf.append("a.usr_codigo");
            } else {
                buf.append("a.lcx_codigo ");
            }
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                int i;
                int i2;
                ModeloGridTable modelo = new ModeloGridTable(campos);
                BigDecimal somatorioValorLancamentos = new BigDecimal(0);
                BigDecimal valorFinalPeriodo = rs.getBigDecimal("saldoAnteriorConta");
                int codigoConta = rs.getInt("codigoReduzidoConta");
                do {
                    if (rs.getInt("codigoReduzidoConta") != codigoConta) {
                        somatorioValorLancamentos = new BigDecimal(0);
                        codigoConta = rs.getInt("codigoReduzidoConta");
                        valorFinalPeriodo = valorFinalPeriodo.add(rs.getBigDecimal("saldoAnteriorConta"));
                    }
                    if (rs.getString("tipoLancamento").equalsIgnoreCase("C")) {
                        somatorioValorLancamentos = somatorioValorLancamentos.add(rs.getBigDecimal("valorTotalLancamento"));
                        valorFinalPeriodo = valorFinalPeriodo.add(rs.getBigDecimal("valorTotalLancamento"));
                    } else {
                        somatorioValorLancamentos = somatorioValorLancamentos.subtract(rs.getBigDecimal("valorTotalLancamento"));
                        valorFinalPeriodo = valorFinalPeriodo.subtract(rs.getBigDecimal("valorTotalLancamento"));
                    }
                    Object[] o = new Object[campos.length];
                    for (i2 = 0; i2 < campos.length; ++i2) {
                        o[i2] = campos[i2].equals("tipoLancamento") ? Tipos.tipoLancamentoCaixa(rs.getString(campos[i2])) : (campos[i2].equals("indiceTipoLancamento") ? Integer.valueOf(rs.getString("tipoLancamento").equalsIgnoreCase("D") ? -1 : 1) : (campos[i2].equals("valorLancamento") && rs.getBigDecimal(campos[i2]) != null ? rs.getBigDecimal(campos[i2]).multiply(rs.getString("tipoLancamento").equalsIgnoreCase("D") && rs.getDouble(campos[i2]) > 0.0 ? new BigDecimal(-1) : new BigDecimal(1)) : (campos[i2].equals("valorTotalLancamento") ? rs.getBigDecimal(campos[i2]).multiply(rs.getString("tipoLancamento").equalsIgnoreCase("D") && rs.getDouble(campos[i2]) > 0.0 ? new BigDecimal(-1) : new BigDecimal(1)) : (campos[i2].equals("tipoDocumentoLancamento") ? Tipos.tipoDocumento(rs.getString(campos[i2])) : (campos[i2].equals("tipoUltimoPagamentoRequisicao") || campos[i2].equals("tipoPagamentoLancamento") ? Tipos.tipoPagamento(rs.getString(campos[i2])) : (campos[i2].equals("situacaoLancamento") ? Tipos.tipoSituacaoLancamento(rs.getString(campos[i2])) : (campos[i2].equals("somatorioValorLancamentos") ? somatorioValorLancamentos : rs.getObject(campos[i2]))))))));
                    }
                    modelo.addLine(o);
                } while (rs.next());
                int pos = modelo.findColumn("valorFinalPeriodoContas");
                for (i2 = 0; i2 < modelo.getRowCount(); ++i2) {
                    modelo.setValueAt(valorFinalPeriodo, i2, pos);
                }
                Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                gerador.setPai(this.panelCentro);
                gerador.setPreVisualizar(true);
                gerador.setZoomPreVisualizar(0.5f);
                gerador.setAcaoFechar(new Runnable(){

                    @Override
                    public void run() {
                        RelatorioLancamentosSemPlanoContas.this.panelCentro.removeAll();
                        RelatorioLancamentosSemPlanoContas.this.panelCentro.repaint();
                        RelatorioLancamentosSemPlanoContas.this.habilitaBotaoImprimir(true);
                    }
                });
                HashMap<String, Object> var = new HashMap<String, Object>();
                var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                var.put("filtroPagamento", this.getFiltroCombo("filtroPagamento"));
                var.put("filtroSituacao", this.getFiltroCombo("filtroSituacao"));
                var.put("filtroCampoData", this.getFiltroCombo("filtroCampoData"));
                var.put("filtroTipo", this.getFiltroCombo("filtroTipo"));
                var.put("filtroNaoTransfContas", this.getFiltroCheck("filtroNaoTransfContas") ? "Sim" : "N\u00e3o");
                var.put("filtroNaoTransfFiliais", this.getFiltroCheck("filtroNaoTransfFiliais") ? "Sim" : "N\u00e3o");
                buf.delete(0, buf.length());
                if (filiais != null) {
                    for (i = 0; i < filiais.length; ++i) {
                        buf.append(filiais[i]);
                        if (i >= filiais.length - 1) continue;
                        buf.append(", ");
                    }
                }
                var.put("filtroFilial", buf.toString());
                buf.delete(0, buf.length());
                if (estacao != null) {
                    for (i = 0; i < estacao.length; ++i) {
                        buf.append(estacao[i]);
                        if (i >= estacao.length - 1) continue;
                        buf.append(", ");
                    }
                }
                var.put("filtroEstacao", buf.toString());
                buf.delete(0, buf.length());
                if (usuario != null) {
                    for (i = 0; i < usuario.length; ++i) {
                        buf.append(usuario[i]);
                        if (i >= usuario.length - 1) continue;
                        buf.append(", ");
                    }
                }
                var.put("filtroUsuario", buf.toString());
                buf.delete(0, buf.length());
                if (conta != null) {
                    for (i = 0; i < conta.length; ++i) {
                        buf.append(conta[i]);
                        if (i >= conta.length - 1) continue;
                        buf.append(", ");
                    }
                }
                var.put("filtroConta", buf.toString());
                buf.delete(0, buf.length());
                if (historicoPadrao != null) {
                    for (i = 0; i < historicoPadrao.length; ++i) {
                        buf.append(historicoPadrao[i]);
                        if (i >= historicoPadrao.length - 1) continue;
                        buf.append(", ");
                    }
                }
                var.put("filtroHistoricoPadrao", buf.toString());
                gerador.executar(this.layout, (TableModel)modelo, var);
                this.panelCentro.revalidate();
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
            Conexao.fecharStatement(st);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private boolean validaLayoutRelatorio() {
        StringBuilder buf = new StringBuilder();
        Statement st = Conexao.getStatement();
        ResultSet rs = null;
        if (Funcoes.textoVazio(this.layout)) {
            try {
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioLancamentosSemPlanoContas.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    this.layout = rs.getString("rel_xml");
                }
                rs.close();
            }
            catch (Exception e) {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                Conexao.fecharStatement(st);
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel carregar o layout do relat\u00f3rio." + e.getMessage(), e.getStackTrace());
                return false;
            }
        }
        Conexao.fecharStatement(st);
        return !Funcoes.textoVazio(this.layout);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0850802300");
    }

    public static long getConfigurarAcesso() {
        return Long.parseLong("0850802301");
    }
}

