/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.movimento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioLancamentoPlanoDetalhado
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private static final String[] ordem = new String[]{"C\u00f3digo", "Documento", "Dt. Cadastro", "Dt. Vencimento", "Valor"};
    private static final String[] CAMPOS_ORDEM = new String[]{"codigoLancamento", "documentoLancamento", "emissaoLancamento", "vencimentoLancamento", "valorLancamentoPlanoComSinal"};
    private static final String[] ordemRecPag = new String[]{"C\u00f3digo", "N\u00famero Doc.", "C\u00f3digo Doc.", "Valor Total"};
    private static final String[] CAMPOS_ORDEM_RECPAG = new String[]{"codigoReceberPagar", "numeroDocumentoReceberPagar", "codigoDocumentoReceberPagar", "valorTotalReceberPagarComSinal"};
    private static final String[] tipoPlanoConta = new String[]{"Todos", Tipos.tipoPlanoContas("R"), Tipos.tipoPlanoContas("D")};
    private static final String[] situacaoLancto = new String[]{"Todos", Tipos.tipoSituacaoLancamento("A"), Tipos.tipoSituacaoLancamento("O")};
    private static final String[] tipoLancto = new String[]{"Todos", Tipos.tipoLancamentoCaixa("C"), Tipos.tipoLancamentoCaixa("D")};
    private static final String FILTRO_PLANO_CONTA = "filtroPlanoConta";
    private static final String FILTRO_FILIAL_PLANO_CONTA = "filtroFilialPlanoConta";
    private static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private static final String FILTRO_VALOR_INICIAL = "filtroValorInicial";
    private static final String FILTRO_VALOR_FINAL = "filtroValorFinal";
    private static final String FILTRO_TIPO_PLANO = "filtroTipoPlanoConta";
    private static final String FILTRO_USUARIO = "filtroUsuario";
    private static final String FILTRO_ORIGEM = "filtroOrigem";
    private static final String FILTRO_CAMPO_DATA = "filtroData";
    private static final String FILTRO_ORDEM = "filtroOrdem";
    private static final String FILTRO_ORDEM_RECPAG = "filtroOrdemRecPag";
    private static final String FILTRO_SITUACAO = "filtroSituacao";
    private static final String FILTRO_TIPO = "filtroTipo";
    private static final String FILTRO_NUMERO_DOCUMENTO = "filtroNumeroDocumento";
    private static final String FILTRO_CODIGO_DOCUMENTO = "filtroCodigoDocumento";
    private static final String[] CAMPOSDATALANCTO = new String[]{"Vencimento", "Compet\u00eancia", "Cadastro", "Concilia\u00e7\u00e3o"};
    private static final String[] CAMPOSDATABANCOLANCTO = new String[]{"lcx_vencimento", "lcx_competencia", "lcx_datahora", "lcx_conciliacao"};
    private String[] camposRelatorio = Constantes.CAMPOS_FILIAL;
    private static final String[] camposPlanoConta = new String[]{"reduzidoPlanoConta", "descricaoPlanoConta", "contaPlanoConta", "tipoPlanoConta", "apropriarPlanoConta", "filialPlanoConta", "nivelPlanoConta", "paiPlanoConta", "totalPlanoConta", "valorSomatorio", "totalPlanoContaComSinal", "valorSomatorioComSinal", "operacaoPlanoConta"};
    private static final String[] camposLancamento = new String[]{"codigoLancamento", "tipoPagamentoLancamento", "contaLancamento", "documentoLancamento", "valorLancamento", "valorTotalLancamento", "vencimentoLancamento", "tipoLancamento", "valorLancamentoPlano", "codigoOrigemLancamentoPlano", "competenciaLancamento", "conciliacaoLancamento", "emissaoLancamento", "valorLancamentoPlanoComSinal", "situacaoLancamento"};
    private static final String[] camposRecPag = new String[]{"codigoReceberPagar", "vencimentoReceberPagar", "tipoReceberPagar", "tipoCadastro", "tipoDocumentoReceberPagar", "numeroDocumentoReceberPagar", "parcelaReceberPagar", "dataDocumentoReceberPagar", "dataProcessamentoReceberPagar", "codigoSerieReceberPagar", "situacaoReceberPagar", "valorReceberPagar", "valorTotalReceberPagar", "dataHoraReceberPagar", "competenciaReceberPagar", "codigoDocumentoReceberPagar", "valorTotalReceberPagarComSinal", "valorReceberPagarPlano"};
    private static final String[] camposCadastros = new String[]{"codigoCadastro", "fantasiaCadastro", "nomeSocialPaciente", "razaoSocialCadastro", "foneCadastro", "enderecoCadastro", "numeroEnderecoCadastro", "faxCadastro", "complementoCadastro", "cepCadastro", "codigoCidadeCadastro", "nomeCidadeCadastro", "tipoLogradouroCadastro"};

    public RelatorioLancamentoPlanoDetalhado() {
        this.montaBarraDescricao("Relat\u00f3rio de Lan\u00e7amento por Plano de Contas Detalhado", "Lan\u00e7amentos e t\u00edtulos associados nos planos de contas", "relatorios/rel_lancamento_plc_detalhado.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro(FILTRO_FILIAL_PLANO_CONTA, "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_USUARIO, "Usu\u00e1rio", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_PLANO_CONTA, "Plano Contas", "planoconta", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"plc_reduzido", "plc_conta", "plc_descricao"}, new String[]{"C\u00f3digo", "Conta", "Descri\u00e7\u00e3o"}, new int[]{70, 120, 0});
        this.adicionaItemFiltro(FILTRO_ORIGEM, "Origem", "origemplanocusto", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"opc_codigo", "opc_descricao", "opc_padrao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Padr\u00e3o"}, new int[]{70, 0, 50});
        this.adicionaFiltroCombo(FILTRO_CAMPO_DATA, "Campo Data:", CAMPOSDATALANCTO, 0);
        this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Data inicial:");
        this.adicionaFiltroData(FILTRO_DATA_FINAL, "Data final:");
        this.adicionaFiltroDecimal(FILTRO_VALOR_INICIAL, "Valor Inicial:", 0);
        this.adicionaFiltroDecimal(FILTRO_VALOR_FINAL, "Valor Final:", 0);
        this.adicionaFiltroTexto(FILTRO_CODIGO_DOCUMENTO, "C\u00f3digo Doc.:", 40);
        this.adicionaFiltroTexto(FILTRO_NUMERO_DOCUMENTO, "N\u00famero Doc.:", 40);
        this.adicionaFiltroCombo(FILTRO_TIPO_PLANO, "Tipo Plano:", tipoPlanoConta, 0);
        this.adicionaFiltroCombo(FILTRO_SITUACAO, "Situa\u00e7\u00e3o:", situacaoLancto, 0);
        this.adicionaRetornaFiltroCombo(FILTRO_TIPO, "Tipo:", tipoLancto, 0);
        this.adicionaFiltroCombo(FILTRO_ORDEM, "Ordem:", ordem, 0);
        this.adicionaFiltroCombo(FILTRO_ORDEM_RECPAG, "Ordem T\u00edt.:", ordemRecPag, 0);
        this.setModuloConfigurar(RelatorioLancamentoPlanoDetalhado.getConfigurarAcesso());
        this.setModuloAcesso(RelatorioLancamentoPlanoDetalhado.getModuloAcesso());
        this.camposRelatorio = ArraysUtil.concatenar(ArraysUtil.concatenar(ArraysUtil.concatenar(ArraysUtil.concatenar(this.camposRelatorio, camposPlanoConta), camposLancamento), camposRecPag), camposCadastros);
        this.setCamposConfigurador(this.camposRelatorio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement st2;
        Statement st;
        block125: {
            String[] filiais;
            String[] origem;
            String numeroDocumento;
            String codigoDocumento;
            String combo;
            String[] usuario;
            StringBuilder whereRpl;
            StringBuilder whereRpg;
            block124: {
                st = Conexao.getStatement();
                st2 = Conexao.getStatement();
                whereRpg = new StringBuilder();
                whereRpl = new StringBuilder();
                if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_INICIAL))) {
                    whereRpg.append(" and cast(lcx." + CAMPOSDATABANCOLANCTO[this.getFiltroComboIndice(FILTRO_CAMPO_DATA)] + " as date) >= '");
                    whereRpg.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_INICIAL)));
                    whereRpg.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_FINAL))) {
                    whereRpg.append(" and cast(lcx." + CAMPOSDATABANCOLANCTO[this.getFiltroComboIndice(FILTRO_CAMPO_DATA)] + " as date) <= '");
                    whereRpg.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_FINAL)));
                    whereRpg.append("'");
                }
                if (!Funcoes.textoVazio(this.getFiltroDecimal(FILTRO_VALOR_INICIAL))) {
                    whereRpl.append(" and lcx.lcx_valortotal >= ");
                    whereRpl.append(this.getFiltroTexto(FILTRO_VALOR_INICIAL));
                    whereRpl.append(" ");
                }
                if (!Funcoes.textoVazio(this.getFiltroDecimal(FILTRO_VALOR_FINAL))) {
                    whereRpl.append(" and lcx.lcx_valortotal <= ");
                    whereRpl.append(this.getFiltroTexto(FILTRO_VALOR_FINAL));
                    whereRpl.append(" ");
                }
                if ((usuario = this.getSelecionadosFiltro(FILTRO_USUARIO, 0)) != null) {
                    whereRpg.append(" and (lcx.usr_codigo in (");
                    for (int i = 0; i < usuario.length; ++i) {
                        whereRpg.append("'");
                        whereRpg.append(usuario[i]);
                        whereRpg.append("'");
                        if (i >= usuario.length - 1) continue;
                        whereRpg.append(", ");
                    }
                    whereRpg.append(") OR lcx.usr_codigo IS NULL)");
                }
                if ((combo = this.getFiltroCombo(FILTRO_SITUACAO).toString()).equals(situacaoLancto[0])) {
                    whereRpg.append(" and lcx.lcx_situacao IN('");
                    whereRpg.append("A").append("', '").append("O");
                    whereRpg.append("') ");
                } else {
                    whereRpg.append(" and lcx.lcx_situacao = '");
                    if (combo.equals(situacaoLancto[1])) {
                        whereRpg.append("A");
                    } else {
                        whereRpg.append("O");
                    }
                    whereRpg.append("' ");
                }
                combo = this.getFiltroCombo(FILTRO_TIPO).toString();
                if (combo.equals(tipoLancto[0])) {
                    whereRpg.append(" and lcx.lcx_tipo IN('");
                    whereRpg.append("C").append("', '").append("D");
                    whereRpg.append("') ");
                } else {
                    whereRpg.append(" and lcx.lcx_tipo = '");
                    if (combo.equals(tipoLancto[1])) {
                        whereRpg.append("C");
                    } else {
                        whereRpg.append("D");
                    }
                    whereRpg.append("' ");
                }
                codigoDocumento = this.getFiltroTexto(FILTRO_CODIGO_DOCUMENTO);
                if (codigoDocumento.length() > 0) {
                    whereRpg.append(" and rpg.rpg_codigodocumento ilike '%").append(this.getFiltroTexto(FILTRO_CODIGO_DOCUMENTO)).append("%' ");
                }
                if ((numeroDocumento = this.getFiltroTexto(FILTRO_NUMERO_DOCUMENTO)).length() > 0) {
                    whereRpg.append(" and rpg.rpg_numerodocumento ilike '%").append(this.getFiltroTexto(FILTRO_NUMERO_DOCUMENTO)).append("%' ");
                }
                if ((origem = this.getSelecionadosFiltro(FILTRO_ORIGEM, 0)) != null) {
                    whereRpl.append(" and lpc.opc_codigo in (");
                    for (int i = 0; i < origem.length; ++i) {
                        whereRpl.append("'");
                        whereRpl.append(origem[i]);
                        whereRpl.append("'");
                        if (i >= origem.length - 1) continue;
                        whereRpl.append(", ");
                    }
                    whereRpl.append(")");
                }
                filiais = this.getSelecionadosFiltro(FILTRO_FILIAL_PLANO_CONTA, 0);
                if (filiais == null || filiais.length <= 1) break block124;
                Funcoes.mensagem(this, "Apenas uma filial deve ser selecionada para o relat\u00f3rio", 2);
                this.habilitaBotaoImprimir(true);
                Conexao.fecharStatement(st, st2);
                return;
            }
            try {
                int i;
                this.setCursor(Cursor.getPredefinedCursor(3));
                StringBuilder buf = new StringBuilder();
                buf.append("select distinct ");
                buf.append(" a.plc_reduzido as reduzidoPlanoConta, ");
                buf.append(" a.plc_descricao as descricaoPlanoConta, ");
                buf.append(" a.plc_conta as contaPlanoConta, ");
                buf.append(" a.plc_tipo as tipoPlanoConta, ");
                buf.append(" a.plc_apropriar as apropriarPlanoConta, ");
                buf.append(" a.fil_codigo as filialPlanoConta, ");
                buf.append(" a.plc_nivel as nivelPlanoConta, ");
                buf.append(" a.plc_pai as paiPlanoConta, ");
                buf.append(" a.plc_operacao as operacaoPlanoConta, ");
                buf.append(" lcx.lcx_codigo as codigoLancamento, ");
                buf.append(" lcx.lcx_tipopagamento as tipoPagamentoLancamento, ");
                buf.append(" lcx.lcx_conta as contaLancamento, ");
                buf.append(" lcx.lcx_documento as documentoLancamento, ");
                buf.append(" lcx.lcx_vencimento as vencimentoLancamento, ");
                buf.append(" lcx.lcx_datahora as emissaoLancamento, ");
                buf.append(" lcx.lcx_conciliacao as conciliacaoLancamento, ");
                buf.append(" lcx.lcx_competencia as competenciaLancamento, ");
                buf.append(" lcx.lcx_tipo as tipoLancamento, ");
                buf.append(" lcx.opc_codigo as codigoOrigemLancamentoPlano, ");
                buf.append(" lcx.lcx_valor as valorLancamento, ");
                buf.append(" lcx.lcx_valortotal as valorTotalLancamento, ");
                buf.append(" lcx.lpl_valor as valorLancamentoPlano, ");
                buf.append(" lcx.lcx_situacao as situacaoLancamento, ");
                buf.append(" CASE WHEN a.plc_operacao = 'A' THEN lcx.lpl_valor ELSE lcx.lpl_valor * (-1) END as valorLancamentoPlanoComSinal, ");
                buf.append(" lcx.rpg_datahora as dataHoraReceberPagar, ");
                buf.append(" lcx.rpg_competencia as competenciaReceberPagar, ");
                buf.append(" lcx.rpg_vencimento as vencimentoReceberPagar, ");
                buf.append(" lcx.rpg_codigo as codigoReceberPagar, ");
                buf.append(" lcx.rpg_tipo as tipoReceberPagar, ");
                buf.append(" lcx.rpg_tipodocumento as tipoDocumentoReceberPagar, ");
                buf.append(" lcx.rpg_parcela as parcelaReceberPagar, ");
                buf.append(" lcx.rpg_datadocumento as dataDocumentoReceberPagar, ");
                buf.append(" lcx.rpg_dataprocessamento as dataProcessamentoReceberPagar, ");
                buf.append(" lcx.ser_codigo as codigoSerieReceberPagar, ");
                buf.append(" lcx.rpg_situacao as situacaoReceberPagar, ");
                buf.append(" lcx.rpg_valor as valorReceberPagar, ");
                buf.append(" lcx.rpg_valortotal as valorTotalReceberPagar, ");
                buf.append(" lcx.rpg_tipocadastro as tipoCadastro, ");
                buf.append(" lcx.rpg_numerodocumento as numeroDocumentoReceberPagar, ");
                buf.append(" lcx.rpg_codigodocumento as codigoDocumentoReceberPagar, ");
                buf.append("CASE WHEN lcx.rpg_tipo = 'R' THEN lcx.rpg_valortotal ELSE lcx.rpg_valortotal * (-1) END as valorTotalReceberPagarComSinal, ");
                buf.append(" lcx.codigoCadastro, ");
                buf.append(" lcx.lrp_valor as valorReceberPagarPlano, ");
                buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                buf.append("  from planoconta a ");
                buf.append("  left join (select lpc.*, ");
                buf.append("                    lcx.lcx_tipo, ");
                buf.append("                    lcx.lcx_tipopagamento, ");
                buf.append("                    lcx.lcx_conta, ");
                buf.append("                    lcx.lcx_documento, ");
                buf.append("                    lcx.lcx_situacao, ");
                buf.append("                    lcx.lcx_valor, ");
                buf.append("                    lcx.lcx_valortotal, ");
                buf.append("                    lcx.lcx_vencimento, ");
                buf.append("                    lcx.lcx_competencia, ");
                buf.append("                    lcx.lcx_datahora, ");
                buf.append("                    lcx.lcx_conciliacao, ");
                buf.append("                    lrp.lrp_valor, ");
                buf.append(" \t\t\t\t\t\t\t\t\t\trpg.rpg_datahora, ");
                buf.append(" \t\t\t\t\t\t\t\t\t\trpg.rpg_competencia, ");
                buf.append(" \t\t\t\t\t\t\t\t\t\trpg.rpg_vencimento, ");
                buf.append(" \t\t\t\t\t\t\t\t\t\trpg.rpg_codigo, ");
                buf.append(" \t\t\t\t\t\t\t\t\t\trpg.rpg_tipo, ");
                buf.append(" \t\t\t\t\t\t\t\t\t\trpg.rpg_tipodocumento, ");
                buf.append(" \t\t\t\t\t\t\t\t\t\trpg.rpg_numerodocumento, ");
                buf.append(" \t\t\t\t\t\t\t\t\t\trpg.rpg_parcela, ");
                buf.append(" \t\t\t\t\t\t\t\t\t\trpg.rpg_datadocumento, ");
                buf.append(" \t\t\t\t\t\t\t\t\t\trpg.rpg_dataprocessamento, ");
                buf.append(" \t\t\t\t\t\t\t\t\t\trpg.ser_codigo, ");
                buf.append(" \t\t\t\t\t\t\t\t\t\trpg.rpg_situacao, ");
                buf.append(" \t\t\t\t\t\t\t\t\t\trpg.rpg_valor, ");
                buf.append(" \t\t\t\t\t\t\t\t\t\trpg.rpg_valortotal, ");
                buf.append(" \t\t\t\t\t\t\t\t\t\trpg.rpg_tipocadastro, ");
                buf.append("                    rpg.rpg_codigodocumento, ");
                buf.append(" \t\t\t\t\t\t\t\t\t\tCASE WHEN rpg.rpg_tipocadastro = '").append("P").append("' THEN rpg.pac_codigo ");
                buf.append("      \t\t\t\t\t\t\t\t\t WHEN rpg.rpg_tipocadastro = '").append("O").append("' THEN rpg.con_codigo ");
                buf.append("      \t\t\t\t\t\t\t\t\t ELSE rpg.ent_codigo END as codigoCadastro ");
                buf.append("               from lanctocaixaplanoconta lpc ");
                buf.append(" join lanctocaixa lcx on lpc.fil_codigo = lcx.fil_codigo and lpc.lcx_codigo = lcx.lcx_codigo and lcx.lcx_situacao <> '").append("C").append("' ");
                buf.append(" join baixalanctocaixa blc on lcx.fil_codigo = blc.fil_codigo and lcx.lcx_codigo = blc.lcx_codigo ");
                buf.append(" join baixa bxa on blc.fil_codigo = bxa.fil_codigo and blc.bxa_codigo = bxa.bxa_codigo ");
                buf.append(" join baixareceberpagar brp on bxa.fil_codigo = brp.fil_codigo and bxa.bxa_codigo = brp.bxa_codigo ");
                buf.append(" join lanctocaixaplanocontarp lrp on brp.fil_codigo = lrp.fil_codigo and lpc.opc_codigo = lrp.opc_codigo and lcx.lcx_codigo = lrp.lcx_codigo and lcx.est_codigo = lrp.est_codigo and lpc.plc_reduzido = lrp.plc_reduzido ");
                buf.append(" join receberpagar rpg on rpg.fil_codigo = rpg.fil_codigo and lrp.rpg_codigo = rpg.rpg_codigo ");
                buf.append(whereRpg.toString() + whereRpl.toString());
                buf.append(") lcx on a.fil_codigo = lcx.fil_codigo and a.plc_reduzido = lcx.plc_reduzido ");
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                buf.append("where a.fil_codigo ");
                if (filiais == null || filiais.length == 0) {
                    buf.append(" = ").append(Variaveis.filialPadrao);
                } else {
                    buf.append(" in (");
                    for (int i2 = 0; i2 < filiais.length; ++i2) {
                        buf.append(filiais[i2]);
                        if (i2 >= filiais.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                int maiorNivel = 0;
                ResultSet rs = null;
                try {
                    rs = Conexao.executeQuery(st, "select MAX(a.plc_nivel) as maiorNivel from planoconta a");
                    rs.next();
                    maiorNivel = rs.getInt("maiorNivel");
                }
                catch (Exception ex) {
                    maiorNivel = 0;
                }
                String[] planoconta = this.getSelecionadosFiltro(FILTRO_PLANO_CONTA, 0);
                if (planoconta != null) {
                    buf.append(" and a.plc_reduzido in (");
                    ArrayList<Integer> arrayAux = new ArrayList<Integer>();
                    for (int i3 = 0; i3 < planoconta.length; ++i3) {
                        arrayAux.add(new Integer(planoconta[i3]));
                    }
                    ArrayList<Integer> arrayAcima = this.getPlanosAcima((ArrayList)arrayAux.clone());
                    ArrayList<Integer> arrayAbaixo = this.getPlanosAbaixo((ArrayList)arrayAux.clone());
                    if (arrayAcima != null) {
                        for (i = 0; i < arrayAcima.size(); ++i) {
                            if (arrayAux.contains(arrayAcima.get(i))) continue;
                            arrayAux.add(arrayAcima.get(i));
                        }
                    }
                    if (arrayAbaixo != null) {
                        for (i = 0; i < arrayAbaixo.size(); ++i) {
                            if (arrayAux.contains(arrayAbaixo.get(i))) continue;
                            arrayAux.add(arrayAbaixo.get(i));
                        }
                    }
                    for (i = 0; i < arrayAux.size(); ++i) {
                        buf.append(arrayAux.get(i));
                        if (i >= arrayAux.size() - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                if (!this.getFiltroCombo(FILTRO_TIPO_PLANO).toString().equals(tipoPlanoConta[0])) {
                    combo = this.getFiltroCombo(FILTRO_TIPO_PLANO).toString();
                    buf.append(" and a.plc_tipo = '");
                    if (combo.equals(tipoPlanoConta[1])) {
                        buf.append("R");
                    } else if (combo.equals(tipoPlanoConta[2])) {
                        buf.append("D");
                    } else {
                        buf.append("C");
                    }
                    buf.append("'");
                }
                rs = Conexao.executeQuery(st, buf.toString());
                ArrayValoresPlanoConta arrayContas = null;
                ArrayList<Integer> listaLanctoRP = new ArrayList<Integer>();
                if (rs.next()) {
                    arrayContas = new ArrayValoresPlanoConta();
                    while (rs.next()) {
                    }
                    rs.first();
                    do {
                        if (rs.getInt("codigoLancamento") == 0 || listaLanctoRP.contains(rs.getInt("codigoLancamento"))) continue;
                        listaLanctoRP.add(rs.getInt("codigoLancamento"));
                    } while (rs.next());
                }
                if (codigoDocumento.length() == 0 && numeroDocumento.length() == 0) {
                    buf = new StringBuilder(" (").append(buf.toString()).append(") ");
                    buf.append(" UNION ");
                    buf.append(" (select ");
                    buf.append(" a.plc_reduzido as reduzidoPlanoConta, ");
                    buf.append(" a.plc_descricao as descricaoPlanoConta, ");
                    buf.append(" a.plc_conta as contaPlanoConta, ");
                    buf.append(" a.plc_tipo as tipoPlanoConta, ");
                    buf.append(" a.plc_apropriar as apropriarPlanoConta, ");
                    buf.append(" a.fil_codigo as filialPlanoConta, ");
                    buf.append(" a.plc_nivel as nivelPlanoConta, ");
                    buf.append(" a.plc_pai as paiPlanoConta, ");
                    buf.append(" a.plc_operacao as operacaoPlanoConta, ");
                    buf.append(" lcx.lcx_codigo as codigoLancamento, ");
                    buf.append(" lcx.lcx_tipopagamento as tipoPagamentoLancamento, ");
                    buf.append(" lcx.lcx_conta as contaLancamento, ");
                    buf.append(" lcx.lcx_documento as documentoLancamento, ");
                    buf.append(" lcx.lcx_vencimento as vencimentoLancamento, ");
                    buf.append(" lcx.lcx_datahora as emissaoLancamento, ");
                    buf.append(" lcx.lcx_conciliacao as conciliacaoLancamento, ");
                    buf.append(" lcx.lcx_competencia as competenciaLancamento, ");
                    buf.append(" lcx.lcx_tipo as tipoLancamento, ");
                    buf.append(" lcx.opc_codigo as codigoOrigemLancamentoPlano, ");
                    buf.append(" lcx.lcx_valor as valorLancamento, ");
                    buf.append(" lcx.lcx_valortotal as valorTotalLancamento, ");
                    buf.append(" lcx.lpl_valor as valorLancamentoPlano, ");
                    buf.append(" lcx.lcx_situacao as situacaoLancamento, ");
                    buf.append(" CASE WHEN a.plc_operacao = 'A' THEN lcx.lpl_valor ELSE lcx.lpl_valor * (-1) END as valorLancamentoPlanoComSinal, ");
                    buf.append(" rpg.rpg_datahora as dataHoraReceberPagar, ");
                    buf.append(" rpg.rpg_competencia as competenciaReceberPagar, ");
                    buf.append(" rpg.rpg_vencimento as vencimentoReceberPagar, ");
                    buf.append(" rpg.rpg_codigo as codigoReceberPagar, ");
                    buf.append(" rpg.rpg_tipo as tipoReceberPagar, ");
                    buf.append(" rpg.rpg_tipodocumento as tipoDocumentoReceberPagar, ");
                    buf.append(" rpg.rpg_parcela as parcelaReceberPagar, ");
                    buf.append(" rpg.rpg_datadocumento as dataDocumentoReceberPagar, ");
                    buf.append(" rpg.rpg_dataprocessamento as dataProcessamentoReceberPagar, ");
                    buf.append(" rpg.ser_codigo as codigoSerieReceberPagar, ");
                    buf.append(" rpg.rpg_situacao as situacaoReceberPagar, ");
                    buf.append(" rpg.rpg_valor as valorReceberPagar, ");
                    buf.append(" rpg.rpg_valortotal as valorTotalReceberPagar, ");
                    buf.append(" rpg.rpg_tipocadastro as tipoCadastro, ");
                    buf.append(" rpg.rpg_numerodocumento as numeroDocumentoReceberPagar, ");
                    buf.append(" rpg.rpg_codigodocumento as codigoDocumentoReceberPagar, ");
                    buf.append("CASE WHEN rpg.rpg_tipo = 'R' THEN rpg.rpg_valortotal ELSE rpg.rpg_valortotal * (-1) END as valorTotalReceberPagarComSinal, ");
                    buf.append(" CASE WHEN rpg.rpg_tipocadastro = '").append("P").append("' THEN rpg.pac_codigo ");
                    buf.append("      WHEN rpg.rpg_tipocadastro = '").append("O").append("' THEN rpg.con_codigo ");
                    buf.append("      ELSE rpg.ent_codigo END as codigoCadastro, ");
                    buf.append(" rpg.rpg_valortotal as valorReceberPagarPlano, ");
                    buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                    buf.append("  from planoconta a ");
                    buf.append("  left join (select lpc.*, ");
                    buf.append("                    lcx.lcx_tipo, ");
                    buf.append("                    lcx.lcx_tipopagamento, ");
                    buf.append("                    lcx.lcx_conta, ");
                    buf.append("                    lcx.lcx_documento, ");
                    buf.append("                    lcx.lcx_situacao, ");
                    buf.append("                    lcx.lcx_valor, ");
                    buf.append("                    lcx.lcx_valortotal, ");
                    buf.append("                    lcx.lcx_vencimento, ");
                    buf.append("                    lcx.lcx_competencia, ");
                    buf.append("                    lcx.lcx_datahora, ");
                    buf.append("                    lcx.lcx_conciliacao ");
                    buf.append("               from lanctocaixaplanoconta lpc, ");
                    buf.append("                    lanctocaixa lcx ");
                    buf.append("              where lcx.lcx_codigo = lpc.lcx_codigo ");
                    buf.append("                and lcx.fil_codigo = lpc.fil_codigo ");
                    buf.append("                and lcx.lcx_situacao <> '").append("C").append("' ");
                    buf.append(whereRpg.toString() + whereRpl.toString());
                    if (listaLanctoRP.size() > 0) {
                        buf.append(" and lpc.lcx_codigo NOT IN(");
                        for (int i4 = 0; i4 < listaLanctoRP.size(); ++i4) {
                            buf.append(listaLanctoRP.get(i4));
                            if (i4 >= listaLanctoRP.size() - 1) continue;
                            buf.append(", ");
                        }
                        buf.append(") ");
                    }
                    buf.append("            ) as lcx on (a.plc_reduzido = lcx.plc_reduzido and a.fil_codigo = lcx.fil_codigo) ");
                    buf.append(" left join (select rpg.*, ");
                    buf.append("                   blc.lcx_codigo ");
                    buf.append("              from baixareceberpagar brp ");
                    buf.append("              join receberpagar rpg on (brp.fil_codigo = rpg.fil_codigo and brp.rpg_codigo = rpg.rpg_codigo) ");
                    buf.append("              join baixa bxa on (brp.fil_codigo = bxa.fil_codigo and brp.bxa_codigo = bxa.bxa_codigo) ");
                    buf.append("              join baixalanctocaixa blc on (bxa.fil_codigo = blc.fil_codigo and bxa.bxa_codigo = blc.bxa_codigo)) as rpg on (lcx.fil_codigo = rpg.fil_codigo and lcx.lcx_codigo = rpg.lcx_codigo) ");
                    buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                    buf.append("where a.fil_codigo ");
                    if (filiais == null || filiais.length == 0) {
                        buf.append(" = ").append(Variaveis.filialPadrao);
                    } else {
                        buf.append(" in (");
                        for (int i5 = 0; i5 < filiais.length; ++i5) {
                            buf.append(filiais[i5]);
                            if (i5 >= filiais.length - 1) continue;
                            buf.append(", ");
                        }
                        buf.append(")");
                    }
                    if (planoconta != null) {
                        int i6;
                        buf.append(" and a.plc_reduzido in (");
                        ArrayList<Integer> arrayAux = new ArrayList<Integer>();
                        for (i = 0; i < planoconta.length; ++i) {
                            arrayAux.add(new Integer(planoconta[i]));
                        }
                        ArrayList<Integer> arrayAcima = this.getPlanosAcima((ArrayList)arrayAux.clone());
                        ArrayList<Integer> arrayAbaixo = this.getPlanosAbaixo((ArrayList)arrayAux.clone());
                        if (arrayAcima != null) {
                            for (i6 = 0; i6 < arrayAcima.size(); ++i6) {
                                if (arrayAux.contains(arrayAcima.get(i6))) continue;
                                arrayAux.add(arrayAcima.get(i6));
                            }
                        }
                        if (arrayAbaixo != null) {
                            for (i6 = 0; i6 < arrayAbaixo.size(); ++i6) {
                                if (arrayAux.contains(arrayAbaixo.get(i6))) continue;
                                arrayAux.add(arrayAbaixo.get(i6));
                            }
                        }
                        for (i6 = 0; i6 < arrayAux.size(); ++i6) {
                            buf.append(arrayAux.get(i6));
                            if (i6 >= arrayAux.size() - 1) continue;
                            buf.append(", ");
                        }
                        buf.append(")");
                    }
                    if (!this.getFiltroCombo(FILTRO_TIPO_PLANO).toString().equals(tipoPlanoConta[0])) {
                        combo = this.getFiltroCombo(FILTRO_TIPO_PLANO).toString();
                        buf.append(" and a.plc_tipo = '");
                        if (combo.equals(tipoPlanoConta[1])) {
                            buf.append("R");
                        } else if (combo.equals(tipoPlanoConta[2])) {
                            buf.append("D");
                        } else {
                            buf.append("C");
                        }
                        buf.append("'");
                    }
                    buf.append(" )");
                }
                buf.append(" order by contaPlanoConta, ");
                buf.append(CAMPOS_ORDEM[this.getFiltroComboIndice(FILTRO_ORDEM)]).append(", ");
                buf.append(CAMPOS_ORDEM_RECPAG[this.getFiltroComboIndice(FILTRO_ORDEM_RECPAG)]);
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    do {
                        arrayContas.adicionaConta(rs.getInt("reduzidoPlanoConta"), rs.getInt("paiPlanoConta"));
                    } while (rs.next());
                    rs.first();
                    do {
                        if (rs.getString("codigoLancamento") == null) continue;
                        arrayContas.somaValorConta(rs.getInt("reduzidoPlanoConta"), rs.getBigDecimal("valorLancamentoPlano"), rs.getBigDecimal("valorLancamentoPlanoComSinal"), rs.getInt("paiPlanoConta"), rs.getInt("codigoLancamento"), rs.getString("codigoOrigemLancamentoPlano"));
                    } while (rs.next());
                }
                rs.first();
                int posCampoReduzidoRelatorio = 0;
                for (int i7 = 0; i7 < this.camposRelatorio.length; ++i7) {
                    if (!this.camposRelatorio[i7].equals("reduzidoPlanoConta")) continue;
                    posCampoReduzidoRelatorio = i7;
                    break;
                }
                rs.beforeFirst();
                int reduzidoPlanoConta = -1;
                int codigoLancto = -1;
                String codigoOrigem = "";
                boolean imprimeLancto = false;
                boolean imprimeRecPag = false;
                if (rs.next()) {
                    int i8;
                    ModeloGridTable modelo = null;
                    modelo = new ModeloGridTable(this.camposRelatorio);
                    do {
                        int i9;
                        Object[] o = null;
                        o = new Object[this.camposRelatorio.length];
                        if (rs.getInt("nivelPlanoConta") == maiorNivel) {
                            if (reduzidoPlanoConta == -1) {
                                imprimeLancto = false;
                            } else if (reduzidoPlanoConta == rs.getInt("reduzidoPlanoConta")) {
                                imprimeLancto = true;
                            } else {
                                imprimeLancto = false;
                                imprimeRecPag = false;
                            }
                            reduzidoPlanoConta = rs.getInt("reduzidoPlanoConta");
                            if (codigoLancto == 0) {
                                codigoLancto = -1;
                                continue;
                            }
                            if (codigoLancto != rs.getInt("codigoLancamento") || !codigoOrigem.equalsIgnoreCase(rs.getString("codigoOrigemLancamentoPlano"))) {
                                imprimeRecPag = false;
                                codigoLancto = -1;
                                codigoOrigem = "";
                            }
                            if (imprimeLancto && !imprimeRecPag) {
                                for (i9 = 0; i9 < camposLancamento.length; ++i9) {
                                    if (camposLancamento[i9].equals("tipoPagamentoLancamento")) {
                                        o[modelo.findColumn((String)RelatorioLancamentoPlanoDetalhado.camposLancamento[i9])] = Tipos.tipoPagamento(rs.getString(camposLancamento[i9]));
                                        continue;
                                    }
                                    if (camposLancamento[i9].equals("tipoLancamento")) {
                                        if (rs.getString(camposLancamento[i9]) != null) {
                                            o[modelo.findColumn((String)RelatorioLancamentoPlanoDetalhado.camposLancamento[i9])] = Tipos.tipoLancamentoCaixa(rs.getString(camposLancamento[i9]));
                                            continue;
                                        }
                                        o[modelo.findColumn((String)RelatorioLancamentoPlanoDetalhado.camposLancamento[i9])] = "";
                                        continue;
                                    }
                                    if (this.camposRelatorio[i9].equalsIgnoreCase("situacaoLancamento")) {
                                        if (rs.getString(this.camposRelatorio[i9]) != null) {
                                            o[modelo.findColumn((String)this.camposRelatorio[i9])] = Tipos.tipoSituacaoLancamento(rs.getString(this.camposRelatorio[i9]));
                                            continue;
                                        }
                                        o[modelo.findColumn((String)this.camposRelatorio[i9])] = null;
                                        continue;
                                    }
                                    o[modelo.findColumn((String)RelatorioLancamentoPlanoDetalhado.camposLancamento[i9])] = rs.getObject(camposLancamento[i9]);
                                }
                                imprimeRecPag = true;
                                codigoLancto = rs.getInt("codigoLancamento");
                                codigoOrigem = rs.getString("codigoOrigemLancamentoPlano");
                                rs.previous();
                            } else if (imprimeRecPag) {
                                for (i9 = 0; i9 < this.camposRelatorio.length; ++i9) {
                                    if (!ArraysUtil.contem(camposRecPag, this.camposRelatorio[i9])) continue;
                                    if (this.camposRelatorio[i9].equals("tipoDocumentoReceberPagar")) {
                                        o[modelo.findColumn((String)this.camposRelatorio[i9])] = Tipos.tipoDocumento(rs.getString(this.camposRelatorio[i9]));
                                        continue;
                                    }
                                    if (this.camposRelatorio[i9].equals("tipoReceberPagar")) {
                                        if (rs.getString(this.camposRelatorio[i9]) != null) {
                                            o[modelo.findColumn((String)this.camposRelatorio[i9])] = Tipos.tipoReceberPagar(rs.getString(this.camposRelatorio[i9]));
                                            continue;
                                        }
                                        o[modelo.findColumn((String)this.camposRelatorio[i9])] = "";
                                        continue;
                                    }
                                    if (this.camposRelatorio[i9].equals("tipoCadastro")) {
                                        if (rs.getString(this.camposRelatorio[i9]) != null) {
                                            o[modelo.findColumn((String)this.camposRelatorio[i9])] = Tipos.tipoCadastro(rs.getString(this.camposRelatorio[i9]));
                                            continue;
                                        }
                                        o[modelo.findColumn((String)this.camposRelatorio[i9])] = "";
                                        continue;
                                    }
                                    o[modelo.findColumn((String)this.camposRelatorio[i9])] = rs.getObject(this.camposRelatorio[i9]);
                                }
                                if (rs.getString("tipoCadastro") != null) {
                                    this.pegaDadosCadastro(st2, o, modelo, rs.getString("tipoCadastro"), rs.getInt("codigoFilial"), rs.getInt("codigoCadastro"));
                                }
                            } else {
                                for (i9 = 0; i9 < this.camposRelatorio.length; ++i9) {
                                    if (this.camposRelatorio[i9].equals("tipoPlanoConta")) {
                                        o[modelo.findColumn((String)this.camposRelatorio[i9])] = Tipos.tipoPlanoContas(rs.getString(this.camposRelatorio[i9]));
                                        continue;
                                    }
                                    if (this.camposRelatorio[i9].equals("totalPlanoConta")) {
                                        if (arrayContas == null) continue;
                                        o[modelo.findColumn((String)this.camposRelatorio[i9])] = arrayContas.getValorConta(rs.getInt(this.camposRelatorio[posCampoReduzidoRelatorio]));
                                        continue;
                                    }
                                    if (this.camposRelatorio[i9].equals("totalPlanoContaComSinal")) {
                                        if (arrayContas == null) continue;
                                        o[modelo.findColumn((String)this.camposRelatorio[i9])] = arrayContas.getValorContaComSinal(rs.getInt(this.camposRelatorio[posCampoReduzidoRelatorio]));
                                        continue;
                                    }
                                    if (this.camposRelatorio[i9].equals("valorSomatorio") || this.camposRelatorio[i9].equals("valorSomatorioComSinal") || ArraysUtil.contem(camposRecPag, this.camposRelatorio[i9]) || ArraysUtil.contem(camposLancamento, this.camposRelatorio[i9]) || ArraysUtil.contem(camposCadastros, this.camposRelatorio[i9])) continue;
                                    o[modelo.findColumn((String)this.camposRelatorio[i9])] = rs.getObject(this.camposRelatorio[i9]);
                                }
                                if (rs.getString("codigoLancamento") != null && !Funcoes.textoVazio(rs.getString("codigoLancamento"))) {
                                    rs.previous();
                                } else if (rs.next()) {
                                    if (reduzidoPlanoConta == rs.getInt("reduzidoPlanoConta")) {
                                        rs.previous();
                                    }
                                    rs.previous();
                                }
                            }
                        } else {
                            for (i9 = 0; i9 < this.camposRelatorio.length; ++i9) {
                                if (this.camposRelatorio[i9].equals("tipoPlanoConta")) {
                                    o[modelo.findColumn((String)this.camposRelatorio[i9])] = Tipos.tipoPlanoContas(rs.getString(this.camposRelatorio[i9]));
                                    continue;
                                }
                                if (this.camposRelatorio[i9].equals("totalPlanoConta")) {
                                    if (arrayContas == null) continue;
                                    o[modelo.findColumn((String)this.camposRelatorio[i9])] = arrayContas.getValorConta(rs.getInt(this.camposRelatorio[posCampoReduzidoRelatorio]));
                                    continue;
                                }
                                if (this.camposRelatorio[i9].equals("totalPlanoContaComSinal")) {
                                    if (arrayContas == null) continue;
                                    o[modelo.findColumn((String)this.camposRelatorio[i9])] = arrayContas.getValorContaComSinal(rs.getInt(this.camposRelatorio[posCampoReduzidoRelatorio]));
                                    continue;
                                }
                                if (this.camposRelatorio[i9].equals("valorSomatorio") || this.camposRelatorio[i9].equals("valorSomatorioComSinal") || this.camposRelatorio[i9].equalsIgnoreCase("dataVencimentoLancamentoBaixa") || this.camposRelatorio[i9].equalsIgnoreCase("dataCompetenciaLancamentoBaixa") || this.camposRelatorio[i9].equalsIgnoreCase("dataConciliacaoLancamentoBaixa") || this.camposRelatorio[i9].equalsIgnoreCase("codigoBaixa") || this.camposRelatorio[i9].equalsIgnoreCase("situacaoLancamentoBaixa")) continue;
                                if (this.camposRelatorio[i9].equalsIgnoreCase("tipoLancamento")) {
                                    if (rs.getString(this.camposRelatorio[i9]) != null) {
                                        o[modelo.findColumn((String)this.camposRelatorio[i9])] = Tipos.tipoLancamentoCaixa(rs.getString(this.camposRelatorio[i9]));
                                        continue;
                                    }
                                    o[modelo.findColumn((String)this.camposRelatorio[i9])] = null;
                                    continue;
                                }
                                if (this.camposRelatorio[i9].equalsIgnoreCase("tipoReceberPagar")) {
                                    if (rs.getString(this.camposRelatorio[i9]) != null) {
                                        o[modelo.findColumn((String)this.camposRelatorio[i9])] = Tipos.tipoReceberPagar(rs.getString(this.camposRelatorio[i9]));
                                        continue;
                                    }
                                    o[modelo.findColumn((String)this.camposRelatorio[i9])] = null;
                                    continue;
                                }
                                if (this.camposRelatorio[i9].equalsIgnoreCase("situacaoLancamento")) {
                                    if (rs.getString(this.camposRelatorio[i9]) != null) {
                                        o[modelo.findColumn((String)this.camposRelatorio[i9])] = Tipos.tipoSituacaoLancamento(rs.getString(this.camposRelatorio[i9]));
                                        continue;
                                    }
                                    o[modelo.findColumn((String)this.camposRelatorio[i9])] = null;
                                    continue;
                                }
                                if (this.camposRelatorio[i9].equalsIgnoreCase("situacaoReceberPagar")) {
                                    if (rs.getString(this.camposRelatorio[i9]) != null) {
                                        o[modelo.findColumn((String)this.camposRelatorio[i9])] = Tipos.tipoSituacaoReceberPagar(rs.getString(this.camposRelatorio[i9]));
                                        continue;
                                    }
                                    o[modelo.findColumn((String)this.camposRelatorio[i9])] = null;
                                    continue;
                                }
                                if (ArraysUtil.contem(camposCadastros, this.camposRelatorio[i9])) continue;
                                o[modelo.findColumn((String)this.camposRelatorio[i9])] = rs.getObject(this.camposRelatorio[i9]);
                            }
                            imprimeLancto = false;
                            reduzidoPlanoConta = -1;
                        }
                        modelo.addLine(o);
                    } while (rs.next());
                    for (i8 = 0; i8 < modelo.getRowCount(); ++i8) {
                        if (arrayContas == null) continue;
                        modelo.setValueAt(arrayContas.somatorioPlanoConta, i8, modelo.findColumn("valorSomatorio"));
                    }
                    for (i8 = 0; i8 < modelo.getRowCount(); ++i8) {
                        if (arrayContas == null) continue;
                        modelo.setValueAt(arrayContas.somatorioPlanoContaComSinal, i8, modelo.findColumn("valorSomatorioComSinal"));
                    }
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(RelatorioLancamentoPlanoDetalhado.getModuloAcesso());
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        int i10;
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(1.0f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioLancamentoPlanoDetalhado.this.panelCentro.removeAll();
                                RelatorioLancamentoPlanoDetalhado.this.panelCentro.repaint();
                                RelatorioLancamentoPlanoDetalhado.this.habilitaBotaoImprimir(true);
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put(FILTRO_DATA_INICIAL, this.getFiltroData(FILTRO_DATA_INICIAL));
                        var.put(FILTRO_DATA_FINAL, this.getFiltroData(FILTRO_DATA_FINAL));
                        var.put(FILTRO_VALOR_INICIAL, this.getFiltroDecimal(FILTRO_VALOR_INICIAL));
                        var.put(FILTRO_VALOR_FINAL, this.getFiltroDecimal(FILTRO_VALOR_FINAL));
                        var.put(FILTRO_TIPO_PLANO, this.getFiltroCombo(FILTRO_TIPO_PLANO));
                        var.put(FILTRO_CAMPO_DATA, this.getFiltroCombo(FILTRO_CAMPO_DATA));
                        var.put(FILTRO_SITUACAO, this.getFiltroCombo(FILTRO_SITUACAO) == null ? "Todos" : this.getFiltroCombo(FILTRO_SITUACAO));
                        var.put(FILTRO_TIPO, this.getFiltroCombo(FILTRO_TIPO) == null ? "Todos" : this.getFiltroCombo(FILTRO_TIPO));
                        var.put(FILTRO_ORDEM, this.getFiltroCombo(FILTRO_ORDEM));
                        var.put(FILTRO_ORDEM_RECPAG, this.getFiltroCombo(FILTRO_ORDEM_RECPAG));
                        var.put(FILTRO_CODIGO_DOCUMENTO, codigoDocumento);
                        var.put(FILTRO_NUMERO_DOCUMENTO, numeroDocumento);
                        buf.delete(0, buf.length());
                        if (filiais != null) {
                            for (i10 = 0; i10 < filiais.length; ++i10) {
                                buf.append(filiais[i10]);
                                if (i10 >= filiais.length - 1) continue;
                                buf.append(", ");
                            }
                        } else {
                            buf.append(Variaveis.filialPadrao);
                        }
                        var.put(FILTRO_FILIAL_PLANO_CONTA, buf.toString());
                        buf.delete(0, buf.length());
                        if (usuario != null) {
                            for (i10 = 0; i10 < usuario.length; ++i10) {
                                buf.append(usuario[i10]);
                                if (i10 >= usuario.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put(FILTRO_USUARIO, buf.toString());
                        buf.delete(0, buf.length());
                        if (planoconta != null) {
                            for (i10 = 0; i10 < planoconta.length; ++i10) {
                                buf.append(planoconta[i10]);
                                if (i10 >= planoconta.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put(FILTRO_PLANO_CONTA, buf.toString());
                        buf.delete(0, buf.length());
                        if (origem != null) {
                            for (i10 = 0; i10 < origem.length; ++i10) {
                                buf.append(origem[i10]);
                                if (i10 >= origem.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put(FILTRO_ORIGEM, buf.toString());
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelCentro.revalidate();
                    }
                    break block125;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st, st2);
                    throw throwable;
                }
                Conexao.fecharStatement(st, st2);
            }
        }
        Conexao.fecharStatement(st, st2);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private ArrayList<Integer> getPlanosAcima(ArrayList<Integer> planos) {
        Statement st = Conexao.getStatement();
        ArrayList<Integer> resultado = new ArrayList<Integer>();
        StringBuilder planosSql = null;
        StringBuilder buf = null;
        while (planos != null) {
            planosSql = new StringBuilder();
            for (int i = 0; i < planos.size() && planos != null; ++i) {
                planosSql.append(planos.get(i));
                if (i >= planos.size() - 1) continue;
                planosSql.append(", ");
            }
            buf = new StringBuilder();
            buf.append(" select plc_pai ");
            buf.append("   from planoconta ");
            buf.append("  where plc_reduzido IN (").append((CharSequence)planosSql).append(") ");
            buf.append("    and fil_codigo = ").append(Variaveis.filialPadrao);
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (planos != null) {
                    planos.clear();
                }
                if (rs.next()) {
                    do {
                        if (rs.getString("plc_pai") == null || resultado.contains(rs.getInt("plc_pai"))) continue;
                        resultado.add(rs.getInt("plc_pai"));
                        if (planos == null) continue;
                        planos.add(rs.getInt("plc_pai"));
                    } while (rs.next());
                } else {
                    planos = null;
                }
            }
            catch (SQLException e) {
                break;
            }
            if (planos == null || planos.size() != 0) continue;
            planos = null;
        }
        Conexao.fecharStatement(st);
        if (resultado.size() == 0) {
            return null;
        }
        return resultado;
    }

    private ArrayList<Integer> getPlanosAbaixo(ArrayList<Integer> planos) {
        Statement st = Conexao.getStatement();
        ArrayList<Integer> resultado = new ArrayList<Integer>();
        StringBuilder planosSql = null;
        StringBuilder buf = null;
        while (planos != null) {
            planosSql = new StringBuilder();
            for (int i = 0; i < planos.size() && planos != null; ++i) {
                planosSql.append(planos.get(i));
                if (i >= planos.size() - 1) continue;
                planosSql.append(", ");
            }
            buf = new StringBuilder();
            buf.append(" select plc_reduzido ");
            buf.append("   from planoconta ");
            buf.append("  where plc_pai IN (").append((CharSequence)planosSql).append(") ");
            buf.append("    and fil_codigo = ").append(Variaveis.filialPadrao);
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (planos != null) {
                    planos.clear();
                }
                if (rs.next()) {
                    do {
                        if (rs.getString("plc_reduzido") == null || resultado.contains(rs.getInt("plc_reduzido"))) continue;
                        resultado.add(rs.getInt("plc_reduzido"));
                        if (planos == null) continue;
                        planos.add(rs.getInt("plc_reduzido"));
                    } while (rs.next());
                } else {
                    planos = null;
                }
            }
            catch (SQLException e) {
                break;
            }
            if (planos == null || planos.size() != 0) continue;
            planos = null;
        }
        Conexao.fecharStatement(st);
        if (resultado.size() == 0) {
            return null;
        }
        return resultado;
    }

    private void pegaDadosCadastro(Statement st, Object[] array, ModeloGridTable modelo, String tipo, int filial, int codigo) throws SQLException {
        StringBuilder buf = new StringBuilder();
        if (tipo.equalsIgnoreCase("P")) {
            buf.append("select ");
            buf.append("\tpac.pac_codigo as codigoCadastro, pac.pac_nome as fantasiaCadastro,pac.pac_nomesocial as nomeSocialPaciente, pac.pac_nome as razaoSocialCadastro, pac.pac_fone as foneCadastro, ");
            buf.append("\tpac.pac_endereco as enderecoCadastro, pac.pac_numeroendereco as numeroEnderecoCadastro, pac.pac_tipologradouroendereco as tipoLogradouroCadastro, ");
            buf.append("\tpac.pac_fax as faxCadastro, pac.pac_complemento as complementoCadastro, pac.pac_cep as cepCadastro, ");
            buf.append("\tpac.cid_codigo as codigoCidadeCadastro, cidpac.cid_nome as nomeCidadeCadastro ");
            buf.append("from paciente pac ");
            buf.append("\tleft join cidades cidpac on pac.fil_codigo = cidpac.fil_codigo and pac.cid_codigo = cidpac.cid_codigo ");
            buf.append("where pac.fil_codigo = ").append(filial);
            buf.append(" and pac.pac_codigo = ").append(codigo);
        } else if (tipo.equalsIgnoreCase("O")) {
            buf.append("select ");
            buf.append("\tcon.con_codigo as codigoCadastro, con.con_fantasia as fantasiaCadastro, con.con_razao as razaoSocialCadastro, con.con_fone as foneCadastro, ");
            buf.append("\tcon.con_endereco as enderecoCadastro, con.con_numeroendereco as numeroEnderecoCadastro, con.con_tipologradouroendereco as tipoLogradouroCadastro, ");
            buf.append("\tcon.con_fax as faxCadastro, con.con_complemento as complementoCadastro, con.con_cep as cepCadastro, ");
            buf.append("\tcon.cid_codigo as codigoCidadeCadastro, cidcon.cid_nome as nomeCidadeCadastro, '' as nomeSocialPaciente ");
            buf.append("from convenios con ");
            buf.append("\tleft join cidades cidcon on con.fil_codigo = cidcon.fil_codigo and con.cid_codigo = cidcon.cid_codigo ");
            buf.append("where con.fil_codigo = ").append(filial);
            buf.append(" and con.con_codigo = ").append(codigo);
        } else {
            buf.append("select ");
            buf.append("\tent.ent_codigo as codigoCadastro, ent.ent_fantasia as fantasiaCadastro, ent.ent_razaosocial as razaoSocialCadastro, ent.ent_fone as foneCadastro, ");
            buf.append("\tent.ent_endereco as enderecoCadastro, ent.ent_numeroendereco as numeroEnderecoCadastro, ent.ent_tipologradouroendereco as tipoLogradouroCadastro, ");
            buf.append("\tent.ent_fax as faxCadastro, ent.ent_complemento as complementoCadastro, ent.ent_cep as cepCadastro, ");
            buf.append("\tent.cid_codigo as codigoCidadeCadastro, cident.cid_nome as nomeCidadeCadastro, '' as nomeSocialPaciente ");
            buf.append("from entidade ent ");
            buf.append("\tleft join cidades cident on ent.fil_codigo = cident.fil_codigo and ent.cid_codigo = cident.cid_codigo ");
            buf.append("where ent.fil_codigo = ").append(filial);
            buf.append(" and ent.ent_codigo = ").append(codigo);
        }
        ResultSet rs = Conexao.executeQuery(st, buf);
        if (rs.next()) {
            int pos = -1;
            for (String s : camposCadastros) {
                if (rs.findColumn(s) <= 0 || modelo.findColumn(s) <= -1) continue;
                pos = modelo.findColumn(s);
                array[modelo.findColumn((String)s)] = modelo.getColumnName(pos).equalsIgnoreCase("tipoLogradouroCadastro") ? Tipos.tipoLogradouroDescricao(rs.getString(s)) : rs.getObject(s);
            }
        }
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0850802200");
    }

    public static long getConfigurarAcesso() {
        return Long.parseLong("0850802201");
    }

    public class ArrayValoresPlanoConta {
        private ArrayList<ValorLanctoPlano> arrayLancamentos;
        private ArrayList<Integer> reduzidoPlanoConta = new ArrayList();
        private ArrayList<Integer> paiPlanoConta = new ArrayList();
        private ArrayList<BigDecimal> valorPlanoConta = new ArrayList();
        private ArrayList<BigDecimal> valorPlanoContaComSinal = new ArrayList();
        public BigDecimal somatorioPlanoConta = null;
        public BigDecimal somatorioPlanoContaComSinal = null;

        public ArrayValoresPlanoConta() {
            this.arrayLancamentos = new ArrayList();
            this.somatorioPlanoConta = BigDecimal.ZERO;
            this.somatorioPlanoContaComSinal = BigDecimal.ZERO;
        }

        public void adicionaConta(int reduzidoPlanoConta, int paiPlanoConta) {
            if (this.getPosicaoConta(reduzidoPlanoConta) != -1) {
                return;
            }
            this.reduzidoPlanoConta.add(reduzidoPlanoConta);
            this.paiPlanoConta.add(paiPlanoConta);
            this.valorPlanoConta.add(BigDecimal.ZERO);
            this.valorPlanoContaComSinal.add(BigDecimal.ZERO);
        }

        private int getPosicaoConta(int conta) {
            if (conta == -1) {
                return -1;
            }
            for (int i = 0; i < this.reduzidoPlanoConta.size(); ++i) {
                if (this.reduzidoPlanoConta.get(i) != conta) continue;
                return i;
            }
            return -1;
        }

        private int getPaiConta(int conta) {
            if (conta == -1) {
                return -1;
            }
            for (int i = 0; i < this.reduzidoPlanoConta.size(); ++i) {
                if (this.reduzidoPlanoConta.get(i) != conta) continue;
                return this.paiPlanoConta.get(i);
            }
            return -1;
        }

        private void setContaValorPosicao(int posicao, int reduzidoPlanoConta, int paiPlanoConta, BigDecimal valorPlanoConta, BigDecimal valorPlanoContaComSinal) {
            if (posicao == -1) {
                return;
            }
            if (paiPlanoConta != 0) {
                this.setContaValorPosicao(this.getPosicaoConta(paiPlanoConta), paiPlanoConta, this.getPaiConta(paiPlanoConta), valorPlanoConta, valorPlanoContaComSinal);
            } else {
                this.somatorioPlanoConta = this.somatorioPlanoConta.add(valorPlanoConta);
                this.somatorioPlanoContaComSinal = this.somatorioPlanoContaComSinal.add(valorPlanoContaComSinal);
            }
            this.valorPlanoConta.set(posicao, valorPlanoConta.add(this.getValorConta(reduzidoPlanoConta)));
            this.valorPlanoContaComSinal.set(posicao, valorPlanoContaComSinal.add(this.getValorContaComSinal(reduzidoPlanoConta)));
        }

        public BigDecimal getValorConta(int reduzidoPlanoConta) {
            for (int i = 0; i < this.reduzidoPlanoConta.size(); ++i) {
                if (this.reduzidoPlanoConta.get(i) == -1 || this.reduzidoPlanoConta.get(i) != reduzidoPlanoConta) continue;
                return this.valorPlanoConta.get(i);
            }
            return BigDecimal.ZERO;
        }

        public BigDecimal getValorContaComSinal(int reduzidoPlanoConta) {
            for (int i = 0; i < this.reduzidoPlanoConta.size(); ++i) {
                if (this.reduzidoPlanoConta.get(i) == -1 || this.reduzidoPlanoConta.get(i) != reduzidoPlanoConta) continue;
                return this.valorPlanoContaComSinal.get(i);
            }
            return BigDecimal.ZERO;
        }

        public void somaValorConta(int reduzidoPlanoConta, BigDecimal valorAdicionar, BigDecimal valorAdicionarComSinal, int paiPlanoConta, int codigoLancamento, String codigoOrigem) {
            if (valorAdicionar == null) {
                valorAdicionar = BigDecimal.ZERO;
            }
            if (valorAdicionarComSinal == null) {
                valorAdicionarComSinal = BigDecimal.ZERO;
            }
            ValorLanctoPlano valorLancto = new ValorLanctoPlano(reduzidoPlanoConta, codigoLancamento, codigoOrigem);
            if (codigoLancamento != -1) {
                if (this.arrayLancamentos.contains(valorLancto)) {
                    return;
                }
                this.arrayLancamentos.add(valorLancto);
            }
            this.setContaValorPosicao(this.getPosicaoConta(reduzidoPlanoConta), reduzidoPlanoConta, paiPlanoConta, valorAdicionar, valorAdicionarComSinal);
        }

        class ValorLanctoPlano {
            int reduzidoPlano = -1;
            int codigoLancto = -1;
            String codigoOrigem = "";

            public ValorLanctoPlano(int reduzidoPlano, int codigoLancto, String codigoOrigem) {
                this.reduzidoPlano = reduzidoPlano;
                this.codigoLancto = codigoLancto;
                this.codigoOrigem = codigoOrigem;
            }

            public boolean equals(Object obj) {
                if (obj instanceof ValorLanctoPlano) {
                    return ((ValorLanctoPlano)obj).reduzidoPlano == this.reduzidoPlano && ((ValorLanctoPlano)obj).codigoLancto == this.codigoLancto && ((ValorLanctoPlano)obj).codigoOrigem.equalsIgnoreCase(this.codigoOrigem);
                }
                return false;
            }
        }
    }
}

