/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.movimento;

import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioLancamentoCentroDetalhado
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private static final String[] ORDEM = new String[]{"C\u00f3digo", "Documento", "Dt. Cadastro", "Dt. Vencimento", "Valor"};
    private static final String[] CAMPOS_ORDEM = new String[]{"codigoLancamento", "documentoLancamento", "emissaoLancamento", "vencimentoLancamento", "valorLancamentoCentroComSinal"};
    private static final String[] ORDEMRECPAG = new String[]{"C\u00f3digo", "N\u00famero Doc.", "C\u00f3digo Doc.", "Valor Total"};
    private static final String[] CAMPOS_ORDEM_RECPAG = new String[]{"codigoReceberPagar", "numeroDocumentoReceberPagar", "codigoDocumentoReceberPagar", "valorTotalReceberPagar"};
    private static final String[] SITUACAOLANCTO = new String[]{"Todos", Tipos.tipoSituacaoLancamento("A"), Tipos.tipoSituacaoLancamento("O")};
    private static final String[] TIPOLANCTO = new String[]{"Todos", Tipos.tipoLancamentoCaixa("C"), Tipos.tipoLancamentoCaixa("D")};
    private static final String FILTRO_CENTRO_CUSTO = "filtroCentroCusto";
    private static final String FILTRO_FILIAL_CENTRO_CUSTO = "filtroFilialCentroCusto";
    private static final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private static final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private static final String FILTRO_VALOR_INICIAL = "filtroValorInicial";
    private static final String FILTRO_VALOR_FINAL = "filtroValorFinal";
    private static final String FILTRO_USUARIO = "filtroUsuario";
    private static final String FILTRO_ORIGEM = "filtroOrigem";
    private static final String FILTRO_CAMPO_DATA = "filtroData";
    private static final String FILTRO_ORDEM = "filtroOrdem";
    private static final String FILTRO_ORDEM_RECPAG = "filtroOrdemRecPag";
    private static final String FILTRO_SITUACAO = "filtroSituacao";
    private static final String FILTRO_TIPO = "filtroTipo";
    private static final String FILTRO_CODIGO_DOCUMENTO = "filtroCodigoDocumento";
    private static final String FILTRO_NUMERO_DOCUMENTO = "filtroNumeroDocumento";
    private static final String[] CAMPOSDATALANCTO = new String[]{"Vencimento", "Compet\u00eancia", "Cadastro", "Concilia\u00e7\u00e3o"};
    private static final String[] CAMPOSDATABANCOLANCTO = new String[]{"lcx_vencimento", "lcx_competencia", "lcx_datahora", "lcx_conciliacao"};
    private String[] camposRelatorio = Constantes.CAMPOS_FILIAL;
    private static final String[] camposCentroCusto = new String[]{"reduzidoCentroCusto", "descricaoCentroCusto", "contaCentroCusto", "filialCentroCusto", "nivelCentroCusto", "paiCentroCusto", "totalCentroCusto", "valorSomatorio", "totalCentroCustoComSinal", "valorSomatorioComSinal", "operacaoCentroCusto"};
    private static final String[] camposLancamento = new String[]{"codigoLancamento", "tipoPagamentoLancamento", "contaLancamento", "documentoLancamento", "valorLancamento", "valorTotalLancamento", "vencimentoLancamento", "tipoLancamento", "valorLancamentoCentro", "codigoOrigemLancamentoCentro", "competenciaLancamento", "conciliacaoLancamento", "emissaoLancamento", "valorLancamentoCentroComSinal", "situacaoLancamento"};
    private static final String[] camposRecPag = new String[]{"codigoReceberPagar", "vencimentoReceberPagar", "tipoReceberPagar", "tipoCadastro", "tipoDocumentoReceberPagar", "numeroDocumentoReceberPagar", "codigoDocumentoReceberPagar", "parcelaReceberPagar", "dataDocumentoReceberPagar", "dataProcessamentoReceberPagar", "codigoSerieReceberPagar", "situacaoReceberPagar", "valorReceberPagar", "valorTotalReceberPagar", "dataHoraReceberPagar", "competenciaReceberPagar", "valorTotalReceberPagarComSinal", "valorReceberPagarCentro"};
    private static final String[] camposCadastros = new String[]{"codigoCadastro", "fantasiaCadastro", "nomeSocialPaciente", "razaoSocialCadastro", "foneCadastro", "enderecoCadastro", "numeroEnderecoCadastro", "faxCadastro", "complementoCadastro", "cepCadastro", "codigoCidadeCadastro", "nomeCidadeCadastro", "tipoLogradouroCadastro"};

    public RelatorioLancamentoCentroDetalhado() {
        this.montaBarraDescricao("Relat\u00f3rio de Lan\u00e7amento por Centro de Custo Detalhado", "Lan\u00e7amentos e t\u00edtulos associados nos centros de custo", "relatorios/rel_lancamento_por_centro_custo.jpg");
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro(FILTRO_FILIAL_CENTRO_CUSTO, "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_USUARIO, "Usu\u00e1rio", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_CENTRO_CUSTO, "Centro Custo", "centrocusto", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"ccu_reduzido", "ccu_conta", "ccu_descricao"}, new String[]{"C\u00f3digo", "Centro", "Descri\u00e7\u00e3o"}, new int[]{70, 120, 0});
        this.adicionaItemFiltro(FILTRO_ORIGEM, "Origem", "origemplanocusto", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"opc_codigo", "opc_descricao", "opc_padrao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Padr\u00e3o"}, new int[]{70, 0, 50});
        this.adicionaFiltroCombo(FILTRO_CAMPO_DATA, "Campo Data:", CAMPOSDATALANCTO, 0);
        this.adicionaFiltroData(FILTRO_DATA_INICIAL, "Data inicial:");
        this.adicionaFiltroData(FILTRO_DATA_FINAL, "Data final:");
        this.adicionaFiltroDecimal(FILTRO_VALOR_INICIAL, "Valor Inicial:", 0);
        this.adicionaFiltroDecimal(FILTRO_VALOR_FINAL, "Valor Final:", 0);
        this.adicionaFiltroTexto(FILTRO_CODIGO_DOCUMENTO, "C\u00f3digo Doc.", 40);
        this.adicionaFiltroTexto(FILTRO_NUMERO_DOCUMENTO, "N\u00famero Doc.", 40);
        this.adicionaFiltroCombo(FILTRO_SITUACAO, "Situa\u00e7\u00e3o:", SITUACAOLANCTO, 0);
        this.adicionaRetornaFiltroCombo(FILTRO_TIPO, "Tipo:", TIPOLANCTO, 0);
        this.adicionaFiltroCombo(FILTRO_ORDEM, "Ordem:", ORDEM, 0);
        this.adicionaFiltroCombo(FILTRO_ORDEM_RECPAG, "Ordem T\u00edt.:", ORDEMRECPAG, 0);
        this.setModuloConfigurar(RelatorioLancamentoCentroDetalhado.getConfigurarAcesso());
        this.setModuloAcesso(RelatorioLancamentoCentroDetalhado.getModuloAcesso());
        this.camposRelatorio = ArraysUtil.concatenar(ArraysUtil.concatenar(ArraysUtil.concatenar(ArraysUtil.concatenar(this.camposRelatorio, camposCentroCusto), camposLancamento), camposRecPag), camposCadastros);
        this.setCamposConfigurador(this.camposRelatorio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement st2;
        Statement st;
        block112: {
            String[] filiais;
            String[] origem;
            String numeroDocumento;
            String codigoDocumento;
            String[] usuario;
            StringBuilder whereRpl;
            StringBuilder whereRpg;
            block111: {
                String combo;
                st = Conexao.getStatement();
                st2 = Conexao.getStatement();
                whereRpg = new StringBuilder();
                whereRpl = new StringBuilder();
                if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_INICIAL))) {
                    whereRpg.append(" and cast(lcx." + CAMPOSDATABANCOLANCTO[this.getFiltroComboIndice(FILTRO_CAMPO_DATA)] + " as date) >= '");
                    whereRpg.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_INICIAL)));
                    whereRpg.append("'");
                }
                if (Funcoes.verificaData(this.getFiltroData(FILTRO_DATA_FINAL))) {
                    whereRpg.append(" and cast(lcx." + CAMPOSDATABANCOLANCTO[this.getFiltroComboIndice(FILTRO_CAMPO_DATA)] + " as date) <= '");
                    whereRpg.append(Funcoes.formataData("yyyy-MM-dd", this.getFiltroData(FILTRO_DATA_FINAL)));
                    whereRpg.append("'");
                }
                if (!Funcoes.textoVazio(this.getFiltroDecimal(FILTRO_VALOR_INICIAL))) {
                    whereRpl.append(" and lcx.lcx_valortotal >= ");
                    whereRpl.append(this.getFiltroTexto(FILTRO_VALOR_INICIAL));
                    whereRpl.append(" ");
                }
                if (!Funcoes.textoVazio(this.getFiltroDecimal(FILTRO_VALOR_FINAL))) {
                    whereRpl.append(" and lcx.lcx_valortotal <= ");
                    whereRpl.append(this.getFiltroTexto(FILTRO_VALOR_FINAL));
                    whereRpl.append(" ");
                }
                if ((usuario = this.getSelecionadosFiltro(FILTRO_USUARIO, 0)) != null) {
                    whereRpg.append(" and (lcx.usr_codigo in (");
                    for (int i = 0; i < usuario.length; ++i) {
                        whereRpg.append("'");
                        whereRpg.append(usuario[i]);
                        whereRpg.append("'");
                        if (i >= usuario.length - 1) continue;
                        whereRpg.append(", ");
                    }
                    whereRpg.append(") OR lcx.usr_codigo IS NULL)");
                }
                if ((combo = this.getFiltroCombo(FILTRO_SITUACAO).toString()).equals(SITUACAOLANCTO[0])) {
                    whereRpg.append(" and lcx.lcx_situacao IN('");
                    whereRpg.append("A").append("', '").append("O");
                    whereRpg.append("') ");
                } else {
                    whereRpg.append(" and lcx.lcx_situacao = '");
                    if (combo.equals(SITUACAOLANCTO[1])) {
                        whereRpg.append("A");
                    } else {
                        whereRpg.append("O");
                    }
                    whereRpg.append("' ");
                }
                combo = this.getFiltroCombo(FILTRO_TIPO).toString();
                if (combo.equals(TIPOLANCTO[0])) {
                    whereRpg.append(" and lcx.lcx_tipo IN('");
                    whereRpg.append("C").append("', '").append("D");
                    whereRpg.append("') ");
                } else {
                    whereRpg.append(" and lcx.lcx_tipo = '");
                    if (combo.equals(TIPOLANCTO[1])) {
                        whereRpg.append("C");
                    } else {
                        whereRpg.append("D");
                    }
                    whereRpg.append("' ");
                }
                codigoDocumento = this.getFiltroTexto(FILTRO_CODIGO_DOCUMENTO);
                if (codigoDocumento.length() > 0) {
                    whereRpg.append(" and rpg.rpg_codigodocumento ilike '%").append(this.getFiltroTexto(FILTRO_CODIGO_DOCUMENTO)).append("%' ");
                }
                if ((numeroDocumento = this.getFiltroTexto(FILTRO_NUMERO_DOCUMENTO)).length() > 0) {
                    whereRpg.append(" and rpg.rpg_numerodocumento ilike '%").append(this.getFiltroTexto(FILTRO_NUMERO_DOCUMENTO)).append("%' ");
                }
                if ((origem = this.getSelecionadosFiltro(FILTRO_ORIGEM, 0)) != null) {
                    whereRpl.append(" and lcc.opc_codigo in (");
                    for (int i = 0; i < origem.length; ++i) {
                        whereRpl.append("'");
                        whereRpl.append(origem[i]);
                        whereRpl.append("'");
                        if (i >= origem.length - 1) continue;
                        whereRpl.append(", ");
                    }
                    whereRpl.append(")");
                }
                filiais = this.getSelecionadosFiltro(FILTRO_FILIAL_CENTRO_CUSTO, 0);
                if (filiais == null || filiais.length <= 1) break block111;
                Funcoes.mensagem(this, "Apenas uma filial deve ser selecionada para o relat\u00f3rio", 2);
                this.habilitaBotaoImprimir(true);
                Conexao.fecharStatement(st, st2);
                return;
            }
            try {
                int i;
                this.setCursor(Cursor.getPredefinedCursor(3));
                StringBuilder buf = new StringBuilder();
                buf.append("select distinct ");
                buf.append(" a.ccu_reduzido as reduzidoCentroCusto, ");
                buf.append(" a.ccu_descricao as descricaoCentroCusto, ");
                buf.append(" a.ccu_conta as contaCentroCusto, ");
                buf.append(" a.fil_codigo as filialCentroCusto, ");
                buf.append(" a.ccu_nivel as nivelCentroCusto, ");
                buf.append(" a.ccu_pai as paiCentroCusto, ");
                buf.append(" a.ccu_operacao as operacaoCentroCusto, ");
                buf.append(" lcx.lcx_codigo as codigoLancamento, ");
                buf.append(" lcx.lcx_tipopagamento as tipoPagamentoLancamento, ");
                buf.append(" lcx.lcx_conta as contaLancamento, ");
                buf.append(" lcx.lcx_documento as documentoLancamento, ");
                buf.append(" lcx.lcx_vencimento as vencimentoLancamento, ");
                buf.append(" lcx.lcx_datahora as emissaoLancamento, ");
                buf.append(" lcx.lcx_conciliacao as conciliacaoLancamento, ");
                buf.append(" lcx.lcx_competencia as competenciaLancamento, ");
                buf.append(" lcx.lcx_tipo as tipoLancamento, ");
                buf.append(" lcx.opc_codigo as codigoOrigemLancamentoCentro, ");
                buf.append(" lcx.lcx_valor as valorLancamento, ");
                buf.append(" lcx.lcx_valortotal as valorTotalLancamento, ");
                buf.append(" lcx.lcc_valor as valorLancamentoCentro, ");
                buf.append(" lcx.lcx_situacao as situacaoLancamento, ");
                buf.append(" CASE WHEN a.ccu_operacao = 'A' THEN lcx.lcc_valor ELSE lcx.lcc_valor * (-1) END as valorLancamentoCentroComSinal, ");
                buf.append(" lcx.rpg_datahora as dataHoraReceberPagar, ");
                buf.append(" lcx.rpg_competencia as competenciaReceberPagar, ");
                buf.append(" lcx.rpg_vencimento as vencimentoReceberPagar, ");
                buf.append(" lcx.rpg_codigo as codigoReceberPagar, ");
                buf.append(" lcx.rpg_tipo as tipoReceberPagar, ");
                buf.append(" lcx.rpg_tipodocumento as tipoDocumentoReceberPagar, ");
                buf.append(" lcx.rpg_parcela as parcelaReceberPagar, ");
                buf.append(" lcx.rpg_datadocumento as dataDocumentoReceberPagar, ");
                buf.append(" lcx.rpg_dataprocessamento as dataProcessamentoReceberPagar, ");
                buf.append(" lcx.ser_codigo as codigoSerieReceberPagar, ");
                buf.append(" lcx.rpg_situacao as situacaoReceberPagar, ");
                buf.append(" lcx.rpg_valor as valorReceberPagar, ");
                buf.append(" lcx.rpg_valortotal as valorTotalReceberPagar, ");
                buf.append(" lcx.rpg_tipocadastro as tipoCadastro, ");
                buf.append(" lcx.rpg_numerodocumento as numeroDocumentoReceberPagar, ");
                buf.append(" lcx.rpg_codigodocumento as codigoDocumentoReceberPagar, ");
                buf.append("CASE WHEN lcx.rpg_tipo = 'R' THEN lcx.rpg_valortotal ELSE lcx.rpg_valortotal * (-1) END as valorTotalReceberPagarComSinal, ");
                buf.append(" lcx.codigoCadastro, ");
                buf.append(" lcx.crp_valor as valorReceberPagarCentro, ");
                buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                buf.append("  from centrocusto a ");
                buf.append("  left join (select lcc.*, ");
                buf.append("                    lcx.lcx_tipo, ");
                buf.append("                    lcx.lcx_tipopagamento, ");
                buf.append("                    lcx.lcx_conta, ");
                buf.append("                    lcx.lcx_documento, ");
                buf.append("                    lcx.lcx_situacao, ");
                buf.append("                    lcx.lcx_valor, ");
                buf.append("                    lcx.lcx_valortotal, ");
                buf.append("                    lcx.lcx_vencimento, ");
                buf.append("                    lcx.lcx_competencia, ");
                buf.append("                    lcx.lcx_datahora, ");
                buf.append("                    lcx.lcx_conciliacao, ");
                buf.append("                    crp.crp_valor, ");
                buf.append(" \t\t\t\t\t\t\t\t\t\trpg.rpg_datahora, ");
                buf.append(" \t\t\t\t\t\t\t\t\t\trpg.rpg_competencia, ");
                buf.append(" \t\t\t\t\t\t\t\t\t\trpg.rpg_vencimento, ");
                buf.append(" \t\t\t\t\t\t\t\t\t\trpg.rpg_codigo, ");
                buf.append(" \t\t\t\t\t\t\t\t\t\trpg.rpg_tipo, ");
                buf.append(" \t\t\t\t\t\t\t\t\t\trpg.rpg_tipodocumento, ");
                buf.append(" \t\t\t\t\t\t\t\t\t\trpg.rpg_numerodocumento, ");
                buf.append(" \t\t\t\t\t\t\t\t\t\trpg.rpg_codigodocumento, ");
                buf.append(" \t\t\t\t\t\t\t\t\t\trpg.rpg_parcela, ");
                buf.append(" \t\t\t\t\t\t\t\t\t\trpg.rpg_datadocumento, ");
                buf.append(" \t\t\t\t\t\t\t\t\t\trpg.rpg_dataprocessamento, ");
                buf.append(" \t\t\t\t\t\t\t\t\t\trpg.ser_codigo, ");
                buf.append(" \t\t\t\t\t\t\t\t\t\trpg.rpg_situacao, ");
                buf.append(" \t\t\t\t\t\t\t\t\t\trpg.rpg_valor, ");
                buf.append(" \t\t\t\t\t\t\t\t\t\trpg.rpg_valortotal, ");
                buf.append(" \t\t\t\t\t\t\t\t\t\trpg.rpg_tipocadastro, ");
                buf.append(" \t\t\t\t\t\t\t\t\t\tCASE WHEN rpg.rpg_tipocadastro = '").append("P").append("' THEN rpg.pac_codigo ");
                buf.append("      \t\t\t\t\t\t\t\t\t WHEN rpg.rpg_tipocadastro = '").append("O").append("' THEN rpg.con_codigo ");
                buf.append("      \t\t\t\t\t\t\t\t\t ELSE rpg.ent_codigo END as codigoCadastro ");
                buf.append("               from lanctocaixacentrocusto lcc ");
                buf.append(" join lanctocaixa lcx on lcc.fil_codigo = lcx.fil_codigo and lcc.lcx_codigo = lcx.lcx_codigo and lcx.lcx_situacao <> '").append("C").append("' ");
                buf.append(" join baixalanctocaixa blc on lcx.fil_codigo = blc.fil_codigo and lcx.lcx_codigo = blc.lcx_codigo ");
                buf.append(" join baixa bxa on blc.fil_codigo = bxa.fil_codigo and blc.bxa_codigo = bxa.bxa_codigo ");
                buf.append(" join baixareceberpagar brp on bxa.fil_codigo = brp.fil_codigo and bxa.bxa_codigo = brp.bxa_codigo ");
                buf.append(" join lanctocaixacentrocustorp crp on brp.fil_codigo = crp.fil_codigo and lcc.opc_codigo = crp.opc_codigo and lcx.lcx_codigo = crp.lcx_codigo and lcx.est_codigo = crp.est_codigo and lcc.ccu_reduzido = crp.ccu_reduzido ");
                buf.append(" join receberpagar rpg on rpg.fil_codigo = rpg.fil_codigo and crp.rpg_codigo = rpg.rpg_codigo ");
                buf.append(whereRpg.toString() + whereRpl.toString());
                buf.append(") lcx on a.fil_codigo = lcx.fil_codigo and a.ccu_reduzido = lcx.ccu_reduzido ");
                buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                buf.append("where a.fil_codigo ");
                if (filiais == null || filiais.length == 0) {
                    buf.append(" = ").append(Variaveis.filialPadrao);
                } else {
                    buf.append(" in (");
                    for (int i2 = 0; i2 < filiais.length; ++i2) {
                        buf.append(filiais[i2]);
                        if (i2 >= filiais.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                int maiorNivel = 0;
                ResultSet rs = null;
                try {
                    rs = Conexao.executeQuery(st, "select MAX(a.ccu_nivel) as maiorNivel from centrocusto a");
                    rs.next();
                    maiorNivel = rs.getInt("maiorNivel");
                }
                catch (Exception ex) {
                    maiorNivel = 0;
                }
                String[] centroCusto = this.getSelecionadosFiltro(FILTRO_CENTRO_CUSTO, 0);
                if (centroCusto != null) {
                    buf.append(" and a.ccu_reduzido in (");
                    ArrayList<Integer> arrayAux = new ArrayList<Integer>();
                    for (int i3 = 0; i3 < centroCusto.length; ++i3) {
                        arrayAux.add(new Integer(centroCusto[i3]));
                    }
                    ArrayList<Integer> arrayAcima = this.getCentrosAcima((ArrayList)arrayAux.clone());
                    ArrayList<Integer> arrayAbaixo = this.getCentrosAbaixo((ArrayList)arrayAux.clone());
                    if (arrayAcima != null) {
                        for (i = 0; i < arrayAcima.size(); ++i) {
                            if (arrayAux.contains(arrayAcima.get(i))) continue;
                            arrayAux.add(arrayAcima.get(i));
                        }
                    }
                    if (arrayAbaixo != null) {
                        for (i = 0; i < arrayAbaixo.size(); ++i) {
                            if (arrayAux.contains(arrayAbaixo.get(i))) continue;
                            arrayAux.add(arrayAbaixo.get(i));
                        }
                    }
                    for (i = 0; i < arrayAux.size(); ++i) {
                        buf.append(arrayAux.get(i));
                        if (i >= arrayAux.size() - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
                rs = Conexao.executeQuery(st, buf.toString());
                ArrayValoresCentroCusto arrayCentros = null;
                ArrayList<Integer> listaCentroRP = new ArrayList<Integer>();
                if (rs.next()) {
                    arrayCentros = new ArrayValoresCentroCusto();
                    do {
                        if (rs.getInt("codigoLancamento") == 0 || listaCentroRP.contains(rs.getInt("codigoLancamento"))) continue;
                        listaCentroRP.add(rs.getInt("codigoLancamento"));
                    } while (rs.next());
                }
                if (codigoDocumento.length() == 0 && numeroDocumento.length() == 0) {
                    buf = new StringBuilder(" (").append(buf.toString()).append(") ");
                    buf.append(" UNION ");
                    buf.append(" (select ");
                    buf.append(" a.ccu_reduzido as reduzidoCentroCusto, ");
                    buf.append(" a.ccu_descricao as descricaoCentroCusto, ");
                    buf.append(" a.ccu_conta as contaCentroCusto, ");
                    buf.append(" a.fil_codigo as filialCentroCusto, ");
                    buf.append(" a.ccu_nivel as nivelCentroCusto, ");
                    buf.append(" a.ccu_pai as paiCentroCusto, ");
                    buf.append(" a.ccu_operacao as operacaoCentroCusto, ");
                    buf.append(" lcx.lcx_codigo as codigoLancamento, ");
                    buf.append(" lcx.lcx_tipopagamento as tipoPagamentoLancamento, ");
                    buf.append(" lcx.lcx_conta as contaLancamento, ");
                    buf.append(" lcx.lcx_documento as documentoLancamento, ");
                    buf.append(" lcx.lcx_vencimento as vencimentoLancamento, ");
                    buf.append(" lcx.lcx_datahora as emissaoLancamento, ");
                    buf.append(" lcx.lcx_conciliacao as conciliacaoLancamento, ");
                    buf.append(" lcx.lcx_competencia as competenciaLancamento, ");
                    buf.append(" lcx.lcx_tipo as tipoLancamento, ");
                    buf.append(" lcx.opc_codigo as codigoOrigemLancamentoCentro, ");
                    buf.append(" lcx.lcx_valor as valorLancamento, ");
                    buf.append(" lcx.lcx_valortotal as valorTotalLancamento, ");
                    buf.append(" lcx.lcc_valor as valorLancamentoCentro, ");
                    buf.append(" lcx.lcx_situacao as situacaoLancamento, ");
                    buf.append(" CASE WHEN a.ccu_operacao = 'A' THEN lcx.lcc_valor ELSE lcx.lcc_valor * (-1) END as valorLancamentoCentroComSinal, ");
                    buf.append(" rpg.rpg_datahora as dataHoraReceberPagar, ");
                    buf.append(" rpg.rpg_competencia as competenciaReceberPagar, ");
                    buf.append(" rpg.rpg_vencimento as vencimentoReceberPagar, ");
                    buf.append(" rpg.rpg_codigo as codigoReceberPagar, ");
                    buf.append(" rpg.rpg_tipo as tipoReceberPagar, ");
                    buf.append(" rpg.rpg_tipodocumento as tipoDocumentoReceberPagar, ");
                    buf.append(" rpg.rpg_parcela as parcelaReceberPagar, ");
                    buf.append(" rpg.rpg_datadocumento as dataDocumentoReceberPagar, ");
                    buf.append(" rpg.rpg_dataprocessamento as dataProcessamentoReceberPagar, ");
                    buf.append(" rpg.ser_codigo as codigoSerieReceberPagar, ");
                    buf.append(" rpg.rpg_situacao as situacaoReceberPagar, ");
                    buf.append(" rpg.rpg_valor as valorReceberPagar, ");
                    buf.append(" rpg.rpg_valortotal as valorTotalReceberPagar, ");
                    buf.append(" rpg.rpg_tipocadastro as tipoCadastro, ");
                    buf.append(" rpg.rpg_numerodocumento as numeroDocumentoReceberPagar, ");
                    buf.append(" rpg.rpg_codigodocumento as codigoDocumentoReceberPagar, ");
                    buf.append("CASE WHEN rpg.rpg_tipo = 'R' THEN rpg.rpg_valortotal ELSE rpg.rpg_valortotal * (-1) END as valorTotalReceberPagarComSinal, ");
                    buf.append(" CASE WHEN rpg.rpg_tipocadastro = '").append("P").append("' THEN rpg.pac_codigo ");
                    buf.append("      WHEN rpg.rpg_tipocadastro = '").append("O").append("' THEN rpg.con_codigo ");
                    buf.append("      ELSE rpg.ent_codigo END as codigoCadastro, ");
                    buf.append(" rpg.rpg_valortotal as valorReceberPagarCentro, ");
                    buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                    buf.append("  from centrocusto a ");
                    buf.append("  left join (select lcc.*, ");
                    buf.append("                    lcx.lcx_tipo, ");
                    buf.append("                    lcx.lcx_tipopagamento, ");
                    buf.append("                    lcx.lcx_conta, ");
                    buf.append("                    lcx.lcx_documento, ");
                    buf.append("                    lcx.lcx_situacao, ");
                    buf.append("                    lcx.lcx_valor, ");
                    buf.append("                    lcx.lcx_valortotal, ");
                    buf.append("                    lcx.lcx_vencimento, ");
                    buf.append("                    lcx.lcx_competencia, ");
                    buf.append("                    lcx.lcx_datahora, ");
                    buf.append("                    lcx.lcx_conciliacao ");
                    buf.append("               from lanctocaixacentrocusto lcc, ");
                    buf.append("                    lanctocaixa lcx ");
                    buf.append("              where lcx.lcx_codigo = lcc.lcx_codigo ");
                    buf.append("                and lcx.fil_codigo = lcc.fil_codigo ");
                    buf.append("                and lcx.lcx_situacao <> '").append("C").append("' ");
                    buf.append(whereRpg.toString() + whereRpl.toString());
                    if (listaCentroRP.size() > 0) {
                        buf.append(" and lcc.lcx_codigo NOT IN(");
                        for (int i4 = 0; i4 < listaCentroRP.size(); ++i4) {
                            buf.append(listaCentroRP.get(i4));
                            if (i4 >= listaCentroRP.size() - 1) continue;
                            buf.append(", ");
                        }
                        buf.append(") ");
                    }
                    buf.append("            ) as lcx on (a.ccu_reduzido = lcx.ccu_reduzido and a.fil_codigo = lcx.fil_codigo) ");
                    buf.append(" left join (select rpg.*, ");
                    buf.append("                   blc.lcx_codigo ");
                    buf.append("              from baixareceberpagar brp ");
                    buf.append("              join receberpagar rpg on (brp.fil_codigo = rpg.fil_codigo and brp.rpg_codigo = rpg.rpg_codigo) ");
                    buf.append("              join baixa bxa on (brp.fil_codigo = bxa.fil_codigo and brp.bxa_codigo = bxa.bxa_codigo) ");
                    buf.append("              join baixalanctocaixa blc on (bxa.fil_codigo = blc.fil_codigo and bxa.bxa_codigo = blc.bxa_codigo)) as rpg on (lcx.fil_codigo = rpg.fil_codigo and lcx.lcx_codigo = rpg.lcx_codigo) ");
                    buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                    buf.append("where a.fil_codigo ");
                    if (filiais == null || filiais.length == 0) {
                        buf.append(" = ").append(Variaveis.filialPadrao);
                    } else {
                        buf.append(" in (");
                        for (int i5 = 0; i5 < filiais.length; ++i5) {
                            buf.append(filiais[i5]);
                            if (i5 >= filiais.length - 1) continue;
                            buf.append(", ");
                        }
                        buf.append(")");
                    }
                    if (centroCusto != null) {
                        int i6;
                        buf.append(" and a.ccu_reduzido in (");
                        ArrayList<Integer> arrayAux = new ArrayList<Integer>();
                        for (i = 0; i < centroCusto.length; ++i) {
                            arrayAux.add(new Integer(centroCusto[i]));
                        }
                        ArrayList<Integer> arrayAcima = this.getCentrosAcima((ArrayList)arrayAux.clone());
                        ArrayList<Integer> arrayAbaixo = this.getCentrosAbaixo((ArrayList)arrayAux.clone());
                        if (arrayAcima != null) {
                            for (i6 = 0; i6 < arrayAcima.size(); ++i6) {
                                if (arrayAux.contains(arrayAcima.get(i6))) continue;
                                arrayAux.add(arrayAcima.get(i6));
                            }
                        }
                        if (arrayAbaixo != null) {
                            for (i6 = 0; i6 < arrayAbaixo.size(); ++i6) {
                                if (arrayAux.contains(arrayAbaixo.get(i6))) continue;
                                arrayAux.add(arrayAbaixo.get(i6));
                            }
                        }
                        for (i6 = 0; i6 < arrayAux.size(); ++i6) {
                            buf.append(arrayAux.get(i6));
                            if (i6 >= arrayAux.size() - 1) continue;
                            buf.append(", ");
                        }
                        buf.append(")");
                    }
                    buf.append(" )");
                }
                buf.append(" order by contaCentroCusto, ");
                buf.append(CAMPOS_ORDEM[this.getFiltroComboIndice(FILTRO_ORDEM)]).append(", ");
                buf.append(CAMPOS_ORDEM_RECPAG[this.getFiltroComboIndice(FILTRO_ORDEM_RECPAG)]);
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    do {
                        arrayCentros.adicionaCentro(rs.getInt("reduzidoCentroCusto"), rs.getInt("paiCentroCusto"));
                    } while (rs.next());
                    rs.first();
                    do {
                        if (rs.getInt("codigoLancamento") == 0) continue;
                        arrayCentros.somaValorCentro(rs.getInt("reduzidoCentroCusto"), rs.getBigDecimal("valorLancamentoCentro"), rs.getBigDecimal("valorLancamentoCentroComSinal"), rs.getInt("paiCentroCusto"), rs.getInt("codigoLancamento"), rs.getString("codigoOrigemLancamentoCentro"));
                    } while (rs.next());
                }
                rs.first();
                int posCampoReduzidoRelatorio = 0;
                for (int i7 = 0; i7 < this.camposRelatorio.length; ++i7) {
                    if (!this.camposRelatorio[i7].equals("reduzidoCentroCusto")) continue;
                    posCampoReduzidoRelatorio = i7;
                    break;
                }
                rs.beforeFirst();
                int reduzidoCentroCusto = -1;
                int codigoLancto = -1;
                String codigoOrigem = "";
                boolean imprimeLancto = false;
                boolean imprimeRecPag = false;
                if (rs.next()) {
                    int i8;
                    ModeloGridTable modelo = null;
                    modelo = new ModeloGridTable(this.camposRelatorio);
                    do {
                        int i9;
                        Object[] o = null;
                        o = new Object[this.camposRelatorio.length];
                        if (rs.getInt("nivelCentroCusto") == maiorNivel) {
                            if (reduzidoCentroCusto == -1) {
                                imprimeLancto = false;
                            } else if (reduzidoCentroCusto == rs.getInt("reduzidoCentroCusto")) {
                                imprimeLancto = true;
                            } else {
                                imprimeLancto = false;
                                imprimeRecPag = false;
                            }
                            reduzidoCentroCusto = rs.getInt("reduzidoCentroCusto");
                            if (codigoLancto == 0) {
                                codigoLancto = -1;
                                continue;
                            }
                            if (codigoLancto != rs.getInt("codigoLancamento") || !codigoOrigem.equalsIgnoreCase(rs.getString("codigoOrigemLancamentoCentro"))) {
                                imprimeRecPag = false;
                                codigoLancto = -1;
                                codigoOrigem = "";
                            }
                            if (imprimeLancto && !imprimeRecPag) {
                                for (i9 = 0; i9 < camposLancamento.length; ++i9) {
                                    if (camposLancamento[i9].equals("tipoPagamentoLancamento")) {
                                        o[modelo.findColumn((String)RelatorioLancamentoCentroDetalhado.camposLancamento[i9])] = Tipos.tipoPagamento(rs.getString(camposLancamento[i9]));
                                        continue;
                                    }
                                    if (camposLancamento[i9].equals("tipoLancamento")) {
                                        if (rs.getString(camposLancamento[i9]) != null) {
                                            o[modelo.findColumn((String)RelatorioLancamentoCentroDetalhado.camposLancamento[i9])] = Tipos.tipoLancamentoCaixa(rs.getString(camposLancamento[i9]));
                                            continue;
                                        }
                                        o[modelo.findColumn((String)RelatorioLancamentoCentroDetalhado.camposLancamento[i9])] = "";
                                        continue;
                                    }
                                    if (this.camposRelatorio[i9].equalsIgnoreCase("situacaoLancamento")) {
                                        if (rs.getString(this.camposRelatorio[i9]) != null) {
                                            o[modelo.findColumn((String)this.camposRelatorio[i9])] = Tipos.tipoSituacaoLancamento(rs.getString(this.camposRelatorio[i9]));
                                            continue;
                                        }
                                        o[modelo.findColumn((String)this.camposRelatorio[i9])] = null;
                                        continue;
                                    }
                                    o[modelo.findColumn((String)RelatorioLancamentoCentroDetalhado.camposLancamento[i9])] = rs.getObject(camposLancamento[i9]);
                                }
                                imprimeRecPag = true;
                                codigoLancto = rs.getInt("codigoLancamento");
                                codigoOrigem = rs.getString("codigoOrigemLancamentoCentro");
                                rs.previous();
                            } else if (imprimeRecPag) {
                                for (i9 = 0; i9 < this.camposRelatorio.length; ++i9) {
                                    if (!ArraysUtil.contem(camposRecPag, this.camposRelatorio[i9])) continue;
                                    if (this.camposRelatorio[i9].equals("tipoDocumentoReceberPagar")) {
                                        o[modelo.findColumn((String)this.camposRelatorio[i9])] = Tipos.tipoDocumento(rs.getString(this.camposRelatorio[i9]));
                                        continue;
                                    }
                                    if (this.camposRelatorio[i9].equals("tipoReceberPagar")) {
                                        if (rs.getString(this.camposRelatorio[i9]) != null) {
                                            o[modelo.findColumn((String)this.camposRelatorio[i9])] = Tipos.tipoReceberPagar(rs.getString(this.camposRelatorio[i9]));
                                            continue;
                                        }
                                        o[modelo.findColumn((String)this.camposRelatorio[i9])] = "";
                                        continue;
                                    }
                                    if (this.camposRelatorio[i9].equals("tipoCadastro")) {
                                        if (rs.getString(this.camposRelatorio[i9]) != null) {
                                            o[modelo.findColumn((String)this.camposRelatorio[i9])] = Tipos.tipoCadastro(rs.getString(this.camposRelatorio[i9]));
                                            continue;
                                        }
                                        o[modelo.findColumn((String)this.camposRelatorio[i9])] = "";
                                        continue;
                                    }
                                    o[modelo.findColumn((String)this.camposRelatorio[i9])] = rs.getObject(this.camposRelatorio[i9]);
                                }
                                if (rs.getString("tipoCadastro") != null) {
                                    this.pegaDadosCadastro(st2, o, modelo, rs.getString("tipoCadastro"), rs.getInt("codigoFilial"), rs.getInt("codigoCadastro"));
                                }
                            } else {
                                for (i9 = 0; i9 < this.camposRelatorio.length; ++i9) {
                                    if (this.camposRelatorio[i9].equals("totalCentroCusto")) {
                                        if (arrayCentros == null) continue;
                                        o[modelo.findColumn((String)this.camposRelatorio[i9])] = arrayCentros.getValorCentro(rs.getInt(this.camposRelatorio[posCampoReduzidoRelatorio]));
                                        continue;
                                    }
                                    if (this.camposRelatorio[i9].equals("totalCentroCustoComSinal")) {
                                        if (arrayCentros == null) continue;
                                        o[modelo.findColumn((String)this.camposRelatorio[i9])] = arrayCentros.getValorCentroComSinal(rs.getInt(this.camposRelatorio[posCampoReduzidoRelatorio]));
                                        continue;
                                    }
                                    if (this.camposRelatorio[i9].equals("valorSomatorio") || this.camposRelatorio[i9].equals("valorSomatorioComSinal") || ArraysUtil.contem(camposRecPag, this.camposRelatorio[i9]) || ArraysUtil.contem(camposLancamento, this.camposRelatorio[i9]) || ArraysUtil.contem(camposCadastros, this.camposRelatorio[i9])) continue;
                                    o[modelo.findColumn((String)this.camposRelatorio[i9])] = rs.getObject(this.camposRelatorio[i9]);
                                }
                                if (rs.getString("codigoLancamento") != null && !Funcoes.textoVazio(rs.getString("codigoLancamento"))) {
                                    rs.previous();
                                } else if (rs.next()) {
                                    if (reduzidoCentroCusto == rs.getInt("reduzidoCentroCusto")) {
                                        rs.previous();
                                    }
                                    rs.previous();
                                }
                            }
                        } else {
                            for (i9 = 0; i9 < this.camposRelatorio.length; ++i9) {
                                if (this.camposRelatorio[i9].equals("totalCentroCusto")) {
                                    if (arrayCentros == null) continue;
                                    o[modelo.findColumn((String)this.camposRelatorio[i9])] = arrayCentros.getValorCentro(rs.getInt(this.camposRelatorio[posCampoReduzidoRelatorio]));
                                    continue;
                                }
                                if (this.camposRelatorio[i9].equals("totalCentroCustoComSinal")) {
                                    if (arrayCentros == null) continue;
                                    o[modelo.findColumn((String)this.camposRelatorio[i9])] = arrayCentros.getValorCentroComSinal(rs.getInt(this.camposRelatorio[posCampoReduzidoRelatorio]));
                                    continue;
                                }
                                if (this.camposRelatorio[i9].equals("valorSomatorio") || this.camposRelatorio[i9].equals("valorSomatorioComSinal") || this.camposRelatorio[i9].equalsIgnoreCase("dataVencimentoLancamentoBaixa") || this.camposRelatorio[i9].equalsIgnoreCase("dataCompetenciaLancamentoBaixa") || this.camposRelatorio[i9].equalsIgnoreCase("dataConciliacaoLancamentoBaixa") || this.camposRelatorio[i9].equalsIgnoreCase("codigoBaixa") || this.camposRelatorio[i9].equalsIgnoreCase("situacaoLancamentoBaixa")) continue;
                                if (this.camposRelatorio[i9].equalsIgnoreCase("tipoLancamento")) {
                                    if (rs.getString(this.camposRelatorio[i9]) != null) {
                                        o[modelo.findColumn((String)this.camposRelatorio[i9])] = Tipos.tipoLancamentoCaixa(rs.getString(this.camposRelatorio[i9]));
                                        continue;
                                    }
                                    o[modelo.findColumn((String)this.camposRelatorio[i9])] = null;
                                    continue;
                                }
                                if (this.camposRelatorio[i9].equalsIgnoreCase("tipoReceberPagar")) {
                                    if (rs.getString(this.camposRelatorio[i9]) != null) {
                                        o[modelo.findColumn((String)this.camposRelatorio[i9])] = Tipos.tipoReceberPagar(rs.getString(this.camposRelatorio[i9]));
                                        continue;
                                    }
                                    o[modelo.findColumn((String)this.camposRelatorio[i9])] = null;
                                    continue;
                                }
                                if (this.camposRelatorio[i9].equalsIgnoreCase("situacaoLancamento")) {
                                    if (rs.getString(this.camposRelatorio[i9]) != null) {
                                        o[modelo.findColumn((String)this.camposRelatorio[i9])] = Tipos.tipoSituacaoLancamento(rs.getString(this.camposRelatorio[i9]));
                                        continue;
                                    }
                                    o[modelo.findColumn((String)this.camposRelatorio[i9])] = null;
                                    continue;
                                }
                                if (this.camposRelatorio[i9].equalsIgnoreCase("situacaoReceberPagar")) {
                                    if (rs.getString(this.camposRelatorio[i9]) != null) {
                                        o[modelo.findColumn((String)this.camposRelatorio[i9])] = Tipos.tipoSituacaoReceberPagar(rs.getString(this.camposRelatorio[i9]));
                                        continue;
                                    }
                                    o[modelo.findColumn((String)this.camposRelatorio[i9])] = null;
                                    continue;
                                }
                                if (ArraysUtil.contem(camposCadastros, this.camposRelatorio[i9])) continue;
                                o[modelo.findColumn((String)this.camposRelatorio[i9])] = rs.getObject(this.camposRelatorio[i9]);
                            }
                            imprimeLancto = false;
                            reduzidoCentroCusto = -1;
                        }
                        modelo.addLine(o);
                    } while (rs.next());
                    for (i8 = 0; i8 < modelo.getRowCount(); ++i8) {
                        if (arrayCentros == null) continue;
                        modelo.setValueAt(arrayCentros.somatorioCentroCusto, i8, modelo.findColumn("valorSomatorio"));
                    }
                    for (i8 = 0; i8 < modelo.getRowCount(); ++i8) {
                        if (arrayCentros == null) continue;
                        modelo.setValueAt(arrayCentros.somatorioCentroCustoComSinal, i8, modelo.findColumn("valorSomatorioComSinal"));
                    }
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    buf.append(RelatorioLancamentoCentroDetalhado.getModuloAcesso());
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        int i10;
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(1.0f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioLancamentoCentroDetalhado.this.panelCentro.removeAll();
                                RelatorioLancamentoCentroDetalhado.this.panelCentro.repaint();
                                RelatorioLancamentoCentroDetalhado.this.habilitaBotaoImprimir(true);
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put(FILTRO_DATA_INICIAL, this.getFiltroData(FILTRO_DATA_INICIAL));
                        var.put(FILTRO_DATA_FINAL, this.getFiltroData(FILTRO_DATA_FINAL));
                        var.put(FILTRO_VALOR_INICIAL, this.getFiltroDecimal(FILTRO_VALOR_INICIAL));
                        var.put(FILTRO_VALOR_FINAL, this.getFiltroDecimal(FILTRO_VALOR_FINAL));
                        var.put(FILTRO_CAMPO_DATA, this.getFiltroCombo(FILTRO_CAMPO_DATA));
                        var.put(FILTRO_SITUACAO, this.getFiltroCombo(FILTRO_SITUACAO) == null ? "Todos" : this.getFiltroCombo(FILTRO_SITUACAO));
                        var.put(FILTRO_TIPO, this.getFiltroCombo(FILTRO_TIPO) == null ? "Todos" : this.getFiltroCombo(FILTRO_TIPO));
                        var.put(FILTRO_ORDEM, this.getFiltroCombo(FILTRO_ORDEM));
                        var.put(FILTRO_ORDEM_RECPAG, this.getFiltroCombo(FILTRO_ORDEM_RECPAG));
                        var.put(FILTRO_CODIGO_DOCUMENTO, codigoDocumento);
                        var.put(FILTRO_NUMERO_DOCUMENTO, numeroDocumento);
                        buf.delete(0, buf.length());
                        if (filiais != null) {
                            for (i10 = 0; i10 < filiais.length; ++i10) {
                                buf.append(filiais[i10]);
                                if (i10 >= filiais.length - 1) continue;
                                buf.append(", ");
                            }
                        } else {
                            buf.append(Variaveis.filialPadrao);
                        }
                        var.put(FILTRO_FILIAL_CENTRO_CUSTO, buf.toString());
                        buf.delete(0, buf.length());
                        if (usuario != null) {
                            for (i10 = 0; i10 < usuario.length; ++i10) {
                                buf.append(usuario[i10]);
                                if (i10 >= usuario.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put(FILTRO_USUARIO, buf.toString());
                        buf.delete(0, buf.length());
                        if (centroCusto != null) {
                            for (i10 = 0; i10 < centroCusto.length; ++i10) {
                                buf.append(centroCusto[i10]);
                                if (i10 >= centroCusto.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put(FILTRO_CENTRO_CUSTO, buf.toString());
                        buf.delete(0, buf.length());
                        if (origem != null) {
                            for (i10 = 0; i10 < origem.length; ++i10) {
                                buf.append(origem[i10]);
                                if (i10 >= origem.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put(FILTRO_ORIGEM, buf.toString());
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelCentro.revalidate();
                    }
                    break block112;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st, st2);
                    throw throwable;
                }
                Conexao.fecharStatement(st, st2);
            }
        }
        Conexao.fecharStatement(st, st2);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private ArrayList<Integer> getCentrosAcima(ArrayList<Integer> centros) {
        Statement st = Conexao.getStatement();
        ArrayList<Integer> resultado = new ArrayList<Integer>();
        StringBuilder centrosSql = null;
        StringBuilder buf = null;
        while (centros != null) {
            centrosSql = new StringBuilder();
            for (int i = 0; i < centros.size() && centros != null; ++i) {
                centrosSql.append(centros.get(i));
                if (i >= centros.size() - 1) continue;
                centrosSql.append(", ");
            }
            buf = new StringBuilder();
            buf.append(" select ccu_pai ");
            buf.append("   from centrocusto ");
            buf.append("  where ccu_reduzido IN (").append((CharSequence)centrosSql).append(") ");
            buf.append("    and fil_codigo = ").append(Variaveis.filialPadrao);
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (centros != null) {
                    centros.clear();
                }
                if (rs.next()) {
                    do {
                        if (rs.getString("ccu_pai") == null || resultado.contains(rs.getInt("ccu_pai"))) continue;
                        resultado.add(rs.getInt("ccu_pai"));
                        if (centros == null) continue;
                        centros.add(rs.getInt("ccu_pai"));
                    } while (rs.next());
                } else {
                    centros = null;
                }
            }
            catch (SQLException e) {
                break;
            }
            if (centros == null || centros.size() != 0) continue;
            centros = null;
        }
        Conexao.fecharStatement(st);
        if (resultado.size() == 0) {
            return null;
        }
        return resultado;
    }

    private ArrayList<Integer> getCentrosAbaixo(ArrayList<Integer> centros) {
        Statement st = Conexao.getStatement();
        ArrayList<Integer> resultado = new ArrayList<Integer>();
        StringBuilder centrosSql = null;
        StringBuilder buf = null;
        while (centros != null) {
            centrosSql = new StringBuilder();
            for (int i = 0; i < centros.size() && centros != null; ++i) {
                centrosSql.append(centros.get(i));
                if (i >= centros.size() - 1) continue;
                centrosSql.append(", ");
            }
            buf = new StringBuilder();
            buf.append(" select ccu_reduzido ");
            buf.append("   from centrocusto ");
            buf.append("  where ccu_pai IN (").append((CharSequence)centrosSql).append(") ");
            buf.append("    and fil_codigo = ").append(Variaveis.filialPadrao);
            try {
                ResultSet rs = Conexao.executeQuery(st, buf.toString());
                if (centros != null) {
                    centros.clear();
                }
                if (rs.next()) {
                    do {
                        if (rs.getString("ccu_reduzido") == null || resultado.contains(rs.getInt("ccu_reduzido"))) continue;
                        resultado.add(rs.getInt("ccu_reduzido"));
                        if (centros == null) continue;
                        centros.add(rs.getInt("ccu_reduzido"));
                    } while (rs.next());
                } else {
                    centros = null;
                }
            }
            catch (SQLException e) {
                break;
            }
            if (centros == null || centros.size() != 0) continue;
            centros = null;
        }
        Conexao.fecharStatement(st);
        if (resultado.size() == 0) {
            return null;
        }
        return resultado;
    }

    private void pegaDadosCadastro(Statement st, Object[] array, ModeloGridTable modelo, String tipo, int filial, int codigo) throws SQLException {
        StringBuilder buf = new StringBuilder();
        if (tipo.equalsIgnoreCase("P")) {
            buf.append("select ");
            buf.append("\tpac.pac_codigo as codigoCadastro, pac.pac_nome as fantasiaCadastro,pac.pac_nomesocial as nomeSocialPaciente, pac.pac_nome as razaoSocialCadastro, pac.pac_fone as foneCadastro, ");
            buf.append("\tpac.pac_endereco as enderecoCadastro, pac.pac_numeroendereco as numeroEnderecoCadastro, pac.pac_tipologradouroendereco as tipoLogradouroCadastro, ");
            buf.append("\tpac.pac_fax as faxCadastro, pac.pac_complemento as complementoCadastro, pac.pac_cep as cepCadastro, ");
            buf.append("\tpac.cid_codigo as codigoCidadeCadastro, cidpac.cid_nome as nomeCidadeCadastro ");
            buf.append("from paciente pac ");
            buf.append("\tleft join cidades cidpac on pac.fil_codigo = cidpac.fil_codigo and pac.cid_codigo = cidpac.cid_codigo ");
            buf.append("where pac.fil_codigo = ").append(filial);
            buf.append(" and pac.pac_codigo = ").append(codigo);
        } else if (tipo.equalsIgnoreCase("O")) {
            buf.append("select ");
            buf.append("\tcon.con_codigo as codigoCadastro, con.con_fantasia as fantasiaCadastro, '' as nomeSocialPaciente, con.con_razao as razaoSocialCadastro, con.con_fone as foneCadastro, ");
            buf.append("\tcon.con_endereco as enderecoCadastro, con.con_numeroendereco as numeroEnderecoCadastro, con.con_tipologradouroendereco as tipoLogradouroCadastro, ");
            buf.append("\tcon.con_fax as faxCadastro, con.con_complemento as complementoCadastro, con.con_cep as cepCadastro, ");
            buf.append("\tcon.cid_codigo as codigoCidadeCadastro, cidcon.cid_nome as nomeCidadeCadastro ");
            buf.append("from convenios con ");
            buf.append("\tleft join cidades cidcon on con.fil_codigo = cidcon.fil_codigo and con.cid_codigo = cidcon.cid_codigo ");
            buf.append("where con.fil_codigo = ").append(filial);
            buf.append(" and con.con_codigo = ").append(codigo);
        } else {
            buf.append("select ");
            buf.append("\tent.ent_codigo as codigoCadastro, ent.ent_fantasia as fantasiaCadastro, '' as nomeSocialPaciente, ent.ent_razaosocial as razaoSocialCadastro, ent.ent_fone as foneCadastro, ");
            buf.append("\tent.ent_endereco as enderecoCadastro, ent.ent_numeroendereco as numeroEnderecoCadastro, ent.ent_tipologradouroendereco as tipoLogradouroCadastro, ");
            buf.append("\tent.ent_fax as faxCadastro, ent.ent_complemento as complementoCadastro, ent.ent_cep as cepCadastro, ");
            buf.append("\tent.cid_codigo as codigoCidadeCadastro, cident.cid_nome as nomeCidadeCadastro ");
            buf.append("from entidade ent ");
            buf.append("\tleft join cidades cident on ent.fil_codigo = cident.fil_codigo and ent.cid_codigo = cident.cid_codigo ");
            buf.append("where ent.fil_codigo = ").append(filial);
            buf.append(" and ent.ent_codigo = ").append(codigo);
        }
        ResultSet rs = Conexao.executeQuery(st, buf);
        if (rs.next()) {
            int pos = -1;
            for (String s : camposCadastros) {
                if (rs.findColumn(s) <= 0 || modelo.findColumn(s) <= -1) continue;
                pos = modelo.findColumn(s);
                array[modelo.findColumn((String)s)] = modelo.getColumnName(pos).equalsIgnoreCase("tipoLogradouroCadastro") ? Tipos.tipoLogradouroDescricao(rs.getString(s)) : rs.getObject(s);
            }
        }
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0850902200");
    }

    public static long getConfigurarAcesso() {
        return Long.parseLong("0850902201");
    }

    public class ArrayValoresCentroCusto {
        private ArrayList<ValorLanctoCentro> arrayLancamentos;
        private ArrayList<Integer> reduzidoCentroCusto = new ArrayList();
        private ArrayList<Integer> paiCentroCusto = new ArrayList();
        private ArrayList<BigDecimal> valorCentroCusto = new ArrayList();
        private ArrayList<BigDecimal> valorCentroCustoComSinal = new ArrayList();
        public BigDecimal somatorioCentroCusto = null;
        public BigDecimal somatorioCentroCustoComSinal = null;

        public ArrayValoresCentroCusto() {
            this.arrayLancamentos = new ArrayList();
            this.somatorioCentroCusto = BigDecimal.ZERO;
            this.somatorioCentroCustoComSinal = BigDecimal.ZERO;
        }

        public void adicionaCentro(int reduzidoCentroCusto, int paiCentroCusto) {
            if (this.getPosicaoCentro(reduzidoCentroCusto) != -1) {
                return;
            }
            this.reduzidoCentroCusto.add(reduzidoCentroCusto);
            this.paiCentroCusto.add(paiCentroCusto);
            this.valorCentroCusto.add(BigDecimal.ZERO);
            this.valorCentroCustoComSinal.add(BigDecimal.ZERO);
        }

        private int getPosicaoCentro(int centro) {
            if (centro == -1) {
                return -1;
            }
            for (int i = 0; i < this.reduzidoCentroCusto.size(); ++i) {
                if (this.reduzidoCentroCusto.get(i) != centro) continue;
                return i;
            }
            return -1;
        }

        private int getPaiCentro(int centro) {
            if (centro == -1) {
                return -1;
            }
            for (int i = 0; i < this.reduzidoCentroCusto.size(); ++i) {
                if (this.reduzidoCentroCusto.get(i) != centro) continue;
                return this.paiCentroCusto.get(i);
            }
            return -1;
        }

        private void setCentroValorPosicao(int posicao, int reduzidoCentroCusto, int paiCentroCusto, BigDecimal valorCentroCusto, BigDecimal valorCentroCustoComSinal) {
            if (posicao == -1) {
                return;
            }
            if (paiCentroCusto != 0) {
                this.setCentroValorPosicao(this.getPosicaoCentro(paiCentroCusto), paiCentroCusto, this.getPaiCentro(paiCentroCusto), valorCentroCusto, valorCentroCustoComSinal);
            } else {
                this.somatorioCentroCusto = this.somatorioCentroCusto.add(valorCentroCusto);
                this.somatorioCentroCustoComSinal = this.somatorioCentroCustoComSinal.add(valorCentroCustoComSinal);
            }
            this.valorCentroCusto.set(posicao, valorCentroCusto.add(this.getValorCentro(reduzidoCentroCusto)));
            this.valorCentroCustoComSinal.set(posicao, valorCentroCustoComSinal.add(this.getValorCentroComSinal(reduzidoCentroCusto)));
        }

        public BigDecimal getValorCentro(int reduzidoCentroCusto) {
            for (int i = 0; i < this.reduzidoCentroCusto.size(); ++i) {
                if (this.reduzidoCentroCusto.get(i) == -1 || this.reduzidoCentroCusto.get(i) != reduzidoCentroCusto) continue;
                return this.valorCentroCusto.get(i);
            }
            return BigDecimal.ZERO;
        }

        public BigDecimal getValorCentroComSinal(int reduzidoCentroCusto) {
            for (int i = 0; i < this.reduzidoCentroCusto.size(); ++i) {
                if (this.reduzidoCentroCusto.get(i) == -1 || this.reduzidoCentroCusto.get(i) != reduzidoCentroCusto) continue;
                return this.valorCentroCustoComSinal.get(i);
            }
            return BigDecimal.ZERO;
        }

        public void somaValorCentro(int reduzidoCentroCusto, BigDecimal valorAdicionar, BigDecimal valorAdicionarComSinal, int paiCentroCusto, int codigoLancamento, String codigoOrigem) {
            if (valorAdicionar == null) {
                valorAdicionar = BigDecimal.ZERO;
            }
            if (valorAdicionarComSinal == null) {
                valorAdicionarComSinal = BigDecimal.ZERO;
            }
            ValorLanctoCentro valorLancto = new ValorLanctoCentro(reduzidoCentroCusto, codigoLancamento, codigoOrigem);
            if (codigoLancamento != -1) {
                if (this.arrayLancamentos.contains(valorLancto)) {
                    return;
                }
                this.arrayLancamentos.add(valorLancto);
            }
            this.setCentroValorPosicao(this.getPosicaoCentro(reduzidoCentroCusto), reduzidoCentroCusto, paiCentroCusto, valorAdicionar, valorAdicionarComSinal);
        }

        class ValorLanctoCentro {
            int reduzidoCentro = -1;
            int codigoLancto = -1;
            String codigoOrigem = "";

            public ValorLanctoCentro(int reduzidoCentro, int codigoLancto, String codigoOrigem) {
                this.reduzidoCentro = reduzidoCentro;
                this.codigoLancto = codigoLancto;
                this.codigoOrigem = codigoOrigem;
            }

            public boolean equals(Object obj) {
                if (obj instanceof ValorLanctoCentro) {
                    return ((ValorLanctoCentro)obj).reduzidoCentro == this.reduzidoCentro && ((ValorLanctoCentro)obj).codigoLancto == this.codigoLancto && ((ValorLanctoCentro)obj).codigoOrigem.equalsIgnoreCase(this.codigoOrigem);
                }
                return false;
            }
        }
    }
}

