/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.movimento;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.JComboBox;
import javax.swing.table.TableModel;

public class RelatorioLancamento
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private final String[] ordem = new String[]{"C\u00f3digo", "Data", "Usu\u00e1rio"};
    private final String[] situacao = new String[]{"Todas", Tipos.tipoSituacaoLancamento("A"), Tipos.tipoSituacaoLancamento("O"), Tipos.tipoSituacaoLancamento("C"), "Exceto Cancelados"};
    private final String[] tipo = new String[]{"Todos", Tipos.tipoLancamentoCaixa("C"), Tipos.tipoLancamentoCaixa("D")};
    private String[] itensPagamento = new String[]{"Todos", Tipos.tipoPagamento("H"), Tipos.tipoPagamento("P"), Tipos.tipoPagamento("A"), Tipos.tipoPagamento("D"), Tipos.tipoPagamento("T"), Tipos.tipoPagamento("B"), Tipos.tipoPagamento("E"), Tipos.tipoPagamento("Z"), Tipos.tipoPagamento("S"), Tipos.tipoPagamento("I"), Tipos.tipoPagamento("O"), Tipos.tipoPagamento("C"), Tipos.tipoPagamento("U"), Tipos.tipoPagamento("N"), Tipos.tipoPagamento("F"), Tipos.tipoPagamento("W"), Tipos.tipoPagamento("Y")};
    private final String[] CAMPOSDATA = new String[]{"Vencimento", "Concilia\u00e7\u00e3o", "Emiss\u00e3o", "Compet\u00eancia"};
    private final String[] CAMPOSBANCODATA = new String[]{"lcx_vencimento", "lcx_conciliacao", "lcx_datahora", "lcx_competencia"};
    private final String FILTRO_FILIAL = "filtroFilial";
    private final String FILTRO_ESTACAO = "filtroEstacao";
    private final String FILTRO_USUARIO = "filtroUsuario";
    private final String FILTRO_CONTA = "filtroConta";
    private final String FILTRO_HISTORICO_PADRAO = "filtroHistoricoPadrao";
    private final String FILTRO_DATA_INICIAL = "filtroDataInicial";
    private final String FILTRO_DATA_FINAL = "filtroDataFinal";
    private final String FILTRO_HORA_INICIAL = "filtroHoraInicial";
    private final String FILTRO_HORA_FINAL = "filtroHoraFinal";
    private final String FILTRO_PAGAMENTO = "filtroPagamento";
    private final String FILTRO_SITUACAO = "filtroSituacao";
    private final String FILTRO_ORDEM = "ordemRelatorio";
    private final String FILTRO_CAMPO_DATA = "filtroCampoData";
    private final String FILTRO_TIPO = "filtroTipo";
    private final String FILTRO_PLANO_CONTA = "filtroPlanoConta";
    protected static final String[] campos = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"codigoLancamento", "dataHoraLancamento", "tipoLancamento", "valorLancamento", "bancoLancamento", "agenciaLancamento", "documentoLancamento", "observacaoLancamento", "tipoDocumentoLancamento", "tipoPagamentoLancamento", "numeroChequeLancamento", "validadeCartaoLancamento", "cartaoCreditoLancamento", "contaLancamento", "dataConciliacaoLancamento", "dataVencimentoLancamento", "dataCompetenciaLancamento", "valorTotalLancamento", "valorMultaLancamento", "percentualMultaLancamento", "valorJuroLancamento", "percentualJuroLancamento", "valorAcrescimoLancamento", "percentualAcrescimoLancamento", "valorDescontoLancamento", "percentualDescontoLancamento", "indiceTipoLancamento", "numeroCartaoLancamento", "canceladoLancamento", "situacaoLancamento", "conciliadoLancamento", "usuarioCancelamentoLancamento", "dataCancelamentoLancamento", "nomeUsuarioCancelamentoLancamento", "codigoMotivoCancelamento", "descricaoMotivoCancelamento", "descricaoCancelamentoLancamento", "codigoHistoricoPadrao", "descricaoHistoricoPadrao", "codigoEstacaoLancamento", "descricaoEstacaoLancamento", "codigoReduzidoConta", "contaConta", "titularConta", "codigoUsuarioLancamento", "nomeUsuarioLancamento", "descricaoHistoricoUsuario", "codigoFilialDestinoOrigem", "saldoAnteriorConta", "somatorioValorLancamentos", "valorFinalPeriodoContas", "nomeFuncionarioDescontoFolhaLancamento", "setorFuncionarioDescontoFolhaLancamento", "nomeFuncionarioAutorizacaoDescontoFolhaLancamento", "tipoTransferencia", "planosDeContas", "titularesReceberPagar", "codigoTitularesReceberPagar", "pix", "saldoAnteriorContaVencimento", "saldoAnteriorContaConciliado"});
    private JComboBox auxComboListener;
    private TTextField auxTextHoraInicial;
    private TTextField auxTextHoraFinal;

    public RelatorioLancamento() {
        this.montaBarraDescricao("Relat\u00f3rio de lan\u00e7amentos", "Listagem da movimenta\u00e7\u00e3o financeira em contas", "relatorios/rel_financeiro_movimento_lancamento_caixa.jpg");
        this.adicionaRelatorioListener(this);
        if (!this.naoPermiteFiltrarFilial()) {
            this.adicionaItemFiltro("filtroFilial", "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        }
        this.adicionaItemFiltro("filtroEstacao", "Esta\u00e7\u00e3o", "estacoes", "", 1, new String[]{"est_codigo", "est_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroUsuario", "Usu\u00e1rio", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroConta", "Conta", "contacorrente", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"cco_reduzido", "cco_conta", "bac_codigo", "age_codigo", "cco_inativa"}, new String[]{"C\u00f3digo", "Conta", "Banco", "Ag\u00eancia", "Inativa"}, new int[]{60, 0, 50, 60, 55});
        this.adicionaItemFiltro("filtroHistoricoPadrao", "Hist\u00f3rico padr\u00e3o", "historicopadrao", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"hpa_codigo", "hpa_descricao"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro("filtroPlanoConta", "Plano Contas", "planoconta", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"plc_reduzido", "plc_conta", "plc_descricao"}, new String[]{"C\u00f3digo", "Conta", "Descri\u00e7\u00e3o"}, new int[]{70, 120, 0});
        this.adicionaFiltroCombo("filtroPagamento", "Pagamento:", this.itensPagamento, 0);
        this.auxComboListener = this.adicionaRetornaFiltroCombo("filtroCampoData", "Campo Data:", this.CAMPOSDATA, 0);
        this.adicionaFiltroData("filtroDataInicial", "Data inicial:");
        this.adicionaFiltroData("filtroDataFinal", "Data final:");
        this.auxTextHoraInicial = this.adicionaRetornaFiltroHora("filtroHoraInicial", "Hora inicial:");
        this.auxTextHoraFinal = this.adicionaRetornaFiltroHora("filtroHoraFinal", "Hora final:");
        this.adicionaFiltroCombo("filtroTipo", "Tipo:", this.tipo, 0);
        this.adicionaFiltroCombo("filtroSituacao", "Situa\u00e7\u00e3o:", this.situacao, 0);
        this.adicionaFiltroCombo("ordemRelatorio", "Ordem:", this.ordem, 0);
        this.auxTextHoraInicial.setEnabled(false);
        this.auxTextHoraFinal.setEnabled(false);
        ItemListener listenerCombo = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JComboBox combo = (JComboBox)e.getSource();
                if (combo.getSelectedItem().equals("Emiss\u00e3o")) {
                    RelatorioLancamento.this.auxTextHoraInicial.setEnabled(true);
                    RelatorioLancamento.this.auxTextHoraFinal.setEnabled(true);
                } else {
                    RelatorioLancamento.this.auxTextHoraInicial.setEnabled(false);
                    RelatorioLancamento.this.auxTextHoraFinal.setEnabled(false);
                }
            }
        };
        this.auxComboListener.addItemListener(listenerCombo);
        this.setModuloConfigurar(Long.parseLong("0850400100"));
        this.setModuloAcesso(RelatorioLancamento.getModuloAcesso());
        this.setCamposConfigurador(campos);
    }

    @Override
    public void imprimirPressionado() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            int i;
            String[] historicoPadrao;
            String[] conta;
            String[] usuario;
            Statement st = Conexao.getStatement();
            Statement st2 = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            buf.append("select ");
            buf.append("a.lcx_codigo as codigoLancamento, a.lcx_datahora as dataHoraLancamento,");
            buf.append("a.lcx_tipo as tipoLancamento, a.lcx_valor as valorLancamento, ");
            buf.append("a.lcx_banco as bancoLancamento,a.lcx_agencia as agenciaLancamento, ");
            buf.append("a.lcx_documento as documentoLancamento, a.lcx_obs as observacaoLancamento,");
            buf.append("a.lcx_tipodocumento as tipoDocumentoLancamento, a.lcx_tipopagamento as tipoPagamentoLancamento, ");
            buf.append("a.lcx_nrcheque as numeroChequeLancamento, a.lcx_validadecartao as validadeCartaoLancamento, ");
            buf.append("a.lcx_nrcartao as numeroCartaoLancamento, ");
            buf.append("a.lcx_situacao = '").append("C").append("' as canceladoLancamento, ");
            buf.append("a.lcx_situacao = '").append("O").append("' as conciliadoLancamento, ");
            buf.append("a.lcx_situacao as situacaoLancamento, ");
            buf.append("a.lcx_cartaocredito as cartaoCreditoLancamento, a.lcx_conta as contaLancamento, ");
            buf.append("a.lcx_conciliacao as dataConciliacaoLancamento, a.lcx_vencimento as dataVencimentoLancamento, ");
            buf.append("a.lcx_competencia as dataCompetenciaLancamento, ");
            buf.append("a.usr_codigo as usuarioCancelamentoLancamento, a.lcx_datacancelado as dataCancelamentoLancamento, ");
            buf.append("a.lcx_nomedescfolha as nomeFuncionarioDescontoFolhaLancamento, ");
            buf.append("a.lcx_setordescfolha as setorFuncionarioDescontoFolhaLancamento, ");
            buf.append("a.lcx_autorizadodescfolha as nomeFuncionarioAutorizacaoDescontoFolhaLancamento, ");
            buf.append("usuariocancela.usr_nome as nomeUsuarioCancelamentoLancamento, '' as planosDeContas, '' as titularesReceberPagar, '' as codigoTitularesReceberPagar, ");
            buf.append("a.est_codigo as codigoEstacaoLancamento, estacoes.est_descricao as descricaoEstacaoLancamento, ");
            buf.append("conta.cco_reduzido as codigoReduzidoConta, conta.cco_conta as contaConta, conta.cco_titular as titularConta, a.lcx_tipotransferencia as tipoTransferencia, ");
            if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                buf.append("coalesce(conta.cco_sldinicial, 0) as saldoAnteriorConta, ");
            } else {
                buf.append("0 as saldoAnteriorConta, ");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                buf.append("coalesce((select slv.slv_saldo from saldocontasvencimento slv where slv.fil_codigo = a.fil_codigo and conta.cco_reduzido = slv.cco_reduzido and slv.slv_data < ");
                buf.append("'").append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial"))).append("' order by slv.slv_data desc limit 1), 0) as saldoAnteriorContaVencimento, ");
                buf.append("coalesce((select sld.sld_saldo from saldocontas sld where sld.fil_codigo = a.fil_codigo and conta.cco_reduzido = sld.cco_reduzido and sld.sld_data < ");
                buf.append("'").append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial"))).append("' order by sld.sld_data desc limit 1),0) as saldoAnteriorContaConciliado, ");
            } else {
                buf.append("0 as saldoAnteriorContaVencimento, ");
                buf.append("0 as saldoAnteriorContaConciliado, ");
            }
            buf.append("0 as somatorioValorLancamentos, 0 as valorFinalPeriodoContas, ");
            buf.append("usrlancto.usr_codigo as codigoUsuarioLancamento, usrlancto.usr_nome as nomeUsuarioLancamento, ");
            buf.append("motivo.mov_codigo as codigoMotivoCancelamento, motivo.mov_descricao as descricaoMotivoCancelamento, ");
            buf.append("a.lcx_descricaocancelado as descricaoCancelamentoLancamento, ");
            buf.append("historico.hpa_codigo as codigoHistoricoPadrao, historico.hpa_descricao as descricaoHistoricoPadrao, ");
            buf.append("a.lcx_descricaohistorico as descricaoHistoricoUsuario, ");
            buf.append("case when a.lcx_valortotal is null then 0 else a.lcx_valortotal end as valorTotalLancamento, ");
            buf.append("a.lcx_valormulta as valorMultaLancamento, ");
            buf.append("a.lcx_percentualmulta as percentualMultaLancamento, ");
            buf.append("a.lcx_valorjuro as valorJuroLancamento, ");
            buf.append("a.lcx_percentualjuro as percentualJuroLancamento, ");
            buf.append("a.lcx_valoracrescimo as valorAcrescimoLancamento, ");
            buf.append("a.lcx_percentualacrescimo as percentualAcrescimoLancamento, ");
            buf.append("a.lcx_valordesconto as valorDescontoLancamento, ");
            buf.append("a.lcx_percentualdesconto as percentualDescontoLancamento, ");
            buf.append("a.fil_codentrefilial as codigoFilialDestinoOrigem, ");
            buf.append("a.lcx_pix as pix, ");
            buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
            buf.append("from lanctocaixa a ");
            buf.append("left join usuario usuariocancela on a.usr_codcancelado = usuariocancela.usr_codigo ");
            buf.append("left join filiais_postocoleta filiais on filiais.fil_codigo = a.fil_codentrefilial ");
            buf.append("left join motivoscancelamentos motivo on a.fil_codigo = motivo.fil_codigo and a.mov_codigo = motivo.mov_codigo ");
            buf.append("left join historicopadrao historico on a.fil_codigo = historico.fil_codigo and a.hpa_codigo = historico.hpa_codigo ");
            buf.append("left join estacoes on a.est_codigo = estacoes.est_codigo ");
            buf.append("left join contacorrente conta on a.fil_codigo = conta.fil_codigo and a.cco_reduzido = conta.cco_reduzido ");
            buf.append("left join usuario usrlancto on a.usr_codigo = usrlancto.usr_codigo ");
            String[] planos = this.getSelecionadosFiltro("filtroPlanoConta", 0);
            if (null != planos && planos.length > 0) {
                buf.append("left join lanctocaixaplanoconta lc on a.fil_codigo = lc.fil_codigo and a.lcx_codigo = lc.lcx_codigo and a.est_codigo = lc.est_codigo ");
            }
            buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
            buf.append("where a.fil_codigo ");
            String[] filiais = null;
            if (this.naoPermiteFiltrarFilial()) {
                buf.append(" = ").append(Variaveis.filialPadrao);
            } else {
                filiais = this.getSelecionadosFiltro("filtroFilial", 0);
                if (filiais == null || filiais.length == 0) {
                    buf.append(" = ").append(Variaveis.filialPadrao);
                } else {
                    buf.append(" in (");
                    for (int i2 = 0; i2 < filiais.length; ++i2) {
                        buf.append(filiais[i2]);
                        if (i2 >= filiais.length - 1) continue;
                        buf.append(", ");
                    }
                    buf.append(")");
                }
            }
            String[] estacao = this.getSelecionadosFiltro("filtroEstacao", 0);
            if (estacao != null) {
                buf.append(" and a.est_codigo in (");
                for (int i3 = 0; i3 < estacao.length; ++i3) {
                    buf.append(estacao[i3]);
                    if (i3 >= estacao.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((usuario = this.getSelecionadosFiltro("filtroUsuario", 0)) != null) {
                buf.append(" and a.usr_codigo in (");
                for (int i4 = 0; i4 < usuario.length; ++i4) {
                    buf.append("'");
                    buf.append(usuario[i4]);
                    buf.append("'");
                    if (i4 >= usuario.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((conta = this.getSelecionadosFiltro("filtroConta", 0)) != null) {
                buf.append(" and a.cco_reduzido in (");
                for (int i5 = 0; i5 < conta.length; ++i5) {
                    buf.append(conta[i5]);
                    if (i5 >= conta.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if ((historicoPadrao = this.getSelecionadosFiltro("filtroHistoricoPadrao", 0)) != null) {
                buf.append(" and a.hpa_codigo in (");
                for (i = 0; i < historicoPadrao.length; ++i) {
                    buf.append(historicoPadrao[i]);
                    if (i >= historicoPadrao.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if (null != planos && planos.length > 0) {
                buf.append(" and lc.plc_reduzido in (");
                for (i = 0; i < planos.length; ++i) {
                    buf.append(planos[i]);
                    if (i >= planos.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(")");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataInicial"))) {
                buf.append(" and cast(a.").append(this.CAMPOSBANCODATA[this.getFiltroComboIndice("filtroCampoData")]).append(" as date) >= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataInicial")));
                buf.append("'");
            }
            if (Funcoes.verificaData(this.getFiltroData("filtroDataFinal"))) {
                buf.append(" and cast(a.").append(this.CAMPOSBANCODATA[this.getFiltroComboIndice("filtroCampoData")]).append(" as date) <= '");
                buf.append(Funcoes.formataData("MM/dd/yyyy", this.getFiltroData("filtroDataFinal")));
                buf.append("'");
            }
            if (this.auxTextHoraInicial.isEnabled() && Funcoes.verificaHora(this.getFiltroHora("filtroHoraInicial"))) {
                buf.append(" and cast(a.").append(this.CAMPOSBANCODATA[this.getFiltroComboIndice("filtroCampoData")]).append(" as time) >= '");
                buf.append(this.getFiltroHora("filtroHoraInicial"));
                buf.append("'");
            }
            if (this.auxTextHoraFinal.isEnabled() && Funcoes.verificaHora(this.getFiltroHora("filtroHoraFinal"))) {
                buf.append(" and cast(a.").append(this.CAMPOSBANCODATA[this.getFiltroComboIndice("filtroCampoData")]).append(" as time) <= '");
                buf.append(this.getFiltroHora("filtroHoraFinal"));
                buf.append("'");
            }
            if (!this.getFiltroCombo("filtroPagamento").toString().equals(this.itensPagamento[0])) {
                String combo = this.getFiltroCombo("filtroPagamento").toString();
                buf.append(" and a.lcx_tipopagamento IN ('");
                if (combo.equals(this.itensPagamento[1])) {
                    buf.append("H");
                } else if (combo.equals(this.itensPagamento[2])) {
                    buf.append("P");
                } else if (combo.equals(this.itensPagamento[3])) {
                    buf.append("A");
                } else if (combo.equals(this.itensPagamento[4])) {
                    buf.append("D");
                } else if (combo.equals(this.itensPagamento[5])) {
                    buf.append("T");
                } else if (combo.equals(this.itensPagamento[6])) {
                    buf.append("B");
                } else if (combo.equals(this.itensPagamento[7])) {
                    buf.append("E");
                } else if (combo.equals(this.itensPagamento[8])) {
                    buf.append("Z");
                } else if (combo.equals(this.itensPagamento[9])) {
                    buf.append("S");
                } else if (combo.equals(this.itensPagamento[10])) {
                    buf.append("I");
                } else if (combo.equals(this.itensPagamento[11])) {
                    buf.append("O");
                } else if (combo.equals(this.itensPagamento[12])) {
                    buf.append("C");
                } else if (combo.equals(this.itensPagamento[13])) {
                    buf.append("U");
                } else if (combo.equals(this.itensPagamento[14])) {
                    buf.append("N");
                } else if (combo.equals(this.itensPagamento[15])) {
                    buf.append("F");
                } else if (combo.equals(this.itensPagamento[16])) {
                    buf.append("W");
                } else if (combo.equals(this.itensPagamento[17])) {
                    buf.append("Y");
                }
                buf.append("') ");
            }
            if (this.getFiltroCombo("filtroSituacao").equals(this.situacao[1])) {
                buf.append(" and a.lcx_situacao = '").append("A").append("' ");
            } else if (this.getFiltroCombo("filtroSituacao").equals(this.situacao[2])) {
                buf.append(" and a.lcx_situacao = '").append("O").append("' ");
            } else if (this.getFiltroCombo("filtroSituacao").equals(this.situacao[3])) {
                buf.append(" and a.lcx_situacao = '").append("C").append("' ");
            } else if (this.getFiltroCombo("filtroSituacao").equals(this.situacao[4])) {
                buf.append(" and a.lcx_situacao <> '").append("C").append("' ");
            }
            if (this.getFiltroCombo("filtroTipo").equals(this.tipo[1])) {
                buf.append(" and a.lcx_tipo = '").append("C").append("' ");
            } else if (this.getFiltroCombo("filtroTipo").equals(this.tipo[2])) {
                buf.append(" and a.lcx_tipo = '").append("D").append("' ");
            }
            buf.append(" order by a.fil_codigo, a.cco_reduzido, ");
            if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[1])) {
                buf.append("a.").append(this.CAMPOSBANCODATA[this.getFiltroComboIndice("filtroCampoData")]);
            } else if (this.getFiltroCombo("ordemRelatorio").equals(this.ordem[2])) {
                buf.append("a.usr_codigo");
            } else {
                buf.append("a.lcx_codigo ");
            }
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                int i6;
                ModeloGridTable modelo = new ModeloGridTable(campos);
                BigDecimal somatorioValorLancamentos = new BigDecimal(0);
                BigDecimal valorFinalPeriodo = rs.getBigDecimal("saldoAnteriorConta");
                int codigoConta = rs.getInt("codigoReduzidoConta");
                do {
                    if (rs.getInt("codigoReduzidoConta") != codigoConta) {
                        somatorioValorLancamentos = new BigDecimal(0);
                        codigoConta = rs.getInt("codigoReduzidoConta");
                        valorFinalPeriodo = valorFinalPeriodo.add(rs.getBigDecimal("saldoAnteriorConta"));
                    }
                    if (rs.getString("tipoLancamento").equalsIgnoreCase("C")) {
                        somatorioValorLancamentos = somatorioValorLancamentos.add(rs.getBigDecimal("valorTotalLancamento"));
                        valorFinalPeriodo = valorFinalPeriodo.add(rs.getBigDecimal("valorTotalLancamento"));
                    } else {
                        somatorioValorLancamentos = somatorioValorLancamentos.subtract(rs.getBigDecimal("valorTotalLancamento"));
                        valorFinalPeriodo = valorFinalPeriodo.subtract(rs.getBigDecimal("valorTotalLancamento"));
                    }
                    Object[] o = new Object[campos.length];
                    for (i6 = 0; i6 < campos.length; ++i6) {
                        o[i6] = campos[i6].equals("tipoLancamento") ? Tipos.tipoLancamentoCaixa(rs.getString(campos[i6])) : (campos[i6].equals("indiceTipoLancamento") ? Integer.valueOf(rs.getString("tipoLancamento").equalsIgnoreCase("D") ? -1 : 1) : (campos[i6].equals("valorLancamento") && rs.getBigDecimal(campos[i6]) != null ? rs.getBigDecimal(campos[i6]).multiply(rs.getString("tipoLancamento").equalsIgnoreCase("D") && rs.getDouble(campos[i6]) > 0.0 ? new BigDecimal(-1) : new BigDecimal(1)) : (campos[i6].equals("valorTotalLancamento") ? rs.getBigDecimal(campos[i6]).multiply(rs.getString("tipoLancamento").equalsIgnoreCase("D") && rs.getDouble(campos[i6]) > 0.0 ? new BigDecimal(-1) : new BigDecimal(1)) : (campos[i6].equals("tipoDocumentoLancamento") ? Tipos.tipoDocumento(rs.getString(campos[i6])) : (campos[i6].equals("tipoUltimoPagamentoRequisicao") || campos[i6].equals("tipoPagamentoLancamento") ? Tipos.tipoPagamento(rs.getString(campos[i6])) : (campos[i6].equals("situacaoLancamento") ? Tipos.tipoSituacaoLancamento(rs.getString(campos[i6])) : (campos[i6].equals("somatorioValorLancamentos") ? somatorioValorLancamentos : (campos[i6].equals("planosDeContas") ? this.buscarDescricaoPlanosDeContas(st2, rs.getInt("codigoFilial"), rs.getInt("codigoLancamento"), rs.getInt("codigoEstacaoLancamento")) : (campos[i6].equals("titularesReceberPagar") ? this.buscarNomeTitularReceberPagar(st2, rs.getInt("codigoFilial"), rs.getInt("codigoLancamento"), rs.getInt("codigoEstacaoLancamento")) : (campos[i6].equals("codigoTitularesReceberPagar") ? this.buscarCodigoTitularReceberPagar(st2, rs.getInt("codigoFilial"), rs.getInt("codigoLancamento"), rs.getInt("codigoEstacaoLancamento")) : rs.getObject(campos[i6])))))))))));
                    }
                    modelo.addLine(o);
                } while (rs.next());
                int pos = modelo.findColumn("valorFinalPeriodoContas");
                for (i6 = 0; i6 < modelo.getRowCount(); ++i6) {
                    modelo.setValueAt(valorFinalPeriodo, i6, pos);
                }
                buf.delete(0, buf.length());
                buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                buf.append(RelatorioLancamento.getModuloAcesso());
                rs = Conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    int i7;
                    Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                    gerador.setPai(this.panelCentro);
                    gerador.setPreVisualizar(true);
                    gerador.setZoomPreVisualizar(0.5f);
                    gerador.setAcaoFechar(new Runnable(){

                        @Override
                        public void run() {
                            RelatorioLancamento.this.panelCentro.removeAll();
                            RelatorioLancamento.this.panelCentro.repaint();
                            RelatorioLancamento.this.habilitaBotaoImprimir(true);
                        }
                    });
                    HashMap<String, Object> var = new HashMap<String, Object>();
                    var.put("ordemRelatorio", this.getFiltroCombo("ordemRelatorio"));
                    var.put("filtroDataInicial", this.getFiltroData("filtroDataInicial"));
                    var.put("filtroDataFinal", this.getFiltroData("filtroDataFinal"));
                    var.put("filtroHoraInicial", this.getFiltroHora("filtroHoraInicial"));
                    var.put("filtroHoraFinal", this.getFiltroHora("filtroHoraFinal"));
                    var.put("filtroPagamento", this.getFiltroCombo("filtroPagamento"));
                    var.put("filtroSituacao", this.getFiltroCombo("filtroSituacao"));
                    buf.delete(0, buf.length());
                    if (this.naoPermiteFiltrarFilial()) {
                        var.put("filtroFilial", Variaveis.filialPadrao);
                    } else if (filiais != null) {
                        for (i7 = 0; i7 < filiais.length; ++i7) {
                            buf.append(filiais[i7]);
                            if (i7 >= filiais.length - 1) continue;
                            buf.append(", ");
                        }
                        var.put("filtroFilial", buf.toString());
                    }
                    buf.delete(0, buf.length());
                    if (estacao != null) {
                        for (i7 = 0; i7 < estacao.length; ++i7) {
                            buf.append(estacao[i7]);
                            if (i7 >= estacao.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroEstacao", buf.toString());
                    buf.delete(0, buf.length());
                    if (usuario != null) {
                        for (i7 = 0; i7 < usuario.length; ++i7) {
                            buf.append(usuario[i7]);
                            if (i7 >= usuario.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroUsuario", buf.toString());
                    buf.delete(0, buf.length());
                    if (planos != null) {
                        for (i7 = 0; i7 < planos.length; ++i7) {
                            buf.append(planos[i7]);
                            if (i7 >= planos.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroPlanoConta", buf.toString());
                    buf.delete(0, buf.length());
                    if (conta != null) {
                        for (i7 = 0; i7 < conta.length; ++i7) {
                            buf.append(conta[i7]);
                            if (i7 >= conta.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroConta", buf.toString());
                    buf.delete(0, buf.length());
                    if (historicoPadrao != null) {
                        for (i7 = 0; i7 < historicoPadrao.length; ++i7) {
                            buf.append(historicoPadrao[i7]);
                            if (i7 >= historicoPadrao.length - 1) continue;
                            buf.append(", ");
                        }
                    }
                    var.put("filtroHistoricoPadrao", buf.toString());
                    gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                    this.panelCentro.revalidate();
                }
            } else {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            rs.close();
            Conexao.fecharStatement(st);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private String buscarDescricaoPlanosDeContas(Statement st, int filial, int codigoLancamento, int codigoEstacao) throws SQLException {
        String retorno = "";
        String sql = "select b.plc_descricao from lanctocaixaplanoconta a left join planoconta b on a.fil_codigo = b.fil_codigo and a.plc_reduzido = b.plc_reduzido where a.fil_codigo = " + filial + "  and a.lcx_codigo = " + codigoLancamento + "  and a.est_codigo = " + codigoEstacao + "order by plc_descricao ";
        ResultSet rs = Conexao.executeQuery(st, sql);
        while (rs.next()) {
            if (retorno.contains(rs.getString("plc_descricao"))) continue;
            if (!Funcoes.textoVazio(retorno)) {
                retorno = retorno + ", ";
            }
            retorno = retorno + rs.getString("plc_descricao");
        }
        rs.close();
        return retorno;
    }

    private String buscarNomeTitularReceberPagar(Statement st, int filial, int codigoLancamento, int codigoEstacao) throws SQLException {
        String retorno = "";
        String sql = "select d.pac_nome, e.con_fantasia, f.ent_razaosocial, c.rpg_tipocadastro from baixalanctocaixa a left join baixareceberpagar b on a.fil_codigo = b.fil_codigo and a.bxa_codigo = b.bxa_codigo left join receberpagar c on b.fil_codigo = c.fil_codigo and b.rpg_codigo = c.rpg_codigo left join paciente d on c.fil_codigo = d.fil_codigo and c.pac_codigo = d.pac_codigo left join convenios e on c.fil_codigo = e.fil_codigo and c.con_codigo = e.con_codigo left join entidade f on c.fil_codigo = f.fil_codigo and c.ent_codigo = f.ent_codigo where a.fil_codigo = " + filial + "  and a.lcx_codigo = " + codigoLancamento + "  and a.est_codigo = " + codigoEstacao;
        ResultSet rs = Conexao.executeQuery(st, sql);
        while (rs.next()) {
            String tmp = rs.getString("ent_razaosocial");
            if (rs.getString("rpg_tipocadastro").equals("P")) {
                tmp = rs.getString("pac_nome");
            } else if (rs.getString("rpg_tipocadastro").equals("O")) {
                tmp = rs.getString("con_fantasia");
            }
            if (Funcoes.textoVazio(tmp) || retorno.contains(tmp)) continue;
            if (!Funcoes.textoVazio(retorno)) {
                retorno = retorno + ", ";
            }
            retorno = retorno + tmp;
        }
        rs.close();
        return retorno;
    }

    private String buscarCodigoTitularReceberPagar(Statement st, int filial, int codigoLancamento, int codigoEstacao) throws SQLException {
        String retorno = "";
        String sql = "select d.pac_codigo, e.con_codigo, f.ent_codigo, c.rpg_tipocadastro from baixalanctocaixa a left join baixareceberpagar b on a.fil_codigo = b.fil_codigo and a.bxa_codigo = b.bxa_codigo left join receberpagar c on b.fil_codigo = c.fil_codigo and b.rpg_codigo = c.rpg_codigo left join paciente d on c.fil_codigo = d.fil_codigo and c.pac_codigo = d.pac_codigo left join convenios e on c.fil_codigo = e.fil_codigo and c.con_codigo = e.con_codigo left join entidade f on c.fil_codigo = f.fil_codigo and c.ent_codigo = f.ent_codigo where a.fil_codigo = " + filial + "  and a.lcx_codigo = " + codigoLancamento + "  and a.est_codigo = " + codigoEstacao;
        ResultSet rs = Conexao.executeQuery(st, sql);
        while (rs.next()) {
            String tmp = rs.getString("ent_codigo");
            if (rs.getString("rpg_tipocadastro").equals("P")) {
                tmp = rs.getString("pac_codigo");
            } else if (rs.getString("rpg_tipocadastro").equals("O")) {
                tmp = rs.getString("con_codigo");
            }
            if (Funcoes.textoVazio(tmp) || retorno.contains(tmp)) continue;
            if (!Funcoes.textoVazio(retorno)) {
                retorno = retorno + ", ";
            }
            retorno = retorno + tmp;
        }
        rs.close();
        return retorno;
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0850400100");
    }

    public static long getModuloAcessoNaoPermiteFiltrarFilial() {
        return Long.parseLong("0850400102");
    }

    public boolean naoPermiteFiltrarFilial() {
        return Acesso.getAcesso(RelatorioLancamento.getModuloAcessoNaoPermiteFiltrarFilial());
    }
}

