/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.relatorios.financeiro.movimento;

import jalis.comum.Conexao;
import jalis.comum.ConstantesGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmRelPadrao;
import jalis.comum.padroes.ImprimirRelatorioListener;
import jalis.laboratorio.relatorios.util.Constantes;
import jalis.relatorio.Gerador;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.logger.ErrorLogger;
import java.awt.Cursor;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Calendar;
import java.util.HashMap;
import javax.swing.table.TableModel;

public class RelatorioFluxoCaixaSemanalPrevisto
extends FrmRelPadrao
implements ImprimirRelatorioListener {
    private static final String FILTRO_FILIAL_CONTA = "filtroFilialConta";
    private static final String FILTRO_USUARIO = "filtroUsuario";
    private static final String FILTRO_MES = "filtroMes";
    private static final String FILTRO_ANO = "filtroAno";
    private static final String FILTRO_NIVEL = "filtroNivel";
    private static final String FILTRO_DATAS = "filtroDatas";
    private static final String FILTRO_ORIGEM = "filtroOrigem";
    private static final String FILTRO_CONVENIO = "filtroConvenio";
    private static final String FILTRO_ENTIDADE = "filtroEntidade";
    private static final String FILTRO_PACIENTE = "filtroPaciente";
    private final String[] MESES = ConstantesGerais.MESES_ANO;
    private static final String[] camposRelatorio = ArraysUtil.concatenar(Constantes.CAMPOS_FILIAL, new String[]{"descricaoConta", "reduzidoConta", "tipoConta", "data1", "data2", "data3", "data4", "data5", "data6", "data7", "data8", "data9", "data10", "valor1", "valor2", "valor3", "valor4", "valor5", "somatorio1", "somatorio2", "somatorio3", "somatorio4", "somatorio5", "valorComSinal1", "valorComSinal2", "valorComSinal3", "valorComSinal4", "valorComSinal5", "somatorioComSinal1", "somatorioComSinal2", "somatorioComSinal3", "somatorioComSinal4", "somatorioComSinal5", "valorSaldoInicial", "total1", "total2", "total3", "total4", "total5"});
    private final String[] CAMPOSDATA = new String[]{"Vencimento", "Compet\u00eancia", "Emiss\u00e3o", "Processamento"};
    private final String[] CAMPOSDATABANCO = new String[]{"rpg_vencimento", "rpg_competencia", "rpg_datahora", "rpg_dataprocessamento"};
    public static final int TIPO_PLANOCONTA = 0;
    public static final int TIPO_CENTROCUSTO = 1;
    private int tipoRelatorio = 0;
    private int QTDE_PERIODOS = 5;
    private boolean naoHaPlanosCentros = false;

    public RelatorioFluxoCaixaSemanalPrevisto(int tipoRelatorio) {
        this.tipoRelatorio = tipoRelatorio;
        if (tipoRelatorio == 0) {
            this.montaBarraDescricao("<html>Relat\u00f3rio de fluxo de caixa previsto semanal por <br>plano de contas</html>", "Acumulado das previs\u00f5es de recebimento/pagamento nas contas por semana", "relatorios/rel_fluxo_caixa_previsto_semanal_plano.jpg");
        } else {
            this.montaBarraDescricao("<html>Relat\u00f3rio de fluxo de caixa previsto semanal por <br>centro de custo</html>", "Acumulado das previs\u00f5es de recebimento/pagamento nos centros de custo por semana", "relatorios/rel_financeiro_movimento_centro_custo_fluxo_caixa_previsto_semanal_centro_custo.jpg");
        }
        this.adicionaRelatorioListener(this);
        this.adicionaItemFiltro(FILTRO_FILIAL_CONTA, "Filial", "filiais_postocoleta", "", 1, new String[]{"fil_codigo", "fil_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_USUARIO, "Usu\u00e1rio", "usuario", " usr_inativo = false ", 1, new String[]{"usr_codigo", "usr_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_ORIGEM, "Origem", "origemplanocusto", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"opc_codigo", "opc_descricao", "opc_padrao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o", "Padr\u00e3o"}, new int[]{70, 0, 50});
        this.adicionaItemFiltro(FILTRO_CONVENIO, "Conv\u00eanio", "convenios", "fil_codigo = " + Variaveis.filialPadrao, 1, new String[]{"con_codigo", "con_fantasia"}, new String[]{"C\u00f3digo", "Nome Fantasia"}, new int[]{70, 0});
        this.adicionaItemFiltro(FILTRO_ENTIDADE, "Entidade", "entidade", "fil_codigo = " + Variaveis.filialPadrao + " and ent_inativo = false", 1, new String[]{"ent_codigo", "ent_razaosocial"}, new String[]{"C\u00f3digo", "Raz\u00e3o Social"}, new int[]{70, 0});
        this.adicionaItemFiltroAvancado(FILTRO_PACIENTE, "Paciente", "paciente", "fil_codigo = " + Variaveis.filialPadrao, 2, new String[]{"pac_codigo", "pac_nome"}, new String[]{"C\u00f3digo", "Nome"}, new int[]{70, 0}, false, new int[]{70, 0});
        try {
            String selectNivel = "";
            selectNivel = tipoRelatorio == 0 ? "select max(plc_nivel) as qtde from planoconta " : "select max(ccu_nivel) as qtde from centrocusto ";
            ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), selectNivel);
            if (rs.next()) {
                Object[] arrayNiveis = new Integer[rs.getInt("qtde")];
                for (int i = 1; i <= rs.getInt("qtde"); ++i) {
                    arrayNiveis[i - 1] = i;
                }
                if (tipoRelatorio == 0) {
                    this.adicionaFiltroCombo(FILTRO_NIVEL, "N\u00edvel Plano", arrayNiveis, rs.getInt("qtde") - 1);
                } else {
                    this.adicionaFiltroCombo(FILTRO_NIVEL, "N\u00edvel", arrayNiveis, rs.getInt("qtde") - 1);
                }
                if (arrayNiveis.length == 0) {
                    this.naoHaPlanosCentros = true;
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel identificar os n\u00edveis. " + ex.getMessage(), ex.getStackTrace());
        }
        Calendar dataAtual = Calendar.getInstance();
        this.adicionaFiltroCombo(FILTRO_DATAS, "Campo Data", this.CAMPOSDATA, 0);
        this.adicionaFiltroCombo(FILTRO_MES, "M\u00eas Compet.", this.MESES, dataAtual.get(2));
        this.adicionaFiltroNumero(FILTRO_ANO, "Ano Compet.", 4);
        this.setFiltroNumero(FILTRO_ANO, String.valueOf(dataAtual.get(1)));
        this.setModuloConfigurar(this.getConfigurarAcesso(this.tipoRelatorio));
        this.setModuloAcesso(RelatorioFluxoCaixaSemanalPrevisto.getModuloAcesso(this.tipoRelatorio));
        this.setCamposConfigurador(camposRelatorio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void imprimirPressionado() {
        Statement st;
        block84: {
            st = Conexao.getStatement();
            String[] origem = null;
            StringBuilder whereAux = new StringBuilder();
            if (this.naoHaPlanosCentros) {
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 " + (this.tipoRelatorio == 0 ? "planos de contas" : "centros de custo") + " cadastrados.", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            String[] filiais = this.getSelecionadosFiltro(FILTRO_FILIAL_CONTA, 0);
            String filAux = "";
            if (filiais != null && filiais.length > 1) {
                Funcoes.mensagem(this, "Apenas uma filial deve ser selecionada para o relat\u00f3rio. ", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            if (this.getFiltroNumero(FILTRO_ANO).equals("")) {
                Funcoes.mensagem(this, "Insira um ano de compet\u00eancia. ", 2);
                this.habilitaBotaoImprimir(true);
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                int nivel;
                int j;
                String[] paciente;
                String[] entidade;
                int j2;
                String dataBase = this.getFiltroNumero(FILTRO_ANO).toString() + "-" + (this.getFiltroComboIndice(FILTRO_MES) + 1) + "-01";
                String selectData = "";
                selectData = selectData + "select  date_trunc('month', cast('" + dataBase + "' as date)) as semana1 ";
                selectData = selectData + "       ,date_trunc('month', cast('" + dataBase + "' as date)) + interval '5 day' as semana2 ";
                selectData = selectData + "       ,date_trunc('month', cast('" + dataBase + "' as date)) + interval '6 day' as semana3 ";
                selectData = selectData + "       ,date_trunc('month', cast('" + dataBase + "' as date)) + interval '11 day' as semana4 ";
                selectData = selectData + "       ,date_trunc('month', cast('" + dataBase + "' as date)) + interval '12 day' as semana5 ";
                selectData = selectData + "       ,date_trunc('month', cast('" + dataBase + "' as date)) + interval '17 day' as semana6 ";
                selectData = selectData + "       ,date_trunc('month', cast('" + dataBase + "' as date)) + interval '18 day' as semana7 ";
                selectData = selectData + "       ,date_trunc('month', cast('" + dataBase + "' as date)) + interval '23 day' as semana8 ";
                selectData = selectData + "       ,date_trunc('month', cast('" + dataBase + "' as date)) + interval '24 day' as semana9 ";
                selectData = selectData + "       ,date_trunc('month', cast('" + dataBase + "' as date)) + interval '1 month' - interval '1 day' as semana10 ";
                ResultSet rs = Conexao.executeQuery(st, selectData);
                String[] arraySemanas = new String[10];
                if (rs.next()) {
                    for (j2 = 1; j2 <= 10; ++j2) {
                        arraySemanas[j2 - 1] = rs.getString("semana" + j2);
                    }
                }
                if (filiais == null || filiais.length == 0) {
                    filAux = filAux + " = " + Variaveis.filialPadrao;
                } else {
                    filAux = filAux + " in (";
                    for (j2 = 0; j2 < filiais.length; ++j2) {
                        filAux = filAux + filiais[j2];
                        if (j2 >= filiais.length - 1) continue;
                        filAux = filAux + ", ";
                    }
                    filAux = filAux + ")";
                }
                int qtdePlanos = 0;
                int maxNivel = 0;
                String selectAux = "";
                selectAux = selectAux + "select count(1) as qtde ";
                selectAux = this.tipoRelatorio == 0 ? selectAux + "  from planoconta plc where plc.fil_codigo  " : selectAux + "  from centrocusto ccu where ccu.fil_codigo  ";
                selectAux = selectAux + filAux + " ";
                rs = Conexao.executeQuery(st, selectAux);
                if (rs.next()) {
                    qtdePlanos = rs.getInt("qtde");
                }
                selectAux = "";
                if (this.tipoRelatorio == 0) {
                    selectAux = selectAux + "select max(plc_nivel) as maxNivel ";
                    selectAux = selectAux + "  from planoconta plc where plc.fil_codigo  ";
                } else {
                    selectAux = selectAux + "select max(ccu_nivel) as maxNivel ";
                    selectAux = selectAux + "  from centrocusto ccu where ccu.fil_codigo  ";
                }
                selectAux = selectAux + filAux + " ";
                rs = Conexao.executeQuery(st, selectAux);
                if (rs.next()) {
                    maxNivel = rs.getInt("maxNivel");
                }
                rs.close();
                StringBuilder buf = null;
                String[] usuario = null;
                ArrayDados[] arrayDados = new ArrayDados[qtdePlanos];
                StringBuilder bufUsuario = new StringBuilder();
                String[] convenio = this.getSelecionadosFiltro(FILTRO_CONVENIO, 0);
                if (convenio != null) {
                    bufUsuario.append(" rpg.con_codigo in (");
                    for (int j3 = 0; j3 < convenio.length; ++j3) {
                        bufUsuario.append(convenio[j3]);
                        if (j3 >= convenio.length - 1) continue;
                        bufUsuario.append(", ");
                    }
                    bufUsuario.append(")");
                }
                if ((entidade = this.getSelecionadosFiltro(FILTRO_ENTIDADE, 0)) != null) {
                    if (bufUsuario.length() > 0) {
                        bufUsuario.append(" or ");
                    }
                    bufUsuario.append(" rpg.ent_codigo in (");
                    for (int j4 = 0; j4 < entidade.length; ++j4) {
                        bufUsuario.append("'");
                        bufUsuario.append(entidade[j4]);
                        bufUsuario.append("'");
                        if (j4 >= entidade.length - 1) continue;
                        bufUsuario.append(", ");
                    }
                    bufUsuario.append(")");
                }
                if ((paciente = this.getSelecionadosFiltroAvancado(FILTRO_PACIENTE, 0)) != null) {
                    if (bufUsuario.length() > 0) {
                        bufUsuario.append(" or ");
                    }
                    bufUsuario.append(" rpg.pac_codigo in (");
                    for (j = 0; j < paciente.length; ++j) {
                        bufUsuario.append(paciente[j]);
                        if (j >= paciente.length - 1) continue;
                        bufUsuario.append(", ");
                    }
                    bufUsuario.append(")");
                }
                for (int i = 1; i <= this.QTDE_PERIODOS; ++i) {
                    int j5;
                    whereAux = new StringBuilder();
                    String data1 = arraySemanas[2 * i - 2];
                    String data2 = arraySemanas[2 * i - 1];
                    usuario = this.getSelecionadosFiltro(FILTRO_USUARIO, 0);
                    if (usuario != null) {
                        whereAux.append(" (rpg.usr_codigo in (");
                        for (j5 = 0; j5 < usuario.length; ++j5) {
                            whereAux.append("'").append(usuario[j5]).append("'");
                            if (j5 >= usuario.length - 1) continue;
                            whereAux.append(", ");
                        }
                        whereAux.append(") OR rpg.usr_codigo IS NULL)");
                    }
                    if ((origem = this.getSelecionadosFiltro(FILTRO_ORIGEM, 0)) != null) {
                        if (whereAux.toString().length() > 0) {
                            whereAux.append(" and ");
                        }
                        whereAux.append(" rpl.opc_codigo in (");
                        for (j5 = 0; j5 < origem.length; ++j5) {
                            whereAux.append("'");
                            whereAux.append(origem[j5]);
                            whereAux.append("'");
                            if (j5 >= origem.length - 1) continue;
                            whereAux.append(", ");
                        }
                        whereAux.append(")");
                    }
                    buf = new StringBuilder();
                    buf.append("select ");
                    buf.append("filial.fil_codigo as codigoFilial, filial.fil_descricao as descricaoFilial, filial.fil_cnpj as cnpjFilial, filial.fil_endereco as enderecoFilial, filial.fil_complemento as complementoFilial, filial.fil_cep as cepFilial, filial.fil_fone as foneFilial, filial.fil_fax as faxFilial, filial.fil_razaosocial as razaoSocialFilial, filial.fil_cnes as CNESFilial, cidadefilial.cid_codigo as codigoCidadeFilial, cidadefilial.cid_nome as descricaoCidadeFilial, cidadefilial.cid_uf as estadoCidadeFilial,bairrofilial.bai_codigo as codigoBairroFilial, bairrofilial.bai_descricao as descricaoBairroFilial ");
                    buf.append("\t\t  ,a.plc_reduzido as reduzidoConta ");
                    buf.append("      ,a.plc_descricao as descricaoConta ");
                    if (this.tipoRelatorio == 0) {
                        buf.append("      ,a.plc_tipo as tipoConta");
                    } else {
                        buf.append("      ,'X' as tipoConta");
                    }
                    buf.append("      ,a.plc_pai as paiConta");
                    buf.append("      ,a.plc_nivel as nivelConta");
                    buf.append("      ,case when plc_valor is null then ");
                    buf.append("\t          0 ");
                    buf.append("       else ");
                    buf.append("            plc_valor ");
                    buf.append("       end ");
                    buf.append("       as valorConta ");
                    buf.append("      ,case when plc_valorcomsinal is null then ");
                    buf.append("\t          0 ");
                    buf.append("       else ");
                    buf.append("            plc_valorcomsinal ");
                    buf.append("       end as valorContaComSinal ");
                    buf.append("  from (select plc.fil_codigo");
                    buf.append("\t\t          ,plc.plc_reduzido ");
                    buf.append("              ,plc.plc_descricao ");
                    buf.append("              ,plc.plc_tipo ");
                    buf.append("              ,plc.plc_conta ");
                    buf.append("              ,plc.plc_pai ");
                    buf.append("              ,plc.plc_nivel ");
                    buf.append("              ,plc.plc_operacao ");
                    buf.append("              ,SUM(CASE WHEN plc.plc_operacao = '").append("A").append("' THEN ");
                    buf.append("                             res.rpl_valor ");
                    buf.append("                        ELSE ");
                    buf.append("                             (res.rpl_valor * -1)");
                    buf.append("                        END ");
                    buf.append("               ) as plc_valorcomsinal ");
                    if (this.tipoRelatorio == 0) {
                        buf.append("              ,SUM(case when plc.plc_tipo = '").append("R").append("' then ");
                        buf.append("\t\t\t                       res.rpl_valor ");
                        buf.append("\t                 else ");
                        buf.append("\t\t\t                       (res.rpl_valor * -1) ");
                        buf.append("                   end ");
                    } else {
                        buf.append("              ,SUM(case when res.rpg_tipo = '").append("R").append("' then ");
                        buf.append("\t\t\t                  res.rpl_valor ");
                        buf.append("\t\t               else ");
                        buf.append("\t\t\t                  (res.rpl_valor * -1) ");
                        buf.append("\t\t               end ");
                    }
                    buf.append("               ) as plc_valor ");
                    buf.append("          from planoconta plc ");
                    buf.append("     left join (select rpl.fil_codigo ");
                    buf.append("                      ,rpl.plc_reduzido ");
                    buf.append("                      ,rpg.rpg_tipo ");
                    buf.append("                      ,SUM(rpl.rpl_valor) as rpl_valor ");
                    buf.append("                  from receberpagarplanoconta rpl ");
                    buf.append("                  left join receberpagar rpg on (rpl.fil_codigo = rpg.fil_codigo and rpl.rpg_codigo = rpg.rpg_codigo) ");
                    buf.append("                 where ");
                    buf.append("                       rpg.rpg_situacao IN ('").append("A").append("', '").append("Q").append("', '");
                    buf.append("V").append("', '").append("T").append("', '").append("S").append("') ");
                    buf.append("and" + whereAux + " ");
                    buf.append(whereAux.toString().length() > 0 ? " and " : "");
                    buf.append("                   cast(rpg.");
                    buf.append(this.CAMPOSDATABANCO[this.getFiltroComboIndice(FILTRO_DATAS)]);
                    buf.append(" as date) >= cast('" + data1 + "' as date) ");
                    buf.append(" and cast(rpg.");
                    buf.append(this.CAMPOSDATABANCO[this.getFiltroComboIndice(FILTRO_DATAS)]);
                    buf.append(" as date) <= cast('" + data2 + "' as date) ");
                    if (bufUsuario.length() > 0) {
                        buf.append(" and (").append(bufUsuario.toString()).append(") ");
                    }
                    buf.append("                 group by rpl.fil_codigo ");
                    buf.append("                         ,rpl.plc_reduzido ");
                    buf.append("                         ,rpg.rpg_tipo");
                    buf.append("               ) as res ");
                    buf.append("            on (plc.fil_codigo = res.fil_codigo and plc.plc_reduzido = res.plc_reduzido) ");
                    buf.append("         where plc.fil_codigo  ");
                    buf.append(filAux + " ");
                    buf.append("      group by plc.fil_codigo, plc.plc_reduzido, plc.plc_descricao, plc.plc_tipo, plc_pai, plc_nivel, plc.plc_operacao, plc.plc_conta) a ");
                    buf.append("left join filiais_postocoleta filial on a.fil_codigo = filial.fil_codigo left join cidades cidadefilial on filial.fil_codigo = cidadefilial.fil_codigo and filial.cid_codigo = cidadefilial.cid_codigo left join bairro bairrofilial on filial.fil_codigo = bairrofilial.fil_codigo and filial.bai_codigo = bairrofilial.bai_codigo ");
                    buf.append(" order by a.plc_conta ");
                    if (this.tipoRelatorio == 1) {
                        String aux = buf.toString();
                        aux = aux.replaceAll("plc", "ccu");
                        aux = aux.replaceAll("planoconta", "centrocusto");
                        aux = aux.replaceAll("rpl", "rcc");
                        aux = aux.replaceAll("rpl_valor", "rcc_valor");
                        aux = aux.replaceAll(", ccu.ccu_tipo", " ");
                        aux = aux.replaceAll(",ccu.ccu_tipo", " ");
                        aux = aux.replaceAll("ccu.ccu_tipo", " ");
                        buf.delete(0, buf.length());
                        buf.append(aux);
                    }
                    rs = Conexao.executeQuery(st, buf);
                    j5 = 0;
                    while (rs.next()) {
                        if (arrayDados[j5] == null) {
                            arrayDados[j5] = new ArrayDados(rs.getInt("reduzidoConta"), rs.getInt("paiConta"), rs.getInt("nivelConta"));
                        }
                        arrayDados[j5].valoresPlano[i - 1] = rs.getFloat("valorConta");
                        arrayDados[j5].valoresPlanoComSinal[i - 1] = rs.getFloat("valorContaComSinal");
                        ++j5;
                    }
                }
                for (j = maxNivel; j > Integer.parseInt(this.getFiltroCombo(FILTRO_NIVEL).toString()); --j) {
                    for (int k = 0; k < arrayDados.length; ++k) {
                        for (int l = 0; l < arrayDados[k].valoresPlano.length; ++l) {
                            if (arrayDados[k].nivelPlano != j || arrayDados[k].paiPlano == -1) continue;
                            int n = l;
                            arrayDados[this.getIndicePlano((ArrayDados[])arrayDados, (int)arrayDados[k].paiPlano)].valoresPlano[n] = arrayDados[this.getIndicePlano((ArrayDados[])arrayDados, (int)arrayDados[k].paiPlano)].valoresPlano[n] + arrayDados[k].valoresPlano[l];
                            int n2 = l;
                            arrayDados[this.getIndicePlano((ArrayDados[])arrayDados, (int)arrayDados[k].paiPlano)].valoresPlanoComSinal[n2] = arrayDados[this.getIndicePlano((ArrayDados[])arrayDados, (int)arrayDados[k].paiPlano)].valoresPlanoComSinal[n2] + arrayDados[k].valoresPlanoComSinal[l];
                        }
                    }
                }
                for (int j6 = nivel = Integer.parseInt(this.getFiltroCombo(FILTRO_NIVEL).toString()); j6 > 0; --j6) {
                    for (int k = 0; k < arrayDados.length; ++k) {
                        for (int l = 0; l < arrayDados[k].valoresPlano.length; ++l) {
                            int indicePlano;
                            if (arrayDados[k].nivelPlano != j6 || arrayDados[k].paiPlano == -1 || (indicePlano = this.getIndicePlano(arrayDados, arrayDados[k].paiPlano)) <= -1) continue;
                            int n = l;
                            arrayDados[indicePlano].valoresPlano[n] = arrayDados[indicePlano].valoresPlano[n] + arrayDados[k].valoresPlano[l];
                            int n3 = l;
                            arrayDados[indicePlano].valoresPlanoComSinal[n3] = arrayDados[indicePlano].valoresPlanoComSinal[n3] + arrayDados[k].valoresPlanoComSinal[l];
                        }
                    }
                }
                rs.beforeFirst();
                ModeloGridTable modelo = new ModeloGridTable(camposRelatorio);
                int aux = -1;
                while (rs.next()) {
                    ++aux;
                    if (rs.getInt("nivelConta") > Integer.parseInt(this.getFiltroCombo(FILTRO_NIVEL).toString())) continue;
                    Object[] o = new Object[camposRelatorio.length];
                    for (int i = 0; i < camposRelatorio.length; ++i) {
                        if (camposRelatorio[i].equals("tipoConta")) {
                            if (rs.getString(camposRelatorio[i]).equals("R")) {
                                o[modelo.findColumn((String)RelatorioFluxoCaixaSemanalPrevisto.camposRelatorio[i])] = "ENTRADAS";
                                continue;
                            }
                            if (rs.getString(camposRelatorio[i]).equals("D")) {
                                o[modelo.findColumn((String)RelatorioFluxoCaixaSemanalPrevisto.camposRelatorio[i])] = "SA\u00cdDAS";
                                continue;
                            }
                            o[modelo.findColumn((String)RelatorioFluxoCaixaSemanalPrevisto.camposRelatorio[i])] = "CENTROS DE CUSTO";
                            continue;
                        }
                        if (camposRelatorio[i].equalsIgnoreCase("valorSaldoInicial")) continue;
                        if (camposRelatorio[i].substring(0, 4).equals("data")) {
                            if (camposRelatorio[i].length() == 5) {
                                o[modelo.findColumn((String)RelatorioFluxoCaixaSemanalPrevisto.camposRelatorio[i])] = arraySemanas[Integer.valueOf(camposRelatorio[i].substring(4, 5)) - 1];
                                continue;
                            }
                            o[modelo.findColumn((String)RelatorioFluxoCaixaSemanalPrevisto.camposRelatorio[i])] = arraySemanas[Integer.valueOf(camposRelatorio[i].substring(4, 6)) - 1];
                            continue;
                        }
                        if (camposRelatorio[i].length() >= 13 && camposRelatorio[i].substring(0, 13).equals("valorComSinal")) {
                            o[modelo.findColumn((String)RelatorioFluxoCaixaSemanalPrevisto.camposRelatorio[i])] = Float.valueOf(arrayDados[aux].valoresPlanoComSinal[Integer.valueOf(camposRelatorio[i].substring(13, 14)) - 1]);
                            continue;
                        }
                        if (camposRelatorio[i].substring(0, 5).equals("valor")) {
                            o[modelo.findColumn((String)RelatorioFluxoCaixaSemanalPrevisto.camposRelatorio[i])] = Float.valueOf(arrayDados[aux].valoresPlano[Integer.valueOf(camposRelatorio[i].substring(5, 6)) - 1]);
                            continue;
                        }
                        if (camposRelatorio[i].length() >= 17 && camposRelatorio[i].substring(0, 17).equals("somatorioComSinal")) {
                            if (rs.getInt("nivelConta") != 1) continue;
                            o[modelo.findColumn((String)RelatorioFluxoCaixaSemanalPrevisto.camposRelatorio[i])] = Float.valueOf(arrayDados[aux].valoresPlanoComSinal[Integer.valueOf(camposRelatorio[i].substring(17, 18)) - 1]);
                            continue;
                        }
                        if (camposRelatorio[i].length() <= 7 && camposRelatorio[i].substring(0, 5).equals("total")) {
                            String campo = camposRelatorio[i].replace("total", "");
                            if (rs.getInt("nivelConta") != 1) continue;
                            o[modelo.findColumn((String)RelatorioFluxoCaixaSemanalPrevisto.camposRelatorio[i])] = Float.valueOf(arrayDados[aux].valoresPlanoComSinal[Integer.valueOf(campo) - 1]);
                            continue;
                        }
                        if (camposRelatorio[i].substring(0, 9).equals("somatorio")) {
                            if (this.tipoRelatorio == 0) {
                                if (rs.getString("tipoConta").equals("R")) {
                                    o[modelo.findColumn((String)RelatorioFluxoCaixaSemanalPrevisto.camposRelatorio[i])] = Float.valueOf(arrayDados[aux].valoresPlano[Integer.valueOf(camposRelatorio[i].substring(9, 10)) - 1]);
                                    continue;
                                }
                                o[modelo.findColumn((String)RelatorioFluxoCaixaSemanalPrevisto.camposRelatorio[i])] = Float.valueOf(arrayDados[aux].valoresPlano[Integer.parseInt(camposRelatorio[i].substring(9, 10)) - 1] * -1.0f);
                                continue;
                            }
                            o[modelo.findColumn((String)RelatorioFluxoCaixaSemanalPrevisto.camposRelatorio[i])] = Float.valueOf(arrayDados[aux].valoresPlano[Integer.valueOf(camposRelatorio[i].substring(9, 10)) - 1]);
                            continue;
                        }
                        o[modelo.findColumn((String)RelatorioFluxoCaixaSemanalPrevisto.camposRelatorio[i])] = rs.getObject(camposRelatorio[i]);
                    }
                    modelo.addLine(o);
                }
                if (modelo.getRowCount() > 0) {
                    int i;
                    if (buf != null) {
                        buf.delete(0, buf.length());
                    } else {
                        buf = new StringBuilder();
                    }
                    buf.append(" select SUM(case when plc.plc_operacao = '").append("A").append("' then ");
                    buf.append("                      rpl.rpl_valor ");
                    buf.append("            else (");
                    buf.append("                      rpl.rpl_valor * (-1) ) ");
                    buf.append("            end) as saldoInicial ");
                    buf.append("   from receberpagarplanoconta rpl ");
                    buf.append("       ,receberpagar rpg ");
                    buf.append("       ,planoconta plc ");
                    buf.append("  where rpl.fil_codigo = rpg.fil_codigo ");
                    buf.append("    and rpl.rpg_codigo = rpg.rpg_codigo ");
                    buf.append("    and rpl.fil_codigo = plc.fil_codigo ");
                    buf.append("    and rpl.plc_reduzido = plc.plc_reduzido ");
                    buf.append("    and rpg.rpg_situacao IN ('").append("A").append("', '").append("Q").append("', '");
                    buf.append("V").append("', '").append("T").append("', '").append("S").append("') ");
                    if (whereAux.length() > 0) {
                        buf.append(" and ").append((CharSequence)whereAux);
                    }
                    buf.append("    and cast(").append(this.CAMPOSDATABANCO[this.getFiltroComboIndice(FILTRO_DATAS)]).append(" as date ) ");
                    buf.append(" < '").append(dataBase).append("' ");
                    buf.append("    and rpg.fil_codigo ").append(filAux).append(" ");
                    if (bufUsuario.length() > 0) {
                        buf.append(" and (").append(bufUsuario.toString()).append(") ");
                    }
                    if (this.tipoRelatorio == 1) {
                        String auxBuf = buf.toString();
                        auxBuf = auxBuf.replaceAll("plc", "ccu");
                        auxBuf = auxBuf.replaceAll("planoconta", "centrocusto");
                        auxBuf = auxBuf.replaceAll("rpl", "rcc");
                        auxBuf = auxBuf.replaceAll("rpl_valor", "rcc_valor");
                        auxBuf = auxBuf.replaceAll(", ccu.ccu_tipo", " ");
                        auxBuf = auxBuf.replaceAll(",ccu.ccu_tipo", " ");
                        auxBuf = auxBuf.replaceAll("ccu.ccu_tipo", " ");
                        buf.delete(0, buf.length());
                        buf.append(auxBuf);
                    }
                    if ((rs = st.executeQuery(buf.toString())).next()) {
                        for (i = 0; i < modelo.getRowCount(); ++i) {
                            modelo.setValueAt(rs.getBigDecimal("saldoInicial") == null ? new BigDecimal(0.0) : rs.getBigDecimal("saldoInicial"), i, modelo.findColumn("valorSaldoInicial"));
                        }
                    } else {
                        for (i = 0; i < modelo.getRowCount(); ++i) {
                            modelo.setValueAt(new BigDecimal(0.0), i, modelo.findColumn("valorSaldoInicial"));
                        }
                    }
                    buf.delete(0, buf.length());
                    buf.append("select rel_xml from relatoriosistema where rel_codigo = ");
                    if (this.tipoRelatorio == 0) {
                        buf.append(RelatorioFluxoCaixaSemanalPrevisto.getModuloAcesso(0));
                    } else {
                        buf.append(RelatorioFluxoCaixaSemanalPrevisto.getModuloAcesso(1));
                    }
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        Gerador gerador = new Gerador(ParametrosLocais.getParametro("impressoraRelatorio"));
                        gerador.setPai(this.panelCentro);
                        gerador.setPreVisualizar(true);
                        gerador.setZoomPreVisualizar(1.0f);
                        gerador.setAcaoFechar(new Runnable(){

                            @Override
                            public void run() {
                                RelatorioFluxoCaixaSemanalPrevisto.this.panelCentro.removeAll();
                                RelatorioFluxoCaixaSemanalPrevisto.this.panelCentro.repaint();
                                RelatorioFluxoCaixaSemanalPrevisto.this.habilitaBotaoImprimir(true);
                            }
                        });
                        HashMap<String, Object> var = new HashMap<String, Object>();
                        var.put(FILTRO_NIVEL, this.getFiltroCombo(FILTRO_NIVEL));
                        var.put(FILTRO_DATAS, this.getFiltroCombo(FILTRO_DATAS));
                        var.put(FILTRO_MES, this.getFiltroCombo(FILTRO_MES));
                        var.put(FILTRO_ANO, this.getFiltroTexto(FILTRO_ANO));
                        buf.delete(0, buf.length());
                        if (entidade != null) {
                            for (int i2 = 0; i2 < entidade.length; ++i2) {
                                buf.append(entidade[i2]);
                                if (i2 >= entidade.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put(FILTRO_ENTIDADE, buf.toString());
                        buf.delete(0, buf.length());
                        if (paciente != null) {
                            for (int i3 = 0; i3 < paciente.length; ++i3) {
                                buf.append(paciente[i3]);
                                if (i3 >= paciente.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put(FILTRO_PACIENTE, buf.toString());
                        buf.delete(0, buf.length());
                        if (convenio != null) {
                            for (int i4 = 0; i4 < convenio.length; ++i4) {
                                buf.append(convenio[i4]);
                                if (i4 >= convenio.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put(FILTRO_CONVENIO, buf.toString());
                        buf.delete(0, buf.length());
                        if (filiais != null) {
                            for (int i5 = 0; i5 < filiais.length; ++i5) {
                                buf.append(filiais[i5]);
                                if (i5 >= filiais.length - 1) continue;
                                buf.append(", ");
                            }
                        } else {
                            buf.append(Variaveis.filialPadrao);
                        }
                        var.put(FILTRO_FILIAL_CONTA, buf.toString());
                        buf.delete(0, buf.length());
                        if (usuario != null) {
                            for (int i6 = 0; i6 < usuario.length; ++i6) {
                                buf.append(usuario[i6]);
                                if (i6 >= usuario.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put(FILTRO_USUARIO, buf.toString());
                        buf.delete(0, buf.length());
                        if (origem != null) {
                            for (int i7 = 0; i7 < origem.length; ++i7) {
                                buf.append(origem[i7]);
                                if (i7 >= origem.length - 1) continue;
                                buf.append(", ");
                            }
                        }
                        var.put(FILTRO_ORIGEM, buf.toString());
                        gerador.executar(rs.getString("rel_xml"), (TableModel)modelo, var);
                        this.panelCentro.revalidate();
                    }
                    break block84;
                }
                Funcoes.mensagem(this, "N\u00e3o h\u00e1 dados para imprimir.", 2);
                this.habilitaBotaoImprimir(true);
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private int getIndicePlano(ArrayDados[] arr, int reduzidoPlano) {
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i].reduzidoPlano != reduzidoPlano) continue;
            return i;
        }
        return -1;
    }

    public static long getModuloAcesso(int tipoRelatorio) {
        if (tipoRelatorio == 0) {
            return Long.parseLong("0850809100");
        }
        if (tipoRelatorio == 1) {
            return Long.parseLong("0850909100");
        }
        return Long.parseLong("0850809100");
    }

    public long getConfigurarAcesso(int tipoRelatorio) {
        if (tipoRelatorio == 0) {
            return Long.parseLong("0850809101");
        }
        if (tipoRelatorio == 1) {
            return Long.parseLong("0850909101");
        }
        return Long.parseLong("0850809101");
    }

    class ArrayDados {
        protected int reduzidoPlano = -1;
        protected int paiPlano = -1;
        protected int nivelPlano = -1;
        protected float[] valoresPlano;
        protected float[] valoresPlanoComSinal;

        public ArrayDados(int reduzidoPlano, int paiPlano, int nivelPlano) {
            this.reduzidoPlano = reduzidoPlano;
            this.paiPlano = paiPlano;
            this.nivelPlano = nivelPlano;
            this.valoresPlano = new float[RelatorioFluxoCaixaSemanalPrevisto.this.QTDE_PERIODOS];
            this.valoresPlanoComSinal = new float[RelatorioFluxoCaixaSemanalPrevisto.this.QTDE_PERIODOS];
        }
    }
}

